/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "datacollector_main_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types datacollector_main_fi_types
 */

using namespace ::asf::stream::json;

namespace datacollector_main_fi_types {

bool T_e8_datacollector_UnitType_Parse (const char *str, size_t length, T_e8_datacollector_UnitType &value)
{
    static stringEntry entries[] = {
        {4,"NAVI", 1U},
        {4,"SWSC", 2U},
        {5,"AUDIO", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_UnitType_Name (T_e8_datacollector_UnitType value)
{
    static const char* enumerationLiterals[] = {
        "Audio",
        "Navi",
        "SWSC",
    };

    if (T_e8_datacollector_UnitType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_UnitType_IsValid (T_e8_datacollector_UnitType value)
{
    switch (value) {
    case T_e8_datacollector_UnitType__Audio:
    case T_e8_datacollector_UnitType__Navi:
    case T_e8_datacollector_UnitType__SWSC:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_ConfigurationStatus_Parse (const char *str, size_t length, T_e8_datacollector_ConfigurationStatus &value)
{
    static stringEntry entries[] = {
        {5,"VALID", 1U},
        {7,"INVALID", 2U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_ConfigurationStatus_Name (T_e8_datacollector_ConfigurationStatus value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Valid",
        "Invalid",
    };

    if (T_e8_datacollector_ConfigurationStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_ConfigurationStatus_IsValid (T_e8_datacollector_ConfigurationStatus value)
{
    switch (value) {
    case T_e8_datacollector_ConfigurationStatus__Undefined:
    case T_e8_datacollector_ConfigurationStatus__Valid:
    case T_e8_datacollector_ConfigurationStatus__Invalid:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_VersionInfo_Parse (const char *str, size_t length, T_e8_datacollector_VersionInfo &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {11,"HWSWVERSION", 3U},
        {15,"HARDWAREVERSION", 1U},
        {15,"SOFTWAREVERSION", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_VersionInfo_Name (T_e8_datacollector_VersionInfo value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "HardwareVersion",
        "SoftwareVersion",
        "HwSwVersion",
    };

    if (T_e8_datacollector_VersionInfo_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_VersionInfo_IsValid (T_e8_datacollector_VersionInfo value)
{
    switch (value) {
    case T_e8_datacollector_VersionInfo__Unknown:
    case T_e8_datacollector_VersionInfo__HardwareVersion:
    case T_e8_datacollector_VersionInfo__SoftwareVersion:
    case T_e8_datacollector_VersionInfo__HwSwVersion:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Language_Parse (const char *str, size_t length, T_e8_datacollector_Language &value)
{
    static stringEntry entries[] = {
        {4,"THAI", 51U},
        {5,"CZECH", 8U},
        {5,"DUTCH", 10U},
        {5,"GREEK", 24U},
        {5,"HINDI", 26U},
        {5,"MALAY", 34U},
        {6,"ARABIC", 2U},
        {6,"DANISH", 9U},
        {6,"FRENCH", 21U},
        {6,"GERMAN", 23U},
        {6,"HEBREW", 25U},
        {6,"KOREAN", 31U},
        {6,"POLISH", 38U},
        {6,"UNUSED", 254U},
        {7,"FINNISH", 19U},
        {7,"FLEMISH", 20U},
        {7,"ITALIAN", 29U},
        {7,"LATVIAN", 32U},
        {7,"RUSSIAN", 42U},
        {7,"SERBIAN", 43U},
        {7,"SPANISH", 46U},
        {7,"SWEDISH", 49U},
        {7,"TURKISH", 52U},
        {7,"UNKNOWN", 0U},
        {8,"ALBANESE", 1U},
        {8,"CROATIAN", 7U},
        {8,"ESTONIAN", 18U},
        {8,"JAPANESE", 30U},
        {8,"ROMANIAN", 41U},
        {9,"BULGARIAN", 3U},
        {9,"HUNGARIAN", 27U},
        {9,"NORWEGIAN", 35U},
        {9,"SLOVAKIAN", 44U},
        {9,"SLOVENIAN", 45U},
        {9,"TAIWANESE", 50U},
        {9,"UKRAINIAN", 53U},
        {10,"ENGLISH_UK", 12U},
        {10,"ENGLISH_US", 13U},
        {10,"INDONESIAN", 28U},
        {10,"LITHUANIAN", 33U},
        {10,"PORTUGUESE", 39U},
        {10,"VIETNAMESE", 54U},
        {11,"PHILIPPINES", 37U},
        {11,"UNSUPPORTED", 255U},
        {13,"ENGLISH_INDIA", 17U},
        {15,"FRENCH_CANADIAN", 22U},
        {15,"SPANISH_MEXICAN", 48U},
        {16,"ENGLISH_CANADIAN", 16U},
        {18,"ENGLISH_AUSTRALIAN", 11U},
        {18,"ENGLISH_US_FOR_JPN", 14U},
        {18,"ENGLISH_US_FOR_PRC", 15U},
        {20,"PORTUGUESE_BRAZILIAN", 40U},
        {21,"PERSIAN_FARSI_IRANIAN", 36U},
        {22,"SPANISH_LATIN_AMERICAN", 47U},
        {45,"CHINESE_MANDARIN_SIMPLIFIED_CHINESE_CHARACTER", 6U},
        {46,"CHINESE_CANTONESE_SIMPLIFIED_CHINESE_CHARACTER", 4U},
        {47,"CHINESE_CANTONESE_TRADITIONAL_CHINESE_CHARACTER", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 57, (unsigned int&) value);
}

const char* T_e8_datacollector_Language_Name (T_e8_datacollector_Language value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Albanese",
        "Arabic",
        "Bulgarian",
        "Chinese_Cantonese_Simplified_Chinese_character",
        "Chinese_Cantonese_Traditional_Chinese_character",
        "Chinese_Mandarin_Simplified_Chinese_character",
        "Croatian",
        "Czech",
        "Danish",
        "Dutch",
        "English_Australian",
        "English_UK",
        "English_US",
        "English_US_for_JPN",
        "English_US_for_PRC",
        "English_Canadian",
        "English_India",
        "Estonian",
        "Finnish",
        "Flemish",
        "French",
        "French_Canadian",
        "German",
        "Greek",
        "Hebrew",
        "Hindi",
        "Hungarian",
        "Indonesian",
        "Italian",
        "Japanese",
        "Korean",
        "Latvian",
        "Lithuanian",
        "Malay",
        "Norwegian",
        "Persian_Farsi_Iranian",
        "Philippines",
        "Polish",
        "Portuguese",
        "Portuguese_Brazilian",
        "Romanian",
        "Russian",
        "Serbian",
        "Slovakian",
        "Slovenian",
        "Spanish",
        "Spanish_Latin_American",
        "Spanish_Mexican",
        "Swedish",
        "Taiwanese",
        "Thai",
        "Turkish",
        "Ukrainian",
        "Vietnamese",
        "Unused",
        "UnSupported",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        14U,
        15U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        24U,
        25U,
        26U,
        27U,
        28U,
        29U,
        30U,
        31U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        254U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 57, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_Language_IsValid (T_e8_datacollector_Language value)
{
    switch (value) {
    case T_e8_datacollector_Language__Unknown:
    case T_e8_datacollector_Language__Albanese:
    case T_e8_datacollector_Language__Arabic:
    case T_e8_datacollector_Language__Bulgarian:
    case T_e8_datacollector_Language__Chinese_Cantonese_Simplified_Chinese_character:
    case T_e8_datacollector_Language__Chinese_Cantonese_Traditional_Chinese_character:
    case T_e8_datacollector_Language__Chinese_Mandarin_Simplified_Chinese_character:
    case T_e8_datacollector_Language__Croatian:
    case T_e8_datacollector_Language__Czech:
    case T_e8_datacollector_Language__Danish:
    case T_e8_datacollector_Language__Dutch:
    case T_e8_datacollector_Language__English_Australian:
    case T_e8_datacollector_Language__English_UK:
    case T_e8_datacollector_Language__English_US:
    case T_e8_datacollector_Language__English_US_for_JPN:
    case T_e8_datacollector_Language__English_US_for_PRC:
    case T_e8_datacollector_Language__English_Canadian:
    case T_e8_datacollector_Language__English_India:
    case T_e8_datacollector_Language__Estonian:
    case T_e8_datacollector_Language__Finnish:
    case T_e8_datacollector_Language__Flemish:
    case T_e8_datacollector_Language__French:
    case T_e8_datacollector_Language__French_Canadian:
    case T_e8_datacollector_Language__German:
    case T_e8_datacollector_Language__Greek:
    case T_e8_datacollector_Language__Hebrew:
    case T_e8_datacollector_Language__Hindi:
    case T_e8_datacollector_Language__Hungarian:
    case T_e8_datacollector_Language__Indonesian:
    case T_e8_datacollector_Language__Italian:
    case T_e8_datacollector_Language__Japanese:
    case T_e8_datacollector_Language__Korean:
    case T_e8_datacollector_Language__Latvian:
    case T_e8_datacollector_Language__Lithuanian:
    case T_e8_datacollector_Language__Malay:
    case T_e8_datacollector_Language__Norwegian:
    case T_e8_datacollector_Language__Persian_Farsi_Iranian:
    case T_e8_datacollector_Language__Philippines:
    case T_e8_datacollector_Language__Polish:
    case T_e8_datacollector_Language__Portuguese:
    case T_e8_datacollector_Language__Portuguese_Brazilian:
    case T_e8_datacollector_Language__Romanian:
    case T_e8_datacollector_Language__Russian:
    case T_e8_datacollector_Language__Serbian:
    case T_e8_datacollector_Language__Slovakian:
    case T_e8_datacollector_Language__Slovenian:
    case T_e8_datacollector_Language__Spanish:
    case T_e8_datacollector_Language__Spanish_Latin_American:
    case T_e8_datacollector_Language__Spanish_Mexican:
    case T_e8_datacollector_Language__Swedish:
    case T_e8_datacollector_Language__Taiwanese:
    case T_e8_datacollector_Language__Thai:
    case T_e8_datacollector_Language__Turkish:
    case T_e8_datacollector_Language__Ukrainian:
    case T_e8_datacollector_Language__Vietnamese:
    case T_e8_datacollector_Language__Unused:
    case T_e8_datacollector_Language__UnSupported:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Lang_Sync_Mode_Type_Parse (const char *str, size_t length, T_e8_datacollector_Lang_Sync_Mode_Type &value)
{
    static stringEntry entries[] = {
        {10,"ONEWAYSYNC", 1U},
        {10,"TWOWAYSYNC", 2U},
        {13,"NOT_AVAILABLE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Lang_Sync_Mode_Type_Name (T_e8_datacollector_Lang_Sync_Mode_Type value)
{
    static const char* enumerationLiterals[] = {
        "Not_Available",
        "OneWaySync",
        "TwoWaySync",
    };

    if (T_e8_datacollector_Lang_Sync_Mode_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Lang_Sync_Mode_Type_IsValid (T_e8_datacollector_Lang_Sync_Mode_Type value)
{
    switch (value) {
    case T_e8_datacollector_Lang_Sync_Mode_Type__Not_Available:
    case T_e8_datacollector_Lang_Sync_Mode_Type__OneWaySync:
    case T_e8_datacollector_Lang_Sync_Mode_Type__TwoWaySync:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Language_Status_Parse (const char *str, size_t length, T_e8_datacollector_Language_Status &value)
{
    static stringEntry entries[] = {
        {11,"UNAVAILABLE", 0U},
        {13,"AVAILABLE_SET", 2U},
        {15,"AVAILABLE_UNSET", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Language_Status_Name (T_e8_datacollector_Language_Status value)
{
    static const char* enumerationLiterals[] = {
        "Unavailable",
        "Available_Unset",
        "Available_Set",
    };

    if (T_e8_datacollector_Language_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Language_Status_IsValid (T_e8_datacollector_Language_Status value)
{
    switch (value) {
    case T_e8_datacollector_Language_Status__Unavailable:
    case T_e8_datacollector_Language_Status__Available_Unset:
    case T_e8_datacollector_Language_Status__Available_Set:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_RequestedLanguageResult_Parse (const char *str, size_t length, T_e8_datacollector_RequestedLanguageResult &value)
{
    static stringEntry entries[] = {
        {7,"CHANGED", 3U},
        {13,"UNCHANGEDAUTO", 2U},
        {16,"UNCHANGEDNOTAUTO", 1U},
        {17,"INVALID_PARAMETER", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_RequestedLanguageResult_Name (T_e8_datacollector_RequestedLanguageResult value)
{
    static const char* enumerationLiterals[] = {
        "Invalid_Parameter",
        "UnchangedNotAuto",
        "UnchangedAuto",
        "Changed",
    };

    if (T_e8_datacollector_RequestedLanguageResult_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_RequestedLanguageResult_IsValid (T_e8_datacollector_RequestedLanguageResult value)
{
    switch (value) {
    case T_e8_datacollector_RequestedLanguageResult__Invalid_Parameter:
    case T_e8_datacollector_RequestedLanguageResult__UnchangedNotAuto:
    case T_e8_datacollector_RequestedLanguageResult__UnchangedAuto:
    case T_e8_datacollector_RequestedLanguageResult__Changed:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_DistanceUnit_Parse (const char *str, size_t length, T_e8_datacollector_DistanceUnit &value)
{
    static stringEntry entries[] = {
        {1,"M", 1U},
        {2,"MI", 2U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_DistanceUnit_Name (T_e8_datacollector_DistanceUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "m",
        "mi",
    };

    if (T_e8_datacollector_DistanceUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_DistanceUnit_IsValid (T_e8_datacollector_DistanceUnit value)
{
    switch (value) {
    case T_e8_datacollector_DistanceUnit__Unknown:
    case T_e8_datacollector_DistanceUnit__m:
    case T_e8_datacollector_DistanceUnit__mi:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_FuelConsumptionUnit_Parse (const char *str, size_t length, T_e8_datacollector_FuelConsumptionUnit &value)
{
    static stringEntry entries[] = {
        {6,"UK_MPG", 4U},
        {6,"US_MPG", 3U},
        {7,"UNKNOWN", 0U},
        {8,"KM_PER_L", 1U},
        {11,"L_PER_100KM", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_FuelConsumptionUnit_Name (T_e8_datacollector_FuelConsumptionUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "km_per_l",
        "l_per_100km",
        "US_MPG",
        "UK_MPG",
    };

    if (T_e8_datacollector_FuelConsumptionUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_FuelConsumptionUnit_IsValid (T_e8_datacollector_FuelConsumptionUnit value)
{
    switch (value) {
    case T_e8_datacollector_FuelConsumptionUnit__Unknown:
    case T_e8_datacollector_FuelConsumptionUnit__km_per_l:
    case T_e8_datacollector_FuelConsumptionUnit__l_per_100km:
    case T_e8_datacollector_FuelConsumptionUnit__US_MPG:
    case T_e8_datacollector_FuelConsumptionUnit__UK_MPG:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_TemperatureUnit_Parse (const char *str, size_t length, T_e8_datacollector_TemperatureUnit &value)
{
    static stringEntry entries[] = {
        {5,"DEG_C", 1U},
        {5,"DEG_F", 2U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_TemperatureUnit_Name (T_e8_datacollector_TemperatureUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "deg_C",
        "deg_F",
    };

    if (T_e8_datacollector_TemperatureUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_TemperatureUnit_IsValid (T_e8_datacollector_TemperatureUnit value)
{
    switch (value) {
    case T_e8_datacollector_TemperatureUnit__Unknown:
    case T_e8_datacollector_TemperatureUnit__deg_C:
    case T_e8_datacollector_TemperatureUnit__deg_F:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_PressureUnit_Parse (const char *str, size_t length, T_e8_datacollector_PressureUnit &value)
{
    static stringEntry entries[] = {
        {3,"BAR", 3U},
        {3,"KPA", 1U},
        {3,"PSI", 2U},
        {7,"KGF_CM2", 4U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_PressureUnit_Name (T_e8_datacollector_PressureUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "kPa",
        "PSI",
        "bar",
        "kgf_cm2",
    };

    if (T_e8_datacollector_PressureUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_PressureUnit_IsValid (T_e8_datacollector_PressureUnit value)
{
    switch (value) {
    case T_e8_datacollector_PressureUnit__Unknown:
    case T_e8_datacollector_PressureUnit__kPa:
    case T_e8_datacollector_PressureUnit__PSI:
    case T_e8_datacollector_PressureUnit__bar:
    case T_e8_datacollector_PressureUnit__kgf_cm2:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_RadioSource_Parse (const char *str, size_t length, T_e8_datacollector_Audio_RadioSource &value)
{
    static stringEntry entries[] = {
        {2,"AM", 16U},
        {2,"FM", 1U},
        {3,"DAB", 80U},
        {3,"FM1", 2U},
        {3,"FM2", 3U},
        {3,"SXM", 35U},
        {3,"XM1", 32U},
        {3,"XM2", 33U},
        {3,"XM3", 34U},
        {4,"SXM1", 36U},
        {4,"SXM2", 37U},
        {4,"SXM3", 38U},
        {5,"AM_AP", 17U},
        {5,"FM_AP", 4U},
        {6,"FM_PTY", 50U},
        {6,"TA_JPN", 48U},
        {6,"TA_RDS", 49U},
        {7,"UNKNOWN", 0U},
        {9,"ALARM_RDS", 64U},
    };

    return lookupInStringEntryTable (str, length, entries, 19, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_RadioSource_Name (T_e8_datacollector_Audio_RadioSource value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "FM",
        "FM1",
        "FM2",
        "FM_AP",
        "AM",
        "AM_AP",
        "XM1",
        "XM2",
        "XM3",
        "SXM",
        "SXM1",
        "SXM2",
        "SXM3",
        "TA_JPN",
        "TA_RDS",
        "FM_PTY",
        "ALARM_RDS",
        "DAB",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        16U,
        17U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        48U,
        49U,
        50U,
        64U,
        80U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 19, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_Audio_RadioSource_IsValid (T_e8_datacollector_Audio_RadioSource value)
{
    switch (value) {
    case T_e8_datacollector_Audio_RadioSource__Unknown:
    case T_e8_datacollector_Audio_RadioSource__FM:
    case T_e8_datacollector_Audio_RadioSource__FM1:
    case T_e8_datacollector_Audio_RadioSource__FM2:
    case T_e8_datacollector_Audio_RadioSource__FM_AP:
    case T_e8_datacollector_Audio_RadioSource__AM:
    case T_e8_datacollector_Audio_RadioSource__AM_AP:
    case T_e8_datacollector_Audio_RadioSource__XM1:
    case T_e8_datacollector_Audio_RadioSource__XM2:
    case T_e8_datacollector_Audio_RadioSource__XM3:
    case T_e8_datacollector_Audio_RadioSource__SXM:
    case T_e8_datacollector_Audio_RadioSource__SXM1:
    case T_e8_datacollector_Audio_RadioSource__SXM2:
    case T_e8_datacollector_Audio_RadioSource__SXM3:
    case T_e8_datacollector_Audio_RadioSource__TA_JPN:
    case T_e8_datacollector_Audio_RadioSource__TA_RDS:
    case T_e8_datacollector_Audio_RadioSource__FM_PTY:
    case T_e8_datacollector_Audio_RadioSource__ALARM_RDS:
    case T_e8_datacollector_Audio_RadioSource__DAB:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_RadioLabelType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_RadioLabelType &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"PRESET", 1U},
        {7,"CHANNEL", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_RadioLabelType_Name (T_e8_datacollector_Audio_RadioLabelType value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Preset",
        "Channel",
    };

    if (T_e8_datacollector_Audio_RadioLabelType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_RadioLabelType_IsValid (T_e8_datacollector_Audio_RadioLabelType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_RadioLabelType__None:
    case T_e8_datacollector_Audio_RadioLabelType__Preset:
    case T_e8_datacollector_Audio_RadioLabelType__Channel:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_RadioFrequencyUnit_Parse (const char *str, size_t length, T_e8_datacollector_Audio_RadioFrequencyUnit &value)
{
    static stringEntry entries[] = {
        {2,"AM", 2U},
        {2,"CH", 6U},
        {2,"FM", 1U},
        {2,"XM", 3U},
        {3,"KHZ", 4U},
        {3,"MHZ", 5U},
        {4,"NONE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_RadioFrequencyUnit_Name (T_e8_datacollector_Audio_RadioFrequencyUnit value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "FM",
        "AM",
        "XM",
        "kHz",
        "MHz",
        "Ch",
    };

    if (T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid (T_e8_datacollector_Audio_RadioFrequencyUnit value)
{
    switch (value) {
    case T_e8_datacollector_Audio_RadioFrequencyUnit__None:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__FM:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__AM:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__XM:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__kHz:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__MHz:
    case T_e8_datacollector_Audio_RadioFrequencyUnit__Ch:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_RadioCategoryType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_RadioCategoryType &value)
{
    static stringEntry entries[] = {
        {3,"PTY", 2U},
        {4,"NONE", 0U},
        {8,"CATEGORY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_RadioCategoryType_Name (T_e8_datacollector_Audio_RadioCategoryType value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Category",
        "PTY",
    };

    if (T_e8_datacollector_Audio_RadioCategoryType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_RadioCategoryType_IsValid (T_e8_datacollector_Audio_RadioCategoryType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_RadioCategoryType__None:
    case T_e8_datacollector_Audio_RadioCategoryType__Category:
    case T_e8_datacollector_Audio_RadioCategoryType__PTY:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_MediaType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_MediaType &value)
{
    static stringEntry entries[] = {
        {2,"CD", 1U},
        {3,"DVD", 6U},
        {3,"USB", 4U},
        {4,"DISC", 8U},
        {4,"IPOD", 3U},
        {7,"PANDORA", 7U},
        {7,"UNKNOWN", 0U},
        {8,"BT_AUDIO", 5U},
        {9,"MUSIC_BOX", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_MediaType_Name (T_e8_datacollector_Audio_MediaType value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "CD",
        "Music_Box",
        "iPod",
        "USB",
        "BT_Audio",
        "DVD",
        "Pandora",
        "Disc",
    };

    if (T_e8_datacollector_Audio_MediaType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_MediaType_IsValid (T_e8_datacollector_Audio_MediaType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_MediaType__Unknown:
    case T_e8_datacollector_Audio_MediaType__CD:
    case T_e8_datacollector_Audio_MediaType__Music_Box:
    case T_e8_datacollector_Audio_MediaType__iPod:
    case T_e8_datacollector_Audio_MediaType__USB:
    case T_e8_datacollector_Audio_MediaType__BT_Audio:
    case T_e8_datacollector_Audio_MediaType__DVD:
    case T_e8_datacollector_Audio_MediaType__Pandora:
    case T_e8_datacollector_Audio_MediaType__Disc:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_TrackLabelType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_TrackLabelType &value)
{
    static stringEntry entries[] = {
        {4,"FILE", 3U},
        {4,"NONE", 0U},
        {5,"TRACK", 1U},
        {7,"CHAPTER", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_TrackLabelType_Name (T_e8_datacollector_Audio_TrackLabelType value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Track",
        "Chapter",
        "File",
    };

    if (T_e8_datacollector_Audio_TrackLabelType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_TrackLabelType_IsValid (T_e8_datacollector_Audio_TrackLabelType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_TrackLabelType__None:
    case T_e8_datacollector_Audio_TrackLabelType__Track:
    case T_e8_datacollector_Audio_TrackLabelType__Chapter:
    case T_e8_datacollector_Audio_TrackLabelType__File:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_GroupLabelType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_GroupLabelType &value)
{
    static stringEntry entries[] = {
        {4,"DISC", 1U},
        {4,"NONE", 0U},
        {5,"ALBUM", 2U},
        {5,"GROUP", 3U},
        {5,"TITLE", 5U},
        {6,"FOLDER", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_GroupLabelType_Name (T_e8_datacollector_Audio_GroupLabelType value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Disc",
        "Album",
        "Group",
        "Folder",
        "Title",
    };

    if (T_e8_datacollector_Audio_GroupLabelType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_GroupLabelType_IsValid (T_e8_datacollector_Audio_GroupLabelType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_GroupLabelType__None:
    case T_e8_datacollector_Audio_GroupLabelType__Disc:
    case T_e8_datacollector_Audio_GroupLabelType__Album:
    case T_e8_datacollector_Audio_GroupLabelType__Group:
    case T_e8_datacollector_Audio_GroupLabelType__Folder:
    case T_e8_datacollector_Audio_GroupLabelType__Title:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_ArtistLabelType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_ArtistLabelType &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"ARTIST", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_ArtistLabelType_Name (T_e8_datacollector_Audio_ArtistLabelType value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Artist",
    };

    if (T_e8_datacollector_Audio_ArtistLabelType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_ArtistLabelType_IsValid (T_e8_datacollector_Audio_ArtistLabelType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_ArtistLabelType__None:
    case T_e8_datacollector_Audio_ArtistLabelType__Artist:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_AuxType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_AuxType &value)
{
    static stringEntry entries[] = {
        {7,"PIN_AUX", 2U},
        {7,"UNKNOWN", 0U},
        {8,"VTR_JACK", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_AuxType_Name (T_e8_datacollector_Audio_AuxType value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "VTR_Jack",
        "Pin_Aux",
    };

    if (T_e8_datacollector_Audio_AuxType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_AuxType_IsValid (T_e8_datacollector_Audio_AuxType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_AuxType__Unknown:
    case T_e8_datacollector_Audio_AuxType__VTR_Jack:
    case T_e8_datacollector_Audio_AuxType__Pin_Aux:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_SourceInfoType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_SourceInfoType &value)
{
    static stringEntry entries[] = {
        {28,"T_DATACOLLECTOR_AUDIO_NODATA", 0U},
        {29,"T_DATACOLLECTOR_AUDIO_AUXDATA", 3U},
        {31,"T_DATACOLLECTOR_AUDIO_MEDIADATA", 2U},
        {31,"T_DATACOLLECTOR_AUDIO_RADIODATA", 1U},
        {39,"T_DATACOLLECTOR_AUDIO_EXTERNALSOUNDDATA", 4U},
        {39,"T_DATACOLLECTOR_AUDIO_INTERNETRADIODATA", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_SourceInfoType_Name (T_e8_datacollector_Audio_SourceInfoType value)
{
    static const char* enumerationLiterals[] = {
        "T_datacollector_Audio_NoData",
        "T_datacollector_Audio_RadioData",
        "T_datacollector_Audio_MediaData",
        "T_datacollector_Audio_AuxData",
        "T_datacollector_Audio_ExternalSoundData",
        "T_datacollector_Audio_InternetRadioData",
    };

    if (T_e8_datacollector_Audio_SourceInfoType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_SourceInfoType_IsValid (T_e8_datacollector_Audio_SourceInfoType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_NoData:
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_RadioData:
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_MediaData:
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_AuxData:
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_ExternalSoundData:
    case T_e8_datacollector_Audio_SourceInfoType__T_datacollector_Audio_InternetRadioData:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_Source_Parse (const char *str, size_t length, T_e8_datacollector_Audio_Source &value)
{
    static stringEntry entries[] = {
        {2,"AM", 5U},
        {2,"CD", 16U},
        {2,"FM", 1U},
        {2,"TV", 32U},
        {3,"DAB", 64U},
        {3,"DVD", 21U},
        {3,"FM1", 2U},
        {3,"FM2", 3U},
        {3,"SXM", 65U},
        {3,"TV1", 33U},
        {3,"TV2", 34U},
        {3,"USB", 19U},
        {3,"XM1", 7U},
        {3,"XM2", 8U},
        {3,"XM3", 9U},
        {4,"DISC", 23U},
        {4,"IPOD", 18U},
        {4,"NONE", 0U},
        {4,"SXM1", 66U},
        {4,"SXM2", 67U},
        {4,"SXM3", 68U},
        {5,"AM_AP", 6U},
        {5,"FM_AP", 4U},
        {6,"FM_PTY", 13U},
        {6,"TA_JPN", 10U},
        {6,"TA_RDS", 11U},
        {7,"CARPLAY", 69U},
        {7,"PANDORA", 22U},
        {7,"PIN_AUX", 49U},
        {8,"BT_AUDIO", 20U},
        {8,"VTR_JACK", 48U},
        {9,"ALARM_RDS", 12U},
        {9,"MUSIC_BOX", 17U},
        {12,"ANDROID_AUTO", 70U},
    };

    return lookupInStringEntryTable (str, length, entries, 34, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_Source_Name (T_e8_datacollector_Audio_Source value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "FM",
        "FM1",
        "FM2",
        "FM_AP",
        "AM",
        "AM_AP",
        "XM1",
        "XM2",
        "XM3",
        "TA_JPN",
        "TA_RDS",
        "ALARM_RDS",
        "FM_PTY",
        "CD",
        "Music_Box",
        "iPod",
        "USB",
        "BT_Audio",
        "DVD",
        "Pandora",
        "Disc",
        "TV",
        "TV1",
        "TV2",
        "VTR_Jack",
        "Pin_Aux",
        "DAB",
        "SXM",
        "SXM1",
        "SXM2",
        "SXM3",
        "CARPLAY",
        "ANDROID_AUTO",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        32U,
        33U,
        34U,
        48U,
        49U,
        64U,
        65U,
        66U,
        67U,
        68U,
        69U,
        70U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 34, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_Audio_Source_IsValid (T_e8_datacollector_Audio_Source value)
{
    switch (value) {
    case T_e8_datacollector_Audio_Source__None:
    case T_e8_datacollector_Audio_Source__FM:
    case T_e8_datacollector_Audio_Source__FM1:
    case T_e8_datacollector_Audio_Source__FM2:
    case T_e8_datacollector_Audio_Source__FM_AP:
    case T_e8_datacollector_Audio_Source__AM:
    case T_e8_datacollector_Audio_Source__AM_AP:
    case T_e8_datacollector_Audio_Source__XM1:
    case T_e8_datacollector_Audio_Source__XM2:
    case T_e8_datacollector_Audio_Source__XM3:
    case T_e8_datacollector_Audio_Source__TA_JPN:
    case T_e8_datacollector_Audio_Source__TA_RDS:
    case T_e8_datacollector_Audio_Source__ALARM_RDS:
    case T_e8_datacollector_Audio_Source__FM_PTY:
    case T_e8_datacollector_Audio_Source__CD:
    case T_e8_datacollector_Audio_Source__Music_Box:
    case T_e8_datacollector_Audio_Source__iPod:
    case T_e8_datacollector_Audio_Source__USB:
    case T_e8_datacollector_Audio_Source__BT_Audio:
    case T_e8_datacollector_Audio_Source__DVD:
    case T_e8_datacollector_Audio_Source__Pandora:
    case T_e8_datacollector_Audio_Source__Disc:
    case T_e8_datacollector_Audio_Source__TV:
    case T_e8_datacollector_Audio_Source__TV1:
    case T_e8_datacollector_Audio_Source__TV2:
    case T_e8_datacollector_Audio_Source__VTR_Jack:
    case T_e8_datacollector_Audio_Source__Pin_Aux:
    case T_e8_datacollector_Audio_Source__DAB:
    case T_e8_datacollector_Audio_Source__SXM:
    case T_e8_datacollector_Audio_Source__SXM1:
    case T_e8_datacollector_Audio_Source__SXM2:
    case T_e8_datacollector_Audio_Source__SXM3:
    case T_e8_datacollector_Audio_Source__CARPLAY:
    case T_e8_datacollector_Audio_Source__ANDROID_AUTO:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Interrupt_Type_Parse (const char *str, size_t length, T_e8_datacollector_Interrupt_Type &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 255U},
        {8,"AUDIO_ON", 66U},
        {8,"START_FF", 12U},
        {8,"START_RW", 13U},
        {9,"AUDIO_OFF", 65U},
        {9,"SEEK_STOP", 1U},
        {9,"TA_CANCEL", 64U},
        {10,"NEXT_TRACK", 2U},
        {10,"PREV_TRACK", 3U},
        {10,"SEEK_START", 0U},
        {10,"STOP_FF_RW", 16U},
        {13,"PRESET_STORED", 17U},
        {14,"DTV_CHANNEL_UP", 71U},
        {14,"FREQ_DECREMENT", 10U},
        {14,"FREQ_INCREMENT", 9U},
        {14,"SXM_CHANNEL_UP", 23U},
        {15,"FM_NEXT_STATION", 4U},
        {15,"FM_PREV_STATION", 5U},
        {15,"FREQ_DIRECT_SET", 11U},
        {16,"DTV_CHANNEL_DOWN", 72U},
        {16,"SXM_CHANNEL_DOWN", 32U},
        {17,"DAB_PRESET_CHANGE", 67U},
        {17,"SXM_PRESET_CHANGE", 33U},
        {17,"SXM_PRESET_STORED", 34U},
        {18,"FMAM_PRESET_CHANGE", 6U},
        {19,"DTV_CHANNEL_SEEK_UP", 69U},
        {19,"PLAY_SELECTED_TRACK", 18U},
        {19,"SXM_CHANNEL_SEEK_UP", 19U},
        {20,"FM_CHANNEL_FROM_LIST", 7U},
        {21,"DAB_CHANNEL_FROM_LIST", 8U},
        {21,"DTV_CHANNEL_SCROLL_UP", 73U},
        {21,"DTV_CHANNEL_SEEK_DOWN", 70U},
        {21,"SXM_CHANNEL_SEEK_DOWN", 20U},
        {21,"SXM_SCROLL_CHANNEL_UP", 21U},
        {23,"DTV_CHANNEL_SCROLL_DOWN", 74U},
        {23,"SXM_CHANNEL_FROM_CATLST", 49U},
        {23,"SXM_CHANNEL_FROM_CHNLST", 48U},
        {23,"SXM_SCROLL_CHANNEL_DOWN", 22U},
        {25,"DTV_CHANNEL_PRESET_CHANGE", 75U},
        {27,"ENTERTAINMENT_SOURCE_CHANGE", 68U},
    };

    return lookupInStringEntryTable (str, length, entries, 40, (unsigned int&) value);
}

const char* T_e8_datacollector_Interrupt_Type_Name (T_e8_datacollector_Interrupt_Type value)
{
    static const char* enumerationLiterals[] = {
        "Seek_Start",
        "Seek_Stop",
        "Next_Track",
        "Prev_Track",
        "FM_Next_Station",
        "FM_Prev_Station",
        "FMAM_Preset_Change",
        "FM_Channel_From_List",
        "DAB_Channel_From_List",
        "Freq_Increment",
        "Freq_Decrement",
        "Freq_Direct_Set",
        "Start_FF",
        "Start_RW",
        "Stop_FF_RW",
        "Preset_Stored",
        "Play_Selected_Track",
        "SXM_Channel_Seek_UP",
        "SXM_Channel_Seek_Down",
        "SXM_Scroll_Channel_UP",
        "SXM_Scroll_Channel_Down",
        "SXM_Channel_UP",
        "SXM_Channel_Down",
        "SXM_Preset_Change",
        "SXM_Preset_Stored",
        "SXM_Channel_from_Chnlst",
        "SXM_Channel_From_Catlst",
        "TA_Cancel",
        "Audio_OFF",
        "Audio_ON",
        "DAB_Preset_Change",
        "Entertainment_Source_Change",
        "DTV_Channel_Seek_Up",
        "DTV_Channel_Seek_Down",
        "DTV_Channel_Up",
        "DTV_Channel_Down",
        "DTV_Channel_Scroll_Up",
        "DTV_Channel_Scroll_Down",
        "DTV_Channel_Preset_Change",
        "NONE",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        5U,
        6U,
        7U,
        8U,
        9U,
        10U,
        11U,
        12U,
        13U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        23U,
        32U,
        33U,
        34U,
        48U,
        49U,
        64U,
        65U,
        66U,
        67U,
        68U,
        69U,
        70U,
        71U,
        72U,
        73U,
        74U,
        75U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 40, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_Interrupt_Type_IsValid (T_e8_datacollector_Interrupt_Type value)
{
    switch (value) {
    case T_e8_datacollector_Interrupt_Type__Seek_Start:
    case T_e8_datacollector_Interrupt_Type__Seek_Stop:
    case T_e8_datacollector_Interrupt_Type__Next_Track:
    case T_e8_datacollector_Interrupt_Type__Prev_Track:
    case T_e8_datacollector_Interrupt_Type__FM_Next_Station:
    case T_e8_datacollector_Interrupt_Type__FM_Prev_Station:
    case T_e8_datacollector_Interrupt_Type__FMAM_Preset_Change:
    case T_e8_datacollector_Interrupt_Type__FM_Channel_From_List:
    case T_e8_datacollector_Interrupt_Type__DAB_Channel_From_List:
    case T_e8_datacollector_Interrupt_Type__Freq_Increment:
    case T_e8_datacollector_Interrupt_Type__Freq_Decrement:
    case T_e8_datacollector_Interrupt_Type__Freq_Direct_Set:
    case T_e8_datacollector_Interrupt_Type__Start_FF:
    case T_e8_datacollector_Interrupt_Type__Start_RW:
    case T_e8_datacollector_Interrupt_Type__Stop_FF_RW:
    case T_e8_datacollector_Interrupt_Type__Preset_Stored:
    case T_e8_datacollector_Interrupt_Type__Play_Selected_Track:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_Seek_UP:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_Seek_Down:
    case T_e8_datacollector_Interrupt_Type__SXM_Scroll_Channel_UP:
    case T_e8_datacollector_Interrupt_Type__SXM_Scroll_Channel_Down:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_UP:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_Down:
    case T_e8_datacollector_Interrupt_Type__SXM_Preset_Change:
    case T_e8_datacollector_Interrupt_Type__SXM_Preset_Stored:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_from_Chnlst:
    case T_e8_datacollector_Interrupt_Type__SXM_Channel_From_Catlst:
    case T_e8_datacollector_Interrupt_Type__TA_Cancel:
    case T_e8_datacollector_Interrupt_Type__Audio_OFF:
    case T_e8_datacollector_Interrupt_Type__Audio_ON:
    case T_e8_datacollector_Interrupt_Type__DAB_Preset_Change:
    case T_e8_datacollector_Interrupt_Type__Entertainment_Source_Change:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Seek_Up:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Seek_Down:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Up:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Down:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Scroll_Up:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Scroll_Down:
    case T_e8_datacollector_Interrupt_Type__DTV_Channel_Preset_Change:
    case T_e8_datacollector_Interrupt_Type__NONE:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_WarningState_Parse (const char *str, size_t length, T_e8_datacollector_Audio_WarningState &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {6,"NO_USB", 44U},
        {7,"LOADING", 22U},
        {7,"NO_DISC", 32U},
        {7,"NO_SONG", 42U},
        {7,"OFF_AIR", 21U},
        {9,"AUDIO_OFF", 1U},
        {9,"NO_SIGNAL", 19U},
        {10,"NO_SERVICE", 50U},
        {10,"NO_STATION", 51U},
        {11,"OTHER_ERROR", 46U},
        {11,"PLEASE_WAIT", 47U},
        {12,"CHECK_DEVICE", 45U},
        {12,"LOADING_DISC", 33U},
        {12,"READING_DISC", 35U},
        {12,"READING_IPOD", 37U},
        {13,"CHECK_ANTENNA", 18U},
        {13,"EJECTING_DISC", 34U},
        {13,"EXTERNAL_TEXT", 255U},
        {13,"LIST_UPDATING", 17U},
        {13,"NO_AUDIO_FILE", 41U},
        {13,"NO_MORE_SKIPS", 52U},
        {14,"CH_UNAVAILABLE", 49U},
        {14,"EXTERNAL_SOUND", 2U},
        {14,"REGION_INVALID", 40U},
        {15,"AUTO_PRESETTING", 16U},
        {15,"CH_UNAUTHORIZED", 20U},
        {15,"DISC_READ_ERROR", 39U},
        {15,"UNPLAYABLE_FILE", 38U},
        {17,"PLEASE_EJECT_DISC", 48U},
        {18,"IPOD_NOT_CONNECTED", 43U},
        {18,"READING_USB_MEMORY", 36U},
        {19,"SERVICE_UNAVAILABLE", 54U},
        {24,"CHECK_DEVICE_FOR_PANDORA", 53U},
    };

    return lookupInStringEntryTable (str, length, entries, 34, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_WarningState_Name (T_e8_datacollector_Audio_WarningState value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Audio_Off",
        "External_Sound",
        "Auto_Presetting",
        "List_Updating",
        "Check_Antenna",
        "No_Signal",
        "Ch_Unauthorized",
        "Off_Air",
        "Loading",
        "No_Disc",
        "Loading_Disc",
        "Ejecting_Disc",
        "Reading_Disc",
        "Reading_USB_Memory",
        "Reading_IPod",
        "Unplayable_File",
        "Disc_Read_Error",
        "Region_Invalid",
        "No_Audio_File",
        "No_Song",
        "IPod_Not_Connected",
        "No_USB",
        "Check_Device",
        "Other_Error",
        "Please_Wait",
        "Please_Eject_Disc",
        "CH_Unavailable",
        "No_Service",
        "No_Station",
        "No_More_Skips",
        "Check_Device_For_Pandora",
        "Service_Unavailable",
        "External_Text",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        16U,
        17U,
        18U,
        19U,
        20U,
        21U,
        22U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        38U,
        39U,
        40U,
        41U,
        42U,
        43U,
        44U,
        45U,
        46U,
        47U,
        48U,
        49U,
        50U,
        51U,
        52U,
        53U,
        54U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 34, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_Audio_WarningState_IsValid (T_e8_datacollector_Audio_WarningState value)
{
    switch (value) {
    case T_e8_datacollector_Audio_WarningState__None:
    case T_e8_datacollector_Audio_WarningState__Audio_Off:
    case T_e8_datacollector_Audio_WarningState__External_Sound:
    case T_e8_datacollector_Audio_WarningState__Auto_Presetting:
    case T_e8_datacollector_Audio_WarningState__List_Updating:
    case T_e8_datacollector_Audio_WarningState__Check_Antenna:
    case T_e8_datacollector_Audio_WarningState__No_Signal:
    case T_e8_datacollector_Audio_WarningState__Ch_Unauthorized:
    case T_e8_datacollector_Audio_WarningState__Off_Air:
    case T_e8_datacollector_Audio_WarningState__Loading:
    case T_e8_datacollector_Audio_WarningState__No_Disc:
    case T_e8_datacollector_Audio_WarningState__Loading_Disc:
    case T_e8_datacollector_Audio_WarningState__Ejecting_Disc:
    case T_e8_datacollector_Audio_WarningState__Reading_Disc:
    case T_e8_datacollector_Audio_WarningState__Reading_USB_Memory:
    case T_e8_datacollector_Audio_WarningState__Reading_IPod:
    case T_e8_datacollector_Audio_WarningState__Unplayable_File:
    case T_e8_datacollector_Audio_WarningState__Disc_Read_Error:
    case T_e8_datacollector_Audio_WarningState__Region_Invalid:
    case T_e8_datacollector_Audio_WarningState__No_Audio_File:
    case T_e8_datacollector_Audio_WarningState__No_Song:
    case T_e8_datacollector_Audio_WarningState__IPod_Not_Connected:
    case T_e8_datacollector_Audio_WarningState__No_USB:
    case T_e8_datacollector_Audio_WarningState__Check_Device:
    case T_e8_datacollector_Audio_WarningState__Other_Error:
    case T_e8_datacollector_Audio_WarningState__Please_Wait:
    case T_e8_datacollector_Audio_WarningState__Please_Eject_Disc:
    case T_e8_datacollector_Audio_WarningState__CH_Unavailable:
    case T_e8_datacollector_Audio_WarningState__No_Service:
    case T_e8_datacollector_Audio_WarningState__No_Station:
    case T_e8_datacollector_Audio_WarningState__No_More_Skips:
    case T_e8_datacollector_Audio_WarningState__Check_Device_For_Pandora:
    case T_e8_datacollector_Audio_WarningState__Service_Unavailable:
    case T_e8_datacollector_Audio_WarningState__External_Text:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_SpecialMode_Parse (const char *str, size_t length, T_e8_datacollector_Audio_SpecialMode &value)
{
    static stringEntry entries[] = {
        {4,"NONE", 0U},
        {4,"SCAN", 1U},
        {6,"REWIND", 4U},
        {6,"SEARCH", 2U},
        {11,"FASTFORWARD", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_SpecialMode_Name (T_e8_datacollector_Audio_SpecialMode value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Scan",
        "Search",
        "FastForward",
        "Rewind",
    };

    if (T_e8_datacollector_Audio_SpecialMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_SpecialMode_IsValid (T_e8_datacollector_Audio_SpecialMode value)
{
    switch (value) {
    case T_e8_datacollector_Audio_SpecialMode__None:
    case T_e8_datacollector_Audio_SpecialMode__Scan:
    case T_e8_datacollector_Audio_SpecialMode__Search:
    case T_e8_datacollector_Audio_SpecialMode__FastForward:
    case T_e8_datacollector_Audio_SpecialMode__Rewind:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Audio_MediaElementType_Parse (const char *str, size_t length, T_e8_datacollector_Audio_MediaElementType &value)
{
    static stringEntry entries[] = {
        {5,"TRACK", 2U},
        {6,"FOLDER", 1U},
        {9,"UNDEFINED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_Audio_MediaElementType_Name (T_e8_datacollector_Audio_MediaElementType value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Folder",
        "Track",
    };

    if (T_e8_datacollector_Audio_MediaElementType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Audio_MediaElementType_IsValid (T_e8_datacollector_Audio_MediaElementType value)
{
    switch (value) {
    case T_e8_datacollector_Audio_MediaElementType__Undefined:
    case T_e8_datacollector_Audio_MediaElementType__Folder:
    case T_e8_datacollector_Audio_MediaElementType__Track:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_InputDevice_Parse (const char *str, size_t length, T_e8_datacollector_InputDevice &value)
{
    static stringEntry entries[] = {
        {9,"UNDEFINED", 0U},
        {18,"HEAD_UNIT_HARD_KEY", 1U},
        {24,"STEERING_WHEEL_KEY_EVENT", 3U},
        {25,"HEAD_UNIT_TOUCH_KEY_EVENT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_InputDevice_Name (T_e8_datacollector_InputDevice value)
{
    static const char* enumerationLiterals[] = {
        "Undefined",
        "Head_Unit_Hard_Key",
        "Head_Unit_Touch_Key_Event",
        "Steering_Wheel_Key_Event",
    };

    if (T_e8_datacollector_InputDevice_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_InputDevice_IsValid (T_e8_datacollector_InputDevice value)
{
    switch (value) {
    case T_e8_datacollector_InputDevice__Undefined:
    case T_e8_datacollector_InputDevice__Head_Unit_Hard_Key:
    case T_e8_datacollector_InputDevice__Head_Unit_Touch_Key_Event:
    case T_e8_datacollector_InputDevice__Steering_Wheel_Key_Event:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Current_Radio_Mode_Parse (const char *str, size_t length, T_e8_datacollector_Current_Radio_Mode &value)
{
    static stringEntry entries[] = {
        {4,"LIST", 0U},
        {6,"PRESET", 2U},
        {6,"UNUSED", 3U},
        {9,"FREQUENCY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_Current_Radio_Mode_Name (T_e8_datacollector_Current_Radio_Mode value)
{
    static const char* enumerationLiterals[] = {
        "List",
        "Frequency",
        "Preset",
        "Unused",
    };

    if (T_e8_datacollector_Current_Radio_Mode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Current_Radio_Mode_IsValid (T_e8_datacollector_Current_Radio_Mode value)
{
    switch (value) {
    case T_e8_datacollector_Current_Radio_Mode__List:
    case T_e8_datacollector_Current_Radio_Mode__Frequency:
    case T_e8_datacollector_Current_Radio_Mode__Preset:
    case T_e8_datacollector_Current_Radio_Mode__Unused:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_Renault_Update_List_Value_Parse (const char *str, size_t length, T_e8_datacollector_Renault_Update_List_Value &value)
{
    static stringEntry entries[] = {
        {15,"UPDATING_ACTIVE", 1U},
        {18,"UPDATING_NOTACTIVE", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_datacollector_Renault_Update_List_Value_Name (T_e8_datacollector_Renault_Update_List_Value value)
{
    static const char* enumerationLiterals[] = {
        "Updating_NotActive",
        "Updating_Active",
    };

    if (T_e8_datacollector_Renault_Update_List_Value_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_Renault_Update_List_Value_IsValid (T_e8_datacollector_Renault_Update_List_Value value)
{
    switch (value) {
    case T_e8_datacollector_Renault_Update_List_Value__Updating_NotActive:
    case T_e8_datacollector_Renault_Update_List_Value__Updating_Active:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_SWSC_KeyCode_Parse (const char *str, size_t length, T_e8_datacollector_SWSC_KeyCode &value)
{
    static stringEntry entries[] = {
        {2,"UP", 12U},
        {2,"VR", 4U},
        {3,"TEL", 5U},
        {4,"BACK", 3U},
        {4,"DOWN", 13U},
        {4,"LEFT", 15U},
        {4,"MUTE", 16U},
        {4,"NONE", 0U},
        {5,"ENTER", 2U},
        {5,"RIGHT", 14U},
        {5,"TELON", 6U},
        {5,"VOLUP", 10U},
        {6,"SOURCE", 1U},
        {6,"TELOFF", 7U},
        {7,"MENU_OK", 19U},
        {7,"MENU_UP", 17U},
        {7,"VOLDOWN", 11U},
        {8,"VR_TELON", 8U},
        {9,"MENU_DOWN", 18U},
        {13,"SOURCE_TELOFF", 9U},
    };

    return lookupInStringEntryTable (str, length, entries, 20, (unsigned int&) value);
}

const char* T_e8_datacollector_SWSC_KeyCode_Name (T_e8_datacollector_SWSC_KeyCode value)
{
    static const char* enumerationLiterals[] = {
        "None",
        "Source",
        "Enter",
        "Back",
        "VR",
        "Tel",
        "TelOn",
        "TelOff",
        "VR_TelOn",
        "Source_TelOff",
        "VolUp",
        "VolDown",
        "Up",
        "Down",
        "Right",
        "Left",
        "Mute",
        "Menu_Up",
        "Menu_Down",
        "Menu_Ok",
    };

    if (T_e8_datacollector_SWSC_KeyCode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_SWSC_KeyCode_IsValid (T_e8_datacollector_SWSC_KeyCode value)
{
    switch (value) {
    case T_e8_datacollector_SWSC_KeyCode__None:
    case T_e8_datacollector_SWSC_KeyCode__Source:
    case T_e8_datacollector_SWSC_KeyCode__Enter:
    case T_e8_datacollector_SWSC_KeyCode__Back:
    case T_e8_datacollector_SWSC_KeyCode__VR:
    case T_e8_datacollector_SWSC_KeyCode__Tel:
    case T_e8_datacollector_SWSC_KeyCode__TelOn:
    case T_e8_datacollector_SWSC_KeyCode__TelOff:
    case T_e8_datacollector_SWSC_KeyCode__VR_TelOn:
    case T_e8_datacollector_SWSC_KeyCode__Source_TelOff:
    case T_e8_datacollector_SWSC_KeyCode__VolUp:
    case T_e8_datacollector_SWSC_KeyCode__VolDown:
    case T_e8_datacollector_SWSC_KeyCode__Up:
    case T_e8_datacollector_SWSC_KeyCode__Down:
    case T_e8_datacollector_SWSC_KeyCode__Right:
    case T_e8_datacollector_SWSC_KeyCode__Left:
    case T_e8_datacollector_SWSC_KeyCode__Mute:
    case T_e8_datacollector_SWSC_KeyCode__Menu_Up:
    case T_e8_datacollector_SWSC_KeyCode__Menu_Down:
    case T_e8_datacollector_SWSC_KeyCode__Menu_Ok:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_VR_State_Parse (const char *str, size_t length, T_e8_datacollector_VR_State &value)
{
    static stringEntry entries[] = {
        {4,"IDLE", 0U},
        {9,"LISTENING", 1U},
        {10,"PROCESSING", 2U},
        {11,"MANUAL_MODE", 4U},
        {11,"SMS_SENDING", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_VR_State_Name (T_e8_datacollector_VR_State value)
{
    static const char* enumerationLiterals[] = {
        "Idle",
        "Listening",
        "Processing",
        "SMS_Sending",
        "Manual_Mode",
    };

    if (T_e8_datacollector_VR_State_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_VR_State_IsValid (T_e8_datacollector_VR_State value)
{
    switch (value) {
    case T_e8_datacollector_VR_State__Idle:
    case T_e8_datacollector_VR_State__Listening:
    case T_e8_datacollector_VR_State__Processing:
    case T_e8_datacollector_VR_State__SMS_Sending:
    case T_e8_datacollector_VR_State__Manual_Mode:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_PowerState_Parse (const char *str, size_t length, T_e8_datacollector_PowerState &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {8,"SHUTDOWN", 1U},
        {10,"IGNITIONON", 4U},
        {14,"USINGACCESSORY", 3U},
        {17,"PREPARETOSHUTDOWN", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_PowerState_Name (T_e8_datacollector_PowerState value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Shutdown",
        "PrepareToShutdown",
        "UsingAccessory",
        "IgnitionOn",
    };

    if (T_e8_datacollector_PowerState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_PowerState_IsValid (T_e8_datacollector_PowerState value)
{
    switch (value) {
    case T_e8_datacollector_PowerState__Unknown:
    case T_e8_datacollector_PowerState__Shutdown:
    case T_e8_datacollector_PowerState__PrepareToShutdown:
    case T_e8_datacollector_PowerState__UsingAccessory:
    case T_e8_datacollector_PowerState__IgnitionOn:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_TimeInfoType_Parse (const char *str, size_t length, T_e8_datacollector_TimeInfoType &value)
{
    static stringEntry entries[] = {
        {2,"AM", 2U},
        {2,"PM", 3U},
        {3,"24H", 1U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_TimeInfoType_Name (T_e8_datacollector_TimeInfoType value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "24h",
        "AM",
        "PM",
    };

    if (T_e8_datacollector_TimeInfoType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_TimeInfoType_IsValid (T_e8_datacollector_TimeInfoType value)
{
    switch (value) {
    case T_e8_datacollector_TimeInfoType__Unknown:
    case T_e8_datacollector_TimeInfoType__24h:
    case T_e8_datacollector_TimeInfoType__AM:
    case T_e8_datacollector_TimeInfoType__PM:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_CallStatus_Parse (const char *str, size_t length, T_e8_datacollector_CallStatus &value)
{
    static stringEntry entries[] = {
        {7,"ONGOING", 2U},
        {7,"UNKNOWN", 0U},
        {8,"CALLWAIT", 4U},
        {8,"INCOMING", 1U},
        {8,"OUTGOING", 3U},
        {9,"CALLENDED", 5U},
        {14,"THIRDPARTYCALL", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_datacollector_CallStatus_Name (T_e8_datacollector_CallStatus value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Incoming",
        "OnGoing",
        "OutGoing",
        "CallWait",
        "CallEnded",
        "ThirdPartyCall",
    };

    if (T_e8_datacollector_CallStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_CallStatus_IsValid (T_e8_datacollector_CallStatus value)
{
    switch (value) {
    case T_e8_datacollector_CallStatus__Unknown:
    case T_e8_datacollector_CallStatus__Incoming:
    case T_e8_datacollector_CallStatus__OnGoing:
    case T_e8_datacollector_CallStatus__OutGoing:
    case T_e8_datacollector_CallStatus__CallWait:
    case T_e8_datacollector_CallStatus__CallEnded:
    case T_e8_datacollector_CallStatus__ThirdPartyCall:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_PhoneBkDownloadState_Parse (const char *str, size_t length, T_e8_datacollector_PhoneBkDownloadState &value)
{
    static stringEntry entries[] = {
        {5,"ERROR", 255U},
        {8,"COMPLETE", 3U},
        {11,"NOT_STARTED", 0U},
        {12,"CONTACT_INFO", 1U},
        {13,"CONTACT_PHOTO", 2U},
        {13,"LIMIT_REACHED", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_datacollector_PhoneBkDownloadState_Name (T_e8_datacollector_PhoneBkDownloadState value)
{
    static const char* enumerationLiterals[] = {
        "NOT_STARTED",
        "CONTACT_INFO",
        "CONTACT_PHOTO",
        "COMPLETE",
        "LIMIT_REACHED",
        "ERROR",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        255U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_datacollector_PhoneBkDownloadState_IsValid (T_e8_datacollector_PhoneBkDownloadState value)
{
    switch (value) {
    case T_e8_datacollector_PhoneBkDownloadState__NOT_STARTED:
    case T_e8_datacollector_PhoneBkDownloadState__CONTACT_INFO:
    case T_e8_datacollector_PhoneBkDownloadState__CONTACT_PHOTO:
    case T_e8_datacollector_PhoneBkDownloadState__COMPLETE:
    case T_e8_datacollector_PhoneBkDownloadState__LIMIT_REACHED:
    case T_e8_datacollector_PhoneBkDownloadState__ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_HVACTemperatureUnit_Parse (const char *str, size_t length, T_e8_datacollector_HVACTemperatureUnit &value)
{
    static stringEntry entries[] = {
        {5,"DEG_C", 1U},
        {5,"DEG_F", 2U},
        {7,"UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_datacollector_HVACTemperatureUnit_Name (T_e8_datacollector_HVACTemperatureUnit value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Deg_c",
        "Deg_f",
    };

    if (T_e8_datacollector_HVACTemperatureUnit_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_HVACTemperatureUnit_IsValid (T_e8_datacollector_HVACTemperatureUnit value)
{
    switch (value) {
    case T_e8_datacollector_HVACTemperatureUnit__Unknown:
    case T_e8_datacollector_HVACTemperatureUnit__Deg_c:
    case T_e8_datacollector_HVACTemperatureUnit__Deg_f:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_CuurentRadioSource_Parse (const char *str, size_t length, T_e8_datacollector_CuurentRadioSource &value)
{
    static stringEntry entries[] = {
        {7,"UNKNOWN", 0U},
        {9,"SOURCE_AM", 2U},
        {9,"SOURCE_FM", 1U},
        {10,"SOURCE_DAB", 3U},
        {10,"SOURCE_SXM", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_datacollector_CuurentRadioSource_Name (T_e8_datacollector_CuurentRadioSource value)
{
    static const char* enumerationLiterals[] = {
        "Unknown",
        "Source_FM",
        "Source_AM",
        "Source_DAB",
        "Source_SXM",
    };

    if (T_e8_datacollector_CuurentRadioSource_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_CuurentRadioSource_IsValid (T_e8_datacollector_CuurentRadioSource value)
{
    switch (value) {
    case T_e8_datacollector_CuurentRadioSource__Unknown:
    case T_e8_datacollector_CuurentRadioSource__Source_FM:
    case T_e8_datacollector_CuurentRadioSource__Source_AM:
    case T_e8_datacollector_CuurentRadioSource__Source_DAB:
    case T_e8_datacollector_CuurentRadioSource__Source_SXM:
        return true;
    default:
        return false;
    }
}

bool T_e8_datacollector_SmsSendState_Parse (const char *str, size_t length, T_e8_datacollector_SmsSendState &value)
{
    static stringEntry entries[] = {
        {9,"INSENDING", 1U},
        {10,"SENDFAILED", 2U},
        {12,"NOTINSENDING", 0U},
        {14,"SENDSUCCESSFUL", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_datacollector_SmsSendState_Name (T_e8_datacollector_SmsSendState value)
{
    static const char* enumerationLiterals[] = {
        "NotInSending",
        "InSending",
        "SendFailed",
        "SendSuccessful",
    };

    if (T_e8_datacollector_SmsSendState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_datacollector_SmsSendState_IsValid (T_e8_datacollector_SmsSendState value)
{
    switch (value) {
    case T_e8_datacollector_SmsSendState__NotInSending:
    case T_e8_datacollector_SmsSendState__InSending:
    case T_e8_datacollector_SmsSendState__SendFailed:
    case T_e8_datacollector_SmsSendState__SendSuccessful:
        return true;
    default:
        return false;
    }
}

} // namespace datacollector_main_fi_types
