#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DATACOLLECTOR_MAIN_FI_TYPES_H
#define DATACOLLECTOR_MAIN_FI_TYPES_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "datacollector_main_fi_typesConst.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * Types datacollector_main_fi_types
 */

namespace datacollector_main_fi_types {

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class T_datacollector_VersionInfo;

class T_datacollector_UnitConnectionStatus;

class T_datacollector_UnitConfiguration;

class T_datacollector_UnitVersion;

class T_datacollector_UnitDataTransmissionStatus;

class T_datacollector_Audio_NoData;

class T_datacollector_Audio_RadioLabel;

class T_datacollector_Audio_RadioFrequency;

class T_datacollector_Audio_RadioCategory;

class T_datacollector_Audio_RadioData;

class T_datacollector_Audio_TrackInfo;

class T_datacollector_Audio_GroupInfo;

class T_datacollector_Audio_ArtistInfo;

class T_datacollector_Audio_MediaData;

class T_datacollector_Audio_AuxData;

class T_datacollector_Audio_ExternalSoundData;

class T_datacollector_Audio_InternetRadioData;

class T_datacollector_Audio_SourceInfoUnion;

class T_datacollector_TimeInfoUnion;

class T_datacollector_PhoneInfoUnion;

class T_datacollector_SMSInfoUnion;

class T_datacollector_HVACInfoUnion;

class T_datacollector_AudioInfoUnion;

class T_datacollector_DownloadInfoUnion;


/**
 * Record type containing version information.
 */
class T_datacollector_VersionInfo {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_VersionInfo ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_VersionInfo (const T_datacollector_VersionInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_VersionInfo();

    /**
     * Assignment operator
     */
    inline T_datacollector_VersionInfo& operator = (const T_datacollector_VersionInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_VersionInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_VersionInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_VersionInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_VersionInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Upper"

    static const int kU8Upper = 0;

    /**
     * Clears the field "u8Upper".
     *
     * The field will be set to its default value. The hasU8Upper()
     * method will return false.
     */
    inline void clearU8Upper();

    /**
     * Checks whether the field "u8Upper" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Upper()). Otherwise it will return false.
     */
    inline bool hasU8Upper () const;

    /**
     * Returns the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @return The value of the field "u8Upper"
     */
    inline uint8 getU8Upper () const;

    /**
     * Sets the value of the member "u8Upper".
     *
     * Upper (= Major) version number.
     *
     * @param u8Upper The value which will be set
     */
    inline void setU8Upper (uint8 u8Upper_);

    // API of field "u8Mid"

    static const int kU8Mid = 1;

    /**
     * Clears the field "u8Mid".
     *
     * The field will be set to its default value. The hasU8Mid()
     * method will return false.
     */
    inline void clearU8Mid();

    /**
     * Checks whether the field "u8Mid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Mid()). Otherwise it will return false.
     */
    inline bool hasU8Mid () const;

    /**
     * Returns the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @return The value of the field "u8Mid"
     */
    inline uint8 getU8Mid () const;

    /**
     * Sets the value of the member "u8Mid".
     *
     * Mid (= Minor) version number.
     *
     * @param u8Mid The value which will be set
     */
    inline void setU8Mid (uint8 u8Mid_);

    // API of field "u8Lower"

    static const int kU8Lower = 2;

    /**
     * Clears the field "u8Lower".
     *
     * The field will be set to its default value. The hasU8Lower()
     * method will return false.
     */
    inline void clearU8Lower();

    /**
     * Checks whether the field "u8Lower" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Lower()). Otherwise it will return false.
     */
    inline bool hasU8Lower () const;

    /**
     * Returns the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @return The value of the field "u8Lower"
     */
    inline uint8 getU8Lower () const;

    /**
     * Sets the value of the member "u8Lower".
     *
     * Lower (= Patch) version number.
     *
     * @param u8Lower The value which will be set
     */
    inline void setU8Lower (uint8 u8Lower_);

    static const T_datacollector_VersionInfo &getDefaultInstance();

private:

    inline void set_has_u8Upper ();

    inline void clear_has_u8Upper ();

    inline void set_has_u8Mid ();

    inline void clear_has_u8Mid ();

    inline void set_has_u8Lower ();

    inline void clear_has_u8Lower ();

    uint32 _has_bits_[ (3 + 31) / 32];

    uint8 _u8Upper;

    uint8 _u8Mid;

    uint8 _u8Lower;

};

/**
 * Record type containing the connection status of a MCAN unit.
 */
class T_datacollector_UnitConnectionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_UnitConnectionStatus ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_UnitConnectionStatus (const T_datacollector_UnitConnectionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_UnitConnectionStatus (T_e8_datacollector_UnitType e8UnitType_, bool bConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_UnitConnectionStatus();

    /**
     * Assignment operator
     */
    inline T_datacollector_UnitConnectionStatus& operator = (const T_datacollector_UnitConnectionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_UnitConnectionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_UnitConnectionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_UnitConnectionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_UnitConnectionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_datacollector_UnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_datacollector_UnitType e8UnitType_);

    // API of field "bConnected"

    static const int kBConnected = 1;

    /**
     * Clears the field "bConnected".
     *
     * The field will be set to its default value. The hasBConnected()
     * method will return false.
     */
    inline void clearBConnected();

    /**
     * Checks whether the field "bConnected" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBConnected()). Otherwise it will return false.
     */
    inline bool hasBConnected () const;

    /**
     * Returns the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @return The value of the field "bConnected"
     */
    inline bool getBConnected () const;

    /**
     * Sets the value of the member "bConnected".
     *
     * <p>FALSE: This MCAN unit is not connected.</p>
     * <p>TRUE: This MCAN unit is connected.</p>
     *
     * @param bConnected The value which will be set
     */
    inline void setBConnected (bool bConnected_);

    // API of field "u8AbsenceState"

    static const int kU8AbsenceState = 2;

    /**
     * Clears the field "u8AbsenceState".
     *
     * The field will be set to its default value. The hasU8AbsenceState()
     * method will return false.
     */
    inline void clearU8AbsenceState();

    /**
     * Checks whether the field "u8AbsenceState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8AbsenceState()). Otherwise it will return false.
     */
    inline bool hasU8AbsenceState () const;

    /**
     * Returns the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8AbsenceState"
     */
    inline uint8 getU8AbsenceState () const;

    /**
     * Sets the value of the member "u8AbsenceState".
     *
     * Indicates the absence of CMF (Channel Management Frames), i.e. CMFs were not received.
     * <p>0x00 = CMF not absent, i.e. connection is OK</p>
     * <p>0x80 = CMF currently absent, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed absent, i.e. connection confirmed NOK</p>
     * <p>0xFF = Absence detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8AbsenceState The value which will be set
     */
    inline void setU8AbsenceState (uint8 u8AbsenceState_);

    // API of field "u8MuteState"

    static const int kU8MuteState = 3;

    /**
     * Clears the field "u8MuteState".
     *
     * The field will be set to its default value. The hasU8MuteState()
     * method will return false.
     */
    inline void clearU8MuteState();

    /**
     * Checks whether the field "u8MuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MuteState()). Otherwise it will return false.
     */
    inline bool hasU8MuteState () const;

    /**
     * Returns the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8MuteState"
     */
    inline uint8 getU8MuteState () const;

    /**
     * Sets the value of the member "u8MuteState".
     *
     * Indicates a sending error (mute) of CMF, i.e. CMFs could not be sent.
     * <p>0x00 = CMF not muted, i.e. connection is OK</p>
     * <p>0x80 = CMF currently muted, i.e. connection currently NOK</p>
     * <p>0xC0 = CMF confirmed muted, i.e. connection confirmed NOK</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8MuteState The value which will be set
     */
    inline void setU8MuteState (uint8 u8MuteState_);

    static const T_datacollector_UnitConnectionStatus &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_bConnected ();

    inline void clear_has_bConnected ();

    inline void set_has_u8AbsenceState ();

    inline void clear_has_u8AbsenceState ();

    inline void set_has_u8MuteState ();

    inline void clear_has_u8MuteState ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_datacollector_UnitType _e8UnitType;

    bool _bConnected;

    uint8 _u8AbsenceState;

    uint8 _u8MuteState;

};

/**
 * Record type containing configuration info of a MCAN unit.
 */
class T_datacollector_UnitConfiguration {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_UnitConfiguration ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_UnitConfiguration (const T_datacollector_UnitConfiguration &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_UnitConfiguration (T_e8_datacollector_UnitType e8UnitType_, T_e8_datacollector_ConfigurationStatus e8ConfigurationStatus_, uint8 u8UnitId_, const T_datacollector_VersionInfo& rMessageVersion_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_UnitConfiguration();

    /**
     * Assignment operator
     */
    inline T_datacollector_UnitConfiguration& operator = (const T_datacollector_UnitConfiguration& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_UnitConfiguration& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_UnitConfiguration& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_UnitConfiguration& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_UnitConfiguration& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_datacollector_UnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_datacollector_UnitType e8UnitType_);

    // API of field "e8ConfigurationStatus"

    static const int kE8ConfigurationStatus = 1;

    /**
     * Clears the field "e8ConfigurationStatus".
     *
     * The field will be set to its default value. The hasE8ConfigurationStatus()
     * method will return false.
     */
    inline void clearE8ConfigurationStatus();

    /**
     * Checks whether the field "e8ConfigurationStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8ConfigurationStatus()). Otherwise it will return false.
     */
    inline bool hasE8ConfigurationStatus () const;

    /**
     * Returns the value of the member "e8ConfigurationStatus".
     *
     * Status of the configuration (undefined, valid, invalid).
     *
     * @return The value of the field "e8ConfigurationStatus"
     */
    inline T_e8_datacollector_ConfigurationStatus getE8ConfigurationStatus () const;

    /**
     * Sets the value of the member "e8ConfigurationStatus".
     *
     * Status of the configuration (undefined, valid, invalid).
     *
     * @param e8ConfigurationStatus The value which will be set
     */
    inline void setE8ConfigurationStatus (T_e8_datacollector_ConfigurationStatus e8ConfigurationStatus_);

    // API of field "u8UnitId"

    static const int kU8UnitId = 2;

    /**
     * Clears the field "u8UnitId".
     *
     * The field will be set to its default value. The hasU8UnitId()
     * method will return false.
     */
    inline void clearU8UnitId();

    /**
     * Checks whether the field "u8UnitId" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8UnitId()). Otherwise it will return false.
     */
    inline bool hasU8UnitId () const;

    /**
     * Returns the value of the member "u8UnitId".
     *
     * Identifier defining which kind of unit is connected.
     *
     * @return The value of the field "u8UnitId"
     */
    inline uint8 getU8UnitId () const;

    /**
     * Sets the value of the member "u8UnitId".
     *
     * Identifier defining which kind of unit is connected.
     *
     * @param u8UnitId The value which will be set
     */
    inline void setU8UnitId (uint8 u8UnitId_);

    // API of field "rMessageVersion"

    static const int kRMessageVersion = 3;

    /**
     * Clears the field "rMessageVersion".
     *
     * The field will be set to its default value. The hasRMessageVersion()
     * method will return false.
     */
    inline void clearRMessageVersion();

    /**
     * Checks whether the field "rMessageVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRMessageVersion()). Otherwise it will return false.
     */
    inline bool hasRMessageVersion () const;

    /**
     * Returns the value of the member "rMessageVersion".
     *
     * Record with information about the version number of message set specfication.
     *
     * @return The value of the field "rMessageVersion"
     */
    inline const T_datacollector_VersionInfo& getRMessageVersion () const;

    /**
     * Retrieves the value of the field "rMessageVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rMessageVersion".
     */
    inline T_datacollector_VersionInfo& getRMessageVersionMutable ();

    /**
     * Sets the value of the member "rMessageVersion".
     *
     * Record with information about the version number of message set specfication.
     *
     * @param rMessageVersion The value which will be set
     */
    inline void setRMessageVersion (const T_datacollector_VersionInfo& rMessageVersion_);

    static const T_datacollector_UnitConfiguration &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_e8ConfigurationStatus ();

    inline void clear_has_e8ConfigurationStatus ();

    inline void set_has_u8UnitId ();

    inline void clear_has_u8UnitId ();

    inline void set_has_rMessageVersion ();

    inline void clear_has_rMessageVersion ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_datacollector_UnitType _e8UnitType;

    T_e8_datacollector_ConfigurationStatus _e8ConfigurationStatus;

    uint8 _u8UnitId;

    T_datacollector_VersionInfo _rMessageVersion;

};

/**
 * Record type containing the version info of a MCAN unit.
 */
class T_datacollector_UnitVersion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_UnitVersion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_UnitVersion (const T_datacollector_UnitVersion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_UnitVersion (T_e8_datacollector_UnitType e8UnitType_, const T_datacollector_VersionInfo& rVersion_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_UnitVersion();

    /**
     * Assignment operator
     */
    inline T_datacollector_UnitVersion& operator = (const T_datacollector_UnitVersion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_UnitVersion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_UnitVersion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_UnitVersion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_UnitVersion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_datacollector_UnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_datacollector_UnitType e8UnitType_);

    // API of field "rVersion"

    static const int kRVersion = 1;

    /**
     * Clears the field "rVersion".
     *
     * The field will be set to its default value. The hasRVersion()
     * method will return false.
     */
    inline void clearRVersion();

    /**
     * Checks whether the field "rVersion" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRVersion()). Otherwise it will return false.
     */
    inline bool hasRVersion () const;

    /**
     * Returns the value of the member "rVersion".
     *
     * Record with information about the version.
     *
     * @return The value of the field "rVersion"
     */
    inline const T_datacollector_VersionInfo& getRVersion () const;

    /**
     * Retrieves the value of the field "rVersion" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rVersion".
     */
    inline T_datacollector_VersionInfo& getRVersionMutable ();

    /**
     * Sets the value of the member "rVersion".
     *
     * Record with information about the version.
     *
     * @param rVersion The value which will be set
     */
    inline void setRVersion (const T_datacollector_VersionInfo& rVersion_);

    static const T_datacollector_UnitVersion &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_rVersion ();

    inline void clear_has_rVersion ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_datacollector_UnitType _e8UnitType;

    T_datacollector_VersionInfo _rVersion;

};

/**
 * Record type containing the data transmission status of a MCAN unit.
 */
class T_datacollector_UnitDataTransmissionStatus {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_UnitDataTransmissionStatus ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_UnitDataTransmissionStatus (const T_datacollector_UnitDataTransmissionStatus &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_UnitDataTransmissionStatus (T_e8_datacollector_UnitType e8UnitType_, uint8 u8MPDTMuteState_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_UnitDataTransmissionStatus();

    /**
     * Assignment operator
     */
    inline T_datacollector_UnitDataTransmissionStatus& operator = (const T_datacollector_UnitDataTransmissionStatus& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_UnitDataTransmissionStatus& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_UnitDataTransmissionStatus& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_UnitDataTransmissionStatus& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_UnitDataTransmissionStatus& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8UnitType"

    static const int kE8UnitType = 0;

    /**
     * Clears the field "e8UnitType".
     *
     * The field will be set to its default value. The hasE8UnitType()
     * method will return false.
     */
    inline void clearE8UnitType();

    /**
     * Checks whether the field "e8UnitType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8UnitType()). Otherwise it will return false.
     */
    inline bool hasE8UnitType () const;

    /**
     * Returns the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @return The value of the field "e8UnitType"
     */
    inline T_e8_datacollector_UnitType getE8UnitType () const;

    /**
     * Sets the value of the member "e8UnitType".
     *
     * Type of the unit.
     *
     * @param e8UnitType The value which will be set
     */
    inline void setE8UnitType (T_e8_datacollector_UnitType e8UnitType_);

    // API of field "u8MPDTMuteState"

    static const int kU8MPDTMuteState = 1;

    /**
     * Clears the field "u8MPDTMuteState".
     *
     * The field will be set to its default value. The hasU8MPDTMuteState()
     * method will return false.
     */
    inline void clearU8MPDTMuteState();

    /**
     * Checks whether the field "u8MPDTMuteState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8MPDTMuteState()). Otherwise it will return false.
     */
    inline bool hasU8MPDTMuteState () const;

    /**
     * Returns the value of the member "u8MPDTMuteState".
     *
     * Indicates a sending error (mute) of an MPDT message, i.e. sending was not successful.
     * <p>0x00 = MPDT not muted, i.e. sending of MPDT message were successful</p>
     * <p>0x80 = MPDT currently muted, i.e. sending of MPDT message were currently not successful</p>
     * <p>0xC0 = MPDT confirmed muted, i.e. sending of MPDT message were confirmed not successful</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @return The value of the field "u8MPDTMuteState"
     */
    inline uint8 getU8MPDTMuteState () const;

    /**
     * Sets the value of the member "u8MPDTMuteState".
     *
     * Indicates a sending error (mute) of an MPDT message, i.e. sending was not successful.
     * <p>0x00 = MPDT not muted, i.e. sending of MPDT message were successful</p>
     * <p>0x80 = MPDT currently muted, i.e. sending of MPDT message were currently not successful</p>
     * <p>0xC0 = MPDT confirmed muted, i.e. sending of MPDT message were confirmed not successful</p>
     * <p>0xFF = Mute detection is masked, i.e. diagnosis not active</p>
     *
     * @param u8MPDTMuteState The value which will be set
     */
    inline void setU8MPDTMuteState (uint8 u8MPDTMuteState_);

    static const T_datacollector_UnitDataTransmissionStatus &getDefaultInstance();

private:

    inline void set_has_e8UnitType ();

    inline void clear_has_e8UnitType ();

    inline void set_has_u8MPDTMuteState ();

    inline void clear_has_u8MPDTMuteState ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_datacollector_UnitType _e8UnitType;

    uint8 _u8MPDTMuteState;

};

/**
 * This type indicates that no data is available. It's used for unions.
 */
class T_datacollector_Audio_NoData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_NoData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_NoData (const T_datacollector_Audio_NoData &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_NoData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_NoData& operator = (const T_datacollector_Audio_NoData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_NoData& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_NoData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_NoData& ) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_NoData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const T_datacollector_Audio_NoData &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * Record type used for the label information of the current radio station.
 */
class T_datacollector_Audio_RadioLabel {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_RadioLabel ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_RadioLabel (const T_datacollector_Audio_RadioLabel &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_RadioLabel (T_e8_datacollector_Audio_RadioLabelType e8Type_, uint8 u8Id_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_RadioLabel();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_RadioLabel& operator = (const T_datacollector_Audio_RadioLabel& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_RadioLabel& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_RadioLabel& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_RadioLabel& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_RadioLabel& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the following label: preset or channel.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_datacollector_Audio_RadioLabelType getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the following label: preset or channel.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_datacollector_Audio_RadioLabelType e8Type_);

    // API of field "u8Id"

    static const int kU8Id = 1;

    /**
     * Clears the field "u8Id".
     *
     * The field will be set to its default value. The hasU8Id()
     * method will return false.
     */
    inline void clearU8Id();

    /**
     * Checks whether the field "u8Id" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Id()). Otherwise it will return false.
     */
    inline bool hasU8Id () const;

    /**
     * Returns the value of the member "u8Id".
     *
     * Id of the label, e.g. preset/channel number of the current radio station.
     *
     * @return The value of the field "u8Id"
     */
    inline uint8 getU8Id () const;

    /**
     * Sets the value of the member "u8Id".
     *
     * Id of the label, e.g. preset/channel number of the current radio station.
     *
     * @param u8Id The value which will be set
     */
    inline void setU8Id (uint8 u8Id_);

    static const T_datacollector_Audio_RadioLabel &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_u8Id ();

    inline void clear_has_u8Id ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_datacollector_Audio_RadioLabelType _e8Type;

    uint8 _u8Id;

};

/**
 * Record type used for the frequency of the current radio station.
 */
class T_datacollector_Audio_RadioFrequency {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_RadioFrequency ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_RadioFrequency (const T_datacollector_Audio_RadioFrequency &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_RadioFrequency (uint8 u8Thousands_, uint8 u8Hundreds_, uint8 u8Tens_, uint8 u8Ones_, bool bShowDecimalPoint_, uint8 u8Tenths_, uint8 u8Hundredths_, T_e8_datacollector_Audio_RadioFrequencyUnit e8Unit_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_RadioFrequency();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_RadioFrequency& operator = (const T_datacollector_Audio_RadioFrequency& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_RadioFrequency& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_RadioFrequency& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_RadioFrequency& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_RadioFrequency& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "u8Thousands"

    static const int kU8Thousands = 0;

    /**
     * Clears the field "u8Thousands".
     *
     * The field will be set to its default value. The hasU8Thousands()
     * method will return false.
     */
    inline void clearU8Thousands();

    /**
     * Checks whether the field "u8Thousands" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Thousands()). Otherwise it will return false.
     */
    inline bool hasU8Thousands () const;

    /**
     * Returns the value of the member "u8Thousands".
     *
     * Value of the thousends digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Thousands"
     */
    inline uint8 getU8Thousands () const;

    /**
     * Sets the value of the member "u8Thousands".
     *
     * Value of the thousends digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Thousands The value which will be set
     */
    inline void setU8Thousands (uint8 u8Thousands_);

    // API of field "u8Hundreds"

    static const int kU8Hundreds = 1;

    /**
     * Clears the field "u8Hundreds".
     *
     * The field will be set to its default value. The hasU8Hundreds()
     * method will return false.
     */
    inline void clearU8Hundreds();

    /**
     * Checks whether the field "u8Hundreds" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hundreds()). Otherwise it will return false.
     */
    inline bool hasU8Hundreds () const;

    /**
     * Returns the value of the member "u8Hundreds".
     *
     * Value of the hundreds digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Hundreds"
     */
    inline uint8 getU8Hundreds () const;

    /**
     * Sets the value of the member "u8Hundreds".
     *
     * Value of the hundreds digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Hundreds The value which will be set
     */
    inline void setU8Hundreds (uint8 u8Hundreds_);

    // API of field "u8Tens"

    static const int kU8Tens = 2;

    /**
     * Clears the field "u8Tens".
     *
     * The field will be set to its default value. The hasU8Tens()
     * method will return false.
     */
    inline void clearU8Tens();

    /**
     * Checks whether the field "u8Tens" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Tens()). Otherwise it will return false.
     */
    inline bool hasU8Tens () const;

    /**
     * Returns the value of the member "u8Tens".
     *
     * Value of the tens digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Tens"
     */
    inline uint8 getU8Tens () const;

    /**
     * Sets the value of the member "u8Tens".
     *
     * Value of the tens digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Tens The value which will be set
     */
    inline void setU8Tens (uint8 u8Tens_);

    // API of field "u8Ones"

    static const int kU8Ones = 3;

    /**
     * Clears the field "u8Ones".
     *
     * The field will be set to its default value. The hasU8Ones()
     * method will return false.
     */
    inline void clearU8Ones();

    /**
     * Checks whether the field "u8Ones" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Ones()). Otherwise it will return false.
     */
    inline bool hasU8Ones () const;

    /**
     * Returns the value of the member "u8Ones".
     *
     * Value of the ones(units) digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Ones"
     */
    inline uint8 getU8Ones () const;

    /**
     * Sets the value of the member "u8Ones".
     *
     * Value of the ones(units) digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Ones The value which will be set
     */
    inline void setU8Ones (uint8 u8Ones_);

    // API of field "bShowDecimalPoint"

    static const int kBShowDecimalPoint = 4;

    /**
     * Clears the field "bShowDecimalPoint".
     *
     * The field will be set to its default value. The hasBShowDecimalPoint()
     * method will return false.
     */
    inline void clearBShowDecimalPoint();

    /**
     * Checks whether the field "bShowDecimalPoint" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBShowDecimalPoint()). Otherwise it will return false.
     */
    inline bool hasBShowDecimalPoint () const;

    /**
     * Returns the value of the member "bShowDecimalPoint".
     *
     * <p>FALSE: Don't use the decimal point.</p>
     * <p>TRUE: Use the decimal point.</p>
     *
     * @return The value of the field "bShowDecimalPoint"
     */
    inline bool getBShowDecimalPoint () const;

    /**
     * Sets the value of the member "bShowDecimalPoint".
     *
     * <p>FALSE: Don't use the decimal point.</p>
     * <p>TRUE: Use the decimal point.</p>
     *
     * @param bShowDecimalPoint The value which will be set
     */
    inline void setBShowDecimalPoint (bool bShowDecimalPoint_);

    // API of field "u8Tenths"

    static const int kU8Tenths = 5;

    /**
     * Clears the field "u8Tenths".
     *
     * The field will be set to its default value. The hasU8Tenths()
     * method will return false.
     */
    inline void clearU8Tenths();

    /**
     * Checks whether the field "u8Tenths" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Tenths()). Otherwise it will return false.
     */
    inline bool hasU8Tenths () const;

    /**
     * Returns the value of the member "u8Tenths".
     *
     * Value of the tenths digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Tenths"
     */
    inline uint8 getU8Tenths () const;

    /**
     * Sets the value of the member "u8Tenths".
     *
     * Value of the tenths digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Tenths The value which will be set
     */
    inline void setU8Tenths (uint8 u8Tenths_);

    // API of field "u8Hundredths"

    static const int kU8Hundredths = 6;

    /**
     * Clears the field "u8Hundredths".
     *
     * The field will be set to its default value. The hasU8Hundredths()
     * method will return false.
     */
    inline void clearU8Hundredths();

    /**
     * Checks whether the field "u8Hundredths" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU8Hundredths()). Otherwise it will return false.
     */
    inline bool hasU8Hundredths () const;

    /**
     * Returns the value of the member "u8Hundredths".
     *
     * Value of the hundredths digit. Use 0x0F if it shall not be displayed.
     *
     * @return The value of the field "u8Hundredths"
     */
    inline uint8 getU8Hundredths () const;

    /**
     * Sets the value of the member "u8Hundredths".
     *
     * Value of the hundredths digit. Use 0x0F if it shall not be displayed.
     *
     * @param u8Hundredths The value which will be set
     */
    inline void setU8Hundredths (uint8 u8Hundredths_);

    // API of field "e8Unit"

    static const int kE8Unit = 7;

    /**
     * Clears the field "e8Unit".
     *
     * The field will be set to its default value. The hasE8Unit()
     * method will return false.
     */
    inline void clearE8Unit();

    /**
     * Checks whether the field "e8Unit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Unit()). Otherwise it will return false.
     */
    inline bool hasE8Unit () const;

    /**
     * Returns the value of the member "e8Unit".
     *
     * Unit of the radio frequency, e.g. kHz or MHz.
     *
     * @return The value of the field "e8Unit"
     */
    inline T_e8_datacollector_Audio_RadioFrequencyUnit getE8Unit () const;

    /**
     * Sets the value of the member "e8Unit".
     *
     * Unit of the radio frequency, e.g. kHz or MHz.
     *
     * @param e8Unit The value which will be set
     */
    inline void setE8Unit (T_e8_datacollector_Audio_RadioFrequencyUnit e8Unit_);

    static const T_datacollector_Audio_RadioFrequency &getDefaultInstance();

private:

    inline void set_has_u8Thousands ();

    inline void clear_has_u8Thousands ();

    inline void set_has_u8Hundreds ();

    inline void clear_has_u8Hundreds ();

    inline void set_has_u8Tens ();

    inline void clear_has_u8Tens ();

    inline void set_has_u8Ones ();

    inline void clear_has_u8Ones ();

    inline void set_has_bShowDecimalPoint ();

    inline void clear_has_bShowDecimalPoint ();

    inline void set_has_u8Tenths ();

    inline void clear_has_u8Tenths ();

    inline void set_has_u8Hundredths ();

    inline void clear_has_u8Hundredths ();

    inline void set_has_e8Unit ();

    inline void clear_has_e8Unit ();

    uint32 _has_bits_[ (8 + 31) / 32];

    uint8 _u8Thousands;

    uint8 _u8Hundreds;

    uint8 _u8Tens;

    uint8 _u8Ones;

    bool _bShowDecimalPoint;

    uint8 _u8Tenths;

    uint8 _u8Hundredths;

    T_e8_datacollector_Audio_RadioFrequencyUnit _e8Unit;

};

/**
 * Record type used for the category of the current radio station.
 */
class T_datacollector_Audio_RadioCategory {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_RadioCategory ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_RadioCategory (const T_datacollector_Audio_RadioCategory &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_RadioCategory (T_e8_datacollector_Audio_RadioCategoryType e8Type_, const ::std::string& strCategoryName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_RadioCategory();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_RadioCategory& operator = (const T_datacollector_Audio_RadioCategory& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_RadioCategory& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_RadioCategory& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_RadioCategory& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_RadioCategory& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8Type"

    static const int kE8Type = 0;

    /**
     * Clears the field "e8Type".
     *
     * The field will be set to its default value. The hasE8Type()
     * method will return false.
     */
    inline void clearE8Type();

    /**
     * Checks whether the field "e8Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8Type()). Otherwise it will return false.
     */
    inline bool hasE8Type () const;

    /**
     * Returns the value of the member "e8Type".
     *
     * Type of the category: Category or PTY.
     *
     * @return The value of the field "e8Type"
     */
    inline T_e8_datacollector_Audio_RadioCategoryType getE8Type () const;

    /**
     * Sets the value of the member "e8Type".
     *
     * Type of the category: Category or PTY.
     *
     * @param e8Type The value which will be set
     */
    inline void setE8Type (T_e8_datacollector_Audio_RadioCategoryType e8Type_);

    // API of field "strCategoryName"

    static const int kStrCategoryName = 1;

    /**
     * Clears the field "strCategoryName".
     *
     * The field will be set to its default value. The hasStrCategoryName()
     * method will return false.
     */
    inline void clearStrCategoryName();

    /**
     * Checks whether the field "strCategoryName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrCategoryName()). Otherwise it will return false.
     */
    inline bool hasStrCategoryName () const;

    /**
     * Returns the value of the member "strCategoryName".
     *
     * Text string containing the name of the category.
     *
     * @return The value of the field "strCategoryName"
     */
    inline const ::std::string& getStrCategoryName () const;

    /**
     * Retrieves the value of the field "strCategoryName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strCategoryName".
     */
    inline ::std::string& getStrCategoryNameMutable ();

    /**
     * Sets the value of the member "strCategoryName".
     *
     * Text string containing the name of the category.
     *
     * @param strCategoryName The value which will be set
     */
    inline void setStrCategoryName (const ::std::string& strCategoryName_);

    /**
     * Sets the value of the member "strCategoryName".
     *
     * Text string containing the name of the category.
     *
     * @param strCategoryName The value which will be set
     */
    inline void setStrCategoryName (const char* strCategoryName_);

    /**
     * Sets the value of the member "strCategoryName".
     *
     * Text string containing the name of the category.
     *
     * @param strCategoryName The value which will be set
     */
    inline void setStrCategoryName (const char* value, size_t size);

    static const T_datacollector_Audio_RadioCategory &getDefaultInstance();

private:

    inline void set_has_e8Type ();

    inline void clear_has_e8Type ();

    inline void set_has_strCategoryName ();

    inline void clear_has_strCategoryName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_datacollector_Audio_RadioCategoryType _e8Type;

    ::std::string _strCategoryName;

};

/**
 * <p>Record type used for the data of the audio source Radio.</p>
 * <p>Information about the current channel can either be transmitted within the
 * structure rLabel using the corresponding label type or within the structure rFrequency
 * using the corresponding frequency unit.</p>
 * <p>For XM rFrequency shall have the channel information.</p>
 */
class T_datacollector_Audio_RadioData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_RadioData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_RadioData (const T_datacollector_Audio_RadioData &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_RadioData (T_e8_datacollector_Audio_RadioSource e8RadioSource_, const T_datacollector_Audio_RadioLabel& rLabel_, const T_datacollector_Audio_RadioFrequency& rFrequency_, const T_datacollector_Audio_RadioCategory& rCategory_, const ::std::string& strStationName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_RadioData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_RadioData& operator = (const T_datacollector_Audio_RadioData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_RadioData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_RadioData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_RadioData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_RadioData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8RadioSource"

    static const int kE8RadioSource = 0;

    /**
     * Clears the field "e8RadioSource".
     *
     * The field will be set to its default value. The hasE8RadioSource()
     * method will return false.
     */
    inline void clearE8RadioSource();

    /**
     * Checks whether the field "e8RadioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8RadioSource()). Otherwise it will return false.
     */
    inline bool hasE8RadioSource () const;

    /**
     * Returns the value of the member "e8RadioSource".
     *
     * Current radio source, e.g. FM, AM.
     *
     * @return The value of the field "e8RadioSource"
     */
    inline T_e8_datacollector_Audio_RadioSource getE8RadioSource () const;

    /**
     * Sets the value of the member "e8RadioSource".
     *
     * Current radio source, e.g. FM, AM.
     *
     * @param e8RadioSource The value which will be set
     */
    inline void setE8RadioSource (T_e8_datacollector_Audio_RadioSource e8RadioSource_);

    // API of field "rLabel"

    static const int kRLabel = 1;

    /**
     * Clears the field "rLabel".
     *
     * The field will be set to its default value. The hasRLabel()
     * method will return false.
     */
    inline void clearRLabel();

    /**
     * Checks whether the field "rLabel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRLabel()). Otherwise it will return false.
     */
    inline bool hasRLabel () const;

    /**
     * Returns the value of the member "rLabel".
     *
     * Label information of the current radio station, e.g. "Preset 5" or "Channel 3".
     *
     * @return The value of the field "rLabel"
     */
    inline const T_datacollector_Audio_RadioLabel& getRLabel () const;

    /**
     * Retrieves the value of the field "rLabel" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rLabel".
     */
    inline T_datacollector_Audio_RadioLabel& getRLabelMutable ();

    /**
     * Sets the value of the member "rLabel".
     *
     * Label information of the current radio station, e.g. "Preset 5" or "Channel 3".
     *
     * @param rLabel The value which will be set
     */
    inline void setRLabel (const T_datacollector_Audio_RadioLabel& rLabel_);

    // API of field "rFrequency"

    static const int kRFrequency = 2;

    /**
     * Clears the field "rFrequency".
     *
     * The field will be set to its default value. The hasRFrequency()
     * method will return false.
     */
    inline void clearRFrequency();

    /**
     * Checks whether the field "rFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRFrequency()). Otherwise it will return false.
     */
    inline bool hasRFrequency () const;

    /**
     * Returns the value of the member "rFrequency".
     *
     * Information about the frequency of the current radio station.
     *
     * @return The value of the field "rFrequency"
     */
    inline const T_datacollector_Audio_RadioFrequency& getRFrequency () const;

    /**
     * Retrieves the value of the field "rFrequency" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rFrequency".
     */
    inline T_datacollector_Audio_RadioFrequency& getRFrequencyMutable ();

    /**
     * Sets the value of the member "rFrequency".
     *
     * Information about the frequency of the current radio station.
     *
     * @param rFrequency The value which will be set
     */
    inline void setRFrequency (const T_datacollector_Audio_RadioFrequency& rFrequency_);

    // API of field "rCategory"

    static const int kRCategory = 3;

    /**
     * Clears the field "rCategory".
     *
     * The field will be set to its default value. The hasRCategory()
     * method will return false.
     */
    inline void clearRCategory();

    /**
     * Checks whether the field "rCategory" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRCategory()). Otherwise it will return false.
     */
    inline bool hasRCategory () const;

    /**
     * Returns the value of the member "rCategory".
     *
     * Information about the category of the current radio station.
     *
     * @return The value of the field "rCategory"
     */
    inline const T_datacollector_Audio_RadioCategory& getRCategory () const;

    /**
     * Retrieves the value of the field "rCategory" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rCategory".
     */
    inline T_datacollector_Audio_RadioCategory& getRCategoryMutable ();

    /**
     * Sets the value of the member "rCategory".
     *
     * Information about the category of the current radio station.
     *
     * @param rCategory The value which will be set
     */
    inline void setRCategory (const T_datacollector_Audio_RadioCategory& rCategory_);

    // API of field "strStationName"

    static const int kStrStationName = 4;

    /**
     * Clears the field "strStationName".
     *
     * The field will be set to its default value. The hasStrStationName()
     * method will return false.
     */
    inline void clearStrStationName();

    /**
     * Checks whether the field "strStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrStationName()). Otherwise it will return false.
     */
    inline bool hasStrStationName () const;

    /**
     * Returns the value of the member "strStationName".
     *
     * Text string containing the RDS station name.
     *
     * @return The value of the field "strStationName"
     */
    inline const ::std::string& getStrStationName () const;

    /**
     * Retrieves the value of the field "strStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strStationName".
     */
    inline ::std::string& getStrStationNameMutable ();

    /**
     * Sets the value of the member "strStationName".
     *
     * Text string containing the RDS station name.
     *
     * @param strStationName The value which will be set
     */
    inline void setStrStationName (const ::std::string& strStationName_);

    /**
     * Sets the value of the member "strStationName".
     *
     * Text string containing the RDS station name.
     *
     * @param strStationName The value which will be set
     */
    inline void setStrStationName (const char* strStationName_);

    /**
     * Sets the value of the member "strStationName".
     *
     * Text string containing the RDS station name.
     *
     * @param strStationName The value which will be set
     */
    inline void setStrStationName (const char* value, size_t size);

    static const T_datacollector_Audio_RadioData &getDefaultInstance();

private:

    inline void set_has_e8RadioSource ();

    inline void clear_has_e8RadioSource ();

    inline void set_has_rLabel ();

    inline void clear_has_rLabel ();

    inline void set_has_rFrequency ();

    inline void clear_has_rFrequency ();

    inline void set_has_rCategory ();

    inline void clear_has_rCategory ();

    inline void set_has_strStationName ();

    inline void clear_has_strStationName ();

    uint32 _has_bits_[ (5 + 31) / 32];

    T_e8_datacollector_Audio_RadioSource _e8RadioSource;

    T_datacollector_Audio_RadioLabel _rLabel;

    T_datacollector_Audio_RadioFrequency _rFrequency;

    T_datacollector_Audio_RadioCategory _rCategory;

    ::std::string _strStationName;

};

/**
 * Record type used for information about the track.
 */
class T_datacollector_Audio_TrackInfo {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_TrackInfo ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_TrackInfo (const T_datacollector_Audio_TrackInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_TrackInfo (T_e8_datacollector_Audio_TrackLabelType e8LabelType_, uint32 u32TrackNumber_, const ::std::string& strTrackName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_TrackInfo();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_TrackInfo& operator = (const T_datacollector_Audio_TrackInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_TrackInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_TrackInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_TrackInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_TrackInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LabelType"

    static const int kE8LabelType = 0;

    /**
     * Clears the field "e8LabelType".
     *
     * The field will be set to its default value. The hasE8LabelType()
     * method will return false.
     */
    inline void clearE8LabelType();

    /**
     * Checks whether the field "e8LabelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LabelType()). Otherwise it will return false.
     */
    inline bool hasE8LabelType () const;

    /**
     * Returns the value of the member "e8LabelType".
     *
     * Label used for the track information.
     *
     * @return The value of the field "e8LabelType"
     */
    inline T_e8_datacollector_Audio_TrackLabelType getE8LabelType () const;

    /**
     * Sets the value of the member "e8LabelType".
     *
     * Label used for the track information.
     *
     * @param e8LabelType The value which will be set
     */
    inline void setE8LabelType (T_e8_datacollector_Audio_TrackLabelType e8LabelType_);

    // API of field "u32TrackNumber"

    static const int kU32TrackNumber = 1;

    /**
     * Clears the field "u32TrackNumber".
     *
     * The field will be set to its default value. The hasU32TrackNumber()
     * method will return false.
     */
    inline void clearU32TrackNumber();

    /**
     * Checks whether the field "u32TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU32TrackNumber()). Otherwise it will return false.
     */
    inline bool hasU32TrackNumber () const;

    /**
     * Returns the value of the member "u32TrackNumber".
     *
     * Number of the track (0..99999).
     *
     * @return The value of the field "u32TrackNumber"
     */
    inline uint32 getU32TrackNumber () const;

    /**
     * Sets the value of the member "u32TrackNumber".
     *
     * Number of the track (0..99999).
     *
     * @param u32TrackNumber The value which will be set
     */
    inline void setU32TrackNumber (uint32 u32TrackNumber_);

    // API of field "strTrackName"

    static const int kStrTrackName = 2;

    /**
     * Clears the field "strTrackName".
     *
     * The field will be set to its default value. The hasStrTrackName()
     * method will return false.
     */
    inline void clearStrTrackName();

    /**
     * Checks whether the field "strTrackName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrTrackName()). Otherwise it will return false.
     */
    inline bool hasStrTrackName () const;

    /**
     * Returns the value of the member "strTrackName".
     *
     * Text string containing the name of the track.
     *
     * @return The value of the field "strTrackName"
     */
    inline const ::std::string& getStrTrackName () const;

    /**
     * Retrieves the value of the field "strTrackName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strTrackName".
     */
    inline ::std::string& getStrTrackNameMutable ();

    /**
     * Sets the value of the member "strTrackName".
     *
     * Text string containing the name of the track.
     *
     * @param strTrackName The value which will be set
     */
    inline void setStrTrackName (const ::std::string& strTrackName_);

    /**
     * Sets the value of the member "strTrackName".
     *
     * Text string containing the name of the track.
     *
     * @param strTrackName The value which will be set
     */
    inline void setStrTrackName (const char* strTrackName_);

    /**
     * Sets the value of the member "strTrackName".
     *
     * Text string containing the name of the track.
     *
     * @param strTrackName The value which will be set
     */
    inline void setStrTrackName (const char* value, size_t size);

    static const T_datacollector_Audio_TrackInfo &getDefaultInstance();

private:

    inline void set_has_e8LabelType ();

    inline void clear_has_e8LabelType ();

    inline void set_has_u32TrackNumber ();

    inline void clear_has_u32TrackNumber ();

    inline void set_has_strTrackName ();

    inline void clear_has_strTrackName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_datacollector_Audio_TrackLabelType _e8LabelType;

    uint32 _u32TrackNumber;

    ::std::string _strTrackName;

};

/**
 * Record type used for information about the group.
 */
class T_datacollector_Audio_GroupInfo {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_GroupInfo ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_GroupInfo (const T_datacollector_Audio_GroupInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_GroupInfo (T_e8_datacollector_Audio_GroupLabelType e8LabelType_, uint16 u16GroupNumber_, const ::std::string& strGroupName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_GroupInfo();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_GroupInfo& operator = (const T_datacollector_Audio_GroupInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_GroupInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_GroupInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_GroupInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_GroupInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LabelType"

    static const int kE8LabelType = 0;

    /**
     * Clears the field "e8LabelType".
     *
     * The field will be set to its default value. The hasE8LabelType()
     * method will return false.
     */
    inline void clearE8LabelType();

    /**
     * Checks whether the field "e8LabelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LabelType()). Otherwise it will return false.
     */
    inline bool hasE8LabelType () const;

    /**
     * Returns the value of the member "e8LabelType".
     *
     * Label used for the group information.
     *
     * @return The value of the field "e8LabelType"
     */
    inline T_e8_datacollector_Audio_GroupLabelType getE8LabelType () const;

    /**
     * Sets the value of the member "e8LabelType".
     *
     * Label used for the group information.
     *
     * @param e8LabelType The value which will be set
     */
    inline void setE8LabelType (T_e8_datacollector_Audio_GroupLabelType e8LabelType_);

    // API of field "u16GroupNumber"

    static const int kU16GroupNumber = 1;

    /**
     * Clears the field "u16GroupNumber".
     *
     * The field will be set to its default value. The hasU16GroupNumber()
     * method will return false.
     */
    inline void clearU16GroupNumber();

    /**
     * Checks whether the field "u16GroupNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setU16GroupNumber()). Otherwise it will return false.
     */
    inline bool hasU16GroupNumber () const;

    /**
     * Returns the value of the member "u16GroupNumber".
     *
     * Number of the group (0..9999).
     *
     * @return The value of the field "u16GroupNumber"
     */
    inline uint16 getU16GroupNumber () const;

    /**
     * Sets the value of the member "u16GroupNumber".
     *
     * Number of the group (0..9999).
     *
     * @param u16GroupNumber The value which will be set
     */
    inline void setU16GroupNumber (uint16 u16GroupNumber_);

    // API of field "strGroupName"

    static const int kStrGroupName = 2;

    /**
     * Clears the field "strGroupName".
     *
     * The field will be set to its default value. The hasStrGroupName()
     * method will return false.
     */
    inline void clearStrGroupName();

    /**
     * Checks whether the field "strGroupName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrGroupName()). Otherwise it will return false.
     */
    inline bool hasStrGroupName () const;

    /**
     * Returns the value of the member "strGroupName".
     *
     * Text string containing the group name.
     *
     * @return The value of the field "strGroupName"
     */
    inline const ::std::string& getStrGroupName () const;

    /**
     * Retrieves the value of the field "strGroupName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strGroupName".
     */
    inline ::std::string& getStrGroupNameMutable ();

    /**
     * Sets the value of the member "strGroupName".
     *
     * Text string containing the group name.
     *
     * @param strGroupName The value which will be set
     */
    inline void setStrGroupName (const ::std::string& strGroupName_);

    /**
     * Sets the value of the member "strGroupName".
     *
     * Text string containing the group name.
     *
     * @param strGroupName The value which will be set
     */
    inline void setStrGroupName (const char* strGroupName_);

    /**
     * Sets the value of the member "strGroupName".
     *
     * Text string containing the group name.
     *
     * @param strGroupName The value which will be set
     */
    inline void setStrGroupName (const char* value, size_t size);

    static const T_datacollector_Audio_GroupInfo &getDefaultInstance();

private:

    inline void set_has_e8LabelType ();

    inline void clear_has_e8LabelType ();

    inline void set_has_u16GroupNumber ();

    inline void clear_has_u16GroupNumber ();

    inline void set_has_strGroupName ();

    inline void clear_has_strGroupName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_datacollector_Audio_GroupLabelType _e8LabelType;

    uint16 _u16GroupNumber;

    ::std::string _strGroupName;

};

/**
 * Record type used for information about the artist.
 */
class T_datacollector_Audio_ArtistInfo {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_ArtistInfo ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_ArtistInfo (const T_datacollector_Audio_ArtistInfo &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_ArtistInfo (T_e8_datacollector_Audio_ArtistLabelType e8LabelType_, const ::std::string& strArtistName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_ArtistInfo();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_ArtistInfo& operator = (const T_datacollector_Audio_ArtistInfo& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_ArtistInfo& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_ArtistInfo& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_ArtistInfo& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_ArtistInfo& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8LabelType"

    static const int kE8LabelType = 0;

    /**
     * Clears the field "e8LabelType".
     *
     * The field will be set to its default value. The hasE8LabelType()
     * method will return false.
     */
    inline void clearE8LabelType();

    /**
     * Checks whether the field "e8LabelType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8LabelType()). Otherwise it will return false.
     */
    inline bool hasE8LabelType () const;

    /**
     * Returns the value of the member "e8LabelType".
     *
     * Label used for the information.
     *
     * @return The value of the field "e8LabelType"
     */
    inline T_e8_datacollector_Audio_ArtistLabelType getE8LabelType () const;

    /**
     * Sets the value of the member "e8LabelType".
     *
     * Label used for the information.
     *
     * @param e8LabelType The value which will be set
     */
    inline void setE8LabelType (T_e8_datacollector_Audio_ArtistLabelType e8LabelType_);

    // API of field "strArtistName"

    static const int kStrArtistName = 1;

    /**
     * Clears the field "strArtistName".
     *
     * The field will be set to its default value. The hasStrArtistName()
     * method will return false.
     */
    inline void clearStrArtistName();

    /**
     * Checks whether the field "strArtistName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrArtistName()). Otherwise it will return false.
     */
    inline bool hasStrArtistName () const;

    /**
     * Returns the value of the member "strArtistName".
     *
     * Text string containing the name of the artist.
     *
     * @return The value of the field "strArtistName"
     */
    inline const ::std::string& getStrArtistName () const;

    /**
     * Retrieves the value of the field "strArtistName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strArtistName".
     */
    inline ::std::string& getStrArtistNameMutable ();

    /**
     * Sets the value of the member "strArtistName".
     *
     * Text string containing the name of the artist.
     *
     * @param strArtistName The value which will be set
     */
    inline void setStrArtistName (const ::std::string& strArtistName_);

    /**
     * Sets the value of the member "strArtistName".
     *
     * Text string containing the name of the artist.
     *
     * @param strArtistName The value which will be set
     */
    inline void setStrArtistName (const char* strArtistName_);

    /**
     * Sets the value of the member "strArtistName".
     *
     * Text string containing the name of the artist.
     *
     * @param strArtistName The value which will be set
     */
    inline void setStrArtistName (const char* value, size_t size);

    static const T_datacollector_Audio_ArtistInfo &getDefaultInstance();

private:

    inline void set_has_e8LabelType ();

    inline void clear_has_e8LabelType ();

    inline void set_has_strArtistName ();

    inline void clear_has_strArtistName ();

    uint32 _has_bits_[ (2 + 31) / 32];

    T_e8_datacollector_Audio_ArtistLabelType _e8LabelType;

    ::std::string _strArtistName;

};

/**
 * <p>Record type used for the data of the audio source Media.</p>
 * <p>How the information have to be filled into the three info records is specified in the
 * corresponding specification of the meter:</p>
 * <p>https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-379496/Meter_Combi_Function_Spec_ver3.90.xls</p>
 */
class T_datacollector_Audio_MediaData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_MediaData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_MediaData (const T_datacollector_Audio_MediaData &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_MediaData (T_e8_datacollector_Audio_MediaType e8MediaType_, const T_datacollector_Audio_TrackInfo& rTrackInfo_, const T_datacollector_Audio_GroupInfo& rGroupInfo_, const T_datacollector_Audio_ArtistInfo& rArtistInfo_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_MediaData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_MediaData& operator = (const T_datacollector_Audio_MediaData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_MediaData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_MediaData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_MediaData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_MediaData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8MediaType"

    static const int kE8MediaType = 0;

    /**
     * Clears the field "e8MediaType".
     *
     * The field will be set to its default value. The hasE8MediaType()
     * method will return false.
     */
    inline void clearE8MediaType();

    /**
     * Checks whether the field "e8MediaType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8MediaType()). Otherwise it will return false.
     */
    inline bool hasE8MediaType () const;

    /**
     * Returns the value of the member "e8MediaType".
     *
     * Type of the current media, e.g. CD, USB.
     *
     * @return The value of the field "e8MediaType"
     */
    inline T_e8_datacollector_Audio_MediaType getE8MediaType () const;

    /**
     * Sets the value of the member "e8MediaType".
     *
     * Type of the current media, e.g. CD, USB.
     *
     * @param e8MediaType The value which will be set
     */
    inline void setE8MediaType (T_e8_datacollector_Audio_MediaType e8MediaType_);

    // API of field "rTrackInfo"

    static const int kRTrackInfo = 1;

    /**
     * Clears the field "rTrackInfo".
     *
     * The field will be set to its default value. The hasRTrackInfo()
     * method will return false.
     */
    inline void clearRTrackInfo();

    /**
     * Checks whether the field "rTrackInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTrackInfo()). Otherwise it will return false.
     */
    inline bool hasRTrackInfo () const;

    /**
     * Returns the value of the member "rTrackInfo".
     *
     * Information about the current track.
     *
     * @return The value of the field "rTrackInfo"
     */
    inline const T_datacollector_Audio_TrackInfo& getRTrackInfo () const;

    /**
     * Retrieves the value of the field "rTrackInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTrackInfo".
     */
    inline T_datacollector_Audio_TrackInfo& getRTrackInfoMutable ();

    /**
     * Sets the value of the member "rTrackInfo".
     *
     * Information about the current track.
     *
     * @param rTrackInfo The value which will be set
     */
    inline void setRTrackInfo (const T_datacollector_Audio_TrackInfo& rTrackInfo_);

    // API of field "rGroupInfo"

    static const int kRGroupInfo = 2;

    /**
     * Clears the field "rGroupInfo".
     *
     * The field will be set to its default value. The hasRGroupInfo()
     * method will return false.
     */
    inline void clearRGroupInfo();

    /**
     * Checks whether the field "rGroupInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRGroupInfo()). Otherwise it will return false.
     */
    inline bool hasRGroupInfo () const;

    /**
     * Returns the value of the member "rGroupInfo".
     *
     * Information about the current group.
     *
     * @return The value of the field "rGroupInfo"
     */
    inline const T_datacollector_Audio_GroupInfo& getRGroupInfo () const;

    /**
     * Retrieves the value of the field "rGroupInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rGroupInfo".
     */
    inline T_datacollector_Audio_GroupInfo& getRGroupInfoMutable ();

    /**
     * Sets the value of the member "rGroupInfo".
     *
     * Information about the current group.
     *
     * @param rGroupInfo The value which will be set
     */
    inline void setRGroupInfo (const T_datacollector_Audio_GroupInfo& rGroupInfo_);

    // API of field "rArtistInfo"

    static const int kRArtistInfo = 3;

    /**
     * Clears the field "rArtistInfo".
     *
     * The field will be set to its default value. The hasRArtistInfo()
     * method will return false.
     */
    inline void clearRArtistInfo();

    /**
     * Checks whether the field "rArtistInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRArtistInfo()). Otherwise it will return false.
     */
    inline bool hasRArtistInfo () const;

    /**
     * Returns the value of the member "rArtistInfo".
     *
     * Information about the artist of the current track.
     *
     * @return The value of the field "rArtistInfo"
     */
    inline const T_datacollector_Audio_ArtistInfo& getRArtistInfo () const;

    /**
     * Retrieves the value of the field "rArtistInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rArtistInfo".
     */
    inline T_datacollector_Audio_ArtistInfo& getRArtistInfoMutable ();

    /**
     * Sets the value of the member "rArtistInfo".
     *
     * Information about the artist of the current track.
     *
     * @param rArtistInfo The value which will be set
     */
    inline void setRArtistInfo (const T_datacollector_Audio_ArtistInfo& rArtistInfo_);

    static const T_datacollector_Audio_MediaData &getDefaultInstance();

private:

    inline void set_has_e8MediaType ();

    inline void clear_has_e8MediaType ();

    inline void set_has_rTrackInfo ();

    inline void clear_has_rTrackInfo ();

    inline void set_has_rGroupInfo ();

    inline void clear_has_rGroupInfo ();

    inline void set_has_rArtistInfo ();

    inline void clear_has_rArtistInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    T_e8_datacollector_Audio_MediaType _e8MediaType;

    T_datacollector_Audio_TrackInfo _rTrackInfo;

    T_datacollector_Audio_GroupInfo _rGroupInfo;

    T_datacollector_Audio_ArtistInfo _rArtistInfo;

};

/**
 * Record type used for the data of the audio source AUX.
 */
class T_datacollector_Audio_AuxData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_AuxData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_AuxData (const T_datacollector_Audio_AuxData &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_AuxData (T_e8_datacollector_Audio_AuxType e8AuxType_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_AuxData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_AuxData& operator = (const T_datacollector_Audio_AuxData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_AuxData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_AuxData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_AuxData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_AuxData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "e8AuxType"

    static const int kE8AuxType = 0;

    /**
     * Clears the field "e8AuxType".
     *
     * The field will be set to its default value. The hasE8AuxType()
     * method will return false.
     */
    inline void clearE8AuxType();

    /**
     * Checks whether the field "e8AuxType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setE8AuxType()). Otherwise it will return false.
     */
    inline bool hasE8AuxType () const;

    /**
     * Returns the value of the member "e8AuxType".
     *
     * If the meaning of "e8AuxType" isn't clear, then there should be a description here.
     *
     * @return The value of the field "e8AuxType"
     */
    inline T_e8_datacollector_Audio_AuxType getE8AuxType () const;

    /**
     * Sets the value of the member "e8AuxType".
     *
     * If the meaning of "e8AuxType" isn't clear, then there should be a description here.
     *
     * @param e8AuxType The value which will be set
     */
    inline void setE8AuxType (T_e8_datacollector_Audio_AuxType e8AuxType_);

    static const T_datacollector_Audio_AuxData &getDefaultInstance();

private:

    inline void set_has_e8AuxType ();

    inline void clear_has_e8AuxType ();

    uint32 _has_bits_[ (1 + 31) / 32];

    T_e8_datacollector_Audio_AuxType _e8AuxType;

};

/**
 * Empty record type indicating that an external sound source, e.g. phone call, is active.
 */
class T_datacollector_Audio_ExternalSoundData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_ExternalSoundData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_ExternalSoundData (const T_datacollector_Audio_ExternalSoundData &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_ExternalSoundData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_ExternalSoundData& operator = (const T_datacollector_Audio_ExternalSoundData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_ExternalSoundData& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_ExternalSoundData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_ExternalSoundData& ) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_ExternalSoundData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const T_datacollector_Audio_ExternalSoundData &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * <p>Record type used for the data of the audio source "Internet Radio".</p>
 * <p>The name of the internet radio is defined by a string.</p>
 * <p>How the information have to be filled into the three info records is specified in the
 * corresponding specification of the meter:</p>
 * <p>https://hi-dms.de.bosch.com/docushare/dsweb/Get/Document-379496/Meter_Combi_Function_Spec_ver3.90.xls</p>
 */
class T_datacollector_Audio_InternetRadioData {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_Audio_InternetRadioData ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_InternetRadioData (const T_datacollector_Audio_InternetRadioData &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_Audio_InternetRadioData (const ::std::string& strSourceName_, const T_datacollector_Audio_TrackInfo& rTrackInfo_, const T_datacollector_Audio_GroupInfo& rGroupInfo_, const T_datacollector_Audio_ArtistInfo& rArtistInfo_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_InternetRadioData();

    /**
     * Assignment operator
     */
    inline T_datacollector_Audio_InternetRadioData& operator = (const T_datacollector_Audio_InternetRadioData& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_InternetRadioData& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_InternetRadioData& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_InternetRadioData& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_InternetRadioData& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "strSourceName"

    static const int kStrSourceName = 0;

    /**
     * Clears the field "strSourceName".
     *
     * The field will be set to its default value. The hasStrSourceName()
     * method will return false.
     */
    inline void clearStrSourceName();

    /**
     * Checks whether the field "strSourceName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStrSourceName()). Otherwise it will return false.
     */
    inline bool hasStrSourceName () const;

    /**
     * Returns the value of the member "strSourceName".
     *
     * Text string containing the name of the internet radio.
     *
     * @return The value of the field "strSourceName"
     */
    inline const ::std::string& getStrSourceName () const;

    /**
     * Retrieves the value of the field "strSourceName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "strSourceName".
     */
    inline ::std::string& getStrSourceNameMutable ();

    /**
     * Sets the value of the member "strSourceName".
     *
     * Text string containing the name of the internet radio.
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const ::std::string& strSourceName_);

    /**
     * Sets the value of the member "strSourceName".
     *
     * Text string containing the name of the internet radio.
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const char* strSourceName_);

    /**
     * Sets the value of the member "strSourceName".
     *
     * Text string containing the name of the internet radio.
     *
     * @param strSourceName The value which will be set
     */
    inline void setStrSourceName (const char* value, size_t size);

    // API of field "rTrackInfo"

    static const int kRTrackInfo = 1;

    /**
     * Clears the field "rTrackInfo".
     *
     * The field will be set to its default value. The hasRTrackInfo()
     * method will return false.
     */
    inline void clearRTrackInfo();

    /**
     * Checks whether the field "rTrackInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRTrackInfo()). Otherwise it will return false.
     */
    inline bool hasRTrackInfo () const;

    /**
     * Returns the value of the member "rTrackInfo".
     *
     * Information about the current track.
     *
     * @return The value of the field "rTrackInfo"
     */
    inline const T_datacollector_Audio_TrackInfo& getRTrackInfo () const;

    /**
     * Retrieves the value of the field "rTrackInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rTrackInfo".
     */
    inline T_datacollector_Audio_TrackInfo& getRTrackInfoMutable ();

    /**
     * Sets the value of the member "rTrackInfo".
     *
     * Information about the current track.
     *
     * @param rTrackInfo The value which will be set
     */
    inline void setRTrackInfo (const T_datacollector_Audio_TrackInfo& rTrackInfo_);

    // API of field "rGroupInfo"

    static const int kRGroupInfo = 2;

    /**
     * Clears the field "rGroupInfo".
     *
     * The field will be set to its default value. The hasRGroupInfo()
     * method will return false.
     */
    inline void clearRGroupInfo();

    /**
     * Checks whether the field "rGroupInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRGroupInfo()). Otherwise it will return false.
     */
    inline bool hasRGroupInfo () const;

    /**
     * Returns the value of the member "rGroupInfo".
     *
     * Information about the current group.
     *
     * @return The value of the field "rGroupInfo"
     */
    inline const T_datacollector_Audio_GroupInfo& getRGroupInfo () const;

    /**
     * Retrieves the value of the field "rGroupInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rGroupInfo".
     */
    inline T_datacollector_Audio_GroupInfo& getRGroupInfoMutable ();

    /**
     * Sets the value of the member "rGroupInfo".
     *
     * Information about the current group.
     *
     * @param rGroupInfo The value which will be set
     */
    inline void setRGroupInfo (const T_datacollector_Audio_GroupInfo& rGroupInfo_);

    // API of field "rArtistInfo"

    static const int kRArtistInfo = 3;

    /**
     * Clears the field "rArtistInfo".
     *
     * The field will be set to its default value. The hasRArtistInfo()
     * method will return false.
     */
    inline void clearRArtistInfo();

    /**
     * Checks whether the field "rArtistInfo" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRArtistInfo()). Otherwise it will return false.
     */
    inline bool hasRArtistInfo () const;

    /**
     * Returns the value of the member "rArtistInfo".
     *
     * Information about the artist of the current track.
     *
     * @return The value of the field "rArtistInfo"
     */
    inline const T_datacollector_Audio_ArtistInfo& getRArtistInfo () const;

    /**
     * Retrieves the value of the field "rArtistInfo" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "rArtistInfo".
     */
    inline T_datacollector_Audio_ArtistInfo& getRArtistInfoMutable ();

    /**
     * Sets the value of the member "rArtistInfo".
     *
     * Information about the artist of the current track.
     *
     * @param rArtistInfo The value which will be set
     */
    inline void setRArtistInfo (const T_datacollector_Audio_ArtistInfo& rArtistInfo_);

    static const T_datacollector_Audio_InternetRadioData &getDefaultInstance();

private:

    inline void set_has_strSourceName ();

    inline void clear_has_strSourceName ();

    inline void set_has_rTrackInfo ();

    inline void clear_has_rTrackInfo ();

    inline void set_has_rGroupInfo ();

    inline void clear_has_rGroupInfo ();

    inline void set_has_rArtistInfo ();

    inline void clear_has_rArtistInfo ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _strSourceName;

    T_datacollector_Audio_TrackInfo _rTrackInfo;

    T_datacollector_Audio_GroupInfo _rGroupInfo;

    T_datacollector_Audio_ArtistInfo _rArtistInfo;

};

/**
 * If the meaning of "T_datacollector_Audio_SourceInfoUnion" isn't clear, then there should be a description here.
 */
class T_datacollector_Audio_SourceInfoUnion {
public:

    enum T_datacollector_Audio_SourceInfoUnionField {
        E_T_DATACOLLECTOR_AUDIO_NO_DATA = 0,
        E_T_DATACOLLECTOR_AUDIO_RADIO_DATA = 1,
        E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA = 2,
        E_T_DATACOLLECTOR_AUDIO_AUX_DATA = 3,
        E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA = 4,
        E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA = 5
    };

    /**
     * Default constructor
     *
     * The union will be initialized to "T_datacollector_Audio_NoData".
     */
    inline  T_datacollector_Audio_SourceInfoUnion ();

   /**
     * Copy constructor
     */
    inline  T_datacollector_Audio_SourceInfoUnion (const T_datacollector_Audio_SourceInfoUnion& rhs);

    /**
     * Destructor
     */
    inline  ~T_datacollector_Audio_SourceInfoUnion();

    /**
     * Assigns a new value to this object.
     */
    inline T_datacollector_Audio_SourceInfoUnion& operator = (const T_datacollector_Audio_SourceInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_Audio_SourceInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_Audio_SourceInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_Audio_SourceInfoUnion& rhs) const ;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_Audio_SourceInfoUnion& rhs) const;

    /**
     * Returns the field being set.
     *
     * @return The field being set
     */
    inline T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnionField getField () const;

    inline void setField(T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnionField field);

    // ---- Field accessors -------------------------------------------

    // API of field "T_datacollector_Audio_NoData"

    static const int kT_datacollector_Audio_NoData = 0;

    /**
     * Returns true if the field "T_datacollector_Audio_NoData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_NoData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_NoData", otherwise false
     */
    inline bool hasT_datacollector_Audio_NoData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_NoData".It is only
     * valid to call this method if hasT_datacollector_Audio_NoData() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_NoData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_NoData& getT_datacollector_Audio_NoData() const ;

    /**
     * Retrieves the value of the field "T_datacollector_Audio_NoData" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_NoData() returns true. Otherwise the behavior
     * is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_NoData& getT_datacollector_Audio_NoDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_NoData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_NoData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_NoData"
     */
    inline T_datacollector_Audio_NoData* releaseT_datacollector_Audio_NoData();

    /**
     * Replace the field "T_datacollector_Audio_NoData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_NoData (T_datacollector_Audio_NoData* T_datacollector_Audio_NoData);

    /**
     * Sets the value of the field "T_datacollector_Audio_NoData". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_NoData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_NoData (const T_datacollector_Audio_NoData& value);

    // API of field "T_datacollector_Audio_RadioData"

    static const int kT_datacollector_Audio_RadioData = 1;

    /**
     * Returns true if the field "T_datacollector_Audio_RadioData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_RadioData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_RadioData", otherwise false
     */
    inline bool hasT_datacollector_Audio_RadioData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_RadioData".It is only
     * valid to call this method if hasT_datacollector_Audio_RadioData()
     * returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_RadioData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_RadioData& getT_datacollector_Audio_RadioData() const ;

    /**
     * Retrieves the value of the field "T_datacollector_Audio_RadioData" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_RadioData() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_RadioData& getT_datacollector_Audio_RadioDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_RadioData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_RadioData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_RadioData"
     */
    inline T_datacollector_Audio_RadioData* releaseT_datacollector_Audio_RadioData();

    /**
     * Replace the field "T_datacollector_Audio_RadioData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_RadioData (T_datacollector_Audio_RadioData* T_datacollector_Audio_RadioData);

    /**
     * Sets the value of the field "T_datacollector_Audio_RadioData". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_RadioData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_RadioData (const T_datacollector_Audio_RadioData& value);

    // API of field "T_datacollector_Audio_MediaData"

    static const int kT_datacollector_Audio_MediaData = 2;

    /**
     * Returns true if the field "T_datacollector_Audio_MediaData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_MediaData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_MediaData", otherwise false
     */
    inline bool hasT_datacollector_Audio_MediaData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_MediaData".It is only
     * valid to call this method if hasT_datacollector_Audio_MediaData()
     * returns true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_MediaData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_MediaData& getT_datacollector_Audio_MediaData() const ;

    /**
     * Retrieves the value of the field "T_datacollector_Audio_MediaData" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_MediaData() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_MediaData& getT_datacollector_Audio_MediaDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_MediaData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_MediaData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_MediaData"
     */
    inline T_datacollector_Audio_MediaData* releaseT_datacollector_Audio_MediaData();

    /**
     * Replace the field "T_datacollector_Audio_MediaData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_MediaData (T_datacollector_Audio_MediaData* T_datacollector_Audio_MediaData);

    /**
     * Sets the value of the field "T_datacollector_Audio_MediaData". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_MediaData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_MediaData (const T_datacollector_Audio_MediaData& value);

    // API of field "T_datacollector_Audio_AuxData"

    static const int kT_datacollector_Audio_AuxData = 3;

    /**
     * Returns true if the field "T_datacollector_Audio_AuxData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_AuxData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_AuxData", otherwise false
     */
    inline bool hasT_datacollector_Audio_AuxData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_AuxData".It is only
     * valid to call this method if hasT_datacollector_Audio_AuxData() returns
     * true. Otherwise the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_AuxData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_AuxData& getT_datacollector_Audio_AuxData() const ;

    /**
     * Retrieves the value of the field "T_datacollector_Audio_AuxData" as a
     * mutable object. Any modifications on the returned object will affect
     * the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_AuxData() returns true. Otherwise the behavior
     * is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_AuxData& getT_datacollector_Audio_AuxDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_AuxData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_AuxData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_AuxData"
     */
    inline T_datacollector_Audio_AuxData* releaseT_datacollector_Audio_AuxData();

    /**
     * Replace the field "T_datacollector_Audio_AuxData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_AuxData (T_datacollector_Audio_AuxData* T_datacollector_Audio_AuxData);

    /**
     * Sets the value of the field "T_datacollector_Audio_AuxData". A field
     * which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_AuxData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_AuxData (const T_datacollector_Audio_AuxData& value);

    // API of field "T_datacollector_Audio_ExternalSoundData"

    static const int kT_datacollector_Audio_ExternalSoundData = 4;

    /**
     * Returns true if the field "T_datacollector_Audio_ExternalSoundData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_ExternalSoundData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_ExternalSoundData", otherwise false
     */
    inline bool hasT_datacollector_Audio_ExternalSoundData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_ExternalSoundData".It
     * is only valid to call this method if
     * hasT_datacollector_Audio_ExternalSoundData() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_ExternalSoundData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_ExternalSoundData& getT_datacollector_Audio_ExternalSoundData() const ;

    /**
     * Retrieves the value of the field
     * "T_datacollector_Audio_ExternalSoundData" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_ExternalSoundData() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_ExternalSoundData& getT_datacollector_Audio_ExternalSoundDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_ExternalSoundData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_ExternalSoundData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_ExternalSoundData"
     */
    inline T_datacollector_Audio_ExternalSoundData* releaseT_datacollector_Audio_ExternalSoundData();

    /**
     * Replace the field "T_datacollector_Audio_ExternalSoundData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_ExternalSoundData (T_datacollector_Audio_ExternalSoundData* T_datacollector_Audio_ExternalSoundData);

    /**
     * Sets the value of the field "T_datacollector_Audio_ExternalSoundData".
     * A field which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_ExternalSoundData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_ExternalSoundData (const T_datacollector_Audio_ExternalSoundData& value);

    // API of field "T_datacollector_Audio_InternetRadioData"

    static const int kT_datacollector_Audio_InternetRadioData = 5;

    /**
     * Returns true if the field "T_datacollector_Audio_InternetRadioData" has a value.
     *
     * If the meaning of "T_datacollector_Audio_InternetRadioData" isn't clear, then there should be a description here.
     *
     * @return True if the union is of type "T_datacollector_Audio_InternetRadioData", otherwise false
     */
    inline bool hasT_datacollector_Audio_InternetRadioData () const;

    /**
     * Returns the value of field "T_datacollector_Audio_InternetRadioData".It
     * is only valid to call this method if
     * hasT_datacollector_Audio_InternetRadioData() returns true. Otherwise
     * the behavior is not specified.
     *
     * If the meaning of "T_datacollector_Audio_InternetRadioData" isn't clear, then there should be a description here.
     *
     * @return The value of the union
     */
    inline const T_datacollector_Audio_InternetRadioData& getT_datacollector_Audio_InternetRadioData() const ;

    /**
     * Retrieves the value of the field
     * "T_datacollector_Audio_InternetRadioData" as a mutable object. Any
     * modifications on the returned object will affect the containing object.
     *
     * It is only valid to call this method if
     * isT_datacollector_Audio_InternetRadioData() returns true. Otherwise the
     * behavior is not specified.
     *
     * @return The value of the union
     */
    inline T_datacollector_Audio_InternetRadioData& getT_datacollector_Audio_InternetRadioDataMutable();

    /**
     * Release the object stored in the field "T_datacollector_Audio_InternetRadioData".
     *
     * The caller takes the ownership of the returned object and is
     * responsible for deleting it later. The field will be set to its
     * default value and marked as not being set.
     *
     * It is only valid to call this method if the field "T_datacollector_Audio_InternetRadioData" is set.
     * Otherwise the behavior is not specified.
     *
     * @return The object stored in the field "T_datacollector_Audio_InternetRadioData"
     */
    inline T_datacollector_Audio_InternetRadioData* releaseT_datacollector_Audio_InternetRadioData();

    /**
     * Replace the field "T_datacollector_Audio_InternetRadioData".
     *
     * The caller is loosing the ownership of the passed object. The object
     * will be deleted by the called object.
     */
    inline void replaceT_datacollector_Audio_InternetRadioData (T_datacollector_Audio_InternetRadioData* T_datacollector_Audio_InternetRadioData);

    /**
     * Sets the value of the field "T_datacollector_Audio_InternetRadioData".
     * A field which was previously set will be cleared.
     *
     * If the meaning of "T_datacollector_Audio_InternetRadioData" isn't clear, then there should be a description here.
     *
     * @param value The union will be set to this value
     */
    inline void setT_datacollector_Audio_InternetRadioData (const T_datacollector_Audio_InternetRadioData& value);

    static const T_datacollector_Audio_SourceInfoUnion &getDefaultInstance();

private:

    inline void cloneData (const T_datacollector_Audio_SourceInfoUnion& rhs);

    inline void deleteData ();

    T_datacollector_Audio_SourceInfoUnionField __field;

    union {
        T_datacollector_Audio_NoData* T_datacollector_Audio_NoData_;
        T_datacollector_Audio_RadioData* T_datacollector_Audio_RadioData_;
        T_datacollector_Audio_MediaData* T_datacollector_Audio_MediaData_;
        T_datacollector_Audio_AuxData* T_datacollector_Audio_AuxData_;
        T_datacollector_Audio_ExternalSoundData* T_datacollector_Audio_ExternalSoundData_;
        T_datacollector_Audio_InternetRadioData* T_datacollector_Audio_InternetRadioData_;
    } _data;

};

class T_datacollector_TimeInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_TimeInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_TimeInfoUnion (const T_datacollector_TimeInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_TimeInfoUnion (T_e8_datacollector_TimeInfoType TimeFormatType_, uint8 CurrentHours_, uint8 CurrentMinutes_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_TimeInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_TimeInfoUnion& operator = (const T_datacollector_TimeInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_TimeInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_TimeInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_TimeInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_TimeInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TimeFormatType"

    static const int kTimeFormatType = 0;

    /**
     * Clears the field "TimeFormatType".
     *
     * The field will be set to its default value. The hasTimeFormatType()
     * method will return false.
     */
    inline void clearTimeFormatType();

    /**
     * Checks whether the field "TimeFormatType" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTimeFormatType()). Otherwise it will return false.
     */
    inline bool hasTimeFormatType () const;

    /**
     * Returns the value of the member "TimeFormatType".
     *
     * Enumeration type defining the type, i.e. format, of the time information.
     *
     * @return The value of the field "TimeFormatType"
     */
    inline T_e8_datacollector_TimeInfoType getTimeFormatType () const;

    /**
     * Sets the value of the member "TimeFormatType".
     *
     * Enumeration type defining the type, i.e. format, of the time information.
     *
     * @param TimeFormatType The value which will be set
     */
    inline void setTimeFormatType (T_e8_datacollector_TimeInfoType TimeFormatType_);

    // API of field "CurrentHours"

    static const int kCurrentHours = 1;

    /**
     * Clears the field "CurrentHours".
     *
     * The field will be set to its default value. The hasCurrentHours()
     * method will return false.
     */
    inline void clearCurrentHours();

    /**
     * Checks whether the field "CurrentHours" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentHours()). Otherwise it will return false.
     */
    inline bool hasCurrentHours () const;

    /**
     * Returns the value of the member "CurrentHours".
     *
     *
     *
     * @return The value of the field "CurrentHours"
     */
    inline uint8 getCurrentHours () const;

    /**
     * Sets the value of the member "CurrentHours".
     *
     *
     *
     * @param CurrentHours The value which will be set
     */
    inline void setCurrentHours (uint8 CurrentHours_);

    // API of field "CurrentMinutes"

    static const int kCurrentMinutes = 2;

    /**
     * Clears the field "CurrentMinutes".
     *
     * The field will be set to its default value. The hasCurrentMinutes()
     * method will return false.
     */
    inline void clearCurrentMinutes();

    /**
     * Checks whether the field "CurrentMinutes" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentMinutes()). Otherwise it will return false.
     */
    inline bool hasCurrentMinutes () const;

    /**
     * Returns the value of the member "CurrentMinutes".
     *
     *
     *
     * @return The value of the field "CurrentMinutes"
     */
    inline uint8 getCurrentMinutes () const;

    /**
     * Sets the value of the member "CurrentMinutes".
     *
     *
     *
     * @param CurrentMinutes The value which will be set
     */
    inline void setCurrentMinutes (uint8 CurrentMinutes_);

    static const T_datacollector_TimeInfoUnion &getDefaultInstance();

private:

    inline void set_has_TimeFormatType ();

    inline void clear_has_TimeFormatType ();

    inline void set_has_CurrentHours ();

    inline void clear_has_CurrentHours ();

    inline void set_has_CurrentMinutes ();

    inline void clear_has_CurrentMinutes ();

    uint32 _has_bits_[ (3 + 31) / 32];

    T_e8_datacollector_TimeInfoType _TimeFormatType;

    uint8 _CurrentHours;

    uint8 _CurrentMinutes;

};

/**
 * This structure gives info on BT connection status, Battery residual quantity and Mobile phone field strength
 */
class T_datacollector_PhoneInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_PhoneInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_PhoneInfoUnion (const T_datacollector_PhoneInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_PhoneInfoUnion (bool BTConnectionState_, uint8 BatteryResidualQuantity_, uint8 PhoneSignalStrength_, const ::std::string& CallerName_, const ::std::string& CallerNumber_, uint8 CallDuration_, T_e8_datacollector_CallStatus CallStatus_, uint8 NoOfConnectedDevice_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_PhoneInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_PhoneInfoUnion& operator = (const T_datacollector_PhoneInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_PhoneInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_PhoneInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_PhoneInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_PhoneInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "BTConnectionState"

    static const int kBTConnectionState = 0;

    /**
     * Clears the field "BTConnectionState".
     *
     * The field will be set to its default value. The hasBTConnectionState()
     * method will return false.
     */
    inline void clearBTConnectionState();

    /**
     * Checks whether the field "BTConnectionState" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBTConnectionState()). Otherwise it will return false.
     */
    inline bool hasBTConnectionState () const;

    /**
     * Returns the value of the member "BTConnectionState".
     *
     * TRUE  : If user is connected via BT
     * FALSE : If no user is connected via BT
     *
     * @return The value of the field "BTConnectionState"
     */
    inline bool getBTConnectionState () const;

    /**
     * Sets the value of the member "BTConnectionState".
     *
     * TRUE  : If user is connected via BT
     * FALSE : If no user is connected via BT
     *
     * @param BTConnectionState The value which will be set
     */
    inline void setBTConnectionState (bool BTConnectionState_);

    // API of field "BatteryResidualQuantity"

    static const int kBatteryResidualQuantity = 1;

    /**
     * Clears the field "BatteryResidualQuantity".
     *
     * The field will be set to its default value. The hasBatteryResidualQuantity()
     * method will return false.
     */
    inline void clearBatteryResidualQuantity();

    /**
     * Checks whether the field "BatteryResidualQuantity" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setBatteryResidualQuantity()). Otherwise it will return false.
     */
    inline bool hasBatteryResidualQuantity () const;

    /**
     * Returns the value of the member "BatteryResidualQuantity".
     *
     * This parameter contains the current cell phone battery status from 1 to 5
     *
     * @return The value of the field "BatteryResidualQuantity"
     */
    inline uint8 getBatteryResidualQuantity () const;

    /**
     * Sets the value of the member "BatteryResidualQuantity".
     *
     * This parameter contains the current cell phone battery status from 1 to 5
     *
     * @param BatteryResidualQuantity The value which will be set
     */
    inline void setBatteryResidualQuantity (uint8 BatteryResidualQuantity_);

    // API of field "PhoneSignalStrength"

    static const int kPhoneSignalStrength = 2;

    /**
     * Clears the field "PhoneSignalStrength".
     *
     * The field will be set to its default value. The hasPhoneSignalStrength()
     * method will return false.
     */
    inline void clearPhoneSignalStrength();

    /**
     * Checks whether the field "PhoneSignalStrength" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPhoneSignalStrength()). Otherwise it will return false.
     */
    inline bool hasPhoneSignalStrength () const;

    /**
     * Returns the value of the member "PhoneSignalStrength".
     *
     * This parameter contains the current cell phone signal status from 1 to 5
     *
     * @return The value of the field "PhoneSignalStrength"
     */
    inline uint8 getPhoneSignalStrength () const;

    /**
     * Sets the value of the member "PhoneSignalStrength".
     *
     * This parameter contains the current cell phone signal status from 1 to 5
     *
     * @param PhoneSignalStrength The value which will be set
     */
    inline void setPhoneSignalStrength (uint8 PhoneSignalStrength_);

    // API of field "CallerName"

    static const int kCallerName = 3;

    /**
     * Clears the field "CallerName".
     *
     * The field will be set to its default value. The hasCallerName()
     * method will return false.
     */
    inline void clearCallerName();

    /**
     * Checks whether the field "CallerName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallerName()). Otherwise it will return false.
     */
    inline bool hasCallerName () const;

    /**
     * Returns the value of the member "CallerName".
     *
     * This parameter contains name of the caller
     *
     * @return The value of the field "CallerName"
     */
    inline const ::std::string& getCallerName () const;

    /**
     * Retrieves the value of the field "CallerName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallerName".
     */
    inline ::std::string& getCallerNameMutable ();

    /**
     * Sets the value of the member "CallerName".
     *
     * This parameter contains name of the caller
     *
     * @param CallerName The value which will be set
     */
    inline void setCallerName (const ::std::string& CallerName_);

    /**
     * Sets the value of the member "CallerName".
     *
     * This parameter contains name of the caller
     *
     * @param CallerName The value which will be set
     */
    inline void setCallerName (const char* CallerName_);

    /**
     * Sets the value of the member "CallerName".
     *
     * This parameter contains name of the caller
     *
     * @param CallerName The value which will be set
     */
    inline void setCallerName (const char* value, size_t size);

    // API of field "CallerNumber"

    static const int kCallerNumber = 4;

    /**
     * Clears the field "CallerNumber".
     *
     * The field will be set to its default value. The hasCallerNumber()
     * method will return false.
     */
    inline void clearCallerNumber();

    /**
     * Checks whether the field "CallerNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallerNumber()). Otherwise it will return false.
     */
    inline bool hasCallerNumber () const;

    /**
     * Returns the value of the member "CallerNumber".
     *
     * This parameter contains phone number of the caller
     *
     * @return The value of the field "CallerNumber"
     */
    inline const ::std::string& getCallerNumber () const;

    /**
     * Retrieves the value of the field "CallerNumber" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CallerNumber".
     */
    inline ::std::string& getCallerNumberMutable ();

    /**
     * Sets the value of the member "CallerNumber".
     *
     * This parameter contains phone number of the caller
     *
     * @param CallerNumber The value which will be set
     */
    inline void setCallerNumber (const ::std::string& CallerNumber_);

    /**
     * Sets the value of the member "CallerNumber".
     *
     * This parameter contains phone number of the caller
     *
     * @param CallerNumber The value which will be set
     */
    inline void setCallerNumber (const char* CallerNumber_);

    /**
     * Sets the value of the member "CallerNumber".
     *
     * This parameter contains phone number of the caller
     *
     * @param CallerNumber The value which will be set
     */
    inline void setCallerNumber (const char* value, size_t size);

    // API of field "CallDuration"

    static const int kCallDuration = 5;

    /**
     * Clears the field "CallDuration".
     *
     * The field will be set to its default value. The hasCallDuration()
     * method will return false.
     */
    inline void clearCallDuration();

    /**
     * Checks whether the field "CallDuration" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallDuration()). Otherwise it will return false.
     */
    inline bool hasCallDuration () const;

    /**
     * Returns the value of the member "CallDuration".
     *
     * This parameter contains duration of the ongoing call
     *
     * @return The value of the field "CallDuration"
     */
    inline uint8 getCallDuration () const;

    /**
     * Sets the value of the member "CallDuration".
     *
     * This parameter contains duration of the ongoing call
     *
     * @param CallDuration The value which will be set
     */
    inline void setCallDuration (uint8 CallDuration_);

    // API of field "CallStatus"

    static const int kCallStatus = 6;

    /**
     * Clears the field "CallStatus".
     *
     * The field will be set to its default value. The hasCallStatus()
     * method will return false.
     */
    inline void clearCallStatus();

    /**
     * Checks whether the field "CallStatus" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCallStatus()). Otherwise it will return false.
     */
    inline bool hasCallStatus () const;

    /**
     * Returns the value of the member "CallStatus".
     *
     * This parameter contains duration of the ongoing call
     *
     * @return The value of the field "CallStatus"
     */
    inline T_e8_datacollector_CallStatus getCallStatus () const;

    /**
     * Sets the value of the member "CallStatus".
     *
     * This parameter contains duration of the ongoing call
     *
     * @param CallStatus The value which will be set
     */
    inline void setCallStatus (T_e8_datacollector_CallStatus CallStatus_);

    // API of field "NoOfConnectedDevice"

    static const int kNoOfConnectedDevice = 7;

    /**
     * Clears the field "NoOfConnectedDevice".
     *
     * The field will be set to its default value. The hasNoOfConnectedDevice()
     * method will return false.
     */
    inline void clearNoOfConnectedDevice();

    /**
     * Checks whether the field "NoOfConnectedDevice" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNoOfConnectedDevice()). Otherwise it will return false.
     */
    inline bool hasNoOfConnectedDevice () const;

    /**
     * Returns the value of the member "NoOfConnectedDevice".
     *
     * This parameter gives info on number of connected device
     *
     * @return The value of the field "NoOfConnectedDevice"
     */
    inline uint8 getNoOfConnectedDevice () const;

    /**
     * Sets the value of the member "NoOfConnectedDevice".
     *
     * This parameter gives info on number of connected device
     *
     * @param NoOfConnectedDevice The value which will be set
     */
    inline void setNoOfConnectedDevice (uint8 NoOfConnectedDevice_);

    static const T_datacollector_PhoneInfoUnion &getDefaultInstance();

private:

    inline void set_has_BTConnectionState ();

    inline void clear_has_BTConnectionState ();

    inline void set_has_BatteryResidualQuantity ();

    inline void clear_has_BatteryResidualQuantity ();

    inline void set_has_PhoneSignalStrength ();

    inline void clear_has_PhoneSignalStrength ();

    inline void set_has_CallerName ();

    inline void clear_has_CallerName ();

    inline void set_has_CallerNumber ();

    inline void clear_has_CallerNumber ();

    inline void set_has_CallDuration ();

    inline void clear_has_CallDuration ();

    inline void set_has_CallStatus ();

    inline void clear_has_CallStatus ();

    inline void set_has_NoOfConnectedDevice ();

    inline void clear_has_NoOfConnectedDevice ();

    uint32 _has_bits_[ (8 + 31) / 32];

    bool _BTConnectionState;

    uint8 _BatteryResidualQuantity;

    uint8 _PhoneSignalStrength;

    ::std::string _CallerName;

    ::std::string _CallerNumber;

    uint8 _CallDuration;

    T_e8_datacollector_CallStatus _CallStatus;

    uint8 _NoOfConnectedDevice;

};

/**
 * This structure gives info on number of unread SMS, notification on new SMS and senders name etc
 */
class T_datacollector_SMSInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_SMSInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_SMSInfoUnion (const T_datacollector_SMSInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_SMSInfoUnion (bool NewSMSNotification_, uint8 NumberOfUnreadSMS_, const ::std::string& SMSSendersName_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_SMSInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_SMSInfoUnion& operator = (const T_datacollector_SMSInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_SMSInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_SMSInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_SMSInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_SMSInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "NewSMSNotification"

    static const int kNewSMSNotification = 0;

    /**
     * Clears the field "NewSMSNotification".
     *
     * The field will be set to its default value. The hasNewSMSNotification()
     * method will return false.
     */
    inline void clearNewSMSNotification();

    /**
     * Checks whether the field "NewSMSNotification" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNewSMSNotification()). Otherwise it will return false.
     */
    inline bool hasNewSMSNotification () const;

    /**
     * Returns the value of the member "NewSMSNotification".
     *
     * TRUE  : If there is new message
     * FALSE : There is no new message
     *
     * @return The value of the field "NewSMSNotification"
     */
    inline bool getNewSMSNotification () const;

    /**
     * Sets the value of the member "NewSMSNotification".
     *
     * TRUE  : If there is new message
     * FALSE : There is no new message
     *
     * @param NewSMSNotification The value which will be set
     */
    inline void setNewSMSNotification (bool NewSMSNotification_);

    // API of field "NumberOfUnreadSMS"

    static const int kNumberOfUnreadSMS = 1;

    /**
     * Clears the field "NumberOfUnreadSMS".
     *
     * The field will be set to its default value. The hasNumberOfUnreadSMS()
     * method will return false.
     */
    inline void clearNumberOfUnreadSMS();

    /**
     * Checks whether the field "NumberOfUnreadSMS" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberOfUnreadSMS()). Otherwise it will return false.
     */
    inline bool hasNumberOfUnreadSMS () const;

    /**
     * Returns the value of the member "NumberOfUnreadSMS".
     *
     * This parameter gives info on number of unread messages in the inbox
     *
     * @return The value of the field "NumberOfUnreadSMS"
     */
    inline uint8 getNumberOfUnreadSMS () const;

    /**
     * Sets the value of the member "NumberOfUnreadSMS".
     *
     * This parameter gives info on number of unread messages in the inbox
     *
     * @param NumberOfUnreadSMS The value which will be set
     */
    inline void setNumberOfUnreadSMS (uint8 NumberOfUnreadSMS_);

    // API of field "SMSSendersName"

    static const int kSMSSendersName = 2;

    /**
     * Clears the field "SMSSendersName".
     *
     * The field will be set to its default value. The hasSMSSendersName()
     * method will return false.
     */
    inline void clearSMSSendersName();

    /**
     * Checks whether the field "SMSSendersName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSMSSendersName()). Otherwise it will return false.
     */
    inline bool hasSMSSendersName () const;

    /**
     * Returns the value of the member "SMSSendersName".
     *
     * This parameter gives name of the sender
     *
     * @return The value of the field "SMSSendersName"
     */
    inline const ::std::string& getSMSSendersName () const;

    /**
     * Retrieves the value of the field "SMSSendersName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SMSSendersName".
     */
    inline ::std::string& getSMSSendersNameMutable ();

    /**
     * Sets the value of the member "SMSSendersName".
     *
     * This parameter gives name of the sender
     *
     * @param SMSSendersName The value which will be set
     */
    inline void setSMSSendersName (const ::std::string& SMSSendersName_);

    /**
     * Sets the value of the member "SMSSendersName".
     *
     * This parameter gives name of the sender
     *
     * @param SMSSendersName The value which will be set
     */
    inline void setSMSSendersName (const char* SMSSendersName_);

    /**
     * Sets the value of the member "SMSSendersName".
     *
     * This parameter gives name of the sender
     *
     * @param SMSSendersName The value which will be set
     */
    inline void setSMSSendersName (const char* value, size_t size);

    static const T_datacollector_SMSInfoUnion &getDefaultInstance();

private:

    inline void set_has_NewSMSNotification ();

    inline void clear_has_NewSMSNotification ();

    inline void set_has_NumberOfUnreadSMS ();

    inline void clear_has_NumberOfUnreadSMS ();

    inline void set_has_SMSSendersName ();

    inline void clear_has_SMSSendersName ();

    uint32 _has_bits_[ (3 + 31) / 32];

    bool _NewSMSNotification;

    uint8 _NumberOfUnreadSMS;

    ::std::string _SMSSendersName;

};

/**
 * This structure gives info temperature recieved from the HVAC unit
 */
class T_datacollector_HVACInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_HVACInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_HVACInfoUnion (const T_datacollector_HVACInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_HVACInfoUnion (uint8 HVACTemperature_, T_e8_datacollector_HVACTemperatureUnit TemperatureUnit_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_HVACInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_HVACInfoUnion& operator = (const T_datacollector_HVACInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_HVACInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_HVACInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_HVACInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_HVACInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "HVACTemperature"

    static const int kHVACTemperature = 0;

    /**
     * Clears the field "HVACTemperature".
     *
     * The field will be set to its default value. The hasHVACTemperature()
     * method will return false.
     */
    inline void clearHVACTemperature();

    /**
     * Checks whether the field "HVACTemperature" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHVACTemperature()). Otherwise it will return false.
     */
    inline bool hasHVACTemperature () const;

    /**
     * Returns the value of the member "HVACTemperature".
     *
     *
     *
     * @return The value of the field "HVACTemperature"
     */
    inline uint8 getHVACTemperature () const;

    /**
     * Sets the value of the member "HVACTemperature".
     *
     *
     *
     * @param HVACTemperature The value which will be set
     */
    inline void setHVACTemperature (uint8 HVACTemperature_);

    // API of field "TemperatureUnit"

    static const int kTemperatureUnit = 1;

    /**
     * Clears the field "TemperatureUnit".
     *
     * The field will be set to its default value. The hasTemperatureUnit()
     * method will return false.
     */
    inline void clearTemperatureUnit();

    /**
     * Checks whether the field "TemperatureUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTemperatureUnit()). Otherwise it will return false.
     */
    inline bool hasTemperatureUnit () const;

    /**
     * Returns the value of the member "TemperatureUnit".
     *
     *
     *
     * @return The value of the field "TemperatureUnit"
     */
    inline T_e8_datacollector_HVACTemperatureUnit getTemperatureUnit () const;

    /**
     * Sets the value of the member "TemperatureUnit".
     *
     *
     *
     * @param TemperatureUnit The value which will be set
     */
    inline void setTemperatureUnit (T_e8_datacollector_HVACTemperatureUnit TemperatureUnit_);

    static const T_datacollector_HVACInfoUnion &getDefaultInstance();

private:

    inline void set_has_HVACTemperature ();

    inline void clear_has_HVACTemperature ();

    inline void set_has_TemperatureUnit ();

    inline void clear_has_TemperatureUnit ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint8 _HVACTemperature;

    T_e8_datacollector_HVACTemperatureUnit _TemperatureUnit;

};

/**
 * This structure gives info on current radio or media source, station name, frequency,track name , track number, playtime etc
 */
class T_datacollector_AudioInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_AudioInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_AudioInfoUnion (const T_datacollector_AudioInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_AudioInfoUnion (const ::std::string& TrackName_, uint8 TrackNumber_, uint8 TrackPlayTime_, T_e8_datacollector_CuurentRadioSource CurrentRadioSource_, const ::std::string& CurrentStationName_, const T_datacollector_Audio_RadioFrequency& AM_FMFrequency_, T_e8_datacollector_Audio_RadioFrequencyUnit AM_FMFrequencyUnit_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_AudioInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_AudioInfoUnion& operator = (const T_datacollector_AudioInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_AudioInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_AudioInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_AudioInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_AudioInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "TrackName"

    static const int kTrackName = 0;

    /**
     * Clears the field "TrackName".
     *
     * The field will be set to its default value. The hasTrackName()
     * method will return false.
     */
    inline void clearTrackName();

    /**
     * Checks whether the field "TrackName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackName()). Otherwise it will return false.
     */
    inline bool hasTrackName () const;

    /**
     * Returns the value of the member "TrackName".
     *
     * Name of the current track being played on the head unit
     *
     * @return The value of the field "TrackName"
     */
    inline const ::std::string& getTrackName () const;

    /**
     * Retrieves the value of the field "TrackName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "TrackName".
     */
    inline ::std::string& getTrackNameMutable ();

    /**
     * Sets the value of the member "TrackName".
     *
     * Name of the current track being played on the head unit
     *
     * @param TrackName The value which will be set
     */
    inline void setTrackName (const ::std::string& TrackName_);

    /**
     * Sets the value of the member "TrackName".
     *
     * Name of the current track being played on the head unit
     *
     * @param TrackName The value which will be set
     */
    inline void setTrackName (const char* TrackName_);

    /**
     * Sets the value of the member "TrackName".
     *
     * Name of the current track being played on the head unit
     *
     * @param TrackName The value which will be set
     */
    inline void setTrackName (const char* value, size_t size);

    // API of field "TrackNumber"

    static const int kTrackNumber = 1;

    /**
     * Clears the field "TrackNumber".
     *
     * The field will be set to its default value. The hasTrackNumber()
     * method will return false.
     */
    inline void clearTrackNumber();

    /**
     * Checks whether the field "TrackNumber" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackNumber()). Otherwise it will return false.
     */
    inline bool hasTrackNumber () const;

    /**
     * Returns the value of the member "TrackNumber".
     *
     *
     *
     * @return The value of the field "TrackNumber"
     */
    inline uint8 getTrackNumber () const;

    /**
     * Sets the value of the member "TrackNumber".
     *
     *
     *
     * @param TrackNumber The value which will be set
     */
    inline void setTrackNumber (uint8 TrackNumber_);

    // API of field "TrackPlayTime"

    static const int kTrackPlayTime = 2;

    /**
     * Clears the field "TrackPlayTime".
     *
     * The field will be set to its default value. The hasTrackPlayTime()
     * method will return false.
     */
    inline void clearTrackPlayTime();

    /**
     * Checks whether the field "TrackPlayTime" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTrackPlayTime()). Otherwise it will return false.
     */
    inline bool hasTrackPlayTime () const;

    /**
     * Returns the value of the member "TrackPlayTime".
     *
     *
     *
     * @return The value of the field "TrackPlayTime"
     */
    inline uint8 getTrackPlayTime () const;

    /**
     * Sets the value of the member "TrackPlayTime".
     *
     *
     *
     * @param TrackPlayTime The value which will be set
     */
    inline void setTrackPlayTime (uint8 TrackPlayTime_);

    // API of field "CurrentRadioSource"

    static const int kCurrentRadioSource = 3;

    /**
     * Clears the field "CurrentRadioSource".
     *
     * The field will be set to its default value. The hasCurrentRadioSource()
     * method will return false.
     */
    inline void clearCurrentRadioSource();

    /**
     * Checks whether the field "CurrentRadioSource" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentRadioSource()). Otherwise it will return false.
     */
    inline bool hasCurrentRadioSource () const;

    /**
     * Returns the value of the member "CurrentRadioSource".
     *
     *
     *
     * @return The value of the field "CurrentRadioSource"
     */
    inline T_e8_datacollector_CuurentRadioSource getCurrentRadioSource () const;

    /**
     * Sets the value of the member "CurrentRadioSource".
     *
     *
     *
     * @param CurrentRadioSource The value which will be set
     */
    inline void setCurrentRadioSource (T_e8_datacollector_CuurentRadioSource CurrentRadioSource_);

    // API of field "CurrentStationName"

    static const int kCurrentStationName = 4;

    /**
     * Clears the field "CurrentStationName".
     *
     * The field will be set to its default value. The hasCurrentStationName()
     * method will return false.
     */
    inline void clearCurrentStationName();

    /**
     * Checks whether the field "CurrentStationName" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCurrentStationName()). Otherwise it will return false.
     */
    inline bool hasCurrentStationName () const;

    /**
     * Returns the value of the member "CurrentStationName".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @return The value of the field "CurrentStationName"
     */
    inline const ::std::string& getCurrentStationName () const;

    /**
     * Retrieves the value of the field "CurrentStationName" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "CurrentStationName".
     */
    inline ::std::string& getCurrentStationNameMutable ();

    /**
     * Sets the value of the member "CurrentStationName".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @param CurrentStationName The value which will be set
     */
    inline void setCurrentStationName (const ::std::string& CurrentStationName_);

    /**
     * Sets the value of the member "CurrentStationName".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @param CurrentStationName The value which will be set
     */
    inline void setCurrentStationName (const char* CurrentStationName_);

    /**
     * Sets the value of the member "CurrentStationName".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @param CurrentStationName The value which will be set
     */
    inline void setCurrentStationName (const char* value, size_t size);

    // API of field "AM_FMFrequency"

    static const int kAM_FMFrequency = 5;

    /**
     * Clears the field "AM_FMFrequency".
     *
     * The field will be set to its default value. The hasAM_FMFrequency()
     * method will return false.
     */
    inline void clearAM_FMFrequency();

    /**
     * Checks whether the field "AM_FMFrequency" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAM_FMFrequency()). Otherwise it will return false.
     */
    inline bool hasAM_FMFrequency () const;

    /**
     * Returns the value of the member "AM_FMFrequency".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @return The value of the field "AM_FMFrequency"
     */
    inline const T_datacollector_Audio_RadioFrequency& getAM_FMFrequency () const;

    /**
     * Retrieves the value of the field "AM_FMFrequency" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "AM_FMFrequency".
     */
    inline T_datacollector_Audio_RadioFrequency& getAM_FMFrequencyMutable ();

    /**
     * Sets the value of the member "AM_FMFrequency".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @param AM_FMFrequency The value which will be set
     */
    inline void setAM_FMFrequency (const T_datacollector_Audio_RadioFrequency& AM_FMFrequency_);

    // API of field "AM_FMFrequencyUnit"

    static const int kAM_FMFrequencyUnit = 6;

    /**
     * Clears the field "AM_FMFrequencyUnit".
     *
     * The field will be set to its default value. The hasAM_FMFrequencyUnit()
     * method will return false.
     */
    inline void clearAM_FMFrequencyUnit();

    /**
     * Checks whether the field "AM_FMFrequencyUnit" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAM_FMFrequencyUnit()). Otherwise it will return false.
     */
    inline bool hasAM_FMFrequencyUnit () const;

    /**
     * Returns the value of the member "AM_FMFrequencyUnit".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @return The value of the field "AM_FMFrequencyUnit"
     */
    inline T_e8_datacollector_Audio_RadioFrequencyUnit getAM_FMFrequencyUnit () const;

    /**
     * Sets the value of the member "AM_FMFrequencyUnit".
     *
     * Station name of the current tuned in station of the radio source
     *
     * @param AM_FMFrequencyUnit The value which will be set
     */
    inline void setAM_FMFrequencyUnit (T_e8_datacollector_Audio_RadioFrequencyUnit AM_FMFrequencyUnit_);

    static const T_datacollector_AudioInfoUnion &getDefaultInstance();

private:

    inline void set_has_TrackName ();

    inline void clear_has_TrackName ();

    inline void set_has_TrackNumber ();

    inline void clear_has_TrackNumber ();

    inline void set_has_TrackPlayTime ();

    inline void clear_has_TrackPlayTime ();

    inline void set_has_CurrentRadioSource ();

    inline void clear_has_CurrentRadioSource ();

    inline void set_has_CurrentStationName ();

    inline void clear_has_CurrentStationName ();

    inline void set_has_AM_FMFrequency ();

    inline void clear_has_AM_FMFrequency ();

    inline void set_has_AM_FMFrequencyUnit ();

    inline void clear_has_AM_FMFrequencyUnit ();

    uint32 _has_bits_[ (7 + 31) / 32];

    ::std::string _TrackName;

    uint8 _TrackNumber;

    uint8 _TrackPlayTime;

    T_e8_datacollector_CuurentRadioSource _CurrentRadioSource;

    ::std::string _CurrentStationName;

    T_datacollector_Audio_RadioFrequency _AM_FMFrequency;

    T_e8_datacollector_Audio_RadioFrequencyUnit _AM_FMFrequencyUnit;

};

/**
 * This structure gives info on download availablility , download and update progress
 */
class T_datacollector_DownloadInfoUnion {
public:

    /**
     * Default constructor
     */
    inline  T_datacollector_DownloadInfoUnion ();

    /**
     * Copy constructor
     */
    inline  T_datacollector_DownloadInfoUnion (const T_datacollector_DownloadInfoUnion &rhs);

    /**
     * All fields constructor
     */
    inline  T_datacollector_DownloadInfoUnion (bool IsDownloadAvailable_, bool DownloadConnection_, uint8 DownloadProgress_, uint8 UpdateProgress_);

    /**
     * Destructor
     */
    inline  ~T_datacollector_DownloadInfoUnion();

    /**
     * Assignment operator
     */
    inline T_datacollector_DownloadInfoUnion& operator = (const T_datacollector_DownloadInfoUnion& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const T_datacollector_DownloadInfoUnion& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const T_datacollector_DownloadInfoUnion& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const T_datacollector_DownloadInfoUnion& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const T_datacollector_DownloadInfoUnion& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "IsDownloadAvailable"

    static const int kIsDownloadAvailable = 0;

    /**
     * Clears the field "IsDownloadAvailable".
     *
     * The field will be set to its default value. The hasIsDownloadAvailable()
     * method will return false.
     */
    inline void clearIsDownloadAvailable();

    /**
     * Checks whether the field "IsDownloadAvailable" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setIsDownloadAvailable()). Otherwise it will return false.
     */
    inline bool hasIsDownloadAvailable () const;

    /**
     * Returns the value of the member "IsDownloadAvailable".
     *
     * TRUE  : DownloadAvailable
     * FALSE : DownloadNotAvailable
     *
     * @return The value of the field "IsDownloadAvailable"
     */
    inline bool getIsDownloadAvailable () const;

    /**
     * Sets the value of the member "IsDownloadAvailable".
     *
     * TRUE  : DownloadAvailable
     * FALSE : DownloadNotAvailable
     *
     * @param IsDownloadAvailable The value which will be set
     */
    inline void setIsDownloadAvailable (bool IsDownloadAvailable_);

    // API of field "DownloadConnection"

    static const int kDownloadConnection = 1;

    /**
     * Clears the field "DownloadConnection".
     *
     * The field will be set to its default value. The hasDownloadConnection()
     * method will return false.
     */
    inline void clearDownloadConnection();

    /**
     * Checks whether the field "DownloadConnection" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadConnection()). Otherwise it will return false.
     */
    inline bool hasDownloadConnection () const;

    /**
     * Returns the value of the member "DownloadConnection".
     *
     * TRUE  : Connected
     * FALSE : NotConnected
     *
     * @return The value of the field "DownloadConnection"
     */
    inline bool getDownloadConnection () const;

    /**
     * Sets the value of the member "DownloadConnection".
     *
     * TRUE  : Connected
     * FALSE : NotConnected
     *
     * @param DownloadConnection The value which will be set
     */
    inline void setDownloadConnection (bool DownloadConnection_);

    // API of field "DownloadProgress"

    static const int kDownloadProgress = 2;

    /**
     * Clears the field "DownloadProgress".
     *
     * The field will be set to its default value. The hasDownloadProgress()
     * method will return false.
     */
    inline void clearDownloadProgress();

    /**
     * Checks whether the field "DownloadProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDownloadProgress()). Otherwise it will return false.
     */
    inline bool hasDownloadProgress () const;

    /**
     * Returns the value of the member "DownloadProgress".
     *
     * This parameter gives % of completion of Download
     *
     * @return The value of the field "DownloadProgress"
     */
    inline uint8 getDownloadProgress () const;

    /**
     * Sets the value of the member "DownloadProgress".
     *
     * This parameter gives % of completion of Download
     *
     * @param DownloadProgress The value which will be set
     */
    inline void setDownloadProgress (uint8 DownloadProgress_);

    // API of field "UpdateProgress"

    static const int kUpdateProgress = 3;

    /**
     * Clears the field "UpdateProgress".
     *
     * The field will be set to its default value. The hasUpdateProgress()
     * method will return false.
     */
    inline void clearUpdateProgress();

    /**
     * Checks whether the field "UpdateProgress" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUpdateProgress()). Otherwise it will return false.
     */
    inline bool hasUpdateProgress () const;

    /**
     * Returns the value of the member "UpdateProgress".
     *
     * This parameter gives % of completion of update
     *
     * @return The value of the field "UpdateProgress"
     */
    inline uint8 getUpdateProgress () const;

    /**
     * Sets the value of the member "UpdateProgress".
     *
     * This parameter gives % of completion of update
     *
     * @param UpdateProgress The value which will be set
     */
    inline void setUpdateProgress (uint8 UpdateProgress_);

    static const T_datacollector_DownloadInfoUnion &getDefaultInstance();

private:

    inline void set_has_IsDownloadAvailable ();

    inline void clear_has_IsDownloadAvailable ();

    inline void set_has_DownloadConnection ();

    inline void clear_has_DownloadConnection ();

    inline void set_has_DownloadProgress ();

    inline void clear_has_DownloadProgress ();

    inline void set_has_UpdateProgress ();

    inline void clear_has_UpdateProgress ();

    uint32 _has_bits_[ (4 + 31) / 32];

    bool _IsDownloadAvailable;

    bool _DownloadConnection;

    uint8 _DownloadProgress;

    uint8 _UpdateProgress;

};

inline  T_datacollector_VersionInfo::T_datacollector_VersionInfo ()  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_VersionInfo::T_datacollector_VersionInfo (const T_datacollector_VersionInfo &rhs)  :
    _u8Upper (0u),
    _u8Mid (0u),
    _u8Lower (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_VersionInfo::T_datacollector_VersionInfo (uint8 u8Upper_, uint8 u8Mid_, uint8 u8Lower_)  :
    _u8Upper (u8Upper_),
    _u8Mid (u8Mid_),
    _u8Lower (u8Lower_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_VersionInfo::~T_datacollector_VersionInfo() {
}

inline T_datacollector_VersionInfo& T_datacollector_VersionInfo::operator = (const T_datacollector_VersionInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Upper()) {
            setU8Upper(rhs.getU8Upper());
        } else {
            clearU8Upper();
        }
        if (rhs.hasU8Mid()) {
            setU8Mid(rhs.getU8Mid());
        } else {
            clearU8Mid();
        }
        if (rhs.hasU8Lower()) {
            setU8Lower(rhs.getU8Lower());
        } else {
            clearU8Lower();
        }
    }
    return *this;
}

inline bool T_datacollector_VersionInfo::operator == (const T_datacollector_VersionInfo& rhs) const {
    return (((!hasU8Upper() && !rhs.hasU8Upper()) || getU8Upper() == rhs.getU8Upper()) &&
        ((!hasU8Mid() && !rhs.hasU8Mid()) || getU8Mid() == rhs.getU8Mid()) &&
        ((!hasU8Lower() && !rhs.hasU8Lower()) || getU8Lower() == rhs.getU8Lower()));
}

inline bool T_datacollector_VersionInfo::operator != (const T_datacollector_VersionInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_VersionInfo::operator < (const T_datacollector_VersionInfo& rhs) const {
    if (hasU8Upper() || rhs.hasU8Upper()) {
        if (getU8Upper() < rhs.getU8Upper()) return true;
        if (getU8Upper() > rhs.getU8Upper()) return false;
    }
    if (hasU8Mid() || rhs.hasU8Mid()) {
        if (getU8Mid() < rhs.getU8Mid()) return true;
        if (getU8Mid() > rhs.getU8Mid()) return false;
    }
    if (hasU8Lower() || rhs.hasU8Lower()) {
        if (getU8Lower() < rhs.getU8Lower()) return true;
        if (getU8Lower() > rhs.getU8Lower()) return false;
    }
    return false;
}

inline bool T_datacollector_VersionInfo::operator > (const T_datacollector_VersionInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_VersionInfo::clear() {
    clearU8Upper();
    clearU8Mid();
    clearU8Lower();
}

inline void T_datacollector_VersionInfo::clearU8Upper() {
    if (hasU8Upper()) {
         clear_has_u8Upper();
        _u8Upper = 0u;
     }
}

inline bool T_datacollector_VersionInfo::hasU8Upper () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_datacollector_VersionInfo::getU8Upper () const {
    return _u8Upper;
}

inline void T_datacollector_VersionInfo::setU8Upper (uint8 u8Upper_) {
    set_has_u8Upper();
    this->_u8Upper = u8Upper_;
}

inline void T_datacollector_VersionInfo::clearU8Mid() {
    if (hasU8Mid()) {
         clear_has_u8Mid();
        _u8Mid = 0u;
     }
}

inline bool T_datacollector_VersionInfo::hasU8Mid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_VersionInfo::getU8Mid () const {
    return _u8Mid;
}

inline void T_datacollector_VersionInfo::setU8Mid (uint8 u8Mid_) {
    set_has_u8Mid();
    this->_u8Mid = u8Mid_;
}

inline void T_datacollector_VersionInfo::clearU8Lower() {
    if (hasU8Lower()) {
         clear_has_u8Lower();
        _u8Lower = 0u;
     }
}

inline bool T_datacollector_VersionInfo::hasU8Lower () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_VersionInfo::getU8Lower () const {
    return _u8Lower;
}

inline void T_datacollector_VersionInfo::setU8Lower (uint8 u8Lower_) {
    set_has_u8Lower();
    this->_u8Lower = u8Lower_;
}

inline void T_datacollector_VersionInfo::set_has_u8Upper () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_VersionInfo::clear_has_u8Upper () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_VersionInfo::set_has_u8Mid () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_VersionInfo::clear_has_u8Mid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_VersionInfo::set_has_u8Lower () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_VersionInfo::clear_has_u8Lower () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_datacollector_UnitConnectionStatus::T_datacollector_UnitConnectionStatus ()  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _bConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_UnitConnectionStatus::T_datacollector_UnitConnectionStatus (const T_datacollector_UnitConnectionStatus &rhs)  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _bConnected (false),
    _u8AbsenceState (0u),
    _u8MuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_UnitConnectionStatus::T_datacollector_UnitConnectionStatus (T_e8_datacollector_UnitType e8UnitType_, bool bConnected_, uint8 u8AbsenceState_, uint8 u8MuteState_)  :
    _e8UnitType (e8UnitType_),
    _bConnected (bConnected_),
    _u8AbsenceState (u8AbsenceState_),
    _u8MuteState (u8MuteState_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitConnectionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_UnitConnectionStatus::~T_datacollector_UnitConnectionStatus() {
}

inline T_datacollector_UnitConnectionStatus& T_datacollector_UnitConnectionStatus::operator = (const T_datacollector_UnitConnectionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasBConnected()) {
            setBConnected(rhs.getBConnected());
        } else {
            clearBConnected();
        }
        if (rhs.hasU8AbsenceState()) {
            setU8AbsenceState(rhs.getU8AbsenceState());
        } else {
            clearU8AbsenceState();
        }
        if (rhs.hasU8MuteState()) {
            setU8MuteState(rhs.getU8MuteState());
        } else {
            clearU8MuteState();
        }
    }
    return *this;
}

inline bool T_datacollector_UnitConnectionStatus::operator == (const T_datacollector_UnitConnectionStatus& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasBConnected() && !rhs.hasBConnected()) || getBConnected() == rhs.getBConnected()) &&
        ((!hasU8AbsenceState() && !rhs.hasU8AbsenceState()) || getU8AbsenceState() == rhs.getU8AbsenceState()) &&
        ((!hasU8MuteState() && !rhs.hasU8MuteState()) || getU8MuteState() == rhs.getU8MuteState()));
}

inline bool T_datacollector_UnitConnectionStatus::operator != (const T_datacollector_UnitConnectionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_UnitConnectionStatus::operator < (const T_datacollector_UnitConnectionStatus& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasBConnected() || rhs.hasBConnected()) {
        if (getBConnected() < rhs.getBConnected()) return true;
        if (getBConnected() > rhs.getBConnected()) return false;
    }
    if (hasU8AbsenceState() || rhs.hasU8AbsenceState()) {
        if (getU8AbsenceState() < rhs.getU8AbsenceState()) return true;
        if (getU8AbsenceState() > rhs.getU8AbsenceState()) return false;
    }
    if (hasU8MuteState() || rhs.hasU8MuteState()) {
        if (getU8MuteState() < rhs.getU8MuteState()) return true;
        if (getU8MuteState() > rhs.getU8MuteState()) return false;
    }
    return false;
}

inline bool T_datacollector_UnitConnectionStatus::operator > (const T_datacollector_UnitConnectionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_UnitConnectionStatus::clear() {
    clearE8UnitType();
    clearBConnected();
    clearU8AbsenceState();
    clearU8MuteState();
}

inline void T_datacollector_UnitConnectionStatus::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio;
     }
}

inline bool T_datacollector_UnitConnectionStatus::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_UnitType T_datacollector_UnitConnectionStatus::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_datacollector_UnitConnectionStatus::setE8UnitType (T_e8_datacollector_UnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitConnectionStatus");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_datacollector_UnitConnectionStatus::clearBConnected() {
    if (hasBConnected()) {
         clear_has_bConnected();
        _bConnected = false;
     }
}

inline bool T_datacollector_UnitConnectionStatus::hasBConnected () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_datacollector_UnitConnectionStatus::getBConnected () const {
    return _bConnected;
}

inline void T_datacollector_UnitConnectionStatus::setBConnected (bool bConnected_) {
    set_has_bConnected();
    this->_bConnected = bConnected_;
}

inline void T_datacollector_UnitConnectionStatus::clearU8AbsenceState() {
    if (hasU8AbsenceState()) {
         clear_has_u8AbsenceState();
        _u8AbsenceState = 0u;
     }
}

inline bool T_datacollector_UnitConnectionStatus::hasU8AbsenceState () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_UnitConnectionStatus::getU8AbsenceState () const {
    return _u8AbsenceState;
}

inline void T_datacollector_UnitConnectionStatus::setU8AbsenceState (uint8 u8AbsenceState_) {
    set_has_u8AbsenceState();
    this->_u8AbsenceState = u8AbsenceState_;
}

inline void T_datacollector_UnitConnectionStatus::clearU8MuteState() {
    if (hasU8MuteState()) {
         clear_has_u8MuteState();
        _u8MuteState = 0u;
     }
}

inline bool T_datacollector_UnitConnectionStatus::hasU8MuteState () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_datacollector_UnitConnectionStatus::getU8MuteState () const {
    return _u8MuteState;
}

inline void T_datacollector_UnitConnectionStatus::setU8MuteState (uint8 u8MuteState_) {
    set_has_u8MuteState();
    this->_u8MuteState = u8MuteState_;
}

inline void T_datacollector_UnitConnectionStatus::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_UnitConnectionStatus::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_UnitConnectionStatus::set_has_bConnected () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_UnitConnectionStatus::clear_has_bConnected () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_UnitConnectionStatus::set_has_u8AbsenceState () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_UnitConnectionStatus::clear_has_u8AbsenceState () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_UnitConnectionStatus::set_has_u8MuteState () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_UnitConnectionStatus::clear_has_u8MuteState () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_datacollector_UnitConfiguration::T_datacollector_UnitConfiguration ()  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _e8ConfigurationStatus (::datacollector_main_fi_types::T_e8_datacollector_ConfigurationStatus__Undefined),
    _u8UnitId (0u),
    _rMessageVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_UnitConfiguration::T_datacollector_UnitConfiguration (const T_datacollector_UnitConfiguration &rhs)  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _e8ConfigurationStatus (::datacollector_main_fi_types::T_e8_datacollector_ConfigurationStatus__Undefined),
    _u8UnitId (0u),
    _rMessageVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_UnitConfiguration::T_datacollector_UnitConfiguration (T_e8_datacollector_UnitType e8UnitType_, T_e8_datacollector_ConfigurationStatus e8ConfigurationStatus_, uint8 u8UnitId_, const T_datacollector_VersionInfo& rMessageVersion_)  :
    _e8UnitType (e8UnitType_),
    _e8ConfigurationStatus (e8ConfigurationStatus_),
    _u8UnitId (u8UnitId_),
    _rMessageVersion (rMessageVersion_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitConfiguration");
    }
    #endif
    #ifndef NDEBUG
    if (!(T_e8_datacollector_ConfigurationStatus_IsValid(e8ConfigurationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConfigurationStatus_, "T_e8_datacollector_ConfigurationStatus", "e8ConfigurationStatus", "T_datacollector_UnitConfiguration");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_UnitConfiguration::~T_datacollector_UnitConfiguration() {
}

inline T_datacollector_UnitConfiguration& T_datacollector_UnitConfiguration::operator = (const T_datacollector_UnitConfiguration& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasE8ConfigurationStatus()) {
            setE8ConfigurationStatus(rhs.getE8ConfigurationStatus());
        } else {
            clearE8ConfigurationStatus();
        }
        if (rhs.hasU8UnitId()) {
            setU8UnitId(rhs.getU8UnitId());
        } else {
            clearU8UnitId();
        }
        if (rhs.hasRMessageVersion()) {
            setRMessageVersion(rhs.getRMessageVersion());
        } else {
            clearRMessageVersion();
        }
    }
    return *this;
}

inline bool T_datacollector_UnitConfiguration::operator == (const T_datacollector_UnitConfiguration& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasE8ConfigurationStatus() && !rhs.hasE8ConfigurationStatus()) || getE8ConfigurationStatus() == rhs.getE8ConfigurationStatus()) &&
        ((!hasU8UnitId() && !rhs.hasU8UnitId()) || getU8UnitId() == rhs.getU8UnitId()) &&
        ((!hasRMessageVersion() && !rhs.hasRMessageVersion()) || getRMessageVersion() == rhs.getRMessageVersion()));
}

inline bool T_datacollector_UnitConfiguration::operator != (const T_datacollector_UnitConfiguration& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_UnitConfiguration::operator < (const T_datacollector_UnitConfiguration& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasE8ConfigurationStatus() || rhs.hasE8ConfigurationStatus()) {
        if ((uint32)getE8ConfigurationStatus() < (uint32)rhs.getE8ConfigurationStatus()) return true;
        if ((uint32)getE8ConfigurationStatus() > (uint32)rhs.getE8ConfigurationStatus()) return false;
    }
    if (hasU8UnitId() || rhs.hasU8UnitId()) {
        if (getU8UnitId() < rhs.getU8UnitId()) return true;
        if (getU8UnitId() > rhs.getU8UnitId()) return false;
    }
    if (hasRMessageVersion() || rhs.hasRMessageVersion()) {
        if (getRMessageVersion() < rhs.getRMessageVersion()) return true;
        if (getRMessageVersion() > rhs.getRMessageVersion()) return false;
    }
    return false;
}

inline bool T_datacollector_UnitConfiguration::operator > (const T_datacollector_UnitConfiguration& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_UnitConfiguration::clear() {
    clearE8UnitType();
    clearE8ConfigurationStatus();
    clearU8UnitId();
    clearRMessageVersion();
}

inline void T_datacollector_UnitConfiguration::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio;
     }
}

inline bool T_datacollector_UnitConfiguration::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_UnitType T_datacollector_UnitConfiguration::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_datacollector_UnitConfiguration::setE8UnitType (T_e8_datacollector_UnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitConfiguration");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_datacollector_UnitConfiguration::clearE8ConfigurationStatus() {
    if (hasE8ConfigurationStatus()) {
         clear_has_e8ConfigurationStatus();
        _e8ConfigurationStatus = ::datacollector_main_fi_types::T_e8_datacollector_ConfigurationStatus__Undefined;
     }
}

inline bool T_datacollector_UnitConfiguration::hasE8ConfigurationStatus () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_datacollector_ConfigurationStatus T_datacollector_UnitConfiguration::getE8ConfigurationStatus () const {
    return _e8ConfigurationStatus;
}

inline void T_datacollector_UnitConfiguration::setE8ConfigurationStatus (T_e8_datacollector_ConfigurationStatus e8ConfigurationStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_ConfigurationStatus_IsValid(e8ConfigurationStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8ConfigurationStatus_, "T_e8_datacollector_ConfigurationStatus", "e8ConfigurationStatus", "T_datacollector_UnitConfiguration");
    }
    #endif
    set_has_e8ConfigurationStatus();
    this->_e8ConfigurationStatus = e8ConfigurationStatus_;
}

inline void T_datacollector_UnitConfiguration::clearU8UnitId() {
    if (hasU8UnitId()) {
         clear_has_u8UnitId();
        _u8UnitId = 0u;
     }
}

inline bool T_datacollector_UnitConfiguration::hasU8UnitId () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_UnitConfiguration::getU8UnitId () const {
    return _u8UnitId;
}

inline void T_datacollector_UnitConfiguration::setU8UnitId (uint8 u8UnitId_) {
    set_has_u8UnitId();
    this->_u8UnitId = u8UnitId_;
}

inline void T_datacollector_UnitConfiguration::clearRMessageVersion() {
    if (hasRMessageVersion()) {
         clear_has_rMessageVersion();
        _rMessageVersion.clear();
     }
}

inline bool T_datacollector_UnitConfiguration::hasRMessageVersion () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_datacollector_VersionInfo& T_datacollector_UnitConfiguration::getRMessageVersion () const {
    return _rMessageVersion;
}

inline T_datacollector_VersionInfo& T_datacollector_UnitConfiguration::getRMessageVersionMutable () {
    set_has_rMessageVersion();
    return _rMessageVersion;
}

inline void T_datacollector_UnitConfiguration::setRMessageVersion (const T_datacollector_VersionInfo& rMessageVersion_) {
    set_has_rMessageVersion();
    this->_rMessageVersion = rMessageVersion_;
}

inline void T_datacollector_UnitConfiguration::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_UnitConfiguration::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_UnitConfiguration::set_has_e8ConfigurationStatus () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_UnitConfiguration::clear_has_e8ConfigurationStatus () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_UnitConfiguration::set_has_u8UnitId () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_UnitConfiguration::clear_has_u8UnitId () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_UnitConfiguration::set_has_rMessageVersion () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_UnitConfiguration::clear_has_rMessageVersion () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_datacollector_UnitVersion::T_datacollector_UnitVersion ()  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _rVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_UnitVersion::T_datacollector_UnitVersion (const T_datacollector_UnitVersion &rhs)  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _rVersion ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_UnitVersion::T_datacollector_UnitVersion (T_e8_datacollector_UnitType e8UnitType_, const T_datacollector_VersionInfo& rVersion_)  :
    _e8UnitType (e8UnitType_),
    _rVersion (rVersion_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitVersion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_UnitVersion::~T_datacollector_UnitVersion() {
}

inline T_datacollector_UnitVersion& T_datacollector_UnitVersion::operator = (const T_datacollector_UnitVersion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasRVersion()) {
            setRVersion(rhs.getRVersion());
        } else {
            clearRVersion();
        }
    }
    return *this;
}

inline bool T_datacollector_UnitVersion::operator == (const T_datacollector_UnitVersion& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasRVersion() && !rhs.hasRVersion()) || getRVersion() == rhs.getRVersion()));
}

inline bool T_datacollector_UnitVersion::operator != (const T_datacollector_UnitVersion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_UnitVersion::operator < (const T_datacollector_UnitVersion& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasRVersion() || rhs.hasRVersion()) {
        if (getRVersion() < rhs.getRVersion()) return true;
        if (getRVersion() > rhs.getRVersion()) return false;
    }
    return false;
}

inline bool T_datacollector_UnitVersion::operator > (const T_datacollector_UnitVersion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_UnitVersion::clear() {
    clearE8UnitType();
    clearRVersion();
}

inline void T_datacollector_UnitVersion::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio;
     }
}

inline bool T_datacollector_UnitVersion::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_UnitType T_datacollector_UnitVersion::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_datacollector_UnitVersion::setE8UnitType (T_e8_datacollector_UnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitVersion");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_datacollector_UnitVersion::clearRVersion() {
    if (hasRVersion()) {
         clear_has_rVersion();
        _rVersion.clear();
     }
}

inline bool T_datacollector_UnitVersion::hasRVersion () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_datacollector_VersionInfo& T_datacollector_UnitVersion::getRVersion () const {
    return _rVersion;
}

inline T_datacollector_VersionInfo& T_datacollector_UnitVersion::getRVersionMutable () {
    set_has_rVersion();
    return _rVersion;
}

inline void T_datacollector_UnitVersion::setRVersion (const T_datacollector_VersionInfo& rVersion_) {
    set_has_rVersion();
    this->_rVersion = rVersion_;
}

inline void T_datacollector_UnitVersion::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_UnitVersion::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_UnitVersion::set_has_rVersion () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_UnitVersion::clear_has_rVersion () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_UnitDataTransmissionStatus::T_datacollector_UnitDataTransmissionStatus ()  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _u8MPDTMuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_UnitDataTransmissionStatus::T_datacollector_UnitDataTransmissionStatus (const T_datacollector_UnitDataTransmissionStatus &rhs)  :
    _e8UnitType (::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio),
    _u8MPDTMuteState (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_UnitDataTransmissionStatus::T_datacollector_UnitDataTransmissionStatus (T_e8_datacollector_UnitType e8UnitType_, uint8 u8MPDTMuteState_)  :
    _e8UnitType (e8UnitType_),
    _u8MPDTMuteState (u8MPDTMuteState_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitDataTransmissionStatus");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_UnitDataTransmissionStatus::~T_datacollector_UnitDataTransmissionStatus() {
}

inline T_datacollector_UnitDataTransmissionStatus& T_datacollector_UnitDataTransmissionStatus::operator = (const T_datacollector_UnitDataTransmissionStatus& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8UnitType()) {
            setE8UnitType(rhs.getE8UnitType());
        } else {
            clearE8UnitType();
        }
        if (rhs.hasU8MPDTMuteState()) {
            setU8MPDTMuteState(rhs.getU8MPDTMuteState());
        } else {
            clearU8MPDTMuteState();
        }
    }
    return *this;
}

inline bool T_datacollector_UnitDataTransmissionStatus::operator == (const T_datacollector_UnitDataTransmissionStatus& rhs) const {
    return (((!hasE8UnitType() && !rhs.hasE8UnitType()) || getE8UnitType() == rhs.getE8UnitType()) &&
        ((!hasU8MPDTMuteState() && !rhs.hasU8MPDTMuteState()) || getU8MPDTMuteState() == rhs.getU8MPDTMuteState()));
}

inline bool T_datacollector_UnitDataTransmissionStatus::operator != (const T_datacollector_UnitDataTransmissionStatus& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_UnitDataTransmissionStatus::operator < (const T_datacollector_UnitDataTransmissionStatus& rhs) const {
    if (hasE8UnitType() || rhs.hasE8UnitType()) {
        if ((uint32)getE8UnitType() < (uint32)rhs.getE8UnitType()) return true;
        if ((uint32)getE8UnitType() > (uint32)rhs.getE8UnitType()) return false;
    }
    if (hasU8MPDTMuteState() || rhs.hasU8MPDTMuteState()) {
        if (getU8MPDTMuteState() < rhs.getU8MPDTMuteState()) return true;
        if (getU8MPDTMuteState() > rhs.getU8MPDTMuteState()) return false;
    }
    return false;
}

inline bool T_datacollector_UnitDataTransmissionStatus::operator > (const T_datacollector_UnitDataTransmissionStatus& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_UnitDataTransmissionStatus::clear() {
    clearE8UnitType();
    clearU8MPDTMuteState();
}

inline void T_datacollector_UnitDataTransmissionStatus::clearE8UnitType() {
    if (hasE8UnitType()) {
         clear_has_e8UnitType();
        _e8UnitType = ::datacollector_main_fi_types::T_e8_datacollector_UnitType__Audio;
     }
}

inline bool T_datacollector_UnitDataTransmissionStatus::hasE8UnitType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_UnitType T_datacollector_UnitDataTransmissionStatus::getE8UnitType () const {
    return _e8UnitType;
}

inline void T_datacollector_UnitDataTransmissionStatus::setE8UnitType (T_e8_datacollector_UnitType e8UnitType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_UnitType_IsValid(e8UnitType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8UnitType_, "T_e8_datacollector_UnitType", "e8UnitType", "T_datacollector_UnitDataTransmissionStatus");
    }
    #endif
    set_has_e8UnitType();
    this->_e8UnitType = e8UnitType_;
}

inline void T_datacollector_UnitDataTransmissionStatus::clearU8MPDTMuteState() {
    if (hasU8MPDTMuteState()) {
         clear_has_u8MPDTMuteState();
        _u8MPDTMuteState = 0u;
     }
}

inline bool T_datacollector_UnitDataTransmissionStatus::hasU8MPDTMuteState () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_UnitDataTransmissionStatus::getU8MPDTMuteState () const {
    return _u8MPDTMuteState;
}

inline void T_datacollector_UnitDataTransmissionStatus::setU8MPDTMuteState (uint8 u8MPDTMuteState_) {
    set_has_u8MPDTMuteState();
    this->_u8MPDTMuteState = u8MPDTMuteState_;
}

inline void T_datacollector_UnitDataTransmissionStatus::set_has_e8UnitType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_UnitDataTransmissionStatus::clear_has_e8UnitType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_UnitDataTransmissionStatus::set_has_u8MPDTMuteState () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_UnitDataTransmissionStatus::clear_has_u8MPDTMuteState () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_Audio_NoData::T_datacollector_Audio_NoData () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_NoData::T_datacollector_Audio_NoData (const T_datacollector_Audio_NoData &rhs) {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_NoData::~T_datacollector_Audio_NoData() {
}

inline T_datacollector_Audio_NoData& T_datacollector_Audio_NoData::operator = (const T_datacollector_Audio_NoData& rhs) {
    if( this != &rhs ) {
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool T_datacollector_Audio_NoData::operator == (const T_datacollector_Audio_NoData& ) const {
    return true;
}

inline bool T_datacollector_Audio_NoData::operator != (const T_datacollector_Audio_NoData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_NoData::operator < (const T_datacollector_Audio_NoData& ) const {
    return false;
}

inline bool T_datacollector_Audio_NoData::operator > (const T_datacollector_Audio_NoData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_NoData::clear() {
}

inline  T_datacollector_Audio_RadioLabel::T_datacollector_Audio_RadioLabel ()  :
    _e8Type (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioLabelType__None),
    _u8Id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioLabel::T_datacollector_Audio_RadioLabel (const T_datacollector_Audio_RadioLabel &rhs)  :
    _e8Type (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioLabelType__None),
    _u8Id (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_RadioLabel::T_datacollector_Audio_RadioLabel (T_e8_datacollector_Audio_RadioLabelType e8Type_, uint8 u8Id_)  :
    _e8Type (e8Type_),
    _u8Id (u8Id_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioLabelType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_datacollector_Audio_RadioLabelType", "e8Type", "T_datacollector_Audio_RadioLabel");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioLabel::~T_datacollector_Audio_RadioLabel() {
}

inline T_datacollector_Audio_RadioLabel& T_datacollector_Audio_RadioLabel::operator = (const T_datacollector_Audio_RadioLabel& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasU8Id()) {
            setU8Id(rhs.getU8Id());
        } else {
            clearU8Id();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_RadioLabel::operator == (const T_datacollector_Audio_RadioLabel& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasU8Id() && !rhs.hasU8Id()) || getU8Id() == rhs.getU8Id()));
}

inline bool T_datacollector_Audio_RadioLabel::operator != (const T_datacollector_Audio_RadioLabel& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_RadioLabel::operator < (const T_datacollector_Audio_RadioLabel& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasU8Id() || rhs.hasU8Id()) {
        if (getU8Id() < rhs.getU8Id()) return true;
        if (getU8Id() > rhs.getU8Id()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_RadioLabel::operator > (const T_datacollector_Audio_RadioLabel& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_RadioLabel::clear() {
    clearE8Type();
    clearU8Id();
}

inline void T_datacollector_Audio_RadioLabel::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioLabelType__None;
     }
}

inline bool T_datacollector_Audio_RadioLabel::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_RadioLabelType T_datacollector_Audio_RadioLabel::getE8Type () const {
    return _e8Type;
}

inline void T_datacollector_Audio_RadioLabel::setE8Type (T_e8_datacollector_Audio_RadioLabelType e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioLabelType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_datacollector_Audio_RadioLabelType", "e8Type", "T_datacollector_Audio_RadioLabel");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_datacollector_Audio_RadioLabel::clearU8Id() {
    if (hasU8Id()) {
         clear_has_u8Id();
        _u8Id = 0u;
     }
}

inline bool T_datacollector_Audio_RadioLabel::hasU8Id () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_Audio_RadioLabel::getU8Id () const {
    return _u8Id;
}

inline void T_datacollector_Audio_RadioLabel::setU8Id (uint8 u8Id_) {
    set_has_u8Id();
    this->_u8Id = u8Id_;
}

inline void T_datacollector_Audio_RadioLabel::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_RadioLabel::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_RadioLabel::set_has_u8Id () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_RadioLabel::clear_has_u8Id () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_Audio_RadioFrequency::T_datacollector_Audio_RadioFrequency ()  :
    _u8Thousands (0u),
    _u8Hundreds (0u),
    _u8Tens (0u),
    _u8Ones (0u),
    _bShowDecimalPoint (false),
    _u8Tenths (0u),
    _u8Hundredths (0u),
    _e8Unit (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioFrequency::T_datacollector_Audio_RadioFrequency (const T_datacollector_Audio_RadioFrequency &rhs)  :
    _u8Thousands (0u),
    _u8Hundreds (0u),
    _u8Tens (0u),
    _u8Ones (0u),
    _bShowDecimalPoint (false),
    _u8Tenths (0u),
    _u8Hundredths (0u),
    _e8Unit (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_RadioFrequency::T_datacollector_Audio_RadioFrequency (uint8 u8Thousands_, uint8 u8Hundreds_, uint8 u8Tens_, uint8 u8Ones_, bool bShowDecimalPoint_, uint8 u8Tenths_, uint8 u8Hundredths_, T_e8_datacollector_Audio_RadioFrequencyUnit e8Unit_)  :
    _u8Thousands (u8Thousands_),
    _u8Hundreds (u8Hundreds_),
    _u8Tens (u8Tens_),
    _u8Ones (u8Ones_),
    _bShowDecimalPoint (bShowDecimalPoint_),
    _u8Tenths (u8Tenths_),
    _u8Hundredths (u8Hundredths_),
    _e8Unit (e8Unit_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid(e8Unit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Unit_, "T_e8_datacollector_Audio_RadioFrequencyUnit", "e8Unit", "T_datacollector_Audio_RadioFrequency");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioFrequency::~T_datacollector_Audio_RadioFrequency() {
}

inline T_datacollector_Audio_RadioFrequency& T_datacollector_Audio_RadioFrequency::operator = (const T_datacollector_Audio_RadioFrequency& rhs) {
    if( this != &rhs ) {
        if (rhs.hasU8Thousands()) {
            setU8Thousands(rhs.getU8Thousands());
        } else {
            clearU8Thousands();
        }
        if (rhs.hasU8Hundreds()) {
            setU8Hundreds(rhs.getU8Hundreds());
        } else {
            clearU8Hundreds();
        }
        if (rhs.hasU8Tens()) {
            setU8Tens(rhs.getU8Tens());
        } else {
            clearU8Tens();
        }
        if (rhs.hasU8Ones()) {
            setU8Ones(rhs.getU8Ones());
        } else {
            clearU8Ones();
        }
        if (rhs.hasBShowDecimalPoint()) {
            setBShowDecimalPoint(rhs.getBShowDecimalPoint());
        } else {
            clearBShowDecimalPoint();
        }
        if (rhs.hasU8Tenths()) {
            setU8Tenths(rhs.getU8Tenths());
        } else {
            clearU8Tenths();
        }
        if (rhs.hasU8Hundredths()) {
            setU8Hundredths(rhs.getU8Hundredths());
        } else {
            clearU8Hundredths();
        }
        if (rhs.hasE8Unit()) {
            setE8Unit(rhs.getE8Unit());
        } else {
            clearE8Unit();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_RadioFrequency::operator == (const T_datacollector_Audio_RadioFrequency& rhs) const {
    return (((!hasU8Thousands() && !rhs.hasU8Thousands()) || getU8Thousands() == rhs.getU8Thousands()) &&
        ((!hasU8Hundreds() && !rhs.hasU8Hundreds()) || getU8Hundreds() == rhs.getU8Hundreds()) &&
        ((!hasU8Tens() && !rhs.hasU8Tens()) || getU8Tens() == rhs.getU8Tens()) &&
        ((!hasU8Ones() && !rhs.hasU8Ones()) || getU8Ones() == rhs.getU8Ones()) &&
        ((!hasBShowDecimalPoint() && !rhs.hasBShowDecimalPoint()) || getBShowDecimalPoint() == rhs.getBShowDecimalPoint()) &&
        ((!hasU8Tenths() && !rhs.hasU8Tenths()) || getU8Tenths() == rhs.getU8Tenths()) &&
        ((!hasU8Hundredths() && !rhs.hasU8Hundredths()) || getU8Hundredths() == rhs.getU8Hundredths()) &&
        ((!hasE8Unit() && !rhs.hasE8Unit()) || getE8Unit() == rhs.getE8Unit()));
}

inline bool T_datacollector_Audio_RadioFrequency::operator != (const T_datacollector_Audio_RadioFrequency& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_RadioFrequency::operator < (const T_datacollector_Audio_RadioFrequency& rhs) const {
    if (hasU8Thousands() || rhs.hasU8Thousands()) {
        if (getU8Thousands() < rhs.getU8Thousands()) return true;
        if (getU8Thousands() > rhs.getU8Thousands()) return false;
    }
    if (hasU8Hundreds() || rhs.hasU8Hundreds()) {
        if (getU8Hundreds() < rhs.getU8Hundreds()) return true;
        if (getU8Hundreds() > rhs.getU8Hundreds()) return false;
    }
    if (hasU8Tens() || rhs.hasU8Tens()) {
        if (getU8Tens() < rhs.getU8Tens()) return true;
        if (getU8Tens() > rhs.getU8Tens()) return false;
    }
    if (hasU8Ones() || rhs.hasU8Ones()) {
        if (getU8Ones() < rhs.getU8Ones()) return true;
        if (getU8Ones() > rhs.getU8Ones()) return false;
    }
    if (hasBShowDecimalPoint() || rhs.hasBShowDecimalPoint()) {
        if (getBShowDecimalPoint() < rhs.getBShowDecimalPoint()) return true;
        if (getBShowDecimalPoint() > rhs.getBShowDecimalPoint()) return false;
    }
    if (hasU8Tenths() || rhs.hasU8Tenths()) {
        if (getU8Tenths() < rhs.getU8Tenths()) return true;
        if (getU8Tenths() > rhs.getU8Tenths()) return false;
    }
    if (hasU8Hundredths() || rhs.hasU8Hundredths()) {
        if (getU8Hundredths() < rhs.getU8Hundredths()) return true;
        if (getU8Hundredths() > rhs.getU8Hundredths()) return false;
    }
    if (hasE8Unit() || rhs.hasE8Unit()) {
        if ((uint32)getE8Unit() < (uint32)rhs.getE8Unit()) return true;
        if ((uint32)getE8Unit() > (uint32)rhs.getE8Unit()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_RadioFrequency::operator > (const T_datacollector_Audio_RadioFrequency& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_RadioFrequency::clear() {
    clearU8Thousands();
    clearU8Hundreds();
    clearU8Tens();
    clearU8Ones();
    clearBShowDecimalPoint();
    clearU8Tenths();
    clearU8Hundredths();
    clearE8Unit();
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Thousands() {
    if (hasU8Thousands()) {
         clear_has_u8Thousands();
        _u8Thousands = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Thousands () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Thousands () const {
    return _u8Thousands;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Thousands (uint8 u8Thousands_) {
    set_has_u8Thousands();
    this->_u8Thousands = u8Thousands_;
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Hundreds() {
    if (hasU8Hundreds()) {
         clear_has_u8Hundreds();
        _u8Hundreds = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Hundreds () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Hundreds () const {
    return _u8Hundreds;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Hundreds (uint8 u8Hundreds_) {
    set_has_u8Hundreds();
    this->_u8Hundreds = u8Hundreds_;
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Tens() {
    if (hasU8Tens()) {
         clear_has_u8Tens();
        _u8Tens = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Tens () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Tens () const {
    return _u8Tens;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Tens (uint8 u8Tens_) {
    set_has_u8Tens();
    this->_u8Tens = u8Tens_;
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Ones() {
    if (hasU8Ones()) {
         clear_has_u8Ones();
        _u8Ones = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Ones () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Ones () const {
    return _u8Ones;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Ones (uint8 u8Ones_) {
    set_has_u8Ones();
    this->_u8Ones = u8Ones_;
}

inline void T_datacollector_Audio_RadioFrequency::clearBShowDecimalPoint() {
    if (hasBShowDecimalPoint()) {
         clear_has_bShowDecimalPoint();
        _bShowDecimalPoint = false;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasBShowDecimalPoint () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline bool T_datacollector_Audio_RadioFrequency::getBShowDecimalPoint () const {
    return _bShowDecimalPoint;
}

inline void T_datacollector_Audio_RadioFrequency::setBShowDecimalPoint (bool bShowDecimalPoint_) {
    set_has_bShowDecimalPoint();
    this->_bShowDecimalPoint = bShowDecimalPoint_;
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Tenths() {
    if (hasU8Tenths()) {
         clear_has_u8Tenths();
        _u8Tenths = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Tenths () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Tenths () const {
    return _u8Tenths;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Tenths (uint8 u8Tenths_) {
    set_has_u8Tenths();
    this->_u8Tenths = u8Tenths_;
}

inline void T_datacollector_Audio_RadioFrequency::clearU8Hundredths() {
    if (hasU8Hundredths()) {
         clear_has_u8Hundredths();
        _u8Hundredths = 0u;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasU8Hundredths () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline uint8 T_datacollector_Audio_RadioFrequency::getU8Hundredths () const {
    return _u8Hundredths;
}

inline void T_datacollector_Audio_RadioFrequency::setU8Hundredths (uint8 u8Hundredths_) {
    set_has_u8Hundredths();
    this->_u8Hundredths = u8Hundredths_;
}

inline void T_datacollector_Audio_RadioFrequency::clearE8Unit() {
    if (hasE8Unit()) {
         clear_has_e8Unit();
        _e8Unit = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None;
     }
}

inline bool T_datacollector_Audio_RadioFrequency::hasE8Unit () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline T_e8_datacollector_Audio_RadioFrequencyUnit T_datacollector_Audio_RadioFrequency::getE8Unit () const {
    return _e8Unit;
}

inline void T_datacollector_Audio_RadioFrequency::setE8Unit (T_e8_datacollector_Audio_RadioFrequencyUnit e8Unit_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid(e8Unit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Unit_, "T_e8_datacollector_Audio_RadioFrequencyUnit", "e8Unit", "T_datacollector_Audio_RadioFrequency");
    }
    #endif
    set_has_e8Unit();
    this->_e8Unit = e8Unit_;
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Thousands () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Thousands () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Hundreds () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Hundreds () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Tens () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Tens () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Ones () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Ones () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_bShowDecimalPoint () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_bShowDecimalPoint () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Tenths () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Tenths () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_u8Hundredths () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_u8Hundredths () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_datacollector_Audio_RadioFrequency::set_has_e8Unit () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_datacollector_Audio_RadioFrequency::clear_has_e8Unit () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_datacollector_Audio_RadioCategory::T_datacollector_Audio_RadioCategory ()  :
    _e8Type (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioCategoryType__None),
    _strCategoryName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioCategory::T_datacollector_Audio_RadioCategory (const T_datacollector_Audio_RadioCategory &rhs)  :
    _e8Type (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioCategoryType__None),
    _strCategoryName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_RadioCategory::T_datacollector_Audio_RadioCategory (T_e8_datacollector_Audio_RadioCategoryType e8Type_, const ::std::string& strCategoryName_)  :
    _e8Type (e8Type_),
    _strCategoryName (strCategoryName_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioCategoryType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_datacollector_Audio_RadioCategoryType", "e8Type", "T_datacollector_Audio_RadioCategory");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioCategory::~T_datacollector_Audio_RadioCategory() {
}

inline T_datacollector_Audio_RadioCategory& T_datacollector_Audio_RadioCategory::operator = (const T_datacollector_Audio_RadioCategory& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8Type()) {
            setE8Type(rhs.getE8Type());
        } else {
            clearE8Type();
        }
        if (rhs.hasStrCategoryName()) {
            setStrCategoryName(rhs.getStrCategoryName());
        } else {
            clearStrCategoryName();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_RadioCategory::operator == (const T_datacollector_Audio_RadioCategory& rhs) const {
    return (((!hasE8Type() && !rhs.hasE8Type()) || getE8Type() == rhs.getE8Type()) &&
        ((!hasStrCategoryName() && !rhs.hasStrCategoryName()) || getStrCategoryName() == rhs.getStrCategoryName()));
}

inline bool T_datacollector_Audio_RadioCategory::operator != (const T_datacollector_Audio_RadioCategory& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_RadioCategory::operator < (const T_datacollector_Audio_RadioCategory& rhs) const {
    if (hasE8Type() || rhs.hasE8Type()) {
        if ((uint32)getE8Type() < (uint32)rhs.getE8Type()) return true;
        if ((uint32)getE8Type() > (uint32)rhs.getE8Type()) return false;
    }
    if (hasStrCategoryName() || rhs.hasStrCategoryName()) {
        if (getStrCategoryName() < rhs.getStrCategoryName()) return true;
        if (getStrCategoryName() > rhs.getStrCategoryName()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_RadioCategory::operator > (const T_datacollector_Audio_RadioCategory& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_RadioCategory::clear() {
    clearE8Type();
    clearStrCategoryName();
}

inline void T_datacollector_Audio_RadioCategory::clearE8Type() {
    if (hasE8Type()) {
         clear_has_e8Type();
        _e8Type = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioCategoryType__None;
     }
}

inline bool T_datacollector_Audio_RadioCategory::hasE8Type () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_RadioCategoryType T_datacollector_Audio_RadioCategory::getE8Type () const {
    return _e8Type;
}

inline void T_datacollector_Audio_RadioCategory::setE8Type (T_e8_datacollector_Audio_RadioCategoryType e8Type_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioCategoryType_IsValid(e8Type_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8Type_, "T_e8_datacollector_Audio_RadioCategoryType", "e8Type", "T_datacollector_Audio_RadioCategory");
    }
    #endif
    set_has_e8Type();
    this->_e8Type = e8Type_;
}

inline void T_datacollector_Audio_RadioCategory::clearStrCategoryName() {
    if (hasStrCategoryName()) {
         clear_has_strCategoryName();
        _strCategoryName.clear();
     }
}

inline bool T_datacollector_Audio_RadioCategory::hasStrCategoryName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_datacollector_Audio_RadioCategory::getStrCategoryName () const {
    return _strCategoryName;
}

inline ::std::string& T_datacollector_Audio_RadioCategory::getStrCategoryNameMutable () {
    set_has_strCategoryName();
    return _strCategoryName;
}

inline void T_datacollector_Audio_RadioCategory::setStrCategoryName (const ::std::string& strCategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategoryName();
    this->_strCategoryName = strCategoryName_;
}

inline void T_datacollector_Audio_RadioCategory::setStrCategoryName (const char* strCategoryName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strCategoryName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategoryName();
    this->_strCategoryName.assign(strCategoryName_);
}

inline void T_datacollector_Audio_RadioCategory::setStrCategoryName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strCategoryName();
    this->_strCategoryName.assign(value, size);
}

inline void T_datacollector_Audio_RadioCategory::set_has_e8Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_RadioCategory::clear_has_e8Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_RadioCategory::set_has_strCategoryName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_RadioCategory::clear_has_strCategoryName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_Audio_RadioData::T_datacollector_Audio_RadioData ()  :
    _e8RadioSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioSource__Unknown),
    _rLabel (),
    _rFrequency (),
    _rCategory (),
    _strStationName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioData::T_datacollector_Audio_RadioData (const T_datacollector_Audio_RadioData &rhs)  :
    _e8RadioSource (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioSource__Unknown),
    _rLabel (),
    _rFrequency (),
    _rCategory (),
    _strStationName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_RadioData::T_datacollector_Audio_RadioData (T_e8_datacollector_Audio_RadioSource e8RadioSource_, const T_datacollector_Audio_RadioLabel& rLabel_, const T_datacollector_Audio_RadioFrequency& rFrequency_, const T_datacollector_Audio_RadioCategory& rCategory_, const ::std::string& strStationName_)  :
    _e8RadioSource (e8RadioSource_),
    _rLabel (rLabel_),
    _rFrequency (rFrequency_),
    _rCategory (rCategory_),
    _strStationName (strStationName_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioSource_IsValid(e8RadioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RadioSource_, "T_e8_datacollector_Audio_RadioSource", "e8RadioSource", "T_datacollector_Audio_RadioData");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_RadioData::~T_datacollector_Audio_RadioData() {
}

inline T_datacollector_Audio_RadioData& T_datacollector_Audio_RadioData::operator = (const T_datacollector_Audio_RadioData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8RadioSource()) {
            setE8RadioSource(rhs.getE8RadioSource());
        } else {
            clearE8RadioSource();
        }
        if (rhs.hasRLabel()) {
            setRLabel(rhs.getRLabel());
        } else {
            clearRLabel();
        }
        if (rhs.hasRFrequency()) {
            setRFrequency(rhs.getRFrequency());
        } else {
            clearRFrequency();
        }
        if (rhs.hasRCategory()) {
            setRCategory(rhs.getRCategory());
        } else {
            clearRCategory();
        }
        if (rhs.hasStrStationName()) {
            setStrStationName(rhs.getStrStationName());
        } else {
            clearStrStationName();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_RadioData::operator == (const T_datacollector_Audio_RadioData& rhs) const {
    return (((!hasE8RadioSource() && !rhs.hasE8RadioSource()) || getE8RadioSource() == rhs.getE8RadioSource()) &&
        ((!hasRLabel() && !rhs.hasRLabel()) || getRLabel() == rhs.getRLabel()) &&
        ((!hasRFrequency() && !rhs.hasRFrequency()) || getRFrequency() == rhs.getRFrequency()) &&
        ((!hasRCategory() && !rhs.hasRCategory()) || getRCategory() == rhs.getRCategory()) &&
        ((!hasStrStationName() && !rhs.hasStrStationName()) || getStrStationName() == rhs.getStrStationName()));
}

inline bool T_datacollector_Audio_RadioData::operator != (const T_datacollector_Audio_RadioData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_RadioData::operator < (const T_datacollector_Audio_RadioData& rhs) const {
    if (hasE8RadioSource() || rhs.hasE8RadioSource()) {
        if ((uint32)getE8RadioSource() < (uint32)rhs.getE8RadioSource()) return true;
        if ((uint32)getE8RadioSource() > (uint32)rhs.getE8RadioSource()) return false;
    }
    if (hasRLabel() || rhs.hasRLabel()) {
        if (getRLabel() < rhs.getRLabel()) return true;
        if (getRLabel() > rhs.getRLabel()) return false;
    }
    if (hasRFrequency() || rhs.hasRFrequency()) {
        if (getRFrequency() < rhs.getRFrequency()) return true;
        if (getRFrequency() > rhs.getRFrequency()) return false;
    }
    if (hasRCategory() || rhs.hasRCategory()) {
        if (getRCategory() < rhs.getRCategory()) return true;
        if (getRCategory() > rhs.getRCategory()) return false;
    }
    if (hasStrStationName() || rhs.hasStrStationName()) {
        if (getStrStationName() < rhs.getStrStationName()) return true;
        if (getStrStationName() > rhs.getStrStationName()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_RadioData::operator > (const T_datacollector_Audio_RadioData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_RadioData::clear() {
    clearE8RadioSource();
    clearRLabel();
    clearRFrequency();
    clearRCategory();
    clearStrStationName();
}

inline void T_datacollector_Audio_RadioData::clearE8RadioSource() {
    if (hasE8RadioSource()) {
         clear_has_e8RadioSource();
        _e8RadioSource = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioSource__Unknown;
     }
}

inline bool T_datacollector_Audio_RadioData::hasE8RadioSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_RadioSource T_datacollector_Audio_RadioData::getE8RadioSource () const {
    return _e8RadioSource;
}

inline void T_datacollector_Audio_RadioData::setE8RadioSource (T_e8_datacollector_Audio_RadioSource e8RadioSource_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioSource_IsValid(e8RadioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8RadioSource_, "T_e8_datacollector_Audio_RadioSource", "e8RadioSource", "T_datacollector_Audio_RadioData");
    }
    #endif
    set_has_e8RadioSource();
    this->_e8RadioSource = e8RadioSource_;
}

inline void T_datacollector_Audio_RadioData::clearRLabel() {
    if (hasRLabel()) {
         clear_has_rLabel();
        _rLabel.clear();
     }
}

inline bool T_datacollector_Audio_RadioData::hasRLabel () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_datacollector_Audio_RadioLabel& T_datacollector_Audio_RadioData::getRLabel () const {
    return _rLabel;
}

inline T_datacollector_Audio_RadioLabel& T_datacollector_Audio_RadioData::getRLabelMutable () {
    set_has_rLabel();
    return _rLabel;
}

inline void T_datacollector_Audio_RadioData::setRLabel (const T_datacollector_Audio_RadioLabel& rLabel_) {
    set_has_rLabel();
    this->_rLabel = rLabel_;
}

inline void T_datacollector_Audio_RadioData::clearRFrequency() {
    if (hasRFrequency()) {
         clear_has_rFrequency();
        _rFrequency.clear();
     }
}

inline bool T_datacollector_Audio_RadioData::hasRFrequency () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_datacollector_Audio_RadioFrequency& T_datacollector_Audio_RadioData::getRFrequency () const {
    return _rFrequency;
}

inline T_datacollector_Audio_RadioFrequency& T_datacollector_Audio_RadioData::getRFrequencyMutable () {
    set_has_rFrequency();
    return _rFrequency;
}

inline void T_datacollector_Audio_RadioData::setRFrequency (const T_datacollector_Audio_RadioFrequency& rFrequency_) {
    set_has_rFrequency();
    this->_rFrequency = rFrequency_;
}

inline void T_datacollector_Audio_RadioData::clearRCategory() {
    if (hasRCategory()) {
         clear_has_rCategory();
        _rCategory.clear();
     }
}

inline bool T_datacollector_Audio_RadioData::hasRCategory () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_datacollector_Audio_RadioCategory& T_datacollector_Audio_RadioData::getRCategory () const {
    return _rCategory;
}

inline T_datacollector_Audio_RadioCategory& T_datacollector_Audio_RadioData::getRCategoryMutable () {
    set_has_rCategory();
    return _rCategory;
}

inline void T_datacollector_Audio_RadioData::setRCategory (const T_datacollector_Audio_RadioCategory& rCategory_) {
    set_has_rCategory();
    this->_rCategory = rCategory_;
}

inline void T_datacollector_Audio_RadioData::clearStrStationName() {
    if (hasStrStationName()) {
         clear_has_strStationName();
        _strStationName.clear();
     }
}

inline bool T_datacollector_Audio_RadioData::hasStrStationName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_datacollector_Audio_RadioData::getStrStationName () const {
    return _strStationName;
}

inline ::std::string& T_datacollector_Audio_RadioData::getStrStationNameMutable () {
    set_has_strStationName();
    return _strStationName;
}

inline void T_datacollector_Audio_RadioData::setStrStationName (const ::std::string& strStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStationName();
    this->_strStationName = strStationName_;
}

inline void T_datacollector_Audio_RadioData::setStrStationName (const char* strStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStationName();
    this->_strStationName.assign(strStationName_);
}

inline void T_datacollector_Audio_RadioData::setStrStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strStationName();
    this->_strStationName.assign(value, size);
}

inline void T_datacollector_Audio_RadioData::set_has_e8RadioSource () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_RadioData::clear_has_e8RadioSource () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_RadioData::set_has_rLabel () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_RadioData::clear_has_rLabel () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_RadioData::set_has_rFrequency () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_RadioData::clear_has_rFrequency () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_Audio_RadioData::set_has_rCategory () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_Audio_RadioData::clear_has_rCategory () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_datacollector_Audio_RadioData::set_has_strStationName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_datacollector_Audio_RadioData::clear_has_strStationName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline  T_datacollector_Audio_TrackInfo::T_datacollector_Audio_TrackInfo ()  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_TrackLabelType__None),
    _u32TrackNumber (0u),
    _strTrackName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_TrackInfo::T_datacollector_Audio_TrackInfo (const T_datacollector_Audio_TrackInfo &rhs)  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_TrackLabelType__None),
    _u32TrackNumber (0u),
    _strTrackName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_TrackInfo::T_datacollector_Audio_TrackInfo (T_e8_datacollector_Audio_TrackLabelType e8LabelType_, uint32 u32TrackNumber_, const ::std::string& strTrackName_)  :
    _e8LabelType (e8LabelType_),
    _u32TrackNumber (u32TrackNumber_),
    _strTrackName (strTrackName_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_TrackLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_TrackLabelType", "e8LabelType", "T_datacollector_Audio_TrackInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_TrackInfo::~T_datacollector_Audio_TrackInfo() {
}

inline T_datacollector_Audio_TrackInfo& T_datacollector_Audio_TrackInfo::operator = (const T_datacollector_Audio_TrackInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LabelType()) {
            setE8LabelType(rhs.getE8LabelType());
        } else {
            clearE8LabelType();
        }
        if (rhs.hasU32TrackNumber()) {
            setU32TrackNumber(rhs.getU32TrackNumber());
        } else {
            clearU32TrackNumber();
        }
        if (rhs.hasStrTrackName()) {
            setStrTrackName(rhs.getStrTrackName());
        } else {
            clearStrTrackName();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_TrackInfo::operator == (const T_datacollector_Audio_TrackInfo& rhs) const {
    return (((!hasE8LabelType() && !rhs.hasE8LabelType()) || getE8LabelType() == rhs.getE8LabelType()) &&
        ((!hasU32TrackNumber() && !rhs.hasU32TrackNumber()) || getU32TrackNumber() == rhs.getU32TrackNumber()) &&
        ((!hasStrTrackName() && !rhs.hasStrTrackName()) || getStrTrackName() == rhs.getStrTrackName()));
}

inline bool T_datacollector_Audio_TrackInfo::operator != (const T_datacollector_Audio_TrackInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_TrackInfo::operator < (const T_datacollector_Audio_TrackInfo& rhs) const {
    if (hasE8LabelType() || rhs.hasE8LabelType()) {
        if ((uint32)getE8LabelType() < (uint32)rhs.getE8LabelType()) return true;
        if ((uint32)getE8LabelType() > (uint32)rhs.getE8LabelType()) return false;
    }
    if (hasU32TrackNumber() || rhs.hasU32TrackNumber()) {
        if (getU32TrackNumber() < rhs.getU32TrackNumber()) return true;
        if (getU32TrackNumber() > rhs.getU32TrackNumber()) return false;
    }
    if (hasStrTrackName() || rhs.hasStrTrackName()) {
        if (getStrTrackName() < rhs.getStrTrackName()) return true;
        if (getStrTrackName() > rhs.getStrTrackName()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_TrackInfo::operator > (const T_datacollector_Audio_TrackInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_TrackInfo::clear() {
    clearE8LabelType();
    clearU32TrackNumber();
    clearStrTrackName();
}

inline void T_datacollector_Audio_TrackInfo::clearE8LabelType() {
    if (hasE8LabelType()) {
         clear_has_e8LabelType();
        _e8LabelType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_TrackLabelType__None;
     }
}

inline bool T_datacollector_Audio_TrackInfo::hasE8LabelType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_TrackLabelType T_datacollector_Audio_TrackInfo::getE8LabelType () const {
    return _e8LabelType;
}

inline void T_datacollector_Audio_TrackInfo::setE8LabelType (T_e8_datacollector_Audio_TrackLabelType e8LabelType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_TrackLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_TrackLabelType", "e8LabelType", "T_datacollector_Audio_TrackInfo");
    }
    #endif
    set_has_e8LabelType();
    this->_e8LabelType = e8LabelType_;
}

inline void T_datacollector_Audio_TrackInfo::clearU32TrackNumber() {
    if (hasU32TrackNumber()) {
         clear_has_u32TrackNumber();
        _u32TrackNumber = 0u;
     }
}

inline bool T_datacollector_Audio_TrackInfo::hasU32TrackNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 T_datacollector_Audio_TrackInfo::getU32TrackNumber () const {
    return _u32TrackNumber;
}

inline void T_datacollector_Audio_TrackInfo::setU32TrackNumber (uint32 u32TrackNumber_) {
    set_has_u32TrackNumber();
    this->_u32TrackNumber = u32TrackNumber_;
}

inline void T_datacollector_Audio_TrackInfo::clearStrTrackName() {
    if (hasStrTrackName()) {
         clear_has_strTrackName();
        _strTrackName.clear();
     }
}

inline bool T_datacollector_Audio_TrackInfo::hasStrTrackName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_datacollector_Audio_TrackInfo::getStrTrackName () const {
    return _strTrackName;
}

inline ::std::string& T_datacollector_Audio_TrackInfo::getStrTrackNameMutable () {
    set_has_strTrackName();
    return _strTrackName;
}

inline void T_datacollector_Audio_TrackInfo::setStrTrackName (const ::std::string& strTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTrackName();
    this->_strTrackName = strTrackName_;
}

inline void T_datacollector_Audio_TrackInfo::setStrTrackName (const char* strTrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strTrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTrackName();
    this->_strTrackName.assign(strTrackName_);
}

inline void T_datacollector_Audio_TrackInfo::setStrTrackName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strTrackName();
    this->_strTrackName.assign(value, size);
}

inline void T_datacollector_Audio_TrackInfo::set_has_e8LabelType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_TrackInfo::clear_has_e8LabelType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_TrackInfo::set_has_u32TrackNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_TrackInfo::clear_has_u32TrackNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_TrackInfo::set_has_strTrackName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_TrackInfo::clear_has_strTrackName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_datacollector_Audio_GroupInfo::T_datacollector_Audio_GroupInfo ()  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_GroupLabelType__None),
    _u16GroupNumber (0u),
    _strGroupName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_GroupInfo::T_datacollector_Audio_GroupInfo (const T_datacollector_Audio_GroupInfo &rhs)  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_GroupLabelType__None),
    _u16GroupNumber (0u),
    _strGroupName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_GroupInfo::T_datacollector_Audio_GroupInfo (T_e8_datacollector_Audio_GroupLabelType e8LabelType_, uint16 u16GroupNumber_, const ::std::string& strGroupName_)  :
    _e8LabelType (e8LabelType_),
    _u16GroupNumber (u16GroupNumber_),
    _strGroupName (strGroupName_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_GroupLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_GroupLabelType", "e8LabelType", "T_datacollector_Audio_GroupInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strGroupName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_GroupInfo::~T_datacollector_Audio_GroupInfo() {
}

inline T_datacollector_Audio_GroupInfo& T_datacollector_Audio_GroupInfo::operator = (const T_datacollector_Audio_GroupInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LabelType()) {
            setE8LabelType(rhs.getE8LabelType());
        } else {
            clearE8LabelType();
        }
        if (rhs.hasU16GroupNumber()) {
            setU16GroupNumber(rhs.getU16GroupNumber());
        } else {
            clearU16GroupNumber();
        }
        if (rhs.hasStrGroupName()) {
            setStrGroupName(rhs.getStrGroupName());
        } else {
            clearStrGroupName();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_GroupInfo::operator == (const T_datacollector_Audio_GroupInfo& rhs) const {
    return (((!hasE8LabelType() && !rhs.hasE8LabelType()) || getE8LabelType() == rhs.getE8LabelType()) &&
        ((!hasU16GroupNumber() && !rhs.hasU16GroupNumber()) || getU16GroupNumber() == rhs.getU16GroupNumber()) &&
        ((!hasStrGroupName() && !rhs.hasStrGroupName()) || getStrGroupName() == rhs.getStrGroupName()));
}

inline bool T_datacollector_Audio_GroupInfo::operator != (const T_datacollector_Audio_GroupInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_GroupInfo::operator < (const T_datacollector_Audio_GroupInfo& rhs) const {
    if (hasE8LabelType() || rhs.hasE8LabelType()) {
        if ((uint32)getE8LabelType() < (uint32)rhs.getE8LabelType()) return true;
        if ((uint32)getE8LabelType() > (uint32)rhs.getE8LabelType()) return false;
    }
    if (hasU16GroupNumber() || rhs.hasU16GroupNumber()) {
        if (getU16GroupNumber() < rhs.getU16GroupNumber()) return true;
        if (getU16GroupNumber() > rhs.getU16GroupNumber()) return false;
    }
    if (hasStrGroupName() || rhs.hasStrGroupName()) {
        if (getStrGroupName() < rhs.getStrGroupName()) return true;
        if (getStrGroupName() > rhs.getStrGroupName()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_GroupInfo::operator > (const T_datacollector_Audio_GroupInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_GroupInfo::clear() {
    clearE8LabelType();
    clearU16GroupNumber();
    clearStrGroupName();
}

inline void T_datacollector_Audio_GroupInfo::clearE8LabelType() {
    if (hasE8LabelType()) {
         clear_has_e8LabelType();
        _e8LabelType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_GroupLabelType__None;
     }
}

inline bool T_datacollector_Audio_GroupInfo::hasE8LabelType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_GroupLabelType T_datacollector_Audio_GroupInfo::getE8LabelType () const {
    return _e8LabelType;
}

inline void T_datacollector_Audio_GroupInfo::setE8LabelType (T_e8_datacollector_Audio_GroupLabelType e8LabelType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_GroupLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_GroupLabelType", "e8LabelType", "T_datacollector_Audio_GroupInfo");
    }
    #endif
    set_has_e8LabelType();
    this->_e8LabelType = e8LabelType_;
}

inline void T_datacollector_Audio_GroupInfo::clearU16GroupNumber() {
    if (hasU16GroupNumber()) {
         clear_has_u16GroupNumber();
        _u16GroupNumber = 0u;
     }
}

inline bool T_datacollector_Audio_GroupInfo::hasU16GroupNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 T_datacollector_Audio_GroupInfo::getU16GroupNumber () const {
    return _u16GroupNumber;
}

inline void T_datacollector_Audio_GroupInfo::setU16GroupNumber (uint16 u16GroupNumber_) {
    set_has_u16GroupNumber();
    this->_u16GroupNumber = u16GroupNumber_;
}

inline void T_datacollector_Audio_GroupInfo::clearStrGroupName() {
    if (hasStrGroupName()) {
         clear_has_strGroupName();
        _strGroupName.clear();
     }
}

inline bool T_datacollector_Audio_GroupInfo::hasStrGroupName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_datacollector_Audio_GroupInfo::getStrGroupName () const {
    return _strGroupName;
}

inline ::std::string& T_datacollector_Audio_GroupInfo::getStrGroupNameMutable () {
    set_has_strGroupName();
    return _strGroupName;
}

inline void T_datacollector_Audio_GroupInfo::setStrGroupName (const ::std::string& strGroupName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strGroupName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strGroupName();
    this->_strGroupName = strGroupName_;
}

inline void T_datacollector_Audio_GroupInfo::setStrGroupName (const char* strGroupName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strGroupName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strGroupName();
    this->_strGroupName.assign(strGroupName_);
}

inline void T_datacollector_Audio_GroupInfo::setStrGroupName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strGroupName();
    this->_strGroupName.assign(value, size);
}

inline void T_datacollector_Audio_GroupInfo::set_has_e8LabelType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_GroupInfo::clear_has_e8LabelType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_GroupInfo::set_has_u16GroupNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_GroupInfo::clear_has_u16GroupNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_GroupInfo::set_has_strGroupName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_GroupInfo::clear_has_strGroupName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_datacollector_Audio_ArtistInfo::T_datacollector_Audio_ArtistInfo ()  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_ArtistLabelType__None),
    _strArtistName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_ArtistInfo::T_datacollector_Audio_ArtistInfo (const T_datacollector_Audio_ArtistInfo &rhs)  :
    _e8LabelType (::datacollector_main_fi_types::T_e8_datacollector_Audio_ArtistLabelType__None),
    _strArtistName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_ArtistInfo::T_datacollector_Audio_ArtistInfo (T_e8_datacollector_Audio_ArtistLabelType e8LabelType_, const ::std::string& strArtistName_)  :
    _e8LabelType (e8LabelType_),
    _strArtistName (strArtistName_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_ArtistLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_ArtistLabelType", "e8LabelType", "T_datacollector_Audio_ArtistInfo");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_ArtistInfo::~T_datacollector_Audio_ArtistInfo() {
}

inline T_datacollector_Audio_ArtistInfo& T_datacollector_Audio_ArtistInfo::operator = (const T_datacollector_Audio_ArtistInfo& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8LabelType()) {
            setE8LabelType(rhs.getE8LabelType());
        } else {
            clearE8LabelType();
        }
        if (rhs.hasStrArtistName()) {
            setStrArtistName(rhs.getStrArtistName());
        } else {
            clearStrArtistName();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_ArtistInfo::operator == (const T_datacollector_Audio_ArtistInfo& rhs) const {
    return (((!hasE8LabelType() && !rhs.hasE8LabelType()) || getE8LabelType() == rhs.getE8LabelType()) &&
        ((!hasStrArtistName() && !rhs.hasStrArtistName()) || getStrArtistName() == rhs.getStrArtistName()));
}

inline bool T_datacollector_Audio_ArtistInfo::operator != (const T_datacollector_Audio_ArtistInfo& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_ArtistInfo::operator < (const T_datacollector_Audio_ArtistInfo& rhs) const {
    if (hasE8LabelType() || rhs.hasE8LabelType()) {
        if ((uint32)getE8LabelType() < (uint32)rhs.getE8LabelType()) return true;
        if ((uint32)getE8LabelType() > (uint32)rhs.getE8LabelType()) return false;
    }
    if (hasStrArtistName() || rhs.hasStrArtistName()) {
        if (getStrArtistName() < rhs.getStrArtistName()) return true;
        if (getStrArtistName() > rhs.getStrArtistName()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_ArtistInfo::operator > (const T_datacollector_Audio_ArtistInfo& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_ArtistInfo::clear() {
    clearE8LabelType();
    clearStrArtistName();
}

inline void T_datacollector_Audio_ArtistInfo::clearE8LabelType() {
    if (hasE8LabelType()) {
         clear_has_e8LabelType();
        _e8LabelType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_ArtistLabelType__None;
     }
}

inline bool T_datacollector_Audio_ArtistInfo::hasE8LabelType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_ArtistLabelType T_datacollector_Audio_ArtistInfo::getE8LabelType () const {
    return _e8LabelType;
}

inline void T_datacollector_Audio_ArtistInfo::setE8LabelType (T_e8_datacollector_Audio_ArtistLabelType e8LabelType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_ArtistLabelType_IsValid(e8LabelType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8LabelType_, "T_e8_datacollector_Audio_ArtistLabelType", "e8LabelType", "T_datacollector_Audio_ArtistInfo");
    }
    #endif
    set_has_e8LabelType();
    this->_e8LabelType = e8LabelType_;
}

inline void T_datacollector_Audio_ArtistInfo::clearStrArtistName() {
    if (hasStrArtistName()) {
         clear_has_strArtistName();
        _strArtistName.clear();
     }
}

inline bool T_datacollector_Audio_ArtistInfo::hasStrArtistName () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& T_datacollector_Audio_ArtistInfo::getStrArtistName () const {
    return _strArtistName;
}

inline ::std::string& T_datacollector_Audio_ArtistInfo::getStrArtistNameMutable () {
    set_has_strArtistName();
    return _strArtistName;
}

inline void T_datacollector_Audio_ArtistInfo::setStrArtistName (const ::std::string& strArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strArtistName();
    this->_strArtistName = strArtistName_;
}

inline void T_datacollector_Audio_ArtistInfo::setStrArtistName (const char* strArtistName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strArtistName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strArtistName();
    this->_strArtistName.assign(strArtistName_);
}

inline void T_datacollector_Audio_ArtistInfo::setStrArtistName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strArtistName();
    this->_strArtistName.assign(value, size);
}

inline void T_datacollector_Audio_ArtistInfo::set_has_e8LabelType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_ArtistInfo::clear_has_e8LabelType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_ArtistInfo::set_has_strArtistName () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_ArtistInfo::clear_has_strArtistName () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_Audio_MediaData::T_datacollector_Audio_MediaData ()  :
    _e8MediaType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaType__Unknown),
    _rTrackInfo (),
    _rGroupInfo (),
    _rArtistInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_MediaData::T_datacollector_Audio_MediaData (const T_datacollector_Audio_MediaData &rhs)  :
    _e8MediaType (::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaType__Unknown),
    _rTrackInfo (),
    _rGroupInfo (),
    _rArtistInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_MediaData::T_datacollector_Audio_MediaData (T_e8_datacollector_Audio_MediaType e8MediaType_, const T_datacollector_Audio_TrackInfo& rTrackInfo_, const T_datacollector_Audio_GroupInfo& rGroupInfo_, const T_datacollector_Audio_ArtistInfo& rArtistInfo_)  :
    _e8MediaType (e8MediaType_),
    _rTrackInfo (rTrackInfo_),
    _rGroupInfo (rGroupInfo_),
    _rArtistInfo (rArtistInfo_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_MediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_datacollector_Audio_MediaType", "e8MediaType", "T_datacollector_Audio_MediaData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_MediaData::~T_datacollector_Audio_MediaData() {
}

inline T_datacollector_Audio_MediaData& T_datacollector_Audio_MediaData::operator = (const T_datacollector_Audio_MediaData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8MediaType()) {
            setE8MediaType(rhs.getE8MediaType());
        } else {
            clearE8MediaType();
        }
        if (rhs.hasRTrackInfo()) {
            setRTrackInfo(rhs.getRTrackInfo());
        } else {
            clearRTrackInfo();
        }
        if (rhs.hasRGroupInfo()) {
            setRGroupInfo(rhs.getRGroupInfo());
        } else {
            clearRGroupInfo();
        }
        if (rhs.hasRArtistInfo()) {
            setRArtistInfo(rhs.getRArtistInfo());
        } else {
            clearRArtistInfo();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_MediaData::operator == (const T_datacollector_Audio_MediaData& rhs) const {
    return (((!hasE8MediaType() && !rhs.hasE8MediaType()) || getE8MediaType() == rhs.getE8MediaType()) &&
        ((!hasRTrackInfo() && !rhs.hasRTrackInfo()) || getRTrackInfo() == rhs.getRTrackInfo()) &&
        ((!hasRGroupInfo() && !rhs.hasRGroupInfo()) || getRGroupInfo() == rhs.getRGroupInfo()) &&
        ((!hasRArtistInfo() && !rhs.hasRArtistInfo()) || getRArtistInfo() == rhs.getRArtistInfo()));
}

inline bool T_datacollector_Audio_MediaData::operator != (const T_datacollector_Audio_MediaData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_MediaData::operator < (const T_datacollector_Audio_MediaData& rhs) const {
    if (hasE8MediaType() || rhs.hasE8MediaType()) {
        if ((uint32)getE8MediaType() < (uint32)rhs.getE8MediaType()) return true;
        if ((uint32)getE8MediaType() > (uint32)rhs.getE8MediaType()) return false;
    }
    if (hasRTrackInfo() || rhs.hasRTrackInfo()) {
        if (getRTrackInfo() < rhs.getRTrackInfo()) return true;
        if (getRTrackInfo() > rhs.getRTrackInfo()) return false;
    }
    if (hasRGroupInfo() || rhs.hasRGroupInfo()) {
        if (getRGroupInfo() < rhs.getRGroupInfo()) return true;
        if (getRGroupInfo() > rhs.getRGroupInfo()) return false;
    }
    if (hasRArtistInfo() || rhs.hasRArtistInfo()) {
        if (getRArtistInfo() < rhs.getRArtistInfo()) return true;
        if (getRArtistInfo() > rhs.getRArtistInfo()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_MediaData::operator > (const T_datacollector_Audio_MediaData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_MediaData::clear() {
    clearE8MediaType();
    clearRTrackInfo();
    clearRGroupInfo();
    clearRArtistInfo();
}

inline void T_datacollector_Audio_MediaData::clearE8MediaType() {
    if (hasE8MediaType()) {
         clear_has_e8MediaType();
        _e8MediaType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_MediaType__Unknown;
     }
}

inline bool T_datacollector_Audio_MediaData::hasE8MediaType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_MediaType T_datacollector_Audio_MediaData::getE8MediaType () const {
    return _e8MediaType;
}

inline void T_datacollector_Audio_MediaData::setE8MediaType (T_e8_datacollector_Audio_MediaType e8MediaType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_MediaType_IsValid(e8MediaType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8MediaType_, "T_e8_datacollector_Audio_MediaType", "e8MediaType", "T_datacollector_Audio_MediaData");
    }
    #endif
    set_has_e8MediaType();
    this->_e8MediaType = e8MediaType_;
}

inline void T_datacollector_Audio_MediaData::clearRTrackInfo() {
    if (hasRTrackInfo()) {
         clear_has_rTrackInfo();
        _rTrackInfo.clear();
     }
}

inline bool T_datacollector_Audio_MediaData::hasRTrackInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_datacollector_Audio_TrackInfo& T_datacollector_Audio_MediaData::getRTrackInfo () const {
    return _rTrackInfo;
}

inline T_datacollector_Audio_TrackInfo& T_datacollector_Audio_MediaData::getRTrackInfoMutable () {
    set_has_rTrackInfo();
    return _rTrackInfo;
}

inline void T_datacollector_Audio_MediaData::setRTrackInfo (const T_datacollector_Audio_TrackInfo& rTrackInfo_) {
    set_has_rTrackInfo();
    this->_rTrackInfo = rTrackInfo_;
}

inline void T_datacollector_Audio_MediaData::clearRGroupInfo() {
    if (hasRGroupInfo()) {
         clear_has_rGroupInfo();
        _rGroupInfo.clear();
     }
}

inline bool T_datacollector_Audio_MediaData::hasRGroupInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_datacollector_Audio_GroupInfo& T_datacollector_Audio_MediaData::getRGroupInfo () const {
    return _rGroupInfo;
}

inline T_datacollector_Audio_GroupInfo& T_datacollector_Audio_MediaData::getRGroupInfoMutable () {
    set_has_rGroupInfo();
    return _rGroupInfo;
}

inline void T_datacollector_Audio_MediaData::setRGroupInfo (const T_datacollector_Audio_GroupInfo& rGroupInfo_) {
    set_has_rGroupInfo();
    this->_rGroupInfo = rGroupInfo_;
}

inline void T_datacollector_Audio_MediaData::clearRArtistInfo() {
    if (hasRArtistInfo()) {
         clear_has_rArtistInfo();
        _rArtistInfo.clear();
     }
}

inline bool T_datacollector_Audio_MediaData::hasRArtistInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_datacollector_Audio_ArtistInfo& T_datacollector_Audio_MediaData::getRArtistInfo () const {
    return _rArtistInfo;
}

inline T_datacollector_Audio_ArtistInfo& T_datacollector_Audio_MediaData::getRArtistInfoMutable () {
    set_has_rArtistInfo();
    return _rArtistInfo;
}

inline void T_datacollector_Audio_MediaData::setRArtistInfo (const T_datacollector_Audio_ArtistInfo& rArtistInfo_) {
    set_has_rArtistInfo();
    this->_rArtistInfo = rArtistInfo_;
}

inline void T_datacollector_Audio_MediaData::set_has_e8MediaType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_MediaData::clear_has_e8MediaType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_MediaData::set_has_rTrackInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_MediaData::clear_has_rTrackInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_MediaData::set_has_rGroupInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_MediaData::clear_has_rGroupInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_Audio_MediaData::set_has_rArtistInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_Audio_MediaData::clear_has_rArtistInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_datacollector_Audio_AuxData::T_datacollector_Audio_AuxData ()  :
    _e8AuxType (::datacollector_main_fi_types::T_e8_datacollector_Audio_AuxType__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_AuxData::T_datacollector_Audio_AuxData (const T_datacollector_Audio_AuxData &rhs)  :
    _e8AuxType (::datacollector_main_fi_types::T_e8_datacollector_Audio_AuxType__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_AuxData::T_datacollector_Audio_AuxData (T_e8_datacollector_Audio_AuxType e8AuxType_)  :
    _e8AuxType (e8AuxType_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_AuxType_IsValid(e8AuxType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AuxType_, "T_e8_datacollector_Audio_AuxType", "e8AuxType", "T_datacollector_Audio_AuxData");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_AuxData::~T_datacollector_Audio_AuxData() {
}

inline T_datacollector_Audio_AuxData& T_datacollector_Audio_AuxData::operator = (const T_datacollector_Audio_AuxData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasE8AuxType()) {
            setE8AuxType(rhs.getE8AuxType());
        } else {
            clearE8AuxType();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_AuxData::operator == (const T_datacollector_Audio_AuxData& rhs) const {
    return (((!hasE8AuxType() && !rhs.hasE8AuxType()) || getE8AuxType() == rhs.getE8AuxType()));
}

inline bool T_datacollector_Audio_AuxData::operator != (const T_datacollector_Audio_AuxData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_AuxData::operator < (const T_datacollector_Audio_AuxData& rhs) const {
    if (hasE8AuxType() || rhs.hasE8AuxType()) {
        if ((uint32)getE8AuxType() < (uint32)rhs.getE8AuxType()) return true;
        if ((uint32)getE8AuxType() > (uint32)rhs.getE8AuxType()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_AuxData::operator > (const T_datacollector_Audio_AuxData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_AuxData::clear() {
    clearE8AuxType();
}

inline void T_datacollector_Audio_AuxData::clearE8AuxType() {
    if (hasE8AuxType()) {
         clear_has_e8AuxType();
        _e8AuxType = ::datacollector_main_fi_types::T_e8_datacollector_Audio_AuxType__Unknown;
     }
}

inline bool T_datacollector_Audio_AuxData::hasE8AuxType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_Audio_AuxType T_datacollector_Audio_AuxData::getE8AuxType () const {
    return _e8AuxType;
}

inline void T_datacollector_Audio_AuxData::setE8AuxType (T_e8_datacollector_Audio_AuxType e8AuxType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_AuxType_IsValid(e8AuxType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", e8AuxType_, "T_e8_datacollector_Audio_AuxType", "e8AuxType", "T_datacollector_Audio_AuxData");
    }
    #endif
    set_has_e8AuxType();
    this->_e8AuxType = e8AuxType_;
}

inline void T_datacollector_Audio_AuxData::set_has_e8AuxType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_AuxData::clear_has_e8AuxType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  T_datacollector_Audio_ExternalSoundData::T_datacollector_Audio_ExternalSoundData () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_ExternalSoundData::T_datacollector_Audio_ExternalSoundData (const T_datacollector_Audio_ExternalSoundData &rhs) {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_ExternalSoundData::~T_datacollector_Audio_ExternalSoundData() {
}

inline T_datacollector_Audio_ExternalSoundData& T_datacollector_Audio_ExternalSoundData::operator = (const T_datacollector_Audio_ExternalSoundData& rhs) {
    if( this != &rhs ) {
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool T_datacollector_Audio_ExternalSoundData::operator == (const T_datacollector_Audio_ExternalSoundData& ) const {
    return true;
}

inline bool T_datacollector_Audio_ExternalSoundData::operator != (const T_datacollector_Audio_ExternalSoundData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_ExternalSoundData::operator < (const T_datacollector_Audio_ExternalSoundData& ) const {
    return false;
}

inline bool T_datacollector_Audio_ExternalSoundData::operator > (const T_datacollector_Audio_ExternalSoundData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_ExternalSoundData::clear() {
}

inline  T_datacollector_Audio_InternetRadioData::T_datacollector_Audio_InternetRadioData ()  :
    _strSourceName (),
    _rTrackInfo (),
    _rGroupInfo (),
    _rArtistInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_InternetRadioData::T_datacollector_Audio_InternetRadioData (const T_datacollector_Audio_InternetRadioData &rhs)  :
    _strSourceName (),
    _rTrackInfo (),
    _rGroupInfo (),
    _rArtistInfo ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_Audio_InternetRadioData::T_datacollector_Audio_InternetRadioData (const ::std::string& strSourceName_, const T_datacollector_Audio_TrackInfo& rTrackInfo_, const T_datacollector_Audio_GroupInfo& rGroupInfo_, const T_datacollector_Audio_ArtistInfo& rArtistInfo_)  :
    _strSourceName (strSourceName_),
    _rTrackInfo (rTrackInfo_),
    _rGroupInfo (rGroupInfo_),
    _rArtistInfo (rArtistInfo_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_Audio_InternetRadioData::~T_datacollector_Audio_InternetRadioData() {
}

inline T_datacollector_Audio_InternetRadioData& T_datacollector_Audio_InternetRadioData::operator = (const T_datacollector_Audio_InternetRadioData& rhs) {
    if( this != &rhs ) {
        if (rhs.hasStrSourceName()) {
            setStrSourceName(rhs.getStrSourceName());
        } else {
            clearStrSourceName();
        }
        if (rhs.hasRTrackInfo()) {
            setRTrackInfo(rhs.getRTrackInfo());
        } else {
            clearRTrackInfo();
        }
        if (rhs.hasRGroupInfo()) {
            setRGroupInfo(rhs.getRGroupInfo());
        } else {
            clearRGroupInfo();
        }
        if (rhs.hasRArtistInfo()) {
            setRArtistInfo(rhs.getRArtistInfo());
        } else {
            clearRArtistInfo();
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_InternetRadioData::operator == (const T_datacollector_Audio_InternetRadioData& rhs) const {
    return (((!hasStrSourceName() && !rhs.hasStrSourceName()) || getStrSourceName() == rhs.getStrSourceName()) &&
        ((!hasRTrackInfo() && !rhs.hasRTrackInfo()) || getRTrackInfo() == rhs.getRTrackInfo()) &&
        ((!hasRGroupInfo() && !rhs.hasRGroupInfo()) || getRGroupInfo() == rhs.getRGroupInfo()) &&
        ((!hasRArtistInfo() && !rhs.hasRArtistInfo()) || getRArtistInfo() == rhs.getRArtistInfo()));
}

inline bool T_datacollector_Audio_InternetRadioData::operator != (const T_datacollector_Audio_InternetRadioData& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_InternetRadioData::operator < (const T_datacollector_Audio_InternetRadioData& rhs) const {
    if (hasStrSourceName() || rhs.hasStrSourceName()) {
        if (getStrSourceName() < rhs.getStrSourceName()) return true;
        if (getStrSourceName() > rhs.getStrSourceName()) return false;
    }
    if (hasRTrackInfo() || rhs.hasRTrackInfo()) {
        if (getRTrackInfo() < rhs.getRTrackInfo()) return true;
        if (getRTrackInfo() > rhs.getRTrackInfo()) return false;
    }
    if (hasRGroupInfo() || rhs.hasRGroupInfo()) {
        if (getRGroupInfo() < rhs.getRGroupInfo()) return true;
        if (getRGroupInfo() > rhs.getRGroupInfo()) return false;
    }
    if (hasRArtistInfo() || rhs.hasRArtistInfo()) {
        if (getRArtistInfo() < rhs.getRArtistInfo()) return true;
        if (getRArtistInfo() > rhs.getRArtistInfo()) return false;
    }
    return false;
}

inline bool T_datacollector_Audio_InternetRadioData::operator > (const T_datacollector_Audio_InternetRadioData& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_Audio_InternetRadioData::clear() {
    clearStrSourceName();
    clearRTrackInfo();
    clearRGroupInfo();
    clearRArtistInfo();
}

inline void T_datacollector_Audio_InternetRadioData::clearStrSourceName() {
    if (hasStrSourceName()) {
         clear_has_strSourceName();
        _strSourceName.clear();
     }
}

inline bool T_datacollector_Audio_InternetRadioData::hasStrSourceName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_datacollector_Audio_InternetRadioData::getStrSourceName () const {
    return _strSourceName;
}

inline ::std::string& T_datacollector_Audio_InternetRadioData::getStrSourceNameMutable () {
    set_has_strSourceName();
    return _strSourceName;
}

inline void T_datacollector_Audio_InternetRadioData::setStrSourceName (const ::std::string& strSourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName = strSourceName_;
}

inline void T_datacollector_Audio_InternetRadioData::setStrSourceName (const char* strSourceName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (strSourceName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName.assign(strSourceName_);
}

inline void T_datacollector_Audio_InternetRadioData::setStrSourceName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_strSourceName();
    this->_strSourceName.assign(value, size);
}

inline void T_datacollector_Audio_InternetRadioData::clearRTrackInfo() {
    if (hasRTrackInfo()) {
         clear_has_rTrackInfo();
        _rTrackInfo.clear();
     }
}

inline bool T_datacollector_Audio_InternetRadioData::hasRTrackInfo () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const T_datacollector_Audio_TrackInfo& T_datacollector_Audio_InternetRadioData::getRTrackInfo () const {
    return _rTrackInfo;
}

inline T_datacollector_Audio_TrackInfo& T_datacollector_Audio_InternetRadioData::getRTrackInfoMutable () {
    set_has_rTrackInfo();
    return _rTrackInfo;
}

inline void T_datacollector_Audio_InternetRadioData::setRTrackInfo (const T_datacollector_Audio_TrackInfo& rTrackInfo_) {
    set_has_rTrackInfo();
    this->_rTrackInfo = rTrackInfo_;
}

inline void T_datacollector_Audio_InternetRadioData::clearRGroupInfo() {
    if (hasRGroupInfo()) {
         clear_has_rGroupInfo();
        _rGroupInfo.clear();
     }
}

inline bool T_datacollector_Audio_InternetRadioData::hasRGroupInfo () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const T_datacollector_Audio_GroupInfo& T_datacollector_Audio_InternetRadioData::getRGroupInfo () const {
    return _rGroupInfo;
}

inline T_datacollector_Audio_GroupInfo& T_datacollector_Audio_InternetRadioData::getRGroupInfoMutable () {
    set_has_rGroupInfo();
    return _rGroupInfo;
}

inline void T_datacollector_Audio_InternetRadioData::setRGroupInfo (const T_datacollector_Audio_GroupInfo& rGroupInfo_) {
    set_has_rGroupInfo();
    this->_rGroupInfo = rGroupInfo_;
}

inline void T_datacollector_Audio_InternetRadioData::clearRArtistInfo() {
    if (hasRArtistInfo()) {
         clear_has_rArtistInfo();
        _rArtistInfo.clear();
     }
}

inline bool T_datacollector_Audio_InternetRadioData::hasRArtistInfo () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const T_datacollector_Audio_ArtistInfo& T_datacollector_Audio_InternetRadioData::getRArtistInfo () const {
    return _rArtistInfo;
}

inline T_datacollector_Audio_ArtistInfo& T_datacollector_Audio_InternetRadioData::getRArtistInfoMutable () {
    set_has_rArtistInfo();
    return _rArtistInfo;
}

inline void T_datacollector_Audio_InternetRadioData::setRArtistInfo (const T_datacollector_Audio_ArtistInfo& rArtistInfo_) {
    set_has_rArtistInfo();
    this->_rArtistInfo = rArtistInfo_;
}

inline void T_datacollector_Audio_InternetRadioData::set_has_strSourceName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_Audio_InternetRadioData::clear_has_strSourceName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_Audio_InternetRadioData::set_has_rTrackInfo () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_Audio_InternetRadioData::clear_has_rTrackInfo () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_Audio_InternetRadioData::set_has_rGroupInfo () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_Audio_InternetRadioData::clear_has_rGroupInfo () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_Audio_InternetRadioData::set_has_rArtistInfo () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_Audio_InternetRadioData::clear_has_rArtistInfo () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnion () :
    __field (E_T_DATACOLLECTOR_AUDIO_NO_DATA),
    _data()
{
    _data.T_datacollector_Audio_NoData_ = NULL;
}

inline  T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnion (const T_datacollector_Audio_SourceInfoUnion& rhs) :
    __field (E_T_DATACOLLECTOR_AUDIO_NO_DATA),
    _data()
{
    _data.T_datacollector_Audio_NoData_ = NULL;
    *this = rhs;
}

inline  T_datacollector_Audio_SourceInfoUnion::~T_datacollector_Audio_SourceInfoUnion() {
    deleteData ();
}

inline T_datacollector_Audio_SourceInfoUnion& T_datacollector_Audio_SourceInfoUnion::operator = (const T_datacollector_Audio_SourceInfoUnion& rhs) {
    if( this != &rhs ) {
        if (__field == rhs.__field) {
            cloneData (rhs);
        } else {
            deleteData ();
            cloneData (rhs);
        }
    }
    return *this;
}

inline bool T_datacollector_Audio_SourceInfoUnion::operator == (const T_datacollector_Audio_SourceInfoUnion& rhs) const {
    if (__field == rhs.__field) {
        switch (__field) {
        case E_T_DATACOLLECTOR_AUDIO_NO_DATA:
            if (_data.T_datacollector_Audio_NoData_ == NULL && rhs._data.T_datacollector_Audio_NoData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_NoData() == rhs.getT_datacollector_Audio_NoData());
        case E_T_DATACOLLECTOR_AUDIO_RADIO_DATA:
            if (_data.T_datacollector_Audio_RadioData_ == NULL && rhs._data.T_datacollector_Audio_RadioData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_RadioData() == rhs.getT_datacollector_Audio_RadioData());
        case E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA:
            if (_data.T_datacollector_Audio_MediaData_ == NULL && rhs._data.T_datacollector_Audio_MediaData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_MediaData() == rhs.getT_datacollector_Audio_MediaData());
        case E_T_DATACOLLECTOR_AUDIO_AUX_DATA:
            if (_data.T_datacollector_Audio_AuxData_ == NULL && rhs._data.T_datacollector_Audio_AuxData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_AuxData() == rhs.getT_datacollector_Audio_AuxData());
        case E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA:
            if (_data.T_datacollector_Audio_ExternalSoundData_ == NULL && rhs._data.T_datacollector_Audio_ExternalSoundData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_ExternalSoundData() == rhs.getT_datacollector_Audio_ExternalSoundData());
        case E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA:
            if (_data.T_datacollector_Audio_InternetRadioData_ == NULL && rhs._data.T_datacollector_Audio_InternetRadioData_ == NULL) {
                return true;
            }
            return (getT_datacollector_Audio_InternetRadioData() == rhs.getT_datacollector_Audio_InternetRadioData());
        default:
            return false;
        }
    }
    return false;
}

inline bool T_datacollector_Audio_SourceInfoUnion::operator != (const T_datacollector_Audio_SourceInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_Audio_SourceInfoUnion::operator < (const T_datacollector_Audio_SourceInfoUnion& rhs) const  {
    if (hasT_datacollector_Audio_NoData() && rhs.hasT_datacollector_Audio_NoData()) {
        if (getT_datacollector_Audio_NoData() < rhs.getT_datacollector_Audio_NoData()) return true;
        if (getT_datacollector_Audio_NoData() > rhs.getT_datacollector_Audio_NoData()) return false;
    } else {
        if (hasT_datacollector_Audio_NoData() && !rhs.hasT_datacollector_Audio_NoData())
            return true;
        else if (!hasT_datacollector_Audio_NoData() && rhs.hasT_datacollector_Audio_NoData())
            return false;
    }

    if (hasT_datacollector_Audio_RadioData() && rhs.hasT_datacollector_Audio_RadioData()) {
        if (getT_datacollector_Audio_RadioData() < rhs.getT_datacollector_Audio_RadioData()) return true;
        if (getT_datacollector_Audio_RadioData() > rhs.getT_datacollector_Audio_RadioData()) return false;
    } else {
        if (hasT_datacollector_Audio_RadioData() && !rhs.hasT_datacollector_Audio_RadioData())
            return true;
        else if (!hasT_datacollector_Audio_RadioData() && rhs.hasT_datacollector_Audio_RadioData())
            return false;
    }

    if (hasT_datacollector_Audio_MediaData() && rhs.hasT_datacollector_Audio_MediaData()) {
        if (getT_datacollector_Audio_MediaData() < rhs.getT_datacollector_Audio_MediaData()) return true;
        if (getT_datacollector_Audio_MediaData() > rhs.getT_datacollector_Audio_MediaData()) return false;
    } else {
        if (hasT_datacollector_Audio_MediaData() && !rhs.hasT_datacollector_Audio_MediaData())
            return true;
        else if (!hasT_datacollector_Audio_MediaData() && rhs.hasT_datacollector_Audio_MediaData())
            return false;
    }

    if (hasT_datacollector_Audio_AuxData() && rhs.hasT_datacollector_Audio_AuxData()) {
        if (getT_datacollector_Audio_AuxData() < rhs.getT_datacollector_Audio_AuxData()) return true;
        if (getT_datacollector_Audio_AuxData() > rhs.getT_datacollector_Audio_AuxData()) return false;
    } else {
        if (hasT_datacollector_Audio_AuxData() && !rhs.hasT_datacollector_Audio_AuxData())
            return true;
        else if (!hasT_datacollector_Audio_AuxData() && rhs.hasT_datacollector_Audio_AuxData())
            return false;
    }

    if (hasT_datacollector_Audio_ExternalSoundData() && rhs.hasT_datacollector_Audio_ExternalSoundData()) {
        if (getT_datacollector_Audio_ExternalSoundData() < rhs.getT_datacollector_Audio_ExternalSoundData()) return true;
        if (getT_datacollector_Audio_ExternalSoundData() > rhs.getT_datacollector_Audio_ExternalSoundData()) return false;
    } else {
        if (hasT_datacollector_Audio_ExternalSoundData() && !rhs.hasT_datacollector_Audio_ExternalSoundData())
            return true;
        else if (!hasT_datacollector_Audio_ExternalSoundData() && rhs.hasT_datacollector_Audio_ExternalSoundData())
            return false;
    }

    if (hasT_datacollector_Audio_InternetRadioData() && rhs.hasT_datacollector_Audio_InternetRadioData()) {
        if (getT_datacollector_Audio_InternetRadioData() < rhs.getT_datacollector_Audio_InternetRadioData()) return true;
        if (getT_datacollector_Audio_InternetRadioData() > rhs.getT_datacollector_Audio_InternetRadioData()) return false;
    } else {
        if (hasT_datacollector_Audio_InternetRadioData() && !rhs.hasT_datacollector_Audio_InternetRadioData())
            return true;
        else if (!hasT_datacollector_Audio_InternetRadioData() && rhs.hasT_datacollector_Audio_InternetRadioData())
            return false;
    }

    return false;
}

inline bool T_datacollector_Audio_SourceInfoUnion::operator > (const T_datacollector_Audio_SourceInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnionField T_datacollector_Audio_SourceInfoUnion::getField () const {
    return __field;
}

inline void T_datacollector_Audio_SourceInfoUnion::setField(T_datacollector_Audio_SourceInfoUnion::T_datacollector_Audio_SourceInfoUnionField field) {
    deleteData();
    __field = field;
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_NoData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_NO_DATA;
}

inline const T_datacollector_Audio_NoData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_NoData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_NoData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_NoData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_NoData()) {
        if (_data.T_datacollector_Audio_NoData_ == NULL) {
            return T_datacollector_Audio_NoData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_NoData_;
    }
    abort();
}

inline T_datacollector_Audio_NoData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_NoDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_NoData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_NoData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_NoData()) {
        if (_data.T_datacollector_Audio_NoData_ == NULL) {
            _data.T_datacollector_Audio_NoData_ = new T_datacollector_Audio_NoData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_NoData_ );
        }
        return *_data.T_datacollector_Audio_NoData_;
    }
    abort();
}

inline T_datacollector_Audio_NoData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_NoData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_NoData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_NoData()) {
        if (_data.T_datacollector_Audio_NoData_ == NULL) {
            _data.T_datacollector_Audio_NoData_ = new T_datacollector_Audio_NoData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_NoData_ );
        }
        T_datacollector_Audio_NoData* temp = _data.T_datacollector_Audio_NoData_;
        _data.T_datacollector_Audio_NoData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_NoData (T_datacollector_Audio_NoData* T_datacollector_Audio_NoData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_NO_DATA || _data.T_datacollector_Audio_NoData_ != T_datacollector_Audio_NoData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_NO_DATA;
        _data.T_datacollector_Audio_NoData_ = T_datacollector_Audio_NoData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_NoData (const T_datacollector_Audio_NoData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_NO_DATA && _data.T_datacollector_Audio_NoData_ != NULL) {
        *_data.T_datacollector_Audio_NoData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_NO_DATA;
        _data.T_datacollector_Audio_NoData_ = new T_datacollector_Audio_NoData(value);
    }
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_RadioData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_RADIO_DATA;
}

inline const T_datacollector_Audio_RadioData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_RadioData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_RadioData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_RadioData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_RadioData()) {
        if (_data.T_datacollector_Audio_RadioData_ == NULL) {
            return T_datacollector_Audio_RadioData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_RadioData_;
    }
    abort();
}

inline T_datacollector_Audio_RadioData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_RadioDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_RadioData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_RadioData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_RadioData()) {
        if (_data.T_datacollector_Audio_RadioData_ == NULL) {
            _data.T_datacollector_Audio_RadioData_ = new T_datacollector_Audio_RadioData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_RadioData_ );
        }
        return *_data.T_datacollector_Audio_RadioData_;
    }
    abort();
}

inline T_datacollector_Audio_RadioData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_RadioData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_RadioData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_RadioData()) {
        if (_data.T_datacollector_Audio_RadioData_ == NULL) {
            _data.T_datacollector_Audio_RadioData_ = new T_datacollector_Audio_RadioData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_RadioData_ );
        }
        T_datacollector_Audio_RadioData* temp = _data.T_datacollector_Audio_RadioData_;
        _data.T_datacollector_Audio_RadioData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_RadioData (T_datacollector_Audio_RadioData* T_datacollector_Audio_RadioData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_RADIO_DATA || _data.T_datacollector_Audio_RadioData_ != T_datacollector_Audio_RadioData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_RADIO_DATA;
        _data.T_datacollector_Audio_RadioData_ = T_datacollector_Audio_RadioData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_RadioData (const T_datacollector_Audio_RadioData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_RADIO_DATA && _data.T_datacollector_Audio_RadioData_ != NULL) {
        *_data.T_datacollector_Audio_RadioData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_RADIO_DATA;
        _data.T_datacollector_Audio_RadioData_ = new T_datacollector_Audio_RadioData(value);
    }
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_MediaData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA;
}

inline const T_datacollector_Audio_MediaData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_MediaData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_MediaData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_MediaData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_MediaData()) {
        if (_data.T_datacollector_Audio_MediaData_ == NULL) {
            return T_datacollector_Audio_MediaData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_MediaData_;
    }
    abort();
}

inline T_datacollector_Audio_MediaData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_MediaDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_MediaData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_MediaData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_MediaData()) {
        if (_data.T_datacollector_Audio_MediaData_ == NULL) {
            _data.T_datacollector_Audio_MediaData_ = new T_datacollector_Audio_MediaData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_MediaData_ );
        }
        return *_data.T_datacollector_Audio_MediaData_;
    }
    abort();
}

inline T_datacollector_Audio_MediaData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_MediaData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_MediaData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_MediaData()) {
        if (_data.T_datacollector_Audio_MediaData_ == NULL) {
            _data.T_datacollector_Audio_MediaData_ = new T_datacollector_Audio_MediaData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_MediaData_ );
        }
        T_datacollector_Audio_MediaData* temp = _data.T_datacollector_Audio_MediaData_;
        _data.T_datacollector_Audio_MediaData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_MediaData (T_datacollector_Audio_MediaData* T_datacollector_Audio_MediaData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA || _data.T_datacollector_Audio_MediaData_ != T_datacollector_Audio_MediaData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA;
        _data.T_datacollector_Audio_MediaData_ = T_datacollector_Audio_MediaData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_MediaData (const T_datacollector_Audio_MediaData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA && _data.T_datacollector_Audio_MediaData_ != NULL) {
        *_data.T_datacollector_Audio_MediaData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA;
        _data.T_datacollector_Audio_MediaData_ = new T_datacollector_Audio_MediaData(value);
    }
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_AuxData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_AUX_DATA;
}

inline const T_datacollector_Audio_AuxData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_AuxData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_AuxData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_AuxData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_AuxData()) {
        if (_data.T_datacollector_Audio_AuxData_ == NULL) {
            return T_datacollector_Audio_AuxData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_AuxData_;
    }
    abort();
}

inline T_datacollector_Audio_AuxData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_AuxDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_AuxData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_AuxData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_AuxData()) {
        if (_data.T_datacollector_Audio_AuxData_ == NULL) {
            _data.T_datacollector_Audio_AuxData_ = new T_datacollector_Audio_AuxData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_AuxData_ );
        }
        return *_data.T_datacollector_Audio_AuxData_;
    }
    abort();
}

inline T_datacollector_Audio_AuxData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_AuxData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_AuxData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_AuxData()) {
        if (_data.T_datacollector_Audio_AuxData_ == NULL) {
            _data.T_datacollector_Audio_AuxData_ = new T_datacollector_Audio_AuxData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_AuxData_ );
        }
        T_datacollector_Audio_AuxData* temp = _data.T_datacollector_Audio_AuxData_;
        _data.T_datacollector_Audio_AuxData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_AuxData (T_datacollector_Audio_AuxData* T_datacollector_Audio_AuxData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_AUX_DATA || _data.T_datacollector_Audio_AuxData_ != T_datacollector_Audio_AuxData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_AUX_DATA;
        _data.T_datacollector_Audio_AuxData_ = T_datacollector_Audio_AuxData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_AuxData (const T_datacollector_Audio_AuxData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_AUX_DATA && _data.T_datacollector_Audio_AuxData_ != NULL) {
        *_data.T_datacollector_Audio_AuxData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_AUX_DATA;
        _data.T_datacollector_Audio_AuxData_ = new T_datacollector_Audio_AuxData(value);
    }
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_ExternalSoundData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA;
}

inline const T_datacollector_Audio_ExternalSoundData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_ExternalSoundData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_ExternalSoundData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_ExternalSoundData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_ExternalSoundData()) {
        if (_data.T_datacollector_Audio_ExternalSoundData_ == NULL) {
            return T_datacollector_Audio_ExternalSoundData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_ExternalSoundData_;
    }
    abort();
}

inline T_datacollector_Audio_ExternalSoundData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_ExternalSoundDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_ExternalSoundData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_ExternalSoundData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_ExternalSoundData()) {
        if (_data.T_datacollector_Audio_ExternalSoundData_ == NULL) {
            _data.T_datacollector_Audio_ExternalSoundData_ = new T_datacollector_Audio_ExternalSoundData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_ExternalSoundData_ );
        }
        return *_data.T_datacollector_Audio_ExternalSoundData_;
    }
    abort();
}

inline T_datacollector_Audio_ExternalSoundData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_ExternalSoundData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_ExternalSoundData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_ExternalSoundData()) {
        if (_data.T_datacollector_Audio_ExternalSoundData_ == NULL) {
            _data.T_datacollector_Audio_ExternalSoundData_ = new T_datacollector_Audio_ExternalSoundData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_ExternalSoundData_ );
        }
        T_datacollector_Audio_ExternalSoundData* temp = _data.T_datacollector_Audio_ExternalSoundData_;
        _data.T_datacollector_Audio_ExternalSoundData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_ExternalSoundData (T_datacollector_Audio_ExternalSoundData* T_datacollector_Audio_ExternalSoundData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA || _data.T_datacollector_Audio_ExternalSoundData_ != T_datacollector_Audio_ExternalSoundData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA;
        _data.T_datacollector_Audio_ExternalSoundData_ = T_datacollector_Audio_ExternalSoundData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_ExternalSoundData (const T_datacollector_Audio_ExternalSoundData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA && _data.T_datacollector_Audio_ExternalSoundData_ != NULL) {
        *_data.T_datacollector_Audio_ExternalSoundData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA;
        _data.T_datacollector_Audio_ExternalSoundData_ = new T_datacollector_Audio_ExternalSoundData(value);
    }
}

inline bool T_datacollector_Audio_SourceInfoUnion::hasT_datacollector_Audio_InternetRadioData () const {
    return __field == E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA;
}

inline const T_datacollector_Audio_InternetRadioData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_InternetRadioData() const  {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_InternetRadioData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_InternetRadioData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_InternetRadioData()) {
        if (_data.T_datacollector_Audio_InternetRadioData_ == NULL) {
            return T_datacollector_Audio_InternetRadioData::getDefaultInstance();
        }
        return *_data.T_datacollector_Audio_InternetRadioData_;
    }
    abort();
}

inline T_datacollector_Audio_InternetRadioData& T_datacollector_Audio_SourceInfoUnion::getT_datacollector_Audio_InternetRadioDataMutable() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_FATAL_MSG(hasT_datacollector_Audio_InternetRadioData(), "Can't provide value for union field '%s' of union '%s', have field %d", "T_datacollector_Audio_InternetRadioData", "T_datacollector_Audio_SourceInfoUnion", getField());
    }
    if (hasT_datacollector_Audio_InternetRadioData()) {
        if (_data.T_datacollector_Audio_InternetRadioData_ == NULL) {
            _data.T_datacollector_Audio_InternetRadioData_ = new T_datacollector_Audio_InternetRadioData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_InternetRadioData_ );
        }
        return *_data.T_datacollector_Audio_InternetRadioData_;
    }
    abort();
}

inline T_datacollector_Audio_InternetRadioData* T_datacollector_Audio_SourceInfoUnion::releaseT_datacollector_Audio_InternetRadioData() {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG(hasT_datacollector_Audio_InternetRadioData(), "Can't release value for field 'T_datacollector_Audio_SourceInfoUnion', have field %d", getField());
    }
    if (hasT_datacollector_Audio_InternetRadioData()) {
        if (_data.T_datacollector_Audio_InternetRadioData_ == NULL) {
            _data.T_datacollector_Audio_InternetRadioData_ = new T_datacollector_Audio_InternetRadioData();
            CHECK_ALLOCATION( _data.T_datacollector_Audio_InternetRadioData_ );
        }
        T_datacollector_Audio_InternetRadioData* temp = _data.T_datacollector_Audio_InternetRadioData_;
        _data.T_datacollector_Audio_InternetRadioData_ = NULL;
        return temp;
    }
    return 0;
}

inline void T_datacollector_Audio_SourceInfoUnion::replaceT_datacollector_Audio_InternetRadioData (T_datacollector_Audio_InternetRadioData* T_datacollector_Audio_InternetRadioData) {
    if (__field != E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA || _data.T_datacollector_Audio_InternetRadioData_ != T_datacollector_Audio_InternetRadioData) {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA;
        _data.T_datacollector_Audio_InternetRadioData_ = T_datacollector_Audio_InternetRadioData;
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::setT_datacollector_Audio_InternetRadioData (const T_datacollector_Audio_InternetRadioData& value) {
    if (__field == E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA && _data.T_datacollector_Audio_InternetRadioData_ != NULL) {
        *_data.T_datacollector_Audio_InternetRadioData_ = value;
    } else {
        deleteData ();
        __field = E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA;
        _data.T_datacollector_Audio_InternetRadioData_ = new T_datacollector_Audio_InternetRadioData(value);
    }
}

inline void T_datacollector_Audio_SourceInfoUnion::cloneData (const T_datacollector_Audio_SourceInfoUnion& rhs) {
    switch (rhs.__field) {
    case E_T_DATACOLLECTOR_AUDIO_NO_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_NO_DATA) {
            if (rhs._data.T_datacollector_Audio_NoData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_NoData_ != NULL) {
                    *_data.T_datacollector_Audio_NoData_ =  *rhs._data.T_datacollector_Audio_NoData_;
                } else {
                    _data.T_datacollector_Audio_NoData_ = new T_datacollector_Audio_NoData(*rhs._data.T_datacollector_Audio_NoData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_NoData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_NoData_ != NULL) {
                _data.T_datacollector_Audio_NoData_ = new T_datacollector_Audio_NoData(*rhs._data.T_datacollector_Audio_NoData_);
            }
        }
        break;
    case E_T_DATACOLLECTOR_AUDIO_RADIO_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_RADIO_DATA) {
            if (rhs._data.T_datacollector_Audio_RadioData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_RadioData_ != NULL) {
                    *_data.T_datacollector_Audio_RadioData_ =  *rhs._data.T_datacollector_Audio_RadioData_;
                } else {
                    _data.T_datacollector_Audio_RadioData_ = new T_datacollector_Audio_RadioData(*rhs._data.T_datacollector_Audio_RadioData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_RadioData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_RadioData_ != NULL) {
                _data.T_datacollector_Audio_RadioData_ = new T_datacollector_Audio_RadioData(*rhs._data.T_datacollector_Audio_RadioData_);
            }
        }
        break;
    case E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA) {
            if (rhs._data.T_datacollector_Audio_MediaData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_MediaData_ != NULL) {
                    *_data.T_datacollector_Audio_MediaData_ =  *rhs._data.T_datacollector_Audio_MediaData_;
                } else {
                    _data.T_datacollector_Audio_MediaData_ = new T_datacollector_Audio_MediaData(*rhs._data.T_datacollector_Audio_MediaData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_MediaData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_MediaData_ != NULL) {
                _data.T_datacollector_Audio_MediaData_ = new T_datacollector_Audio_MediaData(*rhs._data.T_datacollector_Audio_MediaData_);
            }
        }
        break;
    case E_T_DATACOLLECTOR_AUDIO_AUX_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_AUX_DATA) {
            if (rhs._data.T_datacollector_Audio_AuxData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_AuxData_ != NULL) {
                    *_data.T_datacollector_Audio_AuxData_ =  *rhs._data.T_datacollector_Audio_AuxData_;
                } else {
                    _data.T_datacollector_Audio_AuxData_ = new T_datacollector_Audio_AuxData(*rhs._data.T_datacollector_Audio_AuxData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_AuxData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_AuxData_ != NULL) {
                _data.T_datacollector_Audio_AuxData_ = new T_datacollector_Audio_AuxData(*rhs._data.T_datacollector_Audio_AuxData_);
            }
        }
        break;
    case E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA) {
            if (rhs._data.T_datacollector_Audio_ExternalSoundData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_ExternalSoundData_ != NULL) {
                    *_data.T_datacollector_Audio_ExternalSoundData_ =  *rhs._data.T_datacollector_Audio_ExternalSoundData_;
                } else {
                    _data.T_datacollector_Audio_ExternalSoundData_ = new T_datacollector_Audio_ExternalSoundData(*rhs._data.T_datacollector_Audio_ExternalSoundData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_ExternalSoundData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_ExternalSoundData_ != NULL) {
                _data.T_datacollector_Audio_ExternalSoundData_ = new T_datacollector_Audio_ExternalSoundData(*rhs._data.T_datacollector_Audio_ExternalSoundData_);
            }
        }
        break;
    case E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA:
        if (__field == E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA) {
            if (rhs._data.T_datacollector_Audio_InternetRadioData_ == NULL)
                deleteData ();
            else {
                if (_data.T_datacollector_Audio_InternetRadioData_ != NULL) {
                    *_data.T_datacollector_Audio_InternetRadioData_ =  *rhs._data.T_datacollector_Audio_InternetRadioData_;
                } else {
                    _data.T_datacollector_Audio_InternetRadioData_ = new T_datacollector_Audio_InternetRadioData(*rhs._data.T_datacollector_Audio_InternetRadioData_);
                }
            }
        } else {
            if (_data.T_datacollector_Audio_InternetRadioData_ != 0) deleteData ();
            if (rhs._data.T_datacollector_Audio_InternetRadioData_ != NULL) {
                _data.T_datacollector_Audio_InternetRadioData_ = new T_datacollector_Audio_InternetRadioData(*rhs._data.T_datacollector_Audio_InternetRadioData_);
            }
        }
        break;
    default:
        break;
    }
    __field = rhs.__field;
}

inline void T_datacollector_Audio_SourceInfoUnion::deleteData () {
    switch (__field) {
    case E_T_DATACOLLECTOR_AUDIO_NO_DATA:
        delete _data.T_datacollector_Audio_NoData_;
        _data.T_datacollector_Audio_NoData_ = NULL;
        break;
    case E_T_DATACOLLECTOR_AUDIO_RADIO_DATA:
        delete _data.T_datacollector_Audio_RadioData_;
        _data.T_datacollector_Audio_RadioData_ = NULL;
        break;
    case E_T_DATACOLLECTOR_AUDIO_MEDIA_DATA:
        delete _data.T_datacollector_Audio_MediaData_;
        _data.T_datacollector_Audio_MediaData_ = NULL;
        break;
    case E_T_DATACOLLECTOR_AUDIO_AUX_DATA:
        delete _data.T_datacollector_Audio_AuxData_;
        _data.T_datacollector_Audio_AuxData_ = NULL;
        break;
    case E_T_DATACOLLECTOR_AUDIO_EXTERNAL_SOUND_DATA:
        delete _data.T_datacollector_Audio_ExternalSoundData_;
        _data.T_datacollector_Audio_ExternalSoundData_ = NULL;
        break;
    case E_T_DATACOLLECTOR_AUDIO_INTERNET_RADIO_DATA:
        delete _data.T_datacollector_Audio_InternetRadioData_;
        _data.T_datacollector_Audio_InternetRadioData_ = NULL;
        break;
    default:
        break;
    }
}

inline  T_datacollector_TimeInfoUnion::T_datacollector_TimeInfoUnion ()  :
    _TimeFormatType (::datacollector_main_fi_types::T_e8_datacollector_TimeInfoType__Unknown),
    _CurrentHours (0u),
    _CurrentMinutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_TimeInfoUnion::T_datacollector_TimeInfoUnion (const T_datacollector_TimeInfoUnion &rhs)  :
    _TimeFormatType (::datacollector_main_fi_types::T_e8_datacollector_TimeInfoType__Unknown),
    _CurrentHours (0u),
    _CurrentMinutes (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_TimeInfoUnion::T_datacollector_TimeInfoUnion (T_e8_datacollector_TimeInfoType TimeFormatType_, uint8 CurrentHours_, uint8 CurrentMinutes_)  :
    _TimeFormatType (TimeFormatType_),
    _CurrentHours (CurrentHours_),
    _CurrentMinutes (CurrentMinutes_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_TimeInfoType_IsValid(TimeFormatType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TimeFormatType_, "T_e8_datacollector_TimeInfoType", "TimeFormatType", "T_datacollector_TimeInfoUnion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_TimeInfoUnion::~T_datacollector_TimeInfoUnion() {
}

inline T_datacollector_TimeInfoUnion& T_datacollector_TimeInfoUnion::operator = (const T_datacollector_TimeInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTimeFormatType()) {
            setTimeFormatType(rhs.getTimeFormatType());
        } else {
            clearTimeFormatType();
        }
        if (rhs.hasCurrentHours()) {
            setCurrentHours(rhs.getCurrentHours());
        } else {
            clearCurrentHours();
        }
        if (rhs.hasCurrentMinutes()) {
            setCurrentMinutes(rhs.getCurrentMinutes());
        } else {
            clearCurrentMinutes();
        }
    }
    return *this;
}

inline bool T_datacollector_TimeInfoUnion::operator == (const T_datacollector_TimeInfoUnion& rhs) const {
    return (((!hasTimeFormatType() && !rhs.hasTimeFormatType()) || getTimeFormatType() == rhs.getTimeFormatType()) &&
        ((!hasCurrentHours() && !rhs.hasCurrentHours()) || getCurrentHours() == rhs.getCurrentHours()) &&
        ((!hasCurrentMinutes() && !rhs.hasCurrentMinutes()) || getCurrentMinutes() == rhs.getCurrentMinutes()));
}

inline bool T_datacollector_TimeInfoUnion::operator != (const T_datacollector_TimeInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_TimeInfoUnion::operator < (const T_datacollector_TimeInfoUnion& rhs) const {
    if (hasTimeFormatType() || rhs.hasTimeFormatType()) {
        if ((uint32)getTimeFormatType() < (uint32)rhs.getTimeFormatType()) return true;
        if ((uint32)getTimeFormatType() > (uint32)rhs.getTimeFormatType()) return false;
    }
    if (hasCurrentHours() || rhs.hasCurrentHours()) {
        if (getCurrentHours() < rhs.getCurrentHours()) return true;
        if (getCurrentHours() > rhs.getCurrentHours()) return false;
    }
    if (hasCurrentMinutes() || rhs.hasCurrentMinutes()) {
        if (getCurrentMinutes() < rhs.getCurrentMinutes()) return true;
        if (getCurrentMinutes() > rhs.getCurrentMinutes()) return false;
    }
    return false;
}

inline bool T_datacollector_TimeInfoUnion::operator > (const T_datacollector_TimeInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_TimeInfoUnion::clear() {
    clearTimeFormatType();
    clearCurrentHours();
    clearCurrentMinutes();
}

inline void T_datacollector_TimeInfoUnion::clearTimeFormatType() {
    if (hasTimeFormatType()) {
         clear_has_TimeFormatType();
        _TimeFormatType = ::datacollector_main_fi_types::T_e8_datacollector_TimeInfoType__Unknown;
     }
}

inline bool T_datacollector_TimeInfoUnion::hasTimeFormatType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline T_e8_datacollector_TimeInfoType T_datacollector_TimeInfoUnion::getTimeFormatType () const {
    return _TimeFormatType;
}

inline void T_datacollector_TimeInfoUnion::setTimeFormatType (T_e8_datacollector_TimeInfoType TimeFormatType_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_TimeInfoType_IsValid(TimeFormatType_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TimeFormatType_, "T_e8_datacollector_TimeInfoType", "TimeFormatType", "T_datacollector_TimeInfoUnion");
    }
    #endif
    set_has_TimeFormatType();
    this->_TimeFormatType = TimeFormatType_;
}

inline void T_datacollector_TimeInfoUnion::clearCurrentHours() {
    if (hasCurrentHours()) {
         clear_has_CurrentHours();
        _CurrentHours = 0u;
     }
}

inline bool T_datacollector_TimeInfoUnion::hasCurrentHours () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_TimeInfoUnion::getCurrentHours () const {
    return _CurrentHours;
}

inline void T_datacollector_TimeInfoUnion::setCurrentHours (uint8 CurrentHours_) {
    set_has_CurrentHours();
    this->_CurrentHours = CurrentHours_;
}

inline void T_datacollector_TimeInfoUnion::clearCurrentMinutes() {
    if (hasCurrentMinutes()) {
         clear_has_CurrentMinutes();
        _CurrentMinutes = 0u;
     }
}

inline bool T_datacollector_TimeInfoUnion::hasCurrentMinutes () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_TimeInfoUnion::getCurrentMinutes () const {
    return _CurrentMinutes;
}

inline void T_datacollector_TimeInfoUnion::setCurrentMinutes (uint8 CurrentMinutes_) {
    set_has_CurrentMinutes();
    this->_CurrentMinutes = CurrentMinutes_;
}

inline void T_datacollector_TimeInfoUnion::set_has_TimeFormatType () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_TimeInfoUnion::clear_has_TimeFormatType () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_TimeInfoUnion::set_has_CurrentHours () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_TimeInfoUnion::clear_has_CurrentHours () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_TimeInfoUnion::set_has_CurrentMinutes () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_TimeInfoUnion::clear_has_CurrentMinutes () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_datacollector_PhoneInfoUnion::T_datacollector_PhoneInfoUnion ()  :
    _BTConnectionState (false),
    _BatteryResidualQuantity (0u),
    _PhoneSignalStrength (0u),
    _CallerName (),
    _CallerNumber (),
    _CallDuration (0u),
    _CallStatus (::datacollector_main_fi_types::T_e8_datacollector_CallStatus__Unknown),
    _NoOfConnectedDevice (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_PhoneInfoUnion::T_datacollector_PhoneInfoUnion (const T_datacollector_PhoneInfoUnion &rhs)  :
    _BTConnectionState (false),
    _BatteryResidualQuantity (0u),
    _PhoneSignalStrength (0u),
    _CallerName (),
    _CallerNumber (),
    _CallDuration (0u),
    _CallStatus (::datacollector_main_fi_types::T_e8_datacollector_CallStatus__Unknown),
    _NoOfConnectedDevice (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_PhoneInfoUnion::T_datacollector_PhoneInfoUnion (bool BTConnectionState_, uint8 BatteryResidualQuantity_, uint8 PhoneSignalStrength_, const ::std::string& CallerName_, const ::std::string& CallerNumber_, uint8 CallDuration_, T_e8_datacollector_CallStatus CallStatus_, uint8 NoOfConnectedDevice_)  :
    _BTConnectionState (BTConnectionState_),
    _BatteryResidualQuantity (BatteryResidualQuantity_),
    _PhoneSignalStrength (PhoneSignalStrength_),
    _CallerName (CallerName_),
    _CallerNumber (CallerNumber_),
    _CallDuration (CallDuration_),
    _CallStatus (CallStatus_),
    _NoOfConnectedDevice (NoOfConnectedDevice_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerName_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_datacollector_CallStatus_IsValid(CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CallStatus_, "T_e8_datacollector_CallStatus", "CallStatus", "T_datacollector_PhoneInfoUnion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_PhoneInfoUnion::~T_datacollector_PhoneInfoUnion() {
}

inline T_datacollector_PhoneInfoUnion& T_datacollector_PhoneInfoUnion::operator = (const T_datacollector_PhoneInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasBTConnectionState()) {
            setBTConnectionState(rhs.getBTConnectionState());
        } else {
            clearBTConnectionState();
        }
        if (rhs.hasBatteryResidualQuantity()) {
            setBatteryResidualQuantity(rhs.getBatteryResidualQuantity());
        } else {
            clearBatteryResidualQuantity();
        }
        if (rhs.hasPhoneSignalStrength()) {
            setPhoneSignalStrength(rhs.getPhoneSignalStrength());
        } else {
            clearPhoneSignalStrength();
        }
        if (rhs.hasCallerName()) {
            setCallerName(rhs.getCallerName());
        } else {
            clearCallerName();
        }
        if (rhs.hasCallerNumber()) {
            setCallerNumber(rhs.getCallerNumber());
        } else {
            clearCallerNumber();
        }
        if (rhs.hasCallDuration()) {
            setCallDuration(rhs.getCallDuration());
        } else {
            clearCallDuration();
        }
        if (rhs.hasCallStatus()) {
            setCallStatus(rhs.getCallStatus());
        } else {
            clearCallStatus();
        }
        if (rhs.hasNoOfConnectedDevice()) {
            setNoOfConnectedDevice(rhs.getNoOfConnectedDevice());
        } else {
            clearNoOfConnectedDevice();
        }
    }
    return *this;
}

inline bool T_datacollector_PhoneInfoUnion::operator == (const T_datacollector_PhoneInfoUnion& rhs) const {
    return (((!hasBTConnectionState() && !rhs.hasBTConnectionState()) || getBTConnectionState() == rhs.getBTConnectionState()) &&
        ((!hasBatteryResidualQuantity() && !rhs.hasBatteryResidualQuantity()) || getBatteryResidualQuantity() == rhs.getBatteryResidualQuantity()) &&
        ((!hasPhoneSignalStrength() && !rhs.hasPhoneSignalStrength()) || getPhoneSignalStrength() == rhs.getPhoneSignalStrength()) &&
        ((!hasCallerName() && !rhs.hasCallerName()) || getCallerName() == rhs.getCallerName()) &&
        ((!hasCallerNumber() && !rhs.hasCallerNumber()) || getCallerNumber() == rhs.getCallerNumber()) &&
        ((!hasCallDuration() && !rhs.hasCallDuration()) || getCallDuration() == rhs.getCallDuration()) &&
        ((!hasCallStatus() && !rhs.hasCallStatus()) || getCallStatus() == rhs.getCallStatus()) &&
        ((!hasNoOfConnectedDevice() && !rhs.hasNoOfConnectedDevice()) || getNoOfConnectedDevice() == rhs.getNoOfConnectedDevice()));
}

inline bool T_datacollector_PhoneInfoUnion::operator != (const T_datacollector_PhoneInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_PhoneInfoUnion::operator < (const T_datacollector_PhoneInfoUnion& rhs) const {
    if (hasBTConnectionState() || rhs.hasBTConnectionState()) {
        if (getBTConnectionState() < rhs.getBTConnectionState()) return true;
        if (getBTConnectionState() > rhs.getBTConnectionState()) return false;
    }
    if (hasBatteryResidualQuantity() || rhs.hasBatteryResidualQuantity()) {
        if (getBatteryResidualQuantity() < rhs.getBatteryResidualQuantity()) return true;
        if (getBatteryResidualQuantity() > rhs.getBatteryResidualQuantity()) return false;
    }
    if (hasPhoneSignalStrength() || rhs.hasPhoneSignalStrength()) {
        if (getPhoneSignalStrength() < rhs.getPhoneSignalStrength()) return true;
        if (getPhoneSignalStrength() > rhs.getPhoneSignalStrength()) return false;
    }
    if (hasCallerName() || rhs.hasCallerName()) {
        if (getCallerName() < rhs.getCallerName()) return true;
        if (getCallerName() > rhs.getCallerName()) return false;
    }
    if (hasCallerNumber() || rhs.hasCallerNumber()) {
        if (getCallerNumber() < rhs.getCallerNumber()) return true;
        if (getCallerNumber() > rhs.getCallerNumber()) return false;
    }
    if (hasCallDuration() || rhs.hasCallDuration()) {
        if (getCallDuration() < rhs.getCallDuration()) return true;
        if (getCallDuration() > rhs.getCallDuration()) return false;
    }
    if (hasCallStatus() || rhs.hasCallStatus()) {
        if ((uint32)getCallStatus() < (uint32)rhs.getCallStatus()) return true;
        if ((uint32)getCallStatus() > (uint32)rhs.getCallStatus()) return false;
    }
    if (hasNoOfConnectedDevice() || rhs.hasNoOfConnectedDevice()) {
        if (getNoOfConnectedDevice() < rhs.getNoOfConnectedDevice()) return true;
        if (getNoOfConnectedDevice() > rhs.getNoOfConnectedDevice()) return false;
    }
    return false;
}

inline bool T_datacollector_PhoneInfoUnion::operator > (const T_datacollector_PhoneInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_PhoneInfoUnion::clear() {
    clearBTConnectionState();
    clearBatteryResidualQuantity();
    clearPhoneSignalStrength();
    clearCallerName();
    clearCallerNumber();
    clearCallDuration();
    clearCallStatus();
    clearNoOfConnectedDevice();
}

inline void T_datacollector_PhoneInfoUnion::clearBTConnectionState() {
    if (hasBTConnectionState()) {
         clear_has_BTConnectionState();
        _BTConnectionState = false;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasBTConnectionState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_datacollector_PhoneInfoUnion::getBTConnectionState () const {
    return _BTConnectionState;
}

inline void T_datacollector_PhoneInfoUnion::setBTConnectionState (bool BTConnectionState_) {
    set_has_BTConnectionState();
    this->_BTConnectionState = BTConnectionState_;
}

inline void T_datacollector_PhoneInfoUnion::clearBatteryResidualQuantity() {
    if (hasBatteryResidualQuantity()) {
         clear_has_BatteryResidualQuantity();
        _BatteryResidualQuantity = 0u;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasBatteryResidualQuantity () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_PhoneInfoUnion::getBatteryResidualQuantity () const {
    return _BatteryResidualQuantity;
}

inline void T_datacollector_PhoneInfoUnion::setBatteryResidualQuantity (uint8 BatteryResidualQuantity_) {
    set_has_BatteryResidualQuantity();
    this->_BatteryResidualQuantity = BatteryResidualQuantity_;
}

inline void T_datacollector_PhoneInfoUnion::clearPhoneSignalStrength() {
    if (hasPhoneSignalStrength()) {
         clear_has_PhoneSignalStrength();
        _PhoneSignalStrength = 0u;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasPhoneSignalStrength () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_PhoneInfoUnion::getPhoneSignalStrength () const {
    return _PhoneSignalStrength;
}

inline void T_datacollector_PhoneInfoUnion::setPhoneSignalStrength (uint8 PhoneSignalStrength_) {
    set_has_PhoneSignalStrength();
    this->_PhoneSignalStrength = PhoneSignalStrength_;
}

inline void T_datacollector_PhoneInfoUnion::clearCallerName() {
    if (hasCallerName()) {
         clear_has_CallerName();
        _CallerName.clear();
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasCallerName () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& T_datacollector_PhoneInfoUnion::getCallerName () const {
    return _CallerName;
}

inline ::std::string& T_datacollector_PhoneInfoUnion::getCallerNameMutable () {
    set_has_CallerName();
    return _CallerName;
}

inline void T_datacollector_PhoneInfoUnion::setCallerName (const ::std::string& CallerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerName();
    this->_CallerName = CallerName_;
}

inline void T_datacollector_PhoneInfoUnion::setCallerName (const char* CallerName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerName();
    this->_CallerName.assign(CallerName_);
}

inline void T_datacollector_PhoneInfoUnion::setCallerName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerName();
    this->_CallerName.assign(value, size);
}

inline void T_datacollector_PhoneInfoUnion::clearCallerNumber() {
    if (hasCallerNumber()) {
         clear_has_CallerNumber();
        _CallerNumber.clear();
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasCallerNumber () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_datacollector_PhoneInfoUnion::getCallerNumber () const {
    return _CallerNumber;
}

inline ::std::string& T_datacollector_PhoneInfoUnion::getCallerNumberMutable () {
    set_has_CallerNumber();
    return _CallerNumber;
}

inline void T_datacollector_PhoneInfoUnion::setCallerNumber (const ::std::string& CallerNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerNumber();
    this->_CallerNumber = CallerNumber_;
}

inline void T_datacollector_PhoneInfoUnion::setCallerNumber (const char* CallerNumber_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CallerNumber_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerNumber();
    this->_CallerNumber.assign(CallerNumber_);
}

inline void T_datacollector_PhoneInfoUnion::setCallerNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CallerNumber();
    this->_CallerNumber.assign(value, size);
}

inline void T_datacollector_PhoneInfoUnion::clearCallDuration() {
    if (hasCallDuration()) {
         clear_has_CallDuration();
        _CallDuration = 0u;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasCallDuration () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline uint8 T_datacollector_PhoneInfoUnion::getCallDuration () const {
    return _CallDuration;
}

inline void T_datacollector_PhoneInfoUnion::setCallDuration (uint8 CallDuration_) {
    set_has_CallDuration();
    this->_CallDuration = CallDuration_;
}

inline void T_datacollector_PhoneInfoUnion::clearCallStatus() {
    if (hasCallStatus()) {
         clear_has_CallStatus();
        _CallStatus = ::datacollector_main_fi_types::T_e8_datacollector_CallStatus__Unknown;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasCallStatus () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_datacollector_CallStatus T_datacollector_PhoneInfoUnion::getCallStatus () const {
    return _CallStatus;
}

inline void T_datacollector_PhoneInfoUnion::setCallStatus (T_e8_datacollector_CallStatus CallStatus_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_CallStatus_IsValid(CallStatus_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CallStatus_, "T_e8_datacollector_CallStatus", "CallStatus", "T_datacollector_PhoneInfoUnion");
    }
    #endif
    set_has_CallStatus();
    this->_CallStatus = CallStatus_;
}

inline void T_datacollector_PhoneInfoUnion::clearNoOfConnectedDevice() {
    if (hasNoOfConnectedDevice()) {
         clear_has_NoOfConnectedDevice();
        _NoOfConnectedDevice = 0u;
     }
}

inline bool T_datacollector_PhoneInfoUnion::hasNoOfConnectedDevice () const {
    return (_has_bits_[0] & (1u << 7)) > 0;
}

inline uint8 T_datacollector_PhoneInfoUnion::getNoOfConnectedDevice () const {
    return _NoOfConnectedDevice;
}

inline void T_datacollector_PhoneInfoUnion::setNoOfConnectedDevice (uint8 NoOfConnectedDevice_) {
    set_has_NoOfConnectedDevice();
    this->_NoOfConnectedDevice = NoOfConnectedDevice_;
}

inline void T_datacollector_PhoneInfoUnion::set_has_BTConnectionState () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_BTConnectionState () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_PhoneInfoUnion::set_has_BatteryResidualQuantity () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_BatteryResidualQuantity () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_PhoneInfoUnion::set_has_PhoneSignalStrength () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_PhoneSignalStrength () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_PhoneInfoUnion::set_has_CallerName () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_CallerName () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_datacollector_PhoneInfoUnion::set_has_CallerNumber () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_CallerNumber () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_datacollector_PhoneInfoUnion::set_has_CallDuration () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_CallDuration () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_datacollector_PhoneInfoUnion::set_has_CallStatus () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_CallStatus () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline void T_datacollector_PhoneInfoUnion::set_has_NoOfConnectedDevice () {
    _has_bits_[0] |= 1u << 7;
}

inline void T_datacollector_PhoneInfoUnion::clear_has_NoOfConnectedDevice () {
    _has_bits_[0] &= ~ (1u << 7);
}

inline  T_datacollector_SMSInfoUnion::T_datacollector_SMSInfoUnion ()  :
    _NewSMSNotification (false),
    _NumberOfUnreadSMS (0u),
    _SMSSendersName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_SMSInfoUnion::T_datacollector_SMSInfoUnion (const T_datacollector_SMSInfoUnion &rhs)  :
    _NewSMSNotification (false),
    _NumberOfUnreadSMS (0u),
    _SMSSendersName ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_SMSInfoUnion::T_datacollector_SMSInfoUnion (bool NewSMSNotification_, uint8 NumberOfUnreadSMS_, const ::std::string& SMSSendersName_)  :
    _NewSMSNotification (NewSMSNotification_),
    _NumberOfUnreadSMS (NumberOfUnreadSMS_),
    _SMSSendersName (SMSSendersName_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SMSSendersName_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_SMSInfoUnion::~T_datacollector_SMSInfoUnion() {
}

inline T_datacollector_SMSInfoUnion& T_datacollector_SMSInfoUnion::operator = (const T_datacollector_SMSInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasNewSMSNotification()) {
            setNewSMSNotification(rhs.getNewSMSNotification());
        } else {
            clearNewSMSNotification();
        }
        if (rhs.hasNumberOfUnreadSMS()) {
            setNumberOfUnreadSMS(rhs.getNumberOfUnreadSMS());
        } else {
            clearNumberOfUnreadSMS();
        }
        if (rhs.hasSMSSendersName()) {
            setSMSSendersName(rhs.getSMSSendersName());
        } else {
            clearSMSSendersName();
        }
    }
    return *this;
}

inline bool T_datacollector_SMSInfoUnion::operator == (const T_datacollector_SMSInfoUnion& rhs) const {
    return (((!hasNewSMSNotification() && !rhs.hasNewSMSNotification()) || getNewSMSNotification() == rhs.getNewSMSNotification()) &&
        ((!hasNumberOfUnreadSMS() && !rhs.hasNumberOfUnreadSMS()) || getNumberOfUnreadSMS() == rhs.getNumberOfUnreadSMS()) &&
        ((!hasSMSSendersName() && !rhs.hasSMSSendersName()) || getSMSSendersName() == rhs.getSMSSendersName()));
}

inline bool T_datacollector_SMSInfoUnion::operator != (const T_datacollector_SMSInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_SMSInfoUnion::operator < (const T_datacollector_SMSInfoUnion& rhs) const {
    if (hasNewSMSNotification() || rhs.hasNewSMSNotification()) {
        if (getNewSMSNotification() < rhs.getNewSMSNotification()) return true;
        if (getNewSMSNotification() > rhs.getNewSMSNotification()) return false;
    }
    if (hasNumberOfUnreadSMS() || rhs.hasNumberOfUnreadSMS()) {
        if (getNumberOfUnreadSMS() < rhs.getNumberOfUnreadSMS()) return true;
        if (getNumberOfUnreadSMS() > rhs.getNumberOfUnreadSMS()) return false;
    }
    if (hasSMSSendersName() || rhs.hasSMSSendersName()) {
        if (getSMSSendersName() < rhs.getSMSSendersName()) return true;
        if (getSMSSendersName() > rhs.getSMSSendersName()) return false;
    }
    return false;
}

inline bool T_datacollector_SMSInfoUnion::operator > (const T_datacollector_SMSInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_SMSInfoUnion::clear() {
    clearNewSMSNotification();
    clearNumberOfUnreadSMS();
    clearSMSSendersName();
}

inline void T_datacollector_SMSInfoUnion::clearNewSMSNotification() {
    if (hasNewSMSNotification()) {
         clear_has_NewSMSNotification();
        _NewSMSNotification = false;
     }
}

inline bool T_datacollector_SMSInfoUnion::hasNewSMSNotification () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_datacollector_SMSInfoUnion::getNewSMSNotification () const {
    return _NewSMSNotification;
}

inline void T_datacollector_SMSInfoUnion::setNewSMSNotification (bool NewSMSNotification_) {
    set_has_NewSMSNotification();
    this->_NewSMSNotification = NewSMSNotification_;
}

inline void T_datacollector_SMSInfoUnion::clearNumberOfUnreadSMS() {
    if (hasNumberOfUnreadSMS()) {
         clear_has_NumberOfUnreadSMS();
        _NumberOfUnreadSMS = 0u;
     }
}

inline bool T_datacollector_SMSInfoUnion::hasNumberOfUnreadSMS () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_SMSInfoUnion::getNumberOfUnreadSMS () const {
    return _NumberOfUnreadSMS;
}

inline void T_datacollector_SMSInfoUnion::setNumberOfUnreadSMS (uint8 NumberOfUnreadSMS_) {
    set_has_NumberOfUnreadSMS();
    this->_NumberOfUnreadSMS = NumberOfUnreadSMS_;
}

inline void T_datacollector_SMSInfoUnion::clearSMSSendersName() {
    if (hasSMSSendersName()) {
         clear_has_SMSSendersName();
        _SMSSendersName.clear();
     }
}

inline bool T_datacollector_SMSInfoUnion::hasSMSSendersName () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& T_datacollector_SMSInfoUnion::getSMSSendersName () const {
    return _SMSSendersName;
}

inline ::std::string& T_datacollector_SMSInfoUnion::getSMSSendersNameMutable () {
    set_has_SMSSendersName();
    return _SMSSendersName;
}

inline void T_datacollector_SMSInfoUnion::setSMSSendersName (const ::std::string& SMSSendersName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SMSSendersName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SMSSendersName();
    this->_SMSSendersName = SMSSendersName_;
}

inline void T_datacollector_SMSInfoUnion::setSMSSendersName (const char* SMSSendersName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SMSSendersName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SMSSendersName();
    this->_SMSSendersName.assign(SMSSendersName_);
}

inline void T_datacollector_SMSInfoUnion::setSMSSendersName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SMSSendersName();
    this->_SMSSendersName.assign(value, size);
}

inline void T_datacollector_SMSInfoUnion::set_has_NewSMSNotification () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_SMSInfoUnion::clear_has_NewSMSNotification () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_SMSInfoUnion::set_has_NumberOfUnreadSMS () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_SMSInfoUnion::clear_has_NumberOfUnreadSMS () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_SMSInfoUnion::set_has_SMSSendersName () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_SMSInfoUnion::clear_has_SMSSendersName () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline  T_datacollector_HVACInfoUnion::T_datacollector_HVACInfoUnion ()  :
    _HVACTemperature (0u),
    _TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_HVACTemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_HVACInfoUnion::T_datacollector_HVACInfoUnion (const T_datacollector_HVACInfoUnion &rhs)  :
    _HVACTemperature (0u),
    _TemperatureUnit (::datacollector_main_fi_types::T_e8_datacollector_HVACTemperatureUnit__Unknown)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_HVACInfoUnion::T_datacollector_HVACInfoUnion (uint8 HVACTemperature_, T_e8_datacollector_HVACTemperatureUnit TemperatureUnit_)  :
    _HVACTemperature (HVACTemperature_),
    _TemperatureUnit (TemperatureUnit_)
{
    #ifndef NDEBUG
    if (!(T_e8_datacollector_HVACTemperatureUnit_IsValid(TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TemperatureUnit_, "T_e8_datacollector_HVACTemperatureUnit", "TemperatureUnit", "T_datacollector_HVACInfoUnion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_HVACInfoUnion::~T_datacollector_HVACInfoUnion() {
}

inline T_datacollector_HVACInfoUnion& T_datacollector_HVACInfoUnion::operator = (const T_datacollector_HVACInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasHVACTemperature()) {
            setHVACTemperature(rhs.getHVACTemperature());
        } else {
            clearHVACTemperature();
        }
        if (rhs.hasTemperatureUnit()) {
            setTemperatureUnit(rhs.getTemperatureUnit());
        } else {
            clearTemperatureUnit();
        }
    }
    return *this;
}

inline bool T_datacollector_HVACInfoUnion::operator == (const T_datacollector_HVACInfoUnion& rhs) const {
    return (((!hasHVACTemperature() && !rhs.hasHVACTemperature()) || getHVACTemperature() == rhs.getHVACTemperature()) &&
        ((!hasTemperatureUnit() && !rhs.hasTemperatureUnit()) || getTemperatureUnit() == rhs.getTemperatureUnit()));
}

inline bool T_datacollector_HVACInfoUnion::operator != (const T_datacollector_HVACInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_HVACInfoUnion::operator < (const T_datacollector_HVACInfoUnion& rhs) const {
    if (hasHVACTemperature() || rhs.hasHVACTemperature()) {
        if (getHVACTemperature() < rhs.getHVACTemperature()) return true;
        if (getHVACTemperature() > rhs.getHVACTemperature()) return false;
    }
    if (hasTemperatureUnit() || rhs.hasTemperatureUnit()) {
        if ((uint32)getTemperatureUnit() < (uint32)rhs.getTemperatureUnit()) return true;
        if ((uint32)getTemperatureUnit() > (uint32)rhs.getTemperatureUnit()) return false;
    }
    return false;
}

inline bool T_datacollector_HVACInfoUnion::operator > (const T_datacollector_HVACInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_HVACInfoUnion::clear() {
    clearHVACTemperature();
    clearTemperatureUnit();
}

inline void T_datacollector_HVACInfoUnion::clearHVACTemperature() {
    if (hasHVACTemperature()) {
         clear_has_HVACTemperature();
        _HVACTemperature = 0u;
     }
}

inline bool T_datacollector_HVACInfoUnion::hasHVACTemperature () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 T_datacollector_HVACInfoUnion::getHVACTemperature () const {
    return _HVACTemperature;
}

inline void T_datacollector_HVACInfoUnion::setHVACTemperature (uint8 HVACTemperature_) {
    set_has_HVACTemperature();
    this->_HVACTemperature = HVACTemperature_;
}

inline void T_datacollector_HVACInfoUnion::clearTemperatureUnit() {
    if (hasTemperatureUnit()) {
         clear_has_TemperatureUnit();
        _TemperatureUnit = ::datacollector_main_fi_types::T_e8_datacollector_HVACTemperatureUnit__Unknown;
     }
}

inline bool T_datacollector_HVACInfoUnion::hasTemperatureUnit () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline T_e8_datacollector_HVACTemperatureUnit T_datacollector_HVACInfoUnion::getTemperatureUnit () const {
    return _TemperatureUnit;
}

inline void T_datacollector_HVACInfoUnion::setTemperatureUnit (T_e8_datacollector_HVACTemperatureUnit TemperatureUnit_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_HVACTemperatureUnit_IsValid(TemperatureUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", TemperatureUnit_, "T_e8_datacollector_HVACTemperatureUnit", "TemperatureUnit", "T_datacollector_HVACInfoUnion");
    }
    #endif
    set_has_TemperatureUnit();
    this->_TemperatureUnit = TemperatureUnit_;
}

inline void T_datacollector_HVACInfoUnion::set_has_HVACTemperature () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_HVACInfoUnion::clear_has_HVACTemperature () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_HVACInfoUnion::set_has_TemperatureUnit () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_HVACInfoUnion::clear_has_TemperatureUnit () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  T_datacollector_AudioInfoUnion::T_datacollector_AudioInfoUnion ()  :
    _TrackName (),
    _TrackNumber (0u),
    _TrackPlayTime (0u),
    _CurrentRadioSource (::datacollector_main_fi_types::T_e8_datacollector_CuurentRadioSource__Unknown),
    _CurrentStationName (),
    _AM_FMFrequency (),
    _AM_FMFrequencyUnit (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_AudioInfoUnion::T_datacollector_AudioInfoUnion (const T_datacollector_AudioInfoUnion &rhs)  :
    _TrackName (),
    _TrackNumber (0u),
    _TrackPlayTime (0u),
    _CurrentRadioSource (::datacollector_main_fi_types::T_e8_datacollector_CuurentRadioSource__Unknown),
    _CurrentStationName (),
    _AM_FMFrequency (),
    _AM_FMFrequencyUnit (::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_AudioInfoUnion::T_datacollector_AudioInfoUnion (const ::std::string& TrackName_, uint8 TrackNumber_, uint8 TrackPlayTime_, T_e8_datacollector_CuurentRadioSource CurrentRadioSource_, const ::std::string& CurrentStationName_, const T_datacollector_Audio_RadioFrequency& AM_FMFrequency_, T_e8_datacollector_Audio_RadioFrequencyUnit AM_FMFrequencyUnit_)  :
    _TrackName (TrackName_),
    _TrackNumber (TrackNumber_),
    _TrackPlayTime (TrackPlayTime_),
    _CurrentRadioSource (CurrentRadioSource_),
    _CurrentStationName (CurrentStationName_),
    _AM_FMFrequency (AM_FMFrequency_),
    _AM_FMFrequencyUnit (AM_FMFrequencyUnit_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_datacollector_CuurentRadioSource_IsValid(CurrentRadioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CurrentRadioSource_, "T_e8_datacollector_CuurentRadioSource", "CurrentRadioSource", "T_datacollector_AudioInfoUnion");
    }
    #endif
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid(AM_FMFrequencyUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AM_FMFrequencyUnit_, "T_e8_datacollector_Audio_RadioFrequencyUnit", "AM_FMFrequencyUnit", "T_datacollector_AudioInfoUnion");
    }
    #endif
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_AudioInfoUnion::~T_datacollector_AudioInfoUnion() {
}

inline T_datacollector_AudioInfoUnion& T_datacollector_AudioInfoUnion::operator = (const T_datacollector_AudioInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasTrackName()) {
            setTrackName(rhs.getTrackName());
        } else {
            clearTrackName();
        }
        if (rhs.hasTrackNumber()) {
            setTrackNumber(rhs.getTrackNumber());
        } else {
            clearTrackNumber();
        }
        if (rhs.hasTrackPlayTime()) {
            setTrackPlayTime(rhs.getTrackPlayTime());
        } else {
            clearTrackPlayTime();
        }
        if (rhs.hasCurrentRadioSource()) {
            setCurrentRadioSource(rhs.getCurrentRadioSource());
        } else {
            clearCurrentRadioSource();
        }
        if (rhs.hasCurrentStationName()) {
            setCurrentStationName(rhs.getCurrentStationName());
        } else {
            clearCurrentStationName();
        }
        if (rhs.hasAM_FMFrequency()) {
            setAM_FMFrequency(rhs.getAM_FMFrequency());
        } else {
            clearAM_FMFrequency();
        }
        if (rhs.hasAM_FMFrequencyUnit()) {
            setAM_FMFrequencyUnit(rhs.getAM_FMFrequencyUnit());
        } else {
            clearAM_FMFrequencyUnit();
        }
    }
    return *this;
}

inline bool T_datacollector_AudioInfoUnion::operator == (const T_datacollector_AudioInfoUnion& rhs) const {
    return (((!hasTrackName() && !rhs.hasTrackName()) || getTrackName() == rhs.getTrackName()) &&
        ((!hasTrackNumber() && !rhs.hasTrackNumber()) || getTrackNumber() == rhs.getTrackNumber()) &&
        ((!hasTrackPlayTime() && !rhs.hasTrackPlayTime()) || getTrackPlayTime() == rhs.getTrackPlayTime()) &&
        ((!hasCurrentRadioSource() && !rhs.hasCurrentRadioSource()) || getCurrentRadioSource() == rhs.getCurrentRadioSource()) &&
        ((!hasCurrentStationName() && !rhs.hasCurrentStationName()) || getCurrentStationName() == rhs.getCurrentStationName()) &&
        ((!hasAM_FMFrequency() && !rhs.hasAM_FMFrequency()) || getAM_FMFrequency() == rhs.getAM_FMFrequency()) &&
        ((!hasAM_FMFrequencyUnit() && !rhs.hasAM_FMFrequencyUnit()) || getAM_FMFrequencyUnit() == rhs.getAM_FMFrequencyUnit()));
}

inline bool T_datacollector_AudioInfoUnion::operator != (const T_datacollector_AudioInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_AudioInfoUnion::operator < (const T_datacollector_AudioInfoUnion& rhs) const {
    if (hasTrackName() || rhs.hasTrackName()) {
        if (getTrackName() < rhs.getTrackName()) return true;
        if (getTrackName() > rhs.getTrackName()) return false;
    }
    if (hasTrackNumber() || rhs.hasTrackNumber()) {
        if (getTrackNumber() < rhs.getTrackNumber()) return true;
        if (getTrackNumber() > rhs.getTrackNumber()) return false;
    }
    if (hasTrackPlayTime() || rhs.hasTrackPlayTime()) {
        if (getTrackPlayTime() < rhs.getTrackPlayTime()) return true;
        if (getTrackPlayTime() > rhs.getTrackPlayTime()) return false;
    }
    if (hasCurrentRadioSource() || rhs.hasCurrentRadioSource()) {
        if ((uint32)getCurrentRadioSource() < (uint32)rhs.getCurrentRadioSource()) return true;
        if ((uint32)getCurrentRadioSource() > (uint32)rhs.getCurrentRadioSource()) return false;
    }
    if (hasCurrentStationName() || rhs.hasCurrentStationName()) {
        if (getCurrentStationName() < rhs.getCurrentStationName()) return true;
        if (getCurrentStationName() > rhs.getCurrentStationName()) return false;
    }
    if (hasAM_FMFrequency() || rhs.hasAM_FMFrequency()) {
        if (getAM_FMFrequency() < rhs.getAM_FMFrequency()) return true;
        if (getAM_FMFrequency() > rhs.getAM_FMFrequency()) return false;
    }
    if (hasAM_FMFrequencyUnit() || rhs.hasAM_FMFrequencyUnit()) {
        if ((uint32)getAM_FMFrequencyUnit() < (uint32)rhs.getAM_FMFrequencyUnit()) return true;
        if ((uint32)getAM_FMFrequencyUnit() > (uint32)rhs.getAM_FMFrequencyUnit()) return false;
    }
    return false;
}

inline bool T_datacollector_AudioInfoUnion::operator > (const T_datacollector_AudioInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_AudioInfoUnion::clear() {
    clearTrackName();
    clearTrackNumber();
    clearTrackPlayTime();
    clearCurrentRadioSource();
    clearCurrentStationName();
    clearAM_FMFrequency();
    clearAM_FMFrequencyUnit();
}

inline void T_datacollector_AudioInfoUnion::clearTrackName() {
    if (hasTrackName()) {
         clear_has_TrackName();
        _TrackName.clear();
     }
}

inline bool T_datacollector_AudioInfoUnion::hasTrackName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& T_datacollector_AudioInfoUnion::getTrackName () const {
    return _TrackName;
}

inline ::std::string& T_datacollector_AudioInfoUnion::getTrackNameMutable () {
    set_has_TrackName();
    return _TrackName;
}

inline void T_datacollector_AudioInfoUnion::setTrackName (const ::std::string& TrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TrackName();
    this->_TrackName = TrackName_;
}

inline void T_datacollector_AudioInfoUnion::setTrackName (const char* TrackName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (TrackName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TrackName();
    this->_TrackName.assign(TrackName_);
}

inline void T_datacollector_AudioInfoUnion::setTrackName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_TrackName();
    this->_TrackName.assign(value, size);
}

inline void T_datacollector_AudioInfoUnion::clearTrackNumber() {
    if (hasTrackNumber()) {
         clear_has_TrackNumber();
        _TrackNumber = 0u;
     }
}

inline bool T_datacollector_AudioInfoUnion::hasTrackNumber () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint8 T_datacollector_AudioInfoUnion::getTrackNumber () const {
    return _TrackNumber;
}

inline void T_datacollector_AudioInfoUnion::setTrackNumber (uint8 TrackNumber_) {
    set_has_TrackNumber();
    this->_TrackNumber = TrackNumber_;
}

inline void T_datacollector_AudioInfoUnion::clearTrackPlayTime() {
    if (hasTrackPlayTime()) {
         clear_has_TrackPlayTime();
        _TrackPlayTime = 0u;
     }
}

inline bool T_datacollector_AudioInfoUnion::hasTrackPlayTime () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_AudioInfoUnion::getTrackPlayTime () const {
    return _TrackPlayTime;
}

inline void T_datacollector_AudioInfoUnion::setTrackPlayTime (uint8 TrackPlayTime_) {
    set_has_TrackPlayTime();
    this->_TrackPlayTime = TrackPlayTime_;
}

inline void T_datacollector_AudioInfoUnion::clearCurrentRadioSource() {
    if (hasCurrentRadioSource()) {
         clear_has_CurrentRadioSource();
        _CurrentRadioSource = ::datacollector_main_fi_types::T_e8_datacollector_CuurentRadioSource__Unknown;
     }
}

inline bool T_datacollector_AudioInfoUnion::hasCurrentRadioSource () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline T_e8_datacollector_CuurentRadioSource T_datacollector_AudioInfoUnion::getCurrentRadioSource () const {
    return _CurrentRadioSource;
}

inline void T_datacollector_AudioInfoUnion::setCurrentRadioSource (T_e8_datacollector_CuurentRadioSource CurrentRadioSource_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_CuurentRadioSource_IsValid(CurrentRadioSource_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", CurrentRadioSource_, "T_e8_datacollector_CuurentRadioSource", "CurrentRadioSource", "T_datacollector_AudioInfoUnion");
    }
    #endif
    set_has_CurrentRadioSource();
    this->_CurrentRadioSource = CurrentRadioSource_;
}

inline void T_datacollector_AudioInfoUnion::clearCurrentStationName() {
    if (hasCurrentStationName()) {
         clear_has_CurrentStationName();
        _CurrentStationName.clear();
     }
}

inline bool T_datacollector_AudioInfoUnion::hasCurrentStationName () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& T_datacollector_AudioInfoUnion::getCurrentStationName () const {
    return _CurrentStationName;
}

inline ::std::string& T_datacollector_AudioInfoUnion::getCurrentStationNameMutable () {
    set_has_CurrentStationName();
    return _CurrentStationName;
}

inline void T_datacollector_AudioInfoUnion::setCurrentStationName (const ::std::string& CurrentStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentStationName();
    this->_CurrentStationName = CurrentStationName_;
}

inline void T_datacollector_AudioInfoUnion::setCurrentStationName (const char* CurrentStationName_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (CurrentStationName_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentStationName();
    this->_CurrentStationName.assign(CurrentStationName_);
}

inline void T_datacollector_AudioInfoUnion::setCurrentStationName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_CurrentStationName();
    this->_CurrentStationName.assign(value, size);
}

inline void T_datacollector_AudioInfoUnion::clearAM_FMFrequency() {
    if (hasAM_FMFrequency()) {
         clear_has_AM_FMFrequency();
        _AM_FMFrequency.clear();
     }
}

inline bool T_datacollector_AudioInfoUnion::hasAM_FMFrequency () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const T_datacollector_Audio_RadioFrequency& T_datacollector_AudioInfoUnion::getAM_FMFrequency () const {
    return _AM_FMFrequency;
}

inline T_datacollector_Audio_RadioFrequency& T_datacollector_AudioInfoUnion::getAM_FMFrequencyMutable () {
    set_has_AM_FMFrequency();
    return _AM_FMFrequency;
}

inline void T_datacollector_AudioInfoUnion::setAM_FMFrequency (const T_datacollector_Audio_RadioFrequency& AM_FMFrequency_) {
    set_has_AM_FMFrequency();
    this->_AM_FMFrequency = AM_FMFrequency_;
}

inline void T_datacollector_AudioInfoUnion::clearAM_FMFrequencyUnit() {
    if (hasAM_FMFrequencyUnit()) {
         clear_has_AM_FMFrequencyUnit();
        _AM_FMFrequencyUnit = ::datacollector_main_fi_types::T_e8_datacollector_Audio_RadioFrequencyUnit__None;
     }
}

inline bool T_datacollector_AudioInfoUnion::hasAM_FMFrequencyUnit () const {
    return (_has_bits_[0] & (1u << 6)) > 0;
}

inline T_e8_datacollector_Audio_RadioFrequencyUnit T_datacollector_AudioInfoUnion::getAM_FMFrequencyUnit () const {
    return _AM_FMFrequencyUnit;
}

inline void T_datacollector_AudioInfoUnion::setAM_FMFrequencyUnit (T_e8_datacollector_Audio_RadioFrequencyUnit AM_FMFrequencyUnit_) {
    #ifndef NDEBUG
    if (!(T_e8_datacollector_Audio_RadioFrequencyUnit_IsValid(AM_FMFrequencyUnit_))) {
        LOG_SYSTEM_LOGGER();
        LOG_WARN_STATIC("Invalid value %d for enumeration '%s' in field '%s' of '%s'", AM_FMFrequencyUnit_, "T_e8_datacollector_Audio_RadioFrequencyUnit", "AM_FMFrequencyUnit", "T_datacollector_AudioInfoUnion");
    }
    #endif
    set_has_AM_FMFrequencyUnit();
    this->_AM_FMFrequencyUnit = AM_FMFrequencyUnit_;
}

inline void T_datacollector_AudioInfoUnion::set_has_TrackName () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_AudioInfoUnion::clear_has_TrackName () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_AudioInfoUnion::set_has_TrackNumber () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_AudioInfoUnion::clear_has_TrackNumber () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_AudioInfoUnion::set_has_TrackPlayTime () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_AudioInfoUnion::clear_has_TrackPlayTime () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_AudioInfoUnion::set_has_CurrentRadioSource () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_AudioInfoUnion::clear_has_CurrentRadioSource () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void T_datacollector_AudioInfoUnion::set_has_CurrentStationName () {
    _has_bits_[0] |= 1u << 4;
}

inline void T_datacollector_AudioInfoUnion::clear_has_CurrentStationName () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void T_datacollector_AudioInfoUnion::set_has_AM_FMFrequency () {
    _has_bits_[0] |= 1u << 5;
}

inline void T_datacollector_AudioInfoUnion::clear_has_AM_FMFrequency () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline void T_datacollector_AudioInfoUnion::set_has_AM_FMFrequencyUnit () {
    _has_bits_[0] |= 1u << 6;
}

inline void T_datacollector_AudioInfoUnion::clear_has_AM_FMFrequencyUnit () {
    _has_bits_[0] &= ~ (1u << 6);
}

inline  T_datacollector_DownloadInfoUnion::T_datacollector_DownloadInfoUnion ()  :
    _IsDownloadAvailable (false),
    _DownloadConnection (false),
    _DownloadProgress (0u),
    _UpdateProgress (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  T_datacollector_DownloadInfoUnion::T_datacollector_DownloadInfoUnion (const T_datacollector_DownloadInfoUnion &rhs)  :
    _IsDownloadAvailable (false),
    _DownloadConnection (false),
    _DownloadProgress (0u),
    _UpdateProgress (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  T_datacollector_DownloadInfoUnion::T_datacollector_DownloadInfoUnion (bool IsDownloadAvailable_, bool DownloadConnection_, uint8 DownloadProgress_, uint8 UpdateProgress_)  :
    _IsDownloadAvailable (IsDownloadAvailable_),
    _DownloadConnection (DownloadConnection_),
    _DownloadProgress (DownloadProgress_),
    _UpdateProgress (UpdateProgress_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  T_datacollector_DownloadInfoUnion::~T_datacollector_DownloadInfoUnion() {
}

inline T_datacollector_DownloadInfoUnion& T_datacollector_DownloadInfoUnion::operator = (const T_datacollector_DownloadInfoUnion& rhs) {
    if( this != &rhs ) {
        if (rhs.hasIsDownloadAvailable()) {
            setIsDownloadAvailable(rhs.getIsDownloadAvailable());
        } else {
            clearIsDownloadAvailable();
        }
        if (rhs.hasDownloadConnection()) {
            setDownloadConnection(rhs.getDownloadConnection());
        } else {
            clearDownloadConnection();
        }
        if (rhs.hasDownloadProgress()) {
            setDownloadProgress(rhs.getDownloadProgress());
        } else {
            clearDownloadProgress();
        }
        if (rhs.hasUpdateProgress()) {
            setUpdateProgress(rhs.getUpdateProgress());
        } else {
            clearUpdateProgress();
        }
    }
    return *this;
}

inline bool T_datacollector_DownloadInfoUnion::operator == (const T_datacollector_DownloadInfoUnion& rhs) const {
    return (((!hasIsDownloadAvailable() && !rhs.hasIsDownloadAvailable()) || getIsDownloadAvailable() == rhs.getIsDownloadAvailable()) &&
        ((!hasDownloadConnection() && !rhs.hasDownloadConnection()) || getDownloadConnection() == rhs.getDownloadConnection()) &&
        ((!hasDownloadProgress() && !rhs.hasDownloadProgress()) || getDownloadProgress() == rhs.getDownloadProgress()) &&
        ((!hasUpdateProgress() && !rhs.hasUpdateProgress()) || getUpdateProgress() == rhs.getUpdateProgress()));
}

inline bool T_datacollector_DownloadInfoUnion::operator != (const T_datacollector_DownloadInfoUnion& rhs) const {
    return ! (*this == rhs);
}

inline bool T_datacollector_DownloadInfoUnion::operator < (const T_datacollector_DownloadInfoUnion& rhs) const {
    if (hasIsDownloadAvailable() || rhs.hasIsDownloadAvailable()) {
        if (getIsDownloadAvailable() < rhs.getIsDownloadAvailable()) return true;
        if (getIsDownloadAvailable() > rhs.getIsDownloadAvailable()) return false;
    }
    if (hasDownloadConnection() || rhs.hasDownloadConnection()) {
        if (getDownloadConnection() < rhs.getDownloadConnection()) return true;
        if (getDownloadConnection() > rhs.getDownloadConnection()) return false;
    }
    if (hasDownloadProgress() || rhs.hasDownloadProgress()) {
        if (getDownloadProgress() < rhs.getDownloadProgress()) return true;
        if (getDownloadProgress() > rhs.getDownloadProgress()) return false;
    }
    if (hasUpdateProgress() || rhs.hasUpdateProgress()) {
        if (getUpdateProgress() < rhs.getUpdateProgress()) return true;
        if (getUpdateProgress() > rhs.getUpdateProgress()) return false;
    }
    return false;
}

inline bool T_datacollector_DownloadInfoUnion::operator > (const T_datacollector_DownloadInfoUnion& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void T_datacollector_DownloadInfoUnion::clear() {
    clearIsDownloadAvailable();
    clearDownloadConnection();
    clearDownloadProgress();
    clearUpdateProgress();
}

inline void T_datacollector_DownloadInfoUnion::clearIsDownloadAvailable() {
    if (hasIsDownloadAvailable()) {
         clear_has_IsDownloadAvailable();
        _IsDownloadAvailable = false;
     }
}

inline bool T_datacollector_DownloadInfoUnion::hasIsDownloadAvailable () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline bool T_datacollector_DownloadInfoUnion::getIsDownloadAvailable () const {
    return _IsDownloadAvailable;
}

inline void T_datacollector_DownloadInfoUnion::setIsDownloadAvailable (bool IsDownloadAvailable_) {
    set_has_IsDownloadAvailable();
    this->_IsDownloadAvailable = IsDownloadAvailable_;
}

inline void T_datacollector_DownloadInfoUnion::clearDownloadConnection() {
    if (hasDownloadConnection()) {
         clear_has_DownloadConnection();
        _DownloadConnection = false;
     }
}

inline bool T_datacollector_DownloadInfoUnion::hasDownloadConnection () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline bool T_datacollector_DownloadInfoUnion::getDownloadConnection () const {
    return _DownloadConnection;
}

inline void T_datacollector_DownloadInfoUnion::setDownloadConnection (bool DownloadConnection_) {
    set_has_DownloadConnection();
    this->_DownloadConnection = DownloadConnection_;
}

inline void T_datacollector_DownloadInfoUnion::clearDownloadProgress() {
    if (hasDownloadProgress()) {
         clear_has_DownloadProgress();
        _DownloadProgress = 0u;
     }
}

inline bool T_datacollector_DownloadInfoUnion::hasDownloadProgress () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 T_datacollector_DownloadInfoUnion::getDownloadProgress () const {
    return _DownloadProgress;
}

inline void T_datacollector_DownloadInfoUnion::setDownloadProgress (uint8 DownloadProgress_) {
    set_has_DownloadProgress();
    this->_DownloadProgress = DownloadProgress_;
}

inline void T_datacollector_DownloadInfoUnion::clearUpdateProgress() {
    if (hasUpdateProgress()) {
         clear_has_UpdateProgress();
        _UpdateProgress = 0u;
     }
}

inline bool T_datacollector_DownloadInfoUnion::hasUpdateProgress () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint8 T_datacollector_DownloadInfoUnion::getUpdateProgress () const {
    return _UpdateProgress;
}

inline void T_datacollector_DownloadInfoUnion::setUpdateProgress (uint8 UpdateProgress_) {
    set_has_UpdateProgress();
    this->_UpdateProgress = UpdateProgress_;
}

inline void T_datacollector_DownloadInfoUnion::set_has_IsDownloadAvailable () {
    _has_bits_[0] |= 1u << 0;
}

inline void T_datacollector_DownloadInfoUnion::clear_has_IsDownloadAvailable () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void T_datacollector_DownloadInfoUnion::set_has_DownloadConnection () {
    _has_bits_[0] |= 1u << 1;
}

inline void T_datacollector_DownloadInfoUnion::clear_has_DownloadConnection () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void T_datacollector_DownloadInfoUnion::set_has_DownloadProgress () {
    _has_bits_[0] |= 1u << 2;
}

inline void T_datacollector_DownloadInfoUnion::clear_has_DownloadProgress () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void T_datacollector_DownloadInfoUnion::set_has_UpdateProgress () {
    _has_bits_[0] |= 1u << 3;
}

inline void T_datacollector_DownloadInfoUnion::clear_has_UpdateProgress () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace datacollector_main_fi_types

#endif // DATACOLLECTOR_MAIN_FI_TYPES_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
