/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef DABTUNER_MAIN_FI_TYPESCONST_H
#define DABTUNER_MAIN_FI_TYPESCONST_H

#include <cstddef>

/**
 * Types dabtuner_main_fi_types
 */

namespace dabtuner_main_fi_types {

/**
 * DABTuner Response to a Request.
 */
enum T_e8_DAB_Response {

    /**
     * If the meaning of "DAB_RES_OK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Response__DAB_RES_OK = 0u,
    /**
     * If the meaning of "DAB_RES_FAILED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Response__DAB_RES_FAILED = 1u,
    /**
     * If the meaning of "DAB_RES_NOT_AVAILABLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Response__DAB_RES_NOT_AVAILABLE = 2u,
    /**
     * If the meaning of "DAB_RES_INPROCESS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Response__DAB_RES_INPROCESS = 3u

};

bool T_e8_DAB_Response_Parse (const char *str, size_t length, T_e8_DAB_Response &value);

const char* T_e8_DAB_Response_Name (T_e8_DAB_Response value);

bool T_e8_DAB_Response_IsValid (T_e8_DAB_Response value);

/**
 * User profile actions
 */
enum T_e8_DAB_UserProfileAction {

    /**
     * If the meaning of "DAB_PROFILE_CHANGE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UserProfileAction__DAB_PROFILE_CHANGE = 0u,
    /**
     * If the meaning of "DAB_PROFILE_DELETE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UserProfileAction__DAB_PROFILE_DELETE = 1u,
    /**
     * If the meaning of "DAB_PROFILE_COPY" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UserProfileAction__DAB_PROFILE_COPY = 2u

};

bool T_e8_DAB_UserProfileAction_Parse (const char *str, size_t length, T_e8_DAB_UserProfileAction &value);

const char* T_e8_DAB_UserProfileAction_Name (T_e8_DAB_UserProfileAction value);

bool T_e8_DAB_UserProfileAction_IsValid (T_e8_DAB_UserProfileAction value);

/**
 * DAB Audio in foreground or background.
 */
enum T_e8_DAB_SourceState {

    /**
     * If the meaning of "DAB_BACKGROUND" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_BACKGROUND = 0u,
    /**
     * If the meaning of "DAB_FOREGROUND" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_FOREGROUND = 1u,
    /**
     * If the meaning of "DAB_SERVICE_FOLLOWING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_SERVICE_FOLLOWING = 2u,
    /**
     * If the meaning of "DAB_FOREGROUND_TA" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_FOREGROUND_TA = 3u,
    /**
     * If the meaning of "DAB_FOREGROUND_ALARM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_FOREGROUND_ALARM = 4u,
    /**
     * If the meaning of "DAB_BACKGROUND_ANNO_SURVEILLANCE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_BACKGROUND_ANNO_SURVEILLANCE = 5u,
    /**
     * If the meaning of "DAB_FOREGROUND_ANNO_SURVEILLANCE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_FOREGROUND_ANNO_SURVEILLANCE = 6u,
    /**
     * If the meaning of "DAB_LEARN_FOREVER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_LEARN_FOREVER = 7u,
    /**
     * If the meaning of "DAB_BG_LEARN_FOREVER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SourceState__DAB_BG_LEARN_FOREVER = 8u

};

bool T_e8_DAB_SourceState_Parse (const char *str, size_t length, T_e8_DAB_SourceState &value);

const char* T_e8_DAB_SourceState_Name (T_e8_DAB_SourceState value);

bool T_e8_DAB_SourceState_IsValid (T_e8_DAB_SourceState value);

/**
 * DAB Service can be an AUDIO service (primary service component transports audio) or DATA
 * (primary service component transports data).
 */
enum T_e8_DAB_ServiceType {

    /**
     * If the meaning of "DAB_SERVICETYPE_UNKNOWN" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN = 0u,
    /**
     * If the meaning of "DAB_SERVICETYPE_AUDIO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceType__DAB_SERVICETYPE_AUDIO = 1u,
    /**
     * If the meaning of "DAB_SERVICETYPE_DATA" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceType__DAB_SERVICETYPE_DATA = 2u

};

bool T_e8_DAB_ServiceType_Parse (const char *str, size_t length, T_e8_DAB_ServiceType &value);

const char* T_e8_DAB_ServiceType_Name (T_e8_DAB_ServiceType value);

bool T_e8_DAB_ServiceType_IsValid (T_e8_DAB_ServiceType value);

/**
 * DAB Service list can be sorted by SID or label.
 */
enum T_e8_DAB_ServiceListSortingType {

    /**
     * If the meaning of "DAB_SERVICELIST_SORTINGTYPE_LABEL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceListSortingType__DAB_SERVICELIST_SORTINGTYPE_LABEL = 0u,
    /**
     * If the meaning of "DAB_SERVICELIST_SORTINGTYPE_SID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceListSortingType__DAB_SERVICELIST_SORTINGTYPE_SID = 1u

};

bool T_e8_DAB_ServiceListSortingType_Parse (const char *str, size_t length, T_e8_DAB_ServiceListSortingType &value);

const char* T_e8_DAB_ServiceListSortingType_Name (T_e8_DAB_ServiceListSortingType value);

bool T_e8_DAB_ServiceListSortingType_IsValid (T_e8_DAB_ServiceListSortingType value);

/**
 * DAB ensemble list can be sorted by SID or label.
 */
enum T_e8_DAB_EnsembleListSortingType {

    /**
     * If the meaning of "DAB_ENSEMBLELIST_SORTINGTYPE_LABEL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_LABEL = 0u,
    /**
     * If the meaning of "DAB_ENSEMBLELIST_SORTINGTYPE_FREQ" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_FREQ = 1u,
    /**
     * If the meaning of "DAB_ENSEMBLELIST_SORTINGTYPE_EID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_EID = 2u

};

bool T_e8_DAB_EnsembleListSortingType_Parse (const char *str, size_t length, T_e8_DAB_EnsembleListSortingType &value);

const char* T_e8_DAB_EnsembleListSortingType_Name (T_e8_DAB_EnsembleListSortingType value);

bool T_e8_DAB_EnsembleListSortingType_IsValid (T_e8_DAB_EnsembleListSortingType value);

/**
 * Gives hint on which type of auto store to be initiated
 */
enum T_e8_DAB_AST_Type {

    /**
     * If the meaning of "DAB_AST_NORMAL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AST_Type__DAB_AST_NORMAL = 0u,
    /**
     * If the meaning of "DAB_AST_INITIAL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AST_Type__DAB_AST_INITIAL = 1u

};

bool T_e8_DAB_AST_Type_Parse (const char *str, size_t length, T_e8_DAB_AST_Type &value);

const char* T_e8_DAB_AST_Type_Name (T_e8_DAB_AST_Type value);

bool T_e8_DAB_AST_Type_IsValid (T_e8_DAB_AST_Type value);

/**
 * Receivers allowing this function will automatically switch to other modes of reception
 * if the current one becomes unavailable (e.g. when leaving the coverage area). Synonym: Service Following
 */
enum T_e8_DAB_ServiceLinkingMode {

    /**
     * If the meaning of "DAB_SERVICELINKING_OFF" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_OFF = 0u,
    /**
     * If the meaning of "DAB_SERVICELINKING_DAB" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_DAB = 1u,
    /**
     * If the meaning of "DAB_SERVICELINKING_DAB_FM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_DAB_FM = 2u,
    /**
     * If the meaning of "DAB_SERVICELINKING_FM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_FM = 3u

};

bool T_e8_DAB_ServiceLinkingMode_Parse (const char *str, size_t length, T_e8_DAB_ServiceLinkingMode &value);

const char* T_e8_DAB_ServiceLinkingMode_Name (T_e8_DAB_ServiceLinkingMode value);

bool T_e8_DAB_ServiceLinkingMode_IsValid (T_e8_DAB_ServiceLinkingMode value);

/**
 * Enum for Service switching.
 */
enum T_e8_MTC_Request {

    /**
     * If the meaning of "DAB_SERVICELINKING_FM" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Request__DAB_SERVICELINKING_FM = 0u,
    /**
     * If the meaning of "FM_SERVICELINKING_DAB" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Request__FM_SERVICELINKING_DAB = 1u

};

bool T_e8_MTC_Request_Parse (const char *str, size_t length, T_e8_MTC_Request &value);

const char* T_e8_MTC_Request_Name (T_e8_MTC_Request value);

bool T_e8_MTC_Request_IsValid (T_e8_MTC_Request value);

/**
 * Enum for tuner status switch.
 */
enum T_e8_MTC_Tuner_Status {

    /**
     * If the meaning of "MAIN_DAB_TUNER" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_Status__MAIN_DAB_TUNER = 0u,
    /**
     * If the meaning of "MAIN_FM_TUNER" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_Status__MAIN_FM_TUNER = 1u,
    /**
     * If the meaning of "MAIN_TUNER_UNKNOWN" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_Status__MAIN_TUNER_UNKNOWN = 2u

};

bool T_e8_MTC_Tuner_Status_Parse (const char *str, size_t length, T_e8_MTC_Tuner_Status &value);

const char* T_e8_MTC_Tuner_Status_Name (T_e8_MTC_Tuner_Status value);

bool T_e8_MTC_Tuner_Status_IsValid (T_e8_MTC_Tuner_Status value);

/**
 * Enum for notifing MTC whether an announcement has started or stopped.
 */
enum T_e8_MTC_Tuner_ActivityState {

    /**
     * If the meaning of "Stopped" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_ActivityState__Stopped = 0u,
    /**
     * If the meaning of "Start_FM_Announcement" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_ActivityState__Start_FM_Announcement = 1u,
    /**
     * If the meaning of "Start_DAB_Announcement" isn't clear, then there should be a description here.
     */
    T_e8_MTC_Tuner_ActivityState__Start_DAB_Announcement = 2u

};

bool T_e8_MTC_Tuner_ActivityState_Parse (const char *str, size_t length, T_e8_MTC_Tuner_ActivityState &value);

const char* T_e8_MTC_Tuner_ActivityState_Name (T_e8_MTC_Tuner_ActivityState value);

bool T_e8_MTC_Tuner_ActivityState_IsValid (T_e8_MTC_Tuner_ActivityState value);

/**
 * Type of station being played.
 */
enum T_e8_StationType {

    /**
     * If the meaning of "DAB" isn't clear, then there should be a description here.
     */
    T_e8_StationType__DAB = 0u,
    /**
     * If the meaning of "FM" isn't clear, then there should be a description here.
     */
    T_e8_StationType__FM = 1u

};

bool T_e8_StationType_Parse (const char *str, size_t length, T_e8_StationType &value);

const char* T_e8_StationType_Name (T_e8_StationType value);

bool T_e8_StationType_IsValid (T_e8_StationType value);

/**
 * TP Station present or not.
 */
enum T_e8_TPState {

    /**
     * If the meaning of "NO_TP" isn't clear, then there should be a description here.
     */
    T_e8_TPState__NO_TP = 0u,
    /**
     * If the meaning of "TP" isn't clear, then there should be a description here.
     */
    T_e8_TPState__TP = 1u

};

bool T_e8_TPState_Parse (const char *str, size_t length, T_e8_TPState &value);

const char* T_e8_TPState_Name (T_e8_TPState value);

bool T_e8_TPState_IsValid (T_e8_TPState value);

enum T_e8_DAB_SampleRate {

    /**
     * If the meaning of "DAB_SAMPLERATE_48KHZ" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SampleRate__DAB_SAMPLERATE_48KHZ = 0u,
    /**
     * If the meaning of "DAB_SAMPLERATE_24KHZ" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SampleRate__DAB_SAMPLERATE_24KHZ = 1u

};

bool T_e8_DAB_SampleRate_Parse (const char *str, size_t length, T_e8_DAB_SampleRate &value);

const char* T_e8_DAB_SampleRate_Name (T_e8_DAB_SampleRate value);

bool T_e8_DAB_SampleRate_IsValid (T_e8_DAB_SampleRate value);

enum T_e8_DAB_AudioMode {

    /**
     * If the meaning of "DAB_AUDIOMODE_STEREO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioMode__DAB_AUDIOMODE_STEREO = 0u,
    /**
     * If the meaning of "DAB_AUDIOMODE_JOINT_STEREO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioMode__DAB_AUDIOMODE_JOINT_STEREO = 1u,
    /**
     * If the meaning of "DAB_AUDIOMODE_DUAL_CHANNEL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioMode__DAB_AUDIOMODE_DUAL_CHANNEL = 2u,
    /**
     * If the meaning of "DAB_AUDIOMODE_MONO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioMode__DAB_AUDIOMODE_MONO = 3u

};

bool T_e8_DAB_AudioMode_Parse (const char *str, size_t length, T_e8_DAB_AudioMode &value);

const char* T_e8_DAB_AudioMode_Name (T_e8_DAB_AudioMode value);

bool T_e8_DAB_AudioMode_IsValid (T_e8_DAB_AudioMode value);

enum T_e8_DAB_AudioCodec {

    /**
     * If the meaning of "DAB_AUDIOCODEC_NOT_RECOGNIZED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_NOT_RECOGNIZED = 0u,
    /**
     * If the meaning of "DAB_AUDIOCODEC_MUSICAM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_MUSICAM = 1u,
    /**
     * If the meaning of "DAB_AUDIOCODEC_DABPLUS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_DABPLUS = 2u,
    /**
     * If the meaning of "DAB_AUDIOCODEC_DMB_AUDIO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_DMB_AUDIO = 3u

};

bool T_e8_DAB_AudioCodec_Parse (const char *str, size_t length, T_e8_DAB_AudioCodec &value);

const char* T_e8_DAB_AudioCodec_Name (T_e8_DAB_AudioCodec value);

bool T_e8_DAB_AudioCodec_IsValid (T_e8_DAB_AudioCodec value);

enum T_e8_DAB_Encoding {

    /**
     * If the meaning of "DAB_ENCODING_MPEG1" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Encoding__DAB_ENCODING_MPEG1 = 0u,
    /**
     * If the meaning of "DAB_ENCODING_MPEG2" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Encoding__DAB_ENCODING_MPEG2 = 1u,
    /**
     * If the meaning of "DAB_ENCODING_HEAAC" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Encoding__DAB_ENCODING_HEAAC = 2u,
    /**
     * If the meaning of "DAB_ENCODING_BSAC" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Encoding__DAB_ENCODING_BSAC = 3u

};

bool T_e8_DAB_Encoding_Parse (const char *str, size_t length, T_e8_DAB_Encoding &value);

const char* T_e8_DAB_Encoding_Name (T_e8_DAB_Encoding value);

bool T_e8_DAB_Encoding_IsValid (T_e8_DAB_Encoding value);

enum T_e8_DAB_ComponentType {

    /**
     * If the meaning of "DAB_COMPONENTTYPE_PRIMARY" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_PRIMARY = 0u,
    /**
     * If the meaning of "DAB_COMPONENTTYPE_SECONDARY" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_SECONDARY = 1u

};

bool T_e8_DAB_ComponentType_Parse (const char *str, size_t length, T_e8_DAB_ComponentType &value);

const char* T_e8_DAB_ComponentType_Name (T_e8_DAB_ComponentType value);

bool T_e8_DAB_ComponentType_IsValid (T_e8_DAB_ComponentType value);

enum T_e8_DAB_TMIdType {

    /**
     * If the meaning of "DAB_TMIDTYPE_MSC_AUDIO_STREAM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_AUDIO_STREAM = 0u,
    /**
     * If the meaning of "DAB_TMIDTYPE_MSC_DATA_STREAM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_DATA_STREAM = 1u,
    /**
     * If the meaning of "DAB_TMIDTYPE_FIDC" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TMIdType__DAB_TMIDTYPE_FIDC = 2u,
    /**
     * If the meaning of "DAB_TMIDTYPE_MSC_DATA_PACKET" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_DATA_PACKET = 3u

};

bool T_e8_DAB_TMIdType_Parse (const char *str, size_t length, T_e8_DAB_TMIdType &value);

const char* T_e8_DAB_TMIdType_Name (T_e8_DAB_TMIdType value);

bool T_e8_DAB_TMIdType_IsValid (T_e8_DAB_TMIdType value);

enum T_e8_DAB_AudioServiceComponentType {

    /**
     * If the meaning of "DAB_ASCTY_FG_SOUND" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_FG_SOUND = 0u,
    /**
     * If the meaning of "DAB_ASCTY_BG_SOUND" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_BG_SOUND = 1u,
    /**
     * If the meaning of "DAB_ASCTY_MULTI_CHANNEL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_MULTI_CHANNEL = 2u

};

bool T_e8_DAB_AudioServiceComponentType_Parse (const char *str, size_t length, T_e8_DAB_AudioServiceComponentType &value);

const char* T_e8_DAB_AudioServiceComponentType_Name (T_e8_DAB_AudioServiceComponentType value);

bool T_e8_DAB_AudioServiceComponentType_IsValid (T_e8_DAB_AudioServiceComponentType value);

enum T_e8_DAB_DataServiceComponentType {

    /**
     * If the meaning of "DAB_DSCTY_NOT_SPECIFIED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_NOT_SPECIFIED = 0u,
    /**
     * If the meaning of "DAB_DSCTY_TMC" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_TMC = 1u,
    /**
     * If the meaning of "DAB_DSCTY_EWS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_EWS = 2u,
    /**
     * If the meaning of "DAB_DSCTY_ITTS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_ITTS = 3u,
    /**
     * If the meaning of "DAB_DSCTY_PAGING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_PAGING = 4u,
    /**
     * If the meaning of "DAB_DSCTY_MOT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DataServiceComponentType__DAB_DSCTY_MOT = 60u

};

bool T_e8_DAB_DataServiceComponentType_Parse (const char *str, size_t length, T_e8_DAB_DataServiceComponentType &value);

const char* T_e8_DAB_DataServiceComponentType_Name (T_e8_DAB_DataServiceComponentType value);

bool T_e8_DAB_DataServiceComponentType_IsValid (T_e8_DAB_DataServiceComponentType value);

/**
 * Current transition in announcement-handling
 */
enum T_e8_DAB_AnnouncementSelectState {

    /**
     * If the meaning of "IDLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSelectState__IDLE = 0u,
    /**
     * If the meaning of "PENDING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSelectState__PENDING = 1u,
    /**
     * If the meaning of "SELECTING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSelectState__SELECTING = 2u,
    /**
     * If the meaning of "SELECTED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSelectState__SELECTED = 3u,
    /**
     * If the meaning of "DESELECTING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSelectState__DESELECTING = 4u

};

bool T_e8_DAB_AnnouncementSelectState_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementSelectState &value);

const char* T_e8_DAB_AnnouncementSelectState_Name (T_e8_DAB_AnnouncementSelectState value);

bool T_e8_DAB_AnnouncementSelectState_IsValid (T_e8_DAB_AnnouncementSelectState value);

/**
 * Current state of the announcement according to DAB-module
 */
enum T_e8_DAB_AnnouncementStatus {

    /**
     * If the meaning of "START" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementStatus__START = 1u,
    /**
     * If the meaning of "END" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementStatus__END = 2u,
    /**
     * If the meaning of "ESCAPED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementStatus__ESCAPED = 3u,
    /**
     * If the meaning of "SWITCHED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementStatus__SWITCHED = 4u

};

bool T_e8_DAB_AnnouncementStatus_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementStatus &value);

const char* T_e8_DAB_AnnouncementStatus_Name (T_e8_DAB_AnnouncementStatus value);

bool T_e8_DAB_AnnouncementStatus_IsValid (T_e8_DAB_AnnouncementStatus value);

/**
 * Announcement Sources that shall be selected if signalled.
 * Announcements are indicated by the selected Service.
 * This parameter configures which indicated Sources shall be accepted
 */
enum T_e8_DAB_AnnouncementSource {

    /**
     * If the meaning of "DAB_ANNOSOURCE_NONE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE = 0u,
    /**
     * If the meaning of "DAB_ANNOSOURCE_CURRENT_SUBCHANNEL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_SUBCHANNEL = 1u,
    /**
     * If the meaning of "DAB_ANNOSOURCE_CURRENT_SERVICE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_SERVICE = 2u,
    /**
     * If the meaning of "DAB_ANNOSOURCE_CURRENT_ENSEMBLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_ENSEMBLE = 3u

};

bool T_e8_DAB_AnnouncementSource_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementSource &value);

const char* T_e8_DAB_AnnouncementSource_Name (T_e8_DAB_AnnouncementSource value);

bool T_e8_DAB_AnnouncementSource_IsValid (T_e8_DAB_AnnouncementSource value);

/**
 * Mode of ChannelSelection: Psid, ListId, Relative
 */
enum T_e8_DAB_ChnSelectMode {

    /**
     * If the meaning of "DAB_CHNSELECTMODE_PSDI" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_PSDI = 0u,
    /**
     * If the meaning of "DAB_CHNSELECTMODE_LISTID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_LISTID = 1u,
    /**
     * If the meaning of "DAB_CHNSELECTMODE_RELATIVE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_RELATIVE = 2u

};

bool T_e8_DAB_ChnSelectMode_Parse (const char *str, size_t length, T_e8_DAB_ChnSelectMode &value);

const char* T_e8_DAB_ChnSelectMode_Name (T_e8_DAB_ChnSelectMode value);

bool T_e8_DAB_ChnSelectMode_IsValid (T_e8_DAB_ChnSelectMode value);

/**
 * Mode of EnsembleSelection: EnsId, ListId, Relative
 */
enum T_e8_DAB_EnsSelectMode {

    /**
     * If the meaning of "DAB_ENSSELECTMODE_ENSID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_ENSID = 0u,
    /**
     * If the meaning of "DAB_ENSSELECTMODE_LISTID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_LISTID = 1u,
    /**
     * If the meaning of "DAB_ENSSELECTMODE_RELATIVE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_RELATIVE = 2u

};

bool T_e8_DAB_EnsSelectMode_Parse (const char *str, size_t length, T_e8_DAB_EnsSelectMode &value);

const char* T_e8_DAB_EnsSelectMode_Name (T_e8_DAB_EnsSelectMode value);

bool T_e8_DAB_EnsSelectMode_IsValid (T_e8_DAB_EnsSelectMode value);

/**
 * Mode of Component Selection: SCID, ListId, Relative
 */
enum T_e8_DAB_CompSelectMode {

    /**
     * If the meaning of "DAB_CHNSELECTMODE_SCID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_SCID = 0u,
    /**
     * If the meaning of "DAB_CHNSELECTMODE_LISTID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_LISTID = 1u,
    /**
     * If the meaning of "DAB_CHNSELECTMODE_RELATIVE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_RELATIVE = 2u

};

bool T_e8_DAB_CompSelectMode_Parse (const char *str, size_t length, T_e8_DAB_CompSelectMode &value);

const char* T_e8_DAB_CompSelectMode_Name (T_e8_DAB_CompSelectMode value);

bool T_e8_DAB_CompSelectMode_IsValid (T_e8_DAB_CompSelectMode value);

/**
 * Indicates whether the URI has been accepted and is used for sending notifications.
 */
enum T_e8_DAB_UriSelectState {

    /**
     * If the meaning of "DAB_URI_SELECT_STATE_OK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_OK = 0u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_NOT_VALID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NOT_VALID = 1u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_NO_RESOURCES" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NO_RESOURCES = 4u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_NOT_VALID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_NOT_VALID = 5u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_ALREADY_SELECTED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_ALREADY_SELECTED = 17u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_NOT_SELECTED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NOT_SELECTED = 18u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_PROCESSING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_PROCESSING = 32u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_ACTIVATED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACTIVATED = 33u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER = 34u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION = 35u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER = 36u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS = 37u,
    /**
     * If the meaning of "DAB_URI_SELECT_STATE_ERROR" isn't clear, then there should be a description here.
     */
    T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_ERROR = 65535u

};

bool T_e8_DAB_UriSelectState_Parse (const char *str, size_t length, T_e8_DAB_UriSelectState &value);

const char* T_e8_DAB_UriSelectState_Name (T_e8_DAB_UriSelectState value);

bool T_e8_DAB_UriSelectState_IsValid (T_e8_DAB_UriSelectState value);

/**
 * DAB Tuner Activity type status
 */
enum T_e8_DAB_TunerActivityType {

    /**
     * If the meaning of "DAB_ACTIVITYTYPE_NORMAL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_NORMAL = 0u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_LEARN" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_LEARN = 1u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_SEEK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SEEK = 2u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_SCAN" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SCAN = 3u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_SERVICESEEK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SERVICESEEK = 4u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_TAFOLLOWING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_TAFOLLOWING = 5u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_SERVICEFOLLOWING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SERVICEFOLLOWING = 6u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_TPMONITOR" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_TPMONITOR = 7u,
    /**
     * If the meaning of "DAB_ACTIVITYTYPE_INVALID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_INVALID = 8u

};

bool T_e8_DAB_TunerActivityType_Parse (const char *str, size_t length, T_e8_DAB_TunerActivityType &value);

const char* T_e8_DAB_TunerActivityType_Name (T_e8_DAB_TunerActivityType value);

bool T_e8_DAB_TunerActivityType_IsValid (T_e8_DAB_TunerActivityType value);

/**
 * DAB frequency table
 */
enum T_e8_DAB_FrequencyTable {

    /**
     * If the meaning of "DAB_FREQTABLE_AUTO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_AUTO = 0u,
    /**
     * If the meaning of "DAB_FREQTABLE_EU_BOTH" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BOTH = 1u,
    /**
     * If the meaning of "DAB_FREQTABLE_EU_L_BAND" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_L_BAND = 2u,
    /**
     * If the meaning of "DAB_FREQTABLE_EU_BAND_3" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BAND_3 = 3u,
    /**
     * If the meaning of "DAB_FREQTABLE_CANADA" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_CANADA = 4u,
    /**
     * If the meaning of "DAB_FREQTABLE_EU_BOTH_NEW" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BOTH_NEW = 5u,
    /**
     * If the meaning of "DAB_FREQTABLE_EU_BAND_3_NEW" isn't clear, then there should be a description here.
     */
    T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BAND_3_NEW = 6u

};

bool T_e8_DAB_FrequencyTable_Parse (const char *str, size_t length, T_e8_DAB_FrequencyTable &value);

const char* T_e8_DAB_FrequencyTable_Name (T_e8_DAB_FrequencyTable value);

bool T_e8_DAB_FrequencyTable_IsValid (T_e8_DAB_FrequencyTable value);

/**
 * State of the channel info that indicates how the channel-info shall be displayed.
 * The given advisories are only proposals and have to be clarified.
 */
enum T_e8_DAB_ChannelInfoState {

    /**
     * If the meaning of "DAB_STABLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_STABLE = 0u,
    /**
     * If the meaning of "DAB_SELECTING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_SELECTING = 1u,
    /**
     * If the meaning of "DAB_SELECTING_WAIT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_SELECTING_WAIT = 2u,
    /**
     * If the meaning of "DAB_SELECTING_SEARCH" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_SELECTING_SEARCH = 3u,
    /**
     * If the meaning of "DAB_UNAVAIL" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_UNAVAIL = 4u,
    /**
     * If the meaning of "DAB_INVALID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ChannelInfoState__DAB_INVALID = 5u

};

bool T_e8_DAB_ChannelInfoState_Parse (const char *str, size_t length, T_e8_DAB_ChannelInfoState &value);

const char* T_e8_DAB_ChannelInfoState_Name (T_e8_DAB_ChannelInfoState value);

bool T_e8_DAB_ChannelInfoState_IsValid (T_e8_DAB_ChannelInfoState value);

/**
 * enumeration for the different DAB tune operations that can be started.
 */
enum T_e8_DAB_TuneType {

    /**
     * If the meaning of "DAB_TUNETYPE_OFF" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneType__DAB_TUNETYPE_OFF = 0u,
    /**
     * If the meaning of "DAB_TUNETYPE_SELECT_PSID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_PSID = 1u,
    /**
     * If the meaning of "DAB_TUNETYPE_SELECT_COMPONENT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_COMPONENT = 2u,
    /**
     * If the meaning of "DAB_TUNETYPE_SELECT_FREQ" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_FREQ = 3u

};

bool T_e8_DAB_TuneType_Parse (const char *str, size_t length, T_e8_DAB_TuneType &value);

const char* T_e8_DAB_TuneType_Name (T_e8_DAB_TuneType value);

bool T_e8_DAB_TuneType_IsValid (T_e8_DAB_TuneType value);

/**
 * enumeration for the different DAB learn operations that can be started.
 */
enum T_e8_DAB_LearnType {

    /**
     * If the meaning of "DAB_LEARNTYPE_OFF" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LearnType__DAB_LEARNTYPE_OFF = 0u,
    /**
     * If the meaning of "DAB_LEARNTYPE_UPDATE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LearnType__DAB_LEARNTYPE_UPDATE = 1u,
    /**
     * If the meaning of "DAB_LEARNTYPE_VIRGIN" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LearnType__DAB_LEARNTYPE_VIRGIN = 2u

};

bool T_e8_DAB_LearnType_Parse (const char *str, size_t length, T_e8_DAB_LearnType &value);

const char* T_e8_DAB_LearnType_Name (T_e8_DAB_LearnType value);

bool T_e8_DAB_LearnType_IsValid (T_e8_DAB_LearnType value);

/**
 * Info about which tuner has been activated, or which tuner it is recommended to switch to.
 */
enum T_e8_DAB_SwitchTuner {

    /**
     * If the meaning of "DAB_SWITCH_TO_DAB" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SwitchTuner__DAB_SWITCH_TO_DAB = 0u,
    /**
     * If the meaning of "DAB_SWITCH_TO_FM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_SwitchTuner__DAB_SWITCH_TO_FM = 1u

};

bool T_e8_DAB_SwitchTuner_Parse (const char *str, size_t length, T_e8_DAB_SwitchTuner &value);

const char* T_e8_DAB_SwitchTuner_Name (T_e8_DAB_SwitchTuner value);

bool T_e8_DAB_SwitchTuner_IsValid (T_e8_DAB_SwitchTuner value);

/**
 * Info about which automatic tuner switches.
 */
enum T_e8_DAB_ServiceFollowingTuner {

    /**
     * If the meaning of "MAIN_DAB_TUNER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceFollowingTuner__MAIN_DAB_TUNER = 0u,
    /**
     * If the meaning of "MAIN_FM_TUNER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceFollowingTuner__MAIN_FM_TUNER = 1u

};

bool T_e8_DAB_ServiceFollowingTuner_Parse (const char *str, size_t length, T_e8_DAB_ServiceFollowingTuner &value);

const char* T_e8_DAB_ServiceFollowingTuner_Name (T_e8_DAB_ServiceFollowingTuner value);

bool T_e8_DAB_ServiceFollowingTuner_IsValid (T_e8_DAB_ServiceFollowingTuner value);

/**
 * Info if fc_dabtuner wants to be muted or demuted.
 */
enum T_e8_DAB_MuteStatus {

    /**
     * If the meaning of "MUTE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_MuteStatus__MUTE = 0u,
    /**
     * If the meaning of "DEMUTE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_MuteStatus__DEMUTE = 1u,
    /**
     * If the meaning of "DEMUTE_RUNNING" isn't clear, then there should be a description here.
     */
    T_e8_DAB_MuteStatus__DEMUTE_RUNNING = 2u

};

bool T_e8_DAB_MuteStatus_Parse (const char *str, size_t length, T_e8_DAB_MuteStatus &value);

const char* T_e8_DAB_MuteStatus_Name (T_e8_DAB_MuteStatus value);

bool T_e8_DAB_MuteStatus_IsValid (T_e8_DAB_MuteStatus value);

/**
 * Info if fc_dabtuner wants to be muted or demuted.
 */
enum T_e8_DAB_Source {

    /**
     * If the meaning of "DAB" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Source__DAB = 0u,
    /**
     * If the meaning of "DAB_TA" isn't clear, then there should be a description here.
     */
    T_e8_DAB_Source__DAB_TA = 1u

};

bool T_e8_DAB_Source_Parse (const char *str, size_t length, T_e8_DAB_Source &value);

const char* T_e8_DAB_Source_Name (T_e8_DAB_Source value);

bool T_e8_DAB_Source_IsValid (T_e8_DAB_Source value);

/**
 * Indicates the delete action: delete one or delete all elements in the preset list.
 */
enum T_e8_DAB_DeleteAction {

    /**
     * If the meaning of "PRESETLIST_DELACTION_ONE_ELEMENT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DeleteAction__PRESETLIST_DELACTION_ONE_ELEMENT = 0u,
    /**
     * If the meaning of "PRESETLIST_DELACTION_ALL_ELEMENTS" isn't clear, then there should be a description here.
     */
    T_e8_DAB_DeleteAction__PRESETLIST_DELACTION_ALL_ELEMENTS = 1u

};

bool T_e8_DAB_DeleteAction_Parse (const char *str, size_t length, T_e8_DAB_DeleteAction &value);

const char* T_e8_DAB_DeleteAction_Name (T_e8_DAB_DeleteAction value);

bool T_e8_DAB_DeleteAction_IsValid (T_e8_DAB_DeleteAction value);

/**
 * Indicates the action on a list.
 */
enum T_e8_DAB_ListOperation {

    /**
     * If the meaning of "OPEN" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ListOperation__OPEN = 0u,
    /**
     * If the meaning of "CLOSE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ListOperation__CLOSE = 1u,
    /**
     * If the meaning of "GET" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ListOperation__GET = 2u

};

bool T_e8_DAB_ListOperation_Parse (const char *str, size_t length, T_e8_DAB_ListOperation &value);

const char* T_e8_DAB_ListOperation_Name (T_e8_DAB_ListOperation value);

bool T_e8_DAB_ListOperation_IsValid (T_e8_DAB_ListOperation value);

/**
 * Indicates the type of the service list.
 */
enum T_e8_DAB_ServiceListType {

    /**
     * If the meaning of "GlobalList" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceListType__GlobalList = 0u,
    /**
     * If the meaning of "CurrentEnsembleList" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ServiceListType__CurrentEnsembleList = 1u

};

bool T_e8_DAB_ServiceListType_Parse (const char *str, size_t length, T_e8_DAB_ServiceListType &value);

const char* T_e8_DAB_ServiceListType_Name (T_e8_DAB_ServiceListType value);

bool T_e8_DAB_ServiceListType_IsValid (T_e8_DAB_ServiceListType value);

/**
 * The list of DAB Banks are contained in this structure.
 */
enum T_e8_DAB_BankList {

    /**
     * If the meaning of "BANK_DAB1" isn't clear, then there should be a description here.
     */
    T_e8_DAB_BankList__BANK_DAB1 = 13u,
    /**
     * If the meaning of "BANK_DAB2" isn't clear, then there should be a description here.
     */
    T_e8_DAB_BankList__BANK_DAB2 = 14u,
    /**
     * If the meaning of "BANK_DAB3" isn't clear, then there should be a description here.
     */
    T_e8_DAB_BankList__BANK_DAB3 = 15u,
    /**
     * If the meaning of "BANK_DABAST" isn't clear, then there should be a description here.
     */
    T_e8_DAB_BankList__BANK_DABAST = 16u

};

bool T_e8_DAB_BankList_Parse (const char *str, size_t length, T_e8_DAB_BankList &value);

const char* T_e8_DAB_BankList_Name (T_e8_DAB_BankList value);

bool T_e8_DAB_BankList_IsValid (T_e8_DAB_BankList value);

/**
 * Indicates the action on a list.
 */
enum T_e8_DAB_TestOperation {

    /**
     * If the meaning of "TUNE_ENSEMBLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__TUNE_ENSEMBLE = 1u,
    /**
     * If the meaning of "TUNE_SERVICE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__TUNE_SERVICE = 2u,
    /**
     * If the meaning of "TUNE_FREQUENCY" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__TUNE_FREQUENCY = 3u,
    /**
     * If the meaning of "PLAY_ASID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__PLAY_ASID = 4u,
    /**
     * If the meaning of "VERIFY_FREQ_ASID_AUDIO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__VERIFY_FREQ_ASID_AUDIO = 5u,
    /**
     * If the meaning of "REMOTE_CTRL_ENTER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__REMOTE_CTRL_ENTER = 6u,
    /**
     * If the meaning of "REMOTE_CTRL_LEAVE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TestOperation__REMOTE_CTRL_LEAVE = 7u

};

bool T_e8_DAB_TestOperation_Parse (const char *str, size_t length, T_e8_DAB_TestOperation &value);

const char* T_e8_DAB_TestOperation_Name (T_e8_DAB_TestOperation value);

bool T_e8_DAB_TestOperation_IsValid (T_e8_DAB_TestOperation value);

/**
 * Indicates the tune operation.
 */
enum T_e8_DAB_ManualMode_TuneOperation {

    /**
     * If the meaning of "TUNE_ENSEMBLE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__TUNE_ENSEMBLE = 1u,
    /**
     * If the meaning of "TUNE_SERVICE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__TUNE_SERVICE = 2u,
    /**
     * If the meaning of "TUNE_FREQUENCY" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__TUNE_FREQUENCY = 3u,
    /**
     * If the meaning of "PLAY_ASID" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__PLAY_ASID = 4u,
    /**
     * If the meaning of "VERIFY_FREQ_ASID_AUDIO" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__VERIFY_FREQ_ASID_AUDIO = 5u,
    /**
     * If the meaning of "REMOTE_CTRL_ENTER" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__REMOTE_CTRL_ENTER = 6u,
    /**
     * If the meaning of "REMOTE_CTRL_LEAVE" isn't clear, then there should be a description here.
     */
    T_e8_DAB_ManualMode_TuneOperation__REMOTE_CTRL_LEAVE = 7u

};

bool T_e8_DAB_ManualMode_TuneOperation_Parse (const char *str, size_t length, T_e8_DAB_ManualMode_TuneOperation &value);

const char* T_e8_DAB_ManualMode_TuneOperation_Name (T_e8_DAB_ManualMode_TuneOperation value);

bool T_e8_DAB_ManualMode_TuneOperation_IsValid (T_e8_DAB_ManualMode_TuneOperation value);

/**
 * .
 */
enum T_e8_DAB_LinkType {

    /**
     * If the meaning of "LINKTYPE_DAB_HARDLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_DAB_HARDLINK = 0u,
    /**
     * If the meaning of "LINKTYPE_DAB_SOFTLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_DAB_SOFTLINK = 1u,
    /**
     * If the meaning of "LINKTYPE_DAB_NOLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_DAB_NOLINK = 2u,
    /**
     * If the meaning of "LINKTYPE_FM_HARDLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_FM_HARDLINK = 3u,
    /**
     * If the meaning of "LINKTYPE_FM_SOFTLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_FM_SOFTLINK = 4u,
    /**
     * If the meaning of "LINKTYPE_FM_NOLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_FM_NOLINK = 5u,
    /**
     * If the meaning of "LINKTYPE_DAB_DBLINK" isn't clear, then there should be a description here.
     */
    T_e8_DAB_LinkType__LINKTYPE_DAB_DBLINK = 6u

};

bool T_e8_DAB_LinkType_Parse (const char *str, size_t length, T_e8_DAB_LinkType &value);

const char* T_e8_DAB_LinkType_Name (T_e8_DAB_LinkType value);

bool T_e8_DAB_LinkType_IsValid (T_e8_DAB_LinkType value);

/**
 * Type of tuner medium
 */
enum T_e8_DAB_TmcMediumType {

    /**
     * If the meaning of "DAB_MEDIUMTYPE_RESERVED" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_RESERVED = 0u,
    /**
     * If the meaning of "DAB_MEDIUMTYPE_FM" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_FM = 1u,
    /**
     * If the meaning of "DAB_MEDIUMTYPE_DAB" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_DAB = 2u,
    /**
     * If the meaning of "DAB_MEDIUMTYPE_SAT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_SAT = 3u

};

bool T_e8_DAB_TmcMediumType_Parse (const char *str, size_t length, T_e8_DAB_TmcMediumType &value);

const char* T_e8_DAB_TmcMediumType_Name (T_e8_DAB_TmcMediumType value);

bool T_e8_DAB_TmcMediumType_IsValid (T_e8_DAB_TmcMediumType value);

/**
 * Type of tuner medium
 */
enum T_e8_DAB_TuneCmd {

    /**
     * If the meaning of "DAB_TUNE_NEXT" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneCmd__DAB_TUNE_NEXT = 0u,
    /**
     * If the meaning of "DAB_TUNE_PREV" isn't clear, then there should be a description here.
     */
    T_e8_DAB_TuneCmd__DAB_TUNE_PREV = 1u

};

bool T_e8_DAB_TuneCmd_Parse (const char *str, size_t length, T_e8_DAB_TuneCmd &value);

const char* T_e8_DAB_TuneCmd_Name (T_e8_DAB_TuneCmd value);

bool T_e8_DAB_TuneCmd_IsValid (T_e8_DAB_TuneCmd value);

} // namespace dabtuner_main_fi_types

#endif // DABTUNER_MAIN_FI_TYPESCONST_H
