/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/stream/json.h"
#include "dabtuner_main_fi_typesConst.h"
#include <cstddef>
#include <cstdlib>

/**
 * Types dabtuner_main_fi_types
 */

using namespace ::asf::stream::json;

namespace dabtuner_main_fi_types {

bool T_e8_DAB_Response_Parse (const char *str, size_t length, T_e8_DAB_Response &value)
{
    static stringEntry entries[] = {
        {10,"DAB_RES_OK", 0U},
        {14,"DAB_RES_FAILED", 1U},
        {17,"DAB_RES_INPROCESS", 3U},
        {21,"DAB_RES_NOT_AVAILABLE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_Response_Name (T_e8_DAB_Response value)
{
    static const char* enumerationLiterals[] = {
        "DAB_RES_OK",
        "DAB_RES_FAILED",
        "DAB_RES_NOT_AVAILABLE",
        "DAB_RES_INPROCESS",
    };

    if (T_e8_DAB_Response_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_Response_IsValid (T_e8_DAB_Response value)
{
    switch (value) {
    case T_e8_DAB_Response__DAB_RES_OK:
    case T_e8_DAB_Response__DAB_RES_FAILED:
    case T_e8_DAB_Response__DAB_RES_NOT_AVAILABLE:
    case T_e8_DAB_Response__DAB_RES_INPROCESS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_UserProfileAction_Parse (const char *str, size_t length, T_e8_DAB_UserProfileAction &value)
{
    static stringEntry entries[] = {
        {16,"DAB_PROFILE_COPY", 2U},
        {18,"DAB_PROFILE_CHANGE", 0U},
        {18,"DAB_PROFILE_DELETE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_UserProfileAction_Name (T_e8_DAB_UserProfileAction value)
{
    static const char* enumerationLiterals[] = {
        "DAB_PROFILE_CHANGE",
        "DAB_PROFILE_DELETE",
        "DAB_PROFILE_COPY",
    };

    if (T_e8_DAB_UserProfileAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_UserProfileAction_IsValid (T_e8_DAB_UserProfileAction value)
{
    switch (value) {
    case T_e8_DAB_UserProfileAction__DAB_PROFILE_CHANGE:
    case T_e8_DAB_UserProfileAction__DAB_PROFILE_DELETE:
    case T_e8_DAB_UserProfileAction__DAB_PROFILE_COPY:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_SourceState_Parse (const char *str, size_t length, T_e8_DAB_SourceState &value)
{
    static stringEntry entries[] = {
        {14,"DAB_BACKGROUND", 0U},
        {14,"DAB_FOREGROUND", 1U},
        {17,"DAB_FOREGROUND_TA", 3U},
        {17,"DAB_LEARN_FOREVER", 7U},
        {20,"DAB_BG_LEARN_FOREVER", 8U},
        {20,"DAB_FOREGROUND_ALARM", 4U},
        {21,"DAB_SERVICE_FOLLOWING", 2U},
        {32,"DAB_BACKGROUND_ANNO_SURVEILLANCE", 5U},
        {32,"DAB_FOREGROUND_ANNO_SURVEILLANCE", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_DAB_SourceState_Name (T_e8_DAB_SourceState value)
{
    static const char* enumerationLiterals[] = {
        "DAB_BACKGROUND",
        "DAB_FOREGROUND",
        "DAB_SERVICE_FOLLOWING",
        "DAB_FOREGROUND_TA",
        "DAB_FOREGROUND_ALARM",
        "DAB_BACKGROUND_ANNO_SURVEILLANCE",
        "DAB_FOREGROUND_ANNO_SURVEILLANCE",
        "DAB_LEARN_FOREVER",
        "DAB_BG_LEARN_FOREVER",
    };

    if (T_e8_DAB_SourceState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_SourceState_IsValid (T_e8_DAB_SourceState value)
{
    switch (value) {
    case T_e8_DAB_SourceState__DAB_BACKGROUND:
    case T_e8_DAB_SourceState__DAB_FOREGROUND:
    case T_e8_DAB_SourceState__DAB_SERVICE_FOLLOWING:
    case T_e8_DAB_SourceState__DAB_FOREGROUND_TA:
    case T_e8_DAB_SourceState__DAB_FOREGROUND_ALARM:
    case T_e8_DAB_SourceState__DAB_BACKGROUND_ANNO_SURVEILLANCE:
    case T_e8_DAB_SourceState__DAB_FOREGROUND_ANNO_SURVEILLANCE:
    case T_e8_DAB_SourceState__DAB_LEARN_FOREVER:
    case T_e8_DAB_SourceState__DAB_BG_LEARN_FOREVER:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ServiceType_Parse (const char *str, size_t length, T_e8_DAB_ServiceType &value)
{
    static stringEntry entries[] = {
        {20,"DAB_SERVICETYPE_DATA", 2U},
        {21,"DAB_SERVICETYPE_AUDIO", 1U},
        {23,"DAB_SERVICETYPE_UNKNOWN", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_ServiceType_Name (T_e8_DAB_ServiceType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SERVICETYPE_UNKNOWN",
        "DAB_SERVICETYPE_AUDIO",
        "DAB_SERVICETYPE_DATA",
    };

    if (T_e8_DAB_ServiceType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ServiceType_IsValid (T_e8_DAB_ServiceType value)
{
    switch (value) {
    case T_e8_DAB_ServiceType__DAB_SERVICETYPE_UNKNOWN:
    case T_e8_DAB_ServiceType__DAB_SERVICETYPE_AUDIO:
    case T_e8_DAB_ServiceType__DAB_SERVICETYPE_DATA:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ServiceListSortingType_Parse (const char *str, size_t length, T_e8_DAB_ServiceListSortingType &value)
{
    static stringEntry entries[] = {
        {31,"DAB_SERVICELIST_SORTINGTYPE_SID", 1U},
        {33,"DAB_SERVICELIST_SORTINGTYPE_LABEL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_ServiceListSortingType_Name (T_e8_DAB_ServiceListSortingType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SERVICELIST_SORTINGTYPE_LABEL",
        "DAB_SERVICELIST_SORTINGTYPE_SID",
    };

    if (T_e8_DAB_ServiceListSortingType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ServiceListSortingType_IsValid (T_e8_DAB_ServiceListSortingType value)
{
    switch (value) {
    case T_e8_DAB_ServiceListSortingType__DAB_SERVICELIST_SORTINGTYPE_LABEL:
    case T_e8_DAB_ServiceListSortingType__DAB_SERVICELIST_SORTINGTYPE_SID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_EnsembleListSortingType_Parse (const char *str, size_t length, T_e8_DAB_EnsembleListSortingType &value)
{
    static stringEntry entries[] = {
        {32,"DAB_ENSEMBLELIST_SORTINGTYPE_EID", 2U},
        {33,"DAB_ENSEMBLELIST_SORTINGTYPE_FREQ", 1U},
        {34,"DAB_ENSEMBLELIST_SORTINGTYPE_LABEL", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_EnsembleListSortingType_Name (T_e8_DAB_EnsembleListSortingType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ENSEMBLELIST_SORTINGTYPE_LABEL",
        "DAB_ENSEMBLELIST_SORTINGTYPE_FREQ",
        "DAB_ENSEMBLELIST_SORTINGTYPE_EID",
    };

    if (T_e8_DAB_EnsembleListSortingType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_EnsembleListSortingType_IsValid (T_e8_DAB_EnsembleListSortingType value)
{
    switch (value) {
    case T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_LABEL:
    case T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_FREQ:
    case T_e8_DAB_EnsembleListSortingType__DAB_ENSEMBLELIST_SORTINGTYPE_EID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AST_Type_Parse (const char *str, size_t length, T_e8_DAB_AST_Type &value)
{
    static stringEntry entries[] = {
        {14,"DAB_AST_NORMAL", 0U},
        {15,"DAB_AST_INITIAL", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_AST_Type_Name (T_e8_DAB_AST_Type value)
{
    static const char* enumerationLiterals[] = {
        "DAB_AST_NORMAL",
        "DAB_AST_INITIAL",
    };

    if (T_e8_DAB_AST_Type_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AST_Type_IsValid (T_e8_DAB_AST_Type value)
{
    switch (value) {
    case T_e8_DAB_AST_Type__DAB_AST_NORMAL:
    case T_e8_DAB_AST_Type__DAB_AST_INITIAL:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ServiceLinkingMode_Parse (const char *str, size_t length, T_e8_DAB_ServiceLinkingMode &value)
{
    static stringEntry entries[] = {
        {21,"DAB_SERVICELINKING_FM", 3U},
        {22,"DAB_SERVICELINKING_DAB", 1U},
        {22,"DAB_SERVICELINKING_OFF", 0U},
        {25,"DAB_SERVICELINKING_DAB_FM", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_ServiceLinkingMode_Name (T_e8_DAB_ServiceLinkingMode value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SERVICELINKING_OFF",
        "DAB_SERVICELINKING_DAB",
        "DAB_SERVICELINKING_DAB_FM",
        "DAB_SERVICELINKING_FM",
    };

    if (T_e8_DAB_ServiceLinkingMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ServiceLinkingMode_IsValid (T_e8_DAB_ServiceLinkingMode value)
{
    switch (value) {
    case T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_OFF:
    case T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_DAB:
    case T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_DAB_FM:
    case T_e8_DAB_ServiceLinkingMode__DAB_SERVICELINKING_FM:
        return true;
    default:
        return false;
    }
}

bool T_e8_MTC_Request_Parse (const char *str, size_t length, T_e8_MTC_Request &value)
{
    static stringEntry entries[] = {
        {21,"DAB_SERVICELINKING_FM", 0U},
        {21,"FM_SERVICELINKING_DAB", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_MTC_Request_Name (T_e8_MTC_Request value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SERVICELINKING_FM",
        "FM_SERVICELINKING_DAB",
    };

    if (T_e8_MTC_Request_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MTC_Request_IsValid (T_e8_MTC_Request value)
{
    switch (value) {
    case T_e8_MTC_Request__DAB_SERVICELINKING_FM:
    case T_e8_MTC_Request__FM_SERVICELINKING_DAB:
        return true;
    default:
        return false;
    }
}

bool T_e8_MTC_Tuner_Status_Parse (const char *str, size_t length, T_e8_MTC_Tuner_Status &value)
{
    static stringEntry entries[] = {
        {13,"MAIN_FM_TUNER", 1U},
        {14,"MAIN_DAB_TUNER", 0U},
        {18,"MAIN_TUNER_UNKNOWN", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_MTC_Tuner_Status_Name (T_e8_MTC_Tuner_Status value)
{
    static const char* enumerationLiterals[] = {
        "MAIN_DAB_TUNER",
        "MAIN_FM_TUNER",
        "MAIN_TUNER_UNKNOWN",
    };

    if (T_e8_MTC_Tuner_Status_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MTC_Tuner_Status_IsValid (T_e8_MTC_Tuner_Status value)
{
    switch (value) {
    case T_e8_MTC_Tuner_Status__MAIN_DAB_TUNER:
    case T_e8_MTC_Tuner_Status__MAIN_FM_TUNER:
    case T_e8_MTC_Tuner_Status__MAIN_TUNER_UNKNOWN:
        return true;
    default:
        return false;
    }
}

bool T_e8_MTC_Tuner_ActivityState_Parse (const char *str, size_t length, T_e8_MTC_Tuner_ActivityState &value)
{
    static stringEntry entries[] = {
        {7,"STOPPED", 0U},
        {21,"START_FM_ANNOUNCEMENT", 1U},
        {22,"START_DAB_ANNOUNCEMENT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_MTC_Tuner_ActivityState_Name (T_e8_MTC_Tuner_ActivityState value)
{
    static const char* enumerationLiterals[] = {
        "Stopped",
        "Start_FM_Announcement",
        "Start_DAB_Announcement",
    };

    if (T_e8_MTC_Tuner_ActivityState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_MTC_Tuner_ActivityState_IsValid (T_e8_MTC_Tuner_ActivityState value)
{
    switch (value) {
    case T_e8_MTC_Tuner_ActivityState__Stopped:
    case T_e8_MTC_Tuner_ActivityState__Start_FM_Announcement:
    case T_e8_MTC_Tuner_ActivityState__Start_DAB_Announcement:
        return true;
    default:
        return false;
    }
}

bool T_e8_StationType_Parse (const char *str, size_t length, T_e8_StationType &value)
{
    static stringEntry entries[] = {
        {2,"FM", 1U},
        {3,"DAB", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_StationType_Name (T_e8_StationType value)
{
    static const char* enumerationLiterals[] = {
        "DAB",
        "FM",
    };

    if (T_e8_StationType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_StationType_IsValid (T_e8_StationType value)
{
    switch (value) {
    case T_e8_StationType__DAB:
    case T_e8_StationType__FM:
        return true;
    default:
        return false;
    }
}

bool T_e8_TPState_Parse (const char *str, size_t length, T_e8_TPState &value)
{
    static stringEntry entries[] = {
        {2,"TP", 1U},
        {5,"NO_TP", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_TPState_Name (T_e8_TPState value)
{
    static const char* enumerationLiterals[] = {
        "NO_TP",
        "TP",
    };

    if (T_e8_TPState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_TPState_IsValid (T_e8_TPState value)
{
    switch (value) {
    case T_e8_TPState__NO_TP:
    case T_e8_TPState__TP:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_SampleRate_Parse (const char *str, size_t length, T_e8_DAB_SampleRate &value)
{
    static stringEntry entries[] = {
        {20,"DAB_SAMPLERATE_24KHZ", 1U},
        {20,"DAB_SAMPLERATE_48KHZ", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_SampleRate_Name (T_e8_DAB_SampleRate value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SAMPLERATE_48KHZ",
        "DAB_SAMPLERATE_24KHZ",
    };

    if (T_e8_DAB_SampleRate_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_SampleRate_IsValid (T_e8_DAB_SampleRate value)
{
    switch (value) {
    case T_e8_DAB_SampleRate__DAB_SAMPLERATE_48KHZ:
    case T_e8_DAB_SampleRate__DAB_SAMPLERATE_24KHZ:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AudioMode_Parse (const char *str, size_t length, T_e8_DAB_AudioMode &value)
{
    static stringEntry entries[] = {
        {18,"DAB_AUDIOMODE_MONO", 3U},
        {20,"DAB_AUDIOMODE_STEREO", 0U},
        {26,"DAB_AUDIOMODE_DUAL_CHANNEL", 2U},
        {26,"DAB_AUDIOMODE_JOINT_STEREO", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_AudioMode_Name (T_e8_DAB_AudioMode value)
{
    static const char* enumerationLiterals[] = {
        "DAB_AUDIOMODE_STEREO",
        "DAB_AUDIOMODE_JOINT_STEREO",
        "DAB_AUDIOMODE_DUAL_CHANNEL",
        "DAB_AUDIOMODE_MONO",
    };

    if (T_e8_DAB_AudioMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AudioMode_IsValid (T_e8_DAB_AudioMode value)
{
    switch (value) {
    case T_e8_DAB_AudioMode__DAB_AUDIOMODE_STEREO:
    case T_e8_DAB_AudioMode__DAB_AUDIOMODE_JOINT_STEREO:
    case T_e8_DAB_AudioMode__DAB_AUDIOMODE_DUAL_CHANNEL:
    case T_e8_DAB_AudioMode__DAB_AUDIOMODE_MONO:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AudioCodec_Parse (const char *str, size_t length, T_e8_DAB_AudioCodec &value)
{
    static stringEntry entries[] = {
        {22,"DAB_AUDIOCODEC_DABPLUS", 2U},
        {22,"DAB_AUDIOCODEC_MUSICAM", 1U},
        {24,"DAB_AUDIOCODEC_DMB_AUDIO", 3U},
        {29,"DAB_AUDIOCODEC_NOT_RECOGNIZED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_AudioCodec_Name (T_e8_DAB_AudioCodec value)
{
    static const char* enumerationLiterals[] = {
        "DAB_AUDIOCODEC_NOT_RECOGNIZED",
        "DAB_AUDIOCODEC_MUSICAM",
        "DAB_AUDIOCODEC_DABPLUS",
        "DAB_AUDIOCODEC_DMB_AUDIO",
    };

    if (T_e8_DAB_AudioCodec_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AudioCodec_IsValid (T_e8_DAB_AudioCodec value)
{
    switch (value) {
    case T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_NOT_RECOGNIZED:
    case T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_MUSICAM:
    case T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_DABPLUS:
    case T_e8_DAB_AudioCodec__DAB_AUDIOCODEC_DMB_AUDIO:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_Encoding_Parse (const char *str, size_t length, T_e8_DAB_Encoding &value)
{
    static stringEntry entries[] = {
        {17,"DAB_ENCODING_BSAC", 3U},
        {18,"DAB_ENCODING_HEAAC", 2U},
        {18,"DAB_ENCODING_MPEG1", 0U},
        {18,"DAB_ENCODING_MPEG2", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_Encoding_Name (T_e8_DAB_Encoding value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ENCODING_MPEG1",
        "DAB_ENCODING_MPEG2",
        "DAB_ENCODING_HEAAC",
        "DAB_ENCODING_BSAC",
    };

    if (T_e8_DAB_Encoding_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_Encoding_IsValid (T_e8_DAB_Encoding value)
{
    switch (value) {
    case T_e8_DAB_Encoding__DAB_ENCODING_MPEG1:
    case T_e8_DAB_Encoding__DAB_ENCODING_MPEG2:
    case T_e8_DAB_Encoding__DAB_ENCODING_HEAAC:
    case T_e8_DAB_Encoding__DAB_ENCODING_BSAC:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ComponentType_Parse (const char *str, size_t length, T_e8_DAB_ComponentType &value)
{
    static stringEntry entries[] = {
        {25,"DAB_COMPONENTTYPE_PRIMARY", 0U},
        {27,"DAB_COMPONENTTYPE_SECONDARY", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_ComponentType_Name (T_e8_DAB_ComponentType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_COMPONENTTYPE_PRIMARY",
        "DAB_COMPONENTTYPE_SECONDARY",
    };

    if (T_e8_DAB_ComponentType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ComponentType_IsValid (T_e8_DAB_ComponentType value)
{
    switch (value) {
    case T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_PRIMARY:
    case T_e8_DAB_ComponentType__DAB_COMPONENTTYPE_SECONDARY:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TMIdType_Parse (const char *str, size_t length, T_e8_DAB_TMIdType &value)
{
    static stringEntry entries[] = {
        {17,"DAB_TMIDTYPE_FIDC", 2U},
        {28,"DAB_TMIDTYPE_MSC_DATA_PACKET", 3U},
        {28,"DAB_TMIDTYPE_MSC_DATA_STREAM", 1U},
        {29,"DAB_TMIDTYPE_MSC_AUDIO_STREAM", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_TMIdType_Name (T_e8_DAB_TMIdType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_TMIDTYPE_MSC_AUDIO_STREAM",
        "DAB_TMIDTYPE_MSC_DATA_STREAM",
        "DAB_TMIDTYPE_FIDC",
        "DAB_TMIDTYPE_MSC_DATA_PACKET",
    };

    if (T_e8_DAB_TMIdType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_TMIdType_IsValid (T_e8_DAB_TMIdType value)
{
    switch (value) {
    case T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_AUDIO_STREAM:
    case T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_DATA_STREAM:
    case T_e8_DAB_TMIdType__DAB_TMIDTYPE_FIDC:
    case T_e8_DAB_TMIdType__DAB_TMIDTYPE_MSC_DATA_PACKET:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AudioServiceComponentType_Parse (const char *str, size_t length, T_e8_DAB_AudioServiceComponentType &value)
{
    static stringEntry entries[] = {
        {18,"DAB_ASCTY_BG_SOUND", 1U},
        {18,"DAB_ASCTY_FG_SOUND", 0U},
        {23,"DAB_ASCTY_MULTI_CHANNEL", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_AudioServiceComponentType_Name (T_e8_DAB_AudioServiceComponentType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ASCTY_FG_SOUND",
        "DAB_ASCTY_BG_SOUND",
        "DAB_ASCTY_MULTI_CHANNEL",
    };

    if (T_e8_DAB_AudioServiceComponentType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AudioServiceComponentType_IsValid (T_e8_DAB_AudioServiceComponentType value)
{
    switch (value) {
    case T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_FG_SOUND:
    case T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_BG_SOUND:
    case T_e8_DAB_AudioServiceComponentType__DAB_ASCTY_MULTI_CHANNEL:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_DataServiceComponentType_Parse (const char *str, size_t length, T_e8_DAB_DataServiceComponentType &value)
{
    static stringEntry entries[] = {
        {13,"DAB_DSCTY_EWS", 2U},
        {13,"DAB_DSCTY_MOT", 60U},
        {13,"DAB_DSCTY_TMC", 1U},
        {14,"DAB_DSCTY_ITTS", 3U},
        {16,"DAB_DSCTY_PAGING", 4U},
        {23,"DAB_DSCTY_NOT_SPECIFIED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DAB_DataServiceComponentType_Name (T_e8_DAB_DataServiceComponentType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_DSCTY_NOT_SPECIFIED",
        "DAB_DSCTY_TMC",
        "DAB_DSCTY_EWS",
        "DAB_DSCTY_ITTS",
        "DAB_DSCTY_PAGING",
        "DAB_DSCTY_MOT",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        2U,
        3U,
        4U,
        60U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 6, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DAB_DataServiceComponentType_IsValid (T_e8_DAB_DataServiceComponentType value)
{
    switch (value) {
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_NOT_SPECIFIED:
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_TMC:
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_EWS:
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_ITTS:
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_PAGING:
    case T_e8_DAB_DataServiceComponentType__DAB_DSCTY_MOT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AnnouncementSelectState_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementSelectState &value)
{
    static stringEntry entries[] = {
        {4,"IDLE", 0U},
        {7,"PENDING", 1U},
        {8,"SELECTED", 3U},
        {9,"SELECTING", 2U},
        {11,"DESELECTING", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 5, (unsigned int&) value);
}

const char* T_e8_DAB_AnnouncementSelectState_Name (T_e8_DAB_AnnouncementSelectState value)
{
    static const char* enumerationLiterals[] = {
        "IDLE",
        "PENDING",
        "SELECTING",
        "SELECTED",
        "DESELECTING",
    };

    if (T_e8_DAB_AnnouncementSelectState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AnnouncementSelectState_IsValid (T_e8_DAB_AnnouncementSelectState value)
{
    switch (value) {
    case T_e8_DAB_AnnouncementSelectState__IDLE:
    case T_e8_DAB_AnnouncementSelectState__PENDING:
    case T_e8_DAB_AnnouncementSelectState__SELECTING:
    case T_e8_DAB_AnnouncementSelectState__SELECTED:
    case T_e8_DAB_AnnouncementSelectState__DESELECTING:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AnnouncementStatus_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementStatus &value)
{
    static stringEntry entries[] = {
        {3,"END", 2U},
        {5,"START", 1U},
        {7,"ESCAPED", 3U},
        {8,"SWITCHED", 4U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_AnnouncementStatus_Name (T_e8_DAB_AnnouncementStatus value)
{
    static const char* enumerationLiterals[] = {
        "START",
        "END",
        "ESCAPED",
        "SWITCHED",
    };

    if (T_e8_DAB_AnnouncementStatus_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_DAB_AnnouncementStatus_IsValid (T_e8_DAB_AnnouncementStatus value)
{
    switch (value) {
    case T_e8_DAB_AnnouncementStatus__START:
    case T_e8_DAB_AnnouncementStatus__END:
    case T_e8_DAB_AnnouncementStatus__ESCAPED:
    case T_e8_DAB_AnnouncementStatus__SWITCHED:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_AnnouncementSource_Parse (const char *str, size_t length, T_e8_DAB_AnnouncementSource &value)
{
    static stringEntry entries[] = {
        {19,"DAB_ANNOSOURCE_NONE", 0U},
        {30,"DAB_ANNOSOURCE_CURRENT_SERVICE", 2U},
        {31,"DAB_ANNOSOURCE_CURRENT_ENSEMBLE", 3U},
        {33,"DAB_ANNOSOURCE_CURRENT_SUBCHANNEL", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_AnnouncementSource_Name (T_e8_DAB_AnnouncementSource value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ANNOSOURCE_NONE",
        "DAB_ANNOSOURCE_CURRENT_SUBCHANNEL",
        "DAB_ANNOSOURCE_CURRENT_SERVICE",
        "DAB_ANNOSOURCE_CURRENT_ENSEMBLE",
    };

    if (T_e8_DAB_AnnouncementSource_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_AnnouncementSource_IsValid (T_e8_DAB_AnnouncementSource value)
{
    switch (value) {
    case T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_NONE:
    case T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_SUBCHANNEL:
    case T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_SERVICE:
    case T_e8_DAB_AnnouncementSource__DAB_ANNOSOURCE_CURRENT_ENSEMBLE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ChnSelectMode_Parse (const char *str, size_t length, T_e8_DAB_ChnSelectMode &value)
{
    static stringEntry entries[] = {
        {22,"DAB_CHNSELECTMODE_PSDI", 0U},
        {24,"DAB_CHNSELECTMODE_LISTID", 1U},
        {26,"DAB_CHNSELECTMODE_RELATIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_ChnSelectMode_Name (T_e8_DAB_ChnSelectMode value)
{
    static const char* enumerationLiterals[] = {
        "DAB_CHNSELECTMODE_PSDI",
        "DAB_CHNSELECTMODE_LISTID",
        "DAB_CHNSELECTMODE_RELATIVE",
    };

    if (T_e8_DAB_ChnSelectMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ChnSelectMode_IsValid (T_e8_DAB_ChnSelectMode value)
{
    switch (value) {
    case T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_PSDI:
    case T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_LISTID:
    case T_e8_DAB_ChnSelectMode__DAB_CHNSELECTMODE_RELATIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_EnsSelectMode_Parse (const char *str, size_t length, T_e8_DAB_EnsSelectMode &value)
{
    static stringEntry entries[] = {
        {23,"DAB_ENSSELECTMODE_ENSID", 0U},
        {24,"DAB_ENSSELECTMODE_LISTID", 1U},
        {26,"DAB_ENSSELECTMODE_RELATIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_EnsSelectMode_Name (T_e8_DAB_EnsSelectMode value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ENSSELECTMODE_ENSID",
        "DAB_ENSSELECTMODE_LISTID",
        "DAB_ENSSELECTMODE_RELATIVE",
    };

    if (T_e8_DAB_EnsSelectMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_EnsSelectMode_IsValid (T_e8_DAB_EnsSelectMode value)
{
    switch (value) {
    case T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_ENSID:
    case T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_LISTID:
    case T_e8_DAB_EnsSelectMode__DAB_ENSSELECTMODE_RELATIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_CompSelectMode_Parse (const char *str, size_t length, T_e8_DAB_CompSelectMode &value)
{
    static stringEntry entries[] = {
        {22,"DAB_CHNSELECTMODE_SCID", 0U},
        {24,"DAB_CHNSELECTMODE_LISTID", 1U},
        {26,"DAB_CHNSELECTMODE_RELATIVE", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_CompSelectMode_Name (T_e8_DAB_CompSelectMode value)
{
    static const char* enumerationLiterals[] = {
        "DAB_CHNSELECTMODE_SCID",
        "DAB_CHNSELECTMODE_LISTID",
        "DAB_CHNSELECTMODE_RELATIVE",
    };

    if (T_e8_DAB_CompSelectMode_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_CompSelectMode_IsValid (T_e8_DAB_CompSelectMode value)
{
    switch (value) {
    case T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_SCID:
    case T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_LISTID:
    case T_e8_DAB_CompSelectMode__DAB_CHNSELECTMODE_RELATIVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_UriSelectState_Parse (const char *str, size_t length, T_e8_DAB_UriSelectState &value)
{
    static stringEntry entries[] = {
        {23,"DAB_URI_SELECT_STATE_OK", 0U},
        {26,"DAB_URI_SELECT_STATE_ERROR", 65535U},
        {30,"DAB_URI_SELECT_STATE_NOT_VALID", 1U},
        {33,"DAB_URI_SELECT_STATE_NOT_SELECTED", 18U},
        {33,"DAB_URI_SELECT_STATE_NO_RESOURCES", 4U},
        {34,"DAB_URI_SELECT_STATE_URI_ACTIVATED", 33U},
        {34,"DAB_URI_SELECT_STATE_URI_NOT_VALID", 5U},
        {35,"DAB_URI_SELECT_STATE_URI_PROCESSING", 32U},
        {37,"DAB_URI_SELECT_STATE_ALREADY_SELECTED", 17U},
        {47,"DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION", 35U},
        {47,"DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER", 34U},
        {48,"DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER", 36U},
        {48,"DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS", 37U},
    };

    return lookupInStringEntryTable (str, length, entries, 13, (unsigned int&) value);
}

const char* T_e8_DAB_UriSelectState_Name (T_e8_DAB_UriSelectState value)
{
    static const char* enumerationLiterals[] = {
        "DAB_URI_SELECT_STATE_OK",
        "DAB_URI_SELECT_STATE_NOT_VALID",
        "DAB_URI_SELECT_STATE_NO_RESOURCES",
        "DAB_URI_SELECT_STATE_URI_NOT_VALID",
        "DAB_URI_SELECT_STATE_ALREADY_SELECTED",
        "DAB_URI_SELECT_STATE_NOT_SELECTED",
        "DAB_URI_SELECT_STATE_URI_PROCESSING",
        "DAB_URI_SELECT_STATE_URI_ACTIVATED",
        "DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER",
        "DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION",
        "DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER",
        "DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS",
        "DAB_URI_SELECT_STATE_ERROR",
    };

    static unsigned int enumerationValues[] = {
        0U,
        1U,
        4U,
        5U,
        17U,
        18U,
        32U,
        33U,
        34U,
        35U,
        36U,
        37U,
        65535U,
    };

    unsigned int* result = (unsigned int*) bsearch ((const void *) &value, (const void *) enumerationValues, 13, sizeof(int), (int(*)(const void*,const void*)) compareUnsignedInts);
    if (result != 0) {
        int enumIndex = (int) (result-enumerationValues);
        return enumerationLiterals [enumIndex];
    }
    return NULL;
}

bool T_e8_DAB_UriSelectState_IsValid (T_e8_DAB_UriSelectState value)
{
    switch (value) {
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_OK:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NOT_VALID:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NO_RESOURCES:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_NOT_VALID:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_ALREADY_SELECTED:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_NOT_SELECTED:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_PROCESSING:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACTIVATED:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_SCHEDULER:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_ACIVATE_FAIL_RECEPTION:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SCHEDULER:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_URI_DEACIVATED_BY_SYNC_LOSS:
    case T_e8_DAB_UriSelectState__DAB_URI_SELECT_STATE_ERROR:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TunerActivityType_Parse (const char *str, size_t length, T_e8_DAB_TunerActivityType &value)
{
    static stringEntry entries[] = {
        {21,"DAB_ACTIVITYTYPE_SCAN", 3U},
        {21,"DAB_ACTIVITYTYPE_SEEK", 2U},
        {22,"DAB_ACTIVITYTYPE_LEARN", 1U},
        {23,"DAB_ACTIVITYTYPE_NORMAL", 0U},
        {24,"DAB_ACTIVITYTYPE_INVALID", 8U},
        {26,"DAB_ACTIVITYTYPE_TPMONITOR", 7U},
        {28,"DAB_ACTIVITYTYPE_SERVICESEEK", 4U},
        {28,"DAB_ACTIVITYTYPE_TAFOLLOWING", 5U},
        {33,"DAB_ACTIVITYTYPE_SERVICEFOLLOWING", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 9, (unsigned int&) value);
}

const char* T_e8_DAB_TunerActivityType_Name (T_e8_DAB_TunerActivityType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_ACTIVITYTYPE_NORMAL",
        "DAB_ACTIVITYTYPE_LEARN",
        "DAB_ACTIVITYTYPE_SEEK",
        "DAB_ACTIVITYTYPE_SCAN",
        "DAB_ACTIVITYTYPE_SERVICESEEK",
        "DAB_ACTIVITYTYPE_TAFOLLOWING",
        "DAB_ACTIVITYTYPE_SERVICEFOLLOWING",
        "DAB_ACTIVITYTYPE_TPMONITOR",
        "DAB_ACTIVITYTYPE_INVALID",
    };

    if (T_e8_DAB_TunerActivityType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_TunerActivityType_IsValid (T_e8_DAB_TunerActivityType value)
{
    switch (value) {
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_NORMAL:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_LEARN:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SEEK:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SCAN:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SERVICESEEK:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_TAFOLLOWING:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_SERVICEFOLLOWING:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_TPMONITOR:
    case T_e8_DAB_TunerActivityType__DAB_ACTIVITYTYPE_INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_FrequencyTable_Parse (const char *str, size_t length, T_e8_DAB_FrequencyTable &value)
{
    static stringEntry entries[] = {
        {18,"DAB_FREQTABLE_AUTO", 0U},
        {20,"DAB_FREQTABLE_CANADA", 4U},
        {21,"DAB_FREQTABLE_EU_BOTH", 1U},
        {23,"DAB_FREQTABLE_EU_BAND_3", 3U},
        {23,"DAB_FREQTABLE_EU_L_BAND", 2U},
        {25,"DAB_FREQTABLE_EU_BOTH_NEW", 5U},
        {27,"DAB_FREQTABLE_EU_BAND_3_NEW", 6U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DAB_FrequencyTable_Name (T_e8_DAB_FrequencyTable value)
{
    static const char* enumerationLiterals[] = {
        "DAB_FREQTABLE_AUTO",
        "DAB_FREQTABLE_EU_BOTH",
        "DAB_FREQTABLE_EU_L_BAND",
        "DAB_FREQTABLE_EU_BAND_3",
        "DAB_FREQTABLE_CANADA",
        "DAB_FREQTABLE_EU_BOTH_NEW",
        "DAB_FREQTABLE_EU_BAND_3_NEW",
    };

    if (T_e8_DAB_FrequencyTable_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_FrequencyTable_IsValid (T_e8_DAB_FrequencyTable value)
{
    switch (value) {
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_AUTO:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BOTH:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_L_BAND:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BAND_3:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_CANADA:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BOTH_NEW:
    case T_e8_DAB_FrequencyTable__DAB_FREQTABLE_EU_BAND_3_NEW:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ChannelInfoState_Parse (const char *str, size_t length, T_e8_DAB_ChannelInfoState &value)
{
    static stringEntry entries[] = {
        {10,"DAB_STABLE", 0U},
        {11,"DAB_INVALID", 5U},
        {11,"DAB_UNAVAIL", 4U},
        {13,"DAB_SELECTING", 1U},
        {18,"DAB_SELECTING_WAIT", 2U},
        {20,"DAB_SELECTING_SEARCH", 3U},
    };

    return lookupInStringEntryTable (str, length, entries, 6, (unsigned int&) value);
}

const char* T_e8_DAB_ChannelInfoState_Name (T_e8_DAB_ChannelInfoState value)
{
    static const char* enumerationLiterals[] = {
        "DAB_STABLE",
        "DAB_SELECTING",
        "DAB_SELECTING_WAIT",
        "DAB_SELECTING_SEARCH",
        "DAB_UNAVAIL",
        "DAB_INVALID",
    };

    if (T_e8_DAB_ChannelInfoState_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ChannelInfoState_IsValid (T_e8_DAB_ChannelInfoState value)
{
    switch (value) {
    case T_e8_DAB_ChannelInfoState__DAB_STABLE:
    case T_e8_DAB_ChannelInfoState__DAB_SELECTING:
    case T_e8_DAB_ChannelInfoState__DAB_SELECTING_WAIT:
    case T_e8_DAB_ChannelInfoState__DAB_SELECTING_SEARCH:
    case T_e8_DAB_ChannelInfoState__DAB_UNAVAIL:
    case T_e8_DAB_ChannelInfoState__DAB_INVALID:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TuneType_Parse (const char *str, size_t length, T_e8_DAB_TuneType &value)
{
    static stringEntry entries[] = {
        {16,"DAB_TUNETYPE_OFF", 0U},
        {24,"DAB_TUNETYPE_SELECT_FREQ", 3U},
        {24,"DAB_TUNETYPE_SELECT_PSID", 1U},
        {29,"DAB_TUNETYPE_SELECT_COMPONENT", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_TuneType_Name (T_e8_DAB_TuneType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_TUNETYPE_OFF",
        "DAB_TUNETYPE_SELECT_PSID",
        "DAB_TUNETYPE_SELECT_COMPONENT",
        "DAB_TUNETYPE_SELECT_FREQ",
    };

    if (T_e8_DAB_TuneType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_TuneType_IsValid (T_e8_DAB_TuneType value)
{
    switch (value) {
    case T_e8_DAB_TuneType__DAB_TUNETYPE_OFF:
    case T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_PSID:
    case T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_COMPONENT:
    case T_e8_DAB_TuneType__DAB_TUNETYPE_SELECT_FREQ:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_LearnType_Parse (const char *str, size_t length, T_e8_DAB_LearnType &value)
{
    static stringEntry entries[] = {
        {17,"DAB_LEARNTYPE_OFF", 0U},
        {20,"DAB_LEARNTYPE_UPDATE", 1U},
        {20,"DAB_LEARNTYPE_VIRGIN", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_LearnType_Name (T_e8_DAB_LearnType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_LEARNTYPE_OFF",
        "DAB_LEARNTYPE_UPDATE",
        "DAB_LEARNTYPE_VIRGIN",
    };

    if (T_e8_DAB_LearnType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_LearnType_IsValid (T_e8_DAB_LearnType value)
{
    switch (value) {
    case T_e8_DAB_LearnType__DAB_LEARNTYPE_OFF:
    case T_e8_DAB_LearnType__DAB_LEARNTYPE_UPDATE:
    case T_e8_DAB_LearnType__DAB_LEARNTYPE_VIRGIN:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_SwitchTuner_Parse (const char *str, size_t length, T_e8_DAB_SwitchTuner &value)
{
    static stringEntry entries[] = {
        {16,"DAB_SWITCH_TO_FM", 1U},
        {17,"DAB_SWITCH_TO_DAB", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_SwitchTuner_Name (T_e8_DAB_SwitchTuner value)
{
    static const char* enumerationLiterals[] = {
        "DAB_SWITCH_TO_DAB",
        "DAB_SWITCH_TO_FM",
    };

    if (T_e8_DAB_SwitchTuner_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_SwitchTuner_IsValid (T_e8_DAB_SwitchTuner value)
{
    switch (value) {
    case T_e8_DAB_SwitchTuner__DAB_SWITCH_TO_DAB:
    case T_e8_DAB_SwitchTuner__DAB_SWITCH_TO_FM:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ServiceFollowingTuner_Parse (const char *str, size_t length, T_e8_DAB_ServiceFollowingTuner &value)
{
    static stringEntry entries[] = {
        {13,"MAIN_FM_TUNER", 1U},
        {14,"MAIN_DAB_TUNER", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_ServiceFollowingTuner_Name (T_e8_DAB_ServiceFollowingTuner value)
{
    static const char* enumerationLiterals[] = {
        "MAIN_DAB_TUNER",
        "MAIN_FM_TUNER",
    };

    if (T_e8_DAB_ServiceFollowingTuner_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ServiceFollowingTuner_IsValid (T_e8_DAB_ServiceFollowingTuner value)
{
    switch (value) {
    case T_e8_DAB_ServiceFollowingTuner__MAIN_DAB_TUNER:
    case T_e8_DAB_ServiceFollowingTuner__MAIN_FM_TUNER:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_MuteStatus_Parse (const char *str, size_t length, T_e8_DAB_MuteStatus &value)
{
    static stringEntry entries[] = {
        {4,"MUTE", 0U},
        {6,"DEMUTE", 1U},
        {14,"DEMUTE_RUNNING", 2U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_MuteStatus_Name (T_e8_DAB_MuteStatus value)
{
    static const char* enumerationLiterals[] = {
        "MUTE",
        "DEMUTE",
        "DEMUTE_RUNNING",
    };

    if (T_e8_DAB_MuteStatus_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_MuteStatus_IsValid (T_e8_DAB_MuteStatus value)
{
    switch (value) {
    case T_e8_DAB_MuteStatus__MUTE:
    case T_e8_DAB_MuteStatus__DEMUTE:
    case T_e8_DAB_MuteStatus__DEMUTE_RUNNING:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_Source_Parse (const char *str, size_t length, T_e8_DAB_Source &value)
{
    static stringEntry entries[] = {
        {3,"DAB", 0U},
        {6,"DAB_TA", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_Source_Name (T_e8_DAB_Source value)
{
    static const char* enumerationLiterals[] = {
        "DAB",
        "DAB_TA",
    };

    if (T_e8_DAB_Source_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_Source_IsValid (T_e8_DAB_Source value)
{
    switch (value) {
    case T_e8_DAB_Source__DAB:
    case T_e8_DAB_Source__DAB_TA:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_DeleteAction_Parse (const char *str, size_t length, T_e8_DAB_DeleteAction &value)
{
    static stringEntry entries[] = {
        {32,"PRESETLIST_DELACTION_ONE_ELEMENT", 0U},
        {33,"PRESETLIST_DELACTION_ALL_ELEMENTS", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_DeleteAction_Name (T_e8_DAB_DeleteAction value)
{
    static const char* enumerationLiterals[] = {
        "PRESETLIST_DELACTION_ONE_ELEMENT",
        "PRESETLIST_DELACTION_ALL_ELEMENTS",
    };

    if (T_e8_DAB_DeleteAction_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_DeleteAction_IsValid (T_e8_DAB_DeleteAction value)
{
    switch (value) {
    case T_e8_DAB_DeleteAction__PRESETLIST_DELACTION_ONE_ELEMENT:
    case T_e8_DAB_DeleteAction__PRESETLIST_DELACTION_ALL_ELEMENTS:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ListOperation_Parse (const char *str, size_t length, T_e8_DAB_ListOperation &value)
{
    static stringEntry entries[] = {
        {3,"GET", 2U},
        {4,"OPEN", 0U},
        {5,"CLOSE", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 3, (unsigned int&) value);
}

const char* T_e8_DAB_ListOperation_Name (T_e8_DAB_ListOperation value)
{
    static const char* enumerationLiterals[] = {
        "OPEN",
        "CLOSE",
        "GET",
    };

    if (T_e8_DAB_ListOperation_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ListOperation_IsValid (T_e8_DAB_ListOperation value)
{
    switch (value) {
    case T_e8_DAB_ListOperation__OPEN:
    case T_e8_DAB_ListOperation__CLOSE:
    case T_e8_DAB_ListOperation__GET:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ServiceListType_Parse (const char *str, size_t length, T_e8_DAB_ServiceListType &value)
{
    static stringEntry entries[] = {
        {10,"GLOBALLIST", 0U},
        {19,"CURRENTENSEMBLELIST", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_ServiceListType_Name (T_e8_DAB_ServiceListType value)
{
    static const char* enumerationLiterals[] = {
        "GlobalList",
        "CurrentEnsembleList",
    };

    if (T_e8_DAB_ServiceListType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_ServiceListType_IsValid (T_e8_DAB_ServiceListType value)
{
    switch (value) {
    case T_e8_DAB_ServiceListType__GlobalList:
    case T_e8_DAB_ServiceListType__CurrentEnsembleList:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_BankList_Parse (const char *str, size_t length, T_e8_DAB_BankList &value)
{
    static stringEntry entries[] = {
        {9,"BANK_DAB1", 13U},
        {9,"BANK_DAB2", 14U},
        {9,"BANK_DAB3", 15U},
        {11,"BANK_DABAST", 16U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_BankList_Name (T_e8_DAB_BankList value)
{
    static const char* enumerationLiterals[] = {
        "BANK_DAB1",
        "BANK_DAB2",
        "BANK_DAB3",
        "BANK_DABAST",
    };

    if (T_e8_DAB_BankList_IsValid(value))
        return enumerationLiterals[value - 13U];
    else
        return NULL;
}

bool T_e8_DAB_BankList_IsValid (T_e8_DAB_BankList value)
{
    switch (value) {
    case T_e8_DAB_BankList__BANK_DAB1:
    case T_e8_DAB_BankList__BANK_DAB2:
    case T_e8_DAB_BankList__BANK_DAB3:
    case T_e8_DAB_BankList__BANK_DABAST:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TestOperation_Parse (const char *str, size_t length, T_e8_DAB_TestOperation &value)
{
    static stringEntry entries[] = {
        {9,"PLAY_ASID", 4U},
        {12,"TUNE_SERVICE", 2U},
        {13,"TUNE_ENSEMBLE", 1U},
        {14,"TUNE_FREQUENCY", 3U},
        {17,"REMOTE_CTRL_ENTER", 6U},
        {17,"REMOTE_CTRL_LEAVE", 7U},
        {22,"VERIFY_FREQ_ASID_AUDIO", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DAB_TestOperation_Name (T_e8_DAB_TestOperation value)
{
    static const char* enumerationLiterals[] = {
        "TUNE_ENSEMBLE",
        "TUNE_SERVICE",
        "TUNE_FREQUENCY",
        "PLAY_ASID",
        "VERIFY_FREQ_ASID_AUDIO",
        "REMOTE_CTRL_ENTER",
        "REMOTE_CTRL_LEAVE",
    };

    if (T_e8_DAB_TestOperation_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_DAB_TestOperation_IsValid (T_e8_DAB_TestOperation value)
{
    switch (value) {
    case T_e8_DAB_TestOperation__TUNE_ENSEMBLE:
    case T_e8_DAB_TestOperation__TUNE_SERVICE:
    case T_e8_DAB_TestOperation__TUNE_FREQUENCY:
    case T_e8_DAB_TestOperation__PLAY_ASID:
    case T_e8_DAB_TestOperation__VERIFY_FREQ_ASID_AUDIO:
    case T_e8_DAB_TestOperation__REMOTE_CTRL_ENTER:
    case T_e8_DAB_TestOperation__REMOTE_CTRL_LEAVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_ManualMode_TuneOperation_Parse (const char *str, size_t length, T_e8_DAB_ManualMode_TuneOperation &value)
{
    static stringEntry entries[] = {
        {9,"PLAY_ASID", 4U},
        {12,"TUNE_SERVICE", 2U},
        {13,"TUNE_ENSEMBLE", 1U},
        {14,"TUNE_FREQUENCY", 3U},
        {17,"REMOTE_CTRL_ENTER", 6U},
        {17,"REMOTE_CTRL_LEAVE", 7U},
        {22,"VERIFY_FREQ_ASID_AUDIO", 5U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DAB_ManualMode_TuneOperation_Name (T_e8_DAB_ManualMode_TuneOperation value)
{
    static const char* enumerationLiterals[] = {
        "TUNE_ENSEMBLE",
        "TUNE_SERVICE",
        "TUNE_FREQUENCY",
        "PLAY_ASID",
        "VERIFY_FREQ_ASID_AUDIO",
        "REMOTE_CTRL_ENTER",
        "REMOTE_CTRL_LEAVE",
    };

    if (T_e8_DAB_ManualMode_TuneOperation_IsValid(value))
        return enumerationLiterals[value - 1U];
    else
        return NULL;
}

bool T_e8_DAB_ManualMode_TuneOperation_IsValid (T_e8_DAB_ManualMode_TuneOperation value)
{
    switch (value) {
    case T_e8_DAB_ManualMode_TuneOperation__TUNE_ENSEMBLE:
    case T_e8_DAB_ManualMode_TuneOperation__TUNE_SERVICE:
    case T_e8_DAB_ManualMode_TuneOperation__TUNE_FREQUENCY:
    case T_e8_DAB_ManualMode_TuneOperation__PLAY_ASID:
    case T_e8_DAB_ManualMode_TuneOperation__VERIFY_FREQ_ASID_AUDIO:
    case T_e8_DAB_ManualMode_TuneOperation__REMOTE_CTRL_ENTER:
    case T_e8_DAB_ManualMode_TuneOperation__REMOTE_CTRL_LEAVE:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_LinkType_Parse (const char *str, size_t length, T_e8_DAB_LinkType &value)
{
    static stringEntry entries[] = {
        {18,"LINKTYPE_FM_NOLINK", 5U},
        {19,"LINKTYPE_DAB_DBLINK", 6U},
        {19,"LINKTYPE_DAB_NOLINK", 2U},
        {20,"LINKTYPE_FM_HARDLINK", 3U},
        {20,"LINKTYPE_FM_SOFTLINK", 4U},
        {21,"LINKTYPE_DAB_HARDLINK", 0U},
        {21,"LINKTYPE_DAB_SOFTLINK", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 7, (unsigned int&) value);
}

const char* T_e8_DAB_LinkType_Name (T_e8_DAB_LinkType value)
{
    static const char* enumerationLiterals[] = {
        "LINKTYPE_DAB_HARDLINK",
        "LINKTYPE_DAB_SOFTLINK",
        "LINKTYPE_DAB_NOLINK",
        "LINKTYPE_FM_HARDLINK",
        "LINKTYPE_FM_SOFTLINK",
        "LINKTYPE_FM_NOLINK",
        "LINKTYPE_DAB_DBLINK",
    };

    if (T_e8_DAB_LinkType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_LinkType_IsValid (T_e8_DAB_LinkType value)
{
    switch (value) {
    case T_e8_DAB_LinkType__LINKTYPE_DAB_HARDLINK:
    case T_e8_DAB_LinkType__LINKTYPE_DAB_SOFTLINK:
    case T_e8_DAB_LinkType__LINKTYPE_DAB_NOLINK:
    case T_e8_DAB_LinkType__LINKTYPE_FM_HARDLINK:
    case T_e8_DAB_LinkType__LINKTYPE_FM_SOFTLINK:
    case T_e8_DAB_LinkType__LINKTYPE_FM_NOLINK:
    case T_e8_DAB_LinkType__LINKTYPE_DAB_DBLINK:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TmcMediumType_Parse (const char *str, size_t length, T_e8_DAB_TmcMediumType &value)
{
    static stringEntry entries[] = {
        {17,"DAB_MEDIUMTYPE_FM", 1U},
        {18,"DAB_MEDIUMTYPE_DAB", 2U},
        {18,"DAB_MEDIUMTYPE_SAT", 3U},
        {23,"DAB_MEDIUMTYPE_RESERVED", 0U},
    };

    return lookupInStringEntryTable (str, length, entries, 4, (unsigned int&) value);
}

const char* T_e8_DAB_TmcMediumType_Name (T_e8_DAB_TmcMediumType value)
{
    static const char* enumerationLiterals[] = {
        "DAB_MEDIUMTYPE_RESERVED",
        "DAB_MEDIUMTYPE_FM",
        "DAB_MEDIUMTYPE_DAB",
        "DAB_MEDIUMTYPE_SAT",
    };

    if (T_e8_DAB_TmcMediumType_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_TmcMediumType_IsValid (T_e8_DAB_TmcMediumType value)
{
    switch (value) {
    case T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_RESERVED:
    case T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_FM:
    case T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_DAB:
    case T_e8_DAB_TmcMediumType__DAB_MEDIUMTYPE_SAT:
        return true;
    default:
        return false;
    }
}

bool T_e8_DAB_TuneCmd_Parse (const char *str, size_t length, T_e8_DAB_TuneCmd &value)
{
    static stringEntry entries[] = {
        {13,"DAB_TUNE_NEXT", 0U},
        {13,"DAB_TUNE_PREV", 1U},
    };

    return lookupInStringEntryTable (str, length, entries, 2, (unsigned int&) value);
}

const char* T_e8_DAB_TuneCmd_Name (T_e8_DAB_TuneCmd value)
{
    static const char* enumerationLiterals[] = {
        "DAB_TUNE_NEXT",
        "DAB_TUNE_PREV",
    };

    if (T_e8_DAB_TuneCmd_IsValid(value))
        return enumerationLiterals[value];
    else
        return NULL;
}

bool T_e8_DAB_TuneCmd_IsValid (T_e8_DAB_TuneCmd value)
{
    switch (value) {
    case T_e8_DAB_TuneCmd__DAB_TUNE_NEXT:
    case T_e8_DAB_TuneCmd__DAB_TUNE_PREV:
        return true;
    default:
        return false;
    }
}

} // namespace dabtuner_main_fi_types
