/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_W1_WPA_SUPPLICANT1STUB_H
#define FI_W1_WPA_SUPPLICANT1STUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1.h"
#include <map>
#include <string>

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {

class Wpa_supplicant1StubDelegate;

class Wpa_supplicant1Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the Wpa_supplicant1Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    Wpa_supplicant1Stub (const std::string& portName);

    /**
     * Create an instance of the Wpa_supplicant1Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    Wpa_supplicant1Stub (const std::string& portName, const std::string& objectPath);

    virtual ~Wpa_supplicant1Stub();

    // signal 'InterfaceAdded'

    /**
     * Raise the signal 'InterfaceAdded' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'InterfaceAdded'</b>:
     *
     * If the meaning of "InterfaceAdded" isn't clear, then there should be a description here.
     */
    void sendInterfaceAddedSignal(const ::std::string& interface, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    // signal 'InterfaceRemoved'

    /**
     * Raise the signal 'InterfaceRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'InterfaceRemoved'</b>:
     *
     * If the meaning of "InterfaceRemoved" isn't clear, then there should be a description here.
     */
    void sendInterfaceRemovedSignal(const ::std::string& interface);

    // method 'GetInterface'

    /**
     * The method onGetInterface() is called by ASF when a client invokes the
     * method 'GetInterface'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetInterface() or
     * sendGetInterfaceError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetInterface'</b>:
     *
     * If the meaning of "GetInterface" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetInterfaceRequest (const ::boost::shared_ptr< GetInterfaceRequest >& request) = 0;

    /**
     * The method sendGetInterfaceResponse() sends a response of a previous
     * method invocation of 'GetInterface' back to the client.
     *
     * <b>Documentation of 'GetInterface'</b>:
     *
     * If the meaning of "GetInterface" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetInterface(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetInterfaceResponse (const ::std::string& path, act_t act = 0);

    /**
     * The method sendGetInterfaceError() sends an error response of a
     * previous method invocation of 'GetInterface' back to the client.
     *
     * <b>Documentation of 'GetInterface'</b>:
     *
     * If the meaning of "GetInterface" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetInterface(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetInterfaceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class Wpa_supplicant1StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi

#endif // FI_W1_WPA_SUPPLICANT1STUB_H
