/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1.h"
#include "fi/w1/wpa_supplicant1DBus.h"
#include "fi/w1/wpa_supplicant1Json.h"
#include "fi/w1/wpa_supplicant1Stub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/fi/w1/wpa_supplicant1", Wpa_supplicant1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "GetInterface", 0 },
};


class Wpa_supplicant1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Wpa_supplicant1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Wpa_supplicant1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Wpa_supplicant1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "fi.w1.wpa_supplicant1"),
          _logger(logger) {}

    virtual ~Wpa_supplicant1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Wpa_supplicant1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetInterface'

            LOG_DEBUG_STUB("process method '%s'", "GetInterface");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetInterface", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetInterfaceRequest > payload = ::boost::static_pointer_cast<GetInterfaceRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Wpa_supplicant1Stub*>(getStub())->onGetInterfaceRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Wpa_supplicant1StubDelegate::introspect() const {
    return     "<interface name=\"fi.w1.wpa_supplicant1\">\n"
            "      <method name=\"GetInterface\">\n"
            "        <arg direction=\"in\" name=\"ifname\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <signal name=\"InterfaceAdded\">\n"
            "        <arg name=\"interface\" type=\"o\"/>\n"
            "        <arg name=\"properties\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"InterfaceRemoved\">\n"
            "        <arg name=\"interface\" type=\"o\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void Wpa_supplicant1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Wpa_supplicant1Stub*>(getStub()))->onGetAll (properties);
}

void Wpa_supplicant1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Wpa_supplicant1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Wpa_supplicant1Stub::Wpa_supplicant1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Wpa_supplicant1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Wpa_supplicant1Stub::Wpa_supplicant1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Wpa_supplicant1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Wpa_supplicant1Stub::~Wpa_supplicant1Stub() {
    delete _stubDelegate;
}

void Wpa_supplicant1Stub::sendInterfaceAddedSignal(const ::std::string& interface, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    if (_stubDelegate->isConnected()) {
        InterfaceAddedSignal* payload = new InterfaceAddedSignal(interface, properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "InterfaceAdded", InterfaceAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "InterfaceAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "InterfaceAdded");
    }
}

void Wpa_supplicant1Stub::sendInterfaceRemovedSignal(const ::std::string& interface) {
    if (_stubDelegate->isConnected()) {
        InterfaceRemovedSignal* payload = new InterfaceRemovedSignal(interface);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "InterfaceRemoved", InterfaceRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "InterfaceRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "InterfaceRemoved");
    }
}

void  Wpa_supplicant1Stub::sendGetInterfaceResponse (const ::std::string& path, act_t act) {
    GetInterfaceResponse* payload = new GetInterfaceResponse(path);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetInterface", GetInterfaceResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetInterface", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Wpa_supplicant1Stub::sendGetInterfaceError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetInterfaceError* payload = new GetInterfaceError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetInterface", GetInterfaceError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetInterface", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Wpa_supplicant1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
