/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1.h"
#include "fi/w1/wpa_supplicant1DBus.h"
#include "fi/w1/wpa_supplicant1Json.h"
#include "fi/w1/wpa_supplicant1Proxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/fi/w1/wpa_supplicant1", Wpa_supplicant1Proxy);

class Wpa_supplicant1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Wpa_supplicant1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Wpa_supplicant1Proxy >& proxyShared = ::boost::static_pointer_cast< Wpa_supplicant1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_InterfaceAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InterfaceAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<InterfaceAddedSignal> payload = ::boost::static_pointer_cast<InterfaceAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((InterfaceAddedCallbackIF*) _callback)->onInterfaceAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_InterfaceRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), InterfaceRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "InterfaceRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<InterfaceRemovedSignal> payload = ::boost::static_pointer_cast<InterfaceRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((InterfaceRemovedCallbackIF*) _callback)->onInterfaceRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetInterface:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetInterface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetInterfaceError> payload = ::boost::static_pointer_cast<GetInterfaceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetInterfaceCallbackIF*) _callback)->onGetInterfaceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetInterfaceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetInterface", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetInterfaceResponse> payload = ::boost::static_pointer_cast<GetInterfaceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetInterfaceCallbackIF*) _callback)->onGetInterfaceResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_InterfaceAdded: {
                ::boost::shared_ptr< InterfaceAddedError > payload = ::boost::shared_ptr< InterfaceAddedError >
                (new InterfaceAddedError(DBUS_ERROR_NO_SERVER, "The DBus service Wpa_supplicant1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InterfaceAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Wpa_supplicant1Proxy> proxyShared = ::boost::static_pointer_cast<Wpa_supplicant1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfaceAddedCallbackIF*) _callback)->onInterfaceAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_InterfaceRemoved: {
                ::boost::shared_ptr< InterfaceRemovedError > payload = ::boost::shared_ptr< InterfaceRemovedError >
                (new InterfaceRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Wpa_supplicant1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "InterfaceRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Wpa_supplicant1Proxy> proxyShared = ::boost::static_pointer_cast<Wpa_supplicant1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((InterfaceRemovedCallbackIF*) _callback)->onInterfaceRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetInterface: {
                ::boost::shared_ptr< GetInterfaceError > payload = ::boost::shared_ptr< GetInterfaceError >
                (new GetInterfaceError(DBUS_ERROR_NO_SERVER, "The DBus service Wpa_supplicant1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetInterface", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Wpa_supplicant1Proxy> proxyShared = ::boost::static_pointer_cast<Wpa_supplicant1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetInterfaceCallbackIF*) _callback)->onGetInterfaceError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Wpa_supplicant1ProxyCallback::_logger (Wpa_supplicant1Proxy::_logger);

Wpa_supplicant1Proxy::Wpa_supplicant1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "fi.w1.wpa_supplicant1", serviceAvailable, _logger) {
}

Wpa_supplicant1Proxy::~Wpa_supplicant1Proxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Wpa_supplicant1Proxy > Wpa_supplicant1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Wpa_supplicant1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Wpa_supplicant1Proxy > proxyNew(new Wpa_supplicant1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t Wpa_supplicant1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Wpa_supplicant1ProxyCallback* callback = new Wpa_supplicant1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Wpa_supplicant1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Wpa_supplicant1ProxyCallback* callback = new Wpa_supplicant1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void Wpa_supplicant1Proxy::sendDeregisterAll () const
{
    sendInterfaceAddedDeregisterAll();
    sendInterfaceRemovedDeregisterAll();
}

act_t Wpa_supplicant1Proxy::sendInterfaceAddedRegister(InterfaceAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "InterfaceAdded");
    act_t act = addSignalCallback(ID_InterfaceAdded, "InterfaceAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InterfaceAdded", &cb, act);
    return act;
}

bool Wpa_supplicant1Proxy::sendInterfaceAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InterfaceAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InterfaceAdded", act, static_cast<int>(rv));
    return rv;
}

void Wpa_supplicant1Proxy::sendInterfaceAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InterfaceAdded");
    _dbusProxyDelegate->deregisterSignalCallback("InterfaceAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t Wpa_supplicant1Proxy::sendInterfaceRemovedRegister(InterfaceRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "InterfaceRemoved");
    act_t act = addSignalCallback(ID_InterfaceRemoved, "InterfaceRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "InterfaceRemoved", &cb, act);
    return act;
}

bool Wpa_supplicant1Proxy::sendInterfaceRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("InterfaceRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "InterfaceRemoved", act, static_cast<int>(rv));
    return rv;
}

void Wpa_supplicant1Proxy::sendInterfaceRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "InterfaceRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("InterfaceRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t Wpa_supplicant1Proxy::sendGetInterfaceRequest(GetInterfaceCallbackIF& cb, const ::std::string& ifname) const {
    GetInterfaceRequest* payload = new GetInterfaceRequest();
    CHECK_ALLOCATION(payload);
    payload->setIfname(ifname);
    DBUS_MESSAGE_CALL(dbusMessage, "GetInterface", GetInterfaceRequest, payload, true)
    act_t act = addMethodCallback(ID_GetInterface, dbusMessage.getUniqueSerial(), "GetInterface", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetInterface", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
