/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_W1_WPA_SUPPLICANT1_INTERFACEPROXY_H
#define FI_W1_WPA_SUPPLICANT1_INTERFACEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "fi/w1/wpa_supplicant1/Interface.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace Interface {

class InterfaceProxy;

class BSSAddedCallbackIF {
public:
    virtual ~BSSAddedCallbackIF() {}

    virtual void onBSSAddedError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< BSSAddedError >& error) = 0;

    virtual void onBSSAddedSignal(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< BSSAddedSignal >& signal) = 0;
};

class BSSRemovedCallbackIF {
public:
    virtual ~BSSRemovedCallbackIF() {}

    virtual void onBSSRemovedError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< BSSRemovedError >& error) = 0;

    virtual void onBSSRemovedSignal(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< BSSRemovedSignal >& signal) = 0;
};

class CountryCallbackIF {
public:
    virtual ~CountryCallbackIF() {}

    virtual void onCountryError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< CountryError >& error) = 0;

    virtual void onCountryUpdate(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< CountryUpdate >& update) = 0;
};

class CurrentBSSCallbackIF {
public:
    virtual ~CurrentBSSCallbackIF() {}

    virtual void onCurrentBSSError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< CurrentBSSError >& error) = 0;

    virtual void onCurrentBSSUpdate(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< CurrentBSSUpdate >& update) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class DisconnectReasonCallbackIF {
public:
    virtual ~DisconnectReasonCallbackIF() {}

    virtual void onDisconnectReasonError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectReasonError >& error) = 0;

    virtual void onDisconnectReasonUpdate(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< DisconnectReasonUpdate >& update) = 0;
};

class ScanCallbackIF {
public:
    virtual ~ScanCallbackIF() {}

    virtual void onScanError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< ScanError >& error) = 0;

    virtual void onScanResponse(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< ScanResponse >& response) = 0;
};

class StateCallbackIF {
public:
    virtual ~StateCallbackIF() {}

    virtual void onStateError(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< StateError >& error) = 0;

    virtual void onStateUpdate(const ::boost::shared_ptr< InterfaceProxy >& proxy, const ::boost::shared_ptr< StateUpdate >& update) = 0;
};


/**
 * InterfaceProxy is the client side representation of the D-Bus service
 * interface 'fi.w1.wpa_supplicant1.Interface' (specified in file
 * wpa_supplicant_interface.xml).
 *
 * If the meaning of "fi.w1.wpa_supplicant1.Interface" isn't clear, then there should be a description here.
 */
class InterfaceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of InterfaceProxy.
     */
    static ::boost::shared_ptr< InterfaceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of InterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< InterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of InterfaceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< InterfaceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< InterfaceProxy > proxyNew(new InterfaceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~InterfaceProxy ();


    // Signal 'BSSAdded'

    /**
     * Notify on the signal 'BSSAdded'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BSSAdded'</b>:
     *
     * If the meaning of "BSSAdded" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBSSAddedRegister(BSSAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BSSAdded'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BSSAdded'</b>:
     *
     * If the meaning of "BSSAdded" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBSSAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBSSAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BSSAdded'.
     */
    void sendBSSAddedDeregisterAll () const;

    // Signal 'BSSRemoved'

    /**
     * Notify on the signal 'BSSRemoved'. This method registers for signal
     * changes by D-Bus service.
     *
     * <b>Documentation of 'BSSRemoved'</b>:
     *
     * If the meaning of "BSSRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBSSRemovedRegister(BSSRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BSSRemoved'. This method deregisters
     * signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BSSRemoved'</b>:
     *
     * If the meaning of "BSSRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBSSRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBSSRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BSSRemoved'.
     */
    void sendBSSRemovedDeregisterAll () const;


    // Property 'Country'

    /**
     * Notify on the property 'Country'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCountryRegister(CountryCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Country'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendCountryRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCountryDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Country'.
     */
    void sendCountryDeregisterAll() const;

    /**
     * Request the value of the property 'Country' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCountryGet(CountryCallbackIF& cb);

    /**
     * Set the value of the property 'Country'. This method sends a Set
     * message to the D-Bus server.
     *
     * @deprecated use the sendCountrySet(CountryCallbackIF& cb, const
     * ::std::string& country) method instead.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     */
    void sendCountrySet(const ::std::string& country);

    /**
     * Set the value of the property 'Country'. This method sends a Set
     * message to the D-Bus server.
     *
     * <b>Documentation of 'Country'</b>:
     *
     * If the meaning of "Country" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCountrySet(CountryCallbackIF& cb, const ::std::string& country);

    /**
     * Returns the current value of the property 'Country' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasCountry()
     * returns true.
     *
     * @return the previously received value of the property 'Country'.
     */
    const ::std::string& getCountry() const;

    /**
     * Determines whether a status message for the property 'Country' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCountry() const;

    // Property 'DisconnectReason'

    /**
     * Notify on the property 'DisconnectReason'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectReasonRegister(DisconnectReasonCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DisconnectReason'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDisconnectReasonRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDisconnectReasonDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DisconnectReason'.
     */
    void sendDisconnectReasonDeregisterAll() const;

    /**
     * Request the value of the property 'DisconnectReason' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DisconnectReason'</b>:
     *
     * If the meaning of "DisconnectReason" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectReasonGet(DisconnectReasonCallbackIF& cb);


    /**
     * Returns the current value of the property 'DisconnectReason' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDisconnectReason() returns true.
     *
     * @return the previously received value of the property 'DisconnectReason'.
     */
    int32 getDisconnectReason() const;

    /**
     * Determines whether a status message for the property 'DisconnectReason'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDisconnectReason() const;

    // Property 'State'

    /**
     * Notify on the property 'State'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateRegister(StateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'State'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'State'.
     */
    void sendStateDeregisterAll() const;

    /**
     * Request the value of the property 'State' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateGet(StateCallbackIF& cb);


    /**
     * Returns the current value of the property 'State' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasState()
     * returns true.
     *
     * @return the previously received value of the property 'State'.
     */
    const ::std::string& getState() const;

    /**
     * Determines whether a status message for the property 'State' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasState() const;

    // Property 'CurrentBSS'

    /**
     * Notify on the property 'CurrentBSS'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentBSSRegister(CurrentBSSCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'CurrentBSS'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendCurrentBSSRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendCurrentBSSDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'CurrentBSS'.
     */
    void sendCurrentBSSDeregisterAll() const;

    /**
     * Request the value of the property 'CurrentBSS' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'CurrentBSS'</b>:
     *
     * If the meaning of "CurrentBSS" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCurrentBSSGet(CurrentBSSCallbackIF& cb);


    /**
     * Returns the current value of the property 'CurrentBSS' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasCurrentBSS() returns true.
     *
     * @return the previously received value of the property 'CurrentBSS'.
     */
    const ::std::string& getCurrentBSS() const;

    /**
     * Determines whether a status message for the property 'CurrentBSS' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasCurrentBSS() const;


    // Method 'Scan'

    /**
     * Call the method 'Scan'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param args If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendScanRequest(ScanCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    InterfaceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Country'

    ::asf::core::nullable< CountryUpdate > _country;

    // Property 'DisconnectReason'

    ::asf::core::nullable< DisconnectReasonUpdate > _disconnectReason;

    // Property 'State'

    ::asf::core::nullable< StateUpdate > _state;

    // Property 'CurrentBSS'

    ::asf::core::nullable< CurrentBSSUpdate > _currentBSS;

    DECLARE_CLASS_LOGGER();

    friend class InterfaceProxyCallback;
};

} // namespace Interface
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi

#endif // FI_W1_WPA_SUPPLICANT1_INTERFACEPROXY_H
