/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef FI_W1_WPA_SUPPLICANT1_BSSPROXY_H
#define FI_W1_WPA_SUPPLICANT1_BSSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "fi/w1/wpa_supplicant1/BSS.h"
#include <dbus/dbus.h>
#include <vector>

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace BSS {

class BSSProxy;

class IEsCallbackIF {
public:
    virtual ~IEsCallbackIF() {}

    virtual void onIEsError(const ::boost::shared_ptr< BSSProxy >& proxy, const ::boost::shared_ptr< IEsError >& error) = 0;

    virtual void onIEsUpdate(const ::boost::shared_ptr< BSSProxy >& proxy, const ::boost::shared_ptr< IEsUpdate >& update) = 0;
};


/**
 * BSSProxy is the client side representation of the D-Bus service
 * interface 'fi.w1.wpa_supplicant1.BSS' (specified in file
 * wpa_supplicant_bss.xml).
 *
 * If the meaning of "fi.w1.wpa_supplicant1.BSS" isn't clear, then there should be a description here.
 */
class BSSProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of BSSProxy.
     */
    static ::boost::shared_ptr< BSSProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of BSSProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< BSSProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of BSSProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< BSSProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< BSSProxy > proxyNew(new BSSProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~BSSProxy ();



    // Property 'IEs'

    /**
     * Notify on the property 'IEs'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'IEs'</b>:
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIEsRegister(IEsCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'IEs'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'IEs'</b>:
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendIEsRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendIEsDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'IEs'.
     */
    void sendIEsDeregisterAll() const;

    /**
     * Request the value of the property 'IEs' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'IEs'</b>:
     *
     * If the meaning of "IEs" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendIEsGet(IEsCallbackIF& cb);


    /**
     * Returns the current value of the property 'IEs' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasIEs()
     * returns true.
     *
     * @return the previously received value of the property 'IEs'.
     */
    const ::std::vector< uint8 >& getIEs() const;

    /**
     * Determines whether a status message for the property 'IEs' was received
     * before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasIEs() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    BSSProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'IEs'

    ::asf::core::nullable< IEsUpdate > _iEs;

    DECLARE_CLASS_LOGGER();

    friend class BSSProxyCallback;
};

} // namespace BSS
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi

#endif // FI_W1_WPA_SUPPLICANT1_BSSPROXY_H
