/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "boost/shared_ptr.hpp"
#include "fi/w1/wpa_supplicant1/BSS.h"
#include "fi/w1/wpa_supplicant1/BSSDBus.h"
#include "fi/w1/wpa_supplicant1/BSSJson.h"
#include "fi/w1/wpa_supplicant1/BSSProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace fi {
namespace w1 {
namespace wpa_supplicant1 {
namespace BSS {

DEFINE_CLASS_LOGGER("//fi/w1/wpa_supplicant1/Interfaces/XX/BSSs/XXX/fi/w1/wpa_supplicant1/BSS", BSSProxy);

class BSSProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    BSSProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< BSSProxy >& proxyShared = ::boost::static_pointer_cast< BSSProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_IEs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IEsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IEs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IEsError> payload = ::boost::static_pointer_cast<IEsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((IEsCallbackIF*) _callback)->onIEsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), IEsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "IEs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<IEsUpdate> payload = ::boost::static_pointer_cast<IEsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((IEsCallbackIF*) _callback)->onIEsUpdate(proxyShared, payload);
                        proxyShared->_iEs = *payload.get();
                        return true;
                    }
                }
                break;
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_IEs: {
                ::boost::shared_ptr< IEsError > payload = ::boost::shared_ptr< IEsError >
                (new IEsError(DBUS_ERROR_NO_SERVER, "The DBus service BSS is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "IEs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<BSSProxy> proxyShared = ::boost::static_pointer_cast<BSSProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((IEsCallbackIF*) _callback)->onIEsError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& BSSProxyCallback::_logger (BSSProxy::_logger);

BSSProxy::BSSProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "fi.w1.wpa_supplicant1.BSS", serviceAvailable, _logger) {
}

BSSProxy::~BSSProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< BSSProxy > BSSProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<BSSProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< BSSProxy > proxyNew(new BSSProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t BSSProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    BSSProxyCallback* callback = new BSSProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t BSSProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    BSSProxyCallback* callback = new BSSProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void BSSProxy::clearAllProperties ()
{
    _iEs = ::asf::core::nullable< IEsUpdate >();
}

void BSSProxy::sendDeregisterAll () const
{
    sendIEsDeregisterAll();
}

act_t BSSProxy::sendIEsRegister(IEsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_IEs, "IEs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "IEs", &cb, act);
    return act;
}

bool BSSProxy::sendIEsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("IEs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "IEs", act, static_cast<int>(rv));
    return rv;
}

act_t BSSProxy::sendIEsGet(IEsCallbackIF& cb) {
    BSSProxyCallback* callback = new BSSProxyCallback(ID_IEs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "IEs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("IEs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< uint8 >& BSSProxy::getIEs() const {
    return _iEs.get().getIEs();
}

bool BSSProxy::hasIEs() const {
    return _iEs.hasValue();
}

void BSSProxy::sendIEsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "IEs");
    _dbusProxyDelegate->deregisterSignalCallback("IEs", 0, _dbusDaemonProxy.get(), true);
}

} // namespace BSS
} // namespace wpa_supplicant1
} // namespace w1
} // namespace fi
