/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERSTUB_H
#define OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "objmgr/org/freedesktop/DBus/ObjectManager.h"
#include <map>
#include <string>
#include <vector>

namespace objmgr {
namespace org {
namespace freedesktop {
namespace DBus {
namespace ObjectManager {

class ObjectManagerStubDelegate;

class ObjectManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ObjectManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ObjectManagerStub (const std::string& portName);

    /**
     * Create an instance of the ObjectManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ObjectManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~ObjectManagerStub();

    // signal 'InterfacesAdded'

    /**
     * Raise the signal 'InterfacesAdded' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'InterfacesAdded'</b>:
     *
     * If the meaning of "InterfacesAdded" isn't clear, then there should be a description here.
     */
    void sendInterfacesAddedSignal(const ::std::string& object, const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& interfaces);

    // signal 'InterfacesRemoved'

    /**
     * Raise the signal 'InterfacesRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'InterfacesRemoved'</b>:
     *
     * If the meaning of "InterfacesRemoved" isn't clear, then there should be a description here.
     */
    void sendInterfacesRemovedSignal(const ::std::string& object, const ::std::vector< ::std::string >& interfaces);

    // method 'GetManagedObjects'

    /**
     * The method onGetManagedObjects() is called by ASF when a client invokes
     * the method 'GetManagedObjects'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendGetManagedObjects() or sendGetManagedObjectsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'GetManagedObjects'</b>:
     *
     * If the meaning of "GetManagedObjects" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetManagedObjectsRequest (const ::boost::shared_ptr< GetManagedObjectsRequest >& request) = 0;

    /**
     * The method sendGetManagedObjectsResponse() sends a response of a
     * previous method invocation of 'GetManagedObjects' back to the client.
     *
     * <b>Documentation of 'GetManagedObjects'</b>:
     *
     * If the meaning of "GetManagedObjects" isn't clear, then there should be a description here.
     *
     * @param objects If the meaning of "objects" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetManagedObjects(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendGetManagedObjectsResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > > >& objects, act_t act = 0);

    /**
     * The method sendGetManagedObjectsError() sends an error response of a
     * previous method invocation of 'GetManagedObjects' back to the client.
     *
     * <b>Documentation of 'GetManagedObjects'</b>:
     *
     * If the meaning of "GetManagedObjects" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetManagedObjects().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetManagedObjectsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ObjectManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace ObjectManager
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace objmgr

#endif // OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERSTUB_H
