/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERPROXY_H
#define OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "objmgr/org/freedesktop/DBus/ObjectManager.h"
#include <dbus/dbus.h>

namespace objmgr {
namespace org {
namespace freedesktop {
namespace DBus {
namespace ObjectManager {

class ObjectManagerProxy;

class GetManagedObjectsCallbackIF {
public:
    virtual ~GetManagedObjectsCallbackIF() {}

    virtual void onGetManagedObjectsError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< GetManagedObjectsError >& error) = 0;

    virtual void onGetManagedObjectsResponse(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< GetManagedObjectsResponse >& response) = 0;
};

class InterfacesAddedCallbackIF {
public:
    virtual ~InterfacesAddedCallbackIF() {}

    virtual void onInterfacesAddedError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesAddedError >& error) = 0;

    virtual void onInterfacesAddedSignal(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesAddedSignal >& signal) = 0;
};

class InterfacesRemovedCallbackIF {
public:
    virtual ~InterfacesRemovedCallbackIF() {}

    virtual void onInterfacesRemovedError(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesRemovedError >& error) = 0;

    virtual void onInterfacesRemovedSignal(const ::boost::shared_ptr< ObjectManagerProxy >& proxy, const ::boost::shared_ptr< InterfacesRemovedSignal >& signal) = 0;
};


/**
 * ObjectManagerProxy is the client side representation of the D-Bus
 * service interface 'org.freedesktop.DBus.ObjectManager' (specified in
 * file org_freedesktop_dbus_objectmanager.xml).
 *
 * If the meaning of "org.freedesktop.DBus.ObjectManager" isn't clear, then there should be a description here.
 */
class ObjectManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ObjectManagerProxy.
     */
    static ::boost::shared_ptr< ObjectManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ObjectManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ObjectManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ObjectManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ObjectManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ObjectManagerProxy > proxyNew(new ObjectManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ObjectManagerProxy ();


    // Signal 'InterfacesAdded'

    /**
     * Notify on the signal 'InterfacesAdded'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'InterfacesAdded'</b>:
     *
     * If the meaning of "InterfacesAdded" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInterfacesAddedRegister(InterfacesAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'InterfacesAdded'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'InterfacesAdded'</b>:
     *
     * If the meaning of "InterfacesAdded" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendInterfacesAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInterfacesAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'InterfacesAdded'.
     */
    void sendInterfacesAddedDeregisterAll () const;

    // Signal 'InterfacesRemoved'

    /**
     * Notify on the signal 'InterfacesRemoved'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'InterfacesRemoved'</b>:
     *
     * If the meaning of "InterfacesRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInterfacesRemovedRegister(InterfacesRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'InterfacesRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'InterfacesRemoved'</b>:
     *
     * If the meaning of "InterfacesRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendInterfacesRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInterfacesRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'InterfacesRemoved'.
     */
    void sendInterfacesRemovedDeregisterAll () const;



    // Method 'GetManagedObjects'

    /**
     * Call the method 'GetManagedObjects'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetManagedObjects'</b>:
     *
     * If the meaning of "GetManagedObjects" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetManagedObjectsRequest(GetManagedObjectsCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ObjectManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ObjectManagerProxyCallback;
};

} // namespace ObjectManager
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace objmgr

#endif // OBJMGR_ORG_FREEDESKTOP_DBUS_OBJECTMANAGERPROXY_H
