#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_H
#define INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Introspectable" isn't clear, then there should be a description here.
 */

namespace introspect {
namespace org {
namespace freedesktop {
namespace DBus {
namespace Introspectable {

// method IDs
static const uint16 ID_Introspect = 0;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class IntrospectResponse;

// type definitions
/**
 * If the meaning of "IntrospectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage IntrospectRequest;

/**
 * If the meaning of "IntrospectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError IntrospectError;


/**
 * If the meaning of "IntrospectResponse" isn't clear, then there should be a description here.
 */
class IntrospectResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  IntrospectResponse ();

    /**
     * Copy constructor
     */
    inline  IntrospectResponse (const IntrospectResponse &rhs);

    /**
     * All fields constructor
     */
    inline  IntrospectResponse (const ::std::string& xml_);

    /**
     * Destructor
     */
    inline virtual  ~IntrospectResponse();

    /**
     * Assignment operator
     */
    inline IntrospectResponse& operator = (const IntrospectResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const IntrospectResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const IntrospectResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const IntrospectResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const IntrospectResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "xml"

    static const int kXml = 0;

    /**
     * Clears the field "xml".
     *
     * The field will be set to its default value. The hasXml()
     * method will return false.
     */
    inline void clearXml();

    /**
     * Checks whether the field "xml" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setXml()). Otherwise it will return false.
     */
    inline bool hasXml () const;

    /**
     * Returns the value of the member "xml".
     *
     * If the meaning of "xml" isn't clear, then there should be a description here.
     *
     * @return The value of the field "xml"
     */
    inline const ::std::string& getXml () const;

    /**
     * Retrieves the value of the field "xml" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "xml".
     */
    inline ::std::string& getXmlMutable ();

    /**
     * Sets the value of the member "xml".
     *
     * If the meaning of "xml" isn't clear, then there should be a description here.
     *
     * @param xml The value which will be set
     */
    inline void setXml (const ::std::string& xml_);

    /**
     * Sets the value of the member "xml".
     *
     * If the meaning of "xml" isn't clear, then there should be a description here.
     *
     * @param xml The value which will be set
     */
    inline void setXml (const char* xml_);

    /**
     * Sets the value of the member "xml".
     *
     * If the meaning of "xml" isn't clear, then there should be a description here.
     *
     * @param xml The value which will be set
     */
    inline void setXml (const char* value, size_t size);

    static const IntrospectResponse &getDefaultInstance();

private:

    inline void set_has_xml ();

    inline void clear_has_xml ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _xml;

};

inline  IntrospectResponse::IntrospectResponse ()  :
    _xml ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  IntrospectResponse::IntrospectResponse (const IntrospectResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _xml ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  IntrospectResponse::IntrospectResponse (const ::std::string& xml_)  :
    _xml (xml_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xml_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  IntrospectResponse::~IntrospectResponse() {
}

inline IntrospectResponse& IntrospectResponse::operator = (const IntrospectResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasXml()) {
            setXml(rhs.getXml());
        } else {
            clearXml();
        }
    }
    return *this;
}

inline bool IntrospectResponse::operator == (const IntrospectResponse& rhs) const {
    return (((!hasXml() && !rhs.hasXml()) || getXml() == rhs.getXml()));
}

inline bool IntrospectResponse::operator != (const IntrospectResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool IntrospectResponse::operator < (const IntrospectResponse& rhs) const {
    if (hasXml() || rhs.hasXml()) {
        if (getXml() < rhs.getXml()) return true;
        if (getXml() > rhs.getXml()) return false;
    }
    return false;
}

inline ::asf::core::Payload* IntrospectResponse::clone() {
    return new IntrospectResponse(*this);
}

inline bool IntrospectResponse::operator > (const IntrospectResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void IntrospectResponse::clear() {
    clearXml();
}

inline void IntrospectResponse::clearXml() {
    if (hasXml()) {
         clear_has_xml();
        _xml.clear();
     }
}

inline bool IntrospectResponse::hasXml () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& IntrospectResponse::getXml () const {
    return _xml;
}

inline ::std::string& IntrospectResponse::getXmlMutable () {
    set_has_xml();
    return _xml;
}

inline void IntrospectResponse::setXml (const ::std::string& xml_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xml_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xml();
    this->_xml = xml_;
}

inline void IntrospectResponse::setXml (const char* xml_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (xml_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xml();
    this->_xml.assign(xml_);
}

inline void IntrospectResponse::setXml (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_xml();
    this->_xml.assign(value, size);
}

inline void IntrospectResponse::set_has_xml () {
    _has_bits_[0] |= 1u << 0;
}

inline void IntrospectResponse::clear_has_xml () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace Introspectable
} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace introspect

#endif // INTROSPECT_ORG_FREEDESKTOP_DBUS_INTROSPECTABLE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
