/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CONNDBUS_ORG_FREEDESKTOP_DBUSSTUB_H
#define CONNDBUS_ORG_FREEDESKTOP_DBUSSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "conndbus/org/freedesktop/DBus.h"
#include <string>

namespace conndbus {
namespace org {
namespace freedesktop {
namespace DBus {

class DBusStubDelegate;

class DBusStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DBusStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DBusStub (const std::string& portName);

    /**
     * Create an instance of the DBusStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DBusStub (const std::string& portName, const std::string& objectPath);

    virtual ~DBusStub();

    // signal 'NameOwnerChanged'

    /**
     * Raise the signal 'NameOwnerChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'NameOwnerChanged'</b>:
     *
     * If the meaning of "NameOwnerChanged" isn't clear, then there should be a description here.
     */
    void sendNameOwnerChangedSignal(const ::std::string& name, const ::std::string& old, const ::std::string& new_);

    // method 'GetNameOwner'

    /**
     * The method onGetNameOwner() is called by ASF when a client invokes the
     * method 'GetNameOwner'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetNameOwner() or
     * sendGetNameOwnerError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetNameOwner'</b>:
     *
     * If the meaning of "GetNameOwner" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetNameOwnerRequest (const ::boost::shared_ptr< GetNameOwnerRequest >& request) = 0;

    /**
     * The method sendGetNameOwnerResponse() sends a response of a previous
     * method invocation of 'GetNameOwner' back to the client.
     *
     * <b>Documentation of 'GetNameOwner'</b>:
     *
     * If the meaning of "GetNameOwner" isn't clear, then there should be a description here.
     *
     * @param uniqueid If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetNameOwner(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetNameOwnerResponse (const ::std::string& uniqueid, act_t act = 0);

    /**
     * The method sendGetNameOwnerError() sends an error response of a
     * previous method invocation of 'GetNameOwner' back to the client.
     *
     * <b>Documentation of 'GetNameOwner'</b>:
     *
     * If the meaning of "GetNameOwner" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetNameOwner(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetNameOwnerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DBusStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace conndbus

#endif // CONNDBUS_ORG_FREEDESKTOP_DBUSSTUB_H
