/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "conndbus/org/freedesktop/DBus.h"
#include "conndbus/org/freedesktop/DBusDBus.h"
#include "conndbus/org/freedesktop/DBusJson.h"
#include "conndbus/org/freedesktop/DBusStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace conndbus {
namespace org {
namespace freedesktop {
namespace DBus {

DEFINE_CLASS_LOGGER("///org/freedesktop/DBus", DBusStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 12, "GetNameOwner", 0 },
};


class DBusStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DBusStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DBusStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DBusStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.freedesktop.DBus"),
          _logger(logger) {}

    virtual ~DBusStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DBusStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetNameOwner'

            LOG_DEBUG_STUB("process method '%s'", "GetNameOwner");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetNameOwnerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetNameOwner", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetNameOwnerRequest > payload = ::boost::static_pointer_cast<GetNameOwnerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DBusStub*>(getStub())->onGetNameOwnerRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DBusStubDelegate::introspect() const {
    return     "<interface name=\"org.freedesktop.DBus\">\n"
            "      <signal name=\"NameOwnerChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"old\" type=\"s\"/>\n"
            "        <arg name=\"new\" type=\"s\"/>\n"
            "      </signal>\n"
            "      <method name=\"GetNameOwner\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"uniqueid\" type=\"s\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void DBusStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DBusStub*>(getStub()))->onGetAll (properties);
}

void DBusStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DBusStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DBusStub::DBusStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DBusStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DBusStub::DBusStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DBusStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DBusStub::~DBusStub() {
    delete _stubDelegate;
}

void DBusStub::sendNameOwnerChangedSignal(const ::std::string& name, const ::std::string& old, const ::std::string& new_) {
    if (_stubDelegate->isConnected()) {
        NameOwnerChangedSignal* payload = new NameOwnerChangedSignal(name, old, new_);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NameOwnerChanged", NameOwnerChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "NameOwnerChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NameOwnerChanged");
    }
}

void  DBusStub::sendGetNameOwnerResponse (const ::std::string& uniqueid, act_t act) {
    GetNameOwnerResponse* payload = new GetNameOwnerResponse(uniqueid);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetNameOwner", GetNameOwnerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetNameOwner", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DBusStub::sendGetNameOwnerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetNameOwnerError* payload = new GetNameOwnerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetNameOwner", GetNameOwnerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetNameOwner", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DBusStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace conndbus
