/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CONNDBUS_ORG_FREEDESKTOP_DBUSPROXY_H
#define CONNDBUS_ORG_FREEDESKTOP_DBUSPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "conndbus/org/freedesktop/DBus.h"
#include <dbus/dbus.h>
#include <string>

namespace conndbus {
namespace org {
namespace freedesktop {
namespace DBus {

class DBusProxy;

class GetNameOwnerCallbackIF {
public:
    virtual ~GetNameOwnerCallbackIF() {}

    virtual void onGetNameOwnerError(const ::boost::shared_ptr< DBusProxy >& proxy, const ::boost::shared_ptr< GetNameOwnerError >& error) = 0;

    virtual void onGetNameOwnerResponse(const ::boost::shared_ptr< DBusProxy >& proxy, const ::boost::shared_ptr< GetNameOwnerResponse >& response) = 0;
};

class NameOwnerChangedCallbackIF {
public:
    virtual ~NameOwnerChangedCallbackIF() {}

    virtual void onNameOwnerChangedError(const ::boost::shared_ptr< DBusProxy >& proxy, const ::boost::shared_ptr< NameOwnerChangedError >& error) = 0;

    virtual void onNameOwnerChangedSignal(const ::boost::shared_ptr< DBusProxy >& proxy, const ::boost::shared_ptr< NameOwnerChangedSignal >& signal) = 0;
};


/**
 * DBusProxy is the client side representation of the D-Bus service
 * interface 'org.freedesktop.DBus' (specified in file
 * org_freedesktop_dbus.xml).
 *
 * If the meaning of "org.freedesktop.DBus" isn't clear, then there should be a description here.
 */
class DBusProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of DBusProxy.
     */
    static ::boost::shared_ptr< DBusProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of DBusProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< DBusProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of DBusProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< DBusProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< DBusProxy > proxyNew(new DBusProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~DBusProxy ();


    // Signal 'NameOwnerChanged'

    /**
     * Notify on the signal 'NameOwnerChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'NameOwnerChanged'</b>:
     *
     * If the meaning of "NameOwnerChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNameOwnerChangedRegister(NameOwnerChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NameOwnerChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NameOwnerChanged'</b>:
     *
     * If the meaning of "NameOwnerChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNameOwnerChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNameOwnerChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NameOwnerChanged'.
     */
    void sendNameOwnerChangedDeregisterAll () const;



    // Method 'GetNameOwner'

    /**
     * Call the method 'GetNameOwner'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetNameOwner'</b>:
     *
     * If the meaning of "GetNameOwner" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetNameOwnerRequest(GetNameOwnerCallbackIF& cb, const ::std::string& name) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    DBusProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class DBusProxyCallback;
};

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace conndbus

#endif // CONNDBUS_ORG_FREEDESKTOP_DBUSPROXY_H
