#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef CONNDBUS_ORG_FREEDESKTOP_DBUS_H
#define CONNDBUS_ORG_FREEDESKTOP_DBUS_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "DBus" isn't clear, then there should be a description here.
 */

namespace conndbus {
namespace org {
namespace freedesktop {
namespace DBus {

// method IDs
static const uint16 ID_GetNameOwner = 0;

// signal IDs
static const uint16 ID_NameOwnerChanged = 1;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetNameOwnerRequest;

class GetNameOwnerResponse;

class NameOwnerChangedSignal;

// type definitions
/**
 * If the meaning of "GetNameOwnerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetNameOwnerError;

/**
 * If the meaning of "NameOwnerChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameOwnerChangedError;


/**
 * If the meaning of "GetNameOwnerRequest" isn't clear, then there should be a description here.
 */
class GetNameOwnerRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNameOwnerRequest ();

    /**
     * Copy constructor
     */
    inline  GetNameOwnerRequest (const GetNameOwnerRequest &rhs);

    /**
     * All fields constructor
     */
    inline  GetNameOwnerRequest (const ::std::string& name_);

    /**
     * Destructor
     */
    inline virtual  ~GetNameOwnerRequest();

    /**
     * Assignment operator
     */
    inline GetNameOwnerRequest& operator = (const GetNameOwnerRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNameOwnerRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNameOwnerRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNameOwnerRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNameOwnerRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const GetNameOwnerRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _name;

};

/**
 * If the meaning of "GetNameOwnerResponse" isn't clear, then there should be a description here.
 */
class GetNameOwnerResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetNameOwnerResponse ();

    /**
     * Copy constructor
     */
    inline  GetNameOwnerResponse (const GetNameOwnerResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetNameOwnerResponse (const ::std::string& uniqueid_);

    /**
     * Destructor
     */
    inline virtual  ~GetNameOwnerResponse();

    /**
     * Assignment operator
     */
    inline GetNameOwnerResponse& operator = (const GetNameOwnerResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetNameOwnerResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetNameOwnerResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetNameOwnerResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetNameOwnerResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "uniqueid"

    static const int kUniqueid = 0;

    /**
     * Clears the field "uniqueid".
     *
     * The field will be set to its default value. The hasUniqueid()
     * method will return false.
     */
    inline void clearUniqueid();

    /**
     * Checks whether the field "uniqueid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUniqueid()). Otherwise it will return false.
     */
    inline bool hasUniqueid () const;

    /**
     * Returns the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uniqueid"
     */
    inline const ::std::string& getUniqueid () const;

    /**
     * Retrieves the value of the field "uniqueid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "uniqueid".
     */
    inline ::std::string& getUniqueidMutable ();

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const ::std::string& uniqueid_);

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const char* uniqueid_);

    /**
     * Sets the value of the member "uniqueid".
     *
     * If the meaning of "uniqueid" isn't clear, then there should be a description here.
     *
     * @param uniqueid The value which will be set
     */
    inline void setUniqueid (const char* value, size_t size);

    static const GetNameOwnerResponse &getDefaultInstance();

private:

    inline void set_has_uniqueid ();

    inline void clear_has_uniqueid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _uniqueid;

};

/**
 * If the meaning of "NameOwnerChangedSignal" isn't clear, then there should be a description here.
 */
class NameOwnerChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameOwnerChangedSignal ();

    /**
     * Copy constructor
     */
    inline  NameOwnerChangedSignal (const NameOwnerChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  NameOwnerChangedSignal (const ::std::string& name_, const ::std::string& old_, const ::std::string& new_);

    /**
     * Destructor
     */
    inline virtual  ~NameOwnerChangedSignal();

    /**
     * Assignment operator
     */
    inline NameOwnerChangedSignal& operator = (const NameOwnerChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameOwnerChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameOwnerChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameOwnerChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameOwnerChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "old"

    static const int kOld = 1;

    /**
     * Clears the field "old".
     *
     * The field will be set to its default value. The hasOld()
     * method will return false.
     */
    inline void clearOld();

    /**
     * Checks whether the field "old" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setOld()). Otherwise it will return false.
     */
    inline bool hasOld () const;

    /**
     * Returns the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @return The value of the field "old"
     */
    inline const ::std::string& getOld () const;

    /**
     * Retrieves the value of the field "old" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "old".
     */
    inline ::std::string& getOldMutable ();

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const ::std::string& old_);

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const char* old_);

    /**
     * Sets the value of the member "old".
     *
     * If the meaning of "old" isn't clear, then there should be a description here.
     *
     * @param old The value which will be set
     */
    inline void setOld (const char* value, size_t size);

    // API of field "new"

    static const int kNew = 2;

    /**
     * Clears the field "new_".
     *
     * The field will be set to its default value. The hasNew()
     * method will return false.
     */
    inline void clearNew();

    /**
     * Checks whether the field "new" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNew()). Otherwise it will return false.
     */
    inline bool hasNew () const;

    /**
     * Returns the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @return The value of the field "new_"
     */
    inline const ::std::string& getNew () const;

    /**
     * Retrieves the value of the field "new" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "new".
     */
    inline ::std::string& getNewMutable ();

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const ::std::string& new_);

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const char* new_);

    /**
     * Sets the value of the member "new".
     *
     * If the meaning of "new" isn't clear, then there should be a description here.
     *
     * @param new_ The value which will be set
     */
    inline void setNew (const char* value, size_t size);

    static const NameOwnerChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_old ();

    inline void clear_has_old ();

    inline void set_has_new ();

    inline void clear_has_new ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _name;

    ::std::string _old;

    ::std::string _new;

};

inline  GetNameOwnerRequest::GetNameOwnerRequest ()  :
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNameOwnerRequest::GetNameOwnerRequest (const GetNameOwnerRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNameOwnerRequest::GetNameOwnerRequest (const ::std::string& name_)  :
    _name (name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNameOwnerRequest::~GetNameOwnerRequest() {
}

inline GetNameOwnerRequest& GetNameOwnerRequest::operator = (const GetNameOwnerRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool GetNameOwnerRequest::operator == (const GetNameOwnerRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool GetNameOwnerRequest::operator != (const GetNameOwnerRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNameOwnerRequest::operator < (const GetNameOwnerRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNameOwnerRequest::clone() {
    return new GetNameOwnerRequest(*this);
}

inline bool GetNameOwnerRequest::operator > (const GetNameOwnerRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNameOwnerRequest::clear() {
    clearName();
}

inline void GetNameOwnerRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool GetNameOwnerRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNameOwnerRequest::getName () const {
    return _name;
}

inline ::std::string& GetNameOwnerRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void GetNameOwnerRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void GetNameOwnerRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void GetNameOwnerRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void GetNameOwnerRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNameOwnerRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetNameOwnerResponse::GetNameOwnerResponse ()  :
    _uniqueid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetNameOwnerResponse::GetNameOwnerResponse (const GetNameOwnerResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _uniqueid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetNameOwnerResponse::GetNameOwnerResponse (const ::std::string& uniqueid_)  :
    _uniqueid (uniqueid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetNameOwnerResponse::~GetNameOwnerResponse() {
}

inline GetNameOwnerResponse& GetNameOwnerResponse::operator = (const GetNameOwnerResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasUniqueid()) {
            setUniqueid(rhs.getUniqueid());
        } else {
            clearUniqueid();
        }
    }
    return *this;
}

inline bool GetNameOwnerResponse::operator == (const GetNameOwnerResponse& rhs) const {
    return (((!hasUniqueid() && !rhs.hasUniqueid()) || getUniqueid() == rhs.getUniqueid()));
}

inline bool GetNameOwnerResponse::operator != (const GetNameOwnerResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetNameOwnerResponse::operator < (const GetNameOwnerResponse& rhs) const {
    if (hasUniqueid() || rhs.hasUniqueid()) {
        if (getUniqueid() < rhs.getUniqueid()) return true;
        if (getUniqueid() > rhs.getUniqueid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetNameOwnerResponse::clone() {
    return new GetNameOwnerResponse(*this);
}

inline bool GetNameOwnerResponse::operator > (const GetNameOwnerResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetNameOwnerResponse::clear() {
    clearUniqueid();
}

inline void GetNameOwnerResponse::clearUniqueid() {
    if (hasUniqueid()) {
         clear_has_uniqueid();
        _uniqueid.clear();
     }
}

inline bool GetNameOwnerResponse::hasUniqueid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetNameOwnerResponse::getUniqueid () const {
    return _uniqueid;
}

inline ::std::string& GetNameOwnerResponse::getUniqueidMutable () {
    set_has_uniqueid();
    return _uniqueid;
}

inline void GetNameOwnerResponse::setUniqueid (const ::std::string& uniqueid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid = uniqueid_;
}

inline void GetNameOwnerResponse::setUniqueid (const char* uniqueid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uniqueid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid.assign(uniqueid_);
}

inline void GetNameOwnerResponse::setUniqueid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uniqueid();
    this->_uniqueid.assign(value, size);
}

inline void GetNameOwnerResponse::set_has_uniqueid () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetNameOwnerResponse::clear_has_uniqueid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal ()  :
    _name (),
    _old (),
    _new ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal (const NameOwnerChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _old (),
    _new ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameOwnerChangedSignal::NameOwnerChangedSignal (const ::std::string& name_, const ::std::string& old_, const ::std::string& new_)  :
    _name (name_),
    _old (old_),
    _new (new_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameOwnerChangedSignal::~NameOwnerChangedSignal() {
}

inline NameOwnerChangedSignal& NameOwnerChangedSignal::operator = (const NameOwnerChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasOld()) {
            setOld(rhs.getOld());
        } else {
            clearOld();
        }
        if (rhs.hasNew()) {
            setNew(rhs.getNew());
        } else {
            clearNew();
        }
    }
    return *this;
}

inline bool NameOwnerChangedSignal::operator == (const NameOwnerChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasOld() && !rhs.hasOld()) || getOld() == rhs.getOld()) &&
        ((!hasNew() && !rhs.hasNew()) || getNew() == rhs.getNew()));
}

inline bool NameOwnerChangedSignal::operator != (const NameOwnerChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool NameOwnerChangedSignal::operator < (const NameOwnerChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasOld() || rhs.hasOld()) {
        if (getOld() < rhs.getOld()) return true;
        if (getOld() > rhs.getOld()) return false;
    }
    if (hasNew() || rhs.hasNew()) {
        if (getNew() < rhs.getNew()) return true;
        if (getNew() > rhs.getNew()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameOwnerChangedSignal::clone() {
    return new NameOwnerChangedSignal(*this);
}

inline bool NameOwnerChangedSignal::operator > (const NameOwnerChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameOwnerChangedSignal::clear() {
    clearName();
    clearOld();
    clearNew();
}

inline void NameOwnerChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool NameOwnerChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getName () const {
    return _name;
}

inline ::std::string& NameOwnerChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void NameOwnerChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void NameOwnerChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void NameOwnerChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void NameOwnerChangedSignal::clearOld() {
    if (hasOld()) {
         clear_has_old();
        _old.clear();
     }
}

inline bool NameOwnerChangedSignal::hasOld () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getOld () const {
    return _old;
}

inline ::std::string& NameOwnerChangedSignal::getOldMutable () {
    set_has_old();
    return _old;
}

inline void NameOwnerChangedSignal::setOld (const ::std::string& old_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old = old_;
}

inline void NameOwnerChangedSignal::setOld (const char* old_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (old_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old.assign(old_);
}

inline void NameOwnerChangedSignal::setOld (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_old();
    this->_old.assign(value, size);
}

inline void NameOwnerChangedSignal::clearNew() {
    if (hasNew()) {
         clear_has_new();
        _new.clear();
     }
}

inline bool NameOwnerChangedSignal::hasNew () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline const ::std::string& NameOwnerChangedSignal::getNew () const {
    return _new;
}

inline ::std::string& NameOwnerChangedSignal::getNewMutable () {
    set_has_new();
    return _new;
}

inline void NameOwnerChangedSignal::setNew (const ::std::string& new_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new = new_;
}

inline void NameOwnerChangedSignal::setNew (const char* new_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (new_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new.assign(new_);
}

inline void NameOwnerChangedSignal::setNew (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_new();
    this->_new.assign(value, size);
}

inline void NameOwnerChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameOwnerChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void NameOwnerChangedSignal::set_has_old () {
    _has_bits_[0] |= 1u << 1;
}

inline void NameOwnerChangedSignal::clear_has_old () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void NameOwnerChangedSignal::set_has_new () {
    _has_bits_[0] |= 1u << 2;
}

inline void NameOwnerChangedSignal::clear_has_new () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace DBus
} // namespace freedesktop
} // namespace org
} // namespace conndbus

#endif // CONNDBUS_ORG_FREEDESKTOP_DBUS_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
