/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BOSCH_ECNR_SERVICESTUB_H
#define ORG_BOSCH_ECNR_SERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bosch/ecnr/service.h"
#include <string>
#include <vector>

namespace org {
namespace bosch {
namespace ecnr {
namespace service {

class ServiceStubDelegate;

class ServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ServiceStub (const std::string& portName);

    /**
     * Create an instance of the ServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~ServiceStub();

    // signal 'ecnrAsrModeEnable'

    /**
     * Raise the signal 'ecnrAsrModeEnable' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ecnrAsrModeEnable'</b>:
     *
     * If the meaning of "ecnrAsrModeEnable" isn't clear, then there should be a description here.
     *
     * @param StatusAsrMode If the meaning of "StatusAsrMode" isn't clear, then there should be a description here.
     */
    void sendEcnrAsrModeEnableSignal(int32 statusAsrMode);

    // signal 'ecnrAudioStatus'

    /**
     * Raise the signal 'ecnrAudioStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ecnrAudioStatus'</b>:
     *
     * If the meaning of "ecnrAudioStatus" isn't clear, then there should be a description here.
     *
     * @param AudioStatus If the meaning of "AudioStatus" isn't clear, then there should be a description here.
     */
    void sendEcnrAudioStatusSignal(int32 audioStatus);

    // signal 'ecnrMicroLevelStatus'

    /**
     * Raise the signal 'ecnrMicroLevelStatus' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ecnrMicroLevelStatus'</b>:
     *
     * If the meaning of "ecnrMicroLevelStatus" isn't clear, then there should be a description here.
     *
     * @param StatusMicroLevel If the meaning of "StatusMicroLevel" isn't clear, then there should be a description here.
     */
    void sendEcnrMicroLevelStatusSignal(uint32 statusMicroLevel);

    // property 'ecnrMicLvlNtfyInterval'

    /**
     * The method onEcnrMicLvlNtfyIntervalGet() is called by ASF when a client
     * invokes the read method for the property 'ecnrMicLvlNtfyInterval'. The
     * onEcnrMicLvlNtfyIntervalGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     */
    virtual void onEcnrMicLvlNtfyIntervalGet(const ::boost::shared_ptr< EcnrMicLvlNtfyIntervalGet >& payload);

    /**
     * Sends back the update to a previous onEcnrMicLvlNtfyIntervalGet().
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onEcnrMicLvlNtfyIntervalGet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrMicLvlNtfyIntervalGetUpdate(uint32 ecnrMicLvlNtfyInterval, act_t act = 0);

    /**
     * The method onEcnrMicLvlNtfyIntervalSet() is called by ASF when a client
     * invokes the write method for the property 'ecnrMicLvlNtfyInterval'. The
     * onEcnrMicLvlNtfyIntervalSet() method set property value to the given
     * parameter ecnrMicLvlNtfyInterval by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     */
    virtual void onEcnrMicLvlNtfyIntervalSet(const ::boost::shared_ptr< EcnrMicLvlNtfyIntervalSet >& payload);

    /**
     * Sends back the update to a previous onEcnrMicLvlNtfyIntervalSet().
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onEcnrMicLvlNtfyIntervalSet(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrMicLvlNtfyIntervalSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'ecnrMicLvlNtfyInterval' and send updates
     * to registered clients. No updates will be sent if the property value
     * does not change.
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     */
    void setEcnrMicLvlNtfyInterval(uint32 ecnrMicLvlNtfyInterval);

    /**
     * Returns the current value of the property 'ecnrMicLvlNtfyInterval'.
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     */
    uint32 getEcnrMicLvlNtfyInterval() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEcnrMicLvlNtfyIntervalUpdate().
     *
     * <b>Documentation of 'ecnrMicLvlNtfyInterval'</b>:
     *
     * If the meaning of "ecnrMicLvlNtfyInterval" isn't clear, then there should be a description here.
     */
    void sendEcnrMicLvlNtfyIntervalUpdate();

    // property 'ecnrAsrMode'

    /**
     * The method onEcnrAsrModeGet() is called by ASF when a client invokes
     * the read method for the property 'ecnrAsrMode'. The onEcnrAsrModeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'ecnrAsrMode'</b>:
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     */
    virtual void onEcnrAsrModeGet(const ::boost::shared_ptr< EcnrAsrModeGet >& payload);

    /**
     * Sends back the update to a previous onEcnrAsrModeGet().
     *
     * <b>Documentation of 'ecnrAsrMode'</b>:
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEcnrAsrModeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrAsrModeGetUpdate(int32 ecnrAsrMode, act_t act = 0);

    /**
     * Set the value of the property 'ecnrAsrMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ecnrAsrMode'</b>:
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     */
    void setEcnrAsrMode(int32 ecnrAsrMode);

    /**
     * Returns the current value of the property 'ecnrAsrMode'.
     *
     * <b>Documentation of 'ecnrAsrMode'</b>:
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     */
    int32 getEcnrAsrMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEcnrAsrModeUpdate().
     *
     * <b>Documentation of 'ecnrAsrMode'</b>:
     *
     * If the meaning of "ecnrAsrMode" isn't clear, then there should be a description here.
     */
    void sendEcnrAsrModeUpdate();

    // property 'ecnrAudioState'

    /**
     * The method onEcnrAudioStateGet() is called by ASF when a client invokes
     * the read method for the property 'ecnrAudioState'. The
     * onEcnrAudioStateGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ecnrAudioState'</b>:
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     */
    virtual void onEcnrAudioStateGet(const ::boost::shared_ptr< EcnrAudioStateGet >& payload);

    /**
     * Sends back the update to a previous onEcnrAudioStateGet().
     *
     * <b>Documentation of 'ecnrAudioState'</b>:
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEcnrAudioStateGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrAudioStateGetUpdate(int32 ecnrAudioState, act_t act = 0);

    /**
     * Set the value of the property 'ecnrAudioState' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ecnrAudioState'</b>:
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     */
    void setEcnrAudioState(int32 ecnrAudioState);

    /**
     * Returns the current value of the property 'ecnrAudioState'.
     *
     * <b>Documentation of 'ecnrAudioState'</b>:
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     */
    int32 getEcnrAudioState() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEcnrAudioStateUpdate().
     *
     * <b>Documentation of 'ecnrAudioState'</b>:
     *
     * If the meaning of "ecnrAudioState" isn't clear, then there should be a description here.
     */
    void sendEcnrAudioStateUpdate();

    // property 'ecnrAsrDataType'

    /**
     * The method onEcnrAsrDataTypeGet() is called by ASF when a client
     * invokes the read method for the property 'ecnrAsrDataType'. The
     * onEcnrAsrDataTypeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     */
    virtual void onEcnrAsrDataTypeGet(const ::boost::shared_ptr< EcnrAsrDataTypeGet >& payload);

    /**
     * Sends back the update to a previous onEcnrAsrDataTypeGet().
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onEcnrAsrDataTypeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrAsrDataTypeGetUpdate(const ::std::vector< uint8 >& ecnrAsrDataType, act_t act = 0);

    /**
     * Set the value of the property 'ecnrAsrDataType' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     */
    void setEcnrAsrDataType(const ::std::vector< uint8 >& ecnrAsrDataType);

    /**
     * Returns the current value of the property 'ecnrAsrDataType'.
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getEcnrAsrDataType() const;

    /**
     * Returns the current value of the property 'ecnrAsrDataType' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendEcnrAsrDataTypeUpdate() method.
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getEcnrAsrDataTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendEcnrAsrDataTypeUpdate().
     *
     * <b>Documentation of 'ecnrAsrDataType'</b>:
     *
     * If the meaning of "ecnrAsrDataType" isn't clear, then there should be a description here.
     */
    void sendEcnrAsrDataTypeUpdate();

    // method 'ecnrGetVersion'

    /**
     * The method onEcnrGetVersion() is called by ASF when a client invokes
     * the method 'ecnrGetVersion'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrGetVersion() or sendEcnrGetVersionError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ecnrGetVersion'</b>:
     *
     * If the meaning of "ecnrGetVersion" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrGetVersionRequest (const ::boost::shared_ptr< EcnrGetVersionRequest >& request) = 0;

    /**
     * The method sendEcnrGetVersionResponse() sends a response of a previous
     * method invocation of 'ecnrGetVersion' back to the client.
     *
     * <b>Documentation of 'ecnrGetVersion'</b>:
     *
     * If the meaning of "ecnrGetVersion" isn't clear, then there should be a description here.
     *
     * @param Version If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param VersionString If the meaning of "VersionString" isn't clear, then there should be a description here.
     *
     * @param VersionComment If the meaning of "VersionComment" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrGetVersion(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrGetVersionResponse (const ::std::vector< uint32 >& version, const ::std::string& versionString, const ::std::string& versionComment, act_t act = 0);

    /**
     * The method sendEcnrGetVersionError() sends an error response of a
     * previous method invocation of 'ecnrGetVersion' back to the client.
     *
     * <b>Documentation of 'ecnrGetVersion'</b>:
     *
     * If the meaning of "ecnrGetVersion" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrGetVersion(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrGetVersionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrGetStatusMessage'

    /**
     * The method onEcnrGetStatusMessage() is called by ASF when a client
     * invokes the method 'ecnrGetStatusMessage'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrGetStatusMessage() or sendEcnrGetStatusMessageError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrGetStatusMessage'</b>:
     *
     * If the meaning of "ecnrGetStatusMessage" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrGetStatusMessageRequest (const ::boost::shared_ptr< EcnrGetStatusMessageRequest >& request) = 0;

    /**
     * The method sendEcnrGetStatusMessageResponse() sends a response of a
     * previous method invocation of 'ecnrGetStatusMessage' back to the
     * client.
     *
     * <b>Documentation of 'ecnrGetStatusMessage'</b>:
     *
     * If the meaning of "ecnrGetStatusMessage" isn't clear, then there should be a description here.
     *
     * @param StatusMessage If the meaning of "StatusMessage" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrGetStatusMessage(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetStatusMessageResponse (const ::std::string& statusMessage, act_t act = 0);

    /**
     * The method sendEcnrGetStatusMessageError() sends an error response of a
     * previous method invocation of 'ecnrGetStatusMessage' back to the
     * client.
     *
     * <b>Documentation of 'ecnrGetStatusMessage'</b>:
     *
     * If the meaning of "ecnrGetStatusMessage" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrGetStatusMessage(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetStatusMessageError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrInitialize'

    /**
     * The method onEcnrInitialize() is called by ASF when a client invokes
     * the method 'ecnrInitialize'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrInitialize() or sendEcnrInitializeError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ecnrInitialize'</b>:
     *
     * If the meaning of "ecnrInitialize" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrInitializeRequest (const ::boost::shared_ptr< EcnrInitializeRequest >& request) = 0;

    /**
     * The method sendEcnrInitializeResponse() sends a response of a previous
     * method invocation of 'ecnrInitialize' back to the client.
     *
     * <b>Documentation of 'ecnrInitialize'</b>:
     *
     * If the meaning of "ecnrInitialize" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrInitialize(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrInitializeResponse (act_t act = 0);

    /**
     * The method sendEcnrInitializeError() sends an error response of a
     * previous method invocation of 'ecnrInitialize' back to the client.
     *
     * <b>Documentation of 'ecnrInitialize'</b>:
     *
     * If the meaning of "ecnrInitialize" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrInitialize(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrInitializeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrInitializeSync'

    /**
     * The method onEcnrInitializeSync() is called by ASF when a client
     * invokes the method 'ecnrInitializeSync'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrInitializeSync() or sendEcnrInitializeSyncError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrInitializeSync'</b>:
     *
     * If the meaning of "ecnrInitializeSync" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrInitializeSyncRequest (const ::boost::shared_ptr< EcnrInitializeSyncRequest >& request) = 0;

    /**
     * The method sendEcnrInitializeSyncResponse() sends a response of a
     * previous method invocation of 'ecnrInitializeSync' back to the client.
     *
     * <b>Documentation of 'ecnrInitializeSync'</b>:
     *
     * If the meaning of "ecnrInitializeSync" isn't clear, then there should be a description here.
     *
     * @param InDevices If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @param OutDevices If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @param DeviceProperties If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrInitializeSync(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrInitializeSyncResponse (const ::std::vector< ::std::string >& inDevices, const ::std::vector< ::std::string >& outDevices, const ::std::vector< uint32 >& deviceProperties, act_t act = 0);

    /**
     * The method sendEcnrInitializeSyncError() sends an error response of a
     * previous method invocation of 'ecnrInitializeSync' back to the client.
     *
     * <b>Documentation of 'ecnrInitializeSync'</b>:
     *
     * If the meaning of "ecnrInitializeSync" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrInitializeSync().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrInitializeSyncError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrReset'

    /**
     * The method onEcnrReset() is called by ASF when a client invokes the
     * method 'ecnrReset'. A subclass has to implement this method and send
     * back a response to the client either with the sendEcnrReset() or
     * sendEcnrResetError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrReset'</b>:
     *
     * If the meaning of "ecnrReset" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrResetRequest (const ::boost::shared_ptr< EcnrResetRequest >& request) = 0;

    /**
     * The method sendEcnrResetResponse() sends a response of a previous
     * method invocation of 'ecnrReset' back to the client.
     *
     * <b>Documentation of 'ecnrReset'</b>:
     *
     * If the meaning of "ecnrReset" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrReset(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrResetResponse (act_t act = 0);

    /**
     * The method sendEcnrResetError() sends an error response of a previous
     * method invocation of 'ecnrReset' back to the client.
     *
     * <b>Documentation of 'ecnrReset'</b>:
     *
     * If the meaning of "ecnrReset" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrReset(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEcnrResetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrDestroy'

    /**
     * The method onEcnrDestroy() is called by ASF when a client invokes the
     * method 'ecnrDestroy'. A subclass has to implement this method and send
     * back a response to the client either with the sendEcnrDestroy() or
     * sendEcnrDestroyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrDestroy'</b>:
     *
     * If the meaning of "ecnrDestroy" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrDestroyRequest (const ::boost::shared_ptr< EcnrDestroyRequest >& request) = 0;

    /**
     * The method sendEcnrDestroyResponse() sends a response of a previous
     * method invocation of 'ecnrDestroy' back to the client.
     *
     * <b>Documentation of 'ecnrDestroy'</b>:
     *
     * If the meaning of "ecnrDestroy" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrDestroy(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrDestroyResponse (act_t act = 0);

    /**
     * The method sendEcnrDestroyError() sends an error response of a previous
     * method invocation of 'ecnrDestroy' back to the client.
     *
     * <b>Documentation of 'ecnrDestroy'</b>:
     *
     * If the meaning of "ecnrDestroy" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrDestroy(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendEcnrDestroyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrTerminate'

    /**
     * The method onEcnrTerminate() is called by ASF when a client invokes the
     * method 'ecnrTerminate'. A subclass has to implement this method and
     * send back a response to the client either with the sendEcnrTerminate()
     * or sendEcnrTerminateError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ecnrTerminate'</b>:
     *
     * If the meaning of "ecnrTerminate" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrTerminateRequest (const ::boost::shared_ptr< EcnrTerminateRequest >& request) = 0;

    /**
     * The method sendEcnrTerminateResponse() sends a response of a previous
     * method invocation of 'ecnrTerminate' back to the client.
     *
     * <b>Documentation of 'ecnrTerminate'</b>:
     *
     * If the meaning of "ecnrTerminate" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrTerminate(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrTerminateResponse (act_t act = 0);

    /**
     * The method sendEcnrTerminateError() sends an error response of a
     * previous method invocation of 'ecnrTerminate' back to the client.
     *
     * <b>Documentation of 'ecnrTerminate'</b>:
     *
     * If the meaning of "ecnrTerminate" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrTerminate(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrTerminateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetConfiguration'

    /**
     * The method onEcnrSetConfiguration() is called by ASF when a client
     * invokes the method 'ecnrSetConfiguration'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrSetConfiguration() or sendEcnrSetConfigurationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrSetConfiguration'</b>:
     *
     * If the meaning of "ecnrSetConfiguration" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetConfigurationRequest (const ::boost::shared_ptr< EcnrSetConfigurationRequest >& request) = 0;

    /**
     * The method sendEcnrSetConfigurationResponse() sends a response of a
     * previous method invocation of 'ecnrSetConfiguration' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetConfiguration'</b>:
     *
     * If the meaning of "ecnrSetConfiguration" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetConfiguration(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetConfigurationResponse (act_t act = 0);

    /**
     * The method sendEcnrSetConfigurationError() sends an error response of a
     * previous method invocation of 'ecnrSetConfiguration' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetConfiguration'</b>:
     *
     * If the meaning of "ecnrSetConfiguration" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetConfiguration(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetConfigurationSync'

    /**
     * The method onEcnrSetConfigurationSync() is called by ASF when a client
     * invokes the method 'ecnrSetConfigurationSync'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrSetConfigurationSync() or
     * sendEcnrSetConfigurationSyncError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ecnrSetConfigurationSync'</b>:
     *
     * If the meaning of "ecnrSetConfigurationSync" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetConfigurationSyncRequest (const ::boost::shared_ptr< EcnrSetConfigurationSyncRequest >& request) = 0;

    /**
     * The method sendEcnrSetConfigurationSyncResponse() sends a response of a
     * previous method invocation of 'ecnrSetConfigurationSync' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetConfigurationSync'</b>:
     *
     * If the meaning of "ecnrSetConfigurationSync" isn't clear, then there should be a description here.
     *
     * @param InDevices If the meaning of "InDevices" isn't clear, then there should be a description here.
     *
     * @param OutDevices If the meaning of "OutDevices" isn't clear, then there should be a description here.
     *
     * @param DeviceProperties If the meaning of "DeviceProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetConfigurationSync(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetConfigurationSyncResponse (const ::std::vector< ::std::string >& inDevices, const ::std::vector< ::std::string >& outDevices, const ::std::vector< uint32 >& deviceProperties, act_t act = 0);

    /**
     * The method sendEcnrSetConfigurationSyncError() sends an error response
     * of a previous method invocation of 'ecnrSetConfigurationSync' back to
     * the client.
     *
     * <b>Documentation of 'ecnrSetConfigurationSync'</b>:
     *
     * If the meaning of "ecnrSetConfigurationSync" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetConfigurationSync(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetConfigurationSyncError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrGetEcnrConfiguration'

    /**
     * The method onEcnrGetEcnrConfiguration() is called by ASF when a client
     * invokes the method 'ecnrGetEcnrConfiguration'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrGetEcnrConfiguration() or
     * sendEcnrGetEcnrConfigurationError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'ecnrGetEcnrConfiguration'</b>:
     *
     * If the meaning of "ecnrGetEcnrConfiguration" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrGetEcnrConfigurationRequest (const ::boost::shared_ptr< EcnrGetEcnrConfigurationRequest >& request) = 0;

    /**
     * The method sendEcnrGetEcnrConfigurationResponse() sends a response of a
     * previous method invocation of 'ecnrGetEcnrConfiguration' back to the
     * client.
     *
     * <b>Documentation of 'ecnrGetEcnrConfiguration'</b>:
     *
     * If the meaning of "ecnrGetEcnrConfiguration" isn't clear, then there should be a description here.
     *
     * @param DatasetName If the meaning of "DatasetName" isn't clear, then there should be a description here.
     *
     * @param EcnrProperties If the meaning of "EcnrProperties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrGetEcnrConfiguration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetEcnrConfigurationResponse (const ::std::string& datasetName, const ::std::vector< uint32 >& ecnrProperties, act_t act = 0);

    /**
     * The method sendEcnrGetEcnrConfigurationError() sends an error response
     * of a previous method invocation of 'ecnrGetEcnrConfiguration' back to
     * the client.
     *
     * <b>Documentation of 'ecnrGetEcnrConfiguration'</b>:
     *
     * If the meaning of "ecnrGetEcnrConfiguration" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrGetEcnrConfiguration(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetEcnrConfigurationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrStartAudio'

    /**
     * The method onEcnrStartAudio() is called by ASF when a client invokes
     * the method 'ecnrStartAudio'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrStartAudio() or sendEcnrStartAudioError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ecnrStartAudio'</b>:
     *
     * If the meaning of "ecnrStartAudio" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrStartAudioRequest (const ::boost::shared_ptr< EcnrStartAudioRequest >& request) = 0;

    /**
     * The method sendEcnrStartAudioResponse() sends a response of a previous
     * method invocation of 'ecnrStartAudio' back to the client.
     *
     * <b>Documentation of 'ecnrStartAudio'</b>:
     *
     * If the meaning of "ecnrStartAudio" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrStartAudio(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrStartAudioResponse (act_t act = 0);

    /**
     * The method sendEcnrStartAudioError() sends an error response of a
     * previous method invocation of 'ecnrStartAudio' back to the client.
     *
     * <b>Documentation of 'ecnrStartAudio'</b>:
     *
     * If the meaning of "ecnrStartAudio" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrStartAudio(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrStartAudioError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrStartAudioExt'

    /**
     * The method onEcnrStartAudioExt() is called by ASF when a client invokes
     * the method 'ecnrStartAudioExt'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrStartAudioExt() or sendEcnrStartAudioExtError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrStartAudioExt'</b>:
     *
     * If the meaning of "ecnrStartAudioExt" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrStartAudioExtRequest (const ::boost::shared_ptr< EcnrStartAudioExtRequest >& request) = 0;

    /**
     * The method sendEcnrStartAudioExtResponse() sends a response of a
     * previous method invocation of 'ecnrStartAudioExt' back to the client.
     *
     * <b>Documentation of 'ecnrStartAudioExt'</b>:
     *
     * If the meaning of "ecnrStartAudioExt" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrStartAudioExt(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrStartAudioExtResponse (act_t act = 0);

    /**
     * The method sendEcnrStartAudioExtError() sends an error response of a
     * previous method invocation of 'ecnrStartAudioExt' back to the client.
     *
     * <b>Documentation of 'ecnrStartAudioExt'</b>:
     *
     * If the meaning of "ecnrStartAudioExt" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrStartAudioExt().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrStartAudioExtError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrStopAudio'

    /**
     * The method onEcnrStopAudio() is called by ASF when a client invokes the
     * method 'ecnrStopAudio'. A subclass has to implement this method and
     * send back a response to the client either with the sendEcnrStopAudio()
     * or sendEcnrStopAudioError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ecnrStopAudio'</b>:
     *
     * If the meaning of "ecnrStopAudio" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrStopAudioRequest (const ::boost::shared_ptr< EcnrStopAudioRequest >& request) = 0;

    /**
     * The method sendEcnrStopAudioResponse() sends a response of a previous
     * method invocation of 'ecnrStopAudio' back to the client.
     *
     * <b>Documentation of 'ecnrStopAudio'</b>:
     *
     * If the meaning of "ecnrStopAudio" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrStopAudio(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrStopAudioResponse (act_t act = 0);

    /**
     * The method sendEcnrStopAudioError() sends an error response of a
     * previous method invocation of 'ecnrStopAudio' back to the client.
     *
     * <b>Documentation of 'ecnrStopAudio'</b>:
     *
     * If the meaning of "ecnrStopAudio" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrStopAudio(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrStopAudioError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrFrameInfo'

    /**
     * The method onEcnrFrameInfo() is called by ASF when a client invokes the
     * method 'ecnrFrameInfo'. A subclass has to implement this method and
     * send back a response to the client either with the sendEcnrFrameInfo()
     * or sendEcnrFrameInfoError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'ecnrFrameInfo'</b>:
     *
     * If the meaning of "ecnrFrameInfo" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrFrameInfoRequest (const ::boost::shared_ptr< EcnrFrameInfoRequest >& request) = 0;

    /**
     * The method sendEcnrFrameInfoResponse() sends a response of a previous
     * method invocation of 'ecnrFrameInfo' back to the client.
     *
     * <b>Documentation of 'ecnrFrameInfo'</b>:
     *
     * If the meaning of "ecnrFrameInfo" isn't clear, then there should be a description here.
     *
     * @param FrameCounter If the meaning of "FrameCounter" isn't clear, then there should be a description here.
     *
     * @param VoicePresent If the meaning of "VoicePresent" isn't clear, then there should be a description here.
     *
     * @param AboveBackgroundNoise If the meaning of "AboveBackgroundNoise" isn't clear, then there should be a description here.
     *
     * @param PercentClipping If the meaning of "PercentClipping" isn't clear, then there should be a description here.
     *
     * @param InstantaneousSNR If the meaning of "InstantaneousSNR" isn't clear, then there should be a description here.
     *
     * @param SmoothVNR If the meaning of "SmoothVNR" isn't clear, then there should be a description here.
     *
     * @param ValidOutputCountdown If the meaning of "ValidOutputCountdown" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrFrameInfo(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrFrameInfoResponse (uint32 frameCounter, int32 voicePresent, int32 aboveBackgroundNoise, int32 percentClipping, int32 instantaneousSNR, int32 smoothVNR, int32 validOutputCountdown, act_t act = 0);

    /**
     * The method sendEcnrFrameInfoError() sends an error response of a
     * previous method invocation of 'ecnrFrameInfo' back to the client.
     *
     * <b>Documentation of 'ecnrFrameInfo'</b>:
     *
     * If the meaning of "ecnrFrameInfo" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrFrameInfo(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrFrameInfoError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrMicClipStats'

    /**
     * The method onEcnrMicClipStats() is called by ASF when a client invokes
     * the method 'ecnrMicClipStats'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrMicClipStats() or sendEcnrMicClipStatsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrMicClipStats'</b>:
     *
     * If the meaning of "ecnrMicClipStats" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrMicClipStatsRequest (const ::boost::shared_ptr< EcnrMicClipStatsRequest >& request) = 0;

    /**
     * The method sendEcnrMicClipStatsResponse() sends a response of a
     * previous method invocation of 'ecnrMicClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrMicClipStats'</b>:
     *
     * If the meaning of "ecnrMicClipStats" isn't clear, then there should be a description here.
     *
     * @param ClipFrames If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipCount If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param MaxAmp If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrMicClipStats(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrMicClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act = 0);

    /**
     * The method sendEcnrMicClipStatsError() sends an error response of a
     * previous method invocation of 'ecnrMicClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrMicClipStats'</b>:
     *
     * If the meaning of "ecnrMicClipStats" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrMicClipStats(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrMicClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrRefClipStats'

    /**
     * The method onEcnrRefClipStats() is called by ASF when a client invokes
     * the method 'ecnrRefClipStats'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrRefClipStats() or sendEcnrRefClipStatsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrRefClipStats'</b>:
     *
     * If the meaning of "ecnrRefClipStats" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrRefClipStatsRequest (const ::boost::shared_ptr< EcnrRefClipStatsRequest >& request) = 0;

    /**
     * The method sendEcnrRefClipStatsResponse() sends a response of a
     * previous method invocation of 'ecnrRefClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrRefClipStats'</b>:
     *
     * If the meaning of "ecnrRefClipStats" isn't clear, then there should be a description here.
     *
     * @param ClipFrames If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipCount If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param MaxAmp If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrRefClipStats(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrRefClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act = 0);

    /**
     * The method sendEcnrRefClipStatsError() sends an error response of a
     * previous method invocation of 'ecnrRefClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrRefClipStats'</b>:
     *
     * If the meaning of "ecnrRefClipStats" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrRefClipStats(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrRefClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrRecvClipStats'

    /**
     * The method onEcnrRecvClipStats() is called by ASF when a client invokes
     * the method 'ecnrRecvClipStats'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrRecvClipStats() or sendEcnrRecvClipStatsError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrRecvClipStats'</b>:
     *
     * If the meaning of "ecnrRecvClipStats" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrRecvClipStatsRequest (const ::boost::shared_ptr< EcnrRecvClipStatsRequest >& request) = 0;

    /**
     * The method sendEcnrRecvClipStatsResponse() sends a response of a
     * previous method invocation of 'ecnrRecvClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrRecvClipStats'</b>:
     *
     * If the meaning of "ecnrRecvClipStats" isn't clear, then there should be a description here.
     *
     * @param ClipFrames If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipCount If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param MaxAmp If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrRecvClipStats(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrRecvClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act = 0);

    /**
     * The method sendEcnrRecvClipStatsError() sends an error response of a
     * previous method invocation of 'ecnrRecvClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrRecvClipStats'</b>:
     *
     * If the meaning of "ecnrRecvClipStats" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrRecvClipStats().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrRecvClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrMicOutClipStats'

    /**
     * The method onEcnrMicOutClipStats() is called by ASF when a client
     * invokes the method 'ecnrMicOutClipStats'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrMicOutClipStats() or sendEcnrMicOutClipStatsError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrMicOutClipStats'</b>:
     *
     * If the meaning of "ecnrMicOutClipStats" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrMicOutClipStatsRequest (const ::boost::shared_ptr< EcnrMicOutClipStatsRequest >& request) = 0;

    /**
     * The method sendEcnrMicOutClipStatsResponse() sends a response of a
     * previous method invocation of 'ecnrMicOutClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrMicOutClipStats'</b>:
     *
     * If the meaning of "ecnrMicOutClipStats" isn't clear, then there should be a description here.
     *
     * @param ClipFrames If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipCount If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param MaxAmp If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrMicOutClipStats(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrMicOutClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act = 0);

    /**
     * The method sendEcnrMicOutClipStatsError() sends an error response of a
     * previous method invocation of 'ecnrMicOutClipStats' back to the client.
     *
     * <b>Documentation of 'ecnrMicOutClipStats'</b>:
     *
     * If the meaning of "ecnrMicOutClipStats" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrMicOutClipStats().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrMicOutClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrRecvOutClipStats'

    /**
     * The method onEcnrRecvOutClipStats() is called by ASF when a client
     * invokes the method 'ecnrRecvOutClipStats'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrRecvOutClipStats() or sendEcnrRecvOutClipStatsError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrRecvOutClipStats'</b>:
     *
     * If the meaning of "ecnrRecvOutClipStats" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrRecvOutClipStatsRequest (const ::boost::shared_ptr< EcnrRecvOutClipStatsRequest >& request) = 0;

    /**
     * The method sendEcnrRecvOutClipStatsResponse() sends a response of a
     * previous method invocation of 'ecnrRecvOutClipStats' back to the
     * client.
     *
     * <b>Documentation of 'ecnrRecvOutClipStats'</b>:
     *
     * If the meaning of "ecnrRecvOutClipStats" isn't clear, then there should be a description here.
     *
     * @param ClipFrames If the meaning of "ClipFrames" isn't clear, then there should be a description here.
     *
     * @param ClipCount If the meaning of "ClipCount" isn't clear, then there should be a description here.
     *
     * @param MaxAmp If the meaning of "MaxAmp" isn't clear, then there should be a description here.
     *
     * @param MinAmp If the meaning of "MinAmp" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrRecvOutClipStats(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrRecvOutClipStatsResponse (uint32 clipFrames, uint32 clipCount, int32 maxAmp, int32 minAmp, act_t act = 0);

    /**
     * The method sendEcnrRecvOutClipStatsError() sends an error response of a
     * previous method invocation of 'ecnrRecvOutClipStats' back to the
     * client.
     *
     * <b>Documentation of 'ecnrRecvOutClipStats'</b>:
     *
     * If the meaning of "ecnrRecvOutClipStats" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrRecvOutClipStats(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrRecvOutClipStatsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetSendMuteSwitch'

    /**
     * The method onEcnrSetSendMuteSwitch() is called by ASF when a client
     * invokes the method 'ecnrSetSendMuteSwitch'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrSetSendMuteSwitch() or sendEcnrSetSendMuteSwitchError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrSetSendMuteSwitch'</b>:
     *
     * If the meaning of "ecnrSetSendMuteSwitch" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetSendMuteSwitchRequest (const ::boost::shared_ptr< EcnrSetSendMuteSwitchRequest >& request) = 0;

    /**
     * The method sendEcnrSetSendMuteSwitchResponse() sends a response of a
     * previous method invocation of 'ecnrSetSendMuteSwitch' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetSendMuteSwitch'</b>:
     *
     * If the meaning of "ecnrSetSendMuteSwitch" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetSendMuteSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetSendMuteSwitchResponse (act_t act = 0);

    /**
     * The method sendEcnrSetSendMuteSwitchError() sends an error response of
     * a previous method invocation of 'ecnrSetSendMuteSwitch' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetSendMuteSwitch'</b>:
     *
     * If the meaning of "ecnrSetSendMuteSwitch" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetSendMuteSwitch(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetSendMuteSwitchError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetSendGainDelta'

    /**
     * The method onEcnrSetSendGainDelta() is called by ASF when a client
     * invokes the method 'ecnrSetSendGainDelta'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrSetSendGainDelta() or sendEcnrSetSendGainDeltaError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrSetSendGainDelta'</b>:
     *
     * If the meaning of "ecnrSetSendGainDelta" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetSendGainDeltaRequest (const ::boost::shared_ptr< EcnrSetSendGainDeltaRequest >& request) = 0;

    /**
     * The method sendEcnrSetSendGainDeltaResponse() sends a response of a
     * previous method invocation of 'ecnrSetSendGainDelta' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetSendGainDelta'</b>:
     *
     * If the meaning of "ecnrSetSendGainDelta" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetSendGainDelta(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetSendGainDeltaResponse (act_t act = 0);

    /**
     * The method sendEcnrSetSendGainDeltaError() sends an error response of a
     * previous method invocation of 'ecnrSetSendGainDelta' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetSendGainDelta'</b>:
     *
     * If the meaning of "ecnrSetSendGainDelta" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetSendGainDelta(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetSendGainDeltaError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetMicGain'

    /**
     * The method onEcnrSetMicGain() is called by ASF when a client invokes
     * the method 'ecnrSetMicGain'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrSetMicGain() or sendEcnrSetMicGainError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ecnrSetMicGain'</b>:
     *
     * If the meaning of "ecnrSetMicGain" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetMicGainRequest (const ::boost::shared_ptr< EcnrSetMicGainRequest >& request) = 0;

    /**
     * The method sendEcnrSetMicGainResponse() sends a response of a previous
     * method invocation of 'ecnrSetMicGain' back to the client.
     *
     * <b>Documentation of 'ecnrSetMicGain'</b>:
     *
     * If the meaning of "ecnrSetMicGain" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetMicGain(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrSetMicGainResponse (act_t act = 0);

    /**
     * The method sendEcnrSetMicGainError() sends an error response of a
     * previous method invocation of 'ecnrSetMicGain' back to the client.
     *
     * <b>Documentation of 'ecnrSetMicGain'</b>:
     *
     * If the meaning of "ecnrSetMicGain" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrSetMicGain(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrSetMicGainError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetPassThroughMode'

    /**
     * The method onEcnrSetPassThroughMode() is called by ASF when a client
     * invokes the method 'ecnrSetPassThroughMode'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrSetPassThroughMode() or
     * sendEcnrSetPassThroughModeError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ecnrSetPassThroughMode'</b>:
     *
     * If the meaning of "ecnrSetPassThroughMode" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetPassThroughModeRequest (const ::boost::shared_ptr< EcnrSetPassThroughModeRequest >& request) = 0;

    /**
     * The method sendEcnrSetPassThroughModeResponse() sends a response of a
     * previous method invocation of 'ecnrSetPassThroughMode' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetPassThroughMode'</b>:
     *
     * If the meaning of "ecnrSetPassThroughMode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetPassThroughMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetPassThroughModeResponse (act_t act = 0);

    /**
     * The method sendEcnrSetPassThroughModeError() sends an error response of
     * a previous method invocation of 'ecnrSetPassThroughMode' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetPassThroughMode'</b>:
     *
     * If the meaning of "ecnrSetPassThroughMode" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetPassThroughMode(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetPassThroughModeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetNRCombFloor'

    /**
     * The method onEcnrSetNRCombFloor() is called by ASF when a client
     * invokes the method 'ecnrSetNRCombFloor'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrSetNRCombFloor() or sendEcnrSetNRCombFloorError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrSetNRCombFloor'</b>:
     *
     * If the meaning of "ecnrSetNRCombFloor" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetNRCombFloorRequest (const ::boost::shared_ptr< EcnrSetNRCombFloorRequest >& request) = 0;

    /**
     * The method sendEcnrSetNRCombFloorResponse() sends a response of a
     * previous method invocation of 'ecnrSetNRCombFloor' back to the client.
     *
     * <b>Documentation of 'ecnrSetNRCombFloor'</b>:
     *
     * If the meaning of "ecnrSetNRCombFloor" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetNRCombFloor(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetNRCombFloorResponse (act_t act = 0);

    /**
     * The method sendEcnrSetNRCombFloorError() sends an error response of a
     * previous method invocation of 'ecnrSetNRCombFloor' back to the client.
     *
     * <b>Documentation of 'ecnrSetNRCombFloor'</b>:
     *
     * If the meaning of "ecnrSetNRCombFloor" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrSetNRCombFloor().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrSetNRCombFloorError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetEchoCancellation'

    /**
     * The method onEcnrSetEchoCancellation() is called by ASF when a client
     * invokes the method 'ecnrSetEchoCancellation'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrSetEchoCancellation() or
     * sendEcnrSetEchoCancellationError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ecnrSetEchoCancellation'</b>:
     *
     * If the meaning of "ecnrSetEchoCancellation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetEchoCancellationRequest (const ::boost::shared_ptr< EcnrSetEchoCancellationRequest >& request) = 0;

    /**
     * The method sendEcnrSetEchoCancellationResponse() sends a response of a
     * previous method invocation of 'ecnrSetEchoCancellation' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetEchoCancellation'</b>:
     *
     * If the meaning of "ecnrSetEchoCancellation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetEchoCancellation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetEchoCancellationResponse (act_t act = 0);

    /**
     * The method sendEcnrSetEchoCancellationError() sends an error response
     * of a previous method invocation of 'ecnrSetEchoCancellation' back to
     * the client.
     *
     * <b>Documentation of 'ecnrSetEchoCancellation'</b>:
     *
     * If the meaning of "ecnrSetEchoCancellation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetEchoCancellation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetEchoCancellationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrSetNoiseReduction'

    /**
     * The method onEcnrSetNoiseReduction() is called by ASF when a client
     * invokes the method 'ecnrSetNoiseReduction'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendEcnrSetNoiseReduction() or sendEcnrSetNoiseReductionError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'ecnrSetNoiseReduction'</b>:
     *
     * If the meaning of "ecnrSetNoiseReduction" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrSetNoiseReductionRequest (const ::boost::shared_ptr< EcnrSetNoiseReductionRequest >& request) = 0;

    /**
     * The method sendEcnrSetNoiseReductionResponse() sends a response of a
     * previous method invocation of 'ecnrSetNoiseReduction' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetNoiseReduction'</b>:
     *
     * If the meaning of "ecnrSetNoiseReduction" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrSetNoiseReduction(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetNoiseReductionResponse (act_t act = 0);

    /**
     * The method sendEcnrSetNoiseReductionError() sends an error response of
     * a previous method invocation of 'ecnrSetNoiseReduction' back to the
     * client.
     *
     * <b>Documentation of 'ecnrSetNoiseReduction'</b>:
     *
     * If the meaning of "ecnrSetNoiseReduction" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrSetNoiseReduction(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrSetNoiseReductionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrGetEngineParameter'

    /**
     * The method onEcnrGetEngineParameter() is called by ASF when a client
     * invokes the method 'ecnrGetEngineParameter'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendEcnrGetEngineParameter() or
     * sendEcnrGetEngineParameterError() method. Do not invoke this method on
     * your own.
     *
     * <b>Documentation of 'ecnrGetEngineParameter'</b>:
     *
     * If the meaning of "ecnrGetEngineParameter" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrGetEngineParameterRequest (const ::boost::shared_ptr< EcnrGetEngineParameterRequest >& request) = 0;

    /**
     * The method sendEcnrGetEngineParameterResponse() sends a response of a
     * previous method invocation of 'ecnrGetEngineParameter' back to the
     * client.
     *
     * <b>Documentation of 'ecnrGetEngineParameter'</b>:
     *
     * If the meaning of "ecnrGetEngineParameter" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrGetEngineParameter(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetEngineParameterResponse (const ::std::vector< uint8 >& data, act_t act = 0);

    /**
     * The method sendEcnrGetEngineParameterError() sends an error response of
     * a previous method invocation of 'ecnrGetEngineParameter' back to the
     * client.
     *
     * <b>Documentation of 'ecnrGetEngineParameter'</b>:
     *
     * If the meaning of "ecnrGetEngineParameter" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onEcnrGetEngineParameter(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendEcnrGetEngineParameterError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ecnrStartItcTest'

    /**
     * The method onEcnrStartItcTest() is called by ASF when a client invokes
     * the method 'ecnrStartItcTest'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendEcnrStartItcTest() or sendEcnrStartItcTestError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ecnrStartItcTest'</b>:
     *
     * If the meaning of "ecnrStartItcTest" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onEcnrStartItcTestRequest (const ::boost::shared_ptr< EcnrStartItcTestRequest >& request) = 0;

    /**
     * The method sendEcnrStartItcTestResponse() sends a response of a
     * previous method invocation of 'ecnrStartItcTest' back to the client.
     *
     * <b>Documentation of 'ecnrStartItcTest'</b>:
     *
     * If the meaning of "ecnrStartItcTest" isn't clear, then there should be a description here.
     *
     * @param rspITCValue If the meaning of "rspITCValue" isn't clear, then there should be a description here.
     *
     * @param TestResult If the meaning of "TestResult" isn't clear, then there should be a description here.
     *
     * @param TestErrorCode If the meaning of "TestErrorCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onEcnrStartItcTest(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendEcnrStartItcTestResponse (int32 rspITCValue, uint8 testResult, int32 testErrorCode, act_t act = 0);

    /**
     * The method sendEcnrStartItcTestError() sends an error response of a
     * previous method invocation of 'ecnrStartItcTest' back to the client.
     *
     * <b>Documentation of 'ecnrStartItcTest'</b>:
     *
     * If the meaning of "ecnrStartItcTest" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onEcnrStartItcTest(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendEcnrStartItcTestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    EcnrMicLvlNtfyIntervalUpdate _ecnrMicLvlNtfyIntervalProperty;

    EcnrAsrModeUpdate _ecnrAsrModeProperty;

    EcnrAudioStateUpdate _ecnrAudioStateProperty;

    EcnrAsrDataTypeUpdate _ecnrAsrDataTypeProperty;

    friend class ServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace service
} // namespace ecnr
} // namespace bosch
} // namespace org

#endif // ORG_BOSCH_ECNR_SERVICESTUB_H
