/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "org/bosch/ecnr/service.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of EcnrGetVersionResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetVersionResponse& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o0ArrayIter));
    const ::std::vector< uint32 >* o1 = &in.getVersion();
    ::std::vector< uint32 >::const_iterator o2 = o1->end();
    for (::std::vector< uint32 >::const_iterator o3 = o1->begin(); o3 != o2; ++o3) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o0ArrayIter, DBUS_TYPE_UINT32, &(*o3)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
    const char* o4 = in.getVersionString().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o4));
    const char* o5 = in.getVersionComment().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o5));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetVersionResponse& out) {
    {
        ::std::vector< uint32 > VersionValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o6ArrayIter;
            dbus_message_iter_recurse (in, &o6ArrayIter);

            if(dbus_message_iter_get_arg_type(&o6ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o7;
                    dbus_message_iter_get_basic(&o6ArrayIter, &o7);
                    VersionValue.push_back(o7);
                } while (dbus_message_iter_next(&o6ArrayIter));
            }
        }
        out.setVersion(VersionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string VersionStringValue;
        ::std::string &VersionStringTmpValue = VersionStringValue;
        {
            char* o8 = 0;
            dbus_message_iter_get_basic(in, &o8);
            VersionStringTmpValue.assign (o8);
        }
        out.setVersionString(VersionStringValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string VersionCommentValue;
        ::std::string &VersionCommentTmpValue = VersionCommentValue;
        {
            char* o9 = 0;
            dbus_message_iter_get_basic(in, &o9);
            VersionCommentTmpValue.assign (o9);
        }
        out.setVersionComment(VersionCommentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrGetStatusMessageRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetStatusMessageRequest& in, DBusMessageIter* out) {
    uint8 o10 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o10));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetStatusMessageRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrGetStatusMessageResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetStatusMessageResponse& in, DBusMessageIter* out) {
    const char* o11 = in.getStatusMessage().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o11));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetStatusMessageResponse& out) {
    {
        ::std::string StatusMessageValue;
        ::std::string &StatusMessageTmpValue = StatusMessageValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            StatusMessageTmpValue.assign (o12);
        }
        out.setStatusMessage(StatusMessageValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrInitializeRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrInitializeRequest& in, DBusMessageIter* out) {
    uint8 o13 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o13));
    uint32 o14 = in.getEcnrConfigurationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o14));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrInitializeRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ecnrConfigurationIdValue;
        uint32 &ecnrConfigurationIdTmpValue = ecnrConfigurationIdValue;
        dbus_message_iter_get_basic(in, &ecnrConfigurationIdTmpValue);
        out.setEcnrConfigurationId(ecnrConfigurationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrInitializeSyncRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrInitializeSyncRequest& in, DBusMessageIter* out) {
    uint8 o15 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o15));
    uint32 o16 = in.getEcnrConfigurationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o16));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrInitializeSyncRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ecnrConfigurationIdValue;
        uint32 &ecnrConfigurationIdTmpValue = ecnrConfigurationIdValue;
        dbus_message_iter_get_basic(in, &ecnrConfigurationIdTmpValue);
        out.setEcnrConfigurationId(ecnrConfigurationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrInitializeSyncResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrInitializeSyncResponse& in, DBusMessageIter* out) {
    DBusMessageIter o17ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o17ArrayIter));
    const ::std::vector< ::std::string >* o18 = &in.getInDevices();
    ::std::vector< ::std::string >::const_iterator o19 = o18->end();
    for (::std::vector< ::std::string >::const_iterator o20 = o18->begin(); o20 != o19; ++o20) {
        const char* o21 = (*o20).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o17ArrayIter, DBUS_TYPE_STRING, &o21));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o17ArrayIter));
    DBusMessageIter o22ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o22ArrayIter));
    const ::std::vector< ::std::string >* o23 = &in.getOutDevices();
    ::std::vector< ::std::string >::const_iterator o24 = o23->end();
    for (::std::vector< ::std::string >::const_iterator o25 = o23->begin(); o25 != o24; ++o25) {
        const char* o26 = (*o25).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o22ArrayIter, DBUS_TYPE_STRING, &o26));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o22ArrayIter));
    DBusMessageIter o27ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o27ArrayIter));
    const ::std::vector< uint32 >* o28 = &in.getDeviceProperties();
    ::std::vector< uint32 >::const_iterator o29 = o28->end();
    for (::std::vector< uint32 >::const_iterator o30 = o28->begin(); o30 != o29; ++o30) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o27ArrayIter, DBUS_TYPE_UINT32, &(*o30)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o27ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrInitializeSyncResponse& out) {
    {
        ::std::vector< ::std::string > InDevicesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o31ArrayIter;
            dbus_message_iter_recurse (in, &o31ArrayIter);

            if(dbus_message_iter_get_arg_type(&o31ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o32;
                    {
                        char* o33 = 0;
                        dbus_message_iter_get_basic(&o31ArrayIter, &o33);
                        o32.assign (o33);
                    }
                    InDevicesValue.push_back(o32);
                } while (dbus_message_iter_next(&o31ArrayIter));
            }
        }
        out.setInDevices(InDevicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > OutDevicesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o34ArrayIter;
            dbus_message_iter_recurse (in, &o34ArrayIter);

            if(dbus_message_iter_get_arg_type(&o34ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o35;
                    {
                        char* o36 = 0;
                        dbus_message_iter_get_basic(&o34ArrayIter, &o36);
                        o35.assign (o36);
                    }
                    OutDevicesValue.push_back(o35);
                } while (dbus_message_iter_next(&o34ArrayIter));
            }
        }
        out.setOutDevices(OutDevicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > DevicePropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o37ArrayIter;
            dbus_message_iter_recurse (in, &o37ArrayIter);

            if(dbus_message_iter_get_arg_type(&o37ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o38;
                    dbus_message_iter_get_basic(&o37ArrayIter, &o38);
                    DevicePropertiesValue.push_back(o38);
                } while (dbus_message_iter_next(&o37ArrayIter));
            }
        }
        out.setDeviceProperties(DevicePropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrResetRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrResetRequest& in, DBusMessageIter* out) {
    uint8 o39 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o39));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrResetRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrDestroyRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrDestroyRequest& in, DBusMessageIter* out) {
    uint8 o40 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o40));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrDestroyRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrTerminateRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrTerminateRequest& in, DBusMessageIter* out) {
    uint8 o41 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o41));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrTerminateRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetConfigurationRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetConfigurationRequest& in, DBusMessageIter* out) {
    uint8 o42 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o42));
    uint32 o43 = in.getEcnrConfigurationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o43));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetConfigurationRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ecnrConfigurationIdValue;
        uint32 &ecnrConfigurationIdTmpValue = ecnrConfigurationIdValue;
        dbus_message_iter_get_basic(in, &ecnrConfigurationIdTmpValue);
        out.setEcnrConfigurationId(ecnrConfigurationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetConfigurationSyncRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetConfigurationSyncRequest& in, DBusMessageIter* out) {
    uint8 o44 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o44));
    uint32 o45 = in.getEcnrConfigurationId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o45));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetConfigurationSyncRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ecnrConfigurationIdValue;
        uint32 &ecnrConfigurationIdTmpValue = ecnrConfigurationIdValue;
        dbus_message_iter_get_basic(in, &ecnrConfigurationIdTmpValue);
        out.setEcnrConfigurationId(ecnrConfigurationIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetConfigurationSyncResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetConfigurationSyncResponse& in, DBusMessageIter* out) {
    DBusMessageIter o46ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o46ArrayIter));
    const ::std::vector< ::std::string >* o47 = &in.getInDevices();
    ::std::vector< ::std::string >::const_iterator o48 = o47->end();
    for (::std::vector< ::std::string >::const_iterator o49 = o47->begin(); o49 != o48; ++o49) {
        const char* o50 = (*o49).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o46ArrayIter, DBUS_TYPE_STRING, &o50));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o46ArrayIter));
    DBusMessageIter o51ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "s", &o51ArrayIter));
    const ::std::vector< ::std::string >* o52 = &in.getOutDevices();
    ::std::vector< ::std::string >::const_iterator o53 = o52->end();
    for (::std::vector< ::std::string >::const_iterator o54 = o52->begin(); o54 != o53; ++o54) {
        const char* o55 = (*o54).c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o51ArrayIter, DBUS_TYPE_STRING, &o55));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o51ArrayIter));
    DBusMessageIter o56ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o56ArrayIter));
    const ::std::vector< uint32 >* o57 = &in.getDeviceProperties();
    ::std::vector< uint32 >::const_iterator o58 = o57->end();
    for (::std::vector< uint32 >::const_iterator o59 = o57->begin(); o59 != o58; ++o59) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o56ArrayIter, DBUS_TYPE_UINT32, &(*o59)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o56ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetConfigurationSyncResponse& out) {
    {
        ::std::vector< ::std::string > InDevicesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o60ArrayIter;
            dbus_message_iter_recurse (in, &o60ArrayIter);

            if(dbus_message_iter_get_arg_type(&o60ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o61;
                    {
                        char* o62 = 0;
                        dbus_message_iter_get_basic(&o60ArrayIter, &o62);
                        o61.assign (o62);
                    }
                    InDevicesValue.push_back(o61);
                } while (dbus_message_iter_next(&o60ArrayIter));
            }
        }
        out.setInDevices(InDevicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > OutDevicesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o63ArrayIter;
            dbus_message_iter_recurse (in, &o63ArrayIter);

            if(dbus_message_iter_get_arg_type(&o63ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o64;
                    {
                        char* o65 = 0;
                        dbus_message_iter_get_basic(&o63ArrayIter, &o65);
                        o64.assign (o65);
                    }
                    OutDevicesValue.push_back(o64);
                } while (dbus_message_iter_next(&o63ArrayIter));
            }
        }
        out.setOutDevices(OutDevicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > DevicePropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o66ArrayIter;
            dbus_message_iter_recurse (in, &o66ArrayIter);

            if(dbus_message_iter_get_arg_type(&o66ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o67;
                    dbus_message_iter_get_basic(&o66ArrayIter, &o67);
                    DevicePropertiesValue.push_back(o67);
                } while (dbus_message_iter_next(&o66ArrayIter));
            }
        }
        out.setDeviceProperties(DevicePropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrGetEcnrConfigurationResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetEcnrConfigurationResponse& in, DBusMessageIter* out) {
    const char* o68 = in.getDatasetName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o68));
    DBusMessageIter o69ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "u", &o69ArrayIter));
    const ::std::vector< uint32 >* o70 = &in.getEcnrProperties();
    ::std::vector< uint32 >::const_iterator o71 = o70->end();
    for (::std::vector< uint32 >::const_iterator o72 = o70->begin(); o72 != o71; ++o72) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o69ArrayIter, DBUS_TYPE_UINT32, &(*o72)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o69ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetEcnrConfigurationResponse& out) {
    {
        ::std::string DatasetNameValue;
        ::std::string &DatasetNameTmpValue = DatasetNameValue;
        {
            char* o73 = 0;
            dbus_message_iter_get_basic(in, &o73);
            DatasetNameTmpValue.assign (o73);
        }
        out.setDatasetName(DatasetNameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< uint32 > EcnrPropertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o74ArrayIter;
            dbus_message_iter_recurse (in, &o74ArrayIter);

            if(dbus_message_iter_get_arg_type(&o74ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint32 o75;
                    dbus_message_iter_get_basic(&o74ArrayIter, &o75);
                    EcnrPropertiesValue.push_back(o75);
                } while (dbus_message_iter_next(&o74ArrayIter));
            }
        }
        out.setEcnrProperties(EcnrPropertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrStartAudioRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrStartAudioRequest& in, DBusMessageIter* out) {
    uint8 o76 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o76));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrStartAudioRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrStartAudioExtRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrStartAudioExtRequest& in, DBusMessageIter* out) {
    uint8 o77 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o77));
    uint8 o78 = in.getStartMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o78));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrStartAudioExtRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 StartModeValue;
        uint8 &StartModeTmpValue = StartModeValue;
        dbus_message_iter_get_basic(in, &StartModeTmpValue);
        out.setStartMode(StartModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrStopAudioRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrStopAudioRequest& in, DBusMessageIter* out) {
    uint8 o79 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o79));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrStopAudioRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrFrameInfoResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrFrameInfoResponse& in, DBusMessageIter* out) {
    uint32 o80 = in.getFrameCounter();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o80));
    int32 o81 = in.getVoicePresent();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o81));
    int32 o82 = in.getAboveBackgroundNoise();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o82));
    int32 o83 = in.getPercentClipping();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o83));
    int32 o84 = in.getInstantaneousSNR();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o84));
    int32 o85 = in.getSmoothVNR();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o85));
    int32 o86 = in.getValidOutputCountdown();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o86));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrFrameInfoResponse& out) {
    {
        uint32 FrameCounterValue;
        uint32 &FrameCounterTmpValue = FrameCounterValue;
        dbus_message_iter_get_basic(in, &FrameCounterTmpValue);
        out.setFrameCounter(FrameCounterValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 VoicePresentValue;
        int32 &VoicePresentTmpValue = VoicePresentValue;
        dbus_message_iter_get_basic(in, &VoicePresentTmpValue);
        out.setVoicePresent(VoicePresentValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 AboveBackgroundNoiseValue;
        int32 &AboveBackgroundNoiseTmpValue = AboveBackgroundNoiseValue;
        dbus_message_iter_get_basic(in, &AboveBackgroundNoiseTmpValue);
        out.setAboveBackgroundNoise(AboveBackgroundNoiseValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 PercentClippingValue;
        int32 &PercentClippingTmpValue = PercentClippingValue;
        dbus_message_iter_get_basic(in, &PercentClippingTmpValue);
        out.setPercentClipping(PercentClippingValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 InstantaneousSNRValue;
        int32 &InstantaneousSNRTmpValue = InstantaneousSNRValue;
        dbus_message_iter_get_basic(in, &InstantaneousSNRTmpValue);
        out.setInstantaneousSNR(InstantaneousSNRValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 SmoothVNRValue;
        int32 &SmoothVNRTmpValue = SmoothVNRValue;
        dbus_message_iter_get_basic(in, &SmoothVNRTmpValue);
        out.setSmoothVNR(SmoothVNRValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 ValidOutputCountdownValue;
        int32 &ValidOutputCountdownTmpValue = ValidOutputCountdownValue;
        dbus_message_iter_get_basic(in, &ValidOutputCountdownTmpValue);
        out.setValidOutputCountdown(ValidOutputCountdownValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicClipStatsRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicClipStatsRequest& in, DBusMessageIter* out) {
    int32 o87 = in.getChannel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o87));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrMicClipStatsRequest& out) {
    {
        int32 ChannelValue;
        int32 &ChannelTmpValue = ChannelValue;
        dbus_message_iter_get_basic(in, &ChannelTmpValue);
        out.setChannel(ChannelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicClipStatsResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicClipStatsResponse& in, DBusMessageIter* out) {
    uint32 o88 = in.getClipFrames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o88));
    uint32 o89 = in.getClipCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o89));
    int32 o90 = in.getMaxAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o90));
    int32 o91 = in.getMinAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o91));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrMicClipStatsResponse& out) {
    {
        uint32 ClipFramesValue;
        uint32 &ClipFramesTmpValue = ClipFramesValue;
        dbus_message_iter_get_basic(in, &ClipFramesTmpValue);
        out.setClipFrames(ClipFramesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ClipCountValue;
        uint32 &ClipCountTmpValue = ClipCountValue;
        dbus_message_iter_get_basic(in, &ClipCountTmpValue);
        out.setClipCount(ClipCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MaxAmpValue;
        int32 &MaxAmpTmpValue = MaxAmpValue;
        dbus_message_iter_get_basic(in, &MaxAmpTmpValue);
        out.setMaxAmp(MaxAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MinAmpValue;
        int32 &MinAmpTmpValue = MinAmpValue;
        dbus_message_iter_get_basic(in, &MinAmpTmpValue);
        out.setMinAmp(MinAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrRefClipStatsResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrRefClipStatsResponse& in, DBusMessageIter* out) {
    uint32 o92 = in.getClipFrames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o92));
    uint32 o93 = in.getClipCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o93));
    int32 o94 = in.getMaxAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o94));
    int32 o95 = in.getMinAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o95));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrRefClipStatsResponse& out) {
    {
        uint32 ClipFramesValue;
        uint32 &ClipFramesTmpValue = ClipFramesValue;
        dbus_message_iter_get_basic(in, &ClipFramesTmpValue);
        out.setClipFrames(ClipFramesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ClipCountValue;
        uint32 &ClipCountTmpValue = ClipCountValue;
        dbus_message_iter_get_basic(in, &ClipCountTmpValue);
        out.setClipCount(ClipCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MaxAmpValue;
        int32 &MaxAmpTmpValue = MaxAmpValue;
        dbus_message_iter_get_basic(in, &MaxAmpTmpValue);
        out.setMaxAmp(MaxAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MinAmpValue;
        int32 &MinAmpTmpValue = MinAmpValue;
        dbus_message_iter_get_basic(in, &MinAmpTmpValue);
        out.setMinAmp(MinAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrRecvClipStatsResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrRecvClipStatsResponse& in, DBusMessageIter* out) {
    uint32 o96 = in.getClipFrames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o96));
    uint32 o97 = in.getClipCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o97));
    int32 o98 = in.getMaxAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o98));
    int32 o99 = in.getMinAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o99));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrRecvClipStatsResponse& out) {
    {
        uint32 ClipFramesValue;
        uint32 &ClipFramesTmpValue = ClipFramesValue;
        dbus_message_iter_get_basic(in, &ClipFramesTmpValue);
        out.setClipFrames(ClipFramesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ClipCountValue;
        uint32 &ClipCountTmpValue = ClipCountValue;
        dbus_message_iter_get_basic(in, &ClipCountTmpValue);
        out.setClipCount(ClipCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MaxAmpValue;
        int32 &MaxAmpTmpValue = MaxAmpValue;
        dbus_message_iter_get_basic(in, &MaxAmpTmpValue);
        out.setMaxAmp(MaxAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MinAmpValue;
        int32 &MinAmpTmpValue = MinAmpValue;
        dbus_message_iter_get_basic(in, &MinAmpTmpValue);
        out.setMinAmp(MinAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicOutClipStatsResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicOutClipStatsResponse& in, DBusMessageIter* out) {
    uint32 o100 = in.getClipFrames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o100));
    uint32 o101 = in.getClipCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o101));
    int32 o102 = in.getMaxAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o102));
    int32 o103 = in.getMinAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o103));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrMicOutClipStatsResponse& out) {
    {
        uint32 ClipFramesValue;
        uint32 &ClipFramesTmpValue = ClipFramesValue;
        dbus_message_iter_get_basic(in, &ClipFramesTmpValue);
        out.setClipFrames(ClipFramesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ClipCountValue;
        uint32 &ClipCountTmpValue = ClipCountValue;
        dbus_message_iter_get_basic(in, &ClipCountTmpValue);
        out.setClipCount(ClipCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MaxAmpValue;
        int32 &MaxAmpTmpValue = MaxAmpValue;
        dbus_message_iter_get_basic(in, &MaxAmpTmpValue);
        out.setMaxAmp(MaxAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MinAmpValue;
        int32 &MinAmpTmpValue = MinAmpValue;
        dbus_message_iter_get_basic(in, &MinAmpTmpValue);
        out.setMinAmp(MinAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrRecvOutClipStatsResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrRecvOutClipStatsResponse& in, DBusMessageIter* out) {
    uint32 o104 = in.getClipFrames();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o104));
    uint32 o105 = in.getClipCount();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o105));
    int32 o106 = in.getMaxAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o106));
    int32 o107 = in.getMinAmp();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o107));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrRecvOutClipStatsResponse& out) {
    {
        uint32 ClipFramesValue;
        uint32 &ClipFramesTmpValue = ClipFramesValue;
        dbus_message_iter_get_basic(in, &ClipFramesTmpValue);
        out.setClipFrames(ClipFramesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 ClipCountValue;
        uint32 &ClipCountTmpValue = ClipCountValue;
        dbus_message_iter_get_basic(in, &ClipCountTmpValue);
        out.setClipCount(ClipCountValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MaxAmpValue;
        int32 &MaxAmpTmpValue = MaxAmpValue;
        dbus_message_iter_get_basic(in, &MaxAmpTmpValue);
        out.setMaxAmp(MaxAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 MinAmpValue;
        int32 &MinAmpTmpValue = MinAmpValue;
        dbus_message_iter_get_basic(in, &MinAmpTmpValue);
        out.setMinAmp(MinAmpValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetSendMuteSwitchRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchRequest& in, DBusMessageIter* out) {
    uint8 o108 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o108));
    uint8 o109 = in.getEcnrSendMuteSwitch();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o109));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetSendMuteSwitchRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 ecnrSendMuteSwitchValue;
        uint8 &ecnrSendMuteSwitchTmpValue = ecnrSendMuteSwitchValue;
        dbus_message_iter_get_basic(in, &ecnrSendMuteSwitchTmpValue);
        out.setEcnrSendMuteSwitch(ecnrSendMuteSwitchValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetSendGainDeltaRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetSendGainDeltaRequest& in, DBusMessageIter* out) {
    uint8 o110 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o110));
    int16 o111 = in.getEcnrLevel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o111));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetSendGainDeltaRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 ecnrLevelValue;
        int16 &ecnrLevelTmpValue = ecnrLevelValue;
        dbus_message_iter_get_basic(in, &ecnrLevelTmpValue);
        out.setEcnrLevel(ecnrLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetMicGainRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetMicGainRequest& in, DBusMessageIter* out) {
    int32 o112 = in.getMicGainLevel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o112));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetMicGainRequest& out) {
    {
        int32 MicGainLevelValue;
        int32 &MicGainLevelTmpValue = MicGainLevelValue;
        dbus_message_iter_get_basic(in, &MicGainLevelTmpValue);
        out.setMicGainLevel(MicGainLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetPassThroughModeRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetPassThroughModeRequest& in, DBusMessageIter* out) {
    uint8 o113 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o113));
    uint8 o114 = in.getEcnrPassThroughMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o114));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetPassThroughModeRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 ecnrPassThroughModeValue;
        uint8 &ecnrPassThroughModeTmpValue = ecnrPassThroughModeValue;
        dbus_message_iter_get_basic(in, &ecnrPassThroughModeTmpValue);
        out.setEcnrPassThroughMode(ecnrPassThroughModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetNRCombFloorRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetNRCombFloorRequest& in, DBusMessageIter* out) {
    uint8 o115 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o115));
    int16 o116 = in.getEcnrNRCombFloor();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT16, &o116));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetNRCombFloorRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int16 ecnrNRCombFloorValue;
        int16 &ecnrNRCombFloorTmpValue = ecnrNRCombFloorValue;
        dbus_message_iter_get_basic(in, &ecnrNRCombFloorTmpValue);
        out.setEcnrNRCombFloor(ecnrNRCombFloorValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetEchoCancellationRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetEchoCancellationRequest& in, DBusMessageIter* out) {
    uint8 o117 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o117));
    uint8 o118 = in.getEcnrECState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o118));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetEchoCancellationRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 EcnrECStateValue;
        uint8 &EcnrECStateTmpValue = EcnrECStateValue;
        dbus_message_iter_get_basic(in, &EcnrECStateTmpValue);
        out.setEcnrECState(EcnrECStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrSetNoiseReductionRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrSetNoiseReductionRequest& in, DBusMessageIter* out) {
    uint8 o119 = in.getEcnrAppId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o119));
    uint8 o120 = in.getEcnrNRState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o120));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrSetNoiseReductionRequest& out) {
    {
        uint8 ecnrAppIdValue;
        uint8 &ecnrAppIdTmpValue = ecnrAppIdValue;
        dbus_message_iter_get_basic(in, &ecnrAppIdTmpValue);
        out.setEcnrAppId(ecnrAppIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 EcnrNRStateValue;
        uint8 &EcnrNRStateTmpValue = EcnrNRStateValue;
        dbus_message_iter_get_basic(in, &EcnrNRStateTmpValue);
        out.setEcnrNRState(EcnrNRStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrGetEngineParameterRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetEngineParameterRequest& in, DBusMessageIter* out) {
    uint32 o121 = in.getEcnrParameterId();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o121));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetEngineParameterRequest& out) {
    {
        uint32 ecnrParameterIdValue;
        uint32 &ecnrParameterIdTmpValue = ecnrParameterIdValue;
        dbus_message_iter_get_basic(in, &ecnrParameterIdTmpValue);
        out.setEcnrParameterId(ecnrParameterIdValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrGetEngineParameterResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrGetEngineParameterResponse& in, DBusMessageIter* out) {
    DBusMessageIter o122ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o122ArrayIter));
    const ::std::vector< uint8 >* o123 = &in.getData();
    ::std::vector< uint8 >::const_iterator o124 = o123->end();
    for (::std::vector< uint8 >::const_iterator o125 = o123->begin(); o125 != o124; ++o125) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o122ArrayIter, DBUS_TYPE_BYTE, &(*o125)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o122ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrGetEngineParameterResponse& out) {
    {
        ::std::vector< uint8 > dataValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o126ArrayIter;
            dbus_message_iter_recurse (in, &o126ArrayIter);

            if(dbus_message_iter_get_arg_type(&o126ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o127;
                    dbus_message_iter_get_basic(&o126ArrayIter, &o127);
                    dataValue.push_back(o127);
                } while (dbus_message_iter_next(&o126ArrayIter));
            }
        }
        out.setData(dataValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrStartItcTestRequest

void serializeDBus (const ::org::bosch::ecnr::service::EcnrStartItcTestRequest& in, DBusMessageIter* out) {
    int32 o128 = in.getITCValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o128));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrStartItcTestRequest& out) {
    {
        int32 ITCValueValue;
        int32 &ITCValueTmpValue = ITCValueValue;
        dbus_message_iter_get_basic(in, &ITCValueTmpValue);
        out.setITCValue(ITCValueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrStartItcTestResponse

void serializeDBus (const ::org::bosch::ecnr::service::EcnrStartItcTestResponse& in, DBusMessageIter* out) {
    int32 o129 = in.getRspITCValue();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o129));
    uint8 o130 = in.getTestResult();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_BYTE, &o130));
    int32 o131 = in.getTestErrorCode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o131));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrStartItcTestResponse& out) {
    {
        int32 rspITCValueValue;
        int32 &rspITCValueTmpValue = rspITCValueValue;
        dbus_message_iter_get_basic(in, &rspITCValueTmpValue);
        out.setRspITCValue(rspITCValueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint8 TestResultValue;
        uint8 &TestResultTmpValue = TestResultValue;
        dbus_message_iter_get_basic(in, &TestResultTmpValue);
        out.setTestResult(TestResultValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        int32 TestErrorCodeValue;
        int32 &TestErrorCodeTmpValue = TestErrorCodeValue;
        dbus_message_iter_get_basic(in, &TestErrorCodeTmpValue);
        out.setTestErrorCode(TestErrorCodeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicLvlNtfyIntervalUpdate

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicLvlNtfyIntervalUpdate& in, DBusMessageIter* out) {
    uint32 o132 = in.getEcnrMicLvlNtfyInterval();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o132));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrMicLvlNtfyIntervalUpdate& out) {
    {
        uint32 ecnrMicLvlNtfyIntervalValue;
        uint32 &ecnrMicLvlNtfyIntervalTmpValue = ecnrMicLvlNtfyIntervalValue;
        dbus_message_iter_get_basic(in, &ecnrMicLvlNtfyIntervalTmpValue);
        out.setEcnrMicLvlNtfyInterval(ecnrMicLvlNtfyIntervalValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicLvlNtfyIntervalRegister

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicLvlNtfyIntervalRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::ecnr::service::EcnrMicLvlNtfyIntervalRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EcnrAsrModeUpdate

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAsrModeUpdate& in, DBusMessageIter* out) {
    int32 o133 = in.getEcnrAsrMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o133));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrAsrModeUpdate& out) {
    {
        int32 ecnrAsrModeValue;
        int32 &ecnrAsrModeTmpValue = ecnrAsrModeValue;
        dbus_message_iter_get_basic(in, &ecnrAsrModeTmpValue);
        out.setEcnrAsrMode(ecnrAsrModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrAsrModeRegister

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAsrModeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::ecnr::service::EcnrAsrModeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EcnrAudioStateUpdate

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAudioStateUpdate& in, DBusMessageIter* out) {
    int32 o134 = in.getEcnrAudioState();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o134));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrAudioStateUpdate& out) {
    {
        int32 ecnrAudioStateValue;
        int32 &ecnrAudioStateTmpValue = ecnrAudioStateValue;
        dbus_message_iter_get_basic(in, &ecnrAudioStateTmpValue);
        out.setEcnrAudioState(ecnrAudioStateValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrAudioStateRegister

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAudioStateRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::ecnr::service::EcnrAudioStateRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EcnrAsrDataTypeUpdate

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAsrDataTypeUpdate& in, DBusMessageIter* out) {
    DBusMessageIter o135ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "y", &o135ArrayIter));
    const ::std::vector< uint8 >* o136 = &in.getEcnrAsrDataType();
    ::std::vector< uint8 >::const_iterator o137 = o136->end();
    for (::std::vector< uint8 >::const_iterator o138 = o136->begin(); o138 != o137; ++o138) {
        DBUS_ASSERT(dbus_message_iter_append_basic(&o135ArrayIter, DBUS_TYPE_BYTE, &(*o138)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o135ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrAsrDataTypeUpdate& out) {
    {
        ::std::vector< uint8 > ecnrAsrDataTypeValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o139ArrayIter;
            dbus_message_iter_recurse (in, &o139ArrayIter);

            if(dbus_message_iter_get_arg_type(&o139ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    uint8 o140;
                    dbus_message_iter_get_basic(&o139ArrayIter, &o140);
                    ecnrAsrDataTypeValue.push_back(o140);
                } while (dbus_message_iter_next(&o139ArrayIter));
            }
        }
        out.setEcnrAsrDataType(ecnrAsrDataTypeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrAsrDataTypeRegister

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAsrDataTypeRegister& /*in*/, DBusMessageIter* /*out*/) {
}

bool deserializeDBus (DBusMessageIter* /*in*/, ::org::bosch::ecnr::service::EcnrAsrDataTypeRegister& /*out*/) {
    return true;
}

// D-Bus serialize and deserialize functions of EcnrAsrModeEnableSignal

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAsrModeEnableSignal& in, DBusMessageIter* out) {
    int32 o141 = in.getStatusAsrMode();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o141));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrAsrModeEnableSignal& out) {
    {
        int32 StatusAsrModeValue;
        int32 &StatusAsrModeTmpValue = StatusAsrModeValue;
        dbus_message_iter_get_basic(in, &StatusAsrModeTmpValue);
        out.setStatusAsrMode(StatusAsrModeValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrAudioStatusSignal

void serializeDBus (const ::org::bosch::ecnr::service::EcnrAudioStatusSignal& in, DBusMessageIter* out) {
    int32 o142 = in.getAudioStatus();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_INT32, &o142));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrAudioStatusSignal& out) {
    {
        int32 AudioStatusValue;
        int32 &AudioStatusTmpValue = AudioStatusValue;
        dbus_message_iter_get_basic(in, &AudioStatusTmpValue);
        out.setAudioStatus(AudioStatusValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of EcnrMicroLevelStatusSignal

void serializeDBus (const ::org::bosch::ecnr::service::EcnrMicroLevelStatusSignal& in, DBusMessageIter* out) {
    uint32 o143 = in.getStatusMicroLevel();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o143));
}

bool deserializeDBus (DBusMessageIter* in, ::org::bosch::ecnr::service::EcnrMicroLevelStatusSignal& out) {
    {
        uint32 StatusMicroLevelValue;
        uint32 &StatusMicroLevelTmpValue = StatusMicroLevelValue;
        dbus_message_iter_get_basic(in, &StatusMicroLevelTmpValue);
        out.setStatusMicroLevel(StatusMicroLevelValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

