/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_TECHNOLOGYSTUB_H
#define NET_CONNMAN_TECHNOLOGYSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Technology.h"
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Technology {

class TechnologyStubDelegate;

class TechnologyStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TechnologyStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TechnologyStub (const std::string& portName);

    /**
     * Create an instance of the TechnologyStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TechnologyStub (const std::string& portName, const std::string& objectPath);

    virtual ~TechnologyStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // property 'Powered'

    /**
     * The method onPoweredGet() is called by ASF when a client invokes the
     * read method for the property 'Powered'. The onPoweredGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredGet(const ::boost::shared_ptr< PoweredGet >& payload);

    /**
     * Sends back the update to a previous onPoweredGet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredGetUpdate(bool powered, act_t act = 0);

    /**
     * The method onPoweredSet() is called by ASF when a client invokes the
     * write method for the property 'Powered'. The onPoweredSet() method set
     * property value to the given parameter Powered by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    virtual void onPoweredSet(const ::boost::shared_ptr< PoweredSet >& payload);

    /**
     * Sends back the update to a previous onPoweredSet().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPoweredSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPoweredSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Powered' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void setPowered(bool powered);

    /**
     * Returns the current value of the property 'Powered'.
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    bool getPowered() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPoweredUpdate().
     *
     * <b>Documentation of 'Powered'</b>:
     *
     * If the meaning of "Powered" isn't clear, then there should be a description here.
     */
    void sendPoweredUpdate();

    // property 'Connected'

    /**
     * The method onConnectedGet() is called by ASF when a client invokes the
     * read method for the property 'Connected'. The onConnectedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    virtual void onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& payload);

    /**
     * Sends back the update to a previous onConnectedGet().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onConnectedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectedGetUpdate(bool connected, act_t act = 0);

    /**
     * Set the value of the property 'Connected' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void setConnected(bool connected);

    /**
     * Returns the current value of the property 'Connected'.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    bool getConnected() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendConnectedUpdate().
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     */
    void sendConnectedUpdate();

    // property 'Name'

    /**
     * The method onNameGet() is called by ASF when a client invokes the read
     * method for the property 'Name'. The onNameGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    virtual void onNameGet(const ::boost::shared_ptr< NameGet >& payload);

    /**
     * Sends back the update to a previous onNameGet().
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onNameGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNameGetUpdate(const ::std::string& name, act_t act = 0);

    /**
     * Set the value of the property 'Name' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    void setName(const ::std::string& name);

    /**
     * Returns the current value of the property 'Name'.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    const ::std::string& getName() const;

    /**
     * Returns the current value of the property 'Name' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNameUpdate() method.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    ::std::string& getNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNameUpdate().
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    void sendNameUpdate();

    // property 'Type'

    /**
     * The method onTypeGet() is called by ASF when a client invokes the read
     * method for the property 'Type'. The onTypeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    virtual void onTypeGet(const ::boost::shared_ptr< TypeGet >& payload);

    /**
     * Sends back the update to a previous onTypeGet().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTypeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTypeGetUpdate(const ::std::string& type, act_t act = 0);

    /**
     * Set the value of the property 'Type' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void setType(const ::std::string& type);

    /**
     * Returns the current value of the property 'Type'.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    const ::std::string& getType() const;

    /**
     * Returns the current value of the property 'Type' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTypeUpdate() method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    ::std::string& getTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTypeUpdate().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void sendTypeUpdate();

    // property 'Tethering'

    /**
     * The method onTetheringGet() is called by ASF when a client invokes the
     * read method for the property 'Tethering'. The onTetheringGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    virtual void onTetheringGet(const ::boost::shared_ptr< TetheringGet >& payload);

    /**
     * Sends back the update to a previous onTetheringGet().
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTetheringGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTetheringGetUpdate(bool tethering, act_t act = 0);

    /**
     * The method onTetheringSet() is called by ASF when a client invokes the
     * write method for the property 'Tethering'. The onTetheringSet() method
     * set property value to the given parameter Tethering by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    virtual void onTetheringSet(const ::boost::shared_ptr< TetheringSet >& payload);

    /**
     * Sends back the update to a previous onTetheringSet().
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTetheringSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTetheringSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Tethering' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    void setTethering(bool tethering);

    /**
     * Returns the current value of the property 'Tethering'.
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    bool getTethering() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTetheringUpdate().
     *
     * <b>Documentation of 'Tethering'</b>:
     *
     * If the meaning of "Tethering" isn't clear, then there should be a description here.
     */
    void sendTetheringUpdate();

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperty'

    /**
     * The method onSetProperty() is called by ASF when a client invokes the
     * method 'SetProperty'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetProperty() or
     * sendSetPropertyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertyRequest (const ::boost::shared_ptr< SetPropertyRequest >& request) = 0;

    /**
     * The method sendSetPropertyResponse() sends a response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertyResponse (act_t act = 0);

    /**
     * The method sendSetPropertyError() sends an error response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperty(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Scan'

    /**
     * The method onScan() is called by ASF when a client invokes the method
     * 'Scan'. A subclass has to implement this method and send back a
     * response to the client either with the sendScan() or sendScanError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onScanRequest (const ::boost::shared_ptr< ScanRequest >& request) = 0;

    /**
     * The method sendScanResponse() sends a response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onScan(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendScanResponse (act_t act = 0);

    /**
     * The method sendScanError() sends an error response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onScan(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    PoweredUpdate _PoweredProperty;

    ConnectedUpdate _ConnectedProperty;

    NameUpdate _NameProperty;

    TypeUpdate _TypeProperty;

    TetheringUpdate _TetheringProperty;

    friend class TechnologyStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Technology
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_TECHNOLOGYSTUB_H
