/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Technology.h"
#include "net/connman/TechnologyDBus.h"
#include "net/connman/TechnologyJson.h"
#include "net/connman/TechnologyStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Technology {

DEFINE_CLASS_LOGGER("//net/connman/technology/technologyXYZ/net/connman/Technology", TechnologyStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Scan", 2 },
    { 11, "SetProperty", 1 },
    { 13, "GetProperties", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Name", 2 },
    { 4, "Type", 3 },
    { 7, "Powered", 0 },
    { 9, "Connected", 1 },
    { 9, "Tethering", 4 },
};

class TechnologyStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TechnologyStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Technology"),
          _logger(logger) {}

    virtual ~TechnologyStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TechnologyStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'SetProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertyRequest > payload = ::boost::static_pointer_cast<SetPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onSetPropertyRequest(payload);
            return;
        }
        case 2: {

            // method 'Scan'

            LOG_DEBUG_STUB("process method '%s'", "Scan");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScanRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Scan", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ScanRequest > payload = ::boost::static_pointer_cast<ScanRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TechnologyStub*>(getStub())->onScanRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TechnologyStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Technology\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "        <annotation name=\"org.freedesktop.DBus.Deprecated\" value=\"true\"/>\n"
            "      </method>\n"
            "      <method name=\"SetProperty\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"Scan\"/>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "      <property access=\"readwrite\" name=\"Powered\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Connected\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Name\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Type\" type=\"s\"/>\n"
            "      <property access=\"readwrite\" name=\"Tethering\" type=\"b\"/>\n"
            "</interface>\n";
}

void TechnologyStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TechnologyStub*>(getStub()))->onGetAll (properties);
}

void TechnologyStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredSet > payload(new PoweredSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<TechnologyStub*>(getStub())->onPoweredSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Name");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Tethering");
            ::boost::shared_ptr< TetheringSet > payload(new TetheringSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<TechnologyStub*>(getStub())->onTetheringSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TechnologyStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 5, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Powered");
            ::boost::shared_ptr< PoweredGet > payload(new PoweredGet());
            payload->setAct(act);
            static_cast<TechnologyStub*>(getStub())->onPoweredGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            ::boost::shared_ptr< ConnectedGet > payload(new ConnectedGet());
            payload->setAct(act);
            static_cast<TechnologyStub*>(getStub())->onConnectedGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Name");
            ::boost::shared_ptr< NameGet > payload(new NameGet());
            payload->setAct(act);
            static_cast<TechnologyStub*>(getStub())->onNameGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            ::boost::shared_ptr< TypeGet > payload(new TypeGet());
            payload->setAct(act);
            static_cast<TechnologyStub*>(getStub())->onTypeGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Tethering");
            ::boost::shared_ptr< TetheringGet > payload(new TetheringGet());
            payload->setAct(act);
            static_cast<TechnologyStub*>(getStub())->onTetheringGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TechnologyStub::TechnologyStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TechnologyStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TechnologyStub::TechnologyStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TechnologyStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TechnologyStub::~TechnologyStub() {
    delete _stubDelegate;
}

void TechnologyStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void TechnologyStub::sendPoweredUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PoweredUpdate payload(_PoweredProperty);

        LOG_INFO ("-> send%s", "PoweredUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Powered", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("net.connman.Technology", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PoweredUpdate");
    }
}

void TechnologyStub::onPoweredGet(const ::boost::shared_ptr< PoweredGet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredGet", powered->getAct());
    sendPoweredGetUpdate(_PoweredProperty.getPowered(), powered->getAct());
}

void TechnologyStub::sendPoweredGetUpdate(bool powered, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PoweredGet payload(powered);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TechnologyStub::onPoweredSet(const ::boost::shared_ptr< PoweredSet >& powered) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PoweredSet", powered->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*powered, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setPowered (powered->getPowered());
    sendPoweredSetUpdate(powered->getAct());
}

void TechnologyStub::sendPoweredSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PoweredSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void TechnologyStub::setPowered(bool powered) {
    if(powered!=_PoweredProperty.getPowered()) {
        _PoweredProperty.setPowered(powered);
        sendPoweredUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool TechnologyStub::getPowered() const {
    return _PoweredProperty.getPowered();
}

void TechnologyStub::sendConnectedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectedUpdate payload(_ConnectedProperty);

        LOG_INFO ("-> send%s", "ConnectedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Connected", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("net.connman.Technology", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectedUpdate");
    }
}

void TechnologyStub::onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& connected) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectedGet", connected->getAct());
    sendConnectedGetUpdate(_ConnectedProperty.getConnected(), connected->getAct());
}

void TechnologyStub::sendConnectedGetUpdate(bool connected, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectedGet payload(connected);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TechnologyStub::setConnected(bool connected) {
    if(connected!=_ConnectedProperty.getConnected()) {
        _ConnectedProperty.setConnected(connected);
        sendConnectedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool TechnologyStub::getConnected() const {
    return _ConnectedProperty.getConnected();
}

void TechnologyStub::sendNameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NameUpdate payload(_NameProperty);

        LOG_INFO ("-> send%s", "NameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Name", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("net.connman.Technology", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NameUpdate");
    }
}

void TechnologyStub::onNameGet(const ::boost::shared_ptr< NameGet >& name) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NameGet", name->getAct());
    sendNameGetUpdate(_NameProperty.getName(), name->getAct());
}

void TechnologyStub::sendNameGetUpdate(const ::std::string& name, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NameGet payload(name);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TechnologyStub::setName(const ::std::string& name) {
    if(name!=_NameProperty.getName()) {
        _NameProperty.setName(name);
        sendNameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TechnologyStub::getName() const {
    return _NameProperty.getName();
}

::std::string& TechnologyStub::getNameMutable() {
    return _NameProperty.getNameMutable();
}

void TechnologyStub::sendTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TypeUpdate payload(_TypeProperty);

        LOG_INFO ("-> send%s", "TypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Type", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("net.connman.Technology", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TypeUpdate");
    }
}

void TechnologyStub::onTypeGet(const ::boost::shared_ptr< TypeGet >& type) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TypeGet", type->getAct());
    sendTypeGetUpdate(_TypeProperty.getType(), type->getAct());
}

void TechnologyStub::sendTypeGetUpdate(const ::std::string& type, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TypeGet payload(type);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TechnologyStub::setType(const ::std::string& type) {
    if(type!=_TypeProperty.getType()) {
        _TypeProperty.setType(type);
        sendTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& TechnologyStub::getType() const {
    return _TypeProperty.getType();
}

::std::string& TechnologyStub::getTypeMutable() {
    return _TypeProperty.getTypeMutable();
}

void TechnologyStub::sendTetheringUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TetheringUpdate payload(_TetheringProperty);

        LOG_INFO ("-> send%s", "TetheringUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Tethering", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("net.connman.Technology", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TetheringUpdate");
    }
}

void TechnologyStub::onTetheringGet(const ::boost::shared_ptr< TetheringGet >& tethering) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TetheringGet", tethering->getAct());
    sendTetheringGetUpdate(_TetheringProperty.getTethering(), tethering->getAct());
}

void TechnologyStub::sendTetheringGetUpdate(bool tethering, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TetheringGet payload(tethering);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TetheringGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void TechnologyStub::onTetheringSet(const ::boost::shared_ptr< TetheringSet >& tethering) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TetheringSet", tethering->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*tethering, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTethering (tethering->getTethering());
    sendTetheringSetUpdate(tethering->getAct());
}

void TechnologyStub::sendTetheringSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TetheringSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void TechnologyStub::setTethering(bool tethering) {
    if(tethering!=_TetheringProperty.getTethering()) {
        _TetheringProperty.setTethering(tethering);
        sendTetheringUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool TechnologyStub::getTethering() const {
    return _TetheringProperty.getTethering();
}

void  TechnologyStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendSetPropertyResponse (act_t act) {
    SetPropertyResponse* payload = new SetPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperty", SetPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertyError* payload = new SetPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperty", SetPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendScanResponse (act_t act) {
    ScanResponse* payload = new ScanResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Scan", ScanResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TechnologyStub::sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ScanError* payload = new ScanError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Scan", ScanError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Scan", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void TechnologyStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Powered'
    {
        ::asf::dbus::DBusVariant variant;
        PoweredGet payload(_PoweredProperty.getPowered());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Powered", variant));
    }

    //property 'Connected'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectedGet payload(_ConnectedProperty.getConnected());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Connected", variant));
    }

    //property 'Name'
    {
        ::asf::dbus::DBusVariant variant;
        NameGet payload(_NameProperty.getName());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Name", variant));
    }

    //property 'Type'
    {
        ::asf::dbus::DBusVariant variant;
        TypeGet payload(_TypeProperty.getType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Type", variant));
    }

    //property 'Tethering'
    {
        ::asf::dbus::DBusVariant variant;
        TetheringGet payload(_TetheringProperty.getTethering());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Tethering", variant));
    }
}

} // namespace Technology
} // namespace connman
} // namespace net
