#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_SESSION_H
#define NET_CONNMAN_SESSION_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Session" isn't clear, then there should be a description here.
 */

namespace net {
namespace connman {
namespace Session {

// method IDs
static const uint16 ID_Destroy = 0;
static const uint16 ID_Connect = 1;
static const uint16 ID_Disconnect = 2;
static const uint16 ID_Change = 3;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ChangeRequest;

// type definitions
/**
 * If the meaning of "DestroyRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DestroyRequest;

/**
 * If the meaning of "DestroyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DestroyResponse;

/**
 * If the meaning of "DestroyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestroyError;

/**
 * If the meaning of "ConnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectRequest;

/**
 * If the meaning of "ConnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectResponse;

/**
 * If the meaning of "ConnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectError;

/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectRequest;

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectResponse;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "ChangeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ChangeResponse;

/**
 * If the meaning of "ChangeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChangeError;


/**
 * If the meaning of "ChangeRequest" isn't clear, then there should be a description here.
 */
class ChangeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChangeRequest ();

    /**
     * Copy constructor
     */
    inline  ChangeRequest (const ChangeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  ChangeRequest (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~ChangeRequest();

    /**
     * Assignment operator
     */
    inline ChangeRequest& operator = (const ChangeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChangeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChangeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChangeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChangeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const ChangeRequest &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

inline  ChangeRequest::ChangeRequest ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ChangeRequest::ChangeRequest (const ChangeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ChangeRequest::ChangeRequest (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ChangeRequest::~ChangeRequest() {
}

inline ChangeRequest& ChangeRequest::operator = (const ChangeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool ChangeRequest::operator == (const ChangeRequest& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool ChangeRequest::operator != (const ChangeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool ChangeRequest::operator < (const ChangeRequest& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ChangeRequest::clone() {
    return new ChangeRequest(*this);
}

inline bool ChangeRequest::operator > (const ChangeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ChangeRequest::clear() {
    clearName();
    clearValue();
}

inline void ChangeRequest::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool ChangeRequest::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& ChangeRequest::getName () const {
    return _name;
}

inline ::std::string& ChangeRequest::getNameMutable () {
    set_has_name();
    return _name;
}

inline void ChangeRequest::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void ChangeRequest::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void ChangeRequest::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void ChangeRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool ChangeRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& ChangeRequest::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& ChangeRequest::getValueMutable () {
    set_has_value();
    return _value;
}

inline void ChangeRequest::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void ChangeRequest::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void ChangeRequest::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ChangeRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void ChangeRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace Session
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_SESSION_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
