/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_SERVICEPROXY_H
#define NET_CONNMAN_SERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Service.h"
#include <dbus/dbus.h>
#include <string>

namespace net {
namespace connman {
namespace Service {

class ServiceProxy;

class ClearPropertyCallbackIF {
public:
    virtual ~ClearPropertyCallbackIF() {}

    virtual void onClearPropertyError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ClearPropertyError >& error) = 0;

    virtual void onClearPropertyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ClearPropertyResponse >& response) = 0;
};

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class MoveAfterCallbackIF {
public:
    virtual ~MoveAfterCallbackIF() {}

    virtual void onMoveAfterError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< MoveAfterError >& error) = 0;

    virtual void onMoveAfterResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< MoveAfterResponse >& response) = 0;
};

class MoveBeforeCallbackIF {
public:
    virtual ~MoveBeforeCallbackIF() {}

    virtual void onMoveBeforeError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< MoveBeforeError >& error) = 0;

    virtual void onMoveBeforeResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< MoveBeforeResponse >& response) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};

class RemoveCallbackIF {
public:
    virtual ~RemoveCallbackIF() {}

    virtual void onRemoveError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoveError >& error) = 0;

    virtual void onRemoveResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoveResponse >& response) = 0;
};

class ResetCountersCallbackIF {
public:
    virtual ~ResetCountersCallbackIF() {}

    virtual void onResetCountersError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ResetCountersError >& error) = 0;

    virtual void onResetCountersResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ResetCountersResponse >& response) = 0;
};

class SetPropertyCallbackIF {
public:
    virtual ~SetPropertyCallbackIF() {}

    virtual void onSetPropertyError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

    virtual void onSetPropertyResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;
};


/**
 * ServiceProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Service' (specified in file
 * connman_service.xml).
 *
 * If the meaning of "net.connman.Service" isn't clear, then there should be a description here.
 */
class ServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ServiceProxy.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ServiceProxy ();


    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;



    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'SetProperty'

    /**
     * Call the method 'SetProperty'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const;

    // Method 'ClearProperty'

    /**
     * Call the method 'ClearProperty'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ClearProperty'</b>:
     *
     * If the meaning of "ClearProperty" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendClearPropertyRequest(ClearPropertyCallbackIF& cb, const ::std::string& name) const;

    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectRequest(ConnectCallbackIF& cb) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    // Method 'Remove'

    /**
     * Call the method 'Remove'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Remove'</b>:
     *
     * If the meaning of "Remove" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveRequest(RemoveCallbackIF& cb) const;

    // Method 'MoveBefore'

    /**
     * Call the method 'MoveBefore'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'MoveBefore'</b>:
     *
     * If the meaning of "MoveBefore" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param service If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMoveBeforeRequest(MoveBeforeCallbackIF& cb, const ::std::string& service) const;

    // Method 'MoveAfter'

    /**
     * Call the method 'MoveAfter'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'MoveAfter'</b>:
     *
     * If the meaning of "MoveAfter" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param service If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendMoveAfterRequest(MoveAfterCallbackIF& cb, const ::std::string& service) const;

    // Method 'ResetCounters'

    /**
     * Call the method 'ResetCounters'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ResetCounters'</b>:
     *
     * If the meaning of "ResetCounters" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendResetCountersRequest(ResetCountersCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ServiceProxyCallback;
};

} // namespace Service
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_SERVICEPROXY_H
