/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_NOTIFICATIONSTUB_H
#define NET_CONNMAN_NOTIFICATIONSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Notification.h"

namespace net {
namespace connman {
namespace Notification {

class NotificationStubDelegate;

class NotificationStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the NotificationStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    NotificationStub (const std::string& portName);

    /**
     * Create an instance of the NotificationStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    NotificationStub (const std::string& portName, const std::string& objectPath);

    virtual ~NotificationStub();

    // method 'Release'

    /**
     * The method onRelease() is called by ASF when a client invokes the
     * method 'Release'. A subclass has to implement this method and send back
     * a response to the client either with the sendRelease() or
     * sendReleaseError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseRequest (const ::boost::shared_ptr< ReleaseRequest >& request) = 0;

    /**
     * The method sendReleaseResponse() sends a response of a previous method
     * invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRelease(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReleaseResponse (act_t act = 0);

    /**
     * The method sendReleaseError() sends an error response of a previous
     * method invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRelease(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Update'

    /**
     * The method onUpdate() is called by ASF when a client invokes the method
     * 'Update'. A subclass has to implement this method and send back a
     * response to the client either with the sendUpdate() or
     * sendUpdateError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Update'</b>:
     *
     * If the meaning of "Update" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUpdateRequest (const ::boost::shared_ptr< UpdateRequest >& request) = 0;

    /**
     * The method sendUpdateResponse() sends a response of a previous method
     * invocation of 'Update' back to the client.
     *
     * <b>Documentation of 'Update'</b>:
     *
     * If the meaning of "Update" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUpdate(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUpdateResponse (act_t act = 0);

    /**
     * The method sendUpdateError() sends an error response of a previous
     * method invocation of 'Update' back to the client.
     *
     * <b>Documentation of 'Update'</b>:
     *
     * If the meaning of "Update" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUpdate(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendUpdateError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class NotificationStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Notification
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_NOTIFICATIONSTUB_H
