/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Manager.h"
#include "net/connman/ManagerDBus.h"
#include "net/connman/ManagerJson.h"
#include "net/connman/ManagerStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Manager {

DEFINE_CLASS_LOGGER("///net/connman/Manager", ManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 11, "GetServices", 4 },
    { 11, "SetProperty", 1 },
    { 13, "CreateSession", 10 },
    { 13, "GetProperties", 0 },
    { 13, "RegisterAgent", 6 },
    { 14, "DestroySession", 11 },
    { 14, "RemoveProvider", 3 },
    { 15, "ConnectProvider", 5 },
    { 15, "GetTechnologies", 2 },
    { 15, "RegisterCounter", 8 },
    { 15, "UnregisterAgent", 7 },
    { 17, "UnregisterCounter", 9 },
    { 21, "ReleasePrivateNetwork", 13 },
    { 21, "RequestPrivateNetwork", 12 },
};


class ManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Manager"),
          _logger(logger) {}

    virtual ~ManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 14, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'SetProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertyRequest > payload = ::boost::static_pointer_cast<SetPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onSetPropertyRequest(payload);
            return;
        }
        case 2: {

            // method 'GetTechnologies'

            LOG_DEBUG_STUB("process method '%s'", "GetTechnologies");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetTechnologiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetTechnologies", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetTechnologiesRequest > payload = ::boost::static_pointer_cast<GetTechnologiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetTechnologiesRequest(payload);
            return;
        }
        case 3: {

            // method 'RemoveProvider'

            LOG_DEBUG_STUB("process method '%s'", "RemoveProvider");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveProviderRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveProvider", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveProviderRequest > payload = ::boost::static_pointer_cast<RemoveProviderRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRemoveProviderRequest(payload);
            return;
        }
        case 4: {

            // method 'GetServices'

            LOG_DEBUG_STUB("process method '%s'", "GetServices");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetServicesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetServices", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetServicesRequest > payload = ::boost::static_pointer_cast<GetServicesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onGetServicesRequest(payload);
            return;
        }
        case 5: {

            // method 'ConnectProvider'

            LOG_DEBUG_STUB("process method '%s'", "ConnectProvider");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectProviderRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ConnectProvider", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectProviderRequest > payload = ::boost::static_pointer_cast<ConnectProviderRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onConnectProviderRequest(payload);
            return;
        }
        case 6: {

            // method 'RegisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "RegisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterAgentRequest > payload = ::boost::static_pointer_cast<RegisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRegisterAgentRequest(payload);
            return;
        }
        case 7: {

            // method 'UnregisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterAgentRequest > payload = ::boost::static_pointer_cast<UnregisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnregisterAgentRequest(payload);
            return;
        }
        case 8: {

            // method 'RegisterCounter'

            LOG_DEBUG_STUB("process method '%s'", "RegisterCounter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterCounterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterCounter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterCounterRequest > payload = ::boost::static_pointer_cast<RegisterCounterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRegisterCounterRequest(payload);
            return;
        }
        case 9: {

            // method 'UnregisterCounter'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterCounter");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterCounterRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterCounter", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterCounterRequest > payload = ::boost::static_pointer_cast<UnregisterCounterRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onUnregisterCounterRequest(payload);
            return;
        }
        case 10: {

            // method 'CreateSession'

            LOG_DEBUG_STUB("process method '%s'", "CreateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateSessionRequest > payload = ::boost::static_pointer_cast<CreateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onCreateSessionRequest(payload);
            return;
        }
        case 11: {

            // method 'DestroySession'

            LOG_DEBUG_STUB("process method '%s'", "DestroySession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestroySessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DestroySession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DestroySessionRequest > payload = ::boost::static_pointer_cast<DestroySessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onDestroySessionRequest(payload);
            return;
        }
        case 12: {

            // method 'RequestPrivateNetwork'

            LOG_DEBUG_STUB("process method '%s'", "RequestPrivateNetwork");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPrivateNetworkRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestPrivateNetwork", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestPrivateNetworkRequest > payload = ::boost::static_pointer_cast<RequestPrivateNetworkRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onRequestPrivateNetworkRequest(payload);
            return;
        }
        case 13: {

            // method 'ReleasePrivateNetwork'

            LOG_DEBUG_STUB("process method '%s'", "ReleasePrivateNetwork");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleasePrivateNetworkRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReleasePrivateNetwork", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleasePrivateNetworkRequest > payload = ::boost::static_pointer_cast<ReleasePrivateNetworkRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ManagerStub*>(getStub())->onReleasePrivateNetworkRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ManagerStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Manager\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"SetProperty\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"GetTechnologies\">\n"
            "        <arg direction=\"out\" name=\"technologies\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <method name=\"RemoveProvider\">\n"
            "        <arg direction=\"in\" name=\"provider\" type=\"o\"/>\n"
            "        <annotation name=\"org.freedesktop.DBus.Deprecated\" value=\"true\"/>\n"
            "      </method>\n"
            "      <method name=\"GetServices\">\n"
            "        <arg direction=\"out\" name=\"services\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <method name=\"ConnectProvider\">\n"
            "        <arg direction=\"in\" name=\"provider\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "        <annotation name=\"org.freedesktop.DBus.Deprecated\" value=\"true\"/>\n"
            "      </method>\n"
            "      <method name=\"RegisterAgent\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"UnregisterAgent\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RegisterCounter\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"accuracy\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"period\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"UnregisterCounter\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"CreateSession\">\n"
            "        <arg direction=\"in\" name=\"settings\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"in\" name=\"notifier\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"DestroySession\">\n"
            "        <arg direction=\"in\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestPrivateNetwork\">\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"settings\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"socket\" type=\"h\"/>\n"
            "      </method>\n"
            "      <method name=\"ReleasePrivateNetwork\">\n"
            "        <arg direction=\"in\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "      <signal name=\"TechnologyAdded\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "        <arg name=\"properties\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"TechnologyRemoved\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ServicesChanged\">\n"
            "        <arg name=\"changed\" type=\"a(oa{sv})\"/>\n"
            "        <arg name=\"removed\" type=\"ao\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ManagerStub*>(getStub()))->onGetAll (properties);
}

void ManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ManagerStub::ManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::ManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ManagerStub::~ManagerStub() {
    delete _stubDelegate;
}

void ManagerStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void ManagerStub::sendTechnologyAddedSignal(const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    if (_stubDelegate->isConnected()) {
        TechnologyAddedSignal* payload = new TechnologyAddedSignal(path, properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "TechnologyAdded", TechnologyAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "TechnologyAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "TechnologyAdded");
    }
}

void ManagerStub::sendTechnologyRemovedSignal(const ::std::string& path) {
    if (_stubDelegate->isConnected()) {
        TechnologyRemovedSignal* payload = new TechnologyRemovedSignal(path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "TechnologyRemoved", TechnologyRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "TechnologyRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "TechnologyRemoved");
    }
}

void ManagerStub::sendServicesChangedSignal(const ::std::vector< ServicesChangedSignalChangedStruct >& changed, const ::std::vector< ::std::string >& removed) {
    if (_stubDelegate->isConnected()) {
        ServicesChangedSignal* payload = new ServicesChangedSignal(changed, removed);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ServicesChanged", ServicesChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "ServicesChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ServicesChanged");
    }
}

void  ManagerStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetPropertyResponse (act_t act) {
    SetPropertyResponse* payload = new SetPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperty", SetPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertyError* payload = new SetPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperty", SetPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetTechnologiesResponse (const ::std::vector< GetTechnologiesResponseTechnologiesStruct >& technologies, act_t act) {
    GetTechnologiesResponse* payload = new GetTechnologiesResponse(technologies);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetTechnologies", GetTechnologiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetTechnologies", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetTechnologiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetTechnologiesError* payload = new GetTechnologiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetTechnologies", GetTechnologiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetTechnologies", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRemoveProviderResponse (act_t act) {
    RemoveProviderResponse* payload = new RemoveProviderResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoveProvider", RemoveProviderResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveProvider", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRemoveProviderError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveProviderError* payload = new RemoveProviderError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoveProvider", RemoveProviderError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveProvider", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetServicesResponse (const ::std::vector< GetServicesResponseServicesStruct >& services, act_t act) {
    GetServicesResponse* payload = new GetServicesResponse(services);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetServices", GetServicesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetServices", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendGetServicesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetServicesError* payload = new GetServicesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetServices", GetServicesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetServices", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendConnectProviderResponse (const ::std::string& path, act_t act) {
    ConnectProviderResponse* payload = new ConnectProviderResponse(path);
    DBUS_MESSAGE_REPLY(dbusMessage, "ConnectProvider", ConnectProviderResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ConnectProvider", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendConnectProviderError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectProviderError* payload = new ConnectProviderError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ConnectProvider", ConnectProviderError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ConnectProvider", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterAgentResponse (act_t act) {
    RegisterAgentResponse* payload = new RegisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterAgent", RegisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterAgentError* payload = new RegisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterAgent", RegisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterAgentResponse (act_t act) {
    UnregisterAgentResponse* payload = new UnregisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterAgent", UnregisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterAgentError* payload = new UnregisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterAgent", UnregisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterCounterResponse (act_t act) {
    RegisterCounterResponse* payload = new RegisterCounterResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterCounter", RegisterCounterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRegisterCounterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterCounterError* payload = new RegisterCounterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterCounter", RegisterCounterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterCounterResponse (act_t act) {
    UnregisterCounterResponse* payload = new UnregisterCounterResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterCounter", UnregisterCounterResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendUnregisterCounterError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterCounterError* payload = new UnregisterCounterError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterCounter", UnregisterCounterError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterCounter", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCreateSessionResponse (const ::std::string& session, act_t act) {
    CreateSessionResponse* payload = new CreateSessionResponse(session);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateSession", CreateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateSessionError* payload = new CreateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateSession", CreateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDestroySessionResponse (act_t act) {
    DestroySessionResponse* payload = new DestroySessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DestroySession", DestroySessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DestroySession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendDestroySessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DestroySessionError* payload = new DestroySessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DestroySession", DestroySessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DestroySession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRequestPrivateNetworkResponse (const ::std::string& path, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings, uint32 socket, act_t act) {
    RequestPrivateNetworkResponse* payload = new RequestPrivateNetworkResponse(path, settings, socket);
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestPrivateNetwork", RequestPrivateNetworkResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestPrivateNetwork", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendRequestPrivateNetworkError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestPrivateNetworkError* payload = new RequestPrivateNetworkError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestPrivateNetwork", RequestPrivateNetworkError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestPrivateNetwork", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReleasePrivateNetworkResponse (act_t act) {
    ReleasePrivateNetworkResponse* payload = new ReleasePrivateNetworkResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ReleasePrivateNetwork", ReleasePrivateNetworkResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReleasePrivateNetwork", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ManagerStub::sendReleasePrivateNetworkError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleasePrivateNetworkError* payload = new ReleasePrivateNetworkError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReleasePrivateNetwork", ReleasePrivateNetworkError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReleasePrivateNetwork", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Manager
} // namespace connman
} // namespace net
