/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/Types.h"
#include "asf/dbus/DBusAssert.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DBusVariantDBus.h"
#include "net/connman/Manager.h"
#include "net/connman/ManagerDBus.h"
#include <dbus/dbus.h>
#include <map>
#include <string>
#include <vector>

static ::asf::core::Logger& _logger =  ::asf::core::Logger::_systemLogger;


// D-Bus serialize and deserialize functions of GetPropertiesResponse

void serializeDBus (const ::net::connman::Manager::GetPropertiesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o0ArrayIter;
    DBusMessageIter o1DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o0ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o2 = &in.getProperties();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o3 = o2->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o4 = o2->begin(); o4 != o3; ++o4) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o0ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o1DictIter));
        const char* o5 = o4->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o1DictIter, DBUS_TYPE_STRING, &o5));
        serializeDBus(o4->second, &o1DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o0ArrayIter, &o1DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o0ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::GetPropertiesResponse& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o6ArrayIter;
            DBusMessageIter o7DictIter;
            dbus_message_iter_recurse (in, &o6ArrayIter);

            if (dbus_message_iter_get_arg_type(&o6ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o8Key;
                    ::asf::dbus::DBusVariant o8Value;
                    dbus_message_iter_recurse (&o6ArrayIter, &o7DictIter);
                    {
                        char* o9 = 0;
                        dbus_message_iter_get_basic(&o7DictIter, &o9);
                        o8Key.assign (o9);
                    }
                    dbus_message_iter_next(&o7DictIter);
                    {
                        DBusMessageIter o10;
                        char* signature = dbus_message_iter_get_signature(&o7DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o7DictIter)) {
                                dbus_message_iter_recurse (&o7DictIter, &o10);

                                if (!deserializeDBus(&o10, o8Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    propertiesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o8Key, o8Value));
                } while (dbus_message_iter_next(&o6ArrayIter));
            }
        }
        out.setProperties(propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of SetPropertyRequest

void serializeDBus (const ::net::connman::Manager::SetPropertyRequest& in, DBusMessageIter* out) {
    const char* o11 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o11));
    serializeDBus(in.getValue(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::SetPropertyRequest& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o12 = 0;
            dbus_message_iter_get_basic(in, &o12);
            nameTmpValue.assign (o12);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::asf::dbus::DBusVariant valueValue;
        {
            DBusMessageIter o13;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o13);

                    if (!deserializeDBus(&o13, valueValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTechnologiesResponse

void serializeDBus (const ::net::connman::Manager::GetTechnologiesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o14ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o14ArrayIter));
    const ::std::vector< ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct >* o15 = &in.getTechnologies();
    ::std::vector< ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct >::const_iterator o16 = o15->end();
    for (::std::vector< ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct >::const_iterator o17 = o15->begin(); o17 != o16; ++o17) {
        {
            DBusMessageIter o18Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o14ArrayIter, DBUS_TYPE_STRUCT, 0, &o18Struct));
            serializeDBus((*o17), &o18Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o14ArrayIter, &o18Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o14ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::GetTechnologiesResponse& out) {
    {
        ::std::vector< ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct > technologiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o19ArrayIter;
            dbus_message_iter_recurse (in, &o19ArrayIter);

            if(dbus_message_iter_get_arg_type(&o19ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct o20;
                    {
                        DBusMessageIter o21;
                        char* signature = dbus_message_iter_get_signature(&o19ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o19ArrayIter)) {
                                dbus_message_iter_recurse (&o19ArrayIter, &o21);

                                if (!deserializeDBus(&o21, o20)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    technologiesValue.push_back(o20);
                } while (dbus_message_iter_next(&o19ArrayIter));
            }
        }
        out.setTechnologies(technologiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RemoveProviderRequest

void serializeDBus (const ::net::connman::Manager::RemoveProviderRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getProvider())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getProvider()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::RemoveProviderRequest& out) {
    {
        ::std::string providerValue;
        ::std::string &providerTmpValue = providerValue;
        {
            char* o22 = 0;
            dbus_message_iter_get_basic(in, &o22);
            providerTmpValue.assign (o22);
        }
        out.setProvider(providerValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetServicesResponse

void serializeDBus (const ::net::connman::Manager::GetServicesResponse& in, DBusMessageIter* out) {
    DBusMessageIter o23ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o23ArrayIter));
    const ::std::vector< ::net::connman::Manager::GetServicesResponseServicesStruct >* o24 = &in.getServices();
    ::std::vector< ::net::connman::Manager::GetServicesResponseServicesStruct >::const_iterator o25 = o24->end();
    for (::std::vector< ::net::connman::Manager::GetServicesResponseServicesStruct >::const_iterator o26 = o24->begin(); o26 != o25; ++o26) {
        {
            DBusMessageIter o27Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o23ArrayIter, DBUS_TYPE_STRUCT, 0, &o27Struct));
            serializeDBus((*o26), &o27Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o23ArrayIter, &o27Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o23ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::GetServicesResponse& out) {
    {
        ::std::vector< ::net::connman::Manager::GetServicesResponseServicesStruct > servicesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o28ArrayIter;
            dbus_message_iter_recurse (in, &o28ArrayIter);

            if(dbus_message_iter_get_arg_type(&o28ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::net::connman::Manager::GetServicesResponseServicesStruct o29;
                    {
                        DBusMessageIter o30;
                        char* signature = dbus_message_iter_get_signature(&o28ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o28ArrayIter)) {
                                dbus_message_iter_recurse (&o28ArrayIter, &o30);

                                if (!deserializeDBus(&o30, o29)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    servicesValue.push_back(o29);
                } while (dbus_message_iter_next(&o28ArrayIter));
            }
        }
        out.setServices(servicesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConnectProviderRequest

void serializeDBus (const ::net::connman::Manager::ConnectProviderRequest& in, DBusMessageIter* out) {
    DBusMessageIter o31ArrayIter;
    DBusMessageIter o32DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o31ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o33 = &in.getProvider();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o34 = o33->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o35 = o33->begin(); o35 != o34; ++o35) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o31ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o32DictIter));
        const char* o36 = o35->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o32DictIter, DBUS_TYPE_STRING, &o36));
        serializeDBus(o35->second, &o32DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o31ArrayIter, &o32DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o31ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::ConnectProviderRequest& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > providerValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o37ArrayIter;
            DBusMessageIter o38DictIter;
            dbus_message_iter_recurse (in, &o37ArrayIter);

            if (dbus_message_iter_get_arg_type(&o37ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o39Key;
                    ::asf::dbus::DBusVariant o39Value;
                    dbus_message_iter_recurse (&o37ArrayIter, &o38DictIter);
                    {
                        char* o40 = 0;
                        dbus_message_iter_get_basic(&o38DictIter, &o40);
                        o39Key.assign (o40);
                    }
                    dbus_message_iter_next(&o38DictIter);
                    {
                        DBusMessageIter o41;
                        char* signature = dbus_message_iter_get_signature(&o38DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o38DictIter)) {
                                dbus_message_iter_recurse (&o38DictIter, &o41);

                                if (!deserializeDBus(&o41, o39Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    providerValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o39Key, o39Value));
                } while (dbus_message_iter_next(&o37ArrayIter));
            }
        }
        out.setProvider(providerValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ConnectProviderResponse

void serializeDBus (const ::net::connman::Manager::ConnectProviderResponse& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::ConnectProviderResponse& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o42 = 0;
            dbus_message_iter_get_basic(in, &o42);
            pathTmpValue.assign (o42);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegisterAgentRequest

void serializeDBus (const ::net::connman::Manager::RegisterAgentRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::RegisterAgentRequest& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o43 = 0;
            dbus_message_iter_get_basic(in, &o43);
            pathTmpValue.assign (o43);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnregisterAgentRequest

void serializeDBus (const ::net::connman::Manager::UnregisterAgentRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::UnregisterAgentRequest& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o44 = 0;
            dbus_message_iter_get_basic(in, &o44);
            pathTmpValue.assign (o44);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RegisterCounterRequest

void serializeDBus (const ::net::connman::Manager::RegisterCounterRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
    uint32 o45 = in.getAccuracy();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o45));
    uint32 o46 = in.getPeriod();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UINT32, &o46));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::RegisterCounterRequest& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o47 = 0;
            dbus_message_iter_get_basic(in, &o47);
            pathTmpValue.assign (o47);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 accuracyValue;
        uint32 &accuracyTmpValue = accuracyValue;
        dbus_message_iter_get_basic(in, &accuracyTmpValue);
        out.setAccuracy(accuracyValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 periodValue;
        uint32 &periodTmpValue = periodValue;
        dbus_message_iter_get_basic(in, &periodTmpValue);
        out.setPeriod(periodValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of UnregisterCounterRequest

void serializeDBus (const ::net::connman::Manager::UnregisterCounterRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::UnregisterCounterRequest& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o48 = 0;
            dbus_message_iter_get_basic(in, &o48);
            pathTmpValue.assign (o48);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateSessionRequest

void serializeDBus (const ::net::connman::Manager::CreateSessionRequest& in, DBusMessageIter* out) {
    DBusMessageIter o49ArrayIter;
    DBusMessageIter o50DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o49ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o51 = &in.getSettings();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o52 = o51->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o53 = o51->begin(); o53 != o52; ++o53) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o49ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o50DictIter));
        const char* o54 = o53->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o50DictIter, DBUS_TYPE_STRING, &o54));
        serializeDBus(o53->second, &o50DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o49ArrayIter, &o50DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o49ArrayIter));
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getNotifier())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getNotifier()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::CreateSessionRequest& out) {
    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > settingsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o55ArrayIter;
            DBusMessageIter o56DictIter;
            dbus_message_iter_recurse (in, &o55ArrayIter);

            if (dbus_message_iter_get_arg_type(&o55ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o57Key;
                    ::asf::dbus::DBusVariant o57Value;
                    dbus_message_iter_recurse (&o55ArrayIter, &o56DictIter);
                    {
                        char* o58 = 0;
                        dbus_message_iter_get_basic(&o56DictIter, &o58);
                        o57Key.assign (o58);
                    }
                    dbus_message_iter_next(&o56DictIter);
                    {
                        DBusMessageIter o59;
                        char* signature = dbus_message_iter_get_signature(&o56DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o56DictIter)) {
                                dbus_message_iter_recurse (&o56DictIter, &o59);

                                if (!deserializeDBus(&o59, o57Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    settingsValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o57Key, o57Value));
                } while (dbus_message_iter_next(&o55ArrayIter));
            }
        }
        out.setSettings(settingsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::string notifierValue;
        ::std::string &notifierTmpValue = notifierValue;
        {
            char* o60 = 0;
            dbus_message_iter_get_basic(in, &o60);
            notifierTmpValue.assign (o60);
        }
        out.setNotifier(notifierValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of CreateSessionResponse

void serializeDBus (const ::net::connman::Manager::CreateSessionResponse& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getSession())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getSession()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::CreateSessionResponse& out) {
    {
        ::std::string sessionValue;
        ::std::string &sessionTmpValue = sessionValue;
        {
            char* o61 = 0;
            dbus_message_iter_get_basic(in, &o61);
            sessionTmpValue.assign (o61);
        }
        out.setSession(sessionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of DestroySessionRequest

void serializeDBus (const ::net::connman::Manager::DestroySessionRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getSession())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getSession()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::DestroySessionRequest& out) {
    {
        ::std::string sessionValue;
        ::std::string &sessionTmpValue = sessionValue;
        {
            char* o62 = 0;
            dbus_message_iter_get_basic(in, &o62);
            sessionTmpValue.assign (o62);
        }
        out.setSession(sessionValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of RequestPrivateNetworkResponse

void serializeDBus (const ::net::connman::Manager::RequestPrivateNetworkResponse& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
    DBusMessageIter o63ArrayIter;
    DBusMessageIter o64DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o63ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o65 = &in.getSettings();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o66 = o65->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o67 = o65->begin(); o67 != o66; ++o67) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o63ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o64DictIter));
        const char* o68 = o67->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o64DictIter, DBUS_TYPE_STRING, &o68));
        serializeDBus(o67->second, &o64DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o63ArrayIter, &o64DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o63ArrayIter));
    uint32 o69 = in.getSocket();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_UNIX_FD, &o69));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::RequestPrivateNetworkResponse& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o70 = 0;
            dbus_message_iter_get_basic(in, &o70);
            pathTmpValue.assign (o70);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > settingsValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o71ArrayIter;
            DBusMessageIter o72DictIter;
            dbus_message_iter_recurse (in, &o71ArrayIter);

            if (dbus_message_iter_get_arg_type(&o71ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o73Key;
                    ::asf::dbus::DBusVariant o73Value;
                    dbus_message_iter_recurse (&o71ArrayIter, &o72DictIter);
                    {
                        char* o74 = 0;
                        dbus_message_iter_get_basic(&o72DictIter, &o74);
                        o73Key.assign (o74);
                    }
                    dbus_message_iter_next(&o72DictIter);
                    {
                        DBusMessageIter o75;
                        char* signature = dbus_message_iter_get_signature(&o72DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o72DictIter)) {
                                dbus_message_iter_recurse (&o72DictIter, &o75);

                                if (!deserializeDBus(&o75, o73Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    settingsValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o73Key, o73Value));
                } while (dbus_message_iter_next(&o71ArrayIter));
            }
        }
        out.setSettings(settingsValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        uint32 socketValue;
        uint32 &socketTmpValue = socketValue;
        dbus_message_iter_get_basic(in, &socketTmpValue);
        out.setSocket(socketValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ReleasePrivateNetworkRequest

void serializeDBus (const ::net::connman::Manager::ReleasePrivateNetworkRequest& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::ReleasePrivateNetworkRequest& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o76 = 0;
            dbus_message_iter_get_basic(in, &o76);
            pathTmpValue.assign (o76);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of PropertyChangedSignal

void serializeDBus (const ::net::connman::Manager::PropertyChangedSignal& in, DBusMessageIter* out) {
    const char* o77 = in.getName().c_str();
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_STRING, &o77));
    serializeDBus(in.getValue(), out);
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::PropertyChangedSignal& out) {
    {
        ::std::string nameValue;
        ::std::string &nameTmpValue = nameValue;
        {
            char* o78 = 0;
            dbus_message_iter_get_basic(in, &o78);
            nameTmpValue.assign (o78);
        }
        out.setName(nameValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::asf::dbus::DBusVariant valueValue;
        {
            DBusMessageIter o79;
            char* signature = dbus_message_iter_get_signature(in);

            if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(in)) {
                    dbus_message_iter_recurse (in, &o79);

                    if (!deserializeDBus(&o79, valueValue)) {
                        dbus_free(signature);
                        return false;
                    }
                }
            }
            dbus_free(signature);
        }
        out.setValue(valueValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TechnologyAddedSignal

void serializeDBus (const ::net::connman::Manager::TechnologyAddedSignal& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
    DBusMessageIter o80ArrayIter;
    DBusMessageIter o81DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o80ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o82 = &in.getProperties();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o83 = o82->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o84 = o82->begin(); o84 != o83; ++o84) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o80ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o81DictIter));
        const char* o85 = o84->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o81DictIter, DBUS_TYPE_STRING, &o85));
        serializeDBus(o84->second, &o81DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o80ArrayIter, &o81DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o80ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::TechnologyAddedSignal& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o86 = 0;
            dbus_message_iter_get_basic(in, &o86);
            pathTmpValue.assign (o86);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > propertiesValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o87ArrayIter;
            DBusMessageIter o88DictIter;
            dbus_message_iter_recurse (in, &o87ArrayIter);

            if (dbus_message_iter_get_arg_type(&o87ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o89Key;
                    ::asf::dbus::DBusVariant o89Value;
                    dbus_message_iter_recurse (&o87ArrayIter, &o88DictIter);
                    {
                        char* o90 = 0;
                        dbus_message_iter_get_basic(&o88DictIter, &o90);
                        o89Key.assign (o90);
                    }
                    dbus_message_iter_next(&o88DictIter);
                    {
                        DBusMessageIter o91;
                        char* signature = dbus_message_iter_get_signature(&o88DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o88DictIter)) {
                                dbus_message_iter_recurse (&o88DictIter, &o91);

                                if (!deserializeDBus(&o91, o89Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    propertiesValue.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o89Key, o89Value));
                } while (dbus_message_iter_next(&o87ArrayIter));
            }
        }
        out.setProperties(propertiesValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of TechnologyRemovedSignal

void serializeDBus (const ::net::connman::Manager::TechnologyRemovedSignal& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getPath())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getPath()));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::TechnologyRemovedSignal& out) {
    {
        ::std::string pathValue;
        ::std::string &pathTmpValue = pathValue;
        {
            char* o92 = 0;
            dbus_message_iter_get_basic(in, &o92);
            pathTmpValue.assign (o92);
        }
        out.setPath(pathValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ServicesChangedSignal

void serializeDBus (const ::net::connman::Manager::ServicesChangedSignal& in, DBusMessageIter* out) {
    DBusMessageIter o93ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "(oa{sv})", &o93ArrayIter));
    const ::std::vector< ::net::connman::Manager::ServicesChangedSignalChangedStruct >* o94 = &in.getChanged();
    ::std::vector< ::net::connman::Manager::ServicesChangedSignalChangedStruct >::const_iterator o95 = o94->end();
    for (::std::vector< ::net::connman::Manager::ServicesChangedSignalChangedStruct >::const_iterator o96 = o94->begin(); o96 != o95; ++o96) {
        {
            DBusMessageIter o97Struct;
            DBUS_ASSERT(dbus_message_iter_open_container(&o93ArrayIter, DBUS_TYPE_STRUCT, 0, &o97Struct));
            serializeDBus((*o96), &o97Struct);
            DBUS_ASSERT(dbus_message_iter_close_container(&o93ArrayIter, &o97Struct));
        }
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o93ArrayIter));
    DBusMessageIter o98ArrayIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "o", &o98ArrayIter));
    const ::std::vector< ::std::string >* o99 = &in.getRemoved();
    ::std::vector< ::std::string >::const_iterator o100 = o99->end();
    for (::std::vector< ::std::string >::const_iterator o101 = o99->begin(); o101 != o100; ++o101) {
        DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string((*o101))));
        DBUS_ASSERT(dbus_message_iter_append_basic(&o98ArrayIter, DBUS_TYPE_OBJECT_PATH, &(*o101)));
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o98ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::ServicesChangedSignal& out) {
    {
        ::std::vector< ::net::connman::Manager::ServicesChangedSignalChangedStruct > changedValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o102ArrayIter;
            dbus_message_iter_recurse (in, &o102ArrayIter);

            if(dbus_message_iter_get_arg_type(&o102ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::net::connman::Manager::ServicesChangedSignalChangedStruct o103;
                    {
                        DBusMessageIter o104;
                        char* signature = dbus_message_iter_get_signature(&o102ArrayIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o102ArrayIter)) {
                                dbus_message_iter_recurse (&o102ArrayIter, &o104);

                                if (!deserializeDBus(&o104, o103)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    changedValue.push_back(o103);
                } while (dbus_message_iter_next(&o102ArrayIter));
            }
        }
        out.setChanged(changedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::vector< ::std::string > removedValue;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o105ArrayIter;
            dbus_message_iter_recurse (in, &o105ArrayIter);

            if(dbus_message_iter_get_arg_type(&o105ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o106;
                    {
                        char* o107 = 0;
                        dbus_message_iter_get_basic(&o105ArrayIter, &o107);
                        o106.assign (o107);
                    }
                    removedValue.push_back(o106);
                } while (dbus_message_iter_next(&o105ArrayIter));
            }
        }
        out.setRemoved(removedValue);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetTechnologiesResponseTechnologiesStruct

void serializeDBus (const ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o108ArrayIter;
    DBusMessageIter o109DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o108ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o110 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o111 = o110->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o112 = o110->begin(); o112 != o111; ++o112) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o108ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o109DictIter));
        const char* o113 = o112->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o109DictIter, DBUS_TYPE_STRING, &o113));
        serializeDBus(o112->second, &o109DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o108ArrayIter, &o109DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o108ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::GetTechnologiesResponseTechnologiesStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o114 = 0;
            dbus_message_iter_get_basic(in, &o114);
            elem1TmpValue.assign (o114);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o115ArrayIter;
            DBusMessageIter o116DictIter;
            dbus_message_iter_recurse (in, &o115ArrayIter);

            if (dbus_message_iter_get_arg_type(&o115ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o117Key;
                    ::asf::dbus::DBusVariant o117Value;
                    dbus_message_iter_recurse (&o115ArrayIter, &o116DictIter);
                    {
                        char* o118 = 0;
                        dbus_message_iter_get_basic(&o116DictIter, &o118);
                        o117Key.assign (o118);
                    }
                    dbus_message_iter_next(&o116DictIter);
                    {
                        DBusMessageIter o119;
                        char* signature = dbus_message_iter_get_signature(&o116DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o116DictIter)) {
                                dbus_message_iter_recurse (&o116DictIter, &o119);

                                if (!deserializeDBus(&o119, o117Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o117Key, o117Value));
                } while (dbus_message_iter_next(&o115ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of GetServicesResponseServicesStruct

void serializeDBus (const ::net::connman::Manager::GetServicesResponseServicesStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o120ArrayIter;
    DBusMessageIter o121DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o120ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o122 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o123 = o122->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o124 = o122->begin(); o124 != o123; ++o124) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o120ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o121DictIter));
        const char* o125 = o124->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o121DictIter, DBUS_TYPE_STRING, &o125));
        serializeDBus(o124->second, &o121DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o120ArrayIter, &o121DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o120ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::GetServicesResponseServicesStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o126 = 0;
            dbus_message_iter_get_basic(in, &o126);
            elem1TmpValue.assign (o126);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o127ArrayIter;
            DBusMessageIter o128DictIter;
            dbus_message_iter_recurse (in, &o127ArrayIter);

            if (dbus_message_iter_get_arg_type(&o127ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o129Key;
                    ::asf::dbus::DBusVariant o129Value;
                    dbus_message_iter_recurse (&o127ArrayIter, &o128DictIter);
                    {
                        char* o130 = 0;
                        dbus_message_iter_get_basic(&o128DictIter, &o130);
                        o129Key.assign (o130);
                    }
                    dbus_message_iter_next(&o128DictIter);
                    {
                        DBusMessageIter o131;
                        char* signature = dbus_message_iter_get_signature(&o128DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o128DictIter)) {
                                dbus_message_iter_recurse (&o128DictIter, &o131);

                                if (!deserializeDBus(&o131, o129Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o129Key, o129Value));
                } while (dbus_message_iter_next(&o127ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

// D-Bus serialize and deserialize functions of ServicesChangedSignalChangedStruct

void serializeDBus (const ::net::connman::Manager::ServicesChangedSignalChangedStruct& in, DBusMessageIter* out) {
    DBUS_ASSERT(::asf::dbus::DBusUtils::isObjectPathValid(std::string(in.getElem1())));
    DBUS_ASSERT(dbus_message_iter_append_basic(out, DBUS_TYPE_OBJECT_PATH, &in.getElem1()));
    DBusMessageIter o132ArrayIter;
    DBusMessageIter o133DictIter;
    DBUS_ASSERT(dbus_message_iter_open_container(out, DBUS_TYPE_ARRAY, "{sv}", &o132ArrayIter));
    const ::std::map< ::std::string, ::asf::dbus::DBusVariant >* o134 = &in.getElem2();
    ::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o135 = o134->end();
    for (::std::map< ::std::string, ::asf::dbus::DBusVariant >::const_iterator o136 = o134->begin(); o136 != o135; ++o136) {
        DBUS_ASSERT(dbus_message_iter_open_container(&o132ArrayIter, DBUS_TYPE_DICT_ENTRY, 0, &o133DictIter));
        const char* o137 = o136->first.c_str();
        DBUS_ASSERT(dbus_message_iter_append_basic(&o133DictIter, DBUS_TYPE_STRING, &o137));
        serializeDBus(o136->second, &o133DictIter);
        DBUS_ASSERT(dbus_message_iter_close_container(&o132ArrayIter, &o133DictIter)); // close dict container
    }
    DBUS_ASSERT(dbus_message_iter_close_container(out, &o132ArrayIter));
}

bool deserializeDBus (DBusMessageIter* in, ::net::connman::Manager::ServicesChangedSignalChangedStruct& out) {
    {
        ::std::string elem1Value;
        ::std::string &elem1TmpValue = elem1Value;
        {
            char* o138 = 0;
            dbus_message_iter_get_basic(in, &o138);
            elem1TmpValue.assign (o138);
        }
        out.setElem1(elem1Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    {
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > elem2Value;

        if (dbus_message_iter_get_arg_type(in) != DBUS_TYPE_INVALID) {
            DBusMessageIter o139ArrayIter;
            DBusMessageIter o140DictIter;
            dbus_message_iter_recurse (in, &o139ArrayIter);

            if (dbus_message_iter_get_arg_type(&o139ArrayIter) != DBUS_TYPE_INVALID) {
                do {
                    ::std::string o141Key;
                    ::asf::dbus::DBusVariant o141Value;
                    dbus_message_iter_recurse (&o139ArrayIter, &o140DictIter);
                    {
                        char* o142 = 0;
                        dbus_message_iter_get_basic(&o140DictIter, &o142);
                        o141Key.assign (o142);
                    }
                    dbus_message_iter_next(&o140DictIter);
                    {
                        DBusMessageIter o143;
                        char* signature = dbus_message_iter_get_signature(&o140DictIter);

                        if (0 !=  strcmp(signature, DBUS_TYPE_INVALID_AS_STRING)) {
                            if (DBUS_TYPE_INVALID != dbus_message_iter_get_arg_type(&o140DictIter)) {
                                dbus_message_iter_recurse (&o140DictIter, &o143);

                                if (!deserializeDBus(&o143, o141Value)) {
                                    dbus_free(signature);
                                    return false;
                                }
                            }
                        }
                        dbus_free(signature);
                    }
                    elem2Value.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant >(o141Key, o141Value));
                } while (dbus_message_iter_next(&o139ArrayIter));
            }
        }
        out.setElem2(elem2Value);
    }

    if (dbus_message_iter_has_next(in)) {
        dbus_message_iter_next(in);
    } else {
        return true;
    }

    return true;
}

