/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_AGENTSTUB_H
#define NET_CONNMAN_AGENTSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Agent.h"
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Agent {

class AgentStubDelegate;

class AgentStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AgentStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AgentStub (const std::string& portName);

    /**
     * Create an instance of the AgentStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AgentStub (const std::string& portName, const std::string& objectPath);

    virtual ~AgentStub();

    // method 'Release'

    /**
     * The method onRelease() is called by ASF when a client invokes the
     * method 'Release'. A subclass has to implement this method and send back
     * a response to the client either with the sendRelease() or
     * sendReleaseError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseRequest (const ::boost::shared_ptr< ReleaseRequest >& request) = 0;

    /**
     * The method sendReleaseResponse() sends a response of a previous method
     * invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRelease(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReleaseResponse (act_t act = 0);

    /**
     * The method sendReleaseError() sends an error response of a previous
     * method invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRelease(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReportError'

    /**
     * The method onReportError() is called by ASF when a client invokes the
     * method 'ReportError'. A subclass has to implement this method and send
     * back a response to the client either with the sendReportError() or
     * sendReportErrorError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'ReportError'</b>:
     *
     * If the meaning of "ReportError" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReportErrorRequest (const ::boost::shared_ptr< ReportErrorRequest >& request) = 0;

    /**
     * The method sendReportErrorResponse() sends a response of a previous
     * method invocation of 'ReportError' back to the client.
     *
     * <b>Documentation of 'ReportError'</b>:
     *
     * If the meaning of "ReportError" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReportError(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReportErrorResponse (act_t act = 0);

    /**
     * The method sendReportErrorError() sends an error response of a previous
     * method invocation of 'ReportError' back to the client.
     *
     * <b>Documentation of 'ReportError'</b>:
     *
     * If the meaning of "ReportError" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReportError(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReportErrorError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestBrowser'

    /**
     * The method onRequestBrowser() is called by ASF when a client invokes
     * the method 'RequestBrowser'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRequestBrowser() or sendRequestBrowserError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RequestBrowser'</b>:
     *
     * If the meaning of "RequestBrowser" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestBrowserRequest (const ::boost::shared_ptr< RequestBrowserRequest >& request) = 0;

    /**
     * The method sendRequestBrowserResponse() sends a response of a previous
     * method invocation of 'RequestBrowser' back to the client.
     *
     * <b>Documentation of 'RequestBrowser'</b>:
     *
     * If the meaning of "RequestBrowser" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestBrowser(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRequestBrowserResponse (act_t act = 0);

    /**
     * The method sendRequestBrowserError() sends an error response of a
     * previous method invocation of 'RequestBrowser' back to the client.
     *
     * <b>Documentation of 'RequestBrowser'</b>:
     *
     * If the meaning of "RequestBrowser" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestBrowser(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestBrowserError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestInput'

    /**
     * The method onRequestInput() is called by ASF when a client invokes the
     * method 'RequestInput'. A subclass has to implement this method and send
     * back a response to the client either with the sendRequestInput() or
     * sendRequestInputError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'RequestInput'</b>:
     *
     * If the meaning of "RequestInput" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestInputRequest (const ::boost::shared_ptr< RequestInputRequest >& request) = 0;

    /**
     * The method sendRequestInputResponse() sends a response of a previous
     * method invocation of 'RequestInput' back to the client.
     *
     * <b>Documentation of 'RequestInput'</b>:
     *
     * If the meaning of "RequestInput" isn't clear, then there should be a description here.
     *
     * @param fields If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestInput(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRequestInputResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields, act_t act = 0);

    /**
     * The method sendRequestInputError() sends an error response of a
     * previous method invocation of 'RequestInput' back to the client.
     *
     * <b>Documentation of 'RequestInput'</b>:
     *
     * If the meaning of "RequestInput" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestInput(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRequestInputError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Cancel'

    /**
     * The method onCancel() is called by ASF when a client invokes the method
     * 'Cancel'. A subclass has to implement this method and send back a
     * response to the client either with the sendCancel() or
     * sendCancelError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRequest (const ::boost::shared_ptr< CancelRequest >& request) = 0;

    /**
     * The method sendCancelResponse() sends a response of a previous method
     * invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancel(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelResponse (act_t act = 0);

    /**
     * The method sendCancelError() sends an error response of a previous
     * method invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancel(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class AgentStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Agent
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_AGENTSTUB_H
