/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_AGENTPROXY_H
#define NET_CONNMAN_AGENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Agent.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Agent {

class AgentProxy;

class CancelCallbackIF {
public:
    virtual ~CancelCallbackIF() {}

    virtual void onCancelError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelError >& error) = 0;

    virtual void onCancelResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response) = 0;
};

class ReleaseCallbackIF {
public:
    virtual ~ReleaseCallbackIF() {}

    virtual void onReleaseError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReleaseError >& error) = 0;

    virtual void onReleaseResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReleaseResponse >& response) = 0;
};

class ReportErrorCallbackIF {
public:
    virtual ~ReportErrorCallbackIF() {}

    virtual void onReportErrorError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReportErrorError >& error) = 0;

    virtual void onReportErrorResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReportErrorResponse >& response) = 0;
};

class RequestBrowserCallbackIF {
public:
    virtual ~RequestBrowserCallbackIF() {}

    virtual void onRequestBrowserError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestBrowserError >& error) = 0;

    virtual void onRequestBrowserResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestBrowserResponse >& response) = 0;
};

class RequestInputCallbackIF {
public:
    virtual ~RequestInputCallbackIF() {}

    virtual void onRequestInputError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestInputError >& error) = 0;

    virtual void onRequestInputResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestInputResponse >& response) = 0;
};


/**
 * AgentProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Agent' (specified in file connman_agent.xml).
 *
 * If the meaning of "net.connman.Agent" isn't clear, then there should be a description here.
 */
class AgentProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of AgentProxy.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of AgentProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of AgentProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< AgentProxy > proxyNew(new AgentProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~AgentProxy ();




    // Method 'Release'

    /**
     * Call the method 'Release'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseRequest(ReleaseCallbackIF& cb) const;

    // Method 'ReportError'

    /**
     * Call the method 'ReportError'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ReportError'</b>:
     *
     * If the meaning of "ReportError" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param service If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param error If the meaning of "error" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReportErrorRequest(ReportErrorCallbackIF& cb, const ::std::string& service, const ::std::string& error) const;

    // Method 'RequestBrowser'

    /**
     * Call the method 'RequestBrowser'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestBrowser'</b>:
     *
     * If the meaning of "RequestBrowser" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param service If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param url If the meaning of "url" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestBrowserRequest(RequestBrowserCallbackIF& cb, const ::std::string& service, const ::std::string& url) const;

    // Method 'RequestInput'

    /**
     * Call the method 'RequestInput'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestInput'</b>:
     *
     * If the meaning of "RequestInput" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param service If the meaning of "service" isn't clear, then there should be a description here.
     *
     * @param fields If the meaning of "fields" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestInputRequest(RequestInputCallbackIF& cb, const ::std::string& service, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& fields) const;

    // Method 'Cancel'

    /**
     * Call the method 'Cancel'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequest(CancelCallbackIF& cb) const;


private:

    AgentProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class AgentProxyCallback;
};

} // namespace Agent
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_AGENTPROXY_H
