/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/SeamlessPairing.h"
#include "org/bluez/SeamlessPairingDBus.h"
#include "org/bluez/SeamlessPairingJson.h"
#include "org/bluez/SeamlessPairingProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace SeamlessPairing {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/SeamlessPairing", SeamlessPairingProxy);

class SeamlessPairingProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SeamlessPairingProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SeamlessPairingProxy >& proxyShared = ::boost::static_pointer_cast< SeamlessPairingProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_ErrorCodeReceived:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ErrorCodeReceivedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ErrorCodeReceived", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<ErrorCodeReceivedSignal> payload = ::boost::static_pointer_cast<ErrorCodeReceivedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((ErrorCodeReceivedCallbackIF*) _callback)->onErrorCodeReceivedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AccessRequest:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AccessRequestSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AccessRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AccessRequestSignal> payload = ::boost::static_pointer_cast<AccessRequestSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AccessRequestCallbackIF*) _callback)->onAccessRequestSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PairingData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairingDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PairingData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairingDataError> payload = ::boost::static_pointer_cast<PairingDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PairingDataCallbackIF*) _callback)->onPairingDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairingDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PairingData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairingDataUpdate> payload = ::boost::static_pointer_cast<PairingDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PairingDataCallbackIF*) _callback)->onPairingDataUpdate(proxyShared, payload);
                        proxyShared->_pairingData = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SendErrorCode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendErrorCodeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendErrorCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendErrorCodeError> payload = ::boost::static_pointer_cast<SendErrorCodeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendErrorCodeCallbackIF*) _callback)->onSendErrorCodeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendErrorCodeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendErrorCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendErrorCodeResponse> payload = ::boost::static_pointer_cast<SendErrorCodeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendErrorCodeCallbackIF*) _callback)->onSendErrorCodeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AllowAccess:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AllowAccessError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AllowAccess", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AllowAccessError> payload = ::boost::static_pointer_cast<AllowAccessError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AllowAccessCallbackIF*) _callback)->onAllowAccessError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AllowAccessResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AllowAccess", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AllowAccessResponse> payload = ::boost::static_pointer_cast<AllowAccessResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AllowAccessCallbackIF*) _callback)->onAllowAccessResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_ErrorCodeReceived: {
                ::boost::shared_ptr< ErrorCodeReceivedError > payload = ::boost::shared_ptr< ErrorCodeReceivedError >
                (new ErrorCodeReceivedError(DBUS_ERROR_NO_SERVER, "The DBus service SeamlessPairing is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ErrorCodeReceived", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SeamlessPairingProxy> proxyShared = ::boost::static_pointer_cast<SeamlessPairingProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ErrorCodeReceivedCallbackIF*) _callback)->onErrorCodeReceivedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AccessRequest: {
                ::boost::shared_ptr< AccessRequestError > payload = ::boost::shared_ptr< AccessRequestError >
                (new AccessRequestError(DBUS_ERROR_NO_SERVER, "The DBus service SeamlessPairing is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AccessRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SeamlessPairingProxy> proxyShared = ::boost::static_pointer_cast<SeamlessPairingProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AccessRequestCallbackIF*) _callback)->onAccessRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PairingData: {
                ::boost::shared_ptr< PairingDataError > payload = ::boost::shared_ptr< PairingDataError >
                (new PairingDataError(DBUS_ERROR_NO_SERVER, "The DBus service SeamlessPairing is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PairingData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SeamlessPairingProxy> proxyShared = ::boost::static_pointer_cast<SeamlessPairingProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PairingDataCallbackIF*) _callback)->onPairingDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendErrorCode: {
                ::boost::shared_ptr< SendErrorCodeError > payload = ::boost::shared_ptr< SendErrorCodeError >
                (new SendErrorCodeError(DBUS_ERROR_NO_SERVER, "The DBus service SeamlessPairing is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendErrorCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SeamlessPairingProxy> proxyShared = ::boost::static_pointer_cast<SeamlessPairingProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendErrorCodeCallbackIF*) _callback)->onSendErrorCodeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AllowAccess: {
                ::boost::shared_ptr< AllowAccessError > payload = ::boost::shared_ptr< AllowAccessError >
                (new AllowAccessError(DBUS_ERROR_NO_SERVER, "The DBus service SeamlessPairing is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AllowAccess", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SeamlessPairingProxy> proxyShared = ::boost::static_pointer_cast<SeamlessPairingProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AllowAccessCallbackIF*) _callback)->onAllowAccessError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SeamlessPairingProxyCallback::_logger (SeamlessPairingProxy::_logger);

SeamlessPairingProxy::SeamlessPairingProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.SeamlessPairing", serviceAvailable, _logger) {
}

SeamlessPairingProxy::~SeamlessPairingProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SeamlessPairingProxy > SeamlessPairingProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SeamlessPairingProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SeamlessPairingProxy > proxyNew(new SeamlessPairingProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SeamlessPairingProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SeamlessPairingProxyCallback* callback = new SeamlessPairingProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SeamlessPairingProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SeamlessPairingProxyCallback* callback = new SeamlessPairingProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SeamlessPairingProxy::clearAllProperties ()
{
    _pairingData = ::asf::core::nullable< PairingDataUpdate >();
}

void SeamlessPairingProxy::sendDeregisterAll () const
{
    sendPairingDataDeregisterAll();
    sendErrorCodeReceivedDeregisterAll();
    sendAccessRequestDeregisterAll();
}

act_t SeamlessPairingProxy::sendErrorCodeReceivedRegister(ErrorCodeReceivedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "ErrorCodeReceived");
    act_t act = addSignalCallback(ID_ErrorCodeReceived, "ErrorCodeReceived", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ErrorCodeReceived", &cb, act);
    return act;
}

bool SeamlessPairingProxy::sendErrorCodeReceivedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ErrorCodeReceived", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ErrorCodeReceived", act, static_cast<int>(rv));
    return rv;
}

void SeamlessPairingProxy::sendErrorCodeReceivedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ErrorCodeReceived");
    _dbusProxyDelegate->deregisterSignalCallback("ErrorCodeReceived", 0, _dbusDaemonProxy.get(), false);
}

act_t SeamlessPairingProxy::sendAccessRequestRegister(AccessRequestCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AccessRequest");
    act_t act = addSignalCallback(ID_AccessRequest, "AccessRequest", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AccessRequest", &cb, act);
    return act;
}

bool SeamlessPairingProxy::sendAccessRequestDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AccessRequest", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AccessRequest", act, static_cast<int>(rv));
    return rv;
}

void SeamlessPairingProxy::sendAccessRequestDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AccessRequest");
    _dbusProxyDelegate->deregisterSignalCallback("AccessRequest", 0, _dbusDaemonProxy.get(), false);
}

act_t SeamlessPairingProxy::sendPairingDataRegister(PairingDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PairingData, "PairingData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PairingData", &cb, act);
    return act;
}

bool SeamlessPairingProxy::sendPairingDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PairingData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PairingData", act, static_cast<int>(rv));
    return rv;
}

act_t SeamlessPairingProxy::sendPairingDataGet(PairingDataCallbackIF& cb) {
    SeamlessPairingProxyCallback* callback = new SeamlessPairingProxyCallback(ID_PairingData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PairingData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PairingData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SeamlessPairingProxy::sendPairingDataSet(const ::std::vector< uint8 >& pairingData) {
    PairingDataSet parameter(pairingData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PairingData");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PairingData", propertyContent);
}

act_t SeamlessPairingProxy::sendPairingDataSet(PairingDataCallbackIF& cb, const ::std::vector< uint8 >& pairingData) {
    SeamlessPairingProxyCallback* callback = new SeamlessPairingProxyCallback(ID_PairingData, &cb);
    PairingDataSet parameter(pairingData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PairingData", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PairingData", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< uint8 >& SeamlessPairingProxy::getPairingData() const {
    return _pairingData.get().getPairingData();
}

bool SeamlessPairingProxy::hasPairingData() const {
    return _pairingData.hasValue();
}

void SeamlessPairingProxy::sendPairingDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PairingData");
    _dbusProxyDelegate->deregisterSignalCallback("PairingData", 0, _dbusDaemonProxy.get(), true);
}

act_t SeamlessPairingProxy::sendSendErrorCodeRequest(SendErrorCodeCallbackIF& cb, const ::std::string& error_code) const {
    SendErrorCodeRequest* payload = new SendErrorCodeRequest();
    CHECK_ALLOCATION(payload);
    payload->setError_code(error_code);
    DBUS_MESSAGE_CALL(dbusMessage, "SendErrorCode", SendErrorCodeRequest, payload, true)
    act_t act = addMethodCallback(ID_SendErrorCode, dbusMessage.getUniqueSerial(), "SendErrorCode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendErrorCode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SeamlessPairingProxy::sendAllowAccessRequest(AllowAccessCallbackIF& cb, bool accept) const {
    AllowAccessRequest* payload = new AllowAccessRequest();
    CHECK_ALLOCATION(payload);
    payload->setAccept(accept);
    DBUS_MESSAGE_CALL(dbusMessage, "AllowAccess", AllowAccessRequest, payload, true)
    act_t act = addMethodCallback(ID_AllowAccess, dbusMessage.getUniqueSerial(), "AllowAccess", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AllowAccess", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SeamlessPairing
} // namespace bluez
} // namespace org
