/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Device1.h"
#include "org/bluez/LE_Device1DBus.h"
#include "org/bluez/LE_Device1Json.h"
#include "org/bluez/LE_Device1Stub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace LE_Device1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/LE_Device1", LE_Device1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 10, "Disconnect", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 7, "Address", 1 },
    { 9, "Connected", 2 },
    { 11, "AddressType", 0 },
};

class LE_Device1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    LE_Device1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    LE_Device1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    LE_Device1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.LE_Device1"),
          _logger(logger) {}

    virtual ~LE_Device1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void LE_Device1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<LE_Device1Stub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* LE_Device1StubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.LE_Device1\">\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <signal name=\"DisconnectionComp\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"reason\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"AddressType\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Address\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Connected\" type=\"b\"/>\n"
            "</interface>\n";
}

void LE_Device1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<LE_Device1Stub*>(getStub()))->onGetAll (properties);
}

void LE_Device1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "AddressType");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void LE_Device1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 3, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "AddressType");
            ::boost::shared_ptr< AddressTypeGet > payload(new AddressTypeGet());
            payload->setAct(act);
            static_cast<LE_Device1Stub*>(getStub())->onAddressTypeGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            ::boost::shared_ptr< AddressGet > payload(new AddressGet());
            payload->setAct(act);
            static_cast<LE_Device1Stub*>(getStub())->onAddressGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            ::boost::shared_ptr< ConnectedGet > payload(new ConnectedGet());
            payload->setAct(act);
            static_cast<LE_Device1Stub*>(getStub())->onConnectedGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

LE_Device1Stub::LE_Device1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LE_Device1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LE_Device1Stub::LE_Device1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new LE_Device1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

LE_Device1Stub::~LE_Device1Stub() {
    delete _stubDelegate;
}

void LE_Device1Stub::sendDisconnectionCompSignal(uint8 status, uint8 reason) {
    if (_stubDelegate->isConnected()) {
        DisconnectionCompSignal* payload = new DisconnectionCompSignal(status, reason);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DisconnectionComp", DisconnectionCompSignal, payload)
        LOG_INFO ("-> send%sSignal", "DisconnectionComp");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DisconnectionComp");
    }
}

void LE_Device1Stub::sendAddressTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressTypeUpdate payload(_AddressTypeProperty);

        LOG_INFO ("-> send%s", "AddressTypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AddressType", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressTypeUpdate");
    }
}

void LE_Device1Stub::onAddressTypeGet(const ::boost::shared_ptr< AddressTypeGet >& addressType) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressTypeGet", addressType->getAct());
    sendAddressTypeGetUpdate(_AddressTypeProperty.getAddressType(), addressType->getAct());
}

void LE_Device1Stub::sendAddressTypeGetUpdate(uint8 addressType, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressTypeGet payload(addressType);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressTypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Device1Stub::setAddressType(uint8 addressType) {
    if(addressType!=_AddressTypeProperty.getAddressType()) {
        _AddressTypeProperty.setAddressType(addressType);
        sendAddressTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 LE_Device1Stub::getAddressType() const {
    return _AddressTypeProperty.getAddressType();
}

void LE_Device1Stub::sendAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressUpdate payload(_AddressProperty);

        LOG_INFO ("-> send%s", "AddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Address", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressUpdate");
    }
}

void LE_Device1Stub::onAddressGet(const ::boost::shared_ptr< AddressGet >& address) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressGet", address->getAct());
    sendAddressGetUpdate(_AddressProperty.getAddress(), address->getAct());
}

void LE_Device1Stub::sendAddressGetUpdate(const ::std::string& address, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressGet payload(address);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Device1Stub::setAddress(const ::std::string& address) {
    if(address!=_AddressProperty.getAddress()) {
        _AddressProperty.setAddress(address);
        sendAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& LE_Device1Stub::getAddress() const {
    return _AddressProperty.getAddress();
}

::std::string& LE_Device1Stub::getAddressMutable() {
    return _AddressProperty.getAddressMutable();
}

void LE_Device1Stub::sendConnectedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectedUpdate payload(_ConnectedProperty);

        LOG_INFO ("-> send%s", "ConnectedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Connected", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.LE_Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectedUpdate");
    }
}

void LE_Device1Stub::onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& connected) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectedGet", connected->getAct());
    sendConnectedGetUpdate(_ConnectedProperty.getConnected(), connected->getAct());
}

void LE_Device1Stub::sendConnectedGetUpdate(bool connected, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectedGet payload(connected);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void LE_Device1Stub::setConnected(bool connected) {
    if(connected!=_ConnectedProperty.getConnected()) {
        _ConnectedProperty.setConnected(connected);
        sendConnectedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool LE_Device1Stub::getConnected() const {
    return _ConnectedProperty.getConnected();
}

void  LE_Device1Stub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  LE_Device1Stub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void LE_Device1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'AddressType'
    {
        ::asf::dbus::DBusVariant variant;
        AddressTypeGet payload(_AddressTypeProperty.getAddressType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AddressType", variant));
    }

    //property 'Address'
    {
        ::asf::dbus::DBusVariant variant;
        AddressGet payload(_AddressProperty.getAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Address", variant));
    }

    //property 'Connected'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectedGet payload(_ConnectedProperty.getConnected());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Connected", variant));
    }
}

} // namespace LE_Device1
} // namespace bluez
} // namespace org
