/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_DEVICE1PROXY_H
#define ORG_BLUEZ_LE_DEVICE1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/LE_Device1.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace LE_Device1 {

class LE_Device1Proxy;

class AddressCallbackIF {
public:
    virtual ~AddressCallbackIF() {}

    virtual void onAddressError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

    virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;
};

class AddressTypeCallbackIF {
public:
    virtual ~AddressTypeCallbackIF() {}

    virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error) = 0;

    virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update) = 0;
};

class ConnectedCallbackIF {
public:
    virtual ~ConnectedCallbackIF() {}

    virtual void onConnectedError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedError >& error) = 0;

    virtual void onConnectedUpdate(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< ConnectedUpdate >& update) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class DisconnectionCompCallbackIF {
public:
    virtual ~DisconnectionCompCallbackIF() {}

    virtual void onDisconnectionCompError(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompError >& error) = 0;

    virtual void onDisconnectionCompSignal(const ::boost::shared_ptr< LE_Device1Proxy >& proxy, const ::boost::shared_ptr< DisconnectionCompSignal >& signal) = 0;
};


/**
 * LE_Device1Proxy is the client side representation of the D-Bus service
 * interface 'org.bluez.LE_Device1' (specified in file ble_device.xml).
 *
 * If the meaning of "org.bluez.LE_Device1" isn't clear, then there should be a description here.
 */
class LE_Device1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LE_Device1Proxy.
     */
    static ::boost::shared_ptr< LE_Device1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LE_Device1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LE_Device1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LE_Device1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LE_Device1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LE_Device1Proxy > proxyNew(new LE_Device1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~LE_Device1Proxy ();


    // Signal 'DisconnectionComp'

    /**
     * Notify on the signal 'DisconnectionComp'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'DisconnectionComp'</b>:
     *
     * If the meaning of "DisconnectionComp" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectionCompRegister(DisconnectionCompCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'DisconnectionComp'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'DisconnectionComp'</b>:
     *
     * If the meaning of "DisconnectionComp" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDisconnectionCompRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDisconnectionCompDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'DisconnectionComp'.
     */
    void sendDisconnectionCompDeregisterAll () const;


    // Property 'AddressType'

    /**
     * Notify on the property 'AddressType'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressTypeRegister(AddressTypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AddressType'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AddressType'.
     */
    void sendAddressTypeDeregisterAll() const;

    /**
     * Request the value of the property 'AddressType' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressTypeGet(AddressTypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'AddressType' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAddressType() returns true.
     *
     * @return the previously received value of the property 'AddressType'.
     */
    uint8 getAddressType() const;

    /**
     * Determines whether a status message for the property 'AddressType' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddressType() const;

    // Property 'Address'

    /**
     * Notify on the property 'Address'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressRegister(AddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Address'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Address'.
     */
    void sendAddressDeregisterAll() const;

    /**
     * Request the value of the property 'Address' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressGet(AddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'Address' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAddress()
     * returns true.
     *
     * @return the previously received value of the property 'Address'.
     */
    const ::std::string& getAddress() const;

    /**
     * Determines whether a status message for the property 'Address' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddress() const;

    // Property 'Connected'

    /**
     * Notify on the property 'Connected'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedRegister(ConnectedCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Connected'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendConnectedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendConnectedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Connected'.
     */
    void sendConnectedDeregisterAll() const;

    /**
     * Request the value of the property 'Connected' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Connected'</b>:
     *
     * If the meaning of "Connected" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectedGet(ConnectedCallbackIF& cb);


    /**
     * Returns the current value of the property 'Connected' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasConnected()
     * returns true.
     *
     * @return the previously received value of the property 'Connected'.
     */
    bool getConnected() const;

    /**
     * Determines whether a status message for the property 'Connected' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasConnected() const;


    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    LE_Device1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'AddressType'

    ::asf::core::nullable< AddressTypeUpdate > _addressType;

    // Property 'Address'

    ::asf::core::nullable< AddressUpdate > _address;

    // Property 'Connected'

    ::asf::core::nullable< ConnectedUpdate > _connected;

    DECLARE_CLASS_LOGGER();

    friend class LE_Device1ProxyCallback;
};

} // namespace LE_Device1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_DEVICE1PROXY_H
