/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_ADAPTER1STUB_H
#define ORG_BLUEZ_LE_ADAPTER1STUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Adapter1.h"
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace LE_Adapter1 {

class LE_Adapter1StubDelegate;

class LE_Adapter1Stub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the LE_Adapter1Stub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    LE_Adapter1Stub (const std::string& portName);

    /**
     * Create an instance of the LE_Adapter1Stub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    LE_Adapter1Stub (const std::string& portName, const std::string& objectPath);

    virtual ~LE_Adapter1Stub();

    // signal 'LeAdapterInitialization'

    /**
     * Raise the signal 'LeAdapterInitialization' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'LeAdapterInitialization'</b>:
     *
     * If the meaning of "LeAdapterInitialization" isn't clear, then there should be a description here.
     */
    void sendLeAdapterInitializationSignal();

    // signal 'LeDeviceCreated'

    /**
     * Raise the signal 'LeDeviceCreated' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LeDeviceCreated'</b>:
     *
     * If the meaning of "LeDeviceCreated" isn't clear, then there should be a description here.
     */
    void sendLeDeviceCreatedSignal(const ::std::string& device);

    // signal 'LeDeviceRemoved'

    /**
     * Raise the signal 'LeDeviceRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'LeDeviceRemoved'</b>:
     *
     * If the meaning of "LeDeviceRemoved" isn't clear, then there should be a description here.
     */
    void sendLeDeviceRemovedSignal(const ::std::string& device);

    // property 'AddressType'

    /**
     * The method onAddressTypeGet() is called by ASF when a client invokes
     * the read method for the property 'AddressType'. The onAddressTypeGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    virtual void onAddressTypeGet(const ::boost::shared_ptr< AddressTypeGet >& payload);

    /**
     * Sends back the update to a previous onAddressTypeGet().
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressTypeGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAddressTypeGetUpdate(uint8 addressType, act_t act = 0);

    /**
     * Set the value of the property 'AddressType' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    void setAddressType(uint8 addressType);

    /**
     * Returns the current value of the property 'AddressType'.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    uint8 getAddressType() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressTypeUpdate().
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     */
    void sendAddressTypeUpdate();

    // property 'Address'

    /**
     * The method onAddressGet() is called by ASF when a client invokes the
     * read method for the property 'Address'. The onAddressGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    virtual void onAddressGet(const ::boost::shared_ptr< AddressGet >& payload);

    /**
     * Sends back the update to a previous onAddressGet().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAddressGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAddressGetUpdate(const ::std::string& address, act_t act = 0);

    /**
     * Set the value of the property 'Address' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void setAddress(const ::std::string& address);

    /**
     * Returns the current value of the property 'Address'.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    const ::std::string& getAddress() const;

    /**
     * Returns the current value of the property 'Address' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAddressUpdate() method.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    ::std::string& getAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAddressUpdate().
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     */
    void sendAddressUpdate();

    // property 'Alias'

    /**
     * The method onAliasGet() is called by ASF when a client invokes the read
     * method for the property 'Alias'. The onAliasGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasGet(const ::boost::shared_ptr< AliasGet >& payload);

    /**
     * Sends back the update to a previous onAliasGet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasGetUpdate(const ::std::string& alias, act_t act = 0);

    /**
     * The method onAliasSet() is called by ASF when a client invokes the
     * write method for the property 'Alias'. The onAliasSet() method set
     * property value to the given parameter Alias by default. If this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    virtual void onAliasSet(const ::boost::shared_ptr< AliasSet >& payload);

    /**
     * Sends back the update to a previous onAliasSet().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAliasSet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAliasSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Alias' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void setAlias(const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias'.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    const ::std::string& getAlias() const;

    /**
     * Returns the current value of the property 'Alias' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendAliasUpdate() method.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    ::std::string& getAliasMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAliasUpdate().
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasUpdate();

    // property 'AdvertisingTimeout'

    /**
     * The method onAdvertisingTimeoutGet() is called by ASF when a client
     * invokes the read method for the property 'AdvertisingTimeout'. The
     * onAdvertisingTimeoutGet() method returns by default the current
     * property value to the caller. In case this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    virtual void onAdvertisingTimeoutGet(const ::boost::shared_ptr< AdvertisingTimeoutGet >& payload);

    /**
     * Sends back the update to a previous onAdvertisingTimeoutGet().
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAdvertisingTimeoutGet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAdvertisingTimeoutGetUpdate(uint8 advertisingTimeout, act_t act = 0);

    /**
     * The method onAdvertisingTimeoutSet() is called by ASF when a client
     * invokes the write method for the property 'AdvertisingTimeout'. The
     * onAdvertisingTimeoutSet() method set property value to the given
     * parameter AdvertisingTimeout by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    virtual void onAdvertisingTimeoutSet(const ::boost::shared_ptr< AdvertisingTimeoutSet >& payload);

    /**
     * Sends back the update to a previous onAdvertisingTimeoutSet().
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of
     * onAdvertisingTimeoutSet(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendAdvertisingTimeoutSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'AdvertisingTimeout' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    void setAdvertisingTimeout(uint8 advertisingTimeout);

    /**
     * Returns the current value of the property 'AdvertisingTimeout'.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    uint8 getAdvertisingTimeout() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAdvertisingTimeoutUpdate().
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    void sendAdvertisingTimeoutUpdate();

    // property 'DiscoverableMode'

    /**
     * The method onDiscoverableModeGet() is called by ASF when a client
     * invokes the read method for the property 'DiscoverableMode'. The
     * onDiscoverableModeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableModeGet(const ::boost::shared_ptr< DiscoverableModeGet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableModeGet().
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDiscoverableModeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoverableModeGetUpdate(uint8 discoverableMode, act_t act = 0);

    /**
     * The method onDiscoverableModeSet() is called by ASF when a client
     * invokes the write method for the property 'DiscoverableMode'. The
     * onDiscoverableModeSet() method set property value to the given
     * parameter DiscoverableMode by default. If this default behavior doesn't
     * match your needs feel free to override this method.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    virtual void onDiscoverableModeSet(const ::boost::shared_ptr< DiscoverableModeSet >& payload);

    /**
     * Sends back the update to a previous onDiscoverableModeSet().
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDiscoverableModeSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDiscoverableModeSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'DiscoverableMode' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    void setDiscoverableMode(uint8 discoverableMode);

    /**
     * Returns the current value of the property 'DiscoverableMode'.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    uint8 getDiscoverableMode() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDiscoverableModeUpdate().
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    void sendDiscoverableModeUpdate();

    // property 'AdvertisingData'

    /**
     * The method onAdvertisingDataGet() is called by ASF when a client
     * invokes the read method for the property 'AdvertisingData'. The
     * onAdvertisingDataGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    virtual void onAdvertisingDataGet(const ::boost::shared_ptr< AdvertisingDataGet >& payload);

    /**
     * Sends back the update to a previous onAdvertisingDataGet().
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAdvertisingDataGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAdvertisingDataGetUpdate(const ::std::vector< uint8 >& advertisingData, act_t act = 0);

    /**
     * The method onAdvertisingDataSet() is called by ASF when a client
     * invokes the write method for the property 'AdvertisingData'. The
     * onAdvertisingDataSet() method set property value to the given parameter
     * AdvertisingData by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    virtual void onAdvertisingDataSet(const ::boost::shared_ptr< AdvertisingDataSet >& payload);

    /**
     * Sends back the update to a previous onAdvertisingDataSet().
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAdvertisingDataSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAdvertisingDataSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'AdvertisingData' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    void setAdvertisingData(const ::std::vector< uint8 >& advertisingData);

    /**
     * Returns the current value of the property 'AdvertisingData'.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getAdvertisingData() const;

    /**
     * Returns the current value of the property 'AdvertisingData' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendAdvertisingDataUpdate() method.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getAdvertisingDataMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAdvertisingDataUpdate().
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    void sendAdvertisingDataUpdate();

    // property 'AdvertiseEnable'

    /**
     * The method onAdvertiseEnableGet() is called by ASF when a client
     * invokes the read method for the property 'AdvertiseEnable'. The
     * onAdvertiseEnableGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    virtual void onAdvertiseEnableGet(const ::boost::shared_ptr< AdvertiseEnableGet >& payload);

    /**
     * Sends back the update to a previous onAdvertiseEnableGet().
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAdvertiseEnableGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAdvertiseEnableGetUpdate(bool advertiseEnable, act_t act = 0);

    /**
     * The method onAdvertiseEnableSet() is called by ASF when a client
     * invokes the write method for the property 'AdvertiseEnable'. The
     * onAdvertiseEnableSet() method set property value to the given parameter
     * AdvertiseEnable by default. If this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    virtual void onAdvertiseEnableSet(const ::boost::shared_ptr< AdvertiseEnableSet >& payload);

    /**
     * Sends back the update to a previous onAdvertiseEnableSet().
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAdvertiseEnableSet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAdvertiseEnableSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'AdvertiseEnable' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    void setAdvertiseEnable(bool advertiseEnable);

    /**
     * Returns the current value of the property 'AdvertiseEnable'.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    bool getAdvertiseEnable() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAdvertiseEnableUpdate().
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    void sendAdvertiseEnableUpdate();

    // method 'CreateLeDevice'

    /**
     * The method onCreateLeDevice() is called by ASF when a client invokes
     * the method 'CreateLeDevice'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCreateLeDevice() or sendCreateLeDeviceError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'CreateLeDevice'</b>:
     *
     * If the meaning of "CreateLeDevice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateLeDeviceRequest (const ::boost::shared_ptr< CreateLeDeviceRequest >& request) = 0;

    /**
     * The method sendCreateLeDeviceResponse() sends a response of a previous
     * method invocation of 'CreateLeDevice' back to the client.
     *
     * <b>Documentation of 'CreateLeDevice'</b>:
     *
     * If the meaning of "CreateLeDevice" isn't clear, then there should be a description here.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateLeDevice(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateLeDeviceResponse (const ::std::string& device, act_t act = 0);

    /**
     * The method sendCreateLeDeviceError() sends an error response of a
     * previous method invocation of 'CreateLeDevice' back to the client.
     *
     * <b>Documentation of 'CreateLeDevice'</b>:
     *
     * If the meaning of "CreateLeDevice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateLeDevice(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateLeDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RemoveLeDevice'

    /**
     * The method onRemoveLeDevice() is called by ASF when a client invokes
     * the method 'RemoveLeDevice'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRemoveLeDevice() or sendRemoveLeDeviceError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RemoveLeDevice'</b>:
     *
     * If the meaning of "RemoveLeDevice" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveLeDeviceRequest (const ::boost::shared_ptr< RemoveLeDeviceRequest >& request) = 0;

    /**
     * The method sendRemoveLeDeviceResponse() sends a response of a previous
     * method invocation of 'RemoveLeDevice' back to the client.
     *
     * <b>Documentation of 'RemoveLeDevice'</b>:
     *
     * If the meaning of "RemoveLeDevice" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveLeDevice(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveLeDeviceResponse (act_t act = 0);

    /**
     * The method sendRemoveLeDeviceError() sends an error response of a
     * previous method invocation of 'RemoveLeDevice' back to the client.
     *
     * <b>Documentation of 'RemoveLeDevice'</b>:
     *
     * If the meaning of "RemoveLeDevice" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveLeDevice(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoveLeDeviceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    AddressTypeUpdate _AddressTypeProperty;

    AddressUpdate _AddressProperty;

    AliasUpdate _AliasProperty;

    AdvertisingTimeoutUpdate _AdvertisingTimeoutProperty;

    DiscoverableModeUpdate _DiscoverableModeProperty;

    AdvertisingDataUpdate _AdvertisingDataProperty;

    AdvertiseEnableUpdate _AdvertiseEnableProperty;

    friend class LE_Adapter1StubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace LE_Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_ADAPTER1STUB_H
