/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_LE_ADAPTER1PROXY_H
#define ORG_BLUEZ_LE_ADAPTER1PROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/LE_Adapter1.h"
#include <dbus/dbus.h>
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace LE_Adapter1 {

class LE_Adapter1Proxy;

class AddressCallbackIF {
public:
    virtual ~AddressCallbackIF() {}

    virtual void onAddressError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressError >& error) = 0;

    virtual void onAddressUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressUpdate >& update) = 0;
};

class AddressTypeCallbackIF {
public:
    virtual ~AddressTypeCallbackIF() {}

    virtual void onAddressTypeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeError >& error) = 0;

    virtual void onAddressTypeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AddressTypeUpdate >& update) = 0;
};

class AdvertiseEnableCallbackIF {
public:
    virtual ~AdvertiseEnableCallbackIF() {}

    virtual void onAdvertiseEnableError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableError >& error) = 0;

    virtual void onAdvertiseEnableUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertiseEnableUpdate >& update) = 0;
};

class AdvertisingDataCallbackIF {
public:
    virtual ~AdvertisingDataCallbackIF() {}

    virtual void onAdvertisingDataError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataError >& error) = 0;

    virtual void onAdvertisingDataUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingDataUpdate >& update) = 0;
};

class AdvertisingTimeoutCallbackIF {
public:
    virtual ~AdvertisingTimeoutCallbackIF() {}

    virtual void onAdvertisingTimeoutError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutError >& error) = 0;

    virtual void onAdvertisingTimeoutUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AdvertisingTimeoutUpdate >& update) = 0;
};

class AliasCallbackIF {
public:
    virtual ~AliasCallbackIF() {}

    virtual void onAliasError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasError >& error) = 0;

    virtual void onAliasUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< AliasUpdate >& update) = 0;
};

class CreateLeDeviceCallbackIF {
public:
    virtual ~CreateLeDeviceCallbackIF() {}

    virtual void onCreateLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceError >& error) = 0;

    virtual void onCreateLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< CreateLeDeviceResponse >& response) = 0;
};

class DiscoverableModeCallbackIF {
public:
    virtual ~DiscoverableModeCallbackIF() {}

    virtual void onDiscoverableModeError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeError >& error) = 0;

    virtual void onDiscoverableModeUpdate(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< DiscoverableModeUpdate >& update) = 0;
};

class LeAdapterInitializationCallbackIF {
public:
    virtual ~LeAdapterInitializationCallbackIF() {}

    virtual void onLeAdapterInitializationError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationError >& error) = 0;

    virtual void onLeAdapterInitializationSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeAdapterInitializationSignal >& signal) = 0;
};

class LeDeviceCreatedCallbackIF {
public:
    virtual ~LeDeviceCreatedCallbackIF() {}

    virtual void onLeDeviceCreatedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedError >& error) = 0;

    virtual void onLeDeviceCreatedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceCreatedSignal >& signal) = 0;
};

class LeDeviceRemovedCallbackIF {
public:
    virtual ~LeDeviceRemovedCallbackIF() {}

    virtual void onLeDeviceRemovedError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedError >& error) = 0;

    virtual void onLeDeviceRemovedSignal(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< LeDeviceRemovedSignal >& signal) = 0;
};

class RemoveLeDeviceCallbackIF {
public:
    virtual ~RemoveLeDeviceCallbackIF() {}

    virtual void onRemoveLeDeviceError(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceError >& error) = 0;

    virtual void onRemoveLeDeviceResponse(const ::boost::shared_ptr< LE_Adapter1Proxy >& proxy, const ::boost::shared_ptr< RemoveLeDeviceResponse >& response) = 0;
};


/**
 * LE_Adapter1Proxy is the client side representation of the D-Bus service
 * interface 'org.bluez.LE_Adapter1' (specified in file ble_adapter.xml).
 *
 * If the meaning of "org.bluez.LE_Adapter1" isn't clear, then there should be a description here.
 */
class LE_Adapter1Proxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of LE_Adapter1Proxy.
     */
    static ::boost::shared_ptr< LE_Adapter1Proxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of LE_Adapter1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< LE_Adapter1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of LE_Adapter1Proxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< LE_Adapter1Proxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< LE_Adapter1Proxy > proxyNew(new LE_Adapter1Proxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~LE_Adapter1Proxy ();


    // Signal 'LeAdapterInitialization'

    /**
     * Notify on the signal 'LeAdapterInitialization'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'LeAdapterInitialization'</b>:
     *
     * If the meaning of "LeAdapterInitialization" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLeAdapterInitializationRegister(LeAdapterInitializationCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'LeAdapterInitialization'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'LeAdapterInitialization'</b>:
     *
     * If the meaning of "LeAdapterInitialization" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLeAdapterInitializationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLeAdapterInitializationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'LeAdapterInitialization'.
     */
    void sendLeAdapterInitializationDeregisterAll () const;

    // Signal 'LeDeviceCreated'

    /**
     * Notify on the signal 'LeDeviceCreated'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'LeDeviceCreated'</b>:
     *
     * If the meaning of "LeDeviceCreated" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLeDeviceCreatedRegister(LeDeviceCreatedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'LeDeviceCreated'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'LeDeviceCreated'</b>:
     *
     * If the meaning of "LeDeviceCreated" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLeDeviceCreatedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLeDeviceCreatedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'LeDeviceCreated'.
     */
    void sendLeDeviceCreatedDeregisterAll () const;

    // Signal 'LeDeviceRemoved'

    /**
     * Notify on the signal 'LeDeviceRemoved'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'LeDeviceRemoved'</b>:
     *
     * If the meaning of "LeDeviceRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendLeDeviceRemovedRegister(LeDeviceRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'LeDeviceRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'LeDeviceRemoved'</b>:
     *
     * If the meaning of "LeDeviceRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendLeDeviceRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendLeDeviceRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'LeDeviceRemoved'.
     */
    void sendLeDeviceRemovedDeregisterAll () const;


    // Property 'AddressType'

    /**
     * Notify on the property 'AddressType'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressTypeRegister(AddressTypeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AddressType'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressTypeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressTypeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AddressType'.
     */
    void sendAddressTypeDeregisterAll() const;

    /**
     * Request the value of the property 'AddressType' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AddressType'</b>:
     *
     * If the meaning of "AddressType" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressTypeGet(AddressTypeCallbackIF& cb);


    /**
     * Returns the current value of the property 'AddressType' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAddressType() returns true.
     *
     * @return the previously received value of the property 'AddressType'.
     */
    uint8 getAddressType() const;

    /**
     * Determines whether a status message for the property 'AddressType' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddressType() const;

    // Property 'Address'

    /**
     * Notify on the property 'Address'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressRegister(AddressCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Address'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAddressRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAddressDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Address'.
     */
    void sendAddressDeregisterAll() const;

    /**
     * Request the value of the property 'Address' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Address'</b>:
     *
     * If the meaning of "Address" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAddressGet(AddressCallbackIF& cb);


    /**
     * Returns the current value of the property 'Address' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAddress()
     * returns true.
     *
     * @return the previously received value of the property 'Address'.
     */
    const ::std::string& getAddress() const;

    /**
     * Determines whether a status message for the property 'Address' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAddress() const;

    // Property 'Alias'

    /**
     * Notify on the property 'Alias'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasRegister(AliasCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Alias'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAliasRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAliasDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Alias'.
     */
    void sendAliasDeregisterAll() const;

    /**
     * Request the value of the property 'Alias' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasGet(AliasCallbackIF& cb);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * @deprecated use the sendAliasSet(AliasCallbackIF& cb, const
     * ::std::string& alias) method instead.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     */
    void sendAliasSet(const ::std::string& alias);

    /**
     * Set the value of the property 'Alias'. This method sends a Set message
     * to the D-Bus server.
     *
     * <b>Documentation of 'Alias'</b>:
     *
     * If the meaning of "Alias" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias);

    /**
     * Returns the current value of the property 'Alias' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasAlias()
     * returns true.
     *
     * @return the previously received value of the property 'Alias'.
     */
    const ::std::string& getAlias() const;

    /**
     * Determines whether a status message for the property 'Alias' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAlias() const;

    // Property 'AdvertisingTimeout'

    /**
     * Notify on the property 'AdvertisingTimeout'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingTimeoutRegister(AdvertisingTimeoutCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AdvertisingTimeout'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAdvertisingTimeoutRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAdvertisingTimeoutDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AdvertisingTimeout'.
     */
    void sendAdvertisingTimeoutDeregisterAll() const;

    /**
     * Request the value of the property 'AdvertisingTimeout' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingTimeoutGet(AdvertisingTimeoutCallbackIF& cb);

    /**
     * Set the value of the property 'AdvertisingTimeout'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the
     * sendAdvertisingTimeoutSet(AdvertisingTimeoutCallbackIF& cb, uint8
     * advertisingTimeout) method instead.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     */
    void sendAdvertisingTimeoutSet(uint8 advertisingTimeout);

    /**
     * Set the value of the property 'AdvertisingTimeout'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertisingTimeout'</b>:
     *
     * If the meaning of "AdvertisingTimeout" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingTimeoutSet(AdvertisingTimeoutCallbackIF& cb, uint8 advertisingTimeout);

    /**
     * Returns the current value of the property 'AdvertisingTimeout' (as
     * known by the proxy). This method is only allowed to be called when a
     * status message for this property was received before. Otherwise the
     * behavior of this method is undefined. It is safe to call this method
     * when hasAdvertisingTimeout() returns true.
     *
     * @return the previously received value of the property 'AdvertisingTimeout'.
     */
    uint8 getAdvertisingTimeout() const;

    /**
     * Determines whether a status message for the property
     * 'AdvertisingTimeout' was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAdvertisingTimeout() const;

    // Property 'DiscoverableMode'

    /**
     * Notify on the property 'DiscoverableMode'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableModeRegister(DiscoverableModeCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'DiscoverableMode'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDiscoverableModeRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDiscoverableModeDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'DiscoverableMode'.
     */
    void sendDiscoverableModeDeregisterAll() const;

    /**
     * Request the value of the property 'DiscoverableMode' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableModeGet(DiscoverableModeCallbackIF& cb);

    /**
     * Set the value of the property 'DiscoverableMode'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendDiscoverableModeSet(DiscoverableModeCallbackIF&
     * cb, uint8 discoverableMode) method instead.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     */
    void sendDiscoverableModeSet(uint8 discoverableMode);

    /**
     * Set the value of the property 'DiscoverableMode'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'DiscoverableMode'</b>:
     *
     * If the meaning of "DiscoverableMode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDiscoverableModeSet(DiscoverableModeCallbackIF& cb, uint8 discoverableMode);

    /**
     * Returns the current value of the property 'DiscoverableMode' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDiscoverableMode() returns true.
     *
     * @return the previously received value of the property 'DiscoverableMode'.
     */
    uint8 getDiscoverableMode() const;

    /**
     * Determines whether a status message for the property 'DiscoverableMode'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDiscoverableMode() const;

    // Property 'AdvertisingData'

    /**
     * Notify on the property 'AdvertisingData'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingDataRegister(AdvertisingDataCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AdvertisingData'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAdvertisingDataRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAdvertisingDataDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AdvertisingData'.
     */
    void sendAdvertisingDataDeregisterAll() const;

    /**
     * Request the value of the property 'AdvertisingData' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingDataGet(AdvertisingDataCallbackIF& cb);

    /**
     * Set the value of the property 'AdvertisingData'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendAdvertisingDataSet(AdvertisingDataCallbackIF&
     * cb, const ::std::vector< uint8 >& advertisingData) method instead.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     */
    void sendAdvertisingDataSet(const ::std::vector< uint8 >& advertisingData);

    /**
     * Set the value of the property 'AdvertisingData'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertisingData'</b>:
     *
     * If the meaning of "AdvertisingData" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertisingDataSet(AdvertisingDataCallbackIF& cb, const ::std::vector< uint8 >& advertisingData);

    /**
     * Returns the current value of the property 'AdvertisingData' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAdvertisingData() returns true.
     *
     * @return the previously received value of the property 'AdvertisingData'.
     */
    const ::std::vector< uint8 >& getAdvertisingData() const;

    /**
     * Determines whether a status message for the property 'AdvertisingData'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAdvertisingData() const;

    // Property 'AdvertiseEnable'

    /**
     * Notify on the property 'AdvertiseEnable'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertiseEnableRegister(AdvertiseEnableCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'AdvertiseEnable'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendAdvertiseEnableRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendAdvertiseEnableDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'AdvertiseEnable'.
     */
    void sendAdvertiseEnableDeregisterAll() const;

    /**
     * Request the value of the property 'AdvertiseEnable' from the D-Bus
     * server. This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertiseEnableGet(AdvertiseEnableCallbackIF& cb);

    /**
     * Set the value of the property 'AdvertiseEnable'. This method sends a
     * Set message to the D-Bus server.
     *
     * @deprecated use the sendAdvertiseEnableSet(AdvertiseEnableCallbackIF&
     * cb, bool advertiseEnable) method instead.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     */
    void sendAdvertiseEnableSet(bool advertiseEnable);

    /**
     * Set the value of the property 'AdvertiseEnable'. This method sends a
     * Set message to the D-Bus server.
     *
     * <b>Documentation of 'AdvertiseEnable'</b>:
     *
     * If the meaning of "AdvertiseEnable" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Set message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAdvertiseEnableSet(AdvertiseEnableCallbackIF& cb, bool advertiseEnable);

    /**
     * Returns the current value of the property 'AdvertiseEnable' (as known
     * by the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasAdvertiseEnable() returns true.
     *
     * @return the previously received value of the property 'AdvertiseEnable'.
     */
    bool getAdvertiseEnable() const;

    /**
     * Determines whether a status message for the property 'AdvertiseEnable'
     * was received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasAdvertiseEnable() const;


    // Method 'CreateLeDevice'

    /**
     * Call the method 'CreateLeDevice'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateLeDevice'</b>:
     *
     * If the meaning of "CreateLeDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param address If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateLeDeviceRequest(CreateLeDeviceCallbackIF& cb, const ::std::string& address) const;

    // Method 'RemoveLeDevice'

    /**
     * Call the method 'RemoveLeDevice'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RemoveLeDevice'</b>:
     *
     * If the meaning of "RemoveLeDevice" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoveLeDeviceRequest(RemoveLeDeviceCallbackIF& cb, const ::std::string& device) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    LE_Adapter1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'AddressType'

    ::asf::core::nullable< AddressTypeUpdate > _addressType;

    // Property 'Address'

    ::asf::core::nullable< AddressUpdate > _address;

    // Property 'Alias'

    ::asf::core::nullable< AliasUpdate > _alias;

    // Property 'AdvertisingTimeout'

    ::asf::core::nullable< AdvertisingTimeoutUpdate > _advertisingTimeout;

    // Property 'DiscoverableMode'

    ::asf::core::nullable< DiscoverableModeUpdate > _discoverableMode;

    // Property 'AdvertisingData'

    ::asf::core::nullable< AdvertisingDataUpdate > _advertisingData;

    // Property 'AdvertiseEnable'

    ::asf::core::nullable< AdvertiseEnableUpdate > _advertiseEnable;

    DECLARE_CLASS_LOGGER();

    friend class LE_Adapter1ProxyCallback;
};

} // namespace LE_Adapter1
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_LE_ADAPTER1PROXY_H
