/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/LE_Adapter1.h"
#include "org/bluez/LE_Adapter1DBus.h"
#include "org/bluez/LE_Adapter1Json.h"
#include "org/bluez/LE_Adapter1Proxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace LE_Adapter1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/LE_Adapter1", LE_Adapter1Proxy);

class LE_Adapter1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    LE_Adapter1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< LE_Adapter1Proxy >& proxyShared = ::boost::static_pointer_cast< LE_Adapter1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_LeAdapterInitialization:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LeAdapterInitializationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LeAdapterInitialization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LeAdapterInitializationSignal> payload = ::boost::static_pointer_cast<LeAdapterInitializationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LeAdapterInitializationCallbackIF*) _callback)->onLeAdapterInitializationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LeDeviceCreated:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LeDeviceCreatedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LeDeviceCreated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LeDeviceCreatedSignal> payload = ::boost::static_pointer_cast<LeDeviceCreatedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LeDeviceCreatedCallbackIF*) _callback)->onLeDeviceCreatedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_LeDeviceRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), LeDeviceRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "LeDeviceRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<LeDeviceRemovedSignal> payload = ::boost::static_pointer_cast<LeDeviceRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((LeDeviceRemovedCallbackIF*) _callback)->onLeDeviceRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_AddressType:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressTypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AddressType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressTypeError> payload = ::boost::static_pointer_cast<AddressTypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressTypeCallbackIF*) _callback)->onAddressTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressTypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AddressType", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressTypeUpdate> payload = ::boost::static_pointer_cast<AddressTypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressTypeCallbackIF*) _callback)->onAddressTypeUpdate(proxyShared, payload);
                        proxyShared->_addressType = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Address:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressError> payload = ::boost::static_pointer_cast<AddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressCallbackIF*) _callback)->onAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressUpdate> payload = ::boost::static_pointer_cast<AddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressCallbackIF*) _callback)->onAddressUpdate(proxyShared, payload);
                        proxyShared->_address = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Alias:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasError> payload = ::boost::static_pointer_cast<AliasError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AliasCallbackIF*) _callback)->onAliasError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasUpdate> payload = ::boost::static_pointer_cast<AliasUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AliasCallbackIF*) _callback)->onAliasUpdate(proxyShared, payload);
                        proxyShared->_alias = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AdvertisingTimeout:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertisingTimeoutError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertisingTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertisingTimeoutError> payload = ::boost::static_pointer_cast<AdvertisingTimeoutError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AdvertisingTimeoutCallbackIF*) _callback)->onAdvertisingTimeoutError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertisingTimeoutUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertisingTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertisingTimeoutUpdate> payload = ::boost::static_pointer_cast<AdvertisingTimeoutUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AdvertisingTimeoutCallbackIF*) _callback)->onAdvertisingTimeoutUpdate(proxyShared, payload);
                        proxyShared->_advertisingTimeout = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DiscoverableMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DiscoverableMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableModeError> payload = ::boost::static_pointer_cast<DiscoverableModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DiscoverableModeCallbackIF*) _callback)->onDiscoverableModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DiscoverableMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableModeUpdate> payload = ::boost::static_pointer_cast<DiscoverableModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DiscoverableModeCallbackIF*) _callback)->onDiscoverableModeUpdate(proxyShared, payload);
                        proxyShared->_discoverableMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AdvertisingData:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertisingDataError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertisingData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertisingDataError> payload = ::boost::static_pointer_cast<AdvertisingDataError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AdvertisingDataCallbackIF*) _callback)->onAdvertisingDataError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertisingDataUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertisingData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertisingDataUpdate> payload = ::boost::static_pointer_cast<AdvertisingDataUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AdvertisingDataCallbackIF*) _callback)->onAdvertisingDataUpdate(proxyShared, payload);
                        proxyShared->_advertisingData = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AdvertiseEnable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertiseEnableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertiseEnable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertiseEnableError> payload = ::boost::static_pointer_cast<AdvertiseEnableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AdvertiseEnableCallbackIF*) _callback)->onAdvertiseEnableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdvertiseEnableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdvertiseEnable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AdvertiseEnableUpdate> payload = ::boost::static_pointer_cast<AdvertiseEnableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AdvertiseEnableCallbackIF*) _callback)->onAdvertiseEnableUpdate(proxyShared, payload);
                        proxyShared->_advertiseEnable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_CreateLeDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateLeDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateLeDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateLeDeviceError> payload = ::boost::static_pointer_cast<CreateLeDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateLeDeviceCallbackIF*) _callback)->onCreateLeDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateLeDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateLeDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateLeDeviceResponse> payload = ::boost::static_pointer_cast<CreateLeDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateLeDeviceCallbackIF*) _callback)->onCreateLeDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoveLeDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveLeDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveLeDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveLeDeviceError> payload = ::boost::static_pointer_cast<RemoveLeDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveLeDeviceCallbackIF*) _callback)->onRemoveLeDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveLeDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveLeDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveLeDeviceResponse> payload = ::boost::static_pointer_cast<RemoveLeDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveLeDeviceCallbackIF*) _callback)->onRemoveLeDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_LeAdapterInitialization: {
                ::boost::shared_ptr< LeAdapterInitializationError > payload = ::boost::shared_ptr< LeAdapterInitializationError >
                (new LeAdapterInitializationError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LeAdapterInitialization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LeAdapterInitializationCallbackIF*) _callback)->onLeAdapterInitializationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LeDeviceCreated: {
                ::boost::shared_ptr< LeDeviceCreatedError > payload = ::boost::shared_ptr< LeDeviceCreatedError >
                (new LeDeviceCreatedError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LeDeviceCreated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LeDeviceCreatedCallbackIF*) _callback)->onLeDeviceCreatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_LeDeviceRemoved: {
                ::boost::shared_ptr< LeDeviceRemovedError > payload = ::boost::shared_ptr< LeDeviceRemovedError >
                (new LeDeviceRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "LeDeviceRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((LeDeviceRemovedCallbackIF*) _callback)->onLeDeviceRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AddressType: {
                ::boost::shared_ptr< AddressTypeError > payload = ::boost::shared_ptr< AddressTypeError >
                (new AddressTypeError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AddressType", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressTypeCallbackIF*) _callback)->onAddressTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Address: {
                ::boost::shared_ptr< AddressError > payload = ::boost::shared_ptr< AddressError >
                (new AddressError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Address", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressCallbackIF*) _callback)->onAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Alias: {
                ::boost::shared_ptr< AliasError > payload = ::boost::shared_ptr< AliasError >
                (new AliasError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Alias", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AliasCallbackIF*) _callback)->onAliasError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AdvertisingTimeout: {
                ::boost::shared_ptr< AdvertisingTimeoutError > payload = ::boost::shared_ptr< AdvertisingTimeoutError >
                (new AdvertisingTimeoutError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AdvertisingTimeout", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AdvertisingTimeoutCallbackIF*) _callback)->onAdvertisingTimeoutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DiscoverableMode: {
                ::boost::shared_ptr< DiscoverableModeError > payload = ::boost::shared_ptr< DiscoverableModeError >
                (new DiscoverableModeError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DiscoverableMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiscoverableModeCallbackIF*) _callback)->onDiscoverableModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AdvertisingData: {
                ::boost::shared_ptr< AdvertisingDataError > payload = ::boost::shared_ptr< AdvertisingDataError >
                (new AdvertisingDataError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AdvertisingData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AdvertisingDataCallbackIF*) _callback)->onAdvertisingDataError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AdvertiseEnable: {
                ::boost::shared_ptr< AdvertiseEnableError > payload = ::boost::shared_ptr< AdvertiseEnableError >
                (new AdvertiseEnableError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AdvertiseEnable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AdvertiseEnableCallbackIF*) _callback)->onAdvertiseEnableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateLeDevice: {
                ::boost::shared_ptr< CreateLeDeviceError > payload = ::boost::shared_ptr< CreateLeDeviceError >
                (new CreateLeDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateLeDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateLeDeviceCallbackIF*) _callback)->onCreateLeDeviceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoveLeDevice: {
                ::boost::shared_ptr< RemoveLeDeviceError > payload = ::boost::shared_ptr< RemoveLeDeviceError >
                (new RemoveLeDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service LE_Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveLeDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<LE_Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<LE_Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveLeDeviceCallbackIF*) _callback)->onRemoveLeDeviceError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& LE_Adapter1ProxyCallback::_logger (LE_Adapter1Proxy::_logger);

LE_Adapter1Proxy::LE_Adapter1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.LE_Adapter1", serviceAvailable, _logger) {
}

LE_Adapter1Proxy::~LE_Adapter1Proxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< LE_Adapter1Proxy > LE_Adapter1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<LE_Adapter1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< LE_Adapter1Proxy > proxyNew(new LE_Adapter1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t LE_Adapter1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t LE_Adapter1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::clearAllProperties ()
{
    _addressType = ::asf::core::nullable< AddressTypeUpdate >();
    _address = ::asf::core::nullable< AddressUpdate >();
    _alias = ::asf::core::nullable< AliasUpdate >();
    _advertisingTimeout = ::asf::core::nullable< AdvertisingTimeoutUpdate >();
    _discoverableMode = ::asf::core::nullable< DiscoverableModeUpdate >();
    _advertisingData = ::asf::core::nullable< AdvertisingDataUpdate >();
    _advertiseEnable = ::asf::core::nullable< AdvertiseEnableUpdate >();
}

void LE_Adapter1Proxy::sendDeregisterAll () const
{
    sendAddressTypeDeregisterAll();
    sendAddressDeregisterAll();
    sendAliasDeregisterAll();
    sendAdvertisingTimeoutDeregisterAll();
    sendDiscoverableModeDeregisterAll();
    sendAdvertisingDataDeregisterAll();
    sendAdvertiseEnableDeregisterAll();
    sendLeAdapterInitializationDeregisterAll();
    sendLeDeviceCreatedDeregisterAll();
    sendLeDeviceRemovedDeregisterAll();
}

act_t LE_Adapter1Proxy::sendLeAdapterInitializationRegister(LeAdapterInitializationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LeAdapterInitialization");
    act_t act = addSignalCallback(ID_LeAdapterInitialization, "LeAdapterInitialization", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LeAdapterInitialization", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendLeAdapterInitializationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LeAdapterInitialization", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LeAdapterInitialization", act, static_cast<int>(rv));
    return rv;
}

void LE_Adapter1Proxy::sendLeAdapterInitializationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LeAdapterInitialization");
    _dbusProxyDelegate->deregisterSignalCallback("LeAdapterInitialization", 0, _dbusDaemonProxy.get(), false);
}

act_t LE_Adapter1Proxy::sendLeDeviceCreatedRegister(LeDeviceCreatedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LeDeviceCreated");
    act_t act = addSignalCallback(ID_LeDeviceCreated, "LeDeviceCreated", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LeDeviceCreated", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendLeDeviceCreatedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LeDeviceCreated", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LeDeviceCreated", act, static_cast<int>(rv));
    return rv;
}

void LE_Adapter1Proxy::sendLeDeviceCreatedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LeDeviceCreated");
    _dbusProxyDelegate->deregisterSignalCallback("LeDeviceCreated", 0, _dbusDaemonProxy.get(), false);
}

act_t LE_Adapter1Proxy::sendLeDeviceRemovedRegister(LeDeviceRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "LeDeviceRemoved");
    act_t act = addSignalCallback(ID_LeDeviceRemoved, "LeDeviceRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "LeDeviceRemoved", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendLeDeviceRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("LeDeviceRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "LeDeviceRemoved", act, static_cast<int>(rv));
    return rv;
}

void LE_Adapter1Proxy::sendLeDeviceRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "LeDeviceRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("LeDeviceRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t LE_Adapter1Proxy::sendAddressTypeRegister(AddressTypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AddressType, "AddressType", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AddressType", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAddressTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AddressType", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AddressType", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAddressTypeGet(AddressTypeCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AddressType, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AddressType", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AddressType", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 LE_Adapter1Proxy::getAddressType() const {
    return _addressType.get().getAddressType();
}

bool LE_Adapter1Proxy::hasAddressType() const {
    return _addressType.hasValue();
}

void LE_Adapter1Proxy::sendAddressTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AddressType");
    _dbusProxyDelegate->deregisterSignalCallback("AddressType", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendAddressRegister(AddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Address, "Address", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Address", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Address", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Address", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAddressGet(AddressCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_Address, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Address", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Address", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& LE_Adapter1Proxy::getAddress() const {
    return _address.get().getAddress();
}

bool LE_Adapter1Proxy::hasAddress() const {
    return _address.hasValue();
}

void LE_Adapter1Proxy::sendAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Address");
    _dbusProxyDelegate->deregisterSignalCallback("Address", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendAliasRegister(AliasCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Alias, "Alias", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAliasDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Alias", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Alias", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAliasGet(AliasCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_Alias, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Alias", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::sendAliasSet(const ::std::string& alias) {
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Alias");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent);
}

act_t LE_Adapter1Proxy::sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_Alias, &cb);
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& LE_Adapter1Proxy::getAlias() const {
    return _alias.get().getAlias();
}

bool LE_Adapter1Proxy::hasAlias() const {
    return _alias.hasValue();
}

void LE_Adapter1Proxy::sendAliasDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Alias");
    _dbusProxyDelegate->deregisterSignalCallback("Alias", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendAdvertisingTimeoutRegister(AdvertisingTimeoutCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AdvertisingTimeout, "AdvertisingTimeout", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AdvertisingTimeout", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAdvertisingTimeoutDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AdvertisingTimeout", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AdvertisingTimeout", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAdvertisingTimeoutGet(AdvertisingTimeoutCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertisingTimeout, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AdvertisingTimeout", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AdvertisingTimeout", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::sendAdvertisingTimeoutSet(uint8 advertisingTimeout) {
    AdvertisingTimeoutSet parameter(advertisingTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AdvertisingTimeout");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertisingTimeout", propertyContent);
}

act_t LE_Adapter1Proxy::sendAdvertisingTimeoutSet(AdvertisingTimeoutCallbackIF& cb, uint8 advertisingTimeout) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertisingTimeout, &cb);
    AdvertisingTimeoutSet parameter(advertisingTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AdvertisingTimeout", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertisingTimeout", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 LE_Adapter1Proxy::getAdvertisingTimeout() const {
    return _advertisingTimeout.get().getAdvertisingTimeout();
}

bool LE_Adapter1Proxy::hasAdvertisingTimeout() const {
    return _advertisingTimeout.hasValue();
}

void LE_Adapter1Proxy::sendAdvertisingTimeoutDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AdvertisingTimeout");
    _dbusProxyDelegate->deregisterSignalCallback("AdvertisingTimeout", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendDiscoverableModeRegister(DiscoverableModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DiscoverableMode, "DiscoverableMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DiscoverableMode", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendDiscoverableModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DiscoverableMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DiscoverableMode", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendDiscoverableModeGet(DiscoverableModeCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_DiscoverableMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DiscoverableMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DiscoverableMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::sendDiscoverableModeSet(uint8 discoverableMode) {
    DiscoverableModeSet parameter(discoverableMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DiscoverableMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DiscoverableMode", propertyContent);
}

act_t LE_Adapter1Proxy::sendDiscoverableModeSet(DiscoverableModeCallbackIF& cb, uint8 discoverableMode) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_DiscoverableMode, &cb);
    DiscoverableModeSet parameter(discoverableMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DiscoverableMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DiscoverableMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint8 LE_Adapter1Proxy::getDiscoverableMode() const {
    return _discoverableMode.get().getDiscoverableMode();
}

bool LE_Adapter1Proxy::hasDiscoverableMode() const {
    return _discoverableMode.hasValue();
}

void LE_Adapter1Proxy::sendDiscoverableModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DiscoverableMode");
    _dbusProxyDelegate->deregisterSignalCallback("DiscoverableMode", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendAdvertisingDataRegister(AdvertisingDataCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AdvertisingData, "AdvertisingData", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AdvertisingData", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAdvertisingDataDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AdvertisingData", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AdvertisingData", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAdvertisingDataGet(AdvertisingDataCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertisingData, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AdvertisingData", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AdvertisingData", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::sendAdvertisingDataSet(const ::std::vector< uint8 >& advertisingData) {
    AdvertisingDataSet parameter(advertisingData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AdvertisingData");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertisingData", propertyContent);
}

act_t LE_Adapter1Proxy::sendAdvertisingDataSet(AdvertisingDataCallbackIF& cb, const ::std::vector< uint8 >& advertisingData) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertisingData, &cb);
    AdvertisingDataSet parameter(advertisingData);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AdvertisingData", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertisingData", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< uint8 >& LE_Adapter1Proxy::getAdvertisingData() const {
    return _advertisingData.get().getAdvertisingData();
}

bool LE_Adapter1Proxy::hasAdvertisingData() const {
    return _advertisingData.hasValue();
}

void LE_Adapter1Proxy::sendAdvertisingDataDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AdvertisingData");
    _dbusProxyDelegate->deregisterSignalCallback("AdvertisingData", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendAdvertiseEnableRegister(AdvertiseEnableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AdvertiseEnable, "AdvertiseEnable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AdvertiseEnable", &cb, act);
    return act;
}

bool LE_Adapter1Proxy::sendAdvertiseEnableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AdvertiseEnable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AdvertiseEnable", act, static_cast<int>(rv));
    return rv;
}

act_t LE_Adapter1Proxy::sendAdvertiseEnableGet(AdvertiseEnableCallbackIF& cb) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertiseEnable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AdvertiseEnable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AdvertiseEnable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void LE_Adapter1Proxy::sendAdvertiseEnableSet(bool advertiseEnable) {
    AdvertiseEnableSet parameter(advertiseEnable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AdvertiseEnable");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertiseEnable", propertyContent);
}

act_t LE_Adapter1Proxy::sendAdvertiseEnableSet(AdvertiseEnableCallbackIF& cb, bool advertiseEnable) {
    LE_Adapter1ProxyCallback* callback = new LE_Adapter1ProxyCallback(ID_AdvertiseEnable, &cb);
    AdvertiseEnableSet parameter(advertiseEnable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AdvertiseEnable", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AdvertiseEnable", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool LE_Adapter1Proxy::getAdvertiseEnable() const {
    return _advertiseEnable.get().getAdvertiseEnable();
}

bool LE_Adapter1Proxy::hasAdvertiseEnable() const {
    return _advertiseEnable.hasValue();
}

void LE_Adapter1Proxy::sendAdvertiseEnableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AdvertiseEnable");
    _dbusProxyDelegate->deregisterSignalCallback("AdvertiseEnable", 0, _dbusDaemonProxy.get(), true);
}

act_t LE_Adapter1Proxy::sendCreateLeDeviceRequest(CreateLeDeviceCallbackIF& cb, const ::std::string& address) const {
    CreateLeDeviceRequest* payload = new CreateLeDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddress(address);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateLeDevice", CreateLeDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateLeDevice, dbusMessage.getUniqueSerial(), "CreateLeDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateLeDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t LE_Adapter1Proxy::sendRemoveLeDeviceRequest(RemoveLeDeviceCallbackIF& cb, const ::std::string& device) const {
    RemoveLeDeviceRequest* payload = new RemoveLeDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoveLeDevice", RemoveLeDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoveLeDevice, dbusMessage.getUniqueSerial(), "RemoveLeDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveLeDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace LE_Adapter1
} // namespace bluez
} // namespace org
