/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_VOICECALLSTUB_H
#define ORG_OFONO_VOICECALLSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCall.h"
#include <map>
#include <string>

namespace org {
namespace ofono {
namespace VoiceCall {

class VoiceCallStubDelegate;

class VoiceCallStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the VoiceCallStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    VoiceCallStub (const std::string& portName);

    /**
     * Create an instance of the VoiceCallStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    VoiceCallStub (const std::string& portName, const std::string& objectPath);

    virtual ~VoiceCallStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Hangup'

    /**
     * The method onHangup() is called by ASF when a client invokes the method
     * 'Hangup'. A subclass has to implement this method and send back a
     * response to the client either with the sendHangup() or
     * sendHangupError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Hangup'</b>:
     *
     * If the meaning of "Hangup" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHangupRequest (const ::boost::shared_ptr< HangupRequest >& request) = 0;

    /**
     * The method sendHangupResponse() sends a response of a previous method
     * invocation of 'Hangup' back to the client.
     *
     * <b>Documentation of 'Hangup'</b>:
     *
     * If the meaning of "Hangup" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHangup(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHangupResponse (act_t act = 0);

    /**
     * The method sendHangupError() sends an error response of a previous
     * method invocation of 'Hangup' back to the client.
     *
     * <b>Documentation of 'Hangup'</b>:
     *
     * If the meaning of "Hangup" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHangup(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHangupError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Answer'

    /**
     * The method onAnswer() is called by ASF when a client invokes the method
     * 'Answer'. A subclass has to implement this method and send back a
     * response to the client either with the sendAnswer() or
     * sendAnswerError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Answer'</b>:
     *
     * If the meaning of "Answer" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAnswerRequest (const ::boost::shared_ptr< AnswerRequest >& request) = 0;

    /**
     * The method sendAnswerResponse() sends a response of a previous method
     * invocation of 'Answer' back to the client.
     *
     * <b>Documentation of 'Answer'</b>:
     *
     * If the meaning of "Answer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAnswer(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAnswerResponse (act_t act = 0);

    /**
     * The method sendAnswerError() sends an error response of a previous
     * method invocation of 'Answer' back to the client.
     *
     * <b>Documentation of 'Answer'</b>:
     *
     * If the meaning of "Answer" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAnswer(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Hold'

    /**
     * The method onHold() is called by ASF when a client invokes the method
     * 'Hold'. A subclass has to implement this method and send back a
     * response to the client either with the sendHold() or sendHoldError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Hold'</b>:
     *
     * If the meaning of "Hold" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHoldRequest (const ::boost::shared_ptr< HoldRequest >& request) = 0;

    /**
     * The method sendHoldResponse() sends a response of a previous method
     * invocation of 'Hold' back to the client.
     *
     * <b>Documentation of 'Hold'</b>:
     *
     * If the meaning of "Hold" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHold(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHoldResponse (act_t act = 0);

    /**
     * The method sendHoldError() sends an error response of a previous method
     * invocation of 'Hold' back to the client.
     *
     * <b>Documentation of 'Hold'</b>:
     *
     * If the meaning of "Hold" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHold(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHoldError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class VoiceCallStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace VoiceCall
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_VOICECALLSTUB_H
