/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCall.h"
#include "org/ofono/VoiceCallDBus.h"
#include "org/ofono/VoiceCallJson.h"
#include "org/ofono/VoiceCallStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace VoiceCall {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/voice_call/created/during/runtime/org/ofono/VoiceCall", VoiceCallStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Hold", 3 },
    { 6, "Answer", 2 },
    { 6, "Hangup", 1 },
    { 13, "GetProperties", 0 },
};


class VoiceCallStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    VoiceCallStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.ofono.VoiceCall"),
          _logger(logger) {}

    virtual ~VoiceCallStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void VoiceCallStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'Hangup'

            LOG_DEBUG_STUB("process method '%s'", "Hangup");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Hangup", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HangupRequest > payload = ::boost::static_pointer_cast<HangupRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onHangupRequest(payload);
            return;
        }
        case 2: {

            // method 'Answer'

            LOG_DEBUG_STUB("process method '%s'", "Answer");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AnswerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Answer", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< AnswerRequest > payload = ::boost::static_pointer_cast<AnswerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onAnswerRequest(payload);
            return;
        }
        case 3: {

            // method 'Hold'

            LOG_DEBUG_STUB("process method '%s'", "Hold");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HoldRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Hold", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HoldRequest > payload = ::boost::static_pointer_cast<HoldRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallStub*>(getStub())->onHoldRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* VoiceCallStubDelegate::introspect() const {
    return     "<interface name=\"org.ofono.VoiceCall\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"Hangup\"/>\n"
            "      <method name=\"Answer\"/>\n"
            "      <method name=\"Hold\"/>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void VoiceCallStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<VoiceCallStub*>(getStub()))->onGetAll (properties);
}

void VoiceCallStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void VoiceCallStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

VoiceCallStub::VoiceCallStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallStub::VoiceCallStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallStub::~VoiceCallStub() {
    delete _stubDelegate;
}

void VoiceCallStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void  VoiceCallStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHangupResponse (act_t act) {
    HangupResponse* payload = new HangupResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Hangup", HangupResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Hangup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHangupError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HangupError* payload = new HangupError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Hangup", HangupError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Hangup", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendAnswerResponse (act_t act) {
    AnswerResponse* payload = new AnswerResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Answer", AnswerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Answer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    AnswerError* payload = new AnswerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Answer", AnswerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Answer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHoldResponse (act_t act) {
    HoldResponse* payload = new HoldResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Hold", HoldResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Hold", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallStub::sendHoldError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HoldError* payload = new HoldError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Hold", HoldError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Hold", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void VoiceCallStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace VoiceCall
} // namespace ofono
} // namespace org
