/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_VOICECALLPROXY_H
#define ORG_OFONO_VOICECALLPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/ofono/VoiceCall.h"
#include <dbus/dbus.h>

namespace org {
namespace ofono {
namespace VoiceCall {

class VoiceCallProxy;

class AnswerCallbackIF {
public:
    virtual ~AnswerCallbackIF() {}

    virtual void onAnswerError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerError >& error) = 0;

    virtual void onAnswerResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< AnswerResponse >& response) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class HangupCallbackIF {
public:
    virtual ~HangupCallbackIF() {}

    virtual void onHangupError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupError >& error) = 0;

    virtual void onHangupResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HangupResponse >& response) = 0;
};

class HoldCallbackIF {
public:
    virtual ~HoldCallbackIF() {}

    virtual void onHoldError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldError >& error) = 0;

    virtual void onHoldResponse(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< HoldResponse >& response) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< VoiceCallProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};


/**
 * VoiceCallProxy is the client side representation of the D-Bus service
 * interface 'org.ofono.VoiceCall' (specified in file
 * handsfree_voice_call.xml).
 *
 * If the meaning of "org.ofono.VoiceCall" isn't clear, then there should be a description here.
 */
class VoiceCallProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of VoiceCallProxy.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of VoiceCallProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of VoiceCallProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< VoiceCallProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< VoiceCallProxy > proxyNew(new VoiceCallProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~VoiceCallProxy ();


    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;



    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'Hangup'

    /**
     * Call the method 'Hangup'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Hangup'</b>:
     *
     * If the meaning of "Hangup" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHangupRequest(HangupCallbackIF& cb) const;

    // Method 'Answer'

    /**
     * Call the method 'Answer'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Answer'</b>:
     *
     * If the meaning of "Answer" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAnswerRequest(AnswerCallbackIF& cb) const;

    // Method 'Hold'

    /**
     * Call the method 'Hold'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Hold'</b>:
     *
     * If the meaning of "Hold" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendHoldRequest(HoldCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    VoiceCallProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class VoiceCallProxyCallback;
};

} // namespace VoiceCall
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_VOICECALLPROXY_H
