/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_VOICECALLMANAGERSTUB_H
#define ORG_OFONO_VOICECALLMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCallManager.h"
#include <map>
#include <string>
#include <vector>

namespace org {
namespace ofono {
namespace VoiceCallManager {

class VoiceCallManagerStubDelegate;

class VoiceCallManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the VoiceCallManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    VoiceCallManagerStub (const std::string& portName);

    /**
     * Create an instance of the VoiceCallManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    VoiceCallManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~VoiceCallManagerStub();

    // signal 'CallAdded'

    /**
     * Raise the signal 'CallAdded' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'CallAdded'</b>:
     *
     * If the meaning of "CallAdded" isn't clear, then there should be a description here.
     */
    void sendCallAddedSignal(const ::std::string& call, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    // signal 'CallRemoved'

    /**
     * Raise the signal 'CallRemoved' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'CallRemoved'</b>:
     *
     * If the meaning of "CallRemoved" isn't clear, then there should be a description here.
     */
    void sendCallRemovedSignal(const ::std::string& path);

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'GetCalls'

    /**
     * The method onGetCalls() is called by ASF when a client invokes the
     * method 'GetCalls'. A subclass has to implement this method and send
     * back a response to the client either with the sendGetCalls() or
     * sendGetCallsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'GetCalls'</b>:
     *
     * If the meaning of "GetCalls" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetCallsRequest (const ::boost::shared_ptr< GetCallsRequest >& request) = 0;

    /**
     * The method sendGetCallsResponse() sends a response of a previous method
     * invocation of 'GetCalls' back to the client.
     *
     * <b>Documentation of 'GetCalls'</b>:
     *
     * If the meaning of "GetCalls" isn't clear, then there should be a description here.
     *
     * @param calls_with_properties If the meaning of "calls_with_properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetCalls(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetCallsResponse (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties, act_t act = 0);

    /**
     * The method sendGetCallsError() sends an error response of a previous
     * method invocation of 'GetCalls' back to the client.
     *
     * <b>Documentation of 'GetCalls'</b>:
     *
     * If the meaning of "GetCalls" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetCalls(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetCallsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Dial'

    /**
     * The method onDial() is called by ASF when a client invokes the method
     * 'Dial'. A subclass has to implement this method and send back a
     * response to the client either with the sendDial() or sendDialError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * If the meaning of "Dial" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDialRequest (const ::boost::shared_ptr< DialRequest >& request) = 0;

    /**
     * The method sendDialResponse() sends a response of a previous method
     * invocation of 'Dial' back to the client.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * If the meaning of "Dial" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDial(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDialResponse (const ::std::string& path, act_t act = 0);

    /**
     * The method sendDialError() sends an error response of a previous method
     * invocation of 'Dial' back to the client.
     *
     * <b>Documentation of 'Dial'</b>:
     *
     * If the meaning of "Dial" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDial(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'MemDial'

    /**
     * The method onMemDial() is called by ASF when a client invokes the
     * method 'MemDial'. A subclass has to implement this method and send back
     * a response to the client either with the sendMemDial() or
     * sendMemDialError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'MemDial'</b>:
     *
     * If the meaning of "MemDial" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onMemDialRequest (const ::boost::shared_ptr< MemDialRequest >& request) = 0;

    /**
     * The method sendMemDialResponse() sends a response of a previous method
     * invocation of 'MemDial' back to the client.
     *
     * <b>Documentation of 'MemDial'</b>:
     *
     * If the meaning of "MemDial" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onMemDial(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendMemDialResponse (const ::std::string& path, act_t act = 0);

    /**
     * The method sendMemDialError() sends an error response of a previous
     * method invocation of 'MemDial' back to the client.
     *
     * <b>Documentation of 'MemDial'</b>:
     *
     * If the meaning of "MemDial" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onMemDial(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendMemDialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Redial'

    /**
     * The method onRedial() is called by ASF when a client invokes the method
     * 'Redial'. A subclass has to implement this method and send back a
     * response to the client either with the sendRedial() or
     * sendRedialError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * If the meaning of "Redial" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRedialRequest (const ::boost::shared_ptr< RedialRequest >& request) = 0;

    /**
     * The method sendRedialResponse() sends a response of a previous method
     * invocation of 'Redial' back to the client.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * If the meaning of "Redial" isn't clear, then there should be a description here.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRedial(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRedialResponse (const ::std::string& path, act_t act = 0);

    /**
     * The method sendRedialError() sends an error response of a previous
     * method invocation of 'Redial' back to the client.
     *
     * <b>Documentation of 'Redial'</b>:
     *
     * If the meaning of "Redial" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRedial(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRedialError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SwapCalls'

    /**
     * The method onSwapCalls() is called by ASF when a client invokes the
     * method 'SwapCalls'. A subclass has to implement this method and send
     * back a response to the client either with the sendSwapCalls() or
     * sendSwapCallsError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SwapCalls'</b>:
     *
     * If the meaning of "SwapCalls" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSwapCallsRequest (const ::boost::shared_ptr< SwapCallsRequest >& request) = 0;

    /**
     * The method sendSwapCallsResponse() sends a response of a previous
     * method invocation of 'SwapCalls' back to the client.
     *
     * <b>Documentation of 'SwapCalls'</b>:
     *
     * If the meaning of "SwapCalls" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSwapCalls(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSwapCallsResponse (act_t act = 0);

    /**
     * The method sendSwapCallsError() sends an error response of a previous
     * method invocation of 'SwapCalls' back to the client.
     *
     * <b>Documentation of 'SwapCalls'</b>:
     *
     * If the meaning of "SwapCalls" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSwapCalls(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSwapCallsError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReleaseAndAnswer'

    /**
     * The method onReleaseAndAnswer() is called by ASF when a client invokes
     * the method 'ReleaseAndAnswer'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReleaseAndAnswer() or sendReleaseAndAnswerError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'ReleaseAndAnswer'</b>:
     *
     * If the meaning of "ReleaseAndAnswer" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseAndAnswerRequest (const ::boost::shared_ptr< ReleaseAndAnswerRequest >& request) = 0;

    /**
     * The method sendReleaseAndAnswerResponse() sends a response of a
     * previous method invocation of 'ReleaseAndAnswer' back to the client.
     *
     * <b>Documentation of 'ReleaseAndAnswer'</b>:
     *
     * If the meaning of "ReleaseAndAnswer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReleaseAndAnswer(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReleaseAndAnswerResponse (act_t act = 0);

    /**
     * The method sendReleaseAndAnswerError() sends an error response of a
     * previous method invocation of 'ReleaseAndAnswer' back to the client.
     *
     * <b>Documentation of 'ReleaseAndAnswer'</b>:
     *
     * If the meaning of "ReleaseAndAnswer" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReleaseAndAnswer(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReleaseAndAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ReleaseAndSwap'

    /**
     * The method onReleaseAndSwap() is called by ASF when a client invokes
     * the method 'ReleaseAndSwap'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendReleaseAndSwap() or sendReleaseAndSwapError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'ReleaseAndSwap'</b>:
     *
     * If the meaning of "ReleaseAndSwap" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseAndSwapRequest (const ::boost::shared_ptr< ReleaseAndSwapRequest >& request) = 0;

    /**
     * The method sendReleaseAndSwapResponse() sends a response of a previous
     * method invocation of 'ReleaseAndSwap' back to the client.
     *
     * <b>Documentation of 'ReleaseAndSwap'</b>:
     *
     * If the meaning of "ReleaseAndSwap" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onReleaseAndSwap(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReleaseAndSwapResponse (act_t act = 0);

    /**
     * The method sendReleaseAndSwapError() sends an error response of a
     * previous method invocation of 'ReleaseAndSwap' back to the client.
     *
     * <b>Documentation of 'ReleaseAndSwap'</b>:
     *
     * If the meaning of "ReleaseAndSwap" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onReleaseAndSwap(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendReleaseAndSwapError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HoldAndAnswer'

    /**
     * The method onHoldAndAnswer() is called by ASF when a client invokes the
     * method 'HoldAndAnswer'. A subclass has to implement this method and
     * send back a response to the client either with the sendHoldAndAnswer()
     * or sendHoldAndAnswerError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'HoldAndAnswer'</b>:
     *
     * If the meaning of "HoldAndAnswer" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHoldAndAnswerRequest (const ::boost::shared_ptr< HoldAndAnswerRequest >& request) = 0;

    /**
     * The method sendHoldAndAnswerResponse() sends a response of a previous
     * method invocation of 'HoldAndAnswer' back to the client.
     *
     * <b>Documentation of 'HoldAndAnswer'</b>:
     *
     * If the meaning of "HoldAndAnswer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHoldAndAnswer(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHoldAndAnswerResponse (act_t act = 0);

    /**
     * The method sendHoldAndAnswerError() sends an error response of a
     * previous method invocation of 'HoldAndAnswer' back to the client.
     *
     * <b>Documentation of 'HoldAndAnswer'</b>:
     *
     * If the meaning of "HoldAndAnswer" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHoldAndAnswer(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHoldAndAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HangupAll'

    /**
     * The method onHangupAll() is called by ASF when a client invokes the
     * method 'HangupAll'. A subclass has to implement this method and send
     * back a response to the client either with the sendHangupAll() or
     * sendHangupAllError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * If the meaning of "HangupAll" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHangupAllRequest (const ::boost::shared_ptr< HangupAllRequest >& request) = 0;

    /**
     * The method sendHangupAllResponse() sends a response of a previous
     * method invocation of 'HangupAll' back to the client.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * If the meaning of "HangupAll" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHangupAll(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHangupAllResponse (act_t act = 0);

    /**
     * The method sendHangupAllError() sends an error response of a previous
     * method invocation of 'HangupAll' back to the client.
     *
     * <b>Documentation of 'HangupAll'</b>:
     *
     * If the meaning of "HangupAll" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHangupAll(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendHangupAllError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'PrivateChat'

    /**
     * The method onPrivateChat() is called by ASF when a client invokes the
     * method 'PrivateChat'. A subclass has to implement this method and send
     * back a response to the client either with the sendPrivateChat() or
     * sendPrivateChatError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'PrivateChat'</b>:
     *
     * If the meaning of "PrivateChat" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onPrivateChatRequest (const ::boost::shared_ptr< PrivateChatRequest >& request) = 0;

    /**
     * The method sendPrivateChatResponse() sends a response of a previous
     * method invocation of 'PrivateChat' back to the client.
     *
     * <b>Documentation of 'PrivateChat'</b>:
     *
     * If the meaning of "PrivateChat" isn't clear, then there should be a description here.
     *
     * @param calls If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onPrivateChat(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendPrivateChatResponse (const ::std::vector< ::std::string >& calls, act_t act = 0);

    /**
     * The method sendPrivateChatError() sends an error response of a previous
     * method invocation of 'PrivateChat' back to the client.
     *
     * <b>Documentation of 'PrivateChat'</b>:
     *
     * If the meaning of "PrivateChat" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onPrivateChat(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPrivateChatError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CreateMultiparty'

    /**
     * The method onCreateMultiparty() is called by ASF when a client invokes
     * the method 'CreateMultiparty'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendCreateMultiparty() or sendCreateMultipartyError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'CreateMultiparty'</b>:
     *
     * If the meaning of "CreateMultiparty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateMultipartyRequest (const ::boost::shared_ptr< CreateMultipartyRequest >& request) = 0;

    /**
     * The method sendCreateMultipartyResponse() sends a response of a
     * previous method invocation of 'CreateMultiparty' back to the client.
     *
     * <b>Documentation of 'CreateMultiparty'</b>:
     *
     * If the meaning of "CreateMultiparty" isn't clear, then there should be a description here.
     *
     * @param calls If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateMultiparty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateMultipartyResponse (const ::std::vector< ::std::string >& calls, act_t act = 0);

    /**
     * The method sendCreateMultipartyError() sends an error response of a
     * previous method invocation of 'CreateMultiparty' back to the client.
     *
     * <b>Documentation of 'CreateMultiparty'</b>:
     *
     * If the meaning of "CreateMultiparty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateMultiparty(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateMultipartyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'HangupMultiparty'

    /**
     * The method onHangupMultiparty() is called by ASF when a client invokes
     * the method 'HangupMultiparty'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendHangupMultiparty() or sendHangupMultipartyError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'HangupMultiparty'</b>:
     *
     * If the meaning of "HangupMultiparty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onHangupMultipartyRequest (const ::boost::shared_ptr< HangupMultipartyRequest >& request) = 0;

    /**
     * The method sendHangupMultipartyResponse() sends a response of a
     * previous method invocation of 'HangupMultiparty' back to the client.
     *
     * <b>Documentation of 'HangupMultiparty'</b>:
     *
     * If the meaning of "HangupMultiparty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onHangupMultiparty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendHangupMultipartyResponse (act_t act = 0);

    /**
     * The method sendHangupMultipartyError() sends an error response of a
     * previous method invocation of 'HangupMultiparty' back to the client.
     *
     * <b>Documentation of 'HangupMultiparty'</b>:
     *
     * If the meaning of "HangupMultiparty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onHangupMultiparty(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendHangupMultipartyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SendTones'

    /**
     * The method onSendTones() is called by ASF when a client invokes the
     * method 'SendTones'. A subclass has to implement this method and send
     * back a response to the client either with the sendSendTones() or
     * sendSendTonesError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SendTones'</b>:
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSendTonesRequest (const ::boost::shared_ptr< SendTonesRequest >& request) = 0;

    /**
     * The method sendSendTonesResponse() sends a response of a previous
     * method invocation of 'SendTones' back to the client.
     *
     * <b>Documentation of 'SendTones'</b>:
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSendTones(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSendTonesResponse (act_t act = 0);

    /**
     * The method sendSendTonesError() sends an error response of a previous
     * method invocation of 'SendTones' back to the client.
     *
     * <b>Documentation of 'SendTones'</b>:
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSendTones(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSendTonesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class VoiceCallManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace VoiceCallManager
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_VOICECALLMANAGERSTUB_H
