/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCallManager.h"
#include "org/ofono/VoiceCallManagerDBus.h"
#include "org/ofono/VoiceCallManagerJson.h"
#include "org/ofono/VoiceCallManagerStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace VoiceCallManager {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/created/during/runtime/org/ofono/VoiceCallManager", VoiceCallManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Dial", 2 },
    { 6, "Redial", 4 },
    { 7, "MemDial", 3 },
    { 8, "GetCalls", 1 },
    { 9, "HangupAll", 9 },
    { 9, "SendTones", 13 },
    { 9, "SwapCalls", 5 },
    { 11, "PrivateChat", 10 },
    { 13, "GetProperties", 0 },
    { 13, "HoldAndAnswer", 8 },
    { 14, "ReleaseAndSwap", 7 },
    { 16, "CreateMultiparty", 11 },
    { 16, "HangupMultiparty", 12 },
    { 16, "ReleaseAndAnswer", 6 },
};


class VoiceCallManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    VoiceCallManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.ofono.VoiceCallManager"),
          _logger(logger) {}

    virtual ~VoiceCallManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void VoiceCallManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 14, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'GetCalls'

            LOG_DEBUG_STUB("process method '%s'", "GetCalls");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCallsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetCalls", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetCallsRequest > payload = ::boost::static_pointer_cast<GetCallsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onGetCallsRequest(payload);
            return;
        }
        case 2: {

            // method 'Dial'

            LOG_DEBUG_STUB("process method '%s'", "Dial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Dial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DialRequest > payload = ::boost::static_pointer_cast<DialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onDialRequest(payload);
            return;
        }
        case 3: {

            // method 'MemDial'

            LOG_DEBUG_STUB("process method '%s'", "MemDial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemDialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "MemDial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< MemDialRequest > payload = ::boost::static_pointer_cast<MemDialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onMemDialRequest(payload);
            return;
        }
        case 4: {

            // method 'Redial'

            LOG_DEBUG_STUB("process method '%s'", "Redial");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RedialRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Redial", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RedialRequest > payload = ::boost::static_pointer_cast<RedialRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onRedialRequest(payload);
            return;
        }
        case 5: {

            // method 'SwapCalls'

            LOG_DEBUG_STUB("process method '%s'", "SwapCalls");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SwapCalls", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SwapCallsRequest > payload = ::boost::static_pointer_cast<SwapCallsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onSwapCallsRequest(payload);
            return;
        }
        case 6: {

            // method 'ReleaseAndAnswer'

            LOG_DEBUG_STUB("process method '%s'", "ReleaseAndAnswer");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndAnswerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReleaseAndAnswer", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseAndAnswerRequest > payload = ::boost::static_pointer_cast<ReleaseAndAnswerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onReleaseAndAnswerRequest(payload);
            return;
        }
        case 7: {

            // method 'ReleaseAndSwap'

            LOG_DEBUG_STUB("process method '%s'", "ReleaseAndSwap");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndSwapRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ReleaseAndSwap", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ReleaseAndSwapRequest > payload = ::boost::static_pointer_cast<ReleaseAndSwapRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onReleaseAndSwapRequest(payload);
            return;
        }
        case 8: {

            // method 'HoldAndAnswer'

            LOG_DEBUG_STUB("process method '%s'", "HoldAndAnswer");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HoldAndAnswerRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HoldAndAnswer", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HoldAndAnswerRequest > payload = ::boost::static_pointer_cast<HoldAndAnswerRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onHoldAndAnswerRequest(payload);
            return;
        }
        case 9: {

            // method 'HangupAll'

            LOG_DEBUG_STUB("process method '%s'", "HangupAll");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HangupAll", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HangupAllRequest > payload = ::boost::static_pointer_cast<HangupAllRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onHangupAllRequest(payload);
            return;
        }
        case 10: {

            // method 'PrivateChat'

            LOG_DEBUG_STUB("process method '%s'", "PrivateChat");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateChatRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PrivateChat", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PrivateChatRequest > payload = ::boost::static_pointer_cast<PrivateChatRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onPrivateChatRequest(payload);
            return;
        }
        case 11: {

            // method 'CreateMultiparty'

            LOG_DEBUG_STUB("process method '%s'", "CreateMultiparty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateMultipartyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateMultiparty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateMultipartyRequest > payload = ::boost::static_pointer_cast<CreateMultipartyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onCreateMultipartyRequest(payload);
            return;
        }
        case 12: {

            // method 'HangupMultiparty'

            LOG_DEBUG_STUB("process method '%s'", "HangupMultiparty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupMultipartyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "HangupMultiparty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< HangupMultipartyRequest > payload = ::boost::static_pointer_cast<HangupMultipartyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onHangupMultipartyRequest(payload);
            return;
        }
        case 13: {

            // method 'SendTones'

            LOG_DEBUG_STUB("process method '%s'", "SendTones");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendTonesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendTones", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendTonesRequest > payload = ::boost::static_pointer_cast<SendTonesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<VoiceCallManagerStub*>(getStub())->onSendTonesRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* VoiceCallManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.ofono.VoiceCallManager\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"GetCalls\">\n"
            "        <arg direction=\"out\" name=\"calls_with_properties\" type=\"a(oa{sv})\"/>\n"
            "      </method>\n"
            "      <method name=\"Dial\">\n"
            "        <arg direction=\"in\" name=\"number\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"hide_callerid\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"MemDial\">\n"
            "        <arg direction=\"in\" name=\"numberindex\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"hide_callerid\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"Redial\">\n"
            "        <arg direction=\"in\" name=\"hide_callerid\" type=\"s\"/>\n"
            "        <arg direction=\"out\" name=\"path\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"SwapCalls\"/>\n"
            "      <method name=\"ReleaseAndAnswer\"/>\n"
            "      <method name=\"ReleaseAndSwap\"/>\n"
            "      <method name=\"HoldAndAnswer\"/>\n"
            "      <method name=\"HangupAll\"/>\n"
            "      <method name=\"PrivateChat\">\n"
            "        <arg direction=\"in\" name=\"call\" type=\"o\"/>\n"
            "        <arg direction=\"out\" name=\"calls\" type=\"ao\"/>\n"
            "      </method>\n"
            "      <method name=\"CreateMultiparty\">\n"
            "        <arg direction=\"out\" name=\"calls\" type=\"ao\"/>\n"
            "      </method>\n"
            "      <method name=\"HangupMultiparty\"/>\n"
            "      <method name=\"SendTones\">\n"
            "        <arg direction=\"in\" name=\"SendTones\" type=\"s\"/>\n"
            "      </method>\n"
            "      <signal name=\"CallAdded\">\n"
            "        <arg name=\"call\" type=\"o\"/>\n"
            "        <arg name=\"properties\" type=\"a{sv}\"/>\n"
            "      </signal>\n"
            "      <signal name=\"CallRemoved\">\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void VoiceCallManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<VoiceCallManagerStub*>(getStub()))->onGetAll (properties);
}

void VoiceCallManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void VoiceCallManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

VoiceCallManagerStub::VoiceCallManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallManagerStub::VoiceCallManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new VoiceCallManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

VoiceCallManagerStub::~VoiceCallManagerStub() {
    delete _stubDelegate;
}

void VoiceCallManagerStub::sendCallAddedSignal(const ::std::string& call, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    if (_stubDelegate->isConnected()) {
        CallAddedSignal* payload = new CallAddedSignal(call, properties);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "CallAdded", CallAddedSignal, payload)
        LOG_INFO ("-> send%sSignal", "CallAdded");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "CallAdded");
    }
}

void VoiceCallManagerStub::sendCallRemovedSignal(const ::std::string& path) {
    if (_stubDelegate->isConnected()) {
        CallRemovedSignal* payload = new CallRemovedSignal(path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "CallRemoved", CallRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "CallRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "CallRemoved");
    }
}

void VoiceCallManagerStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void  VoiceCallManagerStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendGetCallsResponse (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties, act_t act) {
    GetCallsResponse* payload = new GetCallsResponse(calls_with_properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetCalls", GetCallsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendGetCallsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetCallsError* payload = new GetCallsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetCalls", GetCallsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendDialResponse (const ::std::string& path, act_t act) {
    DialResponse* payload = new DialResponse(path);
    DBUS_MESSAGE_REPLY(dbusMessage, "Dial", DialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Dial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendDialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DialError* payload = new DialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Dial", DialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Dial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMemDialResponse (const ::std::string& path, act_t act) {
    MemDialResponse* payload = new MemDialResponse(path);
    DBUS_MESSAGE_REPLY(dbusMessage, "MemDial", MemDialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "MemDial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendMemDialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    MemDialError* payload = new MemDialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "MemDial", MemDialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "MemDial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendRedialResponse (const ::std::string& path, act_t act) {
    RedialResponse* payload = new RedialResponse(path);
    DBUS_MESSAGE_REPLY(dbusMessage, "Redial", RedialResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Redial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendRedialError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RedialError* payload = new RedialError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Redial", RedialError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Redial", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSwapCallsResponse (act_t act) {
    SwapCallsResponse* payload = new SwapCallsResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SwapCalls", SwapCallsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SwapCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSwapCallsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SwapCallsError* payload = new SwapCallsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SwapCalls", SwapCallsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SwapCalls", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendReleaseAndAnswerResponse (act_t act) {
    ReleaseAndAnswerResponse* payload = new ReleaseAndAnswerResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ReleaseAndAnswer", ReleaseAndAnswerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReleaseAndAnswer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendReleaseAndAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseAndAnswerError* payload = new ReleaseAndAnswerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReleaseAndAnswer", ReleaseAndAnswerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReleaseAndAnswer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendReleaseAndSwapResponse (act_t act) {
    ReleaseAndSwapResponse* payload = new ReleaseAndSwapResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ReleaseAndSwap", ReleaseAndSwapResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ReleaseAndSwap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendReleaseAndSwapError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ReleaseAndSwapError* payload = new ReleaseAndSwapError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ReleaseAndSwap", ReleaseAndSwapError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ReleaseAndSwap", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHoldAndAnswerResponse (act_t act) {
    HoldAndAnswerResponse* payload = new HoldAndAnswerResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HoldAndAnswer", HoldAndAnswerResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HoldAndAnswer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHoldAndAnswerError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HoldAndAnswerError* payload = new HoldAndAnswerError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HoldAndAnswer", HoldAndAnswerError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HoldAndAnswer", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupAllResponse (act_t act) {
    HangupAllResponse* payload = new HangupAllResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HangupAll", HangupAllResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HangupAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupAllError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HangupAllError* payload = new HangupAllError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HangupAll", HangupAllError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HangupAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendPrivateChatResponse (const ::std::vector< ::std::string >& calls, act_t act) {
    PrivateChatResponse* payload = new PrivateChatResponse(calls);
    DBUS_MESSAGE_REPLY(dbusMessage, "PrivateChat", PrivateChatResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PrivateChat", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendPrivateChatError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PrivateChatError* payload = new PrivateChatError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PrivateChat", PrivateChatError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PrivateChat", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendCreateMultipartyResponse (const ::std::vector< ::std::string >& calls, act_t act) {
    CreateMultipartyResponse* payload = new CreateMultipartyResponse(calls);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateMultiparty", CreateMultipartyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateMultiparty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendCreateMultipartyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateMultipartyError* payload = new CreateMultipartyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateMultiparty", CreateMultipartyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateMultiparty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupMultipartyResponse (act_t act) {
    HangupMultipartyResponse* payload = new HangupMultipartyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "HangupMultiparty", HangupMultipartyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "HangupMultiparty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendHangupMultipartyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    HangupMultipartyError* payload = new HangupMultipartyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "HangupMultiparty", HangupMultipartyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "HangupMultiparty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSendTonesResponse (act_t act) {
    SendTonesResponse* payload = new SendTonesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendTones", SendTonesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendTones", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  VoiceCallManagerStub::sendSendTonesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendTonesError* payload = new SendTonesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendTones", SendTonesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendTones", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void VoiceCallManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace VoiceCallManager
} // namespace ofono
} // namespace org
