/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/VoiceCallManager.h"
#include "org/ofono/VoiceCallManagerDBus.h"
#include "org/ofono/VoiceCallManagerJson.h"
#include "org/ofono/VoiceCallManagerProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace ofono {
namespace VoiceCallManager {

DEFINE_CLASS_LOGGER("//hfp/adapter_addr/dev_addr/created/during/runtime/org/ofono/VoiceCallManager", VoiceCallManagerProxy);

class VoiceCallManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    VoiceCallManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< VoiceCallManagerProxy >& proxyShared = ::boost::static_pointer_cast< VoiceCallManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_CallAdded:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallAddedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallAdded", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<CallAddedSignal> payload = ::boost::static_pointer_cast<CallAddedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((CallAddedCallbackIF*) _callback)->onCallAddedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_CallRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CallRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "CallRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<CallRemovedSignal> payload = ::boost::static_pointer_cast<CallRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((CallRemovedCallbackIF*) _callback)->onCallRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_PropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertyChangedSignal> payload = ::boost::static_pointer_cast<PropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_GetCalls:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetCallsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCallsError> payload = ::boost::static_pointer_cast<GetCallsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallsCallbackIF*) _callback)->onGetCallsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetCallsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetCallsResponse> payload = ::boost::static_pointer_cast<GetCallsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallsCallbackIF*) _callback)->onGetCallsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Dial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DialError> payload = ::boost::static_pointer_cast<DialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DialCallbackIF*) _callback)->onDialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Dial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DialResponse> payload = ::boost::static_pointer_cast<DialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DialCallbackIF*) _callback)->onDialResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_MemDial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), MemDialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "MemDial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemDialError> payload = ::boost::static_pointer_cast<MemDialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MemDialCallbackIF*) _callback)->onMemDialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), MemDialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "MemDial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<MemDialResponse> payload = ::boost::static_pointer_cast<MemDialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((MemDialCallbackIF*) _callback)->onMemDialResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Redial:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RedialError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Redial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RedialError> payload = ::boost::static_pointer_cast<RedialError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RedialCallbackIF*) _callback)->onRedialError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RedialResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Redial", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RedialResponse> payload = ::boost::static_pointer_cast<RedialResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RedialCallbackIF*) _callback)->onRedialResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SwapCalls:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwapCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwapCallsError> payload = ::boost::static_pointer_cast<SwapCallsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwapCallsCallbackIF*) _callback)->onSwapCallsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SwapCallsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SwapCalls", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SwapCallsResponse> payload = ::boost::static_pointer_cast<SwapCallsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SwapCallsCallbackIF*) _callback)->onSwapCallsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReleaseAndAnswer:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndAnswerError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseAndAnswer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseAndAnswerError> payload = ::boost::static_pointer_cast<ReleaseAndAnswerError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseAndAnswerCallbackIF*) _callback)->onReleaseAndAnswerError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndAnswerResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseAndAnswer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseAndAnswerResponse> payload = ::boost::static_pointer_cast<ReleaseAndAnswerResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseAndAnswerCallbackIF*) _callback)->onReleaseAndAnswerResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ReleaseAndSwap:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndSwapError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseAndSwap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseAndSwapError> payload = ::boost::static_pointer_cast<ReleaseAndSwapError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseAndSwapCallbackIF*) _callback)->onReleaseAndSwapError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseAndSwapResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ReleaseAndSwap", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseAndSwapResponse> payload = ::boost::static_pointer_cast<ReleaseAndSwapResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseAndSwapCallbackIF*) _callback)->onReleaseAndSwapResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HoldAndAnswer:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HoldAndAnswerError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HoldAndAnswer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HoldAndAnswerError> payload = ::boost::static_pointer_cast<HoldAndAnswerError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HoldAndAnswerCallbackIF*) _callback)->onHoldAndAnswerError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HoldAndAnswerResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HoldAndAnswer", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HoldAndAnswerResponse> payload = ::boost::static_pointer_cast<HoldAndAnswerResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HoldAndAnswerCallbackIF*) _callback)->onHoldAndAnswerResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HangupAll:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupAllError> payload = ::boost::static_pointer_cast<HangupAllError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupAllCallbackIF*) _callback)->onHangupAllError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupAllResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupAll", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupAllResponse> payload = ::boost::static_pointer_cast<HangupAllResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupAllCallbackIF*) _callback)->onHangupAllResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PrivateChat:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PrivateChatError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrivateChat", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateChatError> payload = ::boost::static_pointer_cast<PrivateChatError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrivateChatCallbackIF*) _callback)->onPrivateChatError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PrivateChatResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PrivateChat", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PrivateChatResponse> payload = ::boost::static_pointer_cast<PrivateChatResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PrivateChatCallbackIF*) _callback)->onPrivateChatResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CreateMultiparty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateMultipartyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateMultiparty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateMultipartyError> payload = ::boost::static_pointer_cast<CreateMultipartyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateMultipartyCallbackIF*) _callback)->onCreateMultipartyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateMultipartyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateMultiparty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateMultipartyResponse> payload = ::boost::static_pointer_cast<CreateMultipartyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateMultipartyCallbackIF*) _callback)->onCreateMultipartyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_HangupMultiparty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), HangupMultipartyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupMultiparty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupMultipartyError> payload = ::boost::static_pointer_cast<HangupMultipartyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupMultipartyCallbackIF*) _callback)->onHangupMultipartyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HangupMultipartyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "HangupMultiparty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HangupMultipartyResponse> payload = ::boost::static_pointer_cast<HangupMultipartyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((HangupMultipartyCallbackIF*) _callback)->onHangupMultipartyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SendTones:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendTonesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendTones", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendTonesError> payload = ::boost::static_pointer_cast<SendTonesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendTonesCallbackIF*) _callback)->onSendTonesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendTonesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendTones", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendTonesResponse> payload = ::boost::static_pointer_cast<SendTonesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendTonesCallbackIF*) _callback)->onSendTonesResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_CallAdded: {
                ::boost::shared_ptr< CallAddedError > payload = ::boost::shared_ptr< CallAddedError >
                (new CallAddedError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CallAdded", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CallAddedCallbackIF*) _callback)->onCallAddedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CallRemoved: {
                ::boost::shared_ptr< CallRemovedError > payload = ::boost::shared_ptr< CallRemovedError >
                (new CallRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CallRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CallRemovedCallbackIF*) _callback)->onCallRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PropertyChanged: {
                ::boost::shared_ptr< PropertyChangedError > payload = ::boost::shared_ptr< PropertyChangedError >
                (new PropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetCalls: {
                ::boost::shared_ptr< GetCallsError > payload = ::boost::shared_ptr< GetCallsError >
                (new GetCallsError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetCalls", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCallsCallbackIF*) _callback)->onGetCallsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Dial: {
                ::boost::shared_ptr< DialError > payload = ::boost::shared_ptr< DialError >
                (new DialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Dial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DialCallbackIF*) _callback)->onDialError (proxyShared,payload);
                return true;
            }
            break;
            case ID_MemDial: {
                ::boost::shared_ptr< MemDialError > payload = ::boost::shared_ptr< MemDialError >
                (new MemDialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "MemDial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((MemDialCallbackIF*) _callback)->onMemDialError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Redial: {
                ::boost::shared_ptr< RedialError > payload = ::boost::shared_ptr< RedialError >
                (new RedialError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Redial", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RedialCallbackIF*) _callback)->onRedialError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SwapCalls: {
                ::boost::shared_ptr< SwapCallsError > payload = ::boost::shared_ptr< SwapCallsError >
                (new SwapCallsError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SwapCalls", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SwapCallsCallbackIF*) _callback)->onSwapCallsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReleaseAndAnswer: {
                ::boost::shared_ptr< ReleaseAndAnswerError > payload = ::boost::shared_ptr< ReleaseAndAnswerError >
                (new ReleaseAndAnswerError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReleaseAndAnswer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseAndAnswerCallbackIF*) _callback)->onReleaseAndAnswerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReleaseAndSwap: {
                ::boost::shared_ptr< ReleaseAndSwapError > payload = ::boost::shared_ptr< ReleaseAndSwapError >
                (new ReleaseAndSwapError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReleaseAndSwap", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseAndSwapCallbackIF*) _callback)->onReleaseAndSwapError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HoldAndAnswer: {
                ::boost::shared_ptr< HoldAndAnswerError > payload = ::boost::shared_ptr< HoldAndAnswerError >
                (new HoldAndAnswerError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HoldAndAnswer", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HoldAndAnswerCallbackIF*) _callback)->onHoldAndAnswerError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HangupAll: {
                ::boost::shared_ptr< HangupAllError > payload = ::boost::shared_ptr< HangupAllError >
                (new HangupAllError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HangupAll", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HangupAllCallbackIF*) _callback)->onHangupAllError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PrivateChat: {
                ::boost::shared_ptr< PrivateChatError > payload = ::boost::shared_ptr< PrivateChatError >
                (new PrivateChatError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PrivateChat", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PrivateChatCallbackIF*) _callback)->onPrivateChatError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateMultiparty: {
                ::boost::shared_ptr< CreateMultipartyError > payload = ::boost::shared_ptr< CreateMultipartyError >
                (new CreateMultipartyError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateMultiparty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateMultipartyCallbackIF*) _callback)->onCreateMultipartyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HangupMultiparty: {
                ::boost::shared_ptr< HangupMultipartyError > payload = ::boost::shared_ptr< HangupMultipartyError >
                (new HangupMultipartyError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HangupMultiparty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HangupMultipartyCallbackIF*) _callback)->onHangupMultipartyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendTones: {
                ::boost::shared_ptr< SendTonesError > payload = ::boost::shared_ptr< SendTonesError >
                (new SendTonesError(DBUS_ERROR_NO_SERVER, "The DBus service VoiceCallManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendTones", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<VoiceCallManagerProxy> proxyShared = ::boost::static_pointer_cast<VoiceCallManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendTonesCallbackIF*) _callback)->onSendTonesError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& VoiceCallManagerProxyCallback::_logger (VoiceCallManagerProxy::_logger);

VoiceCallManagerProxy::VoiceCallManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.ofono.VoiceCallManager", serviceAvailable, _logger) {
}

VoiceCallManagerProxy::~VoiceCallManagerProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< VoiceCallManagerProxy > VoiceCallManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<VoiceCallManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< VoiceCallManagerProxy > proxyNew(new VoiceCallManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t VoiceCallManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t VoiceCallManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    VoiceCallManagerProxyCallback* callback = new VoiceCallManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void VoiceCallManagerProxy::sendDeregisterAll () const
{
    sendCallAddedDeregisterAll();
    sendCallRemovedDeregisterAll();
    sendPropertyChangedDeregisterAll();
}

act_t VoiceCallManagerProxy::sendCallAddedRegister(CallAddedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "CallAdded");
    act_t act = addSignalCallback(ID_CallAdded, "CallAdded", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CallAdded", &cb, act);
    return act;
}

bool VoiceCallManagerProxy::sendCallAddedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CallAdded", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CallAdded", act, static_cast<int>(rv));
    return rv;
}

void VoiceCallManagerProxy::sendCallAddedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CallAdded");
    _dbusProxyDelegate->deregisterSignalCallback("CallAdded", 0, _dbusDaemonProxy.get(), false);
}

act_t VoiceCallManagerProxy::sendCallRemovedRegister(CallRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "CallRemoved");
    act_t act = addSignalCallback(ID_CallRemoved, "CallRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "CallRemoved", &cb, act);
    return act;
}

bool VoiceCallManagerProxy::sendCallRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("CallRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "CallRemoved", act, static_cast<int>(rv));
    return rv;
}

void VoiceCallManagerProxy::sendCallRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "CallRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("CallRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t VoiceCallManagerProxy::sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertyChanged");
    act_t act = addSignalCallback(ID_PropertyChanged, "PropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertyChanged", &cb, act);
    return act;
}

bool VoiceCallManagerProxy::sendPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void VoiceCallManagerProxy::sendPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t VoiceCallManagerProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendGetCallsRequest(GetCallsCallbackIF& cb) const {
    GetCallsRequest* payload = new GetCallsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetCalls", GetCallsRequest, payload, true)
    act_t act = addMethodCallback(ID_GetCalls, dbusMessage.getUniqueSerial(), "GetCalls", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetCalls", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendDialRequest(DialCallbackIF& cb, const ::std::string& number, const ::std::string& hide_callerid) const {
    DialRequest* payload = new DialRequest();
    CHECK_ALLOCATION(payload);
    payload->setNumber(number);
    payload->setHide_callerid(hide_callerid);
    DBUS_MESSAGE_CALL(dbusMessage, "Dial", DialRequest, payload, true)
    act_t act = addMethodCallback(ID_Dial, dbusMessage.getUniqueSerial(), "Dial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Dial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendMemDialRequest(MemDialCallbackIF& cb, uint16 numberindex, const ::std::string& hide_callerid) const {
    MemDialRequest* payload = new MemDialRequest();
    CHECK_ALLOCATION(payload);
    payload->setNumberindex(numberindex);
    payload->setHide_callerid(hide_callerid);
    DBUS_MESSAGE_CALL(dbusMessage, "MemDial", MemDialRequest, payload, true)
    act_t act = addMethodCallback(ID_MemDial, dbusMessage.getUniqueSerial(), "MemDial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "MemDial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendRedialRequest(RedialCallbackIF& cb, const ::std::string& hide_callerid) const {
    RedialRequest* payload = new RedialRequest();
    CHECK_ALLOCATION(payload);
    payload->setHide_callerid(hide_callerid);
    DBUS_MESSAGE_CALL(dbusMessage, "Redial", RedialRequest, payload, true)
    act_t act = addMethodCallback(ID_Redial, dbusMessage.getUniqueSerial(), "Redial", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Redial", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendSwapCallsRequest(SwapCallsCallbackIF& cb) const {
    SwapCallsRequest* payload = new SwapCallsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "SwapCalls", SwapCallsRequest, payload, true)
    act_t act = addMethodCallback(ID_SwapCalls, dbusMessage.getUniqueSerial(), "SwapCalls", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SwapCalls", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendReleaseAndAnswerRequest(ReleaseAndAnswerCallbackIF& cb) const {
    ReleaseAndAnswerRequest* payload = new ReleaseAndAnswerRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ReleaseAndAnswer", ReleaseAndAnswerRequest, payload, true)
    act_t act = addMethodCallback(ID_ReleaseAndAnswer, dbusMessage.getUniqueSerial(), "ReleaseAndAnswer", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReleaseAndAnswer", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendReleaseAndSwapRequest(ReleaseAndSwapCallbackIF& cb) const {
    ReleaseAndSwapRequest* payload = new ReleaseAndSwapRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ReleaseAndSwap", ReleaseAndSwapRequest, payload, true)
    act_t act = addMethodCallback(ID_ReleaseAndSwap, dbusMessage.getUniqueSerial(), "ReleaseAndSwap", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ReleaseAndSwap", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendHoldAndAnswerRequest(HoldAndAnswerCallbackIF& cb) const {
    HoldAndAnswerRequest* payload = new HoldAndAnswerRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "HoldAndAnswer", HoldAndAnswerRequest, payload, true)
    act_t act = addMethodCallback(ID_HoldAndAnswer, dbusMessage.getUniqueSerial(), "HoldAndAnswer", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HoldAndAnswer", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendHangupAllRequest(HangupAllCallbackIF& cb) const {
    HangupAllRequest* payload = new HangupAllRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "HangupAll", HangupAllRequest, payload, true)
    act_t act = addMethodCallback(ID_HangupAll, dbusMessage.getUniqueSerial(), "HangupAll", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HangupAll", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendPrivateChatRequest(PrivateChatCallbackIF& cb, const ::std::string& call) const {
    PrivateChatRequest* payload = new PrivateChatRequest();
    CHECK_ALLOCATION(payload);
    payload->setCall(call);
    DBUS_MESSAGE_CALL(dbusMessage, "PrivateChat", PrivateChatRequest, payload, true)
    act_t act = addMethodCallback(ID_PrivateChat, dbusMessage.getUniqueSerial(), "PrivateChat", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PrivateChat", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendCreateMultipartyRequest(CreateMultipartyCallbackIF& cb) const {
    CreateMultipartyRequest* payload = new CreateMultipartyRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateMultiparty", CreateMultipartyRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateMultiparty, dbusMessage.getUniqueSerial(), "CreateMultiparty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateMultiparty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendHangupMultipartyRequest(HangupMultipartyCallbackIF& cb) const {
    HangupMultipartyRequest* payload = new HangupMultipartyRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "HangupMultiparty", HangupMultipartyRequest, payload, true)
    act_t act = addMethodCallback(ID_HangupMultiparty, dbusMessage.getUniqueSerial(), "HangupMultiparty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "HangupMultiparty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t VoiceCallManagerProxy::sendSendTonesRequest(SendTonesCallbackIF& cb, const ::std::string& sendTones) const {
    SendTonesRequest* payload = new SendTonesRequest();
    CHECK_ALLOCATION(payload);
    payload->setSendTones(sendTones);
    DBUS_MESSAGE_CALL(dbusMessage, "SendTones", SendTonesRequest, payload, true)
    act_t act = addMethodCallback(ID_SendTones, dbusMessage.getUniqueSerial(), "SendTones", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendTones", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace VoiceCallManager
} // namespace ofono
} // namespace org
