#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_VOICECALLMANAGER_H
#define ORG_OFONO_VOICECALLMANAGER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>
#include <vector>

/**
 * If the meaning of "VoiceCallManager" isn't clear, then there should be a description here.
 */

namespace org {
namespace ofono {
namespace VoiceCallManager {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_GetCalls = 1;
static const uint16 ID_Dial = 2;
static const uint16 ID_MemDial = 3;
static const uint16 ID_Redial = 4;
static const uint16 ID_SwapCalls = 5;
static const uint16 ID_ReleaseAndAnswer = 6;
static const uint16 ID_ReleaseAndSwap = 7;
static const uint16 ID_HoldAndAnswer = 8;
static const uint16 ID_HangupAll = 9;
static const uint16 ID_PrivateChat = 10;
static const uint16 ID_CreateMultiparty = 11;
static const uint16 ID_HangupMultiparty = 12;
static const uint16 ID_SendTones = 13;

// signal IDs
static const uint16 ID_CallAdded = 14;
static const uint16 ID_CallRemoved = 15;
static const uint16 ID_PropertyChanged = 16;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetPropertiesResponse;

class GetCallsResponseCalls_with_propertiesStruct;

class GetCallsResponse;

class DialRequest;

class DialResponse;

class MemDialRequest;

class MemDialResponse;

class RedialRequest;

class RedialResponse;

class PrivateChatRequest;

class PrivateChatResponse;

class CreateMultipartyResponse;

class SendTonesRequest;

class CallAddedSignal;

class CallRemovedSignal;

class PropertyChangedSignal;

// type definitions
/**
 * If the meaning of "GetPropertiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * If the meaning of "GetCallsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetCallsRequest;

/**
 * If the meaning of "GetCallsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetCallsError;

/**
 * If the meaning of "DialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DialError;

/**
 * If the meaning of "MemDialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError MemDialError;

/**
 * If the meaning of "RedialError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RedialError;

/**
 * If the meaning of "SwapCallsRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SwapCallsRequest;

/**
 * If the meaning of "SwapCallsResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SwapCallsResponse;

/**
 * If the meaning of "SwapCallsError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SwapCallsError;

/**
 * If the meaning of "ReleaseAndAnswerRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseAndAnswerRequest;

/**
 * If the meaning of "ReleaseAndAnswerResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseAndAnswerResponse;

/**
 * If the meaning of "ReleaseAndAnswerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseAndAnswerError;

/**
 * If the meaning of "ReleaseAndSwapRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseAndSwapRequest;

/**
 * If the meaning of "ReleaseAndSwapResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseAndSwapResponse;

/**
 * If the meaning of "ReleaseAndSwapError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseAndSwapError;

/**
 * If the meaning of "HoldAndAnswerRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HoldAndAnswerRequest;

/**
 * If the meaning of "HoldAndAnswerResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HoldAndAnswerResponse;

/**
 * If the meaning of "HoldAndAnswerError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HoldAndAnswerError;

/**
 * If the meaning of "HangupAllRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HangupAllRequest;

/**
 * If the meaning of "HangupAllResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HangupAllResponse;

/**
 * If the meaning of "HangupAllError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HangupAllError;

/**
 * If the meaning of "PrivateChatError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PrivateChatError;

/**
 * If the meaning of "CreateMultipartyRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CreateMultipartyRequest;

/**
 * If the meaning of "CreateMultipartyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateMultipartyError;

/**
 * If the meaning of "HangupMultipartyRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HangupMultipartyRequest;

/**
 * If the meaning of "HangupMultipartyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage HangupMultipartyResponse;

/**
 * If the meaning of "HangupMultipartyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError HangupMultipartyError;

/**
 * If the meaning of "SendTonesResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SendTonesResponse;

/**
 * If the meaning of "SendTonesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SendTonesError;

/**
 * If the meaning of "CallAddedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CallAddedError;

/**
 * If the meaning of "CallRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CallRemovedError;

/**
 * If the meaning of "PropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertyChangedError;


/**
 * If the meaning of "GetPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "GetCallsResponseCalls_with_propertiesStruct" isn't clear, then there should be a description here.
 */
class GetCallsResponseCalls_with_propertiesStruct {
public:

    /**
     * Default constructor
     */
    inline  GetCallsResponseCalls_with_propertiesStruct ();

    /**
     * Copy constructor
     */
    inline  GetCallsResponseCalls_with_propertiesStruct (const GetCallsResponseCalls_with_propertiesStruct &rhs);

    /**
     * All fields constructor
     */
    inline  GetCallsResponseCalls_with_propertiesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    /**
     * Destructor
     */
    inline  ~GetCallsResponseCalls_with_propertiesStruct();

    /**
     * Assignment operator
     */
    inline GetCallsResponseCalls_with_propertiesStruct& operator = (const GetCallsResponseCalls_with_propertiesStruct& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCallsResponseCalls_with_propertiesStruct& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCallsResponseCalls_with_propertiesStruct& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCallsResponseCalls_with_propertiesStruct& rhs) const;

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCallsResponseCalls_with_propertiesStruct& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "elem1"

    static const int kElem1 = 0;

    /**
     * Clears the field "elem1".
     *
     * The field will be set to its default value. The hasElem1()
     * method will return false.
     */
    inline void clearElem1();

    /**
     * Checks whether the field "elem1" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem1()). Otherwise it will return false.
     */
    inline bool hasElem1 () const;

    /**
     * Returns the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem1"
     */
    inline const ::std::string& getElem1 () const;

    /**
     * Retrieves the value of the field "elem1" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem1".
     */
    inline ::std::string& getElem1Mutable ();

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const ::std::string& elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* elem1_);

    /**
     * Sets the value of the member "elem1".
     *
     * If the meaning of "elem1" isn't clear, then there should be a description here.
     *
     * @param elem1 The value which will be set
     */
    inline void setElem1 (const char* value, size_t size);

    // API of field "elem2"

    static const int kElem2 = 1;

    /**
     * Clears the field "elem2".
     *
     * The field will be set to its default value. The hasElem2()
     * method will return false.
     */
    inline void clearElem2();

    /**
     * Checks whether the field "elem2" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setElem2()). Otherwise it will return false.
     */
    inline bool hasElem2 () const;

    /**
     * Returns the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @return The value of the field "elem2"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2 () const;

    /**
     * Retrieves the value of the field "elem2" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "elem2".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getElem2Mutable ();

    /**
     * Sets the value of the member "elem2".
     *
     * If the meaning of "elem2" isn't clear, then there should be a description here.
     *
     * @param elem2 The value which will be set
     */
    inline void setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_);

    static const GetCallsResponseCalls_with_propertiesStruct &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_elem1 ();

    inline void clear_has_elem1 ();

    inline void set_has_elem2 ();

    inline void clear_has_elem2 ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _elem1;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _elem2;

};

/**
 * If the meaning of "GetCallsResponse" isn't clear, then there should be a description here.
 */
class GetCallsResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetCallsResponse ();

    /**
     * Copy constructor
     */
    inline  GetCallsResponse (const GetCallsResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetCallsResponse (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetCallsResponse();

    /**
     * Assignment operator
     */
    inline GetCallsResponse& operator = (const GetCallsResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetCallsResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetCallsResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetCallsResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetCallsResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "calls_with_properties"

    static const int kCalls_with_properties = 0;

    /**
     * Clears the field "calls_with_properties".
     *
     * The field will be set to its default value. The hasCalls_with_properties()
     * method will return false.
     */
    inline void clearCalls_with_properties();

    /**
     * Checks whether the field "calls_with_properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalls_with_properties()). Otherwise it will return false.
     */
    inline bool hasCalls_with_properties () const;

    /**
     * Returns the value of the member "calls_with_properties".
     *
     * If the meaning of "calls_with_properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "calls_with_properties"
     */
    inline const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& getCalls_with_properties () const;

    /**
     * Retrieves the value of the field "calls_with_properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "calls_with_properties".
     */
    inline ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& getCalls_with_propertiesMutable ();

    /**
     * Sets the value of the member "calls_with_properties".
     *
     * If the meaning of "calls_with_properties" isn't clear, then there should be a description here.
     *
     * @param calls_with_properties The value which will be set
     */
    inline void setCalls_with_properties (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties_);

    static const GetCallsResponse &getDefaultInstance();

private:

    static const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& getGetCallsResponseCalls_with_propertiesStructList_DefaultInstance ();

    inline void set_has_calls_with_properties ();

    inline void clear_has_calls_with_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< GetCallsResponseCalls_with_propertiesStruct > _calls_with_properties;

};

/**
 * If the meaning of "DialRequest" isn't clear, then there should be a description here.
 */
class DialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialRequest ();

    /**
     * Copy constructor
     */
    inline  DialRequest (const DialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DialRequest (const ::std::string& number_, const ::std::string& hide_callerid_);

    /**
     * Destructor
     */
    inline virtual  ~DialRequest();

    /**
     * Assignment operator
     */
    inline DialRequest& operator = (const DialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "number"

    static const int kNumber = 0;

    /**
     * Clears the field "number".
     *
     * The field will be set to its default value. The hasNumber()
     * method will return false.
     */
    inline void clearNumber();

    /**
     * Checks whether the field "number" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumber()). Otherwise it will return false.
     */
    inline bool hasNumber () const;

    /**
     * Returns the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @return The value of the field "number"
     */
    inline const ::std::string& getNumber () const;

    /**
     * Retrieves the value of the field "number" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "number".
     */
    inline ::std::string& getNumberMutable ();

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const ::std::string& number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* number_);

    /**
     * Sets the value of the member "number".
     *
     * If the meaning of "number" isn't clear, then there should be a description here.
     *
     * @param number The value which will be set
     */
    inline void setNumber (const char* value, size_t size);

    // API of field "hide_callerid"

    static const int kHide_callerid = 1;

    /**
     * Clears the field "hide_callerid".
     *
     * The field will be set to its default value. The hasHide_callerid()
     * method will return false.
     */
    inline void clearHide_callerid();

    /**
     * Checks whether the field "hide_callerid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHide_callerid()). Otherwise it will return false.
     */
    inline bool hasHide_callerid () const;

    /**
     * Returns the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hide_callerid"
     */
    inline const ::std::string& getHide_callerid () const;

    /**
     * Retrieves the value of the field "hide_callerid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hide_callerid".
     */
    inline ::std::string& getHide_calleridMutable ();

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const ::std::string& hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* value, size_t size);

    static const DialRequest &getDefaultInstance();

private:

    inline void set_has_number ();

    inline void clear_has_number ();

    inline void set_has_hide_callerid ();

    inline void clear_has_hide_callerid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _number;

    ::std::string _hide_callerid;

};

/**
 * If the meaning of "DialResponse" isn't clear, then there should be a description here.
 */
class DialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DialResponse ();

    /**
     * Copy constructor
     */
    inline  DialResponse (const DialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  DialResponse (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~DialResponse();

    /**
     * Assignment operator
     */
    inline DialResponse& operator = (const DialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const DialResponse &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "MemDialRequest" isn't clear, then there should be a description here.
 */
class MemDialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MemDialRequest ();

    /**
     * Copy constructor
     */
    inline  MemDialRequest (const MemDialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  MemDialRequest (uint16 numberindex_, const ::std::string& hide_callerid_);

    /**
     * Destructor
     */
    inline virtual  ~MemDialRequest();

    /**
     * Assignment operator
     */
    inline MemDialRequest& operator = (const MemDialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MemDialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MemDialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MemDialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MemDialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "numberindex"

    static const int kNumberindex = 0;

    /**
     * Clears the field "numberindex".
     *
     * The field will be set to its default value. The hasNumberindex()
     * method will return false.
     */
    inline void clearNumberindex();

    /**
     * Checks whether the field "numberindex" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setNumberindex()). Otherwise it will return false.
     */
    inline bool hasNumberindex () const;

    /**
     * Returns the value of the member "numberindex".
     *
     * If the meaning of "numberindex" isn't clear, then there should be a description here.
     *
     * @return The value of the field "numberindex"
     */
    inline uint16 getNumberindex () const;

    /**
     * Sets the value of the member "numberindex".
     *
     * If the meaning of "numberindex" isn't clear, then there should be a description here.
     *
     * @param numberindex The value which will be set
     */
    inline void setNumberindex (uint16 numberindex_);

    // API of field "hide_callerid"

    static const int kHide_callerid = 1;

    /**
     * Clears the field "hide_callerid".
     *
     * The field will be set to its default value. The hasHide_callerid()
     * method will return false.
     */
    inline void clearHide_callerid();

    /**
     * Checks whether the field "hide_callerid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHide_callerid()). Otherwise it will return false.
     */
    inline bool hasHide_callerid () const;

    /**
     * Returns the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hide_callerid"
     */
    inline const ::std::string& getHide_callerid () const;

    /**
     * Retrieves the value of the field "hide_callerid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hide_callerid".
     */
    inline ::std::string& getHide_calleridMutable ();

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const ::std::string& hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* value, size_t size);

    static const MemDialRequest &getDefaultInstance();

private:

    inline void set_has_numberindex ();

    inline void clear_has_numberindex ();

    inline void set_has_hide_callerid ();

    inline void clear_has_hide_callerid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    uint16 _numberindex;

    ::std::string _hide_callerid;

};

/**
 * If the meaning of "MemDialResponse" isn't clear, then there should be a description here.
 */
class MemDialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  MemDialResponse ();

    /**
     * Copy constructor
     */
    inline  MemDialResponse (const MemDialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  MemDialResponse (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~MemDialResponse();

    /**
     * Assignment operator
     */
    inline MemDialResponse& operator = (const MemDialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const MemDialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const MemDialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const MemDialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const MemDialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const MemDialResponse &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "RedialRequest" isn't clear, then there should be a description here.
 */
class RedialRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialRequest ();

    /**
     * Copy constructor
     */
    inline  RedialRequest (const RedialRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RedialRequest (const ::std::string& hide_callerid_);

    /**
     * Destructor
     */
    inline virtual  ~RedialRequest();

    /**
     * Assignment operator
     */
    inline RedialRequest& operator = (const RedialRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "hide_callerid"

    static const int kHide_callerid = 0;

    /**
     * Clears the field "hide_callerid".
     *
     * The field will be set to its default value. The hasHide_callerid()
     * method will return false.
     */
    inline void clearHide_callerid();

    /**
     * Checks whether the field "hide_callerid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setHide_callerid()). Otherwise it will return false.
     */
    inline bool hasHide_callerid () const;

    /**
     * Returns the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "hide_callerid"
     */
    inline const ::std::string& getHide_callerid () const;

    /**
     * Retrieves the value of the field "hide_callerid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "hide_callerid".
     */
    inline ::std::string& getHide_calleridMutable ();

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const ::std::string& hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* hide_callerid_);

    /**
     * Sets the value of the member "hide_callerid".
     *
     * If the meaning of "hide_callerid" isn't clear, then there should be a description here.
     *
     * @param hide_callerid The value which will be set
     */
    inline void setHide_callerid (const char* value, size_t size);

    static const RedialRequest &getDefaultInstance();

private:

    inline void set_has_hide_callerid ();

    inline void clear_has_hide_callerid ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _hide_callerid;

};

/**
 * If the meaning of "RedialResponse" isn't clear, then there should be a description here.
 */
class RedialResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RedialResponse ();

    /**
     * Copy constructor
     */
    inline  RedialResponse (const RedialResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RedialResponse (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~RedialResponse();

    /**
     * Assignment operator
     */
    inline RedialResponse& operator = (const RedialResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RedialResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RedialResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RedialResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RedialResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const RedialResponse &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "PrivateChatRequest" isn't clear, then there should be a description here.
 */
class PrivateChatRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrivateChatRequest ();

    /**
     * Copy constructor
     */
    inline  PrivateChatRequest (const PrivateChatRequest &rhs);

    /**
     * All fields constructor
     */
    inline  PrivateChatRequest (const ::std::string& call_);

    /**
     * Destructor
     */
    inline virtual  ~PrivateChatRequest();

    /**
     * Assignment operator
     */
    inline PrivateChatRequest& operator = (const PrivateChatRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrivateChatRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrivateChatRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrivateChatRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrivateChatRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "call"

    static const int kCall = 0;

    /**
     * Clears the field "call".
     *
     * The field will be set to its default value. The hasCall()
     * method will return false.
     */
    inline void clearCall();

    /**
     * Checks whether the field "call" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCall()). Otherwise it will return false.
     */
    inline bool hasCall () const;

    /**
     * Returns the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @return The value of the field "call"
     */
    inline const ::std::string& getCall () const;

    /**
     * Retrieves the value of the field "call" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "call".
     */
    inline ::std::string& getCallMutable ();

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const ::std::string& call_);

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const char* call_);

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const char* value, size_t size);

    static const PrivateChatRequest &getDefaultInstance();

private:

    inline void set_has_call ();

    inline void clear_has_call ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _call;

};

/**
 * If the meaning of "PrivateChatResponse" isn't clear, then there should be a description here.
 */
class PrivateChatResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PrivateChatResponse ();

    /**
     * Copy constructor
     */
    inline  PrivateChatResponse (const PrivateChatResponse &rhs);

    /**
     * All fields constructor
     */
    inline  PrivateChatResponse (const ::std::vector< ::std::string >& calls_);

    /**
     * Destructor
     */
    inline virtual  ~PrivateChatResponse();

    /**
     * Assignment operator
     */
    inline PrivateChatResponse& operator = (const PrivateChatResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PrivateChatResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PrivateChatResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PrivateChatResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PrivateChatResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "calls"

    static const int kCalls = 0;

    /**
     * Clears the field "calls".
     *
     * The field will be set to its default value. The hasCalls()
     * method will return false.
     */
    inline void clearCalls();

    /**
     * Checks whether the field "calls" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalls()). Otherwise it will return false.
     */
    inline bool hasCalls () const;

    /**
     * Returns the value of the member "calls".
     *
     * If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @return The value of the field "calls"
     */
    inline const ::std::vector< ::std::string >& getCalls () const;

    /**
     * Retrieves the value of the field "calls" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "calls".
     */
    inline ::std::vector< ::std::string >& getCallsMutable ();

    /**
     * Sets the value of the member "calls".
     *
     * If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @param calls The value which will be set
     */
    inline void setCalls (const ::std::vector< ::std::string >& calls_);

    static const PrivateChatResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_calls ();

    inline void clear_has_calls ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _calls;

};

/**
 * If the meaning of "CreateMultipartyResponse" isn't clear, then there should be a description here.
 */
class CreateMultipartyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateMultipartyResponse ();

    /**
     * Copy constructor
     */
    inline  CreateMultipartyResponse (const CreateMultipartyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateMultipartyResponse (const ::std::vector< ::std::string >& calls_);

    /**
     * Destructor
     */
    inline virtual  ~CreateMultipartyResponse();

    /**
     * Assignment operator
     */
    inline CreateMultipartyResponse& operator = (const CreateMultipartyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateMultipartyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateMultipartyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateMultipartyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateMultipartyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "calls"

    static const int kCalls = 0;

    /**
     * Clears the field "calls".
     *
     * The field will be set to its default value. The hasCalls()
     * method will return false.
     */
    inline void clearCalls();

    /**
     * Checks whether the field "calls" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCalls()). Otherwise it will return false.
     */
    inline bool hasCalls () const;

    /**
     * Returns the value of the member "calls".
     *
     * If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @return The value of the field "calls"
     */
    inline const ::std::vector< ::std::string >& getCalls () const;

    /**
     * Retrieves the value of the field "calls" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "calls".
     */
    inline ::std::vector< ::std::string >& getCallsMutable ();

    /**
     * Sets the value of the member "calls".
     *
     * If the meaning of "calls" isn't clear, then there should be a description here.
     *
     * @param calls The value which will be set
     */
    inline void setCalls (const ::std::vector< ::std::string >& calls_);

    static const CreateMultipartyResponse &getDefaultInstance();

private:

    static const ::std::vector< ::std::string >& getStringList_DefaultInstance ();

    inline void set_has_calls ();

    inline void clear_has_calls ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< ::std::string > _calls;

};

/**
 * If the meaning of "SendTonesRequest" isn't clear, then there should be a description here.
 */
class SendTonesRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SendTonesRequest ();

    /**
     * Copy constructor
     */
    inline  SendTonesRequest (const SendTonesRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SendTonesRequest (const ::std::string& SendTones_);

    /**
     * Destructor
     */
    inline virtual  ~SendTonesRequest();

    /**
     * Assignment operator
     */
    inline SendTonesRequest& operator = (const SendTonesRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SendTonesRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SendTonesRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SendTonesRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SendTonesRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "SendTones"

    static const int kSendTones = 0;

    /**
     * Clears the field "SendTones".
     *
     * The field will be set to its default value. The hasSendTones()
     * method will return false.
     */
    inline void clearSendTones();

    /**
     * Checks whether the field "SendTones" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSendTones()). Otherwise it will return false.
     */
    inline bool hasSendTones () const;

    /**
     * Returns the value of the member "SendTones".
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @return The value of the field "SendTones"
     */
    inline const ::std::string& getSendTones () const;

    /**
     * Retrieves the value of the field "SendTones" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "SendTones".
     */
    inline ::std::string& getSendTonesMutable ();

    /**
     * Sets the value of the member "SendTones".
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param SendTones The value which will be set
     */
    inline void setSendTones (const ::std::string& SendTones_);

    /**
     * Sets the value of the member "SendTones".
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param SendTones The value which will be set
     */
    inline void setSendTones (const char* SendTones_);

    /**
     * Sets the value of the member "SendTones".
     *
     * If the meaning of "SendTones" isn't clear, then there should be a description here.
     *
     * @param SendTones The value which will be set
     */
    inline void setSendTones (const char* value, size_t size);

    static const SendTonesRequest &getDefaultInstance();

private:

    inline void set_has_SendTones ();

    inline void clear_has_SendTones ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _SendTones;

};

/**
 * If the meaning of "CallAddedSignal" isn't clear, then there should be a description here.
 */
class CallAddedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallAddedSignal ();

    /**
     * Copy constructor
     */
    inline  CallAddedSignal (const CallAddedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  CallAddedSignal (const ::std::string& call_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~CallAddedSignal();

    /**
     * Assignment operator
     */
    inline CallAddedSignal& operator = (const CallAddedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallAddedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallAddedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallAddedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallAddedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "call"

    static const int kCall = 0;

    /**
     * Clears the field "call".
     *
     * The field will be set to its default value. The hasCall()
     * method will return false.
     */
    inline void clearCall();

    /**
     * Checks whether the field "call" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCall()). Otherwise it will return false.
     */
    inline bool hasCall () const;

    /**
     * Returns the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @return The value of the field "call"
     */
    inline const ::std::string& getCall () const;

    /**
     * Retrieves the value of the field "call" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "call".
     */
    inline ::std::string& getCallMutable ();

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const ::std::string& call_);

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const char* call_);

    /**
     * Sets the value of the member "call".
     *
     * If the meaning of "call" isn't clear, then there should be a description here.
     *
     * @param call The value which will be set
     */
    inline void setCall (const char* value, size_t size);

    // API of field "properties"

    static const int kProperties = 1;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const CallAddedSignal &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_call ();

    inline void clear_has_call ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _call;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "CallRemovedSignal" isn't clear, then there should be a description here.
 */
class CallRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CallRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  CallRemovedSignal (const CallRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  CallRemovedSignal (const ::std::string& path_);

    /**
     * Destructor
     */
    inline virtual  ~CallRemovedSignal();

    /**
     * Assignment operator
     */
    inline CallRemovedSignal& operator = (const CallRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CallRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CallRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CallRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CallRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "path"

    static const int kPath = 0;

    /**
     * Clears the field "path".
     *
     * The field will be set to its default value. The hasPath()
     * method will return false.
     */
    inline void clearPath();

    /**
     * Checks whether the field "path" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPath()). Otherwise it will return false.
     */
    inline bool hasPath () const;

    /**
     * Returns the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return The value of the field "path"
     */
    inline const ::std::string& getPath () const;

    /**
     * Retrieves the value of the field "path" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "path".
     */
    inline ::std::string& getPathMutable ();

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const ::std::string& path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* path_);

    /**
     * Sets the value of the member "path".
     *
     * If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @param path The value which will be set
     */
    inline void setPath (const char* value, size_t size);

    static const CallRemovedSignal &getDefaultInstance();

private:

    inline void set_has_path ();

    inline void clear_has_path ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _path;

};

/**
 * If the meaning of "PropertyChangedSignal" isn't clear, then there should be a description here.
 */
class PropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertyChangedSignal (const PropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~PropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertyChangedSignal& operator = (const PropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "name"

    static const int kName = 0;

    /**
     * Clears the field "name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const ::std::string& name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* name_);

    /**
     * Sets the value of the member "name".
     *
     * If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const PropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_name ();

    inline void clear_has_name ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _name;

    ::asf::dbus::DBusVariant _value;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearProperties();
}

inline void GetPropertiesResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetPropertiesResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetPropertiesResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetPropertiesResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  GetCallsResponseCalls_with_propertiesStruct::GetCallsResponseCalls_with_propertiesStruct ()  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCallsResponseCalls_with_propertiesStruct::GetCallsResponseCalls_with_propertiesStruct (const GetCallsResponseCalls_with_propertiesStruct &rhs)  :
    _elem1 (),
    _elem2 ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCallsResponseCalls_with_propertiesStruct::GetCallsResponseCalls_with_propertiesStruct (const ::std::string& elem1_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_)  :
    _elem1 (elem1_),
    _elem2 (elem2_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCallsResponseCalls_with_propertiesStruct::~GetCallsResponseCalls_with_propertiesStruct() {
}

inline GetCallsResponseCalls_with_propertiesStruct& GetCallsResponseCalls_with_propertiesStruct::operator = (const GetCallsResponseCalls_with_propertiesStruct& rhs) {
    if( this != &rhs ) {
        if (rhs.hasElem1()) {
            setElem1(rhs.getElem1());
        } else {
            clearElem1();
        }
        if (rhs.hasElem2()) {
            setElem2(rhs.getElem2());
        } else {
            clearElem2();
        }
    }
    return *this;
}

inline bool GetCallsResponseCalls_with_propertiesStruct::operator == (const GetCallsResponseCalls_with_propertiesStruct& rhs) const {
    return (((!hasElem1() && !rhs.hasElem1()) || getElem1() == rhs.getElem1()) &&
        ((!hasElem2() && !rhs.hasElem2()) || getElem2() == rhs.getElem2()));
}

inline bool GetCallsResponseCalls_with_propertiesStruct::operator != (const GetCallsResponseCalls_with_propertiesStruct& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCallsResponseCalls_with_propertiesStruct::operator < (const GetCallsResponseCalls_with_propertiesStruct& rhs) const {
    if (hasElem1() || rhs.hasElem1()) {
        if (getElem1() < rhs.getElem1()) return true;
        if (getElem1() > rhs.getElem1()) return false;
    }
    if (hasElem2() || rhs.hasElem2()) {
        if (getElem2() < rhs.getElem2()) return true;
        if (getElem2() > rhs.getElem2()) return false;
    }
    return false;
}

inline bool GetCallsResponseCalls_with_propertiesStruct::operator > (const GetCallsResponseCalls_with_propertiesStruct& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCallsResponseCalls_with_propertiesStruct::clear() {
    clearElem1();
    clearElem2();
}

inline void GetCallsResponseCalls_with_propertiesStruct::clearElem1() {
    if (hasElem1()) {
         clear_has_elem1();
        _elem1.clear();
     }
}

inline bool GetCallsResponseCalls_with_propertiesStruct::hasElem1 () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& GetCallsResponseCalls_with_propertiesStruct::getElem1 () const {
    return _elem1;
}

inline ::std::string& GetCallsResponseCalls_with_propertiesStruct::getElem1Mutable () {
    set_has_elem1();
    return _elem1;
}

inline void GetCallsResponseCalls_with_propertiesStruct::setElem1 (const ::std::string& elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1 = elem1_;
}

inline void GetCallsResponseCalls_with_propertiesStruct::setElem1 (const char* elem1_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (elem1_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(elem1_);
}

inline void GetCallsResponseCalls_with_propertiesStruct::setElem1 (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_elem1();
    this->_elem1.assign(value, size);
}

inline void GetCallsResponseCalls_with_propertiesStruct::clearElem2() {
    if (hasElem2()) {
         clear_has_elem2();
        _elem2.clear();
     }
}

inline bool GetCallsResponseCalls_with_propertiesStruct::hasElem2 () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetCallsResponseCalls_with_propertiesStruct::getElem2 () const {
    return _elem2;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetCallsResponseCalls_with_propertiesStruct::getElem2Mutable () {
    set_has_elem2();
    return _elem2;
}

inline void GetCallsResponseCalls_with_propertiesStruct::setElem2 (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& elem2_) {
    set_has_elem2();
    this->_elem2 = elem2_;
}

inline void GetCallsResponseCalls_with_propertiesStruct::set_has_elem1 () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCallsResponseCalls_with_propertiesStruct::clear_has_elem1 () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void GetCallsResponseCalls_with_propertiesStruct::set_has_elem2 () {
    _has_bits_[0] |= 1u << 1;
}

inline void GetCallsResponseCalls_with_propertiesStruct::clear_has_elem2 () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  GetCallsResponse::GetCallsResponse ()  :
    _calls_with_properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetCallsResponse::GetCallsResponse (const GetCallsResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _calls_with_properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetCallsResponse::GetCallsResponse (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties_)  :
    _calls_with_properties (calls_with_properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetCallsResponse::~GetCallsResponse() {
}

inline GetCallsResponse& GetCallsResponse::operator = (const GetCallsResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalls_with_properties()) {
            setCalls_with_properties(rhs.getCalls_with_properties());
        } else {
            clearCalls_with_properties();
        }
    }
    return *this;
}

inline bool GetCallsResponse::operator == (const GetCallsResponse& rhs) const {
    return (((!hasCalls_with_properties() && !rhs.hasCalls_with_properties()) || getCalls_with_properties() == rhs.getCalls_with_properties()));
}

inline bool GetCallsResponse::operator != (const GetCallsResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetCallsResponse::operator < (const GetCallsResponse& rhs) const {
    if (hasCalls_with_properties() || rhs.hasCalls_with_properties()) {
        if (getCalls_with_properties() < rhs.getCalls_with_properties()) return true;
        if (getCalls_with_properties() > rhs.getCalls_with_properties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetCallsResponse::clone() {
    return new GetCallsResponse(*this);
}

inline bool GetCallsResponse::operator > (const GetCallsResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetCallsResponse::clear() {
    clearCalls_with_properties();
}

inline void GetCallsResponse::clearCalls_with_properties() {
    if (hasCalls_with_properties()) {
         clear_has_calls_with_properties();
        _calls_with_properties.clear();
     }
}

inline bool GetCallsResponse::hasCalls_with_properties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& GetCallsResponse::getCalls_with_properties () const {
    return _calls_with_properties;
}

inline ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& GetCallsResponse::getCalls_with_propertiesMutable () {
    set_has_calls_with_properties();
    return _calls_with_properties;
}

inline void GetCallsResponse::setCalls_with_properties (const ::std::vector< GetCallsResponseCalls_with_propertiesStruct >& calls_with_properties_) {
    set_has_calls_with_properties();
    this->_calls_with_properties = calls_with_properties_;
}

inline void GetCallsResponse::set_has_calls_with_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetCallsResponse::clear_has_calls_with_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DialRequest::DialRequest ()  :
    _number (),
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DialRequest::DialRequest (const DialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _number (),
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DialRequest::DialRequest (const ::std::string& number_, const ::std::string& hide_callerid_)  :
    _number (number_),
    _hide_callerid (hide_callerid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DialRequest::~DialRequest() {
}

inline DialRequest& DialRequest::operator = (const DialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNumber()) {
            setNumber(rhs.getNumber());
        } else {
            clearNumber();
        }
        if (rhs.hasHide_callerid()) {
            setHide_callerid(rhs.getHide_callerid());
        } else {
            clearHide_callerid();
        }
    }
    return *this;
}

inline bool DialRequest::operator == (const DialRequest& rhs) const {
    return (((!hasNumber() && !rhs.hasNumber()) || getNumber() == rhs.getNumber()) &&
        ((!hasHide_callerid() && !rhs.hasHide_callerid()) || getHide_callerid() == rhs.getHide_callerid()));
}

inline bool DialRequest::operator != (const DialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DialRequest::operator < (const DialRequest& rhs) const {
    if (hasNumber() || rhs.hasNumber()) {
        if (getNumber() < rhs.getNumber()) return true;
        if (getNumber() > rhs.getNumber()) return false;
    }
    if (hasHide_callerid() || rhs.hasHide_callerid()) {
        if (getHide_callerid() < rhs.getHide_callerid()) return true;
        if (getHide_callerid() > rhs.getHide_callerid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DialRequest::clone() {
    return new DialRequest(*this);
}

inline bool DialRequest::operator > (const DialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DialRequest::clear() {
    clearNumber();
    clearHide_callerid();
}

inline void DialRequest::clearNumber() {
    if (hasNumber()) {
         clear_has_number();
        _number.clear();
     }
}

inline bool DialRequest::hasNumber () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DialRequest::getNumber () const {
    return _number;
}

inline ::std::string& DialRequest::getNumberMutable () {
    set_has_number();
    return _number;
}

inline void DialRequest::setNumber (const ::std::string& number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number = number_;
}

inline void DialRequest::setNumber (const char* number_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (number_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(number_);
}

inline void DialRequest::setNumber (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_number();
    this->_number.assign(value, size);
}

inline void DialRequest::clearHide_callerid() {
    if (hasHide_callerid()) {
         clear_has_hide_callerid();
        _hide_callerid.clear();
     }
}

inline bool DialRequest::hasHide_callerid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DialRequest::getHide_callerid () const {
    return _hide_callerid;
}

inline ::std::string& DialRequest::getHide_calleridMutable () {
    set_has_hide_callerid();
    return _hide_callerid;
}

inline void DialRequest::setHide_callerid (const ::std::string& hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid = hide_callerid_;
}

inline void DialRequest::setHide_callerid (const char* hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(hide_callerid_);
}

inline void DialRequest::setHide_callerid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(value, size);
}

inline void DialRequest::set_has_number () {
    _has_bits_[0] |= 1u << 0;
}

inline void DialRequest::clear_has_number () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DialRequest::set_has_hide_callerid () {
    _has_bits_[0] |= 1u << 1;
}

inline void DialRequest::clear_has_hide_callerid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  DialResponse::DialResponse ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DialResponse::DialResponse (const DialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DialResponse::DialResponse (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DialResponse::~DialResponse() {
}

inline DialResponse& DialResponse::operator = (const DialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool DialResponse::operator == (const DialResponse& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool DialResponse::operator != (const DialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool DialResponse::operator < (const DialResponse& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DialResponse::clone() {
    return new DialResponse(*this);
}

inline bool DialResponse::operator > (const DialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DialResponse::clear() {
    clearPath();
}

inline void DialResponse::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool DialResponse::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DialResponse::getPath () const {
    return _path;
}

inline ::std::string& DialResponse::getPathMutable () {
    set_has_path();
    return _path;
}

inline void DialResponse::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void DialResponse::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void DialResponse::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void DialResponse::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void DialResponse::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  MemDialRequest::MemDialRequest ()  :
    _numberindex (0u),
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MemDialRequest::MemDialRequest (const MemDialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _numberindex (0u),
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MemDialRequest::MemDialRequest (uint16 numberindex_, const ::std::string& hide_callerid_)  :
    _numberindex (numberindex_),
    _hide_callerid (hide_callerid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MemDialRequest::~MemDialRequest() {
}

inline MemDialRequest& MemDialRequest::operator = (const MemDialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasNumberindex()) {
            setNumberindex(rhs.getNumberindex());
        } else {
            clearNumberindex();
        }
        if (rhs.hasHide_callerid()) {
            setHide_callerid(rhs.getHide_callerid());
        } else {
            clearHide_callerid();
        }
    }
    return *this;
}

inline bool MemDialRequest::operator == (const MemDialRequest& rhs) const {
    return (((!hasNumberindex() && !rhs.hasNumberindex()) || getNumberindex() == rhs.getNumberindex()) &&
        ((!hasHide_callerid() && !rhs.hasHide_callerid()) || getHide_callerid() == rhs.getHide_callerid()));
}

inline bool MemDialRequest::operator != (const MemDialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool MemDialRequest::operator < (const MemDialRequest& rhs) const {
    if (hasNumberindex() || rhs.hasNumberindex()) {
        if (getNumberindex() < rhs.getNumberindex()) return true;
        if (getNumberindex() > rhs.getNumberindex()) return false;
    }
    if (hasHide_callerid() || rhs.hasHide_callerid()) {
        if (getHide_callerid() < rhs.getHide_callerid()) return true;
        if (getHide_callerid() > rhs.getHide_callerid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MemDialRequest::clone() {
    return new MemDialRequest(*this);
}

inline bool MemDialRequest::operator > (const MemDialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MemDialRequest::clear() {
    clearNumberindex();
    clearHide_callerid();
}

inline void MemDialRequest::clearNumberindex() {
    if (hasNumberindex()) {
         clear_has_numberindex();
        _numberindex = 0u;
     }
}

inline bool MemDialRequest::hasNumberindex () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 MemDialRequest::getNumberindex () const {
    return _numberindex;
}

inline void MemDialRequest::setNumberindex (uint16 numberindex_) {
    set_has_numberindex();
    this->_numberindex = numberindex_;
}

inline void MemDialRequest::clearHide_callerid() {
    if (hasHide_callerid()) {
         clear_has_hide_callerid();
        _hide_callerid.clear();
     }
}

inline bool MemDialRequest::hasHide_callerid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& MemDialRequest::getHide_callerid () const {
    return _hide_callerid;
}

inline ::std::string& MemDialRequest::getHide_calleridMutable () {
    set_has_hide_callerid();
    return _hide_callerid;
}

inline void MemDialRequest::setHide_callerid (const ::std::string& hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid = hide_callerid_;
}

inline void MemDialRequest::setHide_callerid (const char* hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(hide_callerid_);
}

inline void MemDialRequest::setHide_callerid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(value, size);
}

inline void MemDialRequest::set_has_numberindex () {
    _has_bits_[0] |= 1u << 0;
}

inline void MemDialRequest::clear_has_numberindex () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void MemDialRequest::set_has_hide_callerid () {
    _has_bits_[0] |= 1u << 1;
}

inline void MemDialRequest::clear_has_hide_callerid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  MemDialResponse::MemDialResponse ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  MemDialResponse::MemDialResponse (const MemDialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  MemDialResponse::MemDialResponse (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  MemDialResponse::~MemDialResponse() {
}

inline MemDialResponse& MemDialResponse::operator = (const MemDialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool MemDialResponse::operator == (const MemDialResponse& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool MemDialResponse::operator != (const MemDialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool MemDialResponse::operator < (const MemDialResponse& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* MemDialResponse::clone() {
    return new MemDialResponse(*this);
}

inline bool MemDialResponse::operator > (const MemDialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void MemDialResponse::clear() {
    clearPath();
}

inline void MemDialResponse::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool MemDialResponse::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& MemDialResponse::getPath () const {
    return _path;
}

inline ::std::string& MemDialResponse::getPathMutable () {
    set_has_path();
    return _path;
}

inline void MemDialResponse::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void MemDialResponse::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void MemDialResponse::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void MemDialResponse::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void MemDialResponse::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RedialRequest::RedialRequest ()  :
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RedialRequest::RedialRequest (const RedialRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _hide_callerid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RedialRequest::RedialRequest (const ::std::string& hide_callerid_)  :
    _hide_callerid (hide_callerid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RedialRequest::~RedialRequest() {
}

inline RedialRequest& RedialRequest::operator = (const RedialRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasHide_callerid()) {
            setHide_callerid(rhs.getHide_callerid());
        } else {
            clearHide_callerid();
        }
    }
    return *this;
}

inline bool RedialRequest::operator == (const RedialRequest& rhs) const {
    return (((!hasHide_callerid() && !rhs.hasHide_callerid()) || getHide_callerid() == rhs.getHide_callerid()));
}

inline bool RedialRequest::operator != (const RedialRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RedialRequest::operator < (const RedialRequest& rhs) const {
    if (hasHide_callerid() || rhs.hasHide_callerid()) {
        if (getHide_callerid() < rhs.getHide_callerid()) return true;
        if (getHide_callerid() > rhs.getHide_callerid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RedialRequest::clone() {
    return new RedialRequest(*this);
}

inline bool RedialRequest::operator > (const RedialRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RedialRequest::clear() {
    clearHide_callerid();
}

inline void RedialRequest::clearHide_callerid() {
    if (hasHide_callerid()) {
         clear_has_hide_callerid();
        _hide_callerid.clear();
     }
}

inline bool RedialRequest::hasHide_callerid () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RedialRequest::getHide_callerid () const {
    return _hide_callerid;
}

inline ::std::string& RedialRequest::getHide_calleridMutable () {
    set_has_hide_callerid();
    return _hide_callerid;
}

inline void RedialRequest::setHide_callerid (const ::std::string& hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid = hide_callerid_;
}

inline void RedialRequest::setHide_callerid (const char* hide_callerid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (hide_callerid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(hide_callerid_);
}

inline void RedialRequest::setHide_callerid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_hide_callerid();
    this->_hide_callerid.assign(value, size);
}

inline void RedialRequest::set_has_hide_callerid () {
    _has_bits_[0] |= 1u << 0;
}

inline void RedialRequest::clear_has_hide_callerid () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RedialResponse::RedialResponse ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RedialResponse::RedialResponse (const RedialResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RedialResponse::RedialResponse (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RedialResponse::~RedialResponse() {
}

inline RedialResponse& RedialResponse::operator = (const RedialResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool RedialResponse::operator == (const RedialResponse& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool RedialResponse::operator != (const RedialResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RedialResponse::operator < (const RedialResponse& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RedialResponse::clone() {
    return new RedialResponse(*this);
}

inline bool RedialResponse::operator > (const RedialResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RedialResponse::clear() {
    clearPath();
}

inline void RedialResponse::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool RedialResponse::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RedialResponse::getPath () const {
    return _path;
}

inline ::std::string& RedialResponse::getPathMutable () {
    set_has_path();
    return _path;
}

inline void RedialResponse::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void RedialResponse::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void RedialResponse::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void RedialResponse::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void RedialResponse::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PrivateChatRequest::PrivateChatRequest ()  :
    _call ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrivateChatRequest::PrivateChatRequest (const PrivateChatRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _call ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrivateChatRequest::PrivateChatRequest (const ::std::string& call_)  :
    _call (call_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrivateChatRequest::~PrivateChatRequest() {
}

inline PrivateChatRequest& PrivateChatRequest::operator = (const PrivateChatRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCall()) {
            setCall(rhs.getCall());
        } else {
            clearCall();
        }
    }
    return *this;
}

inline bool PrivateChatRequest::operator == (const PrivateChatRequest& rhs) const {
    return (((!hasCall() && !rhs.hasCall()) || getCall() == rhs.getCall()));
}

inline bool PrivateChatRequest::operator != (const PrivateChatRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool PrivateChatRequest::operator < (const PrivateChatRequest& rhs) const {
    if (hasCall() || rhs.hasCall()) {
        if (getCall() < rhs.getCall()) return true;
        if (getCall() > rhs.getCall()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrivateChatRequest::clone() {
    return new PrivateChatRequest(*this);
}

inline bool PrivateChatRequest::operator > (const PrivateChatRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrivateChatRequest::clear() {
    clearCall();
}

inline void PrivateChatRequest::clearCall() {
    if (hasCall()) {
         clear_has_call();
        _call.clear();
     }
}

inline bool PrivateChatRequest::hasCall () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PrivateChatRequest::getCall () const {
    return _call;
}

inline ::std::string& PrivateChatRequest::getCallMutable () {
    set_has_call();
    return _call;
}

inline void PrivateChatRequest::setCall (const ::std::string& call_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call = call_;
}

inline void PrivateChatRequest::setCall (const char* call_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call.assign(call_);
}

inline void PrivateChatRequest::setCall (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call.assign(value, size);
}

inline void PrivateChatRequest::set_has_call () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrivateChatRequest::clear_has_call () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PrivateChatResponse::PrivateChatResponse ()  :
    _calls ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PrivateChatResponse::PrivateChatResponse (const PrivateChatResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _calls ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PrivateChatResponse::PrivateChatResponse (const ::std::vector< ::std::string >& calls_)  :
    _calls (calls_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PrivateChatResponse::~PrivateChatResponse() {
}

inline PrivateChatResponse& PrivateChatResponse::operator = (const PrivateChatResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalls()) {
            setCalls(rhs.getCalls());
        } else {
            clearCalls();
        }
    }
    return *this;
}

inline bool PrivateChatResponse::operator == (const PrivateChatResponse& rhs) const {
    return (((!hasCalls() && !rhs.hasCalls()) || getCalls() == rhs.getCalls()));
}

inline bool PrivateChatResponse::operator != (const PrivateChatResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool PrivateChatResponse::operator < (const PrivateChatResponse& rhs) const {
    if (hasCalls() || rhs.hasCalls()) {
        if (getCalls() < rhs.getCalls()) return true;
        if (getCalls() > rhs.getCalls()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PrivateChatResponse::clone() {
    return new PrivateChatResponse(*this);
}

inline bool PrivateChatResponse::operator > (const PrivateChatResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PrivateChatResponse::clear() {
    clearCalls();
}

inline void PrivateChatResponse::clearCalls() {
    if (hasCalls()) {
         clear_has_calls();
        _calls.clear();
     }
}

inline bool PrivateChatResponse::hasCalls () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& PrivateChatResponse::getCalls () const {
    return _calls;
}

inline ::std::vector< ::std::string >& PrivateChatResponse::getCallsMutable () {
    set_has_calls();
    return _calls;
}

inline void PrivateChatResponse::setCalls (const ::std::vector< ::std::string >& calls_) {
    set_has_calls();
    this->_calls = calls_;
}

inline void PrivateChatResponse::set_has_calls () {
    _has_bits_[0] |= 1u << 0;
}

inline void PrivateChatResponse::clear_has_calls () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CreateMultipartyResponse::CreateMultipartyResponse ()  :
    _calls ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateMultipartyResponse::CreateMultipartyResponse (const CreateMultipartyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _calls ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateMultipartyResponse::CreateMultipartyResponse (const ::std::vector< ::std::string >& calls_)  :
    _calls (calls_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateMultipartyResponse::~CreateMultipartyResponse() {
}

inline CreateMultipartyResponse& CreateMultipartyResponse::operator = (const CreateMultipartyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCalls()) {
            setCalls(rhs.getCalls());
        } else {
            clearCalls();
        }
    }
    return *this;
}

inline bool CreateMultipartyResponse::operator == (const CreateMultipartyResponse& rhs) const {
    return (((!hasCalls() && !rhs.hasCalls()) || getCalls() == rhs.getCalls()));
}

inline bool CreateMultipartyResponse::operator != (const CreateMultipartyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateMultipartyResponse::operator < (const CreateMultipartyResponse& rhs) const {
    if (hasCalls() || rhs.hasCalls()) {
        if (getCalls() < rhs.getCalls()) return true;
        if (getCalls() > rhs.getCalls()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateMultipartyResponse::clone() {
    return new CreateMultipartyResponse(*this);
}

inline bool CreateMultipartyResponse::operator > (const CreateMultipartyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateMultipartyResponse::clear() {
    clearCalls();
}

inline void CreateMultipartyResponse::clearCalls() {
    if (hasCalls()) {
         clear_has_calls();
        _calls.clear();
     }
}

inline bool CreateMultipartyResponse::hasCalls () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< ::std::string >& CreateMultipartyResponse::getCalls () const {
    return _calls;
}

inline ::std::vector< ::std::string >& CreateMultipartyResponse::getCallsMutable () {
    set_has_calls();
    return _calls;
}

inline void CreateMultipartyResponse::setCalls (const ::std::vector< ::std::string >& calls_) {
    set_has_calls();
    this->_calls = calls_;
}

inline void CreateMultipartyResponse::set_has_calls () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateMultipartyResponse::clear_has_calls () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SendTonesRequest::SendTonesRequest ()  :
    _SendTones ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SendTonesRequest::SendTonesRequest (const SendTonesRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _SendTones ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SendTonesRequest::SendTonesRequest (const ::std::string& SendTones_)  :
    _SendTones (SendTones_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SendTones_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SendTonesRequest::~SendTonesRequest() {
}

inline SendTonesRequest& SendTonesRequest::operator = (const SendTonesRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSendTones()) {
            setSendTones(rhs.getSendTones());
        } else {
            clearSendTones();
        }
    }
    return *this;
}

inline bool SendTonesRequest::operator == (const SendTonesRequest& rhs) const {
    return (((!hasSendTones() && !rhs.hasSendTones()) || getSendTones() == rhs.getSendTones()));
}

inline bool SendTonesRequest::operator != (const SendTonesRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SendTonesRequest::operator < (const SendTonesRequest& rhs) const {
    if (hasSendTones() || rhs.hasSendTones()) {
        if (getSendTones() < rhs.getSendTones()) return true;
        if (getSendTones() > rhs.getSendTones()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SendTonesRequest::clone() {
    return new SendTonesRequest(*this);
}

inline bool SendTonesRequest::operator > (const SendTonesRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SendTonesRequest::clear() {
    clearSendTones();
}

inline void SendTonesRequest::clearSendTones() {
    if (hasSendTones()) {
         clear_has_SendTones();
        _SendTones.clear();
     }
}

inline bool SendTonesRequest::hasSendTones () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SendTonesRequest::getSendTones () const {
    return _SendTones;
}

inline ::std::string& SendTonesRequest::getSendTonesMutable () {
    set_has_SendTones();
    return _SendTones;
}

inline void SendTonesRequest::setSendTones (const ::std::string& SendTones_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SendTones_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SendTones();
    this->_SendTones = SendTones_;
}

inline void SendTonesRequest::setSendTones (const char* SendTones_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (SendTones_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SendTones();
    this->_SendTones.assign(SendTones_);
}

inline void SendTonesRequest::setSendTones (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_SendTones();
    this->_SendTones.assign(value, size);
}

inline void SendTonesRequest::set_has_SendTones () {
    _has_bits_[0] |= 1u << 0;
}

inline void SendTonesRequest::clear_has_SendTones () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CallAddedSignal::CallAddedSignal ()  :
    _call (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallAddedSignal::CallAddedSignal (const CallAddedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _call (),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallAddedSignal::CallAddedSignal (const ::std::string& call_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _call (call_),
    _properties (properties_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CallAddedSignal::~CallAddedSignal() {
}

inline CallAddedSignal& CallAddedSignal::operator = (const CallAddedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasCall()) {
            setCall(rhs.getCall());
        } else {
            clearCall();
        }
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool CallAddedSignal::operator == (const CallAddedSignal& rhs) const {
    return (((!hasCall() && !rhs.hasCall()) || getCall() == rhs.getCall()) &&
        ((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool CallAddedSignal::operator != (const CallAddedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool CallAddedSignal::operator < (const CallAddedSignal& rhs) const {
    if (hasCall() || rhs.hasCall()) {
        if (getCall() < rhs.getCall()) return true;
        if (getCall() > rhs.getCall()) return false;
    }
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CallAddedSignal::clone() {
    return new CallAddedSignal(*this);
}

inline bool CallAddedSignal::operator > (const CallAddedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallAddedSignal::clear() {
    clearCall();
    clearProperties();
}

inline void CallAddedSignal::clearCall() {
    if (hasCall()) {
         clear_has_call();
        _call.clear();
     }
}

inline bool CallAddedSignal::hasCall () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CallAddedSignal::getCall () const {
    return _call;
}

inline ::std::string& CallAddedSignal::getCallMutable () {
    set_has_call();
    return _call;
}

inline void CallAddedSignal::setCall (const ::std::string& call_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call = call_;
}

inline void CallAddedSignal::setCall (const char* call_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (call_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call.assign(call_);
}

inline void CallAddedSignal::setCall (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_call();
    this->_call.assign(value, size);
}

inline void CallAddedSignal::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool CallAddedSignal::hasProperties () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CallAddedSignal::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CallAddedSignal::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void CallAddedSignal::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void CallAddedSignal::set_has_call () {
    _has_bits_[0] |= 1u << 0;
}

inline void CallAddedSignal::clear_has_call () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CallAddedSignal::set_has_properties () {
    _has_bits_[0] |= 1u << 1;
}

inline void CallAddedSignal::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CallRemovedSignal::CallRemovedSignal ()  :
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CallRemovedSignal::CallRemovedSignal (const CallRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _path ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CallRemovedSignal::CallRemovedSignal (const ::std::string& path_)  :
    _path (path_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CallRemovedSignal::~CallRemovedSignal() {
}

inline CallRemovedSignal& CallRemovedSignal::operator = (const CallRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPath()) {
            setPath(rhs.getPath());
        } else {
            clearPath();
        }
    }
    return *this;
}

inline bool CallRemovedSignal::operator == (const CallRemovedSignal& rhs) const {
    return (((!hasPath() && !rhs.hasPath()) || getPath() == rhs.getPath()));
}

inline bool CallRemovedSignal::operator != (const CallRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool CallRemovedSignal::operator < (const CallRemovedSignal& rhs) const {
    if (hasPath() || rhs.hasPath()) {
        if (getPath() < rhs.getPath()) return true;
        if (getPath() > rhs.getPath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CallRemovedSignal::clone() {
    return new CallRemovedSignal(*this);
}

inline bool CallRemovedSignal::operator > (const CallRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CallRemovedSignal::clear() {
    clearPath();
}

inline void CallRemovedSignal::clearPath() {
    if (hasPath()) {
         clear_has_path();
        _path.clear();
     }
}

inline bool CallRemovedSignal::hasPath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CallRemovedSignal::getPath () const {
    return _path;
}

inline ::std::string& CallRemovedSignal::getPathMutable () {
    set_has_path();
    return _path;
}

inline void CallRemovedSignal::setPath (const ::std::string& path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path = path_;
}

inline void CallRemovedSignal::setPath (const char* path_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (path_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(path_);
}

inline void CallRemovedSignal::setPath (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_path();
    this->_path.assign(value, size);
}

inline void CallRemovedSignal::set_has_path () {
    _has_bits_[0] |= 1u << 0;
}

inline void CallRemovedSignal::clear_has_path () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  PropertyChangedSignal::PropertyChangedSignal ()  :
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::PropertyChangedSignal (const PropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _name (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertyChangedSignal::PropertyChangedSignal (const ::std::string& name_, const ::asf::dbus::DBusVariant& value_)  :
    _name (name_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::~PropertyChangedSignal() {
}

inline PropertyChangedSignal& PropertyChangedSignal::operator = (const PropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool PropertyChangedSignal::operator == (const PropertyChangedSignal& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool PropertyChangedSignal::operator != (const PropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertyChangedSignal::operator < (const PropertyChangedSignal& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertyChangedSignal::clone() {
    return new PropertyChangedSignal(*this);
}

inline bool PropertyChangedSignal::operator > (const PropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertyChangedSignal::clear() {
    clearName();
    clearValue();
}

inline void PropertyChangedSignal::clearName() {
    if (hasName()) {
         clear_has_name();
        _name.clear();
     }
}

inline bool PropertyChangedSignal::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertyChangedSignal::getName () const {
    return _name;
}

inline ::std::string& PropertyChangedSignal::getNameMutable () {
    set_has_name();
    return _name;
}

inline void PropertyChangedSignal::setName (const ::std::string& name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name = name_;
}

inline void PropertyChangedSignal::setName (const char* name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(name_);
}

inline void PropertyChangedSignal::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_name();
    this->_name.assign(value, size);
}

inline void PropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool PropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& PropertyChangedSignal::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& PropertyChangedSignal::getValueMutable () {
    set_has_value();
    return _value;
}

inline void PropertyChangedSignal::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void PropertyChangedSignal::set_has_name () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertyChangedSignal::clear_has_name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace VoiceCallManager
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_VOICECALLMANAGER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
