/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_MODEMSTUB_H
#define ORG_OFONO_MODEMSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/ofono/Modem.h"
#include <map>
#include <string>

namespace org {
namespace ofono {
namespace Modem {

class ModemStubDelegate;

class ModemStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ModemStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ModemStub (const std::string& portName);

    /**
     * Create an instance of the ModemStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ModemStub (const std::string& portName, const std::string& objectPath);

    virtual ~ModemStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // signal 'SCOConnectRequest'

    /**
     * Raise the signal 'SCOConnectRequest' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SCOConnectRequest'</b>:
     *
     * If the meaning of "SCOConnectRequest" isn't clear, then there should be a description here.
     */
    void sendSCOConnectRequestSignal(uint8 type);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperty'

    /**
     * The method onSetProperty() is called by ASF when a client invokes the
     * method 'SetProperty'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetProperty() or
     * sendSetPropertyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertyRequest (const ::boost::shared_ptr< SetPropertyRequest >& request) = 0;

    /**
     * The method sendSetPropertyResponse() sends a response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertyResponse (act_t act = 0);

    /**
     * The method sendSetPropertyError() sends an error response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperty(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AcceptSCOConnect'

    /**
     * The method onAcceptSCOConnect() is called by ASF when a client invokes
     * the method 'AcceptSCOConnect'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendAcceptSCOConnect() or sendAcceptSCOConnectError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'AcceptSCOConnect'</b>:
     *
     * If the meaning of "AcceptSCOConnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAcceptSCOConnectRequest (const ::boost::shared_ptr< AcceptSCOConnectRequest >& request) = 0;

    /**
     * The method sendAcceptSCOConnectResponse() sends a response of a
     * previous method invocation of 'AcceptSCOConnect' back to the client.
     *
     * <b>Documentation of 'AcceptSCOConnect'</b>:
     *
     * If the meaning of "AcceptSCOConnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAcceptSCOConnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAcceptSCOConnectResponse (act_t act = 0);

    /**
     * The method sendAcceptSCOConnectError() sends an error response of a
     * previous method invocation of 'AcceptSCOConnect' back to the client.
     *
     * <b>Documentation of 'AcceptSCOConnect'</b>:
     *
     * If the meaning of "AcceptSCOConnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAcceptSCOConnect(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAcceptSCOConnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ModemStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Modem
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_MODEMSTUB_H
