/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_MODEMPROXY_H
#define ORG_OFONO_MODEMPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/ofono/Modem.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace ofono {
namespace Modem {

class ModemProxy;

class AcceptSCOConnectCallbackIF {
public:
    virtual ~AcceptSCOConnectCallbackIF() {}

    virtual void onAcceptSCOConnectError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectError >& error) = 0;

    virtual void onAcceptSCOConnectResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< AcceptSCOConnectResponse >& response) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};

class SCOConnectRequestCallbackIF {
public:
    virtual ~SCOConnectRequestCallbackIF() {}

    virtual void onSCOConnectRequestError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestError >& error) = 0;

    virtual void onSCOConnectRequestSignal(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SCOConnectRequestSignal >& signal) = 0;
};

class SetPropertyCallbackIF {
public:
    virtual ~SetPropertyCallbackIF() {}

    virtual void onSetPropertyError(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

    virtual void onSetPropertyResponse(const ::boost::shared_ptr< ModemProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;
};


/**
 * ModemProxy is the client side representation of the D-Bus service
 * interface 'org.ofono.Modem' (specified in file handsfree_modem.xml).
 *
 * If the meaning of "org.ofono.Modem" isn't clear, then there should be a description here.
 */
class ModemProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ModemProxy.
     */
    static ::boost::shared_ptr< ModemProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ModemProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ModemProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ModemProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ModemProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ModemProxy > proxyNew(new ModemProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ModemProxy ();


    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;

    // Signal 'SCOConnectRequest'

    /**
     * Notify on the signal 'SCOConnectRequest'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'SCOConnectRequest'</b>:
     *
     * If the meaning of "SCOConnectRequest" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSCOConnectRequestRegister(SCOConnectRequestCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'SCOConnectRequest'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'SCOConnectRequest'</b>:
     *
     * If the meaning of "SCOConnectRequest" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSCOConnectRequestRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSCOConnectRequestDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'SCOConnectRequest'.
     */
    void sendSCOConnectRequestDeregisterAll () const;



    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'SetProperty'

    /**
     * Call the method 'SetProperty'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param property If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& property, const ::asf::dbus::DBusVariant& value) const;

    // Method 'AcceptSCOConnect'

    /**
     * Call the method 'AcceptSCOConnect'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'AcceptSCOConnect'</b>:
     *
     * If the meaning of "AcceptSCOConnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAcceptSCOConnectRequest(AcceptSCOConnectCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ModemProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ModemProxyCallback;
};

} // namespace Modem
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_MODEMPROXY_H
