#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_OFONO_CALLVOLUME_H
#define ORG_OFONO_CALLVOLUME_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "CallVolume" isn't clear, then there should be a description here.
 */

namespace org {
namespace ofono {
namespace CallVolume {

// method IDs
static const uint16 ID_GetProperties = 0;
static const uint16 ID_SetProperty = 1;

// signal IDs
static const uint16 ID_PropertyChanged = 2;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class GetPropertiesResponse;

class SetPropertyRequest;

class PropertyChangedSignal;

// type definitions
/**
 * If the meaning of "GetPropertiesRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage GetPropertiesRequest;

/**
 * If the meaning of "GetPropertiesError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError GetPropertiesError;

/**
 * If the meaning of "SetPropertyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage SetPropertyResponse;

/**
 * If the meaning of "SetPropertyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SetPropertyError;

/**
 * If the meaning of "PropertyChangedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError PropertyChangedError;


/**
 * If the meaning of "GetPropertiesResponse" isn't clear, then there should be a description here.
 */
class GetPropertiesResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  GetPropertiesResponse ();

    /**
     * Copy constructor
     */
    inline  GetPropertiesResponse (const GetPropertiesResponse &rhs);

    /**
     * All fields constructor
     */
    inline  GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    /**
     * Destructor
     */
    inline virtual  ~GetPropertiesResponse();

    /**
     * Assignment operator
     */
    inline GetPropertiesResponse& operator = (const GetPropertiesResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const GetPropertiesResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const GetPropertiesResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const GetPropertiesResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const GetPropertiesResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "properties"

    static const int kProperties = 0;

    /**
     * Clears the field "properties".
     *
     * The field will be set to its default value. The hasProperties()
     * method will return false.
     */
    inline void clearProperties();

    /**
     * Checks whether the field "properties" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperties()). Otherwise it will return false.
     */
    inline bool hasProperties () const;

    /**
     * Returns the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @return The value of the field "properties"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getProperties () const;

    /**
     * Retrieves the value of the field "properties" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "properties".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getPropertiesMutable ();

    /**
     * Sets the value of the member "properties".
     *
     * If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param properties The value which will be set
     */
    inline void setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_);

    static const GetPropertiesResponse &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_properties ();

    inline void clear_has_properties ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _properties;

};

/**
 * If the meaning of "SetPropertyRequest" isn't clear, then there should be a description here.
 */
class SetPropertyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SetPropertyRequest ();

    /**
     * Copy constructor
     */
    inline  SetPropertyRequest (const SetPropertyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  SetPropertyRequest (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~SetPropertyRequest();

    /**
     * Assignment operator
     */
    inline SetPropertyRequest& operator = (const SetPropertyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SetPropertyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SetPropertyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SetPropertyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SetPropertyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "property"

    static const int kProperty = 0;

    /**
     * Clears the field "property".
     *
     * The field will be set to its default value. The hasProperty()
     * method will return false.
     */
    inline void clearProperty();

    /**
     * Checks whether the field "property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperty()). Otherwise it will return false.
     */
    inline bool hasProperty () const;

    /**
     * Returns the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return The value of the field "property"
     */
    inline const ::std::string& getProperty () const;

    /**
     * Retrieves the value of the field "property" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "property".
     */
    inline ::std::string& getPropertyMutable ();

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const ::std::string& property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const SetPropertyRequest &getDefaultInstance();

private:

    inline void set_has_property ();

    inline void clear_has_property ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _property;

    ::asf::dbus::DBusVariant _value;

};

/**
 * If the meaning of "PropertyChangedSignal" isn't clear, then there should be a description here.
 */
class PropertyChangedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  PropertyChangedSignal ();

    /**
     * Copy constructor
     */
    inline  PropertyChangedSignal (const PropertyChangedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  PropertyChangedSignal (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_);

    /**
     * Destructor
     */
    inline virtual  ~PropertyChangedSignal();

    /**
     * Assignment operator
     */
    inline PropertyChangedSignal& operator = (const PropertyChangedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const PropertyChangedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const PropertyChangedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const PropertyChangedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const PropertyChangedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "property"

    static const int kProperty = 0;

    /**
     * Clears the field "property".
     *
     * The field will be set to its default value. The hasProperty()
     * method will return false.
     */
    inline void clearProperty();

    /**
     * Checks whether the field "property" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setProperty()). Otherwise it will return false.
     */
    inline bool hasProperty () const;

    /**
     * Returns the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @return The value of the field "property"
     */
    inline const ::std::string& getProperty () const;

    /**
     * Retrieves the value of the field "property" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "property".
     */
    inline ::std::string& getPropertyMutable ();

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const ::std::string& property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* property_);

    /**
     * Sets the value of the member "property".
     *
     * If the meaning of "property" isn't clear, then there should be a description here.
     *
     * @param property The value which will be set
     */
    inline void setProperty (const char* value, size_t size);

    // API of field "value"

    static const int kValue = 1;

    /**
     * Clears the field "value".
     *
     * The field will be set to its default value. The hasValue()
     * method will return false.
     */
    inline void clearValue();

    /**
     * Checks whether the field "value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setValue()). Otherwise it will return false.
     */
    inline bool hasValue () const;

    /**
     * Returns the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "value"
     */
    inline const ::asf::dbus::DBusVariant& getValue () const;

    /**
     * Retrieves the value of the field "value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "value".
     */
    inline ::asf::dbus::DBusVariant& getValueMutable ();

    /**
     * Sets the value of the member "value".
     *
     * If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @param value The value which will be set
     */
    inline void setValue (const ::asf::dbus::DBusVariant& value_);

    static const PropertyChangedSignal &getDefaultInstance();

private:

    inline void set_has_property ();

    inline void clear_has_property ();

    inline void set_has_value ();

    inline void clear_has_value ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _property;

    ::asf::dbus::DBusVariant _value;

};

inline  GetPropertiesResponse::GetPropertiesResponse ()  :
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::GetPropertiesResponse (const GetPropertiesResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _properties ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  GetPropertiesResponse::GetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_)  :
    _properties (properties_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  GetPropertiesResponse::~GetPropertiesResponse() {
}

inline GetPropertiesResponse& GetPropertiesResponse::operator = (const GetPropertiesResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperties()) {
            setProperties(rhs.getProperties());
        } else {
            clearProperties();
        }
    }
    return *this;
}

inline bool GetPropertiesResponse::operator == (const GetPropertiesResponse& rhs) const {
    return (((!hasProperties() && !rhs.hasProperties()) || getProperties() == rhs.getProperties()));
}

inline bool GetPropertiesResponse::operator != (const GetPropertiesResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool GetPropertiesResponse::operator < (const GetPropertiesResponse& rhs) const {
    if (hasProperties() || rhs.hasProperties()) {
        if (getProperties() < rhs.getProperties()) return true;
        if (getProperties() > rhs.getProperties()) return false;
    }
    return false;
}

inline ::asf::core::Payload* GetPropertiesResponse::clone() {
    return new GetPropertiesResponse(*this);
}

inline bool GetPropertiesResponse::operator > (const GetPropertiesResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void GetPropertiesResponse::clear() {
    clearProperties();
}

inline void GetPropertiesResponse::clearProperties() {
    if (hasProperties()) {
         clear_has_properties();
        _properties.clear();
     }
}

inline bool GetPropertiesResponse::hasProperties () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getProperties () const {
    return _properties;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& GetPropertiesResponse::getPropertiesMutable () {
    set_has_properties();
    return _properties;
}

inline void GetPropertiesResponse::setProperties (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties_) {
    set_has_properties();
    this->_properties = properties_;
}

inline void GetPropertiesResponse::set_has_properties () {
    _has_bits_[0] |= 1u << 0;
}

inline void GetPropertiesResponse::clear_has_properties () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SetPropertyRequest::SetPropertyRequest ()  :
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SetPropertyRequest::SetPropertyRequest (const SetPropertyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SetPropertyRequest::SetPropertyRequest (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_)  :
    _property (property_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SetPropertyRequest::~SetPropertyRequest() {
}

inline SetPropertyRequest& SetPropertyRequest::operator = (const SetPropertyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperty()) {
            setProperty(rhs.getProperty());
        } else {
            clearProperty();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool SetPropertyRequest::operator == (const SetPropertyRequest& rhs) const {
    return (((!hasProperty() && !rhs.hasProperty()) || getProperty() == rhs.getProperty()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool SetPropertyRequest::operator != (const SetPropertyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool SetPropertyRequest::operator < (const SetPropertyRequest& rhs) const {
    if (hasProperty() || rhs.hasProperty()) {
        if (getProperty() < rhs.getProperty()) return true;
        if (getProperty() > rhs.getProperty()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SetPropertyRequest::clone() {
    return new SetPropertyRequest(*this);
}

inline bool SetPropertyRequest::operator > (const SetPropertyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SetPropertyRequest::clear() {
    clearProperty();
    clearValue();
}

inline void SetPropertyRequest::clearProperty() {
    if (hasProperty()) {
         clear_has_property();
        _property.clear();
     }
}

inline bool SetPropertyRequest::hasProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SetPropertyRequest::getProperty () const {
    return _property;
}

inline ::std::string& SetPropertyRequest::getPropertyMutable () {
    set_has_property();
    return _property;
}

inline void SetPropertyRequest::setProperty (const ::std::string& property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property = property_;
}

inline void SetPropertyRequest::setProperty (const char* property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(property_);
}

inline void SetPropertyRequest::setProperty (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(value, size);
}

inline void SetPropertyRequest::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool SetPropertyRequest::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& SetPropertyRequest::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& SetPropertyRequest::getValueMutable () {
    set_has_value();
    return _value;
}

inline void SetPropertyRequest::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void SetPropertyRequest::set_has_property () {
    _has_bits_[0] |= 1u << 0;
}

inline void SetPropertyRequest::clear_has_property () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SetPropertyRequest::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void SetPropertyRequest::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  PropertyChangedSignal::PropertyChangedSignal ()  :
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::PropertyChangedSignal (const PropertyChangedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _property (),
    _value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  PropertyChangedSignal::PropertyChangedSignal (const ::std::string& property_, const ::asf::dbus::DBusVariant& value_)  :
    _property (property_),
    _value (value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  PropertyChangedSignal::~PropertyChangedSignal() {
}

inline PropertyChangedSignal& PropertyChangedSignal::operator = (const PropertyChangedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasProperty()) {
            setProperty(rhs.getProperty());
        } else {
            clearProperty();
        }
        if (rhs.hasValue()) {
            setValue(rhs.getValue());
        } else {
            clearValue();
        }
    }
    return *this;
}

inline bool PropertyChangedSignal::operator == (const PropertyChangedSignal& rhs) const {
    return (((!hasProperty() && !rhs.hasProperty()) || getProperty() == rhs.getProperty()) &&
        ((!hasValue() && !rhs.hasValue()) || getValue() == rhs.getValue()));
}

inline bool PropertyChangedSignal::operator != (const PropertyChangedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool PropertyChangedSignal::operator < (const PropertyChangedSignal& rhs) const {
    if (hasProperty() || rhs.hasProperty()) {
        if (getProperty() < rhs.getProperty()) return true;
        if (getProperty() > rhs.getProperty()) return false;
    }
    if (hasValue() || rhs.hasValue()) {
        if (getValue() < rhs.getValue()) return true;
        if (getValue() > rhs.getValue()) return false;
    }
    return false;
}

inline ::asf::core::Payload* PropertyChangedSignal::clone() {
    return new PropertyChangedSignal(*this);
}

inline bool PropertyChangedSignal::operator > (const PropertyChangedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void PropertyChangedSignal::clear() {
    clearProperty();
    clearValue();
}

inline void PropertyChangedSignal::clearProperty() {
    if (hasProperty()) {
         clear_has_property();
        _property.clear();
     }
}

inline bool PropertyChangedSignal::hasProperty () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& PropertyChangedSignal::getProperty () const {
    return _property;
}

inline ::std::string& PropertyChangedSignal::getPropertyMutable () {
    set_has_property();
    return _property;
}

inline void PropertyChangedSignal::setProperty (const ::std::string& property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property = property_;
}

inline void PropertyChangedSignal::setProperty (const char* property_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (property_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(property_);
}

inline void PropertyChangedSignal::setProperty (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_property();
    this->_property.assign(value, size);
}

inline void PropertyChangedSignal::clearValue() {
    if (hasValue()) {
         clear_has_value();
        _value = ::asf::dbus::DBusVariant ();
     }
}

inline bool PropertyChangedSignal::hasValue () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::asf::dbus::DBusVariant& PropertyChangedSignal::getValue () const {
    return _value;
}

inline ::asf::dbus::DBusVariant& PropertyChangedSignal::getValueMutable () {
    set_has_value();
    return _value;
}

inline void PropertyChangedSignal::setValue (const ::asf::dbus::DBusVariant& value_) {
    set_has_value();
    this->_value = value_;
}

inline void PropertyChangedSignal::set_has_property () {
    _has_bits_[0] |= 1u << 0;
}

inline void PropertyChangedSignal::clear_has_property () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void PropertyChangedSignal::set_has_value () {
    _has_bits_[0] |= 1u << 1;
}

inline void PropertyChangedSignal::clear_has_value () {
    _has_bits_[0] &= ~ (1u << 1);
}

} // namespace CallVolume
} // namespace ofono
} // namespace org

#endif // ORG_OFONO_CALLVOLUME_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
