/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_TRANSFERSTUB_H
#define ORG_BLUEZ_OBEX_TRANSFERSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Transfer.h"
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Transfer {

class TransferStubDelegate;

class TransferStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TransferStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TransferStub (const std::string& portName);

    /**
     * Create an instance of the TransferStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TransferStub (const std::string& portName, const std::string& objectPath);

    virtual ~TransferStub();

    // property 'Status'

    /**
     * The method onStatusGet() is called by ASF when a client invokes the
     * read method for the property 'Status'. The onStatusGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    virtual void onStatusGet(const ::boost::shared_ptr< StatusGet >& payload);

    /**
     * Sends back the update to a previous onStatusGet().
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStatusGetUpdate(const ::std::string& status, act_t act = 0);

    /**
     * Set the value of the property 'Status' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    void setStatus(const ::std::string& status);

    /**
     * Returns the current value of the property 'Status'.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    const ::std::string& getStatus() const;

    /**
     * Returns the current value of the property 'Status' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStatusUpdate() method.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    ::std::string& getStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusUpdate().
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    void sendStatusUpdate();

    // property 'Session'

    /**
     * The method onSessionGet() is called by ASF when a client invokes the
     * read method for the property 'Session'. The onSessionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     */
    virtual void onSessionGet(const ::boost::shared_ptr< SessionGet >& payload);

    /**
     * Sends back the update to a previous onSessionGet().
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSessionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSessionGetUpdate(const ::std::string& session, act_t act = 0);

    /**
     * Set the value of the property 'Session' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     */
    void setSession(const ::std::string& session);

    /**
     * Returns the current value of the property 'Session'.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     */
    const ::std::string& getSession() const;

    /**
     * Returns the current value of the property 'Session' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSessionUpdate() method.
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     */
    ::std::string& getSessionMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSessionUpdate().
     *
     * <b>Documentation of 'Session'</b>:
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     */
    void sendSessionUpdate();

    // property 'Name'

    /**
     * The method onNameGet() is called by ASF when a client invokes the read
     * method for the property 'Name'. The onNameGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    virtual void onNameGet(const ::boost::shared_ptr< NameGet >& payload);

    /**
     * Sends back the update to a previous onNameGet().
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onNameGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendNameGetUpdate(const ::std::string& name, act_t act = 0);

    /**
     * Set the value of the property 'Name' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    void setName(const ::std::string& name);

    /**
     * Returns the current value of the property 'Name'.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    const ::std::string& getName() const;

    /**
     * Returns the current value of the property 'Name' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendNameUpdate() method.
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    ::std::string& getNameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendNameUpdate().
     *
     * <b>Documentation of 'Name'</b>:
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     */
    void sendNameUpdate();

    // property 'Type'

    /**
     * The method onTypeGet() is called by ASF when a client invokes the read
     * method for the property 'Type'. The onTypeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    virtual void onTypeGet(const ::boost::shared_ptr< TypeGet >& payload);

    /**
     * Sends back the update to a previous onTypeGet().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTypeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTypeGetUpdate(const ::std::string& type, act_t act = 0);

    /**
     * Set the value of the property 'Type' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void setType(const ::std::string& type);

    /**
     * Returns the current value of the property 'Type'.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    const ::std::string& getType() const;

    /**
     * Returns the current value of the property 'Type' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTypeUpdate() method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    ::std::string& getTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTypeUpdate().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void sendTypeUpdate();

    // property 'Time'

    /**
     * The method onTimeGet() is called by ASF when a client invokes the read
     * method for the property 'Time'. The onTimeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     */
    virtual void onTimeGet(const ::boost::shared_ptr< TimeGet >& payload);

    /**
     * Sends back the update to a previous onTimeGet().
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTimeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTimeGetUpdate(uint8 time, act_t act = 0);

    /**
     * Set the value of the property 'Time' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     */
    void setTime(uint8 time);

    /**
     * Returns the current value of the property 'Time'.
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     */
    uint8 getTime() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTimeUpdate().
     *
     * <b>Documentation of 'Time'</b>:
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     */
    void sendTimeUpdate();

    // property 'Size'

    /**
     * The method onSizeGet() is called by ASF when a client invokes the read
     * method for the property 'Size'. The onSizeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    virtual void onSizeGet(const ::boost::shared_ptr< SizeGet >& payload);

    /**
     * Sends back the update to a previous onSizeGet().
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSizeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSizeGetUpdate(uint64 size, act_t act = 0);

    /**
     * Set the value of the property 'Size' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    void setSize(uint64 size);

    /**
     * Returns the current value of the property 'Size'.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    uint64 getSize() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSizeUpdate().
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    void sendSizeUpdate();

    // property 'Transferred'

    /**
     * The method onTransferredGet() is called by ASF when a client invokes
     * the read method for the property 'Transferred'. The onTransferredGet()
     * method returns by default the current property value to the caller. In
     * case this default behavior doesn't match your needs feel free to
     * override this method.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     */
    virtual void onTransferredGet(const ::boost::shared_ptr< TransferredGet >& payload);

    /**
     * Sends back the update to a previous onTransferredGet().
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTransferredGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendTransferredGetUpdate(uint64 transferred, act_t act = 0);

    /**
     * Set the value of the property 'Transferred' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     */
    void setTransferred(uint64 transferred);

    /**
     * Returns the current value of the property 'Transferred'.
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     */
    uint64 getTransferred() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTransferredUpdate().
     *
     * <b>Documentation of 'Transferred'</b>:
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     */
    void sendTransferredUpdate();

    // property 'Filename'

    /**
     * The method onFilenameGet() is called by ASF when a client invokes the
     * read method for the property 'Filename'. The onFilenameGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     */
    virtual void onFilenameGet(const ::boost::shared_ptr< FilenameGet >& payload);

    /**
     * Sends back the update to a previous onFilenameGet().
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onFilenameGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendFilenameGetUpdate(const ::std::string& filename, act_t act = 0);

    /**
     * Set the value of the property 'Filename' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     */
    void setFilename(const ::std::string& filename);

    /**
     * Returns the current value of the property 'Filename'.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     */
    const ::std::string& getFilename() const;

    /**
     * Returns the current value of the property 'Filename' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFilenameUpdate() method.
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     */
    ::std::string& getFilenameMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFilenameUpdate().
     *
     * <b>Documentation of 'Filename'</b>:
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     */
    void sendFilenameUpdate();

    // method 'Cancel'

    /**
     * The method onCancel() is called by ASF when a client invokes the method
     * 'Cancel'. A subclass has to implement this method and send back a
     * response to the client either with the sendCancel() or
     * sendCancelError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRequest (const ::boost::shared_ptr< CancelRequest >& request) = 0;

    /**
     * The method sendCancelResponse() sends a response of a previous method
     * invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancel(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelResponse (act_t act = 0);

    /**
     * The method sendCancelError() sends an error response of a previous
     * method invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancel(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    StatusUpdate _StatusProperty;

    SessionUpdate _SessionProperty;

    NameUpdate _NameProperty;

    TypeUpdate _TypeProperty;

    TimeUpdate _TimeProperty;

    SizeUpdate _SizeProperty;

    TransferredUpdate _TransferredProperty;

    FilenameUpdate _FilenameProperty;

    friend class TransferStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Transfer
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_TRANSFERSTUB_H
