/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Transfer.h"
#include "org/bluez/obex/TransferDBus.h"
#include "org/bluez/obex/TransferJson.h"
#include "org/bluez/obex/TransferProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Transfer {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/transfer/created/during/runtime/org/bluez/obex/Transfer", TransferProxy);

class TransferProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    TransferProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< TransferProxy >& proxyShared = ::boost::static_pointer_cast< TransferProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Status:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusError> payload = ::boost::static_pointer_cast<StatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusCallbackIF*) _callback)->onStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusUpdate> payload = ::boost::static_pointer_cast<StatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusCallbackIF*) _callback)->onStatusUpdate(proxyShared, payload);
                        proxyShared->_status = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Session:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SessionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Session", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SessionError> payload = ::boost::static_pointer_cast<SessionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SessionCallbackIF*) _callback)->onSessionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SessionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Session", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SessionUpdate> payload = ::boost::static_pointer_cast<SessionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SessionCallbackIF*) _callback)->onSessionUpdate(proxyShared, payload);
                        proxyShared->_session = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Name:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Name", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NameError> payload = ::boost::static_pointer_cast<NameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NameCallbackIF*) _callback)->onNameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Name", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NameUpdate> payload = ::boost::static_pointer_cast<NameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NameCallbackIF*) _callback)->onNameUpdate(proxyShared, payload);
                        proxyShared->_name = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Type:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeError> payload = ::boost::static_pointer_cast<TypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TypeCallbackIF*) _callback)->onTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeUpdate> payload = ::boost::static_pointer_cast<TypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TypeCallbackIF*) _callback)->onTypeUpdate(proxyShared, payload);
                        proxyShared->_type = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Time:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Time", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeError> payload = ::boost::static_pointer_cast<TimeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimeCallbackIF*) _callback)->onTimeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Time", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimeUpdate> payload = ::boost::static_pointer_cast<TimeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimeCallbackIF*) _callback)->onTimeUpdate(proxyShared, payload);
                        proxyShared->_time = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Size:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SizeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Size", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SizeError> payload = ::boost::static_pointer_cast<SizeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SizeCallbackIF*) _callback)->onSizeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SizeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Size", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SizeUpdate> payload = ::boost::static_pointer_cast<SizeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SizeCallbackIF*) _callback)->onSizeUpdate(proxyShared, payload);
                        proxyShared->_size = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Transferred:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransferredError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Transferred", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransferredError> payload = ::boost::static_pointer_cast<TransferredError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TransferredCallbackIF*) _callback)->onTransferredError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TransferredUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Transferred", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TransferredUpdate> payload = ::boost::static_pointer_cast<TransferredUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TransferredCallbackIF*) _callback)->onTransferredUpdate(proxyShared, payload);
                        proxyShared->_transferred = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Filename:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FilenameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Filename", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FilenameError> payload = ::boost::static_pointer_cast<FilenameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FilenameCallbackIF*) _callback)->onFilenameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FilenameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Filename", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FilenameUpdate> payload = ::boost::static_pointer_cast<FilenameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FilenameCallbackIF*) _callback)->onFilenameUpdate(proxyShared, payload);
                        proxyShared->_filename = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Cancel:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelError> payload = ::boost::static_pointer_cast<CancelError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelResponse> payload = ::boost::static_pointer_cast<CancelResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Status: {
                ::boost::shared_ptr< StatusError > payload = ::boost::shared_ptr< StatusError >
                (new StatusError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Status", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusCallbackIF*) _callback)->onStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Session: {
                ::boost::shared_ptr< SessionError > payload = ::boost::shared_ptr< SessionError >
                (new SessionError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Session", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SessionCallbackIF*) _callback)->onSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Name: {
                ::boost::shared_ptr< NameError > payload = ::boost::shared_ptr< NameError >
                (new NameError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Name", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NameCallbackIF*) _callback)->onNameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Type: {
                ::boost::shared_ptr< TypeError > payload = ::boost::shared_ptr< TypeError >
                (new TypeError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Type", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TypeCallbackIF*) _callback)->onTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Time: {
                ::boost::shared_ptr< TimeError > payload = ::boost::shared_ptr< TimeError >
                (new TimeError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Time", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimeCallbackIF*) _callback)->onTimeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Size: {
                ::boost::shared_ptr< SizeError > payload = ::boost::shared_ptr< SizeError >
                (new SizeError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Size", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SizeCallbackIF*) _callback)->onSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Transferred: {
                ::boost::shared_ptr< TransferredError > payload = ::boost::shared_ptr< TransferredError >
                (new TransferredError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Transferred", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TransferredCallbackIF*) _callback)->onTransferredError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Filename: {
                ::boost::shared_ptr< FilenameError > payload = ::boost::shared_ptr< FilenameError >
                (new FilenameError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Filename", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FilenameCallbackIF*) _callback)->onFilenameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Cancel: {
                ::boost::shared_ptr< CancelError > payload = ::boost::shared_ptr< CancelError >
                (new CancelError(DBUS_ERROR_NO_SERVER, "The DBus service Transfer is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Cancel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TransferProxy> proxyShared = ::boost::static_pointer_cast<TransferProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelCallbackIF*) _callback)->onCancelError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& TransferProxyCallback::_logger (TransferProxy::_logger);

TransferProxy::TransferProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.Transfer", serviceAvailable, _logger) {
}

TransferProxy::~TransferProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< TransferProxy > TransferProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<TransferProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< TransferProxy > proxyNew(new TransferProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t TransferProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    TransferProxyCallback* callback = new TransferProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t TransferProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    TransferProxyCallback* callback = new TransferProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void TransferProxy::clearAllProperties ()
{
    _status = ::asf::core::nullable< StatusUpdate >();
    _session = ::asf::core::nullable< SessionUpdate >();
    _name = ::asf::core::nullable< NameUpdate >();
    _type = ::asf::core::nullable< TypeUpdate >();
    _time = ::asf::core::nullable< TimeUpdate >();
    _size = ::asf::core::nullable< SizeUpdate >();
    _transferred = ::asf::core::nullable< TransferredUpdate >();
    _filename = ::asf::core::nullable< FilenameUpdate >();
}

void TransferProxy::sendDeregisterAll () const
{
    sendStatusDeregisterAll();
    sendSessionDeregisterAll();
    sendNameDeregisterAll();
    sendTypeDeregisterAll();
    sendTimeDeregisterAll();
    sendSizeDeregisterAll();
    sendTransferredDeregisterAll();
    sendFilenameDeregisterAll();
}

act_t TransferProxy::sendStatusRegister(StatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Status, "Status", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Status", &cb, act);
    return act;
}

bool TransferProxy::sendStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Status", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Status", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendStatusGet(StatusCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Status, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Status", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Status", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& TransferProxy::getStatus() const {
    return _status.get().getStatus();
}

bool TransferProxy::hasStatus() const {
    return _status.hasValue();
}

void TransferProxy::sendStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Status");
    _dbusProxyDelegate->deregisterSignalCallback("Status", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendSessionRegister(SessionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Session, "Session", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Session", &cb, act);
    return act;
}

bool TransferProxy::sendSessionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Session", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Session", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendSessionGet(SessionCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Session, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Session", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Session", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& TransferProxy::getSession() const {
    return _session.get().getSession();
}

bool TransferProxy::hasSession() const {
    return _session.hasValue();
}

void TransferProxy::sendSessionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Session");
    _dbusProxyDelegate->deregisterSignalCallback("Session", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendNameRegister(NameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Name, "Name", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Name", &cb, act);
    return act;
}

bool TransferProxy::sendNameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Name", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Name", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendNameGet(NameCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Name, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Name", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Name", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& TransferProxy::getName() const {
    return _name.get().getName();
}

bool TransferProxy::hasName() const {
    return _name.hasValue();
}

void TransferProxy::sendNameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Name");
    _dbusProxyDelegate->deregisterSignalCallback("Name", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendTypeRegister(TypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Type, "Type", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Type", &cb, act);
    return act;
}

bool TransferProxy::sendTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Type", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Type", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendTypeGet(TypeCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Type, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Type", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Type", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& TransferProxy::getType() const {
    return _type.get().getType();
}

bool TransferProxy::hasType() const {
    return _type.hasValue();
}

void TransferProxy::sendTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Type");
    _dbusProxyDelegate->deregisterSignalCallback("Type", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendTimeRegister(TimeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Time, "Time", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Time", &cb, act);
    return act;
}

bool TransferProxy::sendTimeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Time", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Time", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendTimeGet(TimeCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Time, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Time", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Time", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint8 TransferProxy::getTime() const {
    return _time.get().getTime();
}

bool TransferProxy::hasTime() const {
    return _time.hasValue();
}

void TransferProxy::sendTimeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Time");
    _dbusProxyDelegate->deregisterSignalCallback("Time", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendSizeRegister(SizeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Size, "Size", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Size", &cb, act);
    return act;
}

bool TransferProxy::sendSizeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Size", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Size", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendSizeGet(SizeCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Size, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Size", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Size", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 TransferProxy::getSize() const {
    return _size.get().getSize();
}

bool TransferProxy::hasSize() const {
    return _size.hasValue();
}

void TransferProxy::sendSizeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Size");
    _dbusProxyDelegate->deregisterSignalCallback("Size", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendTransferredRegister(TransferredCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Transferred, "Transferred", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Transferred", &cb, act);
    return act;
}

bool TransferProxy::sendTransferredDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Transferred", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Transferred", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendTransferredGet(TransferredCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Transferred, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Transferred", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Transferred", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 TransferProxy::getTransferred() const {
    return _transferred.get().getTransferred();
}

bool TransferProxy::hasTransferred() const {
    return _transferred.hasValue();
}

void TransferProxy::sendTransferredDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Transferred");
    _dbusProxyDelegate->deregisterSignalCallback("Transferred", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendFilenameRegister(FilenameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Filename, "Filename", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Filename", &cb, act);
    return act;
}

bool TransferProxy::sendFilenameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Filename", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Filename", act, static_cast<int>(rv));
    return rv;
}

act_t TransferProxy::sendFilenameGet(FilenameCallbackIF& cb) {
    TransferProxyCallback* callback = new TransferProxyCallback(ID_Filename, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Filename", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Filename", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& TransferProxy::getFilename() const {
    return _filename.get().getFilename();
}

bool TransferProxy::hasFilename() const {
    return _filename.hasValue();
}

void TransferProxy::sendFilenameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Filename");
    _dbusProxyDelegate->deregisterSignalCallback("Filename", 0, _dbusDaemonProxy.get(), true);
}

act_t TransferProxy::sendCancelRequest(CancelCallbackIF& cb) const {
    CancelRequest* payload = new CancelRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Cancel", CancelRequest, payload, true)
    act_t act = addMethodCallback(ID_Cancel, dbusMessage.getUniqueSerial(), "Cancel", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Cancel", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Transfer
} // namespace obex
} // namespace bluez
} // namespace org
