#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_TRANSFER_H
#define ORG_BLUEZ_OBEX_TRANSFER_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Transfer" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace Transfer {

// method IDs
static const uint16 ID_Cancel = 0;

// signal IDs

// property IDs
static const uint16 ID_Status = 1;
static const uint16 ID_Session = 2;
static const uint16 ID_Name = 3;
static const uint16 ID_Type = 4;
static const uint16 ID_Time = 5;
static const uint16 ID_Size = 6;
static const uint16 ID_Transferred = 7;
static const uint16 ID_Filename = 8;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class StatusUpdate;

class StatusRegister;

class SessionUpdate;

class SessionRegister;

class NameUpdate;

class NameRegister;

class TypeUpdate;

class TypeRegister;

class TimeUpdate;

class TimeRegister;

class SizeUpdate;

class SizeRegister;

class TransferredUpdate;

class TransferredRegister;

class FilenameUpdate;

class FilenameRegister;

// type definitions
/**
 * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRequest;

/**
 * If the meaning of "CancelResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelResponse;

/**
 * If the meaning of "CancelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelError;

/**
 * If the meaning of "StatusSet" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusSet;

/**
 * If the meaning of "StatusGet" isn't clear, then there should be a description here.
 */
typedef StatusUpdate StatusGet;

/**
 * If the meaning of "StatusError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StatusError;

/**
 * If the meaning of "SessionSet" isn't clear, then there should be a description here.
 */
typedef SessionUpdate SessionSet;

/**
 * If the meaning of "SessionGet" isn't clear, then there should be a description here.
 */
typedef SessionUpdate SessionGet;

/**
 * If the meaning of "SessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SessionError;

/**
 * If the meaning of "NameSet" isn't clear, then there should be a description here.
 */
typedef NameUpdate NameSet;

/**
 * If the meaning of "NameGet" isn't clear, then there should be a description here.
 */
typedef NameUpdate NameGet;

/**
 * If the meaning of "NameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError NameError;

/**
 * If the meaning of "TypeSet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeSet;

/**
 * If the meaning of "TypeGet" isn't clear, then there should be a description here.
 */
typedef TypeUpdate TypeGet;

/**
 * If the meaning of "TypeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TypeError;

/**
 * If the meaning of "TimeSet" isn't clear, then there should be a description here.
 */
typedef TimeUpdate TimeSet;

/**
 * If the meaning of "TimeGet" isn't clear, then there should be a description here.
 */
typedef TimeUpdate TimeGet;

/**
 * If the meaning of "TimeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TimeError;

/**
 * If the meaning of "SizeSet" isn't clear, then there should be a description here.
 */
typedef SizeUpdate SizeSet;

/**
 * If the meaning of "SizeGet" isn't clear, then there should be a description here.
 */
typedef SizeUpdate SizeGet;

/**
 * If the meaning of "SizeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SizeError;

/**
 * If the meaning of "TransferredSet" isn't clear, then there should be a description here.
 */
typedef TransferredUpdate TransferredSet;

/**
 * If the meaning of "TransferredGet" isn't clear, then there should be a description here.
 */
typedef TransferredUpdate TransferredGet;

/**
 * If the meaning of "TransferredError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TransferredError;

/**
 * If the meaning of "FilenameSet" isn't clear, then there should be a description here.
 */
typedef FilenameUpdate FilenameSet;

/**
 * If the meaning of "FilenameGet" isn't clear, then there should be a description here.
 */
typedef FilenameUpdate FilenameGet;

/**
 * If the meaning of "FilenameError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FilenameError;


/**
 * If the meaning of "StatusUpdate" isn't clear, then there should be a description here.
 */
class StatusUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusUpdate ();

    /**
     * Copy constructor
     */
    inline  StatusUpdate (const StatusUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StatusUpdate (const ::std::string& Status_);

    /**
     * Destructor
     */
    inline virtual  ~StatusUpdate();

    /**
     * Assignment operator
     */
    inline StatusUpdate& operator = (const StatusUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Status"

    static const int kStatus = 0;

    /**
     * Clears the field "Status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "Status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Status"
     */
    inline const ::std::string& getStatus () const;

    /**
     * Retrieves the value of the field "Status" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Status".
     */
    inline ::std::string& getStatusMutable ();

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const ::std::string& Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* Status_);

    /**
     * Sets the value of the member "Status".
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param Status The value which will be set
     */
    inline void setStatus (const char* value, size_t size);

    static const StatusUpdate &getDefaultInstance();

private:

    inline void set_has_Status ();

    inline void clear_has_Status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Status;

};

/**
 * If the meaning of "StatusRegister" isn't clear, then there should be a description here.
 */
class StatusRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StatusRegister ();

    /**
     * Copy constructor
     */
    inline  StatusRegister (const StatusRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StatusRegister();

    /**
     * Assignment operator
     */
    inline StatusRegister& operator = (const StatusRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StatusRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StatusRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StatusRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StatusRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StatusRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SessionUpdate" isn't clear, then there should be a description here.
 */
class SessionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionUpdate ();

    /**
     * Copy constructor
     */
    inline  SessionUpdate (const SessionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SessionUpdate (const ::std::string& Session_);

    /**
     * Destructor
     */
    inline virtual  ~SessionUpdate();

    /**
     * Assignment operator
     */
    inline SessionUpdate& operator = (const SessionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Session"

    static const int kSession = 0;

    /**
     * Clears the field "Session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "Session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "Session".
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "Session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "Session".
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param Session The value which will be set
     */
    inline void setSession (const ::std::string& Session_);

    /**
     * Sets the value of the member "Session".
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param Session The value which will be set
     */
    inline void setSession (const char* Session_);

    /**
     * Sets the value of the member "Session".
     *
     * If the meaning of "Session" isn't clear, then there should be a description here.
     *
     * @param Session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const SessionUpdate &getDefaultInstance();

private:

    inline void set_has_Session ();

    inline void clear_has_Session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Session;

};

/**
 * If the meaning of "SessionRegister" isn't clear, then there should be a description here.
 */
class SessionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionRegister ();

    /**
     * Copy constructor
     */
    inline  SessionRegister (const SessionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SessionRegister();

    /**
     * Assignment operator
     */
    inline SessionRegister& operator = (const SessionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SessionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "NameUpdate" isn't clear, then there should be a description here.
 */
class NameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameUpdate ();

    /**
     * Copy constructor
     */
    inline  NameUpdate (const NameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  NameUpdate (const ::std::string& Name_);

    /**
     * Destructor
     */
    inline virtual  ~NameUpdate();

    /**
     * Assignment operator
     */
    inline NameUpdate& operator = (const NameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Name"

    static const int kName = 0;

    /**
     * Clears the field "Name".
     *
     * The field will be set to its default value. The hasName()
     * method will return false.
     */
    inline void clearName();

    /**
     * Checks whether the field "Name" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setName()). Otherwise it will return false.
     */
    inline bool hasName () const;

    /**
     * Returns the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Name"
     */
    inline const ::std::string& getName () const;

    /**
     * Retrieves the value of the field "Name" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Name".
     */
    inline ::std::string& getNameMutable ();

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const ::std::string& Name_);

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* Name_);

    /**
     * Sets the value of the member "Name".
     *
     * If the meaning of "Name" isn't clear, then there should be a description here.
     *
     * @param Name The value which will be set
     */
    inline void setName (const char* value, size_t size);

    static const NameUpdate &getDefaultInstance();

private:

    inline void set_has_Name ();

    inline void clear_has_Name ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Name;

};

/**
 * If the meaning of "NameRegister" isn't clear, then there should be a description here.
 */
class NameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  NameRegister ();

    /**
     * Copy constructor
     */
    inline  NameRegister (const NameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~NameRegister();

    /**
     * Assignment operator
     */
    inline NameRegister& operator = (const NameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const NameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const NameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const NameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const NameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const NameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TypeUpdate" isn't clear, then there should be a description here.
 */
class TypeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeUpdate ();

    /**
     * Copy constructor
     */
    inline  TypeUpdate (const TypeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TypeUpdate (const ::std::string& Type_);

    /**
     * Destructor
     */
    inline virtual  ~TypeUpdate();

    /**
     * Assignment operator
     */
    inline TypeUpdate& operator = (const TypeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Type"

    static const int kType = 0;

    /**
     * Clears the field "Type".
     *
     * The field will be set to its default value. The hasType()
     * method will return false.
     */
    inline void clearType();

    /**
     * Checks whether the field "Type" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setType()). Otherwise it will return false.
     */
    inline bool hasType () const;

    /**
     * Returns the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Type"
     */
    inline const ::std::string& getType () const;

    /**
     * Retrieves the value of the field "Type" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Type".
     */
    inline ::std::string& getTypeMutable ();

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const ::std::string& Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* Type_);

    /**
     * Sets the value of the member "Type".
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param Type The value which will be set
     */
    inline void setType (const char* value, size_t size);

    static const TypeUpdate &getDefaultInstance();

private:

    inline void set_has_Type ();

    inline void clear_has_Type ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Type;

};

/**
 * If the meaning of "TypeRegister" isn't clear, then there should be a description here.
 */
class TypeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TypeRegister ();

    /**
     * Copy constructor
     */
    inline  TypeRegister (const TypeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TypeRegister();

    /**
     * Assignment operator
     */
    inline TypeRegister& operator = (const TypeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TypeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TypeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TypeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TypeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TypeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TimeUpdate" isn't clear, then there should be a description here.
 */
class TimeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeUpdate ();

    /**
     * Copy constructor
     */
    inline  TimeUpdate (const TimeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TimeUpdate (uint8 Time_);

    /**
     * Destructor
     */
    inline virtual  ~TimeUpdate();

    /**
     * Assignment operator
     */
    inline TimeUpdate& operator = (const TimeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Time"

    static const int kTime = 0;

    /**
     * Clears the field "Time".
     *
     * The field will be set to its default value. The hasTime()
     * method will return false.
     */
    inline void clearTime();

    /**
     * Checks whether the field "Time" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTime()). Otherwise it will return false.
     */
    inline bool hasTime () const;

    /**
     * Returns the value of the member "Time".
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Time"
     */
    inline uint8 getTime () const;

    /**
     * Sets the value of the member "Time".
     *
     * If the meaning of "Time" isn't clear, then there should be a description here.
     *
     * @param Time The value which will be set
     */
    inline void setTime (uint8 Time_);

    static const TimeUpdate &getDefaultInstance();

private:

    inline void set_has_Time ();

    inline void clear_has_Time ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Time;

};

/**
 * If the meaning of "TimeRegister" isn't clear, then there should be a description here.
 */
class TimeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TimeRegister ();

    /**
     * Copy constructor
     */
    inline  TimeRegister (const TimeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TimeRegister();

    /**
     * Assignment operator
     */
    inline TimeRegister& operator = (const TimeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TimeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TimeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TimeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TimeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TimeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "SizeUpdate" isn't clear, then there should be a description here.
 */
class SizeUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SizeUpdate ();

    /**
     * Copy constructor
     */
    inline  SizeUpdate (const SizeUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SizeUpdate (uint64 Size_);

    /**
     * Destructor
     */
    inline virtual  ~SizeUpdate();

    /**
     * Assignment operator
     */
    inline SizeUpdate& operator = (const SizeUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SizeUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SizeUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SizeUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SizeUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Size"

    static const int kSize = 0;

    /**
     * Clears the field "Size".
     *
     * The field will be set to its default value. The hasSize()
     * method will return false.
     */
    inline void clearSize();

    /**
     * Checks whether the field "Size" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSize()). Otherwise it will return false.
     */
    inline bool hasSize () const;

    /**
     * Returns the value of the member "Size".
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Size"
     */
    inline uint64 getSize () const;

    /**
     * Sets the value of the member "Size".
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param Size The value which will be set
     */
    inline void setSize (uint64 Size_);

    static const SizeUpdate &getDefaultInstance();

private:

    inline void set_has_Size ();

    inline void clear_has_Size ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _Size;

};

/**
 * If the meaning of "SizeRegister" isn't clear, then there should be a description here.
 */
class SizeRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SizeRegister ();

    /**
     * Copy constructor
     */
    inline  SizeRegister (const SizeRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SizeRegister();

    /**
     * Assignment operator
     */
    inline SizeRegister& operator = (const SizeRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SizeRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SizeRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SizeRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SizeRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SizeRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TransferredUpdate" isn't clear, then there should be a description here.
 */
class TransferredUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferredUpdate ();

    /**
     * Copy constructor
     */
    inline  TransferredUpdate (const TransferredUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TransferredUpdate (uint64 Transferred_);

    /**
     * Destructor
     */
    inline virtual  ~TransferredUpdate();

    /**
     * Assignment operator
     */
    inline TransferredUpdate& operator = (const TransferredUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferredUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferredUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferredUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferredUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Transferred"

    static const int kTransferred = 0;

    /**
     * Clears the field "Transferred".
     *
     * The field will be set to its default value. The hasTransferred()
     * method will return false.
     */
    inline void clearTransferred();

    /**
     * Checks whether the field "Transferred" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTransferred()). Otherwise it will return false.
     */
    inline bool hasTransferred () const;

    /**
     * Returns the value of the member "Transferred".
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Transferred"
     */
    inline uint64 getTransferred () const;

    /**
     * Sets the value of the member "Transferred".
     *
     * If the meaning of "Transferred" isn't clear, then there should be a description here.
     *
     * @param Transferred The value which will be set
     */
    inline void setTransferred (uint64 Transferred_);

    static const TransferredUpdate &getDefaultInstance();

private:

    inline void set_has_Transferred ();

    inline void clear_has_Transferred ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint64 _Transferred;

};

/**
 * If the meaning of "TransferredRegister" isn't clear, then there should be a description here.
 */
class TransferredRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TransferredRegister ();

    /**
     * Copy constructor
     */
    inline  TransferredRegister (const TransferredRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TransferredRegister();

    /**
     * Assignment operator
     */
    inline TransferredRegister& operator = (const TransferredRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TransferredRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TransferredRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TransferredRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TransferredRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TransferredRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "FilenameUpdate" isn't clear, then there should be a description here.
 */
class FilenameUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FilenameUpdate ();

    /**
     * Copy constructor
     */
    inline  FilenameUpdate (const FilenameUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  FilenameUpdate (const ::std::string& Filename_);

    /**
     * Destructor
     */
    inline virtual  ~FilenameUpdate();

    /**
     * Assignment operator
     */
    inline FilenameUpdate& operator = (const FilenameUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FilenameUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FilenameUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FilenameUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FilenameUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Filename"

    static const int kFilename = 0;

    /**
     * Clears the field "Filename".
     *
     * The field will be set to its default value. The hasFilename()
     * method will return false.
     */
    inline void clearFilename();

    /**
     * Checks whether the field "Filename" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFilename()). Otherwise it will return false.
     */
    inline bool hasFilename () const;

    /**
     * Returns the value of the member "Filename".
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Filename"
     */
    inline const ::std::string& getFilename () const;

    /**
     * Retrieves the value of the field "Filename" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Filename".
     */
    inline ::std::string& getFilenameMutable ();

    /**
     * Sets the value of the member "Filename".
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const ::std::string& Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* Filename_);

    /**
     * Sets the value of the member "Filename".
     *
     * If the meaning of "Filename" isn't clear, then there should be a description here.
     *
     * @param Filename The value which will be set
     */
    inline void setFilename (const char* value, size_t size);

    static const FilenameUpdate &getDefaultInstance();

private:

    inline void set_has_Filename ();

    inline void clear_has_Filename ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Filename;

};

/**
 * If the meaning of "FilenameRegister" isn't clear, then there should be a description here.
 */
class FilenameRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FilenameRegister ();

    /**
     * Copy constructor
     */
    inline  FilenameRegister (const FilenameRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~FilenameRegister();

    /**
     * Assignment operator
     */
    inline FilenameRegister& operator = (const FilenameRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FilenameRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FilenameRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FilenameRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FilenameRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const FilenameRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  StatusUpdate::StatusUpdate ()  :
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusUpdate::StatusUpdate (const StatusUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Status ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusUpdate::StatusUpdate (const ::std::string& Status_)  :
    _Status (Status_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StatusUpdate::~StatusUpdate() {
}

inline StatusUpdate& StatusUpdate::operator = (const StatusUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool StatusUpdate::operator == (const StatusUpdate& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool StatusUpdate::operator != (const StatusUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusUpdate::operator < (const StatusUpdate& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StatusUpdate::clone() {
    return new StatusUpdate(*this);
}

inline bool StatusUpdate::operator > (const StatusUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusUpdate::clear() {
    clearStatus();
}

inline void StatusUpdate::clearStatus() {
    if (hasStatus()) {
         clear_has_Status();
        _Status.clear();
     }
}

inline bool StatusUpdate::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StatusUpdate::getStatus () const {
    return _Status;
}

inline ::std::string& StatusUpdate::getStatusMutable () {
    set_has_Status();
    return _Status;
}

inline void StatusUpdate::setStatus (const ::std::string& Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status = Status_;
}

inline void StatusUpdate::setStatus (const char* Status_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Status_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(Status_);
}

inline void StatusUpdate::setStatus (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Status();
    this->_Status.assign(value, size);
}

inline void StatusUpdate::set_has_Status () {
    _has_bits_[0] |= 1u << 0;
}

inline void StatusUpdate::clear_has_Status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StatusRegister::StatusRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StatusRegister::StatusRegister (const StatusRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StatusRegister::~StatusRegister() {
}

inline StatusRegister& StatusRegister::operator = (const StatusRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StatusRegister::operator == (const StatusRegister& ) const {
    return true;
}

inline bool StatusRegister::operator != (const StatusRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StatusRegister::operator < (const StatusRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StatusRegister::clone() {
    return new StatusRegister(*this);
}

inline bool StatusRegister::operator > (const StatusRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StatusRegister::clear() {
}

inline  SessionUpdate::SessionUpdate ()  :
    _Session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionUpdate::SessionUpdate (const SessionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionUpdate::SessionUpdate (const ::std::string& Session_)  :
    _Session (Session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionUpdate::~SessionUpdate() {
}

inline SessionUpdate& SessionUpdate::operator = (const SessionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool SessionUpdate::operator == (const SessionUpdate& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool SessionUpdate::operator != (const SessionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionUpdate::operator < (const SessionUpdate& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionUpdate::clone() {
    return new SessionUpdate(*this);
}

inline bool SessionUpdate::operator > (const SessionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionUpdate::clear() {
    clearSession();
}

inline void SessionUpdate::clearSession() {
    if (hasSession()) {
         clear_has_Session();
        _Session.clear();
     }
}

inline bool SessionUpdate::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionUpdate::getSession () const {
    return _Session;
}

inline ::std::string& SessionUpdate::getSessionMutable () {
    set_has_Session();
    return _Session;
}

inline void SessionUpdate::setSession (const ::std::string& Session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Session();
    this->_Session = Session_;
}

inline void SessionUpdate::setSession (const char* Session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Session();
    this->_Session.assign(Session_);
}

inline void SessionUpdate::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Session();
    this->_Session.assign(value, size);
}

inline void SessionUpdate::set_has_Session () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionUpdate::clear_has_Session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SessionRegister::SessionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionRegister::SessionRegister (const SessionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionRegister::~SessionRegister() {
}

inline SessionRegister& SessionRegister::operator = (const SessionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SessionRegister::operator == (const SessionRegister& ) const {
    return true;
}

inline bool SessionRegister::operator != (const SessionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionRegister::operator < (const SessionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SessionRegister::clone() {
    return new SessionRegister(*this);
}

inline bool SessionRegister::operator > (const SessionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionRegister::clear() {
}

inline  NameUpdate::NameUpdate ()  :
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameUpdate::NameUpdate (const NameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Name ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameUpdate::NameUpdate (const ::std::string& Name_)  :
    _Name (Name_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  NameUpdate::~NameUpdate() {
}

inline NameUpdate& NameUpdate::operator = (const NameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasName()) {
            setName(rhs.getName());
        } else {
            clearName();
        }
    }
    return *this;
}

inline bool NameUpdate::operator == (const NameUpdate& rhs) const {
    return (((!hasName() && !rhs.hasName()) || getName() == rhs.getName()));
}

inline bool NameUpdate::operator != (const NameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool NameUpdate::operator < (const NameUpdate& rhs) const {
    if (hasName() || rhs.hasName()) {
        if (getName() < rhs.getName()) return true;
        if (getName() > rhs.getName()) return false;
    }
    return false;
}

inline ::asf::core::Payload* NameUpdate::clone() {
    return new NameUpdate(*this);
}

inline bool NameUpdate::operator > (const NameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameUpdate::clear() {
    clearName();
}

inline void NameUpdate::clearName() {
    if (hasName()) {
         clear_has_Name();
        _Name.clear();
     }
}

inline bool NameUpdate::hasName () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& NameUpdate::getName () const {
    return _Name;
}

inline ::std::string& NameUpdate::getNameMutable () {
    set_has_Name();
    return _Name;
}

inline void NameUpdate::setName (const ::std::string& Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name = Name_;
}

inline void NameUpdate::setName (const char* Name_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Name_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(Name_);
}

inline void NameUpdate::setName (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Name();
    this->_Name.assign(value, size);
}

inline void NameUpdate::set_has_Name () {
    _has_bits_[0] |= 1u << 0;
}

inline void NameUpdate::clear_has_Name () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  NameRegister::NameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  NameRegister::NameRegister (const NameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  NameRegister::~NameRegister() {
}

inline NameRegister& NameRegister::operator = (const NameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool NameRegister::operator == (const NameRegister& ) const {
    return true;
}

inline bool NameRegister::operator != (const NameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool NameRegister::operator < (const NameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* NameRegister::clone() {
    return new NameRegister(*this);
}

inline bool NameRegister::operator > (const NameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void NameRegister::clear() {
}

inline  TypeUpdate::TypeUpdate ()  :
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeUpdate::TypeUpdate (const TypeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Type ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeUpdate::TypeUpdate (const ::std::string& Type_)  :
    _Type (Type_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TypeUpdate::~TypeUpdate() {
}

inline TypeUpdate& TypeUpdate::operator = (const TypeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasType()) {
            setType(rhs.getType());
        } else {
            clearType();
        }
    }
    return *this;
}

inline bool TypeUpdate::operator == (const TypeUpdate& rhs) const {
    return (((!hasType() && !rhs.hasType()) || getType() == rhs.getType()));
}

inline bool TypeUpdate::operator != (const TypeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeUpdate::operator < (const TypeUpdate& rhs) const {
    if (hasType() || rhs.hasType()) {
        if (getType() < rhs.getType()) return true;
        if (getType() > rhs.getType()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TypeUpdate::clone() {
    return new TypeUpdate(*this);
}

inline bool TypeUpdate::operator > (const TypeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeUpdate::clear() {
    clearType();
}

inline void TypeUpdate::clearType() {
    if (hasType()) {
         clear_has_Type();
        _Type.clear();
     }
}

inline bool TypeUpdate::hasType () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TypeUpdate::getType () const {
    return _Type;
}

inline ::std::string& TypeUpdate::getTypeMutable () {
    set_has_Type();
    return _Type;
}

inline void TypeUpdate::setType (const ::std::string& Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type = Type_;
}

inline void TypeUpdate::setType (const char* Type_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Type_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(Type_);
}

inline void TypeUpdate::setType (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Type();
    this->_Type.assign(value, size);
}

inline void TypeUpdate::set_has_Type () {
    _has_bits_[0] |= 1u << 0;
}

inline void TypeUpdate::clear_has_Type () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TypeRegister::TypeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TypeRegister::TypeRegister (const TypeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TypeRegister::~TypeRegister() {
}

inline TypeRegister& TypeRegister::operator = (const TypeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TypeRegister::operator == (const TypeRegister& ) const {
    return true;
}

inline bool TypeRegister::operator != (const TypeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TypeRegister::operator < (const TypeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TypeRegister::clone() {
    return new TypeRegister(*this);
}

inline bool TypeRegister::operator > (const TypeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TypeRegister::clear() {
}

inline  TimeUpdate::TimeUpdate ()  :
    _Time (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeUpdate::TimeUpdate (const TimeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Time (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeUpdate::TimeUpdate (uint8 Time_)  :
    _Time (Time_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TimeUpdate::~TimeUpdate() {
}

inline TimeUpdate& TimeUpdate::operator = (const TimeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTime()) {
            setTime(rhs.getTime());
        } else {
            clearTime();
        }
    }
    return *this;
}

inline bool TimeUpdate::operator == (const TimeUpdate& rhs) const {
    return (((!hasTime() && !rhs.hasTime()) || getTime() == rhs.getTime()));
}

inline bool TimeUpdate::operator != (const TimeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeUpdate::operator < (const TimeUpdate& rhs) const {
    if (hasTime() || rhs.hasTime()) {
        if (getTime() < rhs.getTime()) return true;
        if (getTime() > rhs.getTime()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TimeUpdate::clone() {
    return new TimeUpdate(*this);
}

inline bool TimeUpdate::operator > (const TimeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeUpdate::clear() {
    clearTime();
}

inline void TimeUpdate::clearTime() {
    if (hasTime()) {
         clear_has_Time();
        _Time = 0u;
     }
}

inline bool TimeUpdate::hasTime () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 TimeUpdate::getTime () const {
    return _Time;
}

inline void TimeUpdate::setTime (uint8 Time_) {
    set_has_Time();
    this->_Time = Time_;
}

inline void TimeUpdate::set_has_Time () {
    _has_bits_[0] |= 1u << 0;
}

inline void TimeUpdate::clear_has_Time () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TimeRegister::TimeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TimeRegister::TimeRegister (const TimeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TimeRegister::~TimeRegister() {
}

inline TimeRegister& TimeRegister::operator = (const TimeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TimeRegister::operator == (const TimeRegister& ) const {
    return true;
}

inline bool TimeRegister::operator != (const TimeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TimeRegister::operator < (const TimeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TimeRegister::clone() {
    return new TimeRegister(*this);
}

inline bool TimeRegister::operator > (const TimeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TimeRegister::clear() {
}

inline  SizeUpdate::SizeUpdate ()  :
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SizeUpdate::SizeUpdate (const SizeUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Size (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SizeUpdate::SizeUpdate (uint64 Size_)  :
    _Size (Size_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SizeUpdate::~SizeUpdate() {
}

inline SizeUpdate& SizeUpdate::operator = (const SizeUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSize()) {
            setSize(rhs.getSize());
        } else {
            clearSize();
        }
    }
    return *this;
}

inline bool SizeUpdate::operator == (const SizeUpdate& rhs) const {
    return (((!hasSize() && !rhs.hasSize()) || getSize() == rhs.getSize()));
}

inline bool SizeUpdate::operator != (const SizeUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SizeUpdate::operator < (const SizeUpdate& rhs) const {
    if (hasSize() || rhs.hasSize()) {
        if (getSize() < rhs.getSize()) return true;
        if (getSize() > rhs.getSize()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SizeUpdate::clone() {
    return new SizeUpdate(*this);
}

inline bool SizeUpdate::operator > (const SizeUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SizeUpdate::clear() {
    clearSize();
}

inline void SizeUpdate::clearSize() {
    if (hasSize()) {
         clear_has_Size();
        _Size = 0u;
     }
}

inline bool SizeUpdate::hasSize () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 SizeUpdate::getSize () const {
    return _Size;
}

inline void SizeUpdate::setSize (uint64 Size_) {
    set_has_Size();
    this->_Size = Size_;
}

inline void SizeUpdate::set_has_Size () {
    _has_bits_[0] |= 1u << 0;
}

inline void SizeUpdate::clear_has_Size () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SizeRegister::SizeRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SizeRegister::SizeRegister (const SizeRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SizeRegister::~SizeRegister() {
}

inline SizeRegister& SizeRegister::operator = (const SizeRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SizeRegister::operator == (const SizeRegister& ) const {
    return true;
}

inline bool SizeRegister::operator != (const SizeRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SizeRegister::operator < (const SizeRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SizeRegister::clone() {
    return new SizeRegister(*this);
}

inline bool SizeRegister::operator > (const SizeRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SizeRegister::clear() {
}

inline  TransferredUpdate::TransferredUpdate ()  :
    _Transferred (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TransferredUpdate::TransferredUpdate (const TransferredUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Transferred (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TransferredUpdate::TransferredUpdate (uint64 Transferred_)  :
    _Transferred (Transferred_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TransferredUpdate::~TransferredUpdate() {
}

inline TransferredUpdate& TransferredUpdate::operator = (const TransferredUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTransferred()) {
            setTransferred(rhs.getTransferred());
        } else {
            clearTransferred();
        }
    }
    return *this;
}

inline bool TransferredUpdate::operator == (const TransferredUpdate& rhs) const {
    return (((!hasTransferred() && !rhs.hasTransferred()) || getTransferred() == rhs.getTransferred()));
}

inline bool TransferredUpdate::operator != (const TransferredUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TransferredUpdate::operator < (const TransferredUpdate& rhs) const {
    if (hasTransferred() || rhs.hasTransferred()) {
        if (getTransferred() < rhs.getTransferred()) return true;
        if (getTransferred() > rhs.getTransferred()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TransferredUpdate::clone() {
    return new TransferredUpdate(*this);
}

inline bool TransferredUpdate::operator > (const TransferredUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TransferredUpdate::clear() {
    clearTransferred();
}

inline void TransferredUpdate::clearTransferred() {
    if (hasTransferred()) {
         clear_has_Transferred();
        _Transferred = 0u;
     }
}

inline bool TransferredUpdate::hasTransferred () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint64 TransferredUpdate::getTransferred () const {
    return _Transferred;
}

inline void TransferredUpdate::setTransferred (uint64 Transferred_) {
    set_has_Transferred();
    this->_Transferred = Transferred_;
}

inline void TransferredUpdate::set_has_Transferred () {
    _has_bits_[0] |= 1u << 0;
}

inline void TransferredUpdate::clear_has_Transferred () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TransferredRegister::TransferredRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TransferredRegister::TransferredRegister (const TransferredRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TransferredRegister::~TransferredRegister() {
}

inline TransferredRegister& TransferredRegister::operator = (const TransferredRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TransferredRegister::operator == (const TransferredRegister& ) const {
    return true;
}

inline bool TransferredRegister::operator != (const TransferredRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TransferredRegister::operator < (const TransferredRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TransferredRegister::clone() {
    return new TransferredRegister(*this);
}

inline bool TransferredRegister::operator > (const TransferredRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TransferredRegister::clear() {
}

inline  FilenameUpdate::FilenameUpdate ()  :
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FilenameUpdate::FilenameUpdate (const FilenameUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Filename ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FilenameUpdate::FilenameUpdate (const ::std::string& Filename_)  :
    _Filename (Filename_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FilenameUpdate::~FilenameUpdate() {
}

inline FilenameUpdate& FilenameUpdate::operator = (const FilenameUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasFilename()) {
            setFilename(rhs.getFilename());
        } else {
            clearFilename();
        }
    }
    return *this;
}

inline bool FilenameUpdate::operator == (const FilenameUpdate& rhs) const {
    return (((!hasFilename() && !rhs.hasFilename()) || getFilename() == rhs.getFilename()));
}

inline bool FilenameUpdate::operator != (const FilenameUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool FilenameUpdate::operator < (const FilenameUpdate& rhs) const {
    if (hasFilename() || rhs.hasFilename()) {
        if (getFilename() < rhs.getFilename()) return true;
        if (getFilename() > rhs.getFilename()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FilenameUpdate::clone() {
    return new FilenameUpdate(*this);
}

inline bool FilenameUpdate::operator > (const FilenameUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FilenameUpdate::clear() {
    clearFilename();
}

inline void FilenameUpdate::clearFilename() {
    if (hasFilename()) {
         clear_has_Filename();
        _Filename.clear();
     }
}

inline bool FilenameUpdate::hasFilename () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& FilenameUpdate::getFilename () const {
    return _Filename;
}

inline ::std::string& FilenameUpdate::getFilenameMutable () {
    set_has_Filename();
    return _Filename;
}

inline void FilenameUpdate::setFilename (const ::std::string& Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename = Filename_;
}

inline void FilenameUpdate::setFilename (const char* Filename_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Filename_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(Filename_);
}

inline void FilenameUpdate::setFilename (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Filename();
    this->_Filename.assign(value, size);
}

inline void FilenameUpdate::set_has_Filename () {
    _has_bits_[0] |= 1u << 0;
}

inline void FilenameUpdate::clear_has_Filename () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  FilenameRegister::FilenameRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FilenameRegister::FilenameRegister (const FilenameRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FilenameRegister::~FilenameRegister() {
}

inline FilenameRegister& FilenameRegister::operator = (const FilenameRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool FilenameRegister::operator == (const FilenameRegister& ) const {
    return true;
}

inline bool FilenameRegister::operator != (const FilenameRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool FilenameRegister::operator < (const FilenameRegister& ) const {
    return false;
}

inline ::asf::core::Payload* FilenameRegister::clone() {
    return new FilenameRegister(*this);
}

inline bool FilenameRegister::operator > (const FilenameRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FilenameRegister::clear() {
}

} // namespace Transfer
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_TRANSFER_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
