/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_SESSIONPROXY_H
#define ORG_BLUEZ_OBEX_SESSIONPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/Session.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Session {

class SessionProxy;

class ChannelCallbackIF {
public:
    virtual ~ChannelCallbackIF() {}

    virtual void onChannelError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelError >& error) = 0;

    virtual void onChannelUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< ChannelUpdate >& update) = 0;
};

class DestinationCallbackIF {
public:
    virtual ~DestinationCallbackIF() {}

    virtual void onDestinationError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationError >& error) = 0;

    virtual void onDestinationUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< DestinationUpdate >& update) = 0;
};

class InstanceIDCallbackIF {
public:
    virtual ~InstanceIDCallbackIF() {}

    virtual void onInstanceIDError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< InstanceIDError >& error) = 0;

    virtual void onInstanceIDUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< InstanceIDUpdate >& update) = 0;
};

class SourceCallbackIF {
public:
    virtual ~SourceCallbackIF() {}

    virtual void onSourceError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceError >& error) = 0;

    virtual void onSourceUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< SourceUpdate >& update) = 0;
};

class TargetCallbackIF {
public:
    virtual ~TargetCallbackIF() {}

    virtual void onTargetError(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetError >& error) = 0;

    virtual void onTargetUpdate(const ::boost::shared_ptr< SessionProxy >& proxy, const ::boost::shared_ptr< TargetUpdate >& update) = 0;
};


/**
 * SessionProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.obex.Session' (specified in file
 * obex_session.xml).
 *
 * If the meaning of "org.bluez.obex.Session" isn't clear, then there should be a description here.
 */
class SessionProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of SessionProxy.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of SessionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of SessionProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< SessionProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< SessionProxy > proxyNew(new SessionProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~SessionProxy ();



    // Property 'Source'

    /**
     * Notify on the property 'Source'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceRegister(SourceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Source'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendSourceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendSourceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Source'.
     */
    void sendSourceDeregisterAll() const;

    /**
     * Request the value of the property 'Source' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Source'</b>:
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSourceGet(SourceCallbackIF& cb);


    /**
     * Returns the current value of the property 'Source' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasSource()
     * returns true.
     *
     * @return the previously received value of the property 'Source'.
     */
    const ::std::string& getSource() const;

    /**
     * Determines whether a status message for the property 'Source' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasSource() const;

    // Property 'Destination'

    /**
     * Notify on the property 'Destination'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDestinationRegister(DestinationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Destination'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDestinationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDestinationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Destination'.
     */
    void sendDestinationDeregisterAll() const;

    /**
     * Request the value of the property 'Destination' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Destination'</b>:
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDestinationGet(DestinationCallbackIF& cb);


    /**
     * Returns the current value of the property 'Destination' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasDestination() returns true.
     *
     * @return the previously received value of the property 'Destination'.
     */
    const ::std::string& getDestination() const;

    /**
     * Determines whether a status message for the property 'Destination' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDestination() const;

    // Property 'Channel'

    /**
     * Notify on the property 'Channel'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChannelRegister(ChannelCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Channel'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendChannelRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendChannelDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Channel'.
     */
    void sendChannelDeregisterAll() const;

    /**
     * Request the value of the property 'Channel' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Channel'</b>:
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendChannelGet(ChannelCallbackIF& cb);


    /**
     * Returns the current value of the property 'Channel' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasChannel()
     * returns true.
     *
     * @return the previously received value of the property 'Channel'.
     */
    uint8 getChannel() const;

    /**
     * Determines whether a status message for the property 'Channel' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasChannel() const;

    // Property 'Target'

    /**
     * Notify on the property 'Target'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTargetRegister(TargetCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Target'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTargetRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTargetDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Target'.
     */
    void sendTargetDeregisterAll() const;

    /**
     * Request the value of the property 'Target' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Target'</b>:
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTargetGet(TargetCallbackIF& cb);


    /**
     * Returns the current value of the property 'Target' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasTarget()
     * returns true.
     *
     * @return the previously received value of the property 'Target'.
     */
    const ::std::string& getTarget() const;

    /**
     * Determines whether a status message for the property 'Target' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasTarget() const;

    // Property 'InstanceID'

    /**
     * Notify on the property 'InstanceID'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstanceIDRegister(InstanceIDCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'InstanceID'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendInstanceIDRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendInstanceIDDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'InstanceID'.
     */
    void sendInstanceIDDeregisterAll() const;

    /**
     * Request the value of the property 'InstanceID' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'InstanceID'</b>:
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendInstanceIDGet(InstanceIDCallbackIF& cb);


    /**
     * Returns the current value of the property 'InstanceID' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasInstanceID() returns true.
     *
     * @return the previously received value of the property 'InstanceID'.
     */
    int32 getInstanceID() const;

    /**
     * Determines whether a status message for the property 'InstanceID' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasInstanceID() const;


    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    SessionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Source'

    ::asf::core::nullable< SourceUpdate > _source;

    // Property 'Destination'

    ::asf::core::nullable< DestinationUpdate > _destination;

    // Property 'Channel'

    ::asf::core::nullable< ChannelUpdate > _channel;

    // Property 'Target'

    ::asf::core::nullable< TargetUpdate > _target;

    // Property 'InstanceID'

    ::asf::core::nullable< InstanceIDUpdate > _instanceID;

    DECLARE_CLASS_LOGGER();

    friend class SessionProxyCallback;
};

} // namespace Session
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_SESSIONPROXY_H
