#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_SESSION_H
#define ORG_BLUEZ_OBEX_SESSION_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Session" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace Session {

// method IDs

// signal IDs

// property IDs
static const uint16 ID_Source = 0;
static const uint16 ID_Destination = 1;
static const uint16 ID_Channel = 2;
static const uint16 ID_Target = 3;
static const uint16 ID_InstanceID = 4;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class SourceUpdate;

class SourceRegister;

class DestinationUpdate;

class DestinationRegister;

class ChannelUpdate;

class ChannelRegister;

class TargetUpdate;

class TargetRegister;

class InstanceIDUpdate;

class InstanceIDRegister;

// type definitions
/**
 * If the meaning of "SourceSet" isn't clear, then there should be a description here.
 */
typedef SourceUpdate SourceSet;

/**
 * If the meaning of "SourceGet" isn't clear, then there should be a description here.
 */
typedef SourceUpdate SourceGet;

/**
 * If the meaning of "SourceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SourceError;

/**
 * If the meaning of "DestinationSet" isn't clear, then there should be a description here.
 */
typedef DestinationUpdate DestinationSet;

/**
 * If the meaning of "DestinationGet" isn't clear, then there should be a description here.
 */
typedef DestinationUpdate DestinationGet;

/**
 * If the meaning of "DestinationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DestinationError;

/**
 * If the meaning of "ChannelSet" isn't clear, then there should be a description here.
 */
typedef ChannelUpdate ChannelSet;

/**
 * If the meaning of "ChannelGet" isn't clear, then there should be a description here.
 */
typedef ChannelUpdate ChannelGet;

/**
 * If the meaning of "ChannelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ChannelError;

/**
 * If the meaning of "TargetSet" isn't clear, then there should be a description here.
 */
typedef TargetUpdate TargetSet;

/**
 * If the meaning of "TargetGet" isn't clear, then there should be a description here.
 */
typedef TargetUpdate TargetGet;

/**
 * If the meaning of "TargetError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError TargetError;

/**
 * If the meaning of "InstanceIDSet" isn't clear, then there should be a description here.
 */
typedef InstanceIDUpdate InstanceIDSet;

/**
 * If the meaning of "InstanceIDGet" isn't clear, then there should be a description here.
 */
typedef InstanceIDUpdate InstanceIDGet;

/**
 * If the meaning of "InstanceIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError InstanceIDError;


/**
 * If the meaning of "SourceUpdate" isn't clear, then there should be a description here.
 */
class SourceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceUpdate ();

    /**
     * Copy constructor
     */
    inline  SourceUpdate (const SourceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  SourceUpdate (const ::std::string& Source_);

    /**
     * Destructor
     */
    inline virtual  ~SourceUpdate();

    /**
     * Assignment operator
     */
    inline SourceUpdate& operator = (const SourceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Source"

    static const int kSource = 0;

    /**
     * Clears the field "Source".
     *
     * The field will be set to its default value. The hasSource()
     * method will return false.
     */
    inline void clearSource();

    /**
     * Checks whether the field "Source" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSource()). Otherwise it will return false.
     */
    inline bool hasSource () const;

    /**
     * Returns the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Source"
     */
    inline const ::std::string& getSource () const;

    /**
     * Retrieves the value of the field "Source" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Source".
     */
    inline ::std::string& getSourceMutable ();

    /**
     * Sets the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param Source The value which will be set
     */
    inline void setSource (const ::std::string& Source_);

    /**
     * Sets the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param Source The value which will be set
     */
    inline void setSource (const char* Source_);

    /**
     * Sets the value of the member "Source".
     *
     * If the meaning of "Source" isn't clear, then there should be a description here.
     *
     * @param Source The value which will be set
     */
    inline void setSource (const char* value, size_t size);

    static const SourceUpdate &getDefaultInstance();

private:

    inline void set_has_Source ();

    inline void clear_has_Source ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Source;

};

/**
 * If the meaning of "SourceRegister" isn't clear, then there should be a description here.
 */
class SourceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SourceRegister ();

    /**
     * Copy constructor
     */
    inline  SourceRegister (const SourceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~SourceRegister();

    /**
     * Assignment operator
     */
    inline SourceRegister& operator = (const SourceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SourceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SourceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SourceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SourceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const SourceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DestinationUpdate" isn't clear, then there should be a description here.
 */
class DestinationUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestinationUpdate ();

    /**
     * Copy constructor
     */
    inline  DestinationUpdate (const DestinationUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DestinationUpdate (const ::std::string& Destination_);

    /**
     * Destructor
     */
    inline virtual  ~DestinationUpdate();

    /**
     * Assignment operator
     */
    inline DestinationUpdate& operator = (const DestinationUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Destination"

    static const int kDestination = 0;

    /**
     * Clears the field "Destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "Destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "Destination".
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "Destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "Destination".
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const ::std::string& Destination_);

    /**
     * Sets the value of the member "Destination".
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const char* Destination_);

    /**
     * Sets the value of the member "Destination".
     *
     * If the meaning of "Destination" isn't clear, then there should be a description here.
     *
     * @param Destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    static const DestinationUpdate &getDefaultInstance();

private:

    inline void set_has_Destination ();

    inline void clear_has_Destination ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Destination;

};

/**
 * If the meaning of "DestinationRegister" isn't clear, then there should be a description here.
 */
class DestinationRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DestinationRegister ();

    /**
     * Copy constructor
     */
    inline  DestinationRegister (const DestinationRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DestinationRegister();

    /**
     * Assignment operator
     */
    inline DestinationRegister& operator = (const DestinationRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DestinationRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DestinationRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DestinationRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DestinationRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DestinationRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "ChannelUpdate" isn't clear, then there should be a description here.
 */
class ChannelUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChannelUpdate ();

    /**
     * Copy constructor
     */
    inline  ChannelUpdate (const ChannelUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  ChannelUpdate (uint8 Channel_);

    /**
     * Destructor
     */
    inline virtual  ~ChannelUpdate();

    /**
     * Assignment operator
     */
    inline ChannelUpdate& operator = (const ChannelUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Channel"

    static const int kChannel = 0;

    /**
     * Clears the field "Channel".
     *
     * The field will be set to its default value. The hasChannel()
     * method will return false.
     */
    inline void clearChannel();

    /**
     * Checks whether the field "Channel" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setChannel()). Otherwise it will return false.
     */
    inline bool hasChannel () const;

    /**
     * Returns the value of the member "Channel".
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Channel"
     */
    inline uint8 getChannel () const;

    /**
     * Sets the value of the member "Channel".
     *
     * If the meaning of "Channel" isn't clear, then there should be a description here.
     *
     * @param Channel The value which will be set
     */
    inline void setChannel (uint8 Channel_);

    static const ChannelUpdate &getDefaultInstance();

private:

    inline void set_has_Channel ();

    inline void clear_has_Channel ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _Channel;

};

/**
 * If the meaning of "ChannelRegister" isn't clear, then there should be a description here.
 */
class ChannelRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ChannelRegister ();

    /**
     * Copy constructor
     */
    inline  ChannelRegister (const ChannelRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~ChannelRegister();

    /**
     * Assignment operator
     */
    inline ChannelRegister& operator = (const ChannelRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ChannelRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ChannelRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ChannelRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ChannelRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const ChannelRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "TargetUpdate" isn't clear, then there should be a description here.
 */
class TargetUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TargetUpdate ();

    /**
     * Copy constructor
     */
    inline  TargetUpdate (const TargetUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  TargetUpdate (const ::std::string& Target_);

    /**
     * Destructor
     */
    inline virtual  ~TargetUpdate();

    /**
     * Assignment operator
     */
    inline TargetUpdate& operator = (const TargetUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TargetUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TargetUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TargetUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TargetUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Target"

    static const int kTarget = 0;

    /**
     * Clears the field "Target".
     *
     * The field will be set to its default value. The hasTarget()
     * method will return false.
     */
    inline void clearTarget();

    /**
     * Checks whether the field "Target" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setTarget()). Otherwise it will return false.
     */
    inline bool hasTarget () const;

    /**
     * Returns the value of the member "Target".
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Target"
     */
    inline const ::std::string& getTarget () const;

    /**
     * Retrieves the value of the field "Target" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Target".
     */
    inline ::std::string& getTargetMutable ();

    /**
     * Sets the value of the member "Target".
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param Target The value which will be set
     */
    inline void setTarget (const ::std::string& Target_);

    /**
     * Sets the value of the member "Target".
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param Target The value which will be set
     */
    inline void setTarget (const char* Target_);

    /**
     * Sets the value of the member "Target".
     *
     * If the meaning of "Target" isn't clear, then there should be a description here.
     *
     * @param Target The value which will be set
     */
    inline void setTarget (const char* value, size_t size);

    static const TargetUpdate &getDefaultInstance();

private:

    inline void set_has_Target ();

    inline void clear_has_Target ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Target;

};

/**
 * If the meaning of "TargetRegister" isn't clear, then there should be a description here.
 */
class TargetRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  TargetRegister ();

    /**
     * Copy constructor
     */
    inline  TargetRegister (const TargetRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~TargetRegister();

    /**
     * Assignment operator
     */
    inline TargetRegister& operator = (const TargetRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const TargetRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const TargetRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const TargetRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const TargetRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const TargetRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "InstanceIDUpdate" isn't clear, then there should be a description here.
 */
class InstanceIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstanceIDUpdate ();

    /**
     * Copy constructor
     */
    inline  InstanceIDUpdate (const InstanceIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  InstanceIDUpdate (int32 InstanceID_);

    /**
     * Destructor
     */
    inline virtual  ~InstanceIDUpdate();

    /**
     * Assignment operator
     */
    inline InstanceIDUpdate& operator = (const InstanceIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstanceIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstanceIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstanceIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstanceIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "InstanceID"

    static const int kInstanceID = 0;

    /**
     * Clears the field "InstanceID".
     *
     * The field will be set to its default value. The hasInstanceID()
     * method will return false.
     */
    inline void clearInstanceID();

    /**
     * Checks whether the field "InstanceID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setInstanceID()). Otherwise it will return false.
     */
    inline bool hasInstanceID () const;

    /**
     * Returns the value of the member "InstanceID".
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "InstanceID"
     */
    inline int32 getInstanceID () const;

    /**
     * Sets the value of the member "InstanceID".
     *
     * If the meaning of "InstanceID" isn't clear, then there should be a description here.
     *
     * @param InstanceID The value which will be set
     */
    inline void setInstanceID (int32 InstanceID_);

    static const InstanceIDUpdate &getDefaultInstance();

private:

    inline void set_has_InstanceID ();

    inline void clear_has_InstanceID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    int32 _InstanceID;

};

/**
 * If the meaning of "InstanceIDRegister" isn't clear, then there should be a description here.
 */
class InstanceIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  InstanceIDRegister ();

    /**
     * Copy constructor
     */
    inline  InstanceIDRegister (const InstanceIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~InstanceIDRegister();

    /**
     * Assignment operator
     */
    inline InstanceIDRegister& operator = (const InstanceIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const InstanceIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const InstanceIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const InstanceIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const InstanceIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const InstanceIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  SourceUpdate::SourceUpdate ()  :
    _Source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceUpdate::SourceUpdate (const SourceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Source ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceUpdate::SourceUpdate (const ::std::string& Source_)  :
    _Source (Source_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Source_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SourceUpdate::~SourceUpdate() {
}

inline SourceUpdate& SourceUpdate::operator = (const SourceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSource()) {
            setSource(rhs.getSource());
        } else {
            clearSource();
        }
    }
    return *this;
}

inline bool SourceUpdate::operator == (const SourceUpdate& rhs) const {
    return (((!hasSource() && !rhs.hasSource()) || getSource() == rhs.getSource()));
}

inline bool SourceUpdate::operator != (const SourceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceUpdate::operator < (const SourceUpdate& rhs) const {
    if (hasSource() || rhs.hasSource()) {
        if (getSource() < rhs.getSource()) return true;
        if (getSource() > rhs.getSource()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SourceUpdate::clone() {
    return new SourceUpdate(*this);
}

inline bool SourceUpdate::operator > (const SourceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceUpdate::clear() {
    clearSource();
}

inline void SourceUpdate::clearSource() {
    if (hasSource()) {
         clear_has_Source();
        _Source.clear();
     }
}

inline bool SourceUpdate::hasSource () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SourceUpdate::getSource () const {
    return _Source;
}

inline ::std::string& SourceUpdate::getSourceMutable () {
    set_has_Source();
    return _Source;
}

inline void SourceUpdate::setSource (const ::std::string& Source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Source();
    this->_Source = Source_;
}

inline void SourceUpdate::setSource (const char* Source_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Source_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Source();
    this->_Source.assign(Source_);
}

inline void SourceUpdate::setSource (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Source();
    this->_Source.assign(value, size);
}

inline void SourceUpdate::set_has_Source () {
    _has_bits_[0] |= 1u << 0;
}

inline void SourceUpdate::clear_has_Source () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  SourceRegister::SourceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SourceRegister::SourceRegister (const SourceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SourceRegister::~SourceRegister() {
}

inline SourceRegister& SourceRegister::operator = (const SourceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool SourceRegister::operator == (const SourceRegister& ) const {
    return true;
}

inline bool SourceRegister::operator != (const SourceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool SourceRegister::operator < (const SourceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* SourceRegister::clone() {
    return new SourceRegister(*this);
}

inline bool SourceRegister::operator > (const SourceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SourceRegister::clear() {
}

inline  DestinationUpdate::DestinationUpdate ()  :
    _Destination ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DestinationUpdate::DestinationUpdate (const DestinationUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Destination ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DestinationUpdate::DestinationUpdate (const ::std::string& Destination_)  :
    _Destination (Destination_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Destination_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DestinationUpdate::~DestinationUpdate() {
}

inline DestinationUpdate& DestinationUpdate::operator = (const DestinationUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
    }
    return *this;
}

inline bool DestinationUpdate::operator == (const DestinationUpdate& rhs) const {
    return (((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()));
}

inline bool DestinationUpdate::operator != (const DestinationUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DestinationUpdate::operator < (const DestinationUpdate& rhs) const {
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DestinationUpdate::clone() {
    return new DestinationUpdate(*this);
}

inline bool DestinationUpdate::operator > (const DestinationUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DestinationUpdate::clear() {
    clearDestination();
}

inline void DestinationUpdate::clearDestination() {
    if (hasDestination()) {
         clear_has_Destination();
        _Destination.clear();
     }
}

inline bool DestinationUpdate::hasDestination () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DestinationUpdate::getDestination () const {
    return _Destination;
}

inline ::std::string& DestinationUpdate::getDestinationMutable () {
    set_has_Destination();
    return _Destination;
}

inline void DestinationUpdate::setDestination (const ::std::string& Destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Destination();
    this->_Destination = Destination_;
}

inline void DestinationUpdate::setDestination (const char* Destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Destination();
    this->_Destination.assign(Destination_);
}

inline void DestinationUpdate::setDestination (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Destination();
    this->_Destination.assign(value, size);
}

inline void DestinationUpdate::set_has_Destination () {
    _has_bits_[0] |= 1u << 0;
}

inline void DestinationUpdate::clear_has_Destination () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DestinationRegister::DestinationRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DestinationRegister::DestinationRegister (const DestinationRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DestinationRegister::~DestinationRegister() {
}

inline DestinationRegister& DestinationRegister::operator = (const DestinationRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DestinationRegister::operator == (const DestinationRegister& ) const {
    return true;
}

inline bool DestinationRegister::operator != (const DestinationRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DestinationRegister::operator < (const DestinationRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DestinationRegister::clone() {
    return new DestinationRegister(*this);
}

inline bool DestinationRegister::operator > (const DestinationRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DestinationRegister::clear() {
}

inline  ChannelUpdate::ChannelUpdate ()  :
    _Channel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ChannelUpdate::ChannelUpdate (const ChannelUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Channel (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ChannelUpdate::ChannelUpdate (uint8 Channel_)  :
    _Channel (Channel_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ChannelUpdate::~ChannelUpdate() {
}

inline ChannelUpdate& ChannelUpdate::operator = (const ChannelUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasChannel()) {
            setChannel(rhs.getChannel());
        } else {
            clearChannel();
        }
    }
    return *this;
}

inline bool ChannelUpdate::operator == (const ChannelUpdate& rhs) const {
    return (((!hasChannel() && !rhs.hasChannel()) || getChannel() == rhs.getChannel()));
}

inline bool ChannelUpdate::operator != (const ChannelUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool ChannelUpdate::operator < (const ChannelUpdate& rhs) const {
    if (hasChannel() || rhs.hasChannel()) {
        if (getChannel() < rhs.getChannel()) return true;
        if (getChannel() > rhs.getChannel()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ChannelUpdate::clone() {
    return new ChannelUpdate(*this);
}

inline bool ChannelUpdate::operator > (const ChannelUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ChannelUpdate::clear() {
    clearChannel();
}

inline void ChannelUpdate::clearChannel() {
    if (hasChannel()) {
         clear_has_Channel();
        _Channel = 0u;
     }
}

inline bool ChannelUpdate::hasChannel () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 ChannelUpdate::getChannel () const {
    return _Channel;
}

inline void ChannelUpdate::setChannel (uint8 Channel_) {
    set_has_Channel();
    this->_Channel = Channel_;
}

inline void ChannelUpdate::set_has_Channel () {
    _has_bits_[0] |= 1u << 0;
}

inline void ChannelUpdate::clear_has_Channel () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  ChannelRegister::ChannelRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ChannelRegister::ChannelRegister (const ChannelRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ChannelRegister::~ChannelRegister() {
}

inline ChannelRegister& ChannelRegister::operator = (const ChannelRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool ChannelRegister::operator == (const ChannelRegister& ) const {
    return true;
}

inline bool ChannelRegister::operator != (const ChannelRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool ChannelRegister::operator < (const ChannelRegister& ) const {
    return false;
}

inline ::asf::core::Payload* ChannelRegister::clone() {
    return new ChannelRegister(*this);
}

inline bool ChannelRegister::operator > (const ChannelRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ChannelRegister::clear() {
}

inline  TargetUpdate::TargetUpdate ()  :
    _Target ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TargetUpdate::TargetUpdate (const TargetUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Target ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TargetUpdate::TargetUpdate (const ::std::string& Target_)  :
    _Target (Target_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Target_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  TargetUpdate::~TargetUpdate() {
}

inline TargetUpdate& TargetUpdate::operator = (const TargetUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasTarget()) {
            setTarget(rhs.getTarget());
        } else {
            clearTarget();
        }
    }
    return *this;
}

inline bool TargetUpdate::operator == (const TargetUpdate& rhs) const {
    return (((!hasTarget() && !rhs.hasTarget()) || getTarget() == rhs.getTarget()));
}

inline bool TargetUpdate::operator != (const TargetUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool TargetUpdate::operator < (const TargetUpdate& rhs) const {
    if (hasTarget() || rhs.hasTarget()) {
        if (getTarget() < rhs.getTarget()) return true;
        if (getTarget() > rhs.getTarget()) return false;
    }
    return false;
}

inline ::asf::core::Payload* TargetUpdate::clone() {
    return new TargetUpdate(*this);
}

inline bool TargetUpdate::operator > (const TargetUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TargetUpdate::clear() {
    clearTarget();
}

inline void TargetUpdate::clearTarget() {
    if (hasTarget()) {
         clear_has_Target();
        _Target.clear();
     }
}

inline bool TargetUpdate::hasTarget () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& TargetUpdate::getTarget () const {
    return _Target;
}

inline ::std::string& TargetUpdate::getTargetMutable () {
    set_has_Target();
    return _Target;
}

inline void TargetUpdate::setTarget (const ::std::string& Target_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Target_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Target();
    this->_Target = Target_;
}

inline void TargetUpdate::setTarget (const char* Target_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Target_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Target();
    this->_Target.assign(Target_);
}

inline void TargetUpdate::setTarget (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Target();
    this->_Target.assign(value, size);
}

inline void TargetUpdate::set_has_Target () {
    _has_bits_[0] |= 1u << 0;
}

inline void TargetUpdate::clear_has_Target () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  TargetRegister::TargetRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  TargetRegister::TargetRegister (const TargetRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  TargetRegister::~TargetRegister() {
}

inline TargetRegister& TargetRegister::operator = (const TargetRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool TargetRegister::operator == (const TargetRegister& ) const {
    return true;
}

inline bool TargetRegister::operator != (const TargetRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool TargetRegister::operator < (const TargetRegister& ) const {
    return false;
}

inline ::asf::core::Payload* TargetRegister::clone() {
    return new TargetRegister(*this);
}

inline bool TargetRegister::operator > (const TargetRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void TargetRegister::clear() {
}

inline  InstanceIDUpdate::InstanceIDUpdate ()  :
    _InstanceID (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstanceIDUpdate::InstanceIDUpdate (const InstanceIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _InstanceID (0)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstanceIDUpdate::InstanceIDUpdate (int32 InstanceID_)  :
    _InstanceID (InstanceID_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  InstanceIDUpdate::~InstanceIDUpdate() {
}

inline InstanceIDUpdate& InstanceIDUpdate::operator = (const InstanceIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasInstanceID()) {
            setInstanceID(rhs.getInstanceID());
        } else {
            clearInstanceID();
        }
    }
    return *this;
}

inline bool InstanceIDUpdate::operator == (const InstanceIDUpdate& rhs) const {
    return (((!hasInstanceID() && !rhs.hasInstanceID()) || getInstanceID() == rhs.getInstanceID()));
}

inline bool InstanceIDUpdate::operator != (const InstanceIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool InstanceIDUpdate::operator < (const InstanceIDUpdate& rhs) const {
    if (hasInstanceID() || rhs.hasInstanceID()) {
        if (getInstanceID() < rhs.getInstanceID()) return true;
        if (getInstanceID() > rhs.getInstanceID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* InstanceIDUpdate::clone() {
    return new InstanceIDUpdate(*this);
}

inline bool InstanceIDUpdate::operator > (const InstanceIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstanceIDUpdate::clear() {
    clearInstanceID();
}

inline void InstanceIDUpdate::clearInstanceID() {
    if (hasInstanceID()) {
         clear_has_InstanceID();
        _InstanceID = 0;
     }
}

inline bool InstanceIDUpdate::hasInstanceID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline int32 InstanceIDUpdate::getInstanceID () const {
    return _InstanceID;
}

inline void InstanceIDUpdate::setInstanceID (int32 InstanceID_) {
    set_has_InstanceID();
    this->_InstanceID = InstanceID_;
}

inline void InstanceIDUpdate::set_has_InstanceID () {
    _has_bits_[0] |= 1u << 0;
}

inline void InstanceIDUpdate::clear_has_InstanceID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  InstanceIDRegister::InstanceIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  InstanceIDRegister::InstanceIDRegister (const InstanceIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  InstanceIDRegister::~InstanceIDRegister() {
}

inline InstanceIDRegister& InstanceIDRegister::operator = (const InstanceIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool InstanceIDRegister::operator == (const InstanceIDRegister& ) const {
    return true;
}

inline bool InstanceIDRegister::operator != (const InstanceIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool InstanceIDRegister::operator < (const InstanceIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* InstanceIDRegister::clone() {
    return new InstanceIDRegister(*this);
}

inline bool InstanceIDRegister::operator > (const InstanceIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void InstanceIDRegister::clear() {
}

} // namespace Session
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_SESSION_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
