/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/PhonebookAccess.h"
#include "org/bluez/obex/PhonebookAccessDBus.h"
#include "org/bluez/obex/PhonebookAccessJson.h"
#include "org/bluez/obex/PhonebookAccessStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace PhonebookAccess {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/PhonebookAccess", PhonebookAccessStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "List", 3 },
    { 4, "Pull", 2 },
    { 6, "Select", 0 },
    { 7, "GetSize", 4 },
    { 7, "PullAll", 1 },
    { 16, "ListFilterFields", 5 },
};


class PhonebookAccessStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    PhonebookAccessStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    PhonebookAccessStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    PhonebookAccessStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.PhonebookAccess"),
          _logger(logger) {}

    virtual ~PhonebookAccessStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void PhonebookAccessStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Select'

            LOG_DEBUG_STUB("process method '%s'", "Select");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SelectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Select", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SelectRequest > payload = ::boost::static_pointer_cast<SelectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onSelectRequest(payload);
            return;
        }
        case 1: {

            // method 'PullAll'

            LOG_DEBUG_STUB("process method '%s'", "PullAll");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PullAllRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PullAll", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PullAllRequest > payload = ::boost::static_pointer_cast<PullAllRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onPullAllRequest(payload);
            return;
        }
        case 2: {

            // method 'Pull'

            LOG_DEBUG_STUB("process method '%s'", "Pull");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PullRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Pull", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PullRequest > payload = ::boost::static_pointer_cast<PullRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onPullRequest(payload);
            return;
        }
        case 3: {

            // method 'List'

            LOG_DEBUG_STUB("process method '%s'", "List");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "List", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListRequest > payload = ::boost::static_pointer_cast<ListRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onListRequest(payload);
            return;
        }
        case 4: {

            // method 'GetSize'

            LOG_DEBUG_STUB("process method '%s'", "GetSize");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetSizeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetSize", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetSizeRequest > payload = ::boost::static_pointer_cast<GetSizeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onGetSizeRequest(payload);
            return;
        }
        case 5: {

            // method 'ListFilterFields'

            LOG_DEBUG_STUB("process method '%s'", "ListFilterFields");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListFilterFields", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListFilterFieldsRequest > payload = ::boost::static_pointer_cast<ListFilterFieldsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<PhonebookAccessStub*>(getStub())->onListFilterFieldsRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* PhonebookAccessStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.PhonebookAccess\">\n"
            "      <method name=\"Select\">\n"
            "        <arg direction=\"in\" name=\"location\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"phonebook\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"PullAll\">\n"
            "        <arg direction=\"in\" name=\"targetfile\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"transfer\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"Pull\">\n"
            "        <arg direction=\"in\" name=\"vcard\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"targetfile\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"transfer\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"List\">\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"vcard_listing\" type=\"a(ss)\"/>\n"
            "      </method>\n"
            "      <method name=\"GetSize\">\n"
            "        <arg direction=\"out\" name=\"size\" type=\"q\"/>\n"
            "      </method>\n"
            "      <method name=\"ListFilterFields\">\n"
            "        <arg direction=\"out\" name=\"filterFields\" type=\"as\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void PhonebookAccessStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<PhonebookAccessStub*>(getStub()))->onGetAll (properties);
}

void PhonebookAccessStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void PhonebookAccessStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

PhonebookAccessStub::PhonebookAccessStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PhonebookAccessStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PhonebookAccessStub::PhonebookAccessStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new PhonebookAccessStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

PhonebookAccessStub::~PhonebookAccessStub() {
    delete _stubDelegate;
}

void  PhonebookAccessStub::sendSelectResponse (act_t act) {
    SelectResponse* payload = new SelectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Select", SelectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Select", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendSelectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SelectError* payload = new SelectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Select", SelectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Select", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendPullAllResponse (const ::std::string& transfer, act_t act) {
    PullAllResponse* payload = new PullAllResponse(transfer);
    DBUS_MESSAGE_REPLY(dbusMessage, "PullAll", PullAllResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PullAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendPullAllError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PullAllError* payload = new PullAllError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PullAll", PullAllError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PullAll", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendPullResponse (const ::std::string& transfer, act_t act) {
    PullResponse* payload = new PullResponse(transfer);
    DBUS_MESSAGE_REPLY(dbusMessage, "Pull", PullResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Pull", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendPullError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PullError* payload = new PullError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Pull", PullError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Pull", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendListResponse (const ::std::vector< ListResponseVcard_listingStruct >& vcard_listing, act_t act) {
    ListResponse* payload = new ListResponse(vcard_listing);
    DBUS_MESSAGE_REPLY(dbusMessage, "List", ListResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "List", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendListError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListError* payload = new ListError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "List", ListError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "List", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendGetSizeResponse (uint16 size, act_t act) {
    GetSizeResponse* payload = new GetSizeResponse(size);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetSize", GetSizeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetSize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendGetSizeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetSizeError* payload = new GetSizeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetSize", GetSizeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetSize", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendListFilterFieldsResponse (const ::std::vector< ::std::string >& filterFields, act_t act) {
    ListFilterFieldsResponse* payload = new ListFilterFieldsResponse(filterFields);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListFilterFields", ListFilterFieldsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListFilterFields", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  PhonebookAccessStub::sendListFilterFieldsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListFilterFieldsError* payload = new ListFilterFieldsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListFilterFields", ListFilterFieldsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListFilterFields", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void PhonebookAccessStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace PhonebookAccess
} // namespace obex
} // namespace bluez
} // namespace org
